/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Context;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class Gt06ProtocolEncoder
extends BaseProtocolEncoder {
    private ByteBuf encodeContent(long deviceId, String content) {
        boolean language = Context.getIdentityManager().lookupAttributeBoolean(deviceId, "gt06.language", false, true);
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(120);
        buf.writeByte(120);
        buf.writeByte(6 + content.length() + 2 + 2 + (language ? 2 : 0));
        buf.writeByte(128);
        buf.writeByte(4 + content.length());
        buf.writeInt(0);
        buf.writeBytes(content.getBytes(StandardCharsets.US_ASCII));
        if (language) {
            buf.writeShort(2);
        }
        buf.writeShort(0);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_X25, buf.nioBuffer(2, buf.writerIndex() - 2)));
        buf.writeByte(13);
        buf.writeByte(10);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = Context.getIdentityManager().lookupAttributeBoolean(command.getDeviceId(), "gt06.alternative", false, true);
        switch (command.getType()) {
            case "engineStop": {
                return this.encodeContent(command.getDeviceId(), alternative ? "DYD,123456#" : "Relay,1#");
            }
            case "engineResume": {
                return this.encodeContent(command.getDeviceId(), alternative ? "HFYD,123456#" : "Relay,0#");
            }
            case "custom": {
                return this.encodeContent(command.getDeviceId(), command.getString("data"));
            }
        }
        return null;
    }
}

