/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class Gps056ProtocolDecoder
extends BaseProtocolDecoder {
    public Gps056ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static void sendResponse(Channel channel, String type, String imei, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            String header = "*" + type + imei;
            response.writeBytes(header.getBytes(StandardCharsets.US_ASCII));
            if (content != null) {
                response.writeBytes(content);
            }
            response.writeByte(35);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private static double decodeCoordinate(ByteBuf buf) {
        double degrees = buf.getUnsignedShort(buf.readerIndex()) / 100;
        double minutes = (double)(buf.readUnsignedShort() % 100) + (double)buf.readUnsignedShort() * 1.0E-4;
        degrees += minutes / 60.0;
        byte hemisphere = buf.readByte();
        if (hemisphere == 83 || hemisphere == 87) {
            degrees = -degrees;
        }
        return degrees;
    }

    private static void decodeStatus(ByteBuf buf, Position position) {
        position.set("input", buf.readUnsignedByte());
        position.set("output", buf.readUnsignedByte());
        position.set("adc1", (double)buf.readShortLE() * 5.06);
        position.set("sat", buf.readUnsignedByte());
        position.set("rssi", buf.readUnsignedByte());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.skipBytes(2);
        String type = buf.readSlice(7).toString(StandardCharsets.US_ASCII);
        String imei = buf.readSlice(15).toString(StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        if (type.startsWith("LOGN")) {
            ByteBuf content = Unpooled.copiedBuffer((CharSequence)"1", (Charset)StandardCharsets.US_ASCII);
            try {
                Gps056ProtocolDecoder.sendResponse(channel, "LGSA" + type.substring(4), imei, content);
            }
            finally {
                content.release();
            }
        } else {
            if (type.startsWith("GPSL")) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                DateBuilder dateBuilder = new DateBuilder().setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                position.setValid(true);
                position.setTime(dateBuilder.getDate());
                position.setLatitude(Gps056ProtocolDecoder.decodeCoordinate(buf));
                position.setLongitude(Gps056ProtocolDecoder.decodeCoordinate(buf));
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                position.setCourse(buf.readUnsignedShort());
                Gps056ProtocolDecoder.decodeStatus(buf, position);
                Gps056ProtocolDecoder.sendResponse(channel, "GPSA" + type.substring(4), imei, buf.readSlice(2));
                return position;
            }
            if (type.startsWith("SYNC")) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                Gps056ProtocolDecoder.decodeStatus(buf, position);
                Gps056ProtocolDecoder.sendResponse(channel, "SYSA" + type.substring(4), imei, null);
                return position;
            }
        }
        return null;
    }
}

