/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class CellocatorProtocolDecoder
extends BaseProtocolDecoder {
    static final int MSG_CLIENT_STATUS = 0;
    static final int MSG_CLIENT_PROGRAMMING = 3;
    static final int MSG_CLIENT_SERIAL_LOG = 7;
    static final int MSG_CLIENT_SERIAL = 8;
    static final int MSG_CLIENT_MODULAR = 9;
    public static final int MSG_SERVER_ACKNOWLEDGE = 4;
    private byte commandCount;

    public CellocatorProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendReply(Channel channel, SocketAddress remoteAddress, long deviceId, byte packetNumber) {
        if (channel != null) {
            ByteBuf reply = Unpooled.buffer((int)28);
            reply.writeByte(77);
            reply.writeByte(67);
            reply.writeByte(71);
            reply.writeByte(80);
            reply.writeByte(4);
            reply.writeIntLE((int)deviceId);
            byte by = this.commandCount;
            this.commandCount = (byte)(by + 1);
            reply.writeByte((int)by);
            reply.writeIntLE(0);
            reply.writeByte(0);
            reply.writeByte((int)packetNumber);
            reply.writeZero(11);
            int checksum = 0;
            for (int i = 4; i < 27; ++i) {
                checksum = (byte)(checksum + reply.getByte(i));
            }
            reply.writeByte(checksum);
            channel.writeAndFlush((Object)new NetworkMessage(reply, remoteAddress));
        }
    }

    private String decodeAlarm(short reason) {
        switch (reason) {
            case 70: {
                return "sos";
            }
            case 80: {
                return "powerCut";
            }
            case 81: {
                return "lowPower";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        boolean alternative = buf.getByte(buf.readerIndex() + 3) != 80;
        buf.skipBytes(4);
        short type = buf.readUnsignedByte();
        long deviceUniqueId = buf.readUnsignedIntLE();
        if (type != 8) {
            buf.readUnsignedShortLE();
        }
        byte packetNumber = buf.readByte();
        this.sendReply(channel, remoteAddress, deviceUniqueId, packetNumber);
        if (type == 0) {
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceUniqueId));
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("versionHw", buf.readUnsignedByte());
            position.set("versionFw", buf.readUnsignedByte());
            buf.readUnsignedByte();
            position.set("status", buf.readUnsignedByte() & 0xF);
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
            position.set("mode", buf.readUnsignedByte());
            position.set("input", buf.readUnsignedIntLE());
            if (alternative) {
                buf.readUnsignedByte();
                position.set("adc1", buf.readUnsignedShortLE());
                position.set("adc2", buf.readUnsignedShortLE());
            } else {
                buf.readUnsignedByte();
                position.set("adc1", buf.readUnsignedIntLE());
            }
            position.set("odometer", buf.readUnsignedMediumLE());
            buf.skipBytes(6);
            buf.readUnsignedShortLE();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            position.set("sat", buf.readUnsignedByte());
            position.setValid(true);
            if (alternative) {
                position.setLongitude((double)buf.readIntLE() / 1.0E7);
                position.setLatitude((double)buf.readIntLE() / 1.0E7);
            } else {
                position.setLongitude((double)buf.readIntLE() / Math.PI * 180.0 / 1.0E8);
                position.setLatitude((double)buf.readIntLE() / Math.PI * 180.0 / 1.0E8);
            }
            position.setAltitude((double)buf.readIntLE() * 0.01);
            if (alternative) {
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedIntLE()));
                position.setCourse((double)buf.readUnsignedShortLE() / 1000.0);
            } else {
                position.setSpeed(UnitsConverter.knotsFromMps((double)buf.readUnsignedIntLE() * 0.01));
                position.setCourse((double)buf.readUnsignedShortLE() / Math.PI * 180.0 / 1000.0);
            }
            DateBuilder dateBuilder = new DateBuilder().setTimeReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedShortLE());
            position.setTime(dateBuilder.getDate());
            return position;
        }
        return null;
    }
}

