/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class AutoFonProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 16;
    public static final int MSG_LOCATION = 17;
    public static final int MSG_HISTORY = 18;
    public static final int MSG_45_LOGIN = 65;
    public static final int MSG_45_LOCATION = 2;

    public AutoFonProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double convertCoordinate(int raw) {
        int degrees = raw / 1000000;
        double minutes = (double)(raw % 1000000) / 10000.0;
        return (double)degrees + minutes / 60.0;
    }

    private static double convertCoordinate(short degrees, int minutes) {
        double value = (double)degrees + (double)BitUtil.from(minutes, 4) / 600000.0;
        if (BitUtil.check(minutes, 0)) {
            return value;
        }
        return -value;
    }

    private Position decodePosition(DeviceSession deviceSession, ByteBuf buf, boolean history) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (!history) {
            buf.readUnsignedByte();
            buf.skipBytes(8);
        }
        position.set("status", buf.readUnsignedByte());
        if (!history) {
            buf.readUnsignedShort();
        }
        position.set("battery", buf.readUnsignedByte());
        buf.skipBytes(6);
        if (!history) {
            for (int i = 0; i < 2; ++i) {
                buf.skipBytes(5);
                buf.readUnsignedShort();
                buf.skipBytes(5);
            }
        }
        position.set("temp1", buf.readByte());
        short rssi = buf.readUnsignedByte();
        CellTower cellTower = CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), rssi);
        position.setNetwork(new Network(cellTower));
        short valid = buf.readUnsignedByte();
        position.setValid((valid & 0xC0) != 0);
        position.set("sat", valid & 0x3F);
        DateBuilder dateBuilder = new DateBuilder().setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        position.setLatitude(AutoFonProtocolDecoder.convertCoordinate(buf.readInt()));
        position.setLongitude(AutoFonProtocolDecoder.convertCoordinate(buf.readInt()));
        position.setAltitude(buf.readShort());
        position.setSpeed(buf.readUnsignedByte());
        position.setCourse((double)buf.readUnsignedByte() * 2.0);
        position.set("hdop", buf.readUnsignedShort());
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short type = buf.readUnsignedByte();
        if (type == 16 || type == 65) {
            String imei;
            DeviceSession deviceSession;
            if (type == 16) {
                buf.readUnsignedByte();
                buf.readUnsignedByte();
            }
            if ((deviceSession = this.getDeviceSession(channel, remoteAddress, imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1))) != null && channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeBytes("resp_crc=".getBytes(StandardCharsets.US_ASCII));
                response.writeByte((int)buf.getByte(buf.writerIndex() - 1));
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (type == 17) {
            return this.decodePosition(deviceSession, buf, false);
        }
        if (type == 18) {
            int count = buf.readUnsignedByte() & 0xF;
            buf.readUnsignedShort();
            LinkedList<Position> positions = new LinkedList<Position>();
            for (int i = 0; i < count; ++i) {
                positions.add(this.decodePosition(deviceSession, buf, true));
            }
            return positions;
        }
        if (type == 2) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            short status = buf.readUnsignedByte();
            if (BitUtil.check(status, 7)) {
                position.set("alarm", "general");
            }
            position.set("battery", BitUtil.to(status, 7));
            buf.skipBytes(2);
            position.set("temp1", buf.readByte());
            buf.skipBytes(2);
            buf.readByte();
            buf.readByte();
            buf.skipBytes(6);
            short valid = buf.readUnsignedByte();
            position.setValid(BitUtil.from(valid, 6) != 0);
            position.set("sat", BitUtil.from(valid, 6));
            int time = buf.readUnsignedMedium();
            int date = buf.readUnsignedMedium();
            DateBuilder dateBuilder = new DateBuilder().setTime(time / 10000, time / 100 % 100, time % 100).setDateReverse(date / 10000, date / 100 % 100, date % 100);
            position.setTime(dateBuilder.getDate());
            position.setLatitude(AutoFonProtocolDecoder.convertCoordinate(buf.readUnsignedByte(), buf.readUnsignedMedium()));
            position.setLongitude(AutoFonProtocolDecoder.convertCoordinate(buf.readUnsignedByte(), buf.readUnsignedMedium()));
            position.setSpeed(buf.readUnsignedByte());
            position.setCourse(buf.readUnsignedShort());
            return position;
        }
        return null;
    }
}

