/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import org.traccar.Config;
import org.traccar.model.ExtendedModel;

public class PropertiesProvider {
    private Config config;
    private ExtendedModel extendedModel;

    public PropertiesProvider(Config config) {
        this.config = config;
    }

    public PropertiesProvider(ExtendedModel extendedModel) {
        this.extendedModel = extendedModel;
    }

    public String getString(String key) {
        if (this.config != null) {
            return this.config.getString(key);
        }
        return this.extendedModel.getString(key);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public int getInteger(String key, int defaultValue) {
        if (this.config != null) {
            return this.config.getInteger(key, defaultValue);
        }
        Object result = this.extendedModel.getAttributes().get(key);
        if (result != null) {
            return result instanceof String ? Integer.parseInt((String)result) : (Integer)result;
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        if (this.config != null) {
            if (this.config.hasKey(key)) {
                return this.config.getBoolean(key);
            }
            return null;
        }
        Object result = this.extendedModel.getAttributes().get(key);
        if (result != null) {
            return result instanceof String ? Boolean.valueOf((String)result) : (Boolean)result;
        }
        return null;
    }
}

