/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class TimedStateBoolean {
    private AtomicBoolean value;
    private long valueTime;
    private final Boolean expectedValue;

    public TimedStateBoolean(boolean initialValue) {
        this.value = new AtomicBoolean(initialValue);
        this.valueTime = System.currentTimeMillis();
        this.expectedValue = null;
    }

    public TimedStateBoolean(boolean initialValue, boolean expectedValue) {
        this.value = new AtomicBoolean(initialValue);
        this.valueTime = System.currentTimeMillis();
        this.expectedValue = expectedValue;
    }

    public boolean getExpected() {
        if (this.expectedValue == null) {
            return this.get();
        }
        return this.expectedValue;
    }

    public boolean isExpected() {
        if (this.expectedValue == null) {
            return true;
        }
        return this.expectedValue.booleanValue() == this.get();
    }

    public boolean getAndSet(boolean newValue) {
        boolean oldValue = this.value.getAndSet(newValue);
        if (oldValue != newValue) {
            this.valueTime = System.currentTimeMillis();
        }
        return oldValue;
    }

    public void set(boolean newValue) {
        this.getAndSet(newValue);
    }

    public boolean get() {
        return this.value.get();
    }

    public long getValueTimeMillis() {
        return this.valueTime;
    }

    public DateTime getValueDateTime() {
        return new DateTime(this.valueTime);
    }

    public Period getValueDuration() {
        long now = System.currentTimeMillis();
        return new Period(now - this.valueTime);
    }

    public long getValueDurationInMills() {
        return System.currentTimeMillis() - this.valueTime;
    }

    public String toString() {
        return this.value.toString();
    }
}

