/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.simulator;

import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.simulator.SmppSimulatorPduProcessor;
import com.cloudhopper.smpp.simulator.SmppSimulatorSessionHandler;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoder;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoderContext;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SmppSimulatorServerHandler
extends SimpleChannelInboundHandler<Pdu> {
    private static final Logger logger = LoggerFactory.getLogger(SmppSimulatorServerHandler.class);
    private final ChannelGroup sessionChannels;
    private final BlockingQueue<SmppSimulatorSessionHandler> sessionQueue;
    private SmppSimulatorPduProcessor defaultPduProcessor;

    public SmppSimulatorServerHandler(ChannelGroup sessionChannels) {
        this.sessionChannels = sessionChannels;
        this.sessionQueue = new LinkedBlockingQueue<SmppSimulatorSessionHandler>();
    }

    public SmppSimulatorPduProcessor getDefaultPduProcessor() {
        return this.defaultPduProcessor;
    }

    public void setDefaultPduProcessor(SmppSimulatorPduProcessor pduProcessor) {
        this.defaultPduProcessor = pduProcessor;
    }

    public BlockingQueue<SmppSimulatorSessionHandler> getSessionQueue() {
        return this.sessionQueue;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Pdu msg) throws Exception {
        logger.info("Read message {} from channel {}", (Object)msg.toString(), (Object)ctx.channel());
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        logger.info("childChannelRegistered {}", (Object)ctx.channel());
        DefaultPduTranscoderContext context = new DefaultPduTranscoderContext();
        DefaultPduTranscoder transcoder = new DefaultPduTranscoder(context);
        SmppSimulatorSessionHandler session = new SmppSimulatorSessionHandler(ctx.channel(), transcoder);
        ctx.channel().pipeline().addLast("session", (ChannelHandler)session);
        session.setPduProcessor(this.defaultPduProcessor);
        this.sessionChannels.add((Object)ctx.channel());
        this.sessionQueue.add(session);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.info("childChannelClosed {}", (Object)ctx.channel());
        super.channelInactive(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.info("childChannelOpened {}", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("Exception triggered in upstream ChannelHandler: {}", cause);
    }
}

