/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.solr.common.util.SuppressForbidden;

@Documented
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface LogLevel {
    public String value();

    @SuppressForbidden(reason="Specific to Log4J2")
    public static class Configurer {
        private static Map<String, Level> parseFrom(String input) {
            HashMap<String, Level> testlevels = new HashMap<String, Level>();
            for (String levelSetting : input.split(";")) {
                String[] parts = levelSetting.split("=");
                testlevels.put(parts[0], Configurer.parseLevel(parts[1]));
            }
            return testlevels;
        }

        private static Level parseLevel(String level) {
            return level == null ? null : Level.toLevel((String)level);
        }

        public static void restoreLogLevels(Map<String, Level> savedLogLevels) {
            Configurer.setLogLevels(savedLogLevels);
        }

        public static Map<String, Level> setLevels(String value) {
            return Configurer.setLogLevels(Configurer.parseFrom(value));
        }

        private static Map<String, Level> setLogLevels(Map<String, Level> logLevels) {
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            HashMap<String, Level> oldLevels = new HashMap<String, Level>();
            logLevels.forEach((loggerName, level) -> {
                LoggerConfig logConfig = config.getLoggerConfig(loggerName);
                oldLevels.put((String)loggerName, logConfig.getLevel());
                if (loggerName.equals(logConfig.getName())) {
                    logConfig.setLevel(level);
                } else {
                    LoggerConfig loggerConfig = new LoggerConfig(loggerName, level, true);
                    loggerConfig.setLevel(level);
                    config.addLogger(loggerName, loggerConfig);
                }
            });
            ctx.updateLoggers();
            return oldLevels;
        }
    }
}

