/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.blocktreeords.FSTOrdsOutputs;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public final class OrdsBlockTreeTermsWriter
extends FieldsConsumer {
    static final FSTOrdsOutputs FST_OUTPUTS = new FSTOrdsOutputs();
    static final FSTOrdsOutputs.Output NO_OUTPUT = FST_OUTPUTS.getNoOutput();
    public static final int DEFAULT_MIN_BLOCK_SIZE = 25;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 48;
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tio";
    static final String TERMS_CODEC_NAME = "OrdsBlockTreeTerms";
    public static final int VERSION_START = 1;
    public static final int VERSION_CURRENT = 1;
    static final String TERMS_INDEX_EXTENSION = "tipo";
    static final String TERMS_INDEX_CODEC_NAME = "OrdsBlockTreeIndex";
    private final IndexOutput out;
    private final IndexOutput indexOut;
    final int maxDoc;
    final int minItemsInBlock;
    final int maxItemsInBlock;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    private final List<FieldMetaData> fields;
    private final RAMOutputStream scratchBytes;
    private final IntsRefBuilder scratchIntsRef;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrdsBlockTreeTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock) throws IOException {
        IndexOutput indexOut;
        block3: {
            this.fields = new ArrayList<FieldMetaData>();
            this.scratchBytes = new RAMOutputStream();
            this.scratchIntsRef = new IntsRefBuilder();
            BlockTreeTermsWriter.validateSettings((int)minItemsInBlock, (int)maxItemsInBlock);
            this.maxDoc = state.segmentInfo.maxDoc();
            String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
            this.out = state.directory.createOutput(termsFileName, state.context);
            boolean success = false;
            indexOut = null;
            try {
                this.fieldInfos = state.fieldInfos;
                this.minItemsInBlock = minItemsInBlock;
                this.maxItemsInBlock = maxItemsInBlock;
                CodecUtil.writeIndexHeader((DataOutput)this.out, (String)TERMS_CODEC_NAME, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                String termsIndexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
                indexOut = state.directory.createOutput(termsIndexFileName, state.context);
                CodecUtil.writeIndexHeader((DataOutput)indexOut, (String)TERMS_INDEX_CODEC_NAME, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                this.postingsWriter = postingsWriter;
                postingsWriter.init(this.out, state);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, indexOut});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, indexOut});
        }
        this.indexOut = indexOut;
    }

    public void write(Fields fields, NormsProducer norms) throws IOException {
        String lastField = null;
        for (String field : fields) {
            BytesRef term;
            assert (lastField == null || lastField.compareTo(field) < 0);
            lastField = field;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(this.fieldInfos.fieldInfo(field));
            while ((term = termsEnum.next()) != null) {
                termsWriter.write(term, termsEnum, norms);
            }
            termsWriter.finish();
        }
    }

    static long encodeOutput(long fp, boolean hasTerms, boolean isFloor) {
        assert (fp < 0x4000000000000000L);
        return fp << 2 | (long)(hasTerms ? 2 : 0) | (long)(isFloor ? 1 : 0);
    }

    static String brToString(BytesRef b) {
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    static String brToString(byte[] b) {
        return OrdsBlockTreeTermsWriter.brToString(new BytesRef(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                boolean success = false;
                try {
                    long dirStart = this.out.getFilePointer();
                    long indexDirStart = this.indexOut.getFilePointer();
                    this.out.writeVInt(this.fields.size());
                    for (FieldMetaData field : this.fields) {
                        this.out.writeVInt(field.fieldInfo.number);
                        assert (field.numTerms > 0L);
                        this.out.writeVLong(field.numTerms);
                        this.out.writeVInt(field.rootCode.bytes.length);
                        this.out.writeBytes(field.rootCode.bytes.bytes, field.rootCode.bytes.offset, field.rootCode.bytes.length);
                        if (field.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                            this.out.writeVLong(field.sumTotalTermFreq);
                        }
                        this.out.writeVLong(field.sumDocFreq);
                        this.out.writeVInt(field.docCount);
                        this.out.writeVInt(field.longsSize);
                        this.indexOut.writeVLong(field.indexStartFP);
                        OrdsBlockTreeTermsWriter.writeBytesRef(this.out, field.minTerm);
                        OrdsBlockTreeTermsWriter.writeBytesRef(this.out, field.maxTerm);
                    }
                    this.out.writeLong(dirStart);
                    CodecUtil.writeFooter((IndexOutput)this.out);
                    this.indexOut.writeLong(indexDirStart);
                    CodecUtil.writeFooter((IndexOutput)this.indexOut);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
        }
    }

    private static void writeBytesRef(IndexOutput out, BytesRef bytes) throws IOException {
        out.writeVInt(bytes.length);
        out.writeBytes(bytes.bytes, bytes.offset, bytes.length);
    }

    class TermsWriter {
        private final FieldInfo fieldInfo;
        private final int longsSize;
        private long numTerms;
        final FixedBitSet docsSeen;
        long sumTotalTermFreq;
        long sumDocFreq;
        long indexStartFP;
        private final BytesRefBuilder lastTerm = new BytesRefBuilder();
        private int[] prefixStarts = new int[8];
        private final long[] longs;
        private final List<PendingEntry> pending = new ArrayList<PendingEntry>();
        private final List<PendingBlock> newBlocks = new ArrayList<PendingBlock>();
        private PendingTerm firstPendingTerm;
        private PendingTerm lastPendingTerm;
        private final RAMOutputStream suffixWriter = new RAMOutputStream();
        private final RAMOutputStream statsWriter = new RAMOutputStream();
        private final RAMOutputStream metaWriter = new RAMOutputStream();
        private final RAMOutputStream bytesWriter = new RAMOutputStream();

        void writeBlocks(int prefixLength, int count) throws IOException {
            assert (count > 0);
            assert (prefixLength > 0 || count == this.pending.size());
            int lastSuffixLeadLabel = -1;
            boolean hasTerms = false;
            boolean hasSubBlocks = false;
            int start = this.pending.size() - count;
            int end = this.pending.size();
            int nextBlockStart = start;
            int nextFloorLeadLabel = -1;
            for (int i = start; i < end; ++i) {
                int suffixLeadLabel;
                PendingEntry ent = this.pending.get(i);
                if (ent.isTerm) {
                    PendingTerm term = (PendingTerm)ent;
                    if (term.termBytes.length == prefixLength) {
                        assert (lastSuffixLeadLabel == -1);
                        suffixLeadLabel = -1;
                    } else {
                        suffixLeadLabel = term.termBytes[prefixLength] & 0xFF;
                    }
                } else {
                    PendingBlock block = (PendingBlock)ent;
                    assert (block.prefix.length > prefixLength);
                    suffixLeadLabel = block.prefix.bytes[block.prefix.offset + prefixLength] & 0xFF;
                }
                if (suffixLeadLabel != lastSuffixLeadLabel) {
                    int itemsInBlock = i - nextBlockStart;
                    if (itemsInBlock >= OrdsBlockTreeTermsWriter.this.minItemsInBlock && end - nextBlockStart > OrdsBlockTreeTermsWriter.this.maxItemsInBlock) {
                        boolean isFloor = itemsInBlock < count;
                        this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, i, hasTerms, hasSubBlocks));
                        hasTerms = false;
                        hasSubBlocks = false;
                        nextFloorLeadLabel = suffixLeadLabel;
                        nextBlockStart = i;
                    }
                    lastSuffixLeadLabel = suffixLeadLabel;
                }
                if (ent.isTerm) {
                    hasTerms = true;
                    continue;
                }
                hasSubBlocks = true;
            }
            if (nextBlockStart < end) {
                int itemsInBlock = end - nextBlockStart;
                boolean isFloor = itemsInBlock < count;
                this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, end, hasTerms, hasSubBlocks));
            }
            assert (!this.newBlocks.isEmpty());
            PendingBlock firstBlock = this.newBlocks.get(0);
            assert (firstBlock.isFloor || this.newBlocks.size() == 1);
            firstBlock.compileIndex(this.newBlocks, OrdsBlockTreeTermsWriter.this.scratchBytes, OrdsBlockTreeTermsWriter.this.scratchIntsRef);
            this.pending.subList(this.pending.size() - count, this.pending.size()).clear();
            this.pending.add(firstBlock);
            this.newBlocks.clear();
        }

        private PendingBlock writeBlock(int prefixLength, boolean isFloor, int floorLeadLabel, int start, int end, boolean hasTerms, boolean hasSubBlocks) throws IOException {
            long totalTermCount;
            ArrayList<SubIndex> subIndices;
            assert (end > start);
            long startFP = OrdsBlockTreeTermsWriter.this.out.getFilePointer();
            boolean hasFloorLeadLabel = isFloor && floorLeadLabel != -1;
            BytesRef prefix = new BytesRef(prefixLength + (hasFloorLeadLabel ? 1 : 0));
            System.arraycopy(this.lastTerm.bytes(), 0, prefix.bytes, 0, prefixLength);
            prefix.length = prefixLength;
            int numEntries = end - start;
            int code = numEntries << 1;
            if (end == this.pending.size()) {
                code |= 1;
            }
            OrdsBlockTreeTermsWriter.this.out.writeVInt(code);
            boolean isLeafBlock = !hasSubBlocks;
            boolean absolute = true;
            if (isLeafBlock) {
                subIndices = null;
                for (int i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    assert (ent.isTerm) : "i=" + i;
                    PendingTerm term = (PendingTerm)ent;
                    assert (StringHelper.startsWith((byte[])term.termBytes, (BytesRef)prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                    BlockTermState state = term.state;
                    int suffix = term.termBytes.length - prefixLength;
                    this.suffixWriter.writeVInt(suffix);
                    this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                    this.statsWriter.writeVInt(state.docFreq);
                    if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                        assert (state.totalTermFreq >= (long)state.docFreq) : state.totalTermFreq + " vs " + state.docFreq;
                        this.statsWriter.writeVLong(state.totalTermFreq - (long)state.docFreq);
                    }
                    OrdsBlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.longs, (DataOutput)this.bytesWriter, this.fieldInfo, state, absolute);
                    for (int pos = 0; pos < this.longsSize; ++pos) {
                        assert (this.longs[pos] >= 0L);
                        this.metaWriter.writeVLong(this.longs[pos]);
                    }
                    this.bytesWriter.writeTo((DataOutput)this.metaWriter);
                    this.bytesWriter.reset();
                    absolute = false;
                }
                totalTermCount = end - start;
            } else {
                subIndices = new ArrayList<SubIndex>();
                totalTermCount = 0L;
                for (int i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    if (ent.isTerm) {
                        PendingTerm term = (PendingTerm)ent;
                        assert (StringHelper.startsWith((byte[])term.termBytes, (BytesRef)prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                        BlockTermState state = term.state;
                        int suffix = term.termBytes.length - prefixLength;
                        this.suffixWriter.writeVInt(suffix << 1);
                        this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                        assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                        this.statsWriter.writeVInt(state.docFreq);
                        if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                            assert (state.totalTermFreq >= (long)state.docFreq);
                            this.statsWriter.writeVLong(state.totalTermFreq - (long)state.docFreq);
                        }
                        OrdsBlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.longs, (DataOutput)this.bytesWriter, this.fieldInfo, state, absolute);
                        for (int pos = 0; pos < this.longsSize; ++pos) {
                            assert (this.longs[pos] >= 0L);
                            this.metaWriter.writeVLong(this.longs[pos]);
                        }
                        this.bytesWriter.writeTo((DataOutput)this.metaWriter);
                        this.bytesWriter.reset();
                        absolute = false;
                        ++totalTermCount;
                        continue;
                    }
                    PendingBlock block = (PendingBlock)ent;
                    assert (StringHelper.startsWith((BytesRef)block.prefix, (BytesRef)prefix));
                    int suffix = block.prefix.length - prefixLength;
                    assert (suffix > 0);
                    this.suffixWriter.writeVInt(suffix << 1 | 1);
                    this.suffixWriter.writeBytes(block.prefix.bytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (block.prefix.bytes[prefixLength] & 0xFF) >= floorLeadLabel);
                    assert (block.fp < startFP);
                    this.suffixWriter.writeVLong(startFP - block.fp);
                    this.suffixWriter.writeVLong(block.totFloorTermCount);
                    subIndices.add(new SubIndex(block.index, totalTermCount));
                    totalTermCount += block.totFloorTermCount;
                }
                assert (subIndices.size() != 0);
            }
            OrdsBlockTreeTermsWriter.this.out.writeVInt((int)(this.suffixWriter.getFilePointer() << 1) | (isLeafBlock ? 1 : 0));
            this.suffixWriter.writeTo((DataOutput)OrdsBlockTreeTermsWriter.this.out);
            this.suffixWriter.reset();
            OrdsBlockTreeTermsWriter.this.out.writeVInt((int)this.statsWriter.getFilePointer());
            this.statsWriter.writeTo((DataOutput)OrdsBlockTreeTermsWriter.this.out);
            this.statsWriter.reset();
            OrdsBlockTreeTermsWriter.this.out.writeVInt((int)this.metaWriter.getFilePointer());
            this.metaWriter.writeTo((DataOutput)OrdsBlockTreeTermsWriter.this.out);
            this.metaWriter.reset();
            if (hasFloorLeadLabel) {
                prefix.bytes[prefix.length++] = (byte)floorLeadLabel;
            }
            return new PendingBlock(prefix, startFP, hasTerms, totalTermCount, isFloor, floorLeadLabel, subIndices);
        }

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.docsSeen = new FixedBitSet(OrdsBlockTreeTermsWriter.this.maxDoc);
            this.longsSize = OrdsBlockTreeTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.longs = new long[this.longsSize];
        }

        public void write(BytesRef text, TermsEnum termsEnum, NormsProducer norms) throws IOException {
            BlockTermState state = OrdsBlockTreeTermsWriter.this.postingsWriter.writeTerm(text, termsEnum, this.docsSeen, norms);
            if (state != null) {
                assert (state.docFreq != 0);
                assert (this.fieldInfo.getIndexOptions() == IndexOptions.DOCS || state.totalTermFreq >= (long)state.docFreq) : "postingsWriter=" + OrdsBlockTreeTermsWriter.this.postingsWriter;
                this.sumDocFreq += (long)state.docFreq;
                this.sumTotalTermFreq += state.totalTermFreq;
                this.pushTerm(text);
                PendingTerm term = new PendingTerm(BytesRef.deepCopyOf((BytesRef)text), state);
                this.pending.add(term);
                ++this.numTerms;
                if (this.firstPendingTerm == null) {
                    this.firstPendingTerm = term;
                }
                this.lastPendingTerm = term;
            }
        }

        private void pushTerm(BytesRef text) throws IOException {
            int i;
            int pos;
            int limit = Math.min(this.lastTerm.length(), text.length);
            for (pos = 0; pos < limit && this.lastTerm.byteAt(pos) == text.bytes[text.offset + pos]; ++pos) {
            }
            for (i = this.lastTerm.length() - 1; i >= pos; --i) {
                int prefixTopSize = this.pending.size() - this.prefixStarts[i];
                if (prefixTopSize < OrdsBlockTreeTermsWriter.this.minItemsInBlock) continue;
                this.writeBlocks(i + 1, prefixTopSize);
                int n = i;
                this.prefixStarts[n] = this.prefixStarts[n] - (prefixTopSize - 1);
            }
            if (this.prefixStarts.length < text.length) {
                this.prefixStarts = ArrayUtil.grow((int[])this.prefixStarts, (int)text.length);
            }
            for (i = pos; i < text.length; ++i) {
                this.prefixStarts[i] = this.pending.size();
            }
            this.lastTerm.copyBytes(text);
        }

        public void finish() throws IOException {
            if (this.numTerms > 0L) {
                this.writeBlocks(0, this.pending.size());
                assert (this.pending.size() == 1 && !this.pending.get((int)0).isTerm) : "pending.size()=" + this.pending.size() + " pending=" + this.pending;
                PendingBlock root = (PendingBlock)this.pending.get(0);
                assert (root.prefix.length == 0);
                assert (root.index.getEmptyOutput() != null);
                this.indexStartFP = OrdsBlockTreeTermsWriter.this.indexOut.getFilePointer();
                root.index.save((DataOutput)OrdsBlockTreeTermsWriter.this.indexOut);
                assert (this.firstPendingTerm != null);
                BytesRef minTerm = new BytesRef(this.firstPendingTerm.termBytes);
                assert (this.lastPendingTerm != null);
                BytesRef maxTerm = new BytesRef(this.lastPendingTerm.termBytes);
                OrdsBlockTreeTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, (FSTOrdsOutputs.Output)((PendingBlock)this.pending.get((int)0)).index.getEmptyOutput(), this.numTerms, this.indexStartFP, this.sumTotalTermFreq, this.sumDocFreq, this.docsSeen.cardinality(), this.longsSize, minTerm, maxTerm));
            } else assert (this.docsSeen.cardinality() == 0);
        }
    }

    private static final class PendingBlock
    extends PendingEntry {
        public final BytesRef prefix;
        public final long fp;
        public FST<FSTOrdsOutputs.Output> index;
        public List<SubIndex> subIndices;
        public final boolean hasTerms;
        public final boolean isFloor;
        public final int floorLeadByte;
        public long totFloorTermCount;
        private final long totalTermCount;

        public PendingBlock(BytesRef prefix, long fp, boolean hasTerms, long totalTermCount, boolean isFloor, int floorLeadByte, List<SubIndex> subIndices) {
            super(false);
            this.prefix = prefix;
            this.fp = fp;
            this.hasTerms = hasTerms;
            this.totalTermCount = totalTermCount;
            assert (totalTermCount > 0L);
            this.isFloor = isFloor;
            this.floorLeadByte = floorLeadByte;
            this.subIndices = subIndices;
        }

        public String toString() {
            return "BLOCK: " + OrdsBlockTreeTermsWriter.brToString(this.prefix);
        }

        public void compileIndex(List<PendingBlock> blocks, RAMOutputStream scratchBytes, IntsRefBuilder scratchIntsRef) throws IOException {
            assert (this.isFloor && blocks.size() > 1 || !this.isFloor && blocks.size() == 1) : "isFloor=" + this.isFloor + " blocks=" + blocks;
            assert (this == blocks.get(0));
            assert (scratchBytes.getFilePointer() == 0L);
            long lastSumTotalTermCount = 0L;
            long sumTotalTermCount = this.totalTermCount;
            scratchBytes.writeVLong(OrdsBlockTreeTermsWriter.encodeOutput(this.fp, this.hasTerms, this.isFloor));
            if (this.isFloor) {
                scratchBytes.writeVInt(blocks.size() - 1);
                for (int i = 1; i < blocks.size(); ++i) {
                    PendingBlock sub = blocks.get(i);
                    assert (sub.floorLeadByte != -1);
                    scratchBytes.writeByte((byte)sub.floorLeadByte);
                    scratchBytes.writeVLong(sumTotalTermCount - lastSumTotalTermCount);
                    lastSumTotalTermCount = sumTotalTermCount;
                    sumTotalTermCount += sub.totalTermCount;
                    assert (sub.fp > this.fp);
                    scratchBytes.writeVLong(sub.fp - this.fp << 1 | (long)(sub.hasTerms ? 1 : 0));
                }
            }
            Builder indexBuilder = new Builder(FST.INPUT_TYPE.BYTE1, 0, 0, true, false, Integer.MAX_VALUE, (Outputs)FST_OUTPUTS, true, 15);
            byte[] bytes = new byte[(int)scratchBytes.getFilePointer()];
            assert (bytes.length > 0);
            scratchBytes.writeTo(bytes, 0);
            indexBuilder.add(Util.toIntsRef((BytesRef)this.prefix, (IntsRefBuilder)scratchIntsRef), (Object)FST_OUTPUTS.newOutput(new BytesRef(bytes, 0, bytes.length), 0L, Long.MAX_VALUE - (sumTotalTermCount - 1L)));
            scratchBytes.reset();
            long termOrdOffset = 0L;
            for (PendingBlock block : blocks) {
                if (block.subIndices != null) {
                    for (SubIndex subIndex : block.subIndices) {
                        this.append((Builder<FSTOrdsOutputs.Output>)indexBuilder, subIndex.index, termOrdOffset + subIndex.termOrdStart, scratchIntsRef);
                    }
                    block.subIndices = null;
                }
                termOrdOffset += block.totalTermCount;
            }
            this.totFloorTermCount = termOrdOffset;
            assert (sumTotalTermCount == this.totFloorTermCount);
            this.index = indexBuilder.finish();
            assert (this.subIndices == null);
        }

        private void append(Builder<FSTOrdsOutputs.Output> builder, FST<FSTOrdsOutputs.Output> subIndex, long termOrdOffset, IntsRefBuilder scratchIntsRef) throws IOException {
            BytesRefFSTEnum.InputOutput indexEnt;
            BytesRefFSTEnum subIndexEnum = new BytesRefFSTEnum(subIndex);
            while ((indexEnt = subIndexEnum.next()) != null) {
                FSTOrdsOutputs.Output output = (FSTOrdsOutputs.Output)indexEnt.output;
                FSTOrdsOutputs.Output newOutput = FST_OUTPUTS.newOutput(output.bytes, termOrdOffset + output.startOrd, output.endOrd - termOrdOffset);
                builder.add(Util.toIntsRef((BytesRef)indexEnt.input, (IntsRefBuilder)scratchIntsRef), (Object)newOutput);
            }
        }
    }

    private static final class SubIndex {
        public final FST<FSTOrdsOutputs.Output> index;
        public final long termOrdStart;

        public SubIndex(FST<FSTOrdsOutputs.Output> index, long termOrdStart) {
            this.index = index;
            this.termOrdStart = termOrdStart;
        }
    }

    private static final class PendingTerm
    extends PendingEntry {
        public final byte[] termBytes;
        public final BlockTermState state;

        public PendingTerm(BytesRef term, BlockTermState state) {
            super(true);
            this.termBytes = new byte[term.length];
            System.arraycopy(term.bytes, term.offset, this.termBytes, 0, term.length);
            this.state = state;
        }

        public String toString() {
            return OrdsBlockTreeTermsWriter.brToString(this.termBytes);
        }
    }

    private static class PendingEntry {
        public final boolean isTerm;

        protected PendingEntry(boolean isTerm) {
            this.isTerm = isTerm;
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final FSTOrdsOutputs.Output rootCode;
        public final long numTerms;
        public final long indexStartFP;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        private final int longsSize;
        public final BytesRef minTerm;
        public final BytesRef maxTerm;

        public FieldMetaData(FieldInfo fieldInfo, FSTOrdsOutputs.Output rootCode, long numTerms, long indexStartFP, long sumTotalTermFreq, long sumDocFreq, int docCount, int longsSize, BytesRef minTerm, BytesRef maxTerm) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            assert (rootCode != null) : "field=" + fieldInfo.name + " numTerms=" + numTerms;
            this.rootCode = rootCode;
            this.indexStartFP = indexStartFP;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.longsSize = longsSize;
            this.minTerm = minTerm;
            this.maxTerm = maxTerm;
        }
    }
}

