/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRedeclarationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.redeclaration", new Object[0]);
        if (string == null) {
            PyRedeclarationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyRedeclarationInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyRedeclarationInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyRedeclarationInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyRedeclarationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyRedeclarationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            if (!PyKnownDecoratorUtil.hasUnknownDecorator(node, this.myTypeEvalContext) && !PyKnownDecoratorUtil.hasRedeclarationDecorator(node, this.myTypeEvalContext)) {
                this.processElement(node);
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            if (node.isQualified() || "_".equals(node.getText())) {
                return;
            }
            ScopeOwner owner = ScopeUtil.getScopeOwner(node);
            if (owner instanceof PyFile || owner instanceof PyClass) {
                this.processElement(node);
            }
        }

        @Override
        public void visitPyClass(PyClass node) {
            if (!Visitor.isDecorated(node)) {
                this.processElement(node);
            }
        }

        private static boolean isDecorated(@NotNull PyDecoratable node) {
            PyDecorator[] decorators;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            boolean isDecorated = false;
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (decoratorList != null && (decorators = decoratorList.getDecorators()).length > 0) {
                isDecorated = true;
            }
            return isDecorated;
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            String name = element.getName();
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            if (owner != null && name != null) {
                int startInstruction;
                PyImportStatement importStatement;
                Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
                Object elementInControlFlow = element;
                if (element instanceof PyTargetExpression && (importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatement.class)) != null) {
                    elementInControlFlow = importStatement;
                }
                if ((startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)elementInControlFlow)) < 0) {
                    return;
                }
                Ref readElementRef = Ref.create(null);
                Ref writeElementRef = Ref.create(null);
                Ref underPossiblyFalseCondition = Ref.create((Object)false);
                ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])instructions, instruction -> {
                    ReadWriteInstruction rwInstruction;
                    if (element == null) {
                        Visitor.$$$reportNull$$$0(6);
                    }
                    if (instruction instanceof ReadWriteInstruction && instruction.num() != startInstruction && name.equals((rwInstruction = (ReadWriteInstruction)((Object)instruction)).getName())) {
                        PsiElement originalElement = rwInstruction.getElement();
                        if (originalElement != null) {
                            if (rwInstruction.getAccess().isReadAccess()) {
                                readElementRef.set((Object)originalElement);
                            }
                            if (rwInstruction.getAccess().isWriteAccess() && originalElement != element) {
                                if (PyiUtil.isOverload(originalElement, this.myTypeEvalContext)) {
                                    return ControlFlowUtil.Operation.NEXT;
                                }
                                if (!((Boolean)underPossiblyFalseCondition.get()).booleanValue()) {
                                    writeElementRef.set((Object)originalElement);
                                }
                            }
                        }
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                    if (Visitor.possiblyFalseCondition(instruction)) {
                        underPossiblyFalseCondition.set((Object)true);
                    }
                    return ControlFlowUtil.Operation.NEXT;
                });
                PsiElement writeElement = (PsiElement)writeElementRef.get();
                if (writeElement != null && readElementRef.get() == null) {
                    PsiElement identifier;
                    ArrayList<PyRenameElementQuickFix> quickFixes = new ArrayList<PyRenameElementQuickFix>();
                    if (Visitor.suggestRename(element, writeElement)) {
                        quickFixes.add(new PyRenameElementQuickFix((PsiElement)element));
                    }
                    this.registerProblem((PsiElement)((identifier = element.getNameIdentifier()) != null ? identifier : element), PyBundle.message("INSP.redeclared.name", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private static boolean possiblyFalseCondition(@NotNull Instruction instruction) {
            ConditionalInstruction conditionalInstruction;
            PsiElement condition;
            PsiElement element;
            if (instruction == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((element = instruction.getElement()) == null) {
                return false;
            }
            if (element instanceof PyTryPart || element instanceof PyExceptPart || element instanceof PyConditionalExpression) {
                return true;
            }
            if (element instanceof PyForStatement) {
                PyForPart forPart = ((PyForStatement)element).getForPart();
                return !PyEvaluator.evaluateAsBoolean(forPart.getSource(), false);
            }
            if (instruction instanceof ConditionalInstruction && (condition = (conditionalInstruction = (ConditionalInstruction)instruction).getCondition()) instanceof PyExpression) {
                return conditionalInstruction.getResult() ? !PyEvaluator.evaluateAsBoolean((PyExpression)condition, false) : PyEvaluator.evaluateAsBoolean((PyExpression)condition, true);
            }
            return false;
        }

        private static boolean suggestRename(@NotNull PsiNameIdentifierOwner element, @NotNull PsiElement originalElement) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (originalElement == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (element instanceof PyTargetExpression && originalElement instanceof PyTargetExpression) {
                return false;
            }
            return !(element instanceof PyFunction) || !"__init__".equals(element.getName()) || ((PyFunction)element).getContainingClass() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalElement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDecorated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "possiblyFalseCondition";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suggestRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processElement$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

