/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.keyFMap.KeyFMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileImpl
extends VirtualFileSystemEntry {
    private static final Key<byte[]> ourPreloadedContentKey = Key.create((String)"preloaded.content.key");

    VirtualFileImpl(int id, VfsData.Segment segment, VirtualDirectoryImpl parent) {
        super(id, segment, parent);
    }

    @Nullable
    public NewVirtualFile findChild(@NotNull @NonNls String name) {
        if (name == null) {
            VirtualFileImpl.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NotNull
    public Collection<VirtualFile> getCachedChildren() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        Iterable iterable = ContainerUtil.emptyIterable();
        if (iterable == null) {
            VirtualFileImpl.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        VirtualDirectoryImpl parent = this.getParent();
        assert (parent != null);
        NewVirtualFileSystem newVirtualFileSystem = parent.getFileSystem();
        if (newVirtualFileSystem == null) {
            VirtualFileImpl.$$$reportNull$$$0(3);
        }
        return newVirtualFileSystem;
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            VirtualFileImpl.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        if (name == null) {
            VirtualFileImpl.$$$reportNull$$$0(5);
        }
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public boolean isDirectory() {
        return false;
    }

    public void setPreloadedContentHint(byte[] preloadedContentHint) {
        this.putUserData(ourPreloadedContentKey, preloadedContentHint);
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)(preloadedContent == null ? ourPersistence.getInputStream((VirtualFile)this) : new DataInputStream((InputStream)new UnsyncByteArrayInputStream(preloadedContent))), (VirtualFile)this);
        if (inputStream == null) {
            VirtualFileImpl.$$$reportNull$$$0(6);
        }
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.contentsToByteArray(true);
        if (byArray == null) {
            VirtualFileImpl.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    @NotNull
    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        this.checkNotTooLarge(null);
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        if (preloadedContent != null) {
            if (preloadedContent == null) {
                VirtualFileImpl.$$$reportNull$$$0(8);
            }
            return preloadedContent;
        }
        byte[] bytes = ourPersistence.contentsToByteArray((VirtualFile)this, cacheContent);
        if (!this.isCharsetSet()) {
            FileType fileType = (FileType)ObjectUtils.notNull((Object)((FileTypeManagerImpl)FileTypeManager.getInstance()).getByFile((VirtualFile)this), (Object)UnknownFileType.INSTANCE);
            try {
                ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, bytes, fileType));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        if (bytes == null) {
            VirtualFileImpl.$$$reportNull$$$0(9);
        }
        return bytes;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long modStamp, long timeStamp) throws IOException {
        this.checkNotTooLarge(requestor);
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)ourPersistence.getOutputStream((VirtualFile)this, requestor, modStamp, timeStamp), (VirtualFile)this);
        if (outputStream == null) {
            VirtualFileImpl.$$$reportNull$$$0(10);
        }
        return outputStream;
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            VirtualFileImpl.$$$reportNull$$$0(11);
        }
        this.checkNotTooLarge(requestor);
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, (Object)requestor);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            VirtualFileImpl.$$$reportNull$$$0(12);
        }
        this.checkNotTooLarge(null);
        super.setBinaryContent(content, newModificationStamp, (long)newTimeStamp);
    }

    @Nullable
    public String getDetectedLineSeparator() {
        if (this.getFlagInt(0x8000000)) {
            return LineSeparator.getSystemLineSeparator().getSeparatorString();
        }
        return super.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(String separator) {
        boolean hasSystemSeparator = LineSeparator.getSystemLineSeparator().getSeparatorString().equals(separator);
        this.setFlagInt(0x8000000, hasSystemSeparator);
        super.setDetectedLineSeparator(hasSystemSeparator ? null : separator);
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        if (map == null) {
            VirtualFileImpl.$$$reportNull$$$0(13);
        }
        this.mySegment.setUserMap(this.myId, map);
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.mySegment.getUserMap(this, this.myId);
        if (keyFMap == null) {
            VirtualFileImpl.$$$reportNull$$$0(14);
        }
        return keyFMap;
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.mySegment.changeUserMap(this.myId, oldMap, UserDataInterner.internUserData(newMap));
    }

    private void checkNotTooLarge(@Nullable Object requestor) throws FileTooBigException {
        if (!(requestor instanceof LargeFileWriteRequestor) && this.isTooLarge()) {
            throw new FileTooBigException(this.getPath());
        }
    }

    private boolean isTooLarge() {
        return FileUtilRt.isTooLarge((long)this.getLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findChildIfCached";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

