/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.connect.StatServiceException;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogStatisticsService
implements StatisticsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogStatisticsService");
    private static final EventLogSettingsService mySettingsService = EventLogExternalSettingsService.getInstance();
    private static final int MAX_FILES_TO_SEND = 20;

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(mySettingsService, new EventLogCounterResultDecorator());
    }

    public static StatisticsResult send(@NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        if (settings == null) {
            EventLogStatisticsService.$$$reportNull$$$0(0);
        }
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(1);
        }
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            throw new StatServiceException("Event Log collector is not enabled");
        }
        List logs = FeatureUsageLogger.INSTANCE.getLogFiles();
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        if (!EventLogStatisticsService.isSendLogsEnabled(settings.getPermittedTraffic())) {
            EventLogStatisticsService.cleanupAllFiles();
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        LogEventFilter filter = settings.getEventFilter();
        try {
            ArrayList<File> toRemove2 = new ArrayList<File>(logs.size());
            int size = Math.min(20, logs.size());
            for (int i = 0; i < size; ++i) {
                File file2 = (File)logs.get(i);
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file2, filter);
                String error = EventLogStatisticsService.validate(recordRequest, file2);
                if (StringUtil.isNotEmpty((String)error) || recordRequest == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(file2.getName() + "-> " + error);
                    }
                    decorator.failed(recordRequest);
                    toRemove2.add(file2);
                    continue;
                }
                try {
                    HttpRequests.post((String)serviceUrl, (String)"application/json; charset=utf-8").isReadResponseOnError(true).tuner(connection -> connection.setRequestProperty("Content-Encoding", "gzip")).connect(request -> {
                        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                        try (OutputStreamWriter writer = new OutputStreamWriter(new GZIPOutputStream((OutputStream)out));){
                            LogEventSerializer.INSTANCE.toString(recordRequest, writer);
                        }
                        request.write(out.toByteArray());
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(file2.getName() + " -> " + EventLogStatisticsService.readResponse(request));
                        }
                        return null;
                    });
                    decorator.succeed(recordRequest);
                    toRemove2.add(file2);
                    continue;
                }
                catch (HttpRequests.HttpStatusException e) {
                    decorator.failed(recordRequest);
                    if (e.getStatusCode() == 400) {
                        toRemove2.add(file2);
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(file2.getName() + " -> " + e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(file2.getName() + " -> " + e.getMessage());
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove2);
            return decorator.toResult();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    @Nullable
    private static String readResponse(@NotNull HttpRequests.Request request) {
        if (request == null) {
            EventLogStatisticsService.$$$reportNull$$$0(2);
        }
        try {
            return request.readString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static boolean isSendLogsEnabled(int percent) {
        if (percent == 0) {
            return false;
        }
        String userId = PermanentInstallationID.get();
        return Math.abs(userId.hashCode()) % 100 < percent;
    }

    @Nullable
    private static String validate(@Nullable LogEventRecordRequest request, @NotNull File file2) {
        if (file2 == null) {
            EventLogStatisticsService.$$$reportNull$$$0(3);
        }
        if (request == null) {
            return "File is empty or has invalid format: " + file2.getName();
        }
        if (StringUtil.isEmpty((String)request.getUser())) {
            return "Cannot upload event log, user ID is empty";
        }
        if (StringUtil.isEmpty((String)request.getProduct())) {
            return "Cannot upload event log, product code is empty";
        }
        if (request.getRecords().isEmpty()) {
            return "Cannot upload event log, record list is empty";
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return "Cannot upload event log, event list is empty";
        }
        return null;
    }

    private static void cleanupAllFiles() {
        try {
            List logs = FeatureUsageLogger.INSTANCE.getLogFiles();
            if (!logs.isEmpty()) {
                EventLogStatisticsService.cleanupFiles(logs);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private static void cleanupFiles(@NotNull List<File> toRemove2) {
        if (toRemove2 == null) {
            EventLogStatisticsService.$$$reportNull$$$0(4);
        }
        for (File file2 : toRemove2) {
            if (!file2.delete()) {
                LOG.warn("Failed deleting event log: " + file2.getName());
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Removed sent log: " + file2.getName());
        }
    }

    @Override
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener2) {
        if (groupDisplayId == null) {
            EventLogStatisticsService.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "send";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readResponse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanupFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private int myFailed = 0;
        private int mySucceed = 0;

        private EventLogCounterResultDecorator() {
        }

        @Override
        public void succeed(@NotNull LogEventRecordRequest request) {
            if (request == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(0);
            }
            ++this.mySucceed;
        }

        @Override
        public void failed(@Nullable LogEventRecordRequest request) {
            ++this.myFailed;
        }

        @Override
        @NotNull
        public StatisticsResult toResult() {
            int total = this.mySucceed + this.myFailed;
            if (total == 0) {
                StatisticsResult statisticsResult = new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
                if (statisticsResult == null) {
                    EventLogCounterResultDecorator.$$$reportNull$$$0(1);
                }
                return statisticsResult;
            }
            if (this.myFailed > 0) {
                StatisticsResult statisticsResult = new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + this.mySucceed + " out of " + total + " files.");
                if (statisticsResult == null) {
                    EventLogCounterResultDecorator.$$$reportNull$$$0(2);
                }
                return statisticsResult;
            }
            StatisticsResult statisticsResult = new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + this.mySucceed + " files.");
            if (statisticsResult == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(3);
            }
            return statisticsResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService$EventLogCounterResultDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService$EventLogCounterResultDecorator";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "succeed";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

