/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.stackmap.MapMaker;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.EnhancementException;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    private final EnhancementContext enhancementContext;
    private final ClassPool classPool;
    private final CtClass managedEntityCtClass;
    private final CtClass managedCompositeCtClass;
    private final CtClass attributeInterceptorCtClass;
    private final CtClass attributeInterceptableCtClass;
    private final CtClass entityEntryCtClass;
    private final CtClass objectCtClass;
    private boolean isComposite;
    private static final AttributeTypeDescriptor BOOLEAN_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readBoolean(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("boolean localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeBoolean(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor BYTE_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readByte(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("byte localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeByte(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor CHAR_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readChar(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("char localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeChar(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor SHORT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readShort(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("short localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeShort(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor INT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readInt(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("int localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeInt(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor LONG_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readLong(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("long localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeLong(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor DOUBLE_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readDouble(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("double localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeDouble(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor FLOAT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readFloat(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("float localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeFloat(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };

    public Enhancer(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
        this.classPool = this.buildClassPool(enhancementContext);
        try {
            this.managedEntityCtClass = this.classPool.makeClass(ManagedEntity.class.getClassLoader().getResourceAsStream(ManagedEntity.class.getName().replace('.', '/') + ".class"));
            this.managedCompositeCtClass = this.classPool.makeClass(ManagedComposite.class.getClassLoader().getResourceAsStream(ManagedComposite.class.getName().replace('.', '/') + ".class"));
            this.attributeInterceptableCtClass = this.classPool.makeClass(PersistentAttributeInterceptable.class.getClassLoader().getResourceAsStream(PersistentAttributeInterceptable.class.getName().replace('.', '/') + ".class"));
            this.attributeInterceptorCtClass = this.classPool.makeClass(PersistentAttributeInterceptor.class.getClassLoader().getResourceAsStream(PersistentAttributeInterceptor.class.getName().replace('.', '/') + ".class"));
            this.entityEntryCtClass = this.classPool.makeClass(EntityEntry.class.getName());
        }
        catch (IOException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
        try {
            this.objectCtClass = this.classPool.getCtClass(Object.class.getName());
        }
        catch (NotFoundException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
    }

    private ClassPool buildClassPool(EnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false);
        ClassLoader loadingClassLoader = enhancementContext.getLoadingClassLoader();
        if (loadingClassLoader != null) {
            classPool.appendClassPath(new LoaderClassPath(loadingClassLoader));
        }
        return classPool;
    }

    public byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        CtClass managedCtClass;
        try {
            managedCtClass = this.classPool.makeClassIfNew(new ByteArrayInputStream(originalBytes));
        }
        catch (IOException e) {
            log.unableToBuildEnhancementMetamodel(className);
            return originalBytes;
        }
        this.enhance(managedCtClass, false);
        return this.getByteCode(managedCtClass);
    }

    public byte[] enhanceComposite(String className, byte[] originalBytes) throws EnhancementException {
        CtClass managedCtClass;
        try {
            managedCtClass = this.classPool.makeClassIfNew(new ByteArrayInputStream(originalBytes));
        }
        catch (IOException e) {
            log.unableToBuildEnhancementMetamodel(className);
            return originalBytes;
        }
        this.enhance(managedCtClass, true);
        return this.getByteCode(managedCtClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteCode(CtClass managedCtClass) {
        byte[] byArray;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            managedCtClass.toBytecode(out);
            byArray = byteStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                log.unableToTransformClass(e.getMessage());
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
        }
        try {
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return byArray;
    }

    private void enhance(CtClass managedCtClass, boolean isComposite) {
        String[] interfaceNames;
        this.isComposite = isComposite;
        String className = managedCtClass.getName();
        log.debugf("Enhancing %s", (Object)className);
        if (managedCtClass.isInterface()) {
            log.debug("skipping enhancement : interface");
            return;
        }
        for (String interfaceName : interfaceNames = managedCtClass.getClassFile2().getInterfaces()) {
            if (!ManagedEntity.class.getName().equals(interfaceName) && !ManagedComposite.class.getName().equals(interfaceName)) continue;
            log.debug("skipping enhancement : already enhanced");
            return;
        }
        if (!isComposite && this.enhancementContext.isEntityClass(managedCtClass)) {
            this.enhanceAsEntity(managedCtClass);
        } else if (isComposite || this.enhancementContext.isCompositeClass(managedCtClass)) {
            this.enhanceAsComposite(managedCtClass);
        } else {
            log.debug("skipping enhancement : not entity or composite");
        }
    }

    private void enhanceAsEntity(CtClass managedCtClass) {
        managedCtClass.addInterface(this.managedEntityCtClass);
        this.enhancePersistentAttributes(managedCtClass);
        this.addEntityInstanceHandling(managedCtClass);
        this.addEntityEntryHandling(managedCtClass);
        this.addLinkedPreviousHandling(managedCtClass);
        this.addLinkedNextHandling(managedCtClass);
    }

    private void enhanceAsComposite(CtClass managedCtClass) {
        this.enhancePersistentAttributes(managedCtClass);
    }

    private void addEntityInstanceHandling(CtClass managedCtClass) {
        try {
            managedCtClass.addMethod(CtNewMethod.make(this.objectCtClass, "$$_hibernate_getEntityInstance", new CtClass[0], new CtClass[0], "{ return this; }", managedCtClass));
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add EntityEntry getter", managedCtClass.getName()), e);
        }
    }

    private void addEntityEntryHandling(CtClass managedCtClass) {
        this.addFieldWithGetterAndSetter(managedCtClass, this.entityEntryCtClass, "$$_hibernate_entityEntryHolder", "$$_hibernate_getEntityEntry", "$$_hibernate_setEntityEntry");
    }

    private void addLinkedPreviousHandling(CtClass managedCtClass) {
        this.addFieldWithGetterAndSetter(managedCtClass, this.managedEntityCtClass, "$$_hibernate_previousManagedEntity", "$$_hibernate_getPreviousManagedEntity", "$$_hibernate_setPreviousManagedEntity");
    }

    private void addLinkedNextHandling(CtClass managedCtClass) {
        this.addFieldWithGetterAndSetter(managedCtClass, this.managedEntityCtClass, "$$_hibernate_nextManagedEntity", "$$_hibernate_getNextManagedEntity", "$$_hibernate_setNextManagedEntity");
    }

    private AnnotationsAttribute getVisibleAnnotations(FieldInfo fieldInfo) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
            fieldInfo.addAttribute(annotationsAttribute);
        }
        return annotationsAttribute;
    }

    private void enhancePersistentAttributes(CtClass managedCtClass) {
        this.addInterceptorHandling(managedCtClass);
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
            this.addInLineDirtyHandling(managedCtClass);
        }
        IdentityHashMap<String, PersistentAttributeDescriptor> attrDescriptorMap = new IdentityHashMap<String, PersistentAttributeDescriptor>();
        for (CtField persistentField : this.collectPersistentFields(managedCtClass)) {
            attrDescriptorMap.put(persistentField.getName(), this.enhancePersistentAttribute(managedCtClass, persistentField));
        }
        this.transformFieldAccessesIntoReadsAndWrites(managedCtClass, attrDescriptorMap);
    }

    private PersistentAttributeDescriptor enhancePersistentAttribute(CtClass managedCtClass, CtField persistentField) {
        try {
            AttributeTypeDescriptor typeDescriptor = this.resolveAttributeTypeDescriptor(persistentField);
            return new PersistentAttributeDescriptor(persistentField, this.generateFieldReader(managedCtClass, persistentField, typeDescriptor), this.generateFieldWriter(managedCtClass, persistentField, typeDescriptor), typeDescriptor);
        }
        catch (Exception e) {
            throw new EnhancementException(String.format("Unable to enhance persistent attribute [%s:%s]", managedCtClass.getName(), persistentField.getName()), e);
        }
    }

    private CtField[] collectPersistentFields(CtClass managedCtClass) {
        ArrayList<CtField> persistentFieldList = new ArrayList<CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic(ctField.getModifiers()) || ctField.getName().startsWith("$") || !this.enhancementContext.isPersistentField(ctField)) continue;
            persistentFieldList.add(ctField);
        }
        return this.enhancementContext.order(persistentFieldList.toArray(new CtField[persistentFieldList.size()]));
    }

    private List<CtField> collectCollectionFields(CtClass managedCtClass) {
        ArrayList<CtField> collectionList = new ArrayList<CtField>();
        try {
            block2: for (CtField ctField : managedCtClass.getDeclaredFields()) {
                if (Modifier.isStatic(ctField.getModifiers()) || ctField.getName().startsWith("$") || !this.enhancementContext.isPersistentField(ctField)) continue;
                for (CtClass ctClass : ctField.getType().getInterfaces()) {
                    if (!ctClass.getName().equals("java.util.Collection")) continue;
                    collectionList.add(ctField);
                    continue block2;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return collectionList;
    }

    private void addInterceptorHandling(CtClass managedCtClass) {
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass) && !this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            return;
        }
        log.debug("Weaving in PersistentAttributeInterceptable implementation");
        managedCtClass.addInterface(this.attributeInterceptableCtClass);
        this.addFieldWithGetterAndSetter(managedCtClass, this.attributeInterceptorCtClass, "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
    }

    private boolean isClassAlreadyTrackingDirtyStatus(CtClass managedCtClass) {
        try {
            for (CtClass ctInterface : managedCtClass.getInterfaces()) {
                if (!ctInterface.getName().equals(SelfDirtinessTracker.class.getName())) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addInLineDirtyHandling(CtClass managedCtClass) {
        try {
            if (this.isComposite) {
                managedCtClass.addInterface(this.classPool.get("org.hibernate.engine.spi.CompositeTracker"));
                CtClass compositeCtType = this.classPool.get("org.hibernate.bytecode.enhance.spi.CompositeOwnerTracker");
                this.addField(managedCtClass, compositeCtType, "$$_hibernate_compositeOwners", true);
                this.createCompositeTrackerMethod(managedCtClass);
            } else {
                managedCtClass.addInterface(this.classPool.get("org.hibernate.engine.spi.SelfDirtinessTracker"));
                CtClass trackerCtType = this.classPool.get("java.util.Set");
                this.addField(managedCtClass, trackerCtType, "$$_hibernate_tracker", true);
                CtClass collectionTrackerCtType = this.classPool.get("org.hibernate.bytecode.enhance.spi.CollectionTracker");
                this.addField(managedCtClass, collectionTrackerCtType, "$$_hibernate_collectionTracker", true);
                this.createDirtyTrackerMethods(managedCtClass);
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void createDirtyTrackerMethods(CtClass managedCtClass) {
        try {
            String trackerChangeMethod = "public void $$_hibernate_trackChange(String name) {  if($$_hibernate_tracker == null) {    $$_hibernate_tracker = new java.util.HashSet();  }  if(!$$_hibernate_tracker.contains(name)) {    $$_hibernate_tracker.add(name);  }}";
            managedCtClass.addMethod(CtNewMethod.make(trackerChangeMethod, managedCtClass));
            this.createCollectionDirtyCheckMethod(managedCtClass);
            this.createCollectionDirtyCheckGetFieldsMethod(managedCtClass);
            this.createHasDirtyAttributesMethod(managedCtClass);
            this.createClearDirtyCollectionMethod(managedCtClass);
            this.createClearDirtyMethod(managedCtClass);
            String trackerGetMethod = "public java.util.List $$_hibernate_getDirtyAttributes() { if($$_hibernate_tracker == null) $$_hibernate_tracker = new java.util.HashSet();$$_hibernate_getCollectionFieldDirtyNames($$_hibernate_tracker);return $$_hibernate_tracker; }";
            CtMethod getMethod = CtNewMethod.make(trackerGetMethod, managedCtClass);
            MethodInfo methodInfo = getMethod.getMethodInfo();
            SignatureAttribute signatureAttribute = new SignatureAttribute(methodInfo.getConstPool(), "()Ljava/util/Set<Ljava/lang/String;>;");
            methodInfo.addAttribute(signatureAttribute);
            managedCtClass.addMethod(getMethod);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void createTrackChangeCompositeMethod(CtClass managedCtClass) {
        StringBuilder builder = new StringBuilder();
        builder.append("public void ").append("$$_hibernate_trackChange").append("(String name) {").append("if (").append("$$_hibernate_compositeOwners").append(" != null) ").append("$$_hibernate_compositeOwners").append(".callOwner(\".\"+name); }");
        System.out.println("COMPOSITE METHOD: " + builder.toString());
        try {
            managedCtClass.addMethod(CtNewMethod.make(builder.toString(), managedCtClass));
        }
        catch (CannotCompileException cannotCompileException) {
            // empty catch block
        }
    }

    private void createCompositeTrackerMethod(CtClass managedCtClass) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("public void ").append("$$_hibernate_setOwner").append("(String name, org.hibernate.engine.spi.CompositeOwner tracker) {").append("if(").append("$$_hibernate_compositeOwners").append(" == null) ").append("$$_hibernate_compositeOwners").append(" = new org.hibernate.bytecode.enhance.spi.CompositeOwnerTracker();").append("$$_hibernate_compositeOwners").append(".add(name, tracker); }");
            managedCtClass.addMethod(CtNewMethod.make(builder.toString(), managedCtClass));
            builder = new StringBuilder();
            builder.append("public void ").append("$$_hibernate_clearOwner").append("(String name) {").append(" if(").append("$$_hibernate_compositeOwners").append(" != null)").append("$$_hibernate_compositeOwners").append(".removeOwner(name);}");
            managedCtClass.addMethod(CtNewMethod.make(builder.toString(), managedCtClass));
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    private void createHasDirtyAttributesMethod(CtClass managedCtClass) throws CannotCompileException {
        String trackerHasChangedMethod = "public boolean $$_hibernate_hasDirtyAttributes() { return ($$_hibernate_tracker != null && !$$_hibernate_tracker.isEmpty()) || $$_hibernate_areCollectionFieldsDirty(); } ";
        managedCtClass.addMethod(CtNewMethod.make(trackerHasChangedMethod, managedCtClass));
    }

    private void createClearDirtyMethod(CtClass managedCtClass) throws CannotCompileException, ClassNotFoundException {
        StringBuilder builder = new StringBuilder();
        builder.append("public void ").append("$$_hibernate_clearDirtyAttributes").append("() {").append("if (").append("$$_hibernate_tracker").append(" != null) ").append("$$_hibernate_tracker").append(".clear(); ").append("$$_hibernate_clearDirtyCollectionNames").append("(); }");
        managedCtClass.addMethod(CtNewMethod.make(builder.toString(), managedCtClass));
    }

    private void createClearDirtyCollectionMethod(CtClass managedCtClass) throws CannotCompileException {
        StringBuilder builder = new StringBuilder();
        builder.append("private void ").append("$$_hibernate_clearDirtyCollectionNames").append("() { if(").append("$$_hibernate_collectionTracker").append(" == null)").append("$$_hibernate_collectionTracker").append(" = new org.hibernate.bytecode.enhance.spi.CollectionTracker();");
        for (CtField ctField : this.collectCollectionFields(managedCtClass)) {
            if (this.enhancementContext.isMappedCollection(ctField)) continue;
            builder.append("if(").append(ctField.getName()).append(" != null) ").append("$$_hibernate_collectionTracker").append(".add(\"").append(ctField.getName()).append("\", ").append(ctField.getName()).append(".size());");
        }
        builder.append("}");
        managedCtClass.addMethod(CtNewMethod.make(builder.toString(), managedCtClass));
    }

    private void createCollectionDirtyCheckMethod(CtClass managedCtClass) throws CannotCompileException {
        StringBuilder builder = new StringBuilder("private boolean ").append("$$_hibernate_areCollectionFieldsDirty").append("() { if (").append("$$_hibernate_collectionTracker").append(" == null) return false; ");
        for (CtField ctField : this.collectCollectionFields(managedCtClass)) {
            if (this.enhancementContext.isMappedCollection(ctField)) continue;
            builder.append("if(").append("$$_hibernate_collectionTracker").append(".getSize(\"").append(ctField.getName()).append("\") != ").append(ctField.getName()).append(".size()) return true;");
        }
        builder.append("return false; }");
        managedCtClass.addMethod(CtNewMethod.make(builder.toString(), managedCtClass));
    }

    private void createCollectionDirtyCheckGetFieldsMethod(CtClass managedCtClass) throws CannotCompileException {
        StringBuilder collectionFieldDirtyFieldMethod = new StringBuilder("private void ").append("$$_hibernate_getCollectionFieldDirtyNames").append("(java.util.Set trackerSet) { if(").append("$$_hibernate_collectionTracker").append(" == null) return; else {");
        for (CtField ctField : this.collectCollectionFields(managedCtClass)) {
            if (ctField.getName().startsWith("$$_hibernate") || this.enhancementContext.isMappedCollection(ctField)) continue;
            collectionFieldDirtyFieldMethod.append("if(").append("$$_hibernate_collectionTracker").append(".getSize(\"").append(ctField.getName()).append("\") != ").append(ctField.getName()).append(".size()) trackerSet.add(\"").append(ctField.getName()).append("\");");
        }
        collectionFieldDirtyFieldMethod.append("}}");
        managedCtClass.addMethod(CtNewMethod.make(collectionFieldDirtyFieldMethod.toString(), managedCtClass));
    }

    private void addFieldWithGetterAndSetter(CtClass targetClass, CtClass fieldType, String fieldName, String getterName, String setterName) {
        CtField theField = this.addField(targetClass, fieldType, fieldName, true);
        this.addGetter(targetClass, theField, getterName);
        this.addSetter(targetClass, theField, setterName);
    }

    private CtField addField(CtClass targetClass, CtClass fieldType, String fieldName, boolean makeTransient) {
        CtField theField;
        ConstPool constPool = targetClass.getClassFile().getConstPool();
        try {
            theField = new CtField(fieldType, fieldName, targetClass);
            targetClass.addField(theField);
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance class [%s] to add field [%s]", targetClass.getName(), fieldName), e);
        }
        if (makeTransient) {
            theField.setModifiers(theField.getModifiers() | 0x80);
        }
        theField.setModifiers(Modifier.setPrivate(theField.getModifiers()));
        AnnotationsAttribute annotationsAttribute = this.getVisibleAnnotations(theField.getFieldInfo());
        annotationsAttribute.addAnnotation(new Annotation(Transient.class.getName(), constPool));
        return theField;
    }

    private void addGetter(CtClass targetClass, CtField theField, String getterName) {
        try {
            targetClass.addMethod(CtNewMethod.getter(getterName, theField));
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add getter method [%s]", targetClass.getName(), getterName), e);
        }
    }

    private void addSetter(CtClass targetClass, CtField theField, String setterName) {
        try {
            targetClass.addMethod(CtNewMethod.setter(setterName, theField));
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add setter method [%s]", targetClass.getName(), setterName), e);
        }
    }

    private CtMethod generateFieldReader(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) throws BadBytecode, CannotCompileException {
        FieldInfo fieldInfo = persistentField.getFieldInfo();
        String fieldName = fieldInfo.getName();
        String readerName = "$$_hibernate_read_" + fieldName;
        if (!this.enhancementContext.isLazyLoadable(persistentField)) {
            try {
                CtMethod reader = CtNewMethod.getter(readerName, persistentField);
                managedCtClass.addMethod(reader);
                return reader;
            }
            catch (CannotCompileException e) {
                throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName), e);
            }
        }
        String methodBody = typeDescriptor.buildReadInterceptionBodyFragment(fieldName) + " return this." + fieldName + ";";
        try {
            CtMethod reader = CtNewMethod.make(2, persistentField.getType(), readerName, null, null, "{" + methodBody + "}", managedCtClass);
            managedCtClass.addMethod(reader);
            return reader;
        }
        catch (Exception e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName), e);
        }
    }

    private CtMethod generateFieldWriter(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        FieldInfo fieldInfo = persistentField.getFieldInfo();
        String fieldName = fieldInfo.getName();
        String writerName = "$$_hibernate_write_" + fieldName;
        try {
            CtMethod writer;
            if (!this.enhancementContext.isLazyLoadable(persistentField)) {
                writer = CtNewMethod.setter(writerName, persistentField);
            } else {
                String methodBody = typeDescriptor.buildWriteInterceptionBodyFragment(fieldName);
                writer = CtNewMethod.make(2, CtClass.voidType, writerName, new CtClass[]{persistentField.getType()}, null, "{" + methodBody + "}", managedCtClass);
            }
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass) && !this.isComposite) {
                writer.insertBefore(typeDescriptor.buildInLineDirtyCheckingBodyFragment(persistentField));
            }
            if (this.isComposite) {
                StringBuilder builder = new StringBuilder();
                builder.append(" if(  ").append("$$_hibernate_compositeOwners").append(" != null) ").append("$$_hibernate_compositeOwners").append(".callOwner(\".").append(persistentField.getName()).append("\");");
                writer.insertBefore(builder.toString());
            }
            if (persistentField.getAnnotation(Embedded.class) != null) {
                if (!this.doClassInheritCompositeOwner(managedCtClass)) {
                    managedCtClass.addInterface(this.classPool.get("org.hibernate.engine.spi.CompositeOwner"));
                }
                if (this.isComposite) {
                    this.createTrackChangeCompositeMethod(managedCtClass);
                }
                writer.insertBefore(this.cleanupPreviousOwner(persistentField));
                writer.insertAfter(this.compositeMethodBody(persistentField));
            }
            managedCtClass.addMethod(writer);
            return writer;
        }
        catch (Exception e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName), e);
        }
    }

    private boolean doClassInheritCompositeOwner(CtClass managedCtClass) {
        try {
            for (CtClass ctClass : managedCtClass.getInterfaces()) {
                if (!ctClass.getName().equals("org.hibernate.engine.spi.CompositeOwner")) continue;
                return true;
            }
            return false;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private String cleanupPreviousOwner(CtField currentValue) {
        StringBuilder builder = new StringBuilder();
        builder.append("if (").append(currentValue.getName()).append(" != null) ").append("((org.hibernate.engine.spi.CompositeTracker)").append(currentValue.getName()).append(").").append("$$_hibernate_clearOwner").append("(\"").append(currentValue.getName()).append("\");");
        return builder.toString();
    }

    private String compositeMethodBody(CtField currentValue) {
        StringBuilder builder = new StringBuilder();
        builder.append("((org.hibernate.engine.spi.CompositeTracker) ").append(currentValue.getName()).append(").$$_hibernate_setOwner(\"").append(currentValue.getName()).append("\",(org.hibernate.engine.spi.CompositeOwner) this);").append("$$_hibernate_trackChange(\"").append(currentValue.getName()).append("\");");
        return builder.toString();
    }

    private void transformFieldAccessesIntoReadsAndWrites(CtClass managedCtClass, IdentityHashMap<String, PersistentAttributeDescriptor> attributeDescriptorMap) {
        ConstPool constPool = managedCtClass.getClassFile().getConstPool();
        for (Object oMethod : managedCtClass.getClassFile().getMethods()) {
            CodeAttribute codeAttr;
            MethodInfo methodInfo = (MethodInfo)oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith("$$_hibernate_read_") || methodName.startsWith("$$_hibernate_write_") || methodName.equals("$$_hibernate_getEntityInstance") || methodName.equals("$$_hibernate_getEntityEntry") || methodName.equals("$$_hibernate_setEntityEntry") || methodName.equals("$$_hibernate_getPreviousManagedEntity") || methodName.equals("$$_hibernate_setPreviousManagedEntity") || methodName.equals("$$_hibernate_getNextManagedEntity") || methodName.equals("$$_hibernate_setNextManagedEntity") || (codeAttr = methodInfo.getCodeAttribute()) == null) continue;
            try {
                CodeIterator itr = codeAttr.iterator();
                while (itr.hasNext()) {
                    int constIndex;
                    String fieldName;
                    PersistentAttributeDescriptor attributeDescriptor;
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180 || (attributeDescriptor = attributeDescriptorMap.get(fieldName = constPool.getFieldrefName(constIndex = itr.u16bitAt(index + 1)))) == null) continue;
                    log.tracef("Transforming access to field [%s] from method [%s]", (Object)fieldName, (Object)methodName);
                    if (op == 180) {
                        int readMethodIndex = constPool.addMethodrefInfo(constPool.getThisClassInfo(), attributeDescriptor.getReader().getName(), attributeDescriptor.getReader().getSignature());
                        itr.writeByte(183, index);
                        itr.write16bit(readMethodIndex, index + 1);
                        continue;
                    }
                    int writeMethodIndex = constPool.addMethodrefInfo(constPool.getThisClassInfo(), attributeDescriptor.getWriter().getName(), attributeDescriptor.getWriter().getSignature());
                    itr.writeByte(183, index);
                    itr.write16bit(writeMethodIndex, index + 1);
                }
                StackMapTable smt = MapMaker.make(this.classPool, methodInfo);
                methodInfo.getCodeAttribute().setAttribute(smt);
            }
            catch (BadBytecode e) {
                throw new EnhancementException("Unable to perform field access transformation in method : " + methodName, e);
            }
        }
    }

    private AttributeTypeDescriptor resolveAttributeTypeDescriptor(CtField persistentField) throws NotFoundException {
        if (persistentField.getType() == CtClass.booleanType) {
            return BOOLEAN_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.byteType) {
            return BYTE_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.charType) {
            return CHAR_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.shortType) {
            return SHORT_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.intType) {
            return INT_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.longType) {
            return LONG_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.doubleType) {
            return DOUBLE_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.floatType) {
            return FLOAT_DESCRIPTOR;
        }
        return new ObjectAttributeTypeDescriptor(persistentField.getType());
    }

    private static class ObjectAttributeTypeDescriptor
    extends AbstractAttributeTypeDescriptor {
        private final CtClass concreteType;

        private ObjectAttributeTypeDescriptor(CtClass concreteType) {
            this.concreteType = concreteType;
        }

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = (%2$s) $$_hibernate_getInterceptor().readObject(this, \"%1$s\", this.%1$s); }", fieldName, this.concreteType.getName());
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("%2$s localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = (%2$s) $$_hibernate_getInterceptor().writeObject(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName, this.concreteType.getName());
        }
    }

    private static abstract class AbstractAttributeTypeDescriptor
    implements AttributeTypeDescriptor {
        private AbstractAttributeTypeDescriptor() {
        }

        @Override
        public String buildInLineDirtyCheckingBodyFragment(CtField currentValue) {
            StringBuilder builder = new StringBuilder();
            try {
                for (Object o : currentValue.getType().getAnnotations()) {
                    if (!(o instanceof Id)) continue;
                    return "";
                }
                builder.append(this.entityMethodBody(currentValue));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            return builder.toString();
        }

        private String entityMethodBody(CtField currentValue) {
            StringBuilder inlineBuilder = new StringBuilder();
            try {
                if (currentValue.getType().isPrimitive() || currentValue.getType().isEnum()) {
                    inlineBuilder.append("if(").append(currentValue.getName()).append(" != $1)");
                } else if (currentValue.getType().getName().startsWith("java.lang") || currentValue.getType().getName().startsWith("java.math.Big") || currentValue.getType().getName().startsWith("java.sql.Time") || currentValue.getType().getName().startsWith("java.sql.Date") || currentValue.getType().getName().startsWith("java.util.Date") || currentValue.getType().getName().startsWith("java.util.Calendar")) {
                    inlineBuilder.append("if(").append(currentValue.getName()).append(" == null || !").append(currentValue.getName()).append(".equals( $1))");
                } else {
                    for (CtClass ctClass : currentValue.getType().getInterfaces()) {
                        if (!ctClass.getName().equals("java.util.Collection") || currentValue.getAnnotation(OneToMany.class) == null && currentValue.getAnnotation(ManyToMany.class) == null && currentValue.getAnnotation(ElementCollection.class) == null) continue;
                        return "";
                    }
                    inlineBuilder.append("if(").append(currentValue.getName()).append(" == null || !").append(currentValue.getName()).append(".equals( $1))");
                }
                inlineBuilder.append("$$_hibernate_trackChange(\"").append(currentValue.getName()).append("\");");
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return inlineBuilder.toString();
        }
    }

    private static interface AttributeTypeDescriptor {
        public String buildReadInterceptionBodyFragment(String var1);

        public String buildWriteInterceptionBodyFragment(String var1);

        public String buildInLineDirtyCheckingBodyFragment(CtField var1);
    }

    private static class PersistentAttributeDescriptor {
        private final CtField field;
        private final CtMethod reader;
        private final CtMethod writer;
        private final AttributeTypeDescriptor typeDescriptor;

        private PersistentAttributeDescriptor(CtField field, CtMethod reader, CtMethod writer, AttributeTypeDescriptor typeDescriptor) {
            this.field = field;
            this.reader = reader;
            this.writer = writer;
            this.typeDescriptor = typeDescriptor;
        }

        public CtField getField() {
            return this.field;
        }

        public CtMethod getReader() {
            return this.reader;
        }

        public CtMethod getWriter() {
            return this.writer;
        }

        public AttributeTypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }
    }
}

