/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.PhysicalAddress;
import org.hibernate.Query;

public class Finder {
    private static final String HQLPREFIX = "var";
    private List<Token> tokens;
    private Expression expression;

    public static Class<? extends Config> getDeviceConfigClass(Class<?> driver) {
        Class<?>[] innerClasses;
        for (Class<?> innerClass : innerClasses = driver.getDeclaredClasses()) {
            if (!Config.class.isAssignableFrom(innerClass)) continue;
            return innerClass;
        }
        return null;
    }

    public Finder(String query, DeviceDriver driver) throws Expression.FinderParseException {
        this.tokens = Expression.tokenize(query);
        this.expression = this.tokens.size() == 0 ? new NullExpression(driver) : Expression.parse(this.tokens, driver);
    }

    public String getFormattedQuery() {
        return this.expression.toString();
    }

    public String getHql() {
        FinderCriteria criteria = this.expression.buildHqlString(HQLPREFIX);
        StringBuilder hql = new StringBuilder();
        hql.append(" from Device d");
        for (String table : criteria.otherTables) {
            hql.append(", ").append(table);
        }
        for (String join : criteria.joins) {
            hql.append(" left join ").append(join);
        }
        hql.append(" where ");
        if (this.expression.driver != null) {
            hql.append("d.driver = :driver").append(" and ");
        }
        for (String where : criteria.whereJoins) {
            hql.append(where).append(" and ");
        }
        hql.append("(").append(criteria.where).append(")");
        return hql.toString();
    }

    public void setVariables(Query query) {
        this.expression.setVariables(query, HQLPREFIX);
    }

    public static class VirtualNameExpression
    extends Expression {
        public TokenType sign;
        private String value;

        public VirtualNameExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.VIRTUALNAME) {
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                switch (comparator.type) {
                    case IS: 
                    case CONTAINS: 
                    case STARTSWITH: 
                    case ENDSWITH: {
                        if (value.type == TokenType.QUOTE) {
                            VirtualNameExpression modExpr = new VirtualNameExpression(driver);
                            modExpr.sign = comparator.type;
                            modExpr.value = TokenType.unescape(value.text);
                            return modExpr;
                        }
                        throw new Expression.FinderParseException(String.format("Expecting a quoted string for VirtualName at character %d.", value.position));
                    }
                }
                throw new Expression.FinderParseException(String.format("Invalid operator after VirtualName at character %d.", comparator.position));
            }
            return null;
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = String.format("(v like :%s) or (d.name like :%s)", itemPrefix, itemPrefix);
            criteria.joins.add("d.virtualDevices v");
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            String target;
            super.setVariables(query, itemPrefix);
            switch (this.sign) {
                case CONTAINS: {
                    target = "%" + this.value + "%";
                    break;
                }
                case STARTSWITH: {
                    target = this.value + "%";
                    break;
                }
                case ENDSWITH: {
                    target = "%" + this.value;
                    break;
                }
                default: {
                    target = this.value;
                }
            }
            query.setString(itemPrefix, target);
        }

        @Override
        public String toString() {
            return String.format("[%s] %s \"%s\"", new Object[]{TokenType.VIRTUALNAME, this.sign, TokenType.escape(this.value)});
        }
    }

    public static class VrfExpression
    extends Expression {
        public TokenType sign;
        private String value;

        public VrfExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.VRF) {
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                switch (comparator.type) {
                    case IS: 
                    case CONTAINS: 
                    case STARTSWITH: 
                    case ENDSWITH: {
                        if (value.type == TokenType.QUOTE) {
                            VrfExpression modExpr = new VrfExpression(driver);
                            modExpr.sign = comparator.type;
                            modExpr.value = TokenType.unescape(value.text);
                            return modExpr;
                        }
                        throw new Expression.FinderParseException(String.format("Expecting a quoted string for VRF at character %d.", value.position));
                    }
                }
                throw new Expression.FinderParseException(String.format("Invalid operator after VRF at character %d.", comparator.position));
            }
            return null;
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = String.format("(v like :%s)", itemPrefix);
            criteria.joins.add("d.vrfInstances v");
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            String target;
            switch (this.sign) {
                case CONTAINS: {
                    target = "%" + this.value + "%";
                    break;
                }
                case STARTSWITH: {
                    target = this.value + "%";
                    break;
                }
                case ENDSWITH: {
                    target = "%" + this.value;
                    break;
                }
                default: {
                    target = this.value;
                }
            }
            query.setString(itemPrefix, target);
        }

        @Override
        public String toString() {
            return String.format("[%s] %s \"%s\"", new Object[]{TokenType.VRF, this.sign, TokenType.escape(this.value)});
        }
    }

    private static class FinderCriteria {
        public String where = "1 = 1";
        public Set<String> joins = new TreeSet<String>();
        public Set<String> otherTables = new TreeSet<String>();
        public Set<String> whereJoins = new TreeSet<String>();

        private FinderCriteria() {
        }
    }

    public static class BinaryAttributeExpression
    extends AttributeExpression {
        private boolean value;

        public BinaryAttributeExpression(DeviceDriver driver, String item, String property, AttributeExpression.PropertyLevel propertyLevel) {
            super(driver, item, property, propertyLevel);
            this.sign = TokenType.IS;
        }

        @Override
        protected String getTextValue() {
            return this.value ? "TRUE" : "FALSE";
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = this.buildWhere("assumption", "is", itemPrefix);
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            query.setBoolean(itemPrefix, this.value);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            String property = null;
            String item = null;
            AttributeExpression.PropertyLevel level = AttributeExpression.PropertyLevel.DEVICE;
            if (driver != null) {
                for (DeviceDriver.AttributeDefinition attribute : driver.getAttributes()) {
                    if (!attribute.isSearchable() || attribute.getType() != DeviceDriver.AttributeType.BINARY || !attribute.getTitle().equalsIgnoreCase(tokens.get((int)0).text)) continue;
                    property = attribute.getName();
                    item = attribute.getTitle();
                    if (attribute.getLevel() == DeviceDriver.AttributeLevel.CONFIG) {
                        level = AttributeExpression.PropertyLevel.CONFIGATTRIBUTE;
                        break;
                    }
                    level = AttributeExpression.PropertyLevel.DEVICEATTRIBUTE;
                    break;
                }
            }
            if (item == null) {
                return null;
            }
            if (tokens.size() != 3) {
                throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after enum item at character %d.", tokens.get((int)0).position));
            }
            Token sign = tokens.get(1);
            Token value = tokens.get(2);
            if (sign.type != TokenType.IS) {
                throw new Expression.FinderParseException(String.format("Parsing error, invalid operator at position %d, should be 'IS'.", sign.position));
            }
            BinaryAttributeExpression binExpr = new BinaryAttributeExpression(driver, item, property, level);
            if (value.type == TokenType.TRUE) {
                binExpr.value = true;
            } else if (value.type == TokenType.FALSE) {
                binExpr.value = false;
            } else {
                throw new Expression.FinderParseException(String.format("Parsing error, invalid operator at position %d, should be 'TRUE' or 'FALSE'.", value.position));
            }
            return binExpr;
        }
    }

    public static class DateAttributeExpression
    extends AttributeExpression {
        private static final DateFormat WITHTIME = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private static final DateFormat WITHOUTTIME = new SimpleDateFormat("yyyy-MM-dd");
        private Date value;
        private DateFormat format = WITHTIME;

        public DateAttributeExpression(DeviceDriver driver, String item, String property, AttributeExpression.PropertyLevel propertyLevel) {
            super(driver, item, property, propertyLevel);
        }

        @Override
        protected String getTextValue() {
            return "\"" + this.format.format(this.value) + "\"";
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            switch (this.sign) {
                case AFTER: {
                    criteria.where = this.buildWhere("when", ">=", itemPrefix);
                    break;
                }
                case BEFORE: {
                    criteria.where = this.buildWhere("when", "<=", itemPrefix);
                    break;
                }
                default: {
                    criteria.where = "(" + this.buildWhere("when", ">=", itemPrefix + "_1") + " and " + this.buildWhere("when", "<=", itemPrefix + "_2") + ")";
                }
            }
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            Calendar beginTime = Calendar.getInstance();
            beginTime.setTime(this.value);
            Calendar endTime = Calendar.getInstance();
            endTime.setTime(this.value);
            if (this.format == WITHOUTTIME) {
                beginTime.set(14, 0);
                beginTime.set(13, 0);
                beginTime.set(12, 0);
                beginTime.set(10, 0);
                endTime.setTime(beginTime.getTime());
                endTime.add(5, 1);
                endTime.add(14, -1);
            }
            switch (this.sign) {
                case AFTER: {
                    query.setTimestamp(itemPrefix, beginTime.getTime());
                    break;
                }
                case BEFORE: {
                    query.setTimestamp(itemPrefix, endTime.getTime());
                    break;
                }
                default: {
                    query.setDate(itemPrefix + "_1", beginTime.getTime());
                    query.setDate(itemPrefix + "_2", endTime.getTime());
                }
            }
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            String property = null;
            String item = null;
            AttributeExpression.PropertyLevel level = AttributeExpression.PropertyLevel.DEVICE;
            if ("Creation date".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "createdDate";
                item = "Creation date";
            } else if ("Last change date".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "changeDate";
                item = "Last change date";
            } else if (driver != null) {
                for (DeviceDriver.AttributeDefinition attribute : driver.getAttributes()) {
                    if (!attribute.isSearchable() || attribute.getType() != DeviceDriver.AttributeType.DATE || !attribute.getTitle().equalsIgnoreCase(tokens.get((int)0).text)) continue;
                    property = attribute.getName();
                    item = attribute.getTitle();
                    if (attribute.getLevel() == DeviceDriver.AttributeLevel.CONFIG) {
                        level = AttributeExpression.PropertyLevel.CONFIGATTRIBUTE;
                        break;
                    }
                    level = AttributeExpression.PropertyLevel.DEVICEATTRIBUTE;
                    break;
                }
            }
            if (item == null) {
                return null;
            }
            if (tokens.size() != 3) {
                throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after date item at character %d.", tokens.get((int)0).position));
            }
            Token sign = tokens.get(1);
            Token value = tokens.get(2);
            if (sign.type != TokenType.BEFORE && sign.type != TokenType.AFTER && sign.type != TokenType.IS) {
                throw new Expression.FinderParseException(String.format("Parsing error, invalid date operator at position %d.", sign.position));
            }
            if (value.type != TokenType.QUOTE) {
                throw new Expression.FinderParseException(String.format("Parsing error, should be a quoted date at character %d.", value.position));
            }
            DateAttributeExpression dateExpr = new DateAttributeExpression(driver, item, property, level);
            dateExpr.sign = sign.type;
            try {
                dateExpr.value = dateExpr.format.parse(value.text);
            }
            catch (ParseException e1) {
                try {
                    dateExpr.format = WITHOUTTIME;
                    dateExpr.value = dateExpr.format.parse(value.text);
                }
                catch (ParseException e2) {
                    throw new Expression.FinderParseException(String.format("Invalid date/time at position %d.", value.position));
                }
            }
            return dateExpr;
        }

        static {
            WITHTIME.setLenient(false);
            WITHOUTTIME.setLenient(false);
        }
    }

    public static class TextAttributeExpression
    extends AttributeExpression {
        private String value;
        private boolean longText = false;

        public TextAttributeExpression(DeviceDriver driver, String item, String property, AttributeExpression.PropertyLevel propertyLevel) {
            super(driver, item, property, propertyLevel);
        }

        @Override
        protected String getTextValue() {
            return "\"" + TokenType.escape(this.value) + "\"";
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = this.buildWhere(this.longText ? "longText.text" : "text", "like", itemPrefix);
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            String target;
            super.setVariables(query, itemPrefix);
            switch (this.sign) {
                case CONTAINS: {
                    target = "%" + this.value + "%";
                    break;
                }
                case STARTSWITH: {
                    target = this.value + "%";
                    break;
                }
                case ENDSWITH: {
                    target = "%" + this.value;
                    break;
                }
                default: {
                    target = this.value;
                }
            }
            query.setString(itemPrefix, target);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            String property = null;
            String item = null;
            AttributeExpression.PropertyLevel level = AttributeExpression.PropertyLevel.DEVICE;
            boolean longText = false;
            if ("Name".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "name";
                item = "Name";
            } else if ("Comments".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "comments";
                item = "Comments";
            } else if ("Contact".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "contact";
                item = "Contact";
            } else if ("Location".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "location";
                item = "Location";
            } else if ("Software version".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "softwareVersion";
                item = "Software version";
            } else if (driver != null) {
                for (DeviceDriver.AttributeDefinition attribute : driver.getAttributes()) {
                    if (!attribute.isSearchable() || attribute.getType() != DeviceDriver.AttributeType.LONGTEXT && attribute.getType() != DeviceDriver.AttributeType.TEXT || !attribute.getTitle().equalsIgnoreCase(tokens.get((int)0).text)) continue;
                    property = attribute.getName();
                    item = attribute.getTitle();
                    level = attribute.getLevel() == DeviceDriver.AttributeLevel.CONFIG ? AttributeExpression.PropertyLevel.CONFIGATTRIBUTE : AttributeExpression.PropertyLevel.DEVICEATTRIBUTE;
                    longText = attribute.getType() == DeviceDriver.AttributeType.LONGTEXT;
                    break;
                }
            }
            if (item == null) {
                return null;
            }
            if (tokens.size() != 3) {
                throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after text item at character %d.", tokens.get((int)0).position));
            }
            Token sign = tokens.get(1);
            Token value = tokens.get(2);
            if (sign.type != TokenType.IS && sign.type != TokenType.CONTAINS && sign.type != TokenType.STARTSWITH && sign.type != TokenType.STARTSWITH && sign.type != TokenType.ENDSWITH) {
                throw new Expression.FinderParseException(String.format("Invalid operator for a text item at character %d.", sign.position));
            }
            if (value.type != TokenType.QUOTE) {
                throw new Expression.FinderParseException(String.format("Parsing error, should be a quoted text, at character %d.", value.position));
            }
            TextAttributeExpression textExpr = new TextAttributeExpression(driver, item, property, level);
            textExpr.value = value.text;
            textExpr.sign = sign.type;
            textExpr.longText = longText;
            return textExpr;
        }
    }

    public static class EnumAttributeExpression
    extends AttributeExpression {
        private Object value;

        public EnumAttributeExpression(DeviceDriver driver, String item, String property, AttributeExpression.PropertyLevel propertyLevel) {
            super(driver, item, property, propertyLevel);
            this.sign = TokenType.IS;
        }

        @Override
        protected String getTextValue() {
            return "\"" + TokenType.escape(this.value.toString()) + "\"";
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = this.buildWhere("choice", "=", itemPrefix);
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            query.setParameter(itemPrefix, this.value);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            String property = null;
            String item = null;
            Class theEnum = null;
            AttributeExpression.PropertyLevel level = AttributeExpression.PropertyLevel.DEVICE;
            if ("Network class".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "networkClass";
                item = "Network class";
                theEnum = Device.NetworkClass.class;
            } else if ("Software level".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "softwareLevel";
                item = "Software level";
                theEnum = SoftwareRule.ConformanceLevel.class;
            } else if ("Status".equalsIgnoreCase(tokens.get((int)0).text)) {
                property = "status";
                item = "Status";
                theEnum = Device.Status.class;
            }
            if (item == null) {
                return null;
            }
            if (tokens.size() != 3) {
                throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after enum item at character %d.", tokens.get((int)0).position));
            }
            Token sign = tokens.get(1);
            Token value = tokens.get(2);
            if (sign.type != TokenType.IS) {
                throw new Expression.FinderParseException(String.format("Parsing error, invalid operator at position %d, should be 'IS'.", sign.position));
            }
            if (value.type != TokenType.QUOTE) {
                throw new Expression.FinderParseException(String.format("Parsing error, should be a quoted string at character %d.", value.position));
            }
            EnumAttributeExpression enumExpr = new EnumAttributeExpression(driver, item, property, level);
            try {
                Device.NetworkClass choice = Enum.valueOf(theEnum, value.text);
                enumExpr.value = choice;
            }
            catch (Exception e) {
                throw new Expression.FinderParseException(String.format("Invalid value for item %s at character %d.", item, value.position));
            }
            return enumExpr;
        }
    }

    public static class NumericAttributeExpression
    extends AttributeExpression {
        private Double value;

        public NumericAttributeExpression(DeviceDriver driver, String item, String property, AttributeExpression.PropertyLevel propertyLevel) {
            super(driver, item, property, propertyLevel);
        }

        @Override
        protected String getTextValue() {
            return this.value.toString();
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            switch (this.sign) {
                case GREATERTHAN: {
                    criteria.where = this.buildWhere("number", ">", itemPrefix);
                    break;
                }
                case LESSTHAN: {
                    criteria.where = this.buildWhere("number", "<", itemPrefix);
                    break;
                }
                default: {
                    criteria.where = this.buildWhere("number", "=", itemPrefix);
                }
            }
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            query.setDouble(itemPrefix, (double)this.value);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            String property = null;
            String item = null;
            AttributeExpression.PropertyLevel level = AttributeExpression.PropertyLevel.DEVICE;
            if (driver != null) {
                for (DeviceDriver.AttributeDefinition attribute : driver.getAttributes()) {
                    if (!attribute.isSearchable() || attribute.getType() != DeviceDriver.AttributeType.NUMERIC || !attribute.getTitle().equalsIgnoreCase(tokens.get((int)0).text)) continue;
                    property = attribute.getName();
                    item = attribute.getTitle();
                    if (attribute.getLevel() == DeviceDriver.AttributeLevel.CONFIG) {
                        level = AttributeExpression.PropertyLevel.CONFIGATTRIBUTE;
                        break;
                    }
                    level = AttributeExpression.PropertyLevel.DEVICEATTRIBUTE;
                    break;
                }
            }
            if (item == null) {
                return null;
            }
            if (tokens.size() != 3) {
                throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after numeric item at character %d.", tokens.get((int)0).position));
            }
            Token sign = tokens.get(1);
            Token value = tokens.get(2);
            if (sign.type != TokenType.IS && sign.type != TokenType.LESSTHAN && sign.type != TokenType.GREATERTHAN) {
                throw new Expression.FinderParseException(String.format("Parsing error, invalid numeric operator at position %d.", sign.position));
            }
            if (value.type != TokenType.NUMERIC) {
                throw new Expression.FinderParseException(String.format("Parsing error, should be a quoted date at character %d.", value.position));
            }
            NumericAttributeExpression numExpr = new NumericAttributeExpression(driver, item, property, level);
            try {
                numExpr.value = Double.parseDouble(value.text);
            }
            catch (NumberFormatException e) {
                throw new Expression.FinderParseException(String.format("Parsing error, uname to parse the numeric value at character %d.", value.position));
            }
            numExpr.sign = sign.type;
            return numExpr;
        }
    }

    public static abstract class AttributeExpression
    extends Expression {
        public String item;
        private String property;
        public TokenType sign;
        public PropertyLevel propertyLevel;

        public String buildWhere(String valueName, String operator2, String itemPrefix) {
            if (this.propertyLevel.nativeProperty) {
                return this.propertyLevel.prefix + this.property + " " + operator2 + " :" + itemPrefix;
            }
            return itemPrefix + "_" + this.propertyLevel.prefix + valueName + " " + operator2 + " :" + itemPrefix;
        }

        public AttributeExpression(DeviceDriver driver, String item, String property, PropertyLevel propertyLevel) {
            super(driver);
            this.item = item;
            this.property = property;
            this.propertyLevel = propertyLevel;
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 0 || tokens.get((int)0).type != TokenType.ITEM) {
                return null;
            }
            Expression textExpression = TextAttributeExpression.parse(tokens, driver);
            if (textExpression != null) {
                return textExpression;
            }
            Expression dateExpression = DateAttributeExpression.parse(tokens, driver);
            if (dateExpression != null) {
                return dateExpression;
            }
            Expression enumExpression = EnumAttributeExpression.parse(tokens, driver);
            if (enumExpression != null) {
                return enumExpression;
            }
            Expression numExpression = NumericAttributeExpression.parse(tokens, driver);
            if (numExpression != null) {
                return numExpression;
            }
            Expression binaryExpression = BinaryAttributeExpression.parse(tokens, driver);
            if (binaryExpression != null) {
                return binaryExpression;
            }
            throw new Expression.FinderParseException(String.format("Unknown configuration field [%s] at character %d.", tokens.get((int)0).text, tokens.get((int)0).position));
        }

        protected abstract String getTextValue();

        @Override
        public String toString() {
            return String.format("[%s] %s %s", new Object[]{this.item.toString(), this.sign, this.getTextValue()});
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            switch (this.propertyLevel) {
                case CONFIGATTRIBUTE: {
                    criteria.joins.add(String.format("c.attributes %s_ca with %s_ca.name = :%s_name", itemPrefix, itemPrefix, itemPrefix));
                }
                case CONFIG: {
                    criteria.whereJoins.add("d.lastConfig = c");
                    criteria.otherTables.add("Config c");
                    break;
                }
                case DEVICEATTRIBUTE: {
                    criteria.joins.add(String.format("d.attributes %s_da with %s_da.name = :%s_name", itemPrefix, itemPrefix, itemPrefix));
                }
            }
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            if (!this.propertyLevel.nativeProperty) {
                query.setString(itemPrefix + "_name", this.property);
            }
        }

        public static enum PropertyLevel {
            DEVICE("d.", true),
            CONFIG("c.", true),
            DEVICEATTRIBUTE("da.", false),
            CONFIGATTRIBUTE("ca.", false);

            private String prefix;
            private boolean nativeProperty;

            private PropertyLevel(String prefix, boolean nativeProperty) {
                this.prefix = prefix;
                this.nativeProperty = nativeProperty;
            }
        }
    }

    public static class Ipv6Expression
    extends Expression {
        public TokenType sign;
        public boolean withMask;
        public Network6Address target;

        public Ipv6Expression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.get((int)0).type == TokenType.IP) {
                if (tokens.size() != 3) {
                    throw new Expression.FinderParseException(String.format("Incomplete expression after IP at character %d.", tokens.get((int)0).position));
                }
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                int prefixLength = 128;
                String ip = "";
                Ipv6Expression ipExpr = new Ipv6Expression(driver);
                if (value.type == TokenType.IPV6) {
                    if (comparator.type != TokenType.IS) {
                        throw new Expression.FinderParseException(String.format("Invalid operator for simple IP at character %d.", comparator.position));
                    }
                    ip = value.text;
                    ipExpr.withMask = false;
                } else if (value.type == TokenType.SUBNETV6) {
                    if (comparator.type != TokenType.IS && comparator.type != TokenType.IN) {
                        throw new Expression.FinderParseException(String.format("Invalid operator for IP subnet at character %d.", comparator.position));
                    }
                    String[] values = value.text.split("/");
                    ip = values[0];
                    prefixLength = Integer.parseInt(values[1]);
                    ipExpr.withMask = true;
                }
                ipExpr.sign = comparator.type;
                try {
                    ipExpr.target = new Network6Address(ip, prefixLength);
                }
                catch (UnknownHostException e) {
                    throw new Expression.FinderParseException(String.format("Error while parsing IP address at character %d.", value.position));
                }
                return ipExpr;
            }
            return null;
        }

        @Override
        public String toString() {
            return String.format("[IP] %s %s", new Object[]{this.sign, this.withMask ? this.target.getPrefix() : this.target.getIp()});
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.joins.add("d.networkInterfaces ni");
            criteria.joins.add("ni.ip6Addresses ip6");
            criteria.where = this.sign == TokenType.IN ? (this.target.getPrefixLength() <= 64 ? String.format("(ip6.address1 >= :%s_0 and ip6.address1 <= :%s_1)", itemPrefix, itemPrefix) : String.format("(ip6.address2 >= :%s_0 and ip6.address2 <= :%s_1 and ip6.address1 = :%s_2)", itemPrefix, itemPrefix, itemPrefix)) : (this.withMask ? String.format("(ip6.address1 = :%s_0 and ip6.address2 = :%s_1 and ip6.prefixLength = :%s_2)", itemPrefix, itemPrefix, itemPrefix) : String.format("ip6.address1 = :%s_0 and ip6.address2 = :%s_1", itemPrefix, itemPrefix));
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            if (this.sign == TokenType.IN) {
                if (this.target.getPrefixLength() <= 64) {
                    long mask = -1L << 64 - this.target.getPrefixLength();
                    long min = this.target.getAddress1() & mask;
                    long max = this.target.getAddress1() | mask ^ 0xFFFFFFFFFFFFFFFFL;
                    query.setLong(itemPrefix + "_0", max > min ? min : max);
                    query.setLong(itemPrefix + "_1", max > min ? max : min);
                } else {
                    long mask = -1L << 128 - this.target.getPrefixLength();
                    long min = this.target.getAddress1() & mask;
                    long max = this.target.getAddress1() | mask ^ 0xFFFFFFFFFFFFFFFFL;
                    query.setLong(itemPrefix + "_0", max > min ? min : max);
                    query.setLong(itemPrefix + "_1", max > min ? max : min);
                    query.setLong(itemPrefix + "_2", this.target.getAddress1());
                }
            } else if (this.withMask) {
                query.setLong(itemPrefix + "_0", this.target.getAddress1());
                query.setLong(itemPrefix + "_1", this.target.getAddress2());
                query.setInteger(itemPrefix + "_2", this.target.getPrefixLength());
            } else {
                query.setLong(itemPrefix + "_0", this.target.getAddress1());
                query.setLong(itemPrefix + "_1", this.target.getAddress2());
            }
        }
    }

    public static class Ipv4Expression
    extends Expression {
        public TokenType sign;
        public boolean withMask;
        public Network4Address target;

        public Ipv4Expression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.get((int)0).type == TokenType.IP) {
                if (tokens.size() != 3) {
                    throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after IP at character %d.", tokens.get((int)0).position));
                }
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                int prefixLength = 32;
                String ip = "";
                Ipv4Expression ipExpr = new Ipv4Expression(driver);
                if (value.type == TokenType.IPV4) {
                    if (comparator.type != TokenType.IS) {
                        throw new Expression.FinderParseException(String.format("Invalid operator for simple IP at character %d.", comparator.position));
                    }
                    ip = value.text;
                    ipExpr.withMask = false;
                } else if (value.type == TokenType.SUBNETV4) {
                    if (comparator.type != TokenType.IS && comparator.type != TokenType.IN && comparator.type != TokenType.CONTAINS) {
                        throw new Expression.FinderParseException(String.format("Invalid operator for IP subnet at character %d.", comparator.position));
                    }
                    String[] values = value.text.split("/");
                    ip = values[0];
                    prefixLength = Integer.parseInt(values[1]);
                    ipExpr.withMask = true;
                    if (comparator.type == TokenType.CONTAINS && ipExpr.withMask) {
                        throw new Expression.FinderParseException(String.format("IP CONTAINS must be followed by a simple IP address (at character %d).", comparator.position));
                    }
                } else {
                    return null;
                }
                ipExpr.sign = comparator.type;
                try {
                    ipExpr.target = new Network4Address(ip, prefixLength);
                }
                catch (UnknownHostException e) {
                    throw new Expression.FinderParseException(String.format("Error while parsing IP address at character %d.", value.position));
                }
                return ipExpr;
            }
            return null;
        }

        @Override
        public String toString() {
            return String.format("[IP] %s %s", new Object[]{this.sign, this.withMask ? this.target.getPrefix() : this.target.getIp()});
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.joins.add("d.networkInterfaces ni");
            criteria.joins.add("ni.ip4Addresses ip4");
            criteria.where = this.sign == TokenType.IN ? String.format("((d.mgmtAddress.address >= :%s_0 and d.mgmtAddress.address <= :%s_1) or (ip4.address >= :%s_0 and ip4.address < :%s_1))", itemPrefix, itemPrefix, itemPrefix, itemPrefix) : (this.withMask ? String.format("((d.mgmtAddress.address = :%s_0 and d.mgmtAddress.prefixLength = :%s_1) or (ip4.address = :%s_0 and ip4.prefixLength = :%s_1))", itemPrefix, itemPrefix, itemPrefix, itemPrefix) : (this.sign == TokenType.CONTAINS ? String.format("(i4.prefixLength = 0 or (ip4.address < 0 and ip4.address - mod(ip4.address, power(2, 32 - ip4.prefixLength)) - power(2, 32 - ip4.prefixLength) <= :%s_0 and :%s_0 <= ip4.address - mod(ip4.address, power(2, 32 - ip4.prefixLength)) - 1) or (ip4.address >= 0 and ip4.address - mod(ip4.address, power(2, 32 - ip4.prefixLength)) <= :%s_0 and :%s_0 <= ip4.address -mod(ip4.address, power(2, 32 - ip4.prefixLength)) + power(2, 32 - ip4.prefixLength) - 1)", itemPrefix, itemPrefix, itemPrefix, itemPrefix) : String.format("(d.mgmtAddress.address = :%s_0 or ip4.address = :%s_0)", itemPrefix, itemPrefix)));
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            if (this.sign == TokenType.IN) {
                int min = this.target.getSubnetMin();
                int max = this.target.getSubnetMax();
                if (this.target.getPrefixLength() == 0) {
                    max = Integer.MAX_VALUE;
                    min = Integer.MIN_VALUE;
                }
                query.setInteger(itemPrefix + "_0", max > min ? min : max);
                query.setInteger(itemPrefix + "_1", max > min ? max : min);
            } else if (this.withMask) {
                query.setInteger(itemPrefix + "_0", this.target.getIntAddress());
                query.setInteger(itemPrefix + "_1", this.target.getPrefixLength());
            } else {
                query.setInteger(itemPrefix + "_0", this.target.getIntAddress());
            }
        }
    }

    public static class MacExpression
    extends Expression {
        public TokenType sign;
        public PhysicalAddress target;
        public int prefixLength;

        public MacExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.get((int)0).type == TokenType.MAC) {
                if (tokens.size() != 3) {
                    throw new Expression.FinderParseException(String.format("Incomplete or incorrect expression after MAC at character %d.", tokens.get((int)0).position));
                }
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                String mac = "";
                MacExpression macExpr = new MacExpression(driver);
                if (value.type == TokenType.MACADDRESS) {
                    if (comparator.type != TokenType.IS) {
                        throw new Expression.FinderParseException(String.format("Invalid operator for simple MAC at character %d.", comparator.position));
                    }
                    mac = value.text;
                } else if (value.type == TokenType.MACSUBNET) {
                    if (comparator.type != TokenType.IN) {
                        throw new Expression.FinderParseException(String.format("Invalid operator for MAC with mask at character %d.", comparator.position));
                    }
                    String[] values = value.text.split("/");
                    mac = values[0];
                    macExpr.prefixLength = Integer.parseInt(values[1]);
                } else {
                    return null;
                }
                macExpr.sign = comparator.type;
                try {
                    macExpr.target = new PhysicalAddress(mac);
                }
                catch (ParseException e) {
                    throw new Expression.FinderParseException(String.format("Error while parsing MAC address at character %d.", value.position));
                }
                return macExpr;
            }
            return null;
        }

        @Override
        public String toString() {
            String mac = this.target.toString();
            if (this.sign == TokenType.IN) {
                mac = mac + "/" + this.prefixLength;
            }
            return String.format("[MAC] %s %s", new Object[]{this.sign, mac});
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.joins.add("d.networkInterfaces ni");
            criteria.joins.add("ni.physicalAddress mac");
            criteria.where = this.sign == TokenType.IN ? String.format("(mac.address >= :%s_0 and mac.address <= :%s_1)", itemPrefix, itemPrefix) : String.format("mac.address = :%s_0", itemPrefix);
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            if (this.sign == TokenType.IN) {
                long mask = -1L << 48 - this.prefixLength;
                long min = this.target.getLongAddress() & mask;
                long max = this.target.getLongAddress() | mask ^ 0xFFFFFFFFFFFFFFFFL;
                query.setLong(itemPrefix + "_0", min);
                query.setLong(itemPrefix + "_1", max);
            } else {
                query.setLong(itemPrefix + "_0", this.target.getLongAddress());
            }
        }
    }

    public static class NullExpression
    extends Expression {
        public NullExpression(DeviceDriver driver) {
            super(driver);
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = "1 = 1";
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
        }
    }

    public static class DomainExpression
    extends Expression {
        private Long value;

        public DomainExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.DOMAIN) {
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                if (comparator.type != TokenType.IS) {
                    throw new Expression.FinderParseException(String.format("Invalid operator after DOMAIN at character %d.", comparator.position));
                }
                if (value.type != TokenType.NUMERIC) {
                    throw new Expression.FinderParseException(String.format("Expecting a numeric value for DOMAIN at character %d.", value.position));
                }
                DomainExpression domExpr = new DomainExpression(driver);
                domExpr.value = Long.parseLong(value.text);
                return domExpr;
            }
            return null;
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = String.format("d.mgmtDomain.id = :%s", itemPrefix);
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            query.setLong(itemPrefix, (long)this.value);
        }

        @Override
        public String toString() {
            return String.format("[%s] %s %d", new Object[]{TokenType.DOMAIN, TokenType.IS, this.value});
        }
    }

    public static class DeviceExpression
    extends Expression {
        private Long value;

        public DeviceExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.DEVICE) {
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                if (comparator.type != TokenType.IS) {
                    throw new Expression.FinderParseException(String.format("Invalid operator after DEVICE at character %d.", comparator.position));
                }
                if (value.type != TokenType.NUMERIC) {
                    throw new Expression.FinderParseException(String.format("Expecting a numeric value for DEVICE at character %d.", value.position));
                }
                DeviceExpression devExpr = new DeviceExpression(driver);
                devExpr.value = Long.parseLong(value.text);
                return devExpr;
            }
            return null;
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = String.format("d.id = :%s", itemPrefix);
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            query.setLong(itemPrefix, (long)this.value);
        }

        @Override
        public String toString() {
            return String.format("[%s] %s %d", new Object[]{TokenType.DEVICE, TokenType.IS, this.value});
        }
    }

    public static class InterfaceExpression
    extends Expression {
        public TokenType sign;
        private String value;

        public InterfaceExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.INTERFACE) {
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                switch (comparator.type) {
                    case IS: 
                    case CONTAINS: 
                    case STARTSWITH: 
                    case ENDSWITH: {
                        if (value.type == TokenType.QUOTE) {
                            InterfaceExpression modExpr = new InterfaceExpression(driver);
                            modExpr.sign = comparator.type;
                            modExpr.value = TokenType.unescape(value.text);
                            return modExpr;
                        }
                        throw new Expression.FinderParseException(String.format("Expecting a quoted string for INTERFACE at character %d.", value.position));
                    }
                }
                throw new Expression.FinderParseException(String.format("Invalid operator after INTERFACE at character %d.", comparator.position));
            }
            return null;
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = String.format("(ni.interfaceName like :%s or ni.description like :%s)", itemPrefix, itemPrefix);
            criteria.joins.add("d.networkInterfaces ni");
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            String target;
            super.setVariables(query, itemPrefix);
            switch (this.sign) {
                case CONTAINS: {
                    target = "%" + this.value + "%";
                    break;
                }
                case STARTSWITH: {
                    target = this.value + "%";
                    break;
                }
                case ENDSWITH: {
                    target = "%" + this.value;
                    break;
                }
                default: {
                    target = this.value;
                }
            }
            query.setString(itemPrefix, target);
        }

        @Override
        public String toString() {
            return String.format("[%s] %s \"%s\"", new Object[]{TokenType.INTERFACE, this.sign, TokenType.escape(this.value)});
        }
    }

    public static class ModuleExpression
    extends Expression {
        public TokenType sign;
        private String value;

        public ModuleExpression(DeviceDriver driver) {
            super(driver);
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.MODULE) {
                Token comparator = tokens.get(1);
                Token value = tokens.get(2);
                switch (comparator.type) {
                    case IS: 
                    case CONTAINS: 
                    case STARTSWITH: 
                    case ENDSWITH: {
                        if (value.type == TokenType.QUOTE) {
                            ModuleExpression modExpr = new ModuleExpression(driver);
                            modExpr.sign = comparator.type;
                            modExpr.value = TokenType.unescape(value.text);
                            return modExpr;
                        }
                        throw new Expression.FinderParseException(String.format("Expecting a quoted string for MODULE at character %d.", value.position));
                    }
                }
                throw new Expression.FinderParseException(String.format("Invalid operator after MODULE at character %d.", comparator.position));
            }
            return null;
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            criteria.where = String.format("(m.serialNumber like :%s or m.partNumber like :%s)", itemPrefix, itemPrefix);
            criteria.joins.add("d.modules m");
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            String target;
            super.setVariables(query, itemPrefix);
            switch (this.sign) {
                case CONTAINS: {
                    target = "%" + this.value + "%";
                    break;
                }
                case STARTSWITH: {
                    target = this.value + "%";
                    break;
                }
                case ENDSWITH: {
                    target = "%" + this.value;
                    break;
                }
                default: {
                    target = this.value;
                }
            }
            query.setString(itemPrefix, target);
        }

        @Override
        public String toString() {
            return String.format("[%s] %s \"%s\"", new Object[]{TokenType.MODULE, this.sign, TokenType.escape(this.value)});
        }
    }

    public static class OrOperator
    extends Expression {
        public List<Expression> children = new ArrayList<Expression>();

        public OrOperator(DeviceDriver driver) {
            super(driver);
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            buffer.append("(");
            for (Expression child : this.children) {
                if (i++ > 0) {
                    buffer.append(") ").append((Object)TokenType.OR).append(" (");
                }
                buffer.append(child.toString());
            }
            buffer.append(")");
            return buffer.toString();
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            int i = 0;
            criteria.where = "(";
            for (Expression child : this.children) {
                FinderCriteria childCriteria = child.buildHqlString(itemPrefix + "_" + i);
                if (i > 0) {
                    criteria.where = criteria.where + " or ";
                }
                criteria.where = criteria.where + childCriteria.where;
                criteria.joins.addAll(childCriteria.joins);
                criteria.otherTables.addAll(childCriteria.otherTables);
                criteria.whereJoins.addAll(childCriteria.whereJoins);
                ++i;
            }
            criteria.where = criteria.where + ")";
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            int i = 0;
            for (Expression child : this.children) {
                child.setVariables(query, itemPrefix + "_" + i);
                ++i;
            }
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            ListIterator<Token> t = tokens.listIterator();
            OrOperator orExpr = new OrOperator(driver);
            ArrayList<Token> tokenBuffer = new ArrayList<Token>();
            while (t.hasNext()) {
                Token token = t.next();
                if (token.type == TokenType.OR) {
                    if (tokenBuffer.size() == 0) {
                        throw new Expression.FinderParseException(String.format("Parsing error, nothing before OR at character %d.", token.position));
                    }
                    orExpr.children.add(Expression.parse(tokenBuffer, driver));
                    tokenBuffer.clear();
                    continue;
                }
                tokenBuffer.add(token);
            }
            if (orExpr.children.size() > 0) {
                if (tokenBuffer.size() == 0) {
                    throw new Expression.FinderParseException("Parsing error, nothing after last OR.");
                }
                orExpr.children.add(Expression.parse(tokenBuffer, driver));
                return orExpr;
            }
            return null;
        }
    }

    public static class AndOperator
    extends Expression {
        public List<Expression> children = new ArrayList<Expression>();

        public AndOperator(DeviceDriver driver) {
            super(driver);
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            buffer.append("(");
            for (Expression child : this.children) {
                if (i++ > 0) {
                    buffer.append(") ").append((Object)TokenType.AND).append(" (");
                }
                buffer.append(child.toString());
            }
            buffer.append(")");
            return buffer.toString();
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = super.buildHqlString(itemPrefix);
            int i = 0;
            criteria.where = "(";
            for (Expression child : this.children) {
                FinderCriteria childCriteria = child.buildHqlString(itemPrefix + "_" + i);
                if (i > 0) {
                    criteria.where = criteria.where + " and ";
                }
                criteria.where = criteria.where + childCriteria.where;
                criteria.joins.addAll(childCriteria.joins);
                criteria.otherTables.addAll(childCriteria.otherTables);
                criteria.whereJoins.addAll(childCriteria.whereJoins);
                ++i;
            }
            criteria.where = criteria.where + ")";
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            int i = 0;
            for (Expression child : this.children) {
                child.setVariables(query, itemPrefix + "_" + i);
                ++i;
            }
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            ListIterator<Token> t = tokens.listIterator();
            AndOperator andExpr = new AndOperator(driver);
            ArrayList<Token> tokenBuffer = new ArrayList<Token>();
            while (t.hasNext()) {
                Token token = t.next();
                if (token.type == TokenType.AND) {
                    if (tokenBuffer.size() == 0) {
                        throw new Expression.FinderParseException(String.format("Parsing error, nothing before AND at character %d.", token.position));
                    }
                    andExpr.children.add(Expression.parse(tokenBuffer, driver));
                    tokenBuffer.clear();
                    continue;
                }
                tokenBuffer.add(token);
            }
            if (andExpr.children.size() > 0) {
                if (tokenBuffer.size() == 0) {
                    throw new Expression.FinderParseException("Parsing error, nothing after last AND.");
                }
                andExpr.children.add(Expression.parse(tokenBuffer, driver));
                return andExpr;
            }
            return null;
        }
    }

    public static class NotOperator
    extends Expression {
        public Expression child;

        public NotOperator(DeviceDriver driver) {
            super(driver);
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append((Object)TokenType.NOT).append(" ").append(this.child.toString());
            return buffer.toString();
        }

        @Override
        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = this.child.buildHqlString(itemPrefix + "_0");
            criteria.where = "not (" + criteria.where + ")";
            return criteria;
        }

        @Override
        public void setVariables(Query query, String itemPrefix) {
            super.setVariables(query, itemPrefix);
            this.child.setVariables(query, itemPrefix + "_0");
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws Expression.FinderParseException {
            ListIterator<Token> t = tokens.listIterator();
            while (t.hasNext()) {
                boolean first = !t.hasPrevious();
                Token token = t.next();
                if (token.type != TokenType.NOT) continue;
                if (!first) {
                    throw new Expression.FinderParseException(String.format("Parsing error, misplaced NOT at character %d.", token.position));
                }
                NotOperator notExpr = new NotOperator(driver);
                t.previous();
                t.remove();
                notExpr.child = Expression.parse(tokens, driver);
                return notExpr;
            }
            return null;
        }
    }

    public static abstract class Expression {
        protected DeviceDriver driver;

        public Expression(DeviceDriver driver) {
            this.driver = driver;
        }

        public abstract String toString();

        public static List<Token> tokenize(String text) throws FinderParseException {
            ArrayList<Token> tokens = new ArrayList<Token>();
            String buffer = text.trim();
            int position = 1;
            block0: while (buffer.length() > 0) {
                for (TokenType type : TokenType.values()) {
                    Matcher matcher = type.pattern.matcher(buffer);
                    if (!matcher.find()) continue;
                    String value = matcher.group(1);
                    if (type == TokenType.QUOTE) {
                        value = TokenType.unescape(value);
                    }
                    Token token = new Token(value, position, type);
                    tokens.add(token);
                    buffer = buffer.substring(matcher.end());
                    position += matcher.end();
                    continue block0;
                }
                throw new FinderParseException(String.format("Parsing error, unknown token at character %d.", position));
            }
            return tokens;
        }

        public static Expression parse(List<Token> tokens, DeviceDriver driver) throws FinderParseException {
            ListIterator<Token> t = tokens.listIterator();
            int brackets = 0;
            ArrayList<Token> subTokens = new ArrayList<Token>();
            while (t.hasNext()) {
                Token token = t.next();
                if (token.type == TokenType.BRACKETIN) {
                    if (++brackets > 1) {
                        subTokens.add(token);
                    }
                    t.remove();
                    continue;
                }
                if (token.type == TokenType.BRACKETOUT) {
                    if (--brackets < 0) {
                        throw new FinderParseException("Parsing error, unexpected closing bracket.");
                    }
                    if (brackets == 0) {
                        token.type = TokenType.ITEM;
                        token.expression = Expression.parse(subTokens, driver);
                        subTokens.clear();
                        continue;
                    }
                    subTokens.add(token);
                    t.remove();
                    continue;
                }
                if (brackets <= 0) continue;
                subTokens.add(token);
                t.remove();
            }
            if (brackets > 0) {
                throw new FinderParseException("Parsing error, missing closing bracket.");
            }
            if (tokens.size() == 0) {
                throw new FinderParseException("Parsing error, no more token to parse");
            }
            if (tokens.size() == 1 && tokens.get((int)0).expression != null) {
                return tokens.get((int)0).expression;
            }
            Expression expr = OrOperator.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = AndOperator.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = NotOperator.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = ModuleExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = InterfaceExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = VrfExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = VirtualNameExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = DeviceExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = DomainExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = Ipv4Expression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = Ipv6Expression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = MacExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            expr = AttributeExpression.parse(tokens, driver);
            if (expr != null) {
                return expr;
            }
            throw new FinderParseException(String.format("Parsing error at character %d.", tokens.get((int)0).position));
        }

        public FinderCriteria buildHqlString(String itemPrefix) {
            FinderCriteria criteria = new FinderCriteria();
            return criteria;
        }

        public void setVariables(Query query, String itemPrefix) {
            if (this.driver != null) {
                query.setString("driver", this.driver.getName());
            }
        }

        public static class FinderParseException
        extends Exception {
            private static final long serialVersionUID = -4102690686882816860L;

            FinderParseException(String message) {
                super(message);
            }
        }
    }

    public static class Token {
        public int position;
        public String text;
        public TokenType type;
        public Expression expression = null;

        public Token(String text, int position, TokenType type) {
            this.position = position;
            this.text = text;
            this.type = type;
        }
    }

    public static enum TokenType {
        AND("(?i)^\\s*(and)\\b", "AND"),
        OR("(?i)^\\s*(or)\\b", "OR"),
        NOT("(?i)^\\s*(not)\\b", "NOT"),
        IS("(?i)^\\s*(is)\\b", "IS"),
        IN("(?i)^\\s*(in)\\b", "IN"),
        BRACKETIN("^\\s*(\\()", "("),
        BRACKETOUT("^\\s*(\\))", ")"),
        CONTAINS("(?i)^\\s*(contains)\\b", "CONTAINS"),
        STARTSWITH("(?i)^\\s*(startswith)\\b", "STARTSWITH"),
        ENDSWITH("(?i)^\\s*(endswith)\\b", "ENDSWITH"),
        BEFORE("(?i)^\\s*(before)\\b", "BEFORE"),
        AFTER("(?i)^\\s*(after)\\b", "AFTER"),
        LESSTHAN("(?i)^\\s*(lessthan)\\b", "LESSTHAN"),
        GREATERTHAN("(?i)^\\s*(greaterthan)\\b", "GREATERTHAN"),
        TRUE("(?i)^\\s*(true)\\b", "TRUE"),
        FALSE("(?i)^\\s*(false)\\b", "FALSE"),
        IP("(?i)^\\s*(\\[ip\\])", "IP"),
        MAC("(?i)^\\s*(\\[mac\\])", "MAC"),
        MODULE("(?i)^\\s*(\\[module\\])", "MODULE"),
        INTERFACE("(?i)^\\s*(\\[interface\\])", "INTERFACE"),
        VRF("(?i)^\\s*(\\[vrf\\])", "VRF"),
        VIRTUALNAME("(?i)^\\s*(\\[virtual name\\])", "VIRTUAL NAME"),
        DEVICE("(?i)^\\s*(\\[device\\])", "DEVICE"),
        DOMAIN("(?i)^\\s*(\\[domain\\])", "DOMAIN"),
        SUBNETV4("^\\s*(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/(1[0-9]|2[0-9]|3[0-2]|[0-9]))", ""),
        IPV4("^\\s*(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))", ""),
        SUBNETV6("^\\s*(((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b).){3}(b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b))|(([0-9A-Fa-f]{1,4}:){0,5}:((b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b).){3}(b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b))|(::([0-9A-Fa-f]{1,4}:){0,5}((b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b).){3}(b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))/(1[01][0-9]|12[0-8]|[0-9][0-9]|[0-9]))", ""),
        IPV6("^\\s*((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b).){3}(b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b))|(([0-9A-Fa-f]{1,4}:){0,5}:((b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b).){3}(b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b))|(::([0-9A-Fa-f]{1,4}:){0,5}((b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b).){3}(b((25[0-5])|(1d{2})|(2[0-4]d)|(d{1,2}))b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))", ""),
        MACSUBNET("^\\s*([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}/(4[0-8]|[1-3][0-9]|[0-9]))", ""),
        MACADDRESS("^\\s*([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4})", ""),
        QUOTE("^\\s*\"(.*?)(?<!\\\\)\"", ""),
        NUMERIC("^\\s*([0-9\\.]+)\\b", ""),
        ITEM("^\\s*\\[([A-Za-z\\-0-9 \\(\\)]+)\\]", "");

        private Pattern pattern;
        private String command;

        private TokenType(String pattern, String command) {
            this.pattern = Pattern.compile(pattern);
            this.command = command;
        }

        public String toString() {
            return this.command;
        }

        public static String escape(String text) {
            return text.replaceAll("\"", "\\\"");
        }

        public static String unescape(String text) {
            return text.replaceAll("\\\\\\\"", "\"");
        }
    }
}

