/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.compliance;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.compliance.Rule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Policy {
    private long id;
    private String name;
    private Set<Rule> rules = new HashSet<Rule>();
    private DeviceGroup targetGroup;

    protected Policy() {
    }

    public Policy(String name, DeviceGroup deviceGroup) {
        this.name = name;
        this.targetGroup = deviceGroup;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        rule.setPolicy(this);
    }

    public void check(Session session) {
        if (this.targetGroup == null) {
            return;
        }
        for (Device device : this.targetGroup.getCachedDevices()) {
            this.check(device, session);
        }
    }

    public void check(Device device, Session session) {
        for (Rule rule : this.rules) {
            rule.check(device, session);
        }
    }

    @Id
    @GeneratedValue
    @XmlElement
    public long getId() {
        return this.id;
    }

    @NaturalId(mutable=true)
    @XmlElement
    public String getName() {
        return this.name;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="policy")
    public Set<Rule> getRules() {
        return this.rules;
    }

    @ManyToOne
    @XmlElement
    public DeviceGroup getTargetGroup() {
        return this.targetGroup;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRules(Set<Rule> rules) {
        this.rules = rules;
    }

    public void setTargetGroup(DeviceGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Policy other = (Policy)obj;
        return this.id == other.id;
    }
}

