/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.util.RadiusUtils;

public abstract class RadiusResponse
extends RadiusPacket {
    private static final long serialVersionUID = 1L;

    public RadiusResponse() {
    }

    public RadiusResponse(int id, AttributeList list) {
        super(list);
        this.setIdentifier(id);
    }

    public boolean verifyAuthenticator(byte[] requestAuthenticator, String sharedSecret) {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        RadiusFormat.getInstance().packAttributeList(this.getAttributes(), buffer, true);
        byte[] hash = RadiusUtils.makeRFC2865ResponseAuthenticator(sharedSecret, (byte)(this.getCode() & 0xFF), (byte)(this.getIdentifier() & 0xFF), (short)(buffer.position() + 20), requestAuthenticator, buffer.array(), buffer.position());
        return Arrays.equals(hash, this.getAuthenticator());
    }

    public void generateAuthenticator(byte[] requestAuthenticator, String sharedSecret) {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        RadiusFormat.getInstance().packAttributeList(this.getAttributes(), buffer, true);
        this.setAuthenticator(RadiusUtils.makeRFC2865ResponseAuthenticator(sharedSecret, (byte)(this.getCode() & 0xFF), (byte)(this.getIdentifier() & 0xFF), (short)(buffer.position() + 20), requestAuthenticator, buffer.array(), buffer.position()));
    }
}

