/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JPanel;
import org.netbeans.modules.git.ui.diff.Bundle;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;

abstract class DiffToRevisionKind {
    private final String id;
    private final PropertyChangeSupport support;
    private boolean valid;

    public DiffToRevisionKind(String id) {
        this.id = id;
        this.support = new PropertyChangeSupport(this);
    }

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract JPanel getPanel();

    public abstract Revision getTreeFirst();

    public abstract Revision getTreeSecond();

    public final String getId() {
        return this.id;
    }

    public final void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    protected final void setValid(boolean valid) {
        boolean oldValid = this.valid;
        this.valid = valid;
        this.support.firePropertyChange("diffto.propValid", oldValid, valid);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public static class BaseToRevisionKind
    extends DiffToRevisionKind {
        private final RevisionDialogController revisionPicker;

        public BaseToRevisionKind(File repository, Revision preselectedRevision) {
            super(BaseToRevisionKind.class.getName());
            this.revisionPicker = new RevisionDialogController(repository, new File[0], preselectedRevision.getRevision());
            this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "RevisionDialogController.valid") {
                        BaseToRevisionKind.this.setValid(Boolean.TRUE.equals(evt.getNewValue()));
                    }
                }
            });
            this.setValid(true);
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_DiffToRevisionKind_baseToRevision_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_DiffToRevisionKind_baseToRevision_description();
        }

        @Override
        public JPanel getPanel() {
            return this.revisionPicker.getPanel();
        }

        @Override
        public Revision getTreeFirst() {
            return this.revisionPicker.getRevision();
        }

        @Override
        public Revision getTreeSecond() {
            return Revision.HEAD;
        }
    }

    public static class LocalToRevisionKind
    extends DiffToRevisionKind {
        private final RevisionDialogController revisionPicker;

        public LocalToRevisionKind(File repository, Revision preselectedRevision) {
            super(LocalToRevisionKind.class.getName());
            this.revisionPicker = new RevisionDialogController(repository, new File[0], preselectedRevision.getRevision());
            this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "RevisionDialogController.valid") {
                        LocalToRevisionKind.this.setValid(Boolean.TRUE.equals(evt.getNewValue()));
                    }
                }
            });
            this.setValid(true);
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_DiffToRevisionKind_localToRevision_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_DiffToRevisionKind_localToRevision_description();
        }

        @Override
        public JPanel getPanel() {
            return this.revisionPicker.getPanel();
        }

        @Override
        public Revision getTreeFirst() {
            return this.revisionPicker.getRevision();
        }

        @Override
        public Revision getTreeSecond() {
            return Revision.LOCAL;
        }
    }

    public static class LocalToBaseKind
    extends DiffToRevisionKind {
        private final JPanel basicPanel = new JPanel();

        public LocalToBaseKind() {
            super(LocalToBaseKind.class.getName());
            this.setValid(true);
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_DiffToRevisionKind_localToBase_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_DiffToRevisionKind_localToBase_description();
        }

        @Override
        public JPanel getPanel() {
            return this.basicPanel;
        }

        @Override
        public Revision getTreeFirst() {
            return Revision.HEAD;
        }

        @Override
        public Revision getTreeSecond() {
            return Revision.LOCAL;
        }
    }
}

