/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.html.knockout.api.KODataBindTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class KODataBindLexer
implements Lexer<KODataBindTokenId> {
    private final LexerInput input;
    private final TokenFactory<KODataBindTokenId> tokenFactory;
    private State state;
    private byte parenDepth = 0;
    private boolean inSingleQuotedString;
    private boolean inDoubleQuotedString;

    public Object state() {
        return new CompoundState(this.state, this.parenDepth, this.inSingleQuotedString, this.inDoubleQuotedString);
    }

    public KODataBindLexer(LexerRestartInfo<KODataBindTokenId> info) {
        this.tokenFactory = info.tokenFactory();
        this.input = info.input();
        if (info.state() == null) {
            this.state = State.INIT;
        } else {
            CompoundState compoundState = (CompoundState)info.state();
            this.state = compoundState.state;
            this.parenDepth = compoundState.parenDepth;
        }
    }

    public Token<KODataBindTokenId> nextToken() {
        block24: while (true) {
            int c;
            if ((c = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.state) {
                case INIT: {
                    if (Character.isLetter(c) || c == 95 || c == 36) {
                        this.state = State.IN_KEY;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        this.input.backup(1);
                        this.state = State.IN_WS_BEFORE_KEY;
                        break;
                    }
                    return this.tokenFactory.createToken((TokenId)KODataBindTokenId.ERROR);
                }
                case IN_WS_BEFORE_KEY: {
                    if (Character.isLetter(c) || c == 95 || c == 36) {
                        this.state = State.IN_KEY;
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)KODataBindTokenId.WS);
                    }
                    if (Character.isWhitespace(c)) continue block24;
                    this.state = State.INIT;
                    return this.tokenFactory.createToken((TokenId)KODataBindTokenId.ERROR);
                }
                case IN_KEY: {
                    if (Character.isLetter(c) || Character.isDigit(c) || c == 95 || c == 36) continue block24;
                    if (c == 58) {
                        this.state = State.AFTER_KEY;
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)KODataBindTokenId.KEY);
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = State.WS_AFTER_KEY;
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)KODataBindTokenId.KEY);
                    }
                    this.state = State.INIT;
                    return this.tokenFactory.createToken((TokenId)KODataBindTokenId.ERROR);
                }
                case AFTER_KEY: {
                    assert (c == 58);
                    this.state = State.IN_VALUE;
                    return this.tokenFactory.createToken((TokenId)KODataBindTokenId.COLON);
                }
                case WS_AFTER_KEY: {
                    if (Character.isWhitespace(c)) continue block24;
                    if (c == 58) {
                        this.state = State.AFTER_KEY;
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)KODataBindTokenId.WS);
                    }
                    this.state = State.INIT;
                    return this.tokenFactory.createToken((TokenId)KODataBindTokenId.ERROR);
                }
                case IN_VALUE: {
                    switch (c) {
                        case 44: {
                            if (this.parenDepth != 0 || this.inSingleQuotedString || this.inDoubleQuotedString) continue block24;
                            this.state = State.AFTER_VALUE;
                            this.input.backup(1);
                            if (this.input.readLength() <= 0) break block0;
                            return this.tokenFactory.createToken((TokenId)KODataBindTokenId.VALUE);
                        }
                        case 40: 
                        case 91: 
                        case 123: {
                            this.parenDepth = (byte)(this.parenDepth + 1);
                            break block0;
                        }
                        case 41: 
                        case 93: 
                        case 125: {
                            this.parenDepth = (byte)(this.parenDepth - 1);
                            break block0;
                        }
                        case 39: {
                            this.inSingleQuotedString = !this.inSingleQuotedString;
                            break block0;
                        }
                        case 34: {
                            this.inDoubleQuotedString = !this.inDoubleQuotedString;
                            break block0;
                        }
                        case 92: {
                            if (!this.inSingleQuotedString && !this.inDoubleQuotedString) continue block24;
                            this.state = State.IN_VALUE_ESCAPE;
                            break block0;
                        }
                    }
                    break;
                }
                case IN_VALUE_ESCAPE: {
                    this.state = State.IN_VALUE;
                    break;
                }
                case AFTER_VALUE: {
                    assert (c == 44);
                    this.state = State.INIT;
                    return this.tokenFactory.createToken((TokenId)KODataBindTokenId.COMMA);
                }
            }
        }
        this.input.backup(1);
        switch (this.state) {
            case INIT: {
                if (this.input.readLength() != 0) break;
                return null;
            }
            case IN_WS_BEFORE_KEY: {
                return this.tokenFactory.createToken((TokenId)KODataBindTokenId.WS);
            }
            case IN_KEY: 
            case AFTER_KEY: 
            case WS_AFTER_KEY: {
                return this.tokenFactory.createToken((TokenId)KODataBindTokenId.KEY);
            }
            case IN_VALUE: 
            case IN_VALUE_ESCAPE: 
            case AFTER_VALUE: {
                return this.tokenFactory.createToken((TokenId)KODataBindTokenId.VALUE);
            }
        }
        return null;
    }

    public void release() {
    }

    private static class CompoundState {
        private State state;
        private byte parenDepth;
        private boolean inSingleQuotedString;
        private boolean inDoubleQuotedString;

        public CompoundState(State state, byte parenDepth, boolean inSingleQuotedString, boolean inDoubleQuotedString) {
            this.state = state;
            this.parenDepth = parenDepth;
            this.inSingleQuotedString = inSingleQuotedString;
            this.inDoubleQuotedString = inDoubleQuotedString;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.state != null ? this.state.hashCode() : 0);
            hash = 11 * hash + this.parenDepth;
            hash = 11 * hash + (this.inSingleQuotedString ? 1 : 0);
            hash = 11 * hash + (this.inDoubleQuotedString ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundState other = (CompoundState)obj;
            if (this.state != other.state) {
                return false;
            }
            if (this.parenDepth != other.parenDepth) {
                return false;
            }
            if (this.inSingleQuotedString != other.inSingleQuotedString) {
                return false;
            }
            return this.inDoubleQuotedString == other.inDoubleQuotedString;
        }
    }

    private static enum State {
        INIT,
        IN_WS_BEFORE_KEY,
        IN_KEY,
        AFTER_KEY,
        WS_AFTER_KEY,
        IN_VALUE,
        IN_VALUE_ESCAPE,
        AFTER_VALUE;

    }
}

