/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.options;

import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class Nette2Options {
    private static final String PREFERENCES_PATH = "nette2";
    private static final Nette2Options INSTANCE = new Nette2Options();
    private static final String SANDBOX = "sandbox";
    private static final String NETTE_DIRECTORY = "nette-directory";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public static Nette2Options getInstance() {
        return INSTANCE;
    }

    private Nette2Options() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                Nette2Options.this.changeSupport.fireChange();
            }
        });
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Nette2Options.class).node(PREFERENCES_PATH);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getSandbox() {
        return this.getPreferences().get(SANDBOX, null);
    }

    public void setSandbox(String sandbox) {
        this.getPreferences().put(SANDBOX, sandbox);
    }

    public String getNetteDirectory() {
        return this.getPreferences().get(NETTE_DIRECTORY, null);
    }

    public void setNetteDirectory(String netteDirectory) {
        this.getPreferences().put(NETTE_DIRECTORY, netteDirectory);
    }
}

