/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.ui.actions.DebugMainProjectAction;
import org.netbeans.modules.debugger.ui.actions.GestureSubmitter;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConnectorPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    public static final String PROP_TYPE = "type";
    private static final String FIRST_ATTACH_TYPE = "org.netbeans.modules.debugger.jpda.ui.JPDAAttachType";
    private static final String ERGONOMICS_CLASS = "org.netbeans.modules.ide.ergonomics";
    private static final int TOTAL_SLOTS = 4;
    private JComboBox cbAttachTypes;
    private boolean doNotListen;
    private List<AttachType> attachTypes;
    private Controller controller;
    private AttachType currentAttachType;
    private HelpCtx help = HelpCtx.DEFAULT_HELP;

    public ConnectorPanel() {
        AttachType at;
        int i;
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectorPanel.class, (String)"ACSD_ConnectorPanel"));
        this.cbAttachTypes = new JComboBox();
        this.cbAttachTypes.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectorPanel.class, (String)"ACSD_CTL_Connect_through"));
        List types = DebuggerManager.getDebuggerManager().lookup(null, AttachType.class);
        this.attachTypes = new ArrayList<AttachType>(types);
        for (AttachType att : types) {
            if (att.getTypeDisplayName() != null) continue;
            this.attachTypes.remove(att);
        }
        String defaultAttachTypeName = Properties.getDefault().getProperties("debugger").getString("last_attach_type", null);
        int defaultIndex = 0;
        int k = this.attachTypes.size();
        Collections.sort(this.attachTypes, new Comparator<AttachType>(){

            @Override
            public int compare(AttachType at1, AttachType at2) {
                if (ConnectorPanel.FIRST_ATTACH_TYPE.equals(at1.getClass().getName())) {
                    return -1;
                }
                if (ConnectorPanel.FIRST_ATTACH_TYPE.equals(at2.getClass().getName())) {
                    return 1;
                }
                return at1.getTypeDisplayName().compareTo(at2.getTypeDisplayName());
            }
        });
        for (i = 0; i < k; ++i) {
            at = this.attachTypes.get(i);
            String displayName = at.getTypeDisplayName();
            this.cbAttachTypes.addItem(displayName);
            if (!displayName.equals(defaultAttachTypeName)) continue;
            defaultIndex = i;
        }
        i = defaultIndex;
        while (i < k) {
            at = this.attachTypes.get(i);
            if (!at.getClass().getName().startsWith(ERGONOMICS_CLASS)) {
                defaultIndex = i;
                break;
            }
            if (++i == k) {
                i = 0;
            }
            if (i != defaultIndex) continue;
            break;
        }
        this.cbAttachTypes.setActionCommand("SwitchMe!");
        this.cbAttachTypes.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(11, 11, 0, 10));
        this.refresh(defaultIndex);
    }

    private void refresh(int index) {
        JLabel cbLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)cbLabel, (String)NbBundle.getMessage(ConnectorPanel.class, (String)"CTL_Connect_through"));
        cbLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectorPanel.class, (String)"ACSD_CTL_Connect_through"));
        cbLabel.setLabelFor(this.cbAttachTypes);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 6, 6);
        this.add((Component)cbLabel, c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 3, 6, 0);
        this.doNotListen = true;
        if (this.cbAttachTypes.getItemCount() > 0) {
            this.cbAttachTypes.setSelectedIndex(index);
        }
        this.doNotListen = false;
        this.add((Component)this.cbAttachTypes, c);
        c.insets = new Insets(0, 0, 6, 0);
        this.add((Component)new JSeparator(), c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        if (this.cbAttachTypes.getItemCount() == 0) {
            JLabel noAttachType = new JLabel(NbBundle.getMessage(ConnectorPanel.class, (String)"CTL_Attach_Types_Not_Found"));
            this.add((Component)noAttachType, c);
        } else {
            AttachType attachType = this.attachTypes.get(index);
            JComponent customizer = attachType.getCustomizer();
            this.help = HelpCtx.findHelp((Component)customizer);
            this.controller = attachType.getController();
            if (this.controller == null && customizer instanceof Controller) {
                Exceptions.printStackTrace((Throwable)new IllegalStateException("FIXME: JComponent " + customizer + " must not implement Controller interface!"));
                this.controller = (Controller)((Object)customizer);
            }
            this.firePropertyChange(PROP_TYPE, null, customizer);
            this.currentAttachType = attachType;
            this.add((Component)customizer, c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.doNotListen) {
            return;
        }
        if (e.getActionCommand().equals("SwitchMe!")) {
            // empty if block
        }
        this.removeAll();
        this.refresh(((JComboBox)e.getSource()).getSelectedIndex());
        Container w = this.getParent();
        while (!(w instanceof Window)) {
            w = w.getParent();
        }
        if (w != null) {
            ((Window)w).pack();
        }
    }

    Controller getController() {
        return this.controller;
    }

    boolean cancel() {
        if (this.controller == null) {
            return true;
        }
        return this.controller.cancel();
    }

    boolean ok() {
        boolean ok;
        String defaultAttachTypeName = this.currentAttachType.getTypeDisplayName();
        Properties props = Properties.getDefault().getProperties("debugger");
        props.setString("last_attach_type", defaultAttachTypeName);
        if (this.controller == null) {
            return true;
        }
        props = props.getProperties("last_attaches");
        Integer[] usedSlots = (Integer[])props.getArray("used_slots", (Object[])new Integer[0]);
        int freeSlot = -1;
        if (usedSlots.length >= 4) {
            freeSlot = usedSlots[3];
        } else {
            for (int x = 0; x < 4; ++x) {
                boolean found = true;
                for (int y = 0; y < usedSlots.length; ++y) {
                    if (x != usedSlots[y]) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                freeSlot = x;
                break;
            }
        }
        String dispName = null;
        if (this.controller instanceof PersistentController) {
            PersistentController pController = (PersistentController)this.controller;
            Properties slot = props.getProperties("slot_" + freeSlot);
            dispName = pController.getDisplayName();
            if (dispName != null && dispName.trim().length() > 0) {
                slot.setString("display_name", dispName);
                pController.save(slot.getProperties("values"));
                slot.setString("attach_type", defaultAttachTypeName);
            }
        }
        if (ok = this.controller.ok()) {
            GestureSubmitter.logAttach(defaultAttachTypeName);
            if (dispName != null && dispName.trim().length() > 0) {
                int newLength = Math.min(3, usedSlots.length + 1);
                int excludeIndex = -1;
                for (int x = 0; x < usedSlots.length; ++x) {
                    String str = props.getProperties("slot_" + usedSlots[x]).getString("display_name", "");
                    if (!dispName.equals(str) || x >= 3) continue;
                    excludeIndex = x;
                    --newLength;
                    break;
                }
                Object[] newUsedSlots = new Integer[newLength];
                int copyFrom = 0;
                for (int x = 1; x < newLength; ++x) {
                    if (copyFrom == excludeIndex) {
                        ++copyFrom;
                    }
                    newUsedSlots[x] = usedSlots[copyFrom];
                    ++copyFrom;
                }
                newUsedSlots[0] = freeSlot;
                props.setArray("used_slots", newUsedSlots);
            }
            DebugMainProjectAction.attachHistoryChanged();
        }
        return ok;
    }

    public HelpCtx getHelpCtx() {
        return this.help;
    }
}

