/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.parser.Bundle;
import org.netbeans.modules.php.editor.parser.GSFPHPError;
import org.netbeans.modules.php.editor.parser.GSFPHPParser;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandler;
import org.netbeans.modules.php.editor.parser.ParserErrorHandler;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;

public class PHP5ErrorHandlerImpl
implements PHP5ErrorHandler {
    private final List<PHP5ErrorHandler.SyntaxError> syntaxErrors;
    private final GSFPHPParser.Context context;
    private volatile boolean handleErrors = true;

    public PHP5ErrorHandlerImpl(GSFPHPParser.Context context) {
        this.context = context;
        this.syntaxErrors = new ArrayList<PHP5ErrorHandler.SyntaxError>();
    }

    @Override
    public void handleError(ParserErrorHandler.Type type, short[] expectedtokens, Symbol current, Symbol previous) {
        if (this.handleErrors && type == ParserErrorHandler.Type.SYNTAX_ERROR) {
            SyntaxErrorLogger.log(expectedtokens, current, previous);
            PHP5ErrorHandler.SyntaxError.Type syntaxErrorType = PHP5ErrorHandler.SyntaxError.Type.POSSIBLE_ERROR;
            if (this.syntaxErrors.isEmpty()) {
                syntaxErrorType = PHP5ErrorHandler.SyntaxError.Type.FIRST_VALID_ERROR;
            }
            this.syntaxErrors.add(new PHP5ErrorHandler.SyntaxError(expectedtokens, current, previous, syntaxErrorType));
        }
    }

    @Override
    public void disableHandling() {
        this.handleErrors = false;
    }

    @Override
    public List<Error> displayFatalError() {
        return Arrays.asList(new PHP5ErrorHandler.FatalError(this.context));
    }

    @Override
    public List<Error> displaySyntaxErrors(Program program) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (PHP5ErrorHandler.SyntaxError syntaxError : this.syntaxErrors) {
            errors.add(this.defaultSyntaxErrorHandling(syntaxError));
        }
        return errors;
    }

    private Error defaultSyntaxErrorHandling(PHP5ErrorHandler.SyntaxError syntaxError) {
        StringBuilder message = new StringBuilder();
        Symbol currentToken = syntaxError.getCurrentToken();
        message.append(syntaxError.getMessageHeader());
        message.append(TokenWrapper.create(currentToken).createUnexpectedMessage());
        if (syntaxError.generateExtraInfo()) {
            message.append(TokenWrapper.create(syntaxError.getPreviousToken()).createAfterText());
            List<String> possibleTags = PHP5ErrorHandlerImpl.getExpectedTokenNames(syntaxError);
            if (possibleTags.size() > 0) {
                message.append(PHP5ErrorHandlerImpl.createExpectedTokensText(possibleTags));
            }
        }
        return new GSFPHPError(message.toString(), this.context.getSnapshot().getSource().getFileObject(), currentToken.left, currentToken.right, syntaxError.getSeverity(), new Object[]{syntaxError});
    }

    private static List<String> getExpectedTokenNames(PHP5ErrorHandler.SyntaxError syntaxError) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < syntaxError.getExpectedTokens().length; i += 2) {
            String text = TokenWrapper.getTokenTextForm(syntaxError.getExpectedTokens()[i]);
            if (text == null) continue;
            result.add(text);
        }
        return result;
    }

    private static String createExpectedTokensText(List<String> expectedTokenNames) {
        StringBuilder message = new StringBuilder();
        message.append("\n ").append(Bundle.SE_Expected());
        message.append(":\t");
        boolean addOR = false;
        for (String tag : expectedTokenNames) {
            if (addOR) {
                message.append(", ");
            } else {
                addOR = true;
            }
            message.append(tag);
        }
        return message.toString();
    }

    @Override
    public List<PHP5ErrorHandler.SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    private static final class TokenWrapper {
        private final Symbol token;

        public static TokenWrapper create(Symbol token) {
            assert (token != null);
            return new TokenWrapper(token);
        }

        private TokenWrapper(Symbol token) {
            this.token = token;
        }

        public boolean isCommonToken() {
            return !(this.token.value instanceof List) && !(this.token.value instanceof ASTNode);
        }

        public boolean isNodeToken() {
            return this.token.value instanceof ASTNode;
        }

        public String createUnexpectedMessage() {
            String unexpectedText = null;
            if (this.token.sym == 0) {
                unexpectedText = Bundle.SE_EOF();
            } else if (TokenWrapper.isValuableToken(this.token)) {
                unexpectedText = TokenWrapper.getTokenTextForm(this.token.sym) + " '" + String.valueOf(this.token.value) + "'";
            } else {
                String currentText = TokenWrapper.getTokenTextForm(this.token.sym);
                if (StringUtils.hasText((String)currentText)) {
                    unexpectedText = currentText.trim();
                }
            }
            String result = unexpectedText == null ? "" : "\n " + Bundle.SE_Unexpected() + ":\t" + unexpectedText;
            return result;
        }

        public String createAfterText() {
            String previousText;
            String afterText = null;
            if (TokenWrapper.isValuableToken(this.token)) {
                afterText = TokenWrapper.getTokenTextForm(this.token.sym) + " '" + String.valueOf(this.token.value) + "'";
            } else if (!this.isNodeToken() && StringUtils.hasText((String)(previousText = TokenWrapper.getTokenTextForm(this.token.sym)))) {
                afterText = previousText.trim();
            }
            String result = afterText == null ? "" : "\n " + Bundle.SE_After() + ":\t" + afterText;
            return result;
        }

        private static boolean isValuableToken(Symbol token) {
            return (token.sym == 6 || token.sym == 12 || token.sym == 5 || token.sym == 4 || token.sym == 8) && !(token.value instanceof ASTNode) && !(token.value instanceof List);
        }

        public static String getTokenTextForm(int token) {
            String text = null;
            switch (token) {
                case 102: {
                    text = "&&";
                    break;
                }
                case 10: {
                    text = "inline html";
                    break;
                }
                case 47: {
                    text = "empty";
                    break;
                }
                case 145: {
                    text = "protected";
                    break;
                }
                case 136: {
                    text = "]";
                    break;
                }
                case 59: {
                    text = "__TRAIT__";
                    break;
                }
                case 107: {
                    text = "!=";
                    break;
                }
                case 77: {
                    text = "include";
                    break;
                }
                case 151: {
                    text = "'\"'";
                    break;
                }
                case 43: {
                    text = "global";
                    break;
                }
                case 86: {
                    text = "print";
                    break;
                }
                case 95: {
                    text = "|=";
                    break;
                }
                case 84: {
                    text = "XOR";
                    break;
                }
                case 33: {
                    text = "function";
                    break;
                }
                case 141: {
                    text = "static";
                    break;
                }
                case 124: {
                    text = "'.'";
                    break;
                }
                case 40: {
                    text = "throw";
                    break;
                }
                case 49: {
                    text = "class";
                    break;
                }
                case 142: {
                    text = "abstract";
                    break;
                }
                case 11: {
                    text = "String";
                    break;
                }
                case 93: {
                    text = "%=";
                    break;
                }
                case 30: {
                    text = "break";
                    break;
                }
                case 15: {
                    text = "while";
                    break;
                }
                case 14: {
                    text = "do";
                    break;
                }
                case 34: {
                    text = "const";
                    break;
                }
                case 31: {
                    text = "continue";
                    break;
                }
                case 61: {
                    text = "__FUNCTION__";
                    break;
                }
                case 120: {
                    text = "/";
                    break;
                }
                case 83: {
                    text = "OR";
                    break;
                }
                case 73: {
                    text = "__DIR__";
                    break;
                }
                case 147: {
                    text = "(";
                    break;
                }
                case 105: {
                    text = "&";
                    break;
                }
                case 82: {
                    text = "','";
                    break;
                }
                case 140: {
                    text = "else";
                    break;
                }
                case 106: {
                    text = "==";
                    break;
                }
                case 55: {
                    text = "list";
                    break;
                }
                case 71: {
                    text = "namespace";
                    break;
                }
                case 74: {
                    text = "\\";
                    break;
                }
                case 103: {
                    text = "|";
                    break;
                }
                case 108: {
                    text = "===";
                    break;
                }
                case 125: {
                    text = "++";
                    break;
                }
                case 139: {
                    text = "elseif";
                    break;
                }
                case 38: {
                    text = "try";
                    break;
                }
                case 153: {
                    text = "<<<'...'";
                    break;
                }
                case 144: {
                    text = "private";
                    break;
                }
                case 133: {
                    text = "(unset)";
                    break;
                }
                case 78: {
                    text = "include_once";
                    break;
                }
                case 138: {
                    text = "endif";
                    break;
                }
                case 98: {
                    text = ">>=";
                    break;
                }
                case 57: {
                    text = "callable";
                    break;
                }
                case 146: {
                    text = "public";
                    break;
                }
                case 53: {
                    text = "->";
                    break;
                }
                case 123: {
                    text = "~";
                    break;
                }
                case 70: {
                    text = "::";
                    break;
                }
                case 110: {
                    text = "<=";
                    break;
                }
                case 96: {
                    text = "^=";
                    break;
                }
                case 20: {
                    text = "endforeach";
                    break;
                }
                case 12: {
                    text = "String";
                    break;
                }
                case 152: {
                    text = "'`'";
                    break;
                }
                case 134: {
                    text = "@";
                    break;
                }
                case 25: {
                    text = "as";
                    break;
                }
                case 69: {
                    text = "}";
                    break;
                }
                case 22: {
                    text = "enddeclare";
                    break;
                }
                case 39: {
                    text = "catch";
                    break;
                }
                case 28: {
                    text = "case";
                    break;
                }
                case 8: {
                    text = "variable";
                    break;
                }
                case 156: {
                    text = "insteadof";
                    break;
                }
                case 137: {
                    text = "new";
                    break;
                }
                case 89: {
                    text = "-=";
                    break;
                }
                case 117: {
                    text = "+";
                    break;
                }
                case 97: {
                    text = "<<=";
                    break;
                }
                case 16: {
                    text = "endwhile";
                    break;
                }
                case 18: {
                    text = "endfor";
                    break;
                }
                case 155: {
                    text = "trait";
                    break;
                }
                case 24: {
                    text = "clone";
                    break;
                }
                case 101: {
                    text = "||";
                    break;
                }
                case 45: {
                    text = "unset";
                    break;
                }
                case 50: {
                    text = "interface";
                    break;
                }
                case 26: {
                    text = "switch";
                    break;
                }
                case 111: {
                    text = ">=";
                    break;
                }
                case 112: {
                    text = "<=>";
                    break;
                }
                case 135: {
                    text = "[";
                    break;
                }
                case 67: {
                    text = "{$";
                    break;
                }
                case 143: {
                    text = "final";
                    break;
                }
                case 80: {
                    text = "require";
                    break;
                }
                case 63: {
                    text = "__FILE__";
                    break;
                }
                case 126: {
                    text = "--";
                    break;
                }
                case 148: {
                    text = ")";
                    break;
                }
                case 58: {
                    text = "__CLASS__";
                    break;
                }
                case 79: {
                    text = "eval";
                    break;
                }
                case 113: {
                    text = "<";
                    break;
                }
                case 109: {
                    text = "!==";
                    break;
                }
                case 122: {
                    text = "!";
                    break;
                }
                case 81: {
                    text = "require_once";
                    break;
                }
                case 72: {
                    text = "__NAMESPACE__";
                    break;
                }
                case 66: {
                    text = "${";
                    break;
                }
                case 44: {
                    text = "var";
                    break;
                }
                case 64: {
                    text = "<<<\"...\"";
                    break;
                }
                case 27: {
                    text = "endswitch";
                    break;
                }
                case 131: {
                    text = "(object)";
                    break;
                }
                case 13: {
                    text = "echo";
                    break;
                }
                case 62: {
                    text = "__LINE__";
                    break;
                }
                case 17: {
                    text = "for";
                    break;
                }
                case 52: {
                    text = "implements";
                    break;
                }
                case 130: {
                    text = "(array)";
                    break;
                }
                case 150: {
                    text = "$";
                    break;
                }
                case 119: {
                    text = "*";
                    break;
                }
                case 128: {
                    text = "(double)";
                    break;
                }
                case 132: {
                    text = "(bool)";
                    break;
                }
                case 121: {
                    text = "%";
                    break;
                }
                case 4: {
                    text = "integer";
                    break;
                }
                case 68: {
                    text = "{";
                    break;
                }
                case 76: {
                    text = "define";
                    break;
                }
                case 99: {
                    text = "?";
                    break;
                }
                case 160: {
                    text = "??";
                    break;
                }
                case 154: {
                    text = "END_NOWDOC";
                    break;
                }
                case 42: {
                    text = "use";
                    break;
                }
                case 104: {
                    text = "^";
                    break;
                }
                case 3: {
                    text = "if";
                    break;
                }
                case 90: {
                    text = "*=";
                    break;
                }
                case 56: {
                    text = "array";
                    break;
                }
                case 114: {
                    text = ">";
                    break;
                }
                case 100: {
                    text = ";";
                    break;
                }
                case 149: {
                    text = ":";
                    break;
                }
                case 75: {
                    text = "VAR_COMMENT";
                    break;
                }
                case 92: {
                    text = ".=";
                    break;
                }
                case 94: {
                    text = "&=";
                    break;
                }
                case 5: {
                    text = "double";
                    break;
                }
                case 118: {
                    text = "-";
                    break;
                }
                case 19: {
                    text = "foreach";
                    break;
                }
                case 2: {
                    text = "exit";
                    break;
                }
                case 21: {
                    text = "declare";
                    break;
                }
                case 7: {
                    text = "STRING_VARNAME";
                    break;
                }
                case 51: {
                    text = "extends";
                    break;
                }
                case 60: {
                    text = "__METHOD__";
                    break;
                }
                case 127: {
                    text = "(int)";
                    break;
                }
                case 46: {
                    text = "isset";
                    break;
                }
                case 85: {
                    text = "&&";
                    break;
                }
                case 35: {
                    text = "return";
                    break;
                }
                case 29: {
                    text = "default";
                    break;
                }
                case 116: {
                    text = ">>";
                    break;
                }
                case 87: {
                    text = "=";
                    break;
                }
                case 115: {
                    text = "<<";
                    break;
                }
                case 65: {
                    text = "END_HEREDOC";
                    break;
                }
                case 54: {
                    text = "=>";
                    break;
                }
                case 129: {
                    text = "(string)";
                    break;
                }
                case 6: {
                    text = "identifier";
                    break;
                }
                case 88: {
                    text = "+=";
                    break;
                }
                case 23: {
                    text = "instanceof";
                    break;
                }
                case 91: {
                    text = "/=";
                    break;
                }
                case 9: {
                    text = "NUM_STRING";
                    break;
                }
                case 48: {
                    text = "__halt_compiler";
                    break;
                }
                case 32: {
                    text = "goto";
                    break;
                }
                case 36: {
                    text = "yield";
                    break;
                }
                case 37: {
                    text = "yield from";
                    break;
                }
            }
            return text;
        }
    }

    private static class SyntaxErrorLogger {
        private static final Logger LOGGER = Logger.getLogger(SyntaxErrorLogger.class.getName());

        private SyntaxErrorLogger() {
        }

        public static void log(short[] expectedtokens, Symbol current, Symbol previous) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Syntax error:");
                LOGGER.log(Level.FINEST, "Current [{0}, {1}]({2}): {3}", new Object[]{current.left, current.right, Utils.getASTScannerTokenName(current.sym), current.value});
                LOGGER.log(Level.FINEST, "Previous [{0}, {1}] ({2}):{3}", new Object[]{previous.left, previous.right, Utils.getASTScannerTokenName(previous.sym), previous.value});
                StringBuilder message = new StringBuilder();
                message.append("Expected tokens:");
                for (int i = 0; i < expectedtokens.length; i += 2) {
                    message.append(" ").append(Utils.getASTScannerTokenName(expectedtokens[i]));
                }
                LOGGER.finest(message.toString());
            }
        }
    }
}

