/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;

public final class PhpDocTypeTagInfo
extends ASTNodeInfo<PHPDocNode> {
    private final PHPDocTypeTag typeTag;
    private final ASTNodeInfo.Kind kind;
    private final String typeName;

    private PhpDocTypeTagInfo(PHPDocTypeTag typeTag, PHPDocNode node, String typeName, ASTNodeInfo.Kind kind) {
        super(node);
        this.typeTag = typeTag;
        this.kind = kind;
        this.typeName = typeName;
    }

    public static List<? extends PhpDocTypeTagInfo> create(PHPDocTypeTag typeTag, ASTNodeInfo.Kind kind, Scope scope) {
        ArrayList<PhpDocTypeTagInfo> retval = new ArrayList<PhpDocTypeTagInfo>();
        List<PHPDocTypeNode> types = typeTag.getTypes();
        if (!types.isEmpty()) {
            for (PHPDocNode pHPDocNode : types) {
                if (scope == null) continue;
                QualifiedName qualifiedName = QualifiedName.create(pHPDocNode.getValue());
                if (VariousUtils.isAliased(qualifiedName, pHPDocNode.getStartOffset(), scope)) {
                    LinkedList<String> segments = qualifiedName.getSegments();
                    retval.add(new PhpDocTypeTagInfo(typeTag, pHPDocNode, segments.getFirst(), ASTNodeInfo.Kind.USE_ALIAS));
                    if (segments.size() <= 1) continue;
                    retval.add(new PhpDocTypeTagInfo(typeTag, pHPDocNode, pHPDocNode.getValue(), ASTNodeInfo.Kind.CLASS));
                    continue;
                }
                retval.add(new PhpDocTypeTagInfo(typeTag, pHPDocNode, pHPDocNode.getValue(), ASTNodeInfo.Kind.CLASS));
            }
        }
        if (!kind.equals((Object)ASTNodeInfo.Kind.CLASS) && typeTag instanceof PHPDocVarTypeTag) {
            PHPDocVarTypeTag varTypeTag = (PHPDocVarTypeTag)typeTag;
            if (types.isEmpty()) {
                retval.add(new PhpDocTypeTagInfo(typeTag, varTypeTag.getVariable(), varTypeTag.getVariable().getValue(), kind));
            } else {
                for (PHPDocNode pHPDocNode : types) {
                    retval.add(new PhpDocTypeTagInfo(typeTag, varTypeTag.getVariable(), pHPDocNode.getValue(), kind));
                }
            }
        }
        return retval;
    }

    public static List<? extends PhpDocTypeTagInfo> create(PHPDocTypeTag typeTag, Scope scope) {
        ASTNodeInfo.Kind kind = scope instanceof ClassScope || scope instanceof TraitScope ? ASTNodeInfo.Kind.FIELD : ASTNodeInfo.Kind.VARIABLE;
        return PhpDocTypeTagInfo.create(typeTag, kind, scope);
    }

    public PHPDocTypeTag getTypeTag() {
        return this.typeTag;
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return this.kind;
    }

    public String getTypeName() {
        return this.typeName != null ? this.typeName : null;
    }

    @Override
    public String getName() {
        QualifiedName qn;
        PHPDocNode docNode = (PHPDocNode)this.getOriginalNode();
        String value = docNode.getValue();
        int idx = value.indexOf("::");
        if (idx != -1) {
            value = value.substring(0, idx);
        }
        if (this.getKind().equals((Object)ASTNodeInfo.Kind.CLASS)) {
            qn = QualifiedName.create(value);
            value = qn.toName().toString();
        }
        if (this.getKind().equals((Object)ASTNodeInfo.Kind.USE_ALIAS)) {
            qn = QualifiedName.create(value);
            value = qn.getSegments().getFirst();
        }
        return value;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (ASTNodeInfo.Kind.VARIABLE.equals((Object)this.getKind()) || ASTNodeInfo.Kind.FIELD.equals((Object)this.getKind())) {
            QualifiedName.createUnqualifiedName(this.getName());
        }
        String type = CodeUtils.removeNullableTypePrefix(this.getTypeName());
        return QualifiedName.create(type);
    }

    @Override
    public OffsetRange getRange() {
        PHPDocNode node = (PHPDocNode)this.getOriginalNode();
        if (ASTNodeInfo.Kind.VARIABLE.equals((Object)this.getKind()) || ASTNodeInfo.Kind.FIELD.equals((Object)this.getKind())) {
            int start = this.getName().length() > 0 ? node.getStartOffset() + 1 : node.getStartOffset();
            int end = node.getStartOffset() + this.getName().length();
            return new OffsetRange(start, end);
        }
        if (ASTNodeInfo.Kind.USE_ALIAS.equals((Object)this.getKind())) {
            return new OffsetRange(node.getStartOffset(), node.getStartOffset() + this.getName().length());
        }
        String type = CodeUtils.removeNullableTypePrefix(this.getTypeName());
        QualifiedName typeQN = QualifiedName.create(type);
        QualifiedName namespaceName = typeQN.toNamespaceName(typeQN.getKind().isFullyQualified());
        int nsNameLength = namespaceName.toString().length();
        int startOffset = node.getStartOffset();
        if (CodeUtils.isNullableType(this.getTypeName())) {
            ++startOffset;
        }
        if (nsNameLength > 0) {
            startOffset += nsNameLength;
            if (namespaceName.getSegments().size() > 0 && !namespaceName.isDefaultNamespace()) {
                ++startOffset;
            }
        }
        return new OffsetRange(startOffset, startOffset + typeQN.toName().toString().length());
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(1);
    }
}

