/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.apisupport.AccessQueryImpl;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.spi.nodes.DependencyTypeIconBadge;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public class ModuleJarAccessibilityQueryImpl
implements AccessibilityQueryImplementation,
DependencyTypeIconBadge {
    private static final Logger LOG = Logger.getLogger(ModuleJarAccessibilityQueryImpl.class.getName());
    private static final String BADGE = "org/netbeans/modules/maven/apisupport/module-badge.png";
    private static final String toolTip = "<img src=\"" + ModuleJarAccessibilityQueryImpl.class.getClassLoader().getResource("org/netbeans/modules/maven/apisupport/module-badge.png") + "\">&nbsp;" + Bundle.Tooltip_manifest();
    private static final WeakHashMap<FileObject, List<Pattern>> cache = new WeakHashMap();
    private static final List<Pattern> NOT_MODULE = new ArrayList<Pattern>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isPubliclyAccessible(FileObject pkg) {
        FileObject jarFile = FileUtil.getArchiveFile((FileObject)pkg);
        if (jarFile != null) {
            FileObject jarRoot;
            block15: {
                jarRoot = FileUtil.getArchiveRoot((FileObject)jarFile);
                WeakHashMap<FileObject, List<Pattern>> weakHashMap = cache;
                synchronized (weakHashMap) {
                    List<Pattern> patt = cache.get(jarRoot);
                    if (patt != null) {
                        if (patt != NOT_MODULE) {
                            return AccessQueryImpl.check(patt, FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)pkg).replace("/", "."));
                        }
                        return null;
                    }
                }
                FileObject manifest = jarRoot.getFileObject("META-INF/MANIFEST.MF");
                if (manifest != null) {
                    try {
                        Manifest mf = new Manifest(manifest.getInputStream());
                        String publicPack = mf.getMainAttributes().getValue("OpenIDE-Module-Public-Packages");
                        if (publicPack == null) break block15;
                        List<Pattern> patt = AccessQueryImpl.prepareManifestPublicPackagesPatterns(publicPack);
                        WeakHashMap<FileObject, List<Pattern>> weakHashMap2 = cache;
                        synchronized (weakHashMap2) {
                            cache.put(jarRoot, patt);
                        }
                        return AccessQueryImpl.check(patt, FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)pkg).replace("/", "."));
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "cannot read manifest", ex);
                    }
                }
            }
            WeakHashMap<FileObject, List<Pattern>> weakHashMap = cache;
            synchronized (weakHashMap) {
                cache.put(jarRoot, NOT_MODULE);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getBadgeIcon(FileObject jarFile, Artifact art) {
        if ("nbm-file".equals(art.getType())) {
            return this.getIcon();
        }
        if (jarFile != null && FileUtil.isArchiveFile((FileObject)jarFile)) {
            FileObject jarRoot;
            block16: {
                jarRoot = FileUtil.getArchiveRoot((FileObject)jarFile);
                WeakHashMap<FileObject, List<Pattern>> weakHashMap = cache;
                synchronized (weakHashMap) {
                    List<Pattern> patt = cache.get(jarRoot);
                    if (patt != null) {
                        if (patt != NOT_MODULE) {
                            return this.getIcon();
                        }
                        return null;
                    }
                }
                FileObject manifest = jarRoot.getFileObject("META-INF/MANIFEST.MF");
                if (manifest != null) {
                    try {
                        Manifest mf = new Manifest(manifest.getInputStream());
                        String publicPack = mf.getMainAttributes().getValue("OpenIDE-Module-Public-Packages");
                        if (publicPack == null) break block16;
                        List<Pattern> patt = AccessQueryImpl.prepareManifestPublicPackagesPatterns(publicPack);
                        WeakHashMap<FileObject, List<Pattern>> weakHashMap2 = cache;
                        synchronized (weakHashMap2) {
                            cache.put(jarRoot, patt);
                        }
                        return this.getIcon();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "cannot read manifest", ex);
                    }
                }
            }
            WeakHashMap<FileObject, List<Pattern>> weakHashMap = cache;
            synchronized (weakHashMap) {
                cache.put(jarRoot, NOT_MODULE);
            }
        }
        return null;
    }

    private Image getIcon() {
        return ImageUtilities.addToolTipToImage((Image)ImageUtilities.loadImage((String)BADGE), (String)toolTip);
    }
}

