/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.xml.lexer.XMLLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum XMLTokenId implements TokenId
{
    TEXT("xml-text"),
    WS("xml-ws"),
    ERROR("xml-error"),
    TAG("xml-tag"),
    ARGUMENT("xml-attribute"),
    OPERATOR("xml-operator"),
    VALUE("xml-value"),
    BLOCK_COMMENT("xml-comment"),
    DECLARATION("xml-doctype"),
    CHARACTER("xml-ref"),
    EOL("xml-EOL"),
    PI_START("xml-pi-start"),
    PI_TARGET("xml-pi-target"),
    PI_CONTENT("pi-content"),
    PI_END("pi-end"),
    CDATA_SECTION("xml-cdata-section");

    private final String primaryCategory;
    private static final Language<XMLTokenId> language;

    private XMLTokenId() {
        this(null);
    }

    private XMLTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<XMLTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<XMLTokenId>(){

            protected Collection<XMLTokenId> createTokenIds() {
                return EnumSet.allOf(XMLTokenId.class);
            }

            protected Map<String, Collection<XMLTokenId>> createTokenCategories() {
                HashMap<String, Collection<XMLTokenId>> cats = new HashMap<String, Collection<XMLTokenId>>();
                return cats;
            }

            public Lexer<XMLTokenId> createLexer(LexerRestartInfo<XMLTokenId> info) {
                return new XMLLexer(info);
            }

            public LanguageEmbedding<?> embedding(Token<XMLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                return null;
            }

            public String mimeType() {
                return "text/xml";
            }
        }.language();
    }
}

