/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class AddAttachmentCommand
extends BugtrackingCommand {
    private final String id;
    private final BugzillaRepository repository;
    private final String comment;
    private final FileTaskAttachmentSource attachmentSource;
    private final TaskAttribute attAttribute;
    private final File file;
    private String stringValue;

    public AddAttachmentCommand(String id, BugzillaRepository repository, String comment, FileTaskAttachmentSource attachmentSource, File file, TaskAttribute attAttribute) {
        this.id = id;
        this.repository = repository;
        this.comment = comment;
        this.attachmentSource = attachmentSource;
        this.file = file;
        this.attAttribute = attAttribute;
    }

    public void execute() throws CoreException, IOException, MalformedURLException {
        Bugzilla.getInstance().getClient(this.repository).postAttachment(this.id, this.comment, (AbstractTaskAttachmentSource)this.attachmentSource, this.attAttribute, (IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AddAttachmentCommand [repository=");
            sb.append(this.repository.getUrl());
            sb.append(",id=");
            sb.append(this.id);
            sb.append(",comment=");
            sb.append(this.comment);
            sb.append(",file=");
            sb.append(this.file.getAbsolutePath());
            sb.append(",desc=");
            TaskAttribute ta = this.attAttribute.getMappedAttribute("task.common.attachment.description");
            sb.append(ta != null ? ta.getValue() : "");
            sb.append(",patch=");
            ta = this.attAttribute.getMappedAttribute("task.common.attachment.patch");
            sb.append(ta != null ? ta.getValue() : "");
            sb.append(",contentType=");
            ta = this.attAttribute.getMappedAttribute("task.common.attachment.ctype");
            sb.append(ta != null ? ta.getValue() : "");
            sb.append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

