/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.processing.Processor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.lib.nbjavac.services.CancelAbort;
import org.netbeans.lib.nbjavac.services.CancelService;
import org.netbeans.lib.nbjavac.services.NBAttr;
import org.netbeans.lib.nbjavac.services.NBClassFinder;
import org.netbeans.lib.nbjavac.services.NBClassReader;
import org.netbeans.lib.nbjavac.services.NBClassWriter;
import org.netbeans.lib.nbjavac.services.NBEnter;
import org.netbeans.lib.nbjavac.services.NBJavaCompiler;
import org.netbeans.lib.nbjavac.services.NBJavacTrees;
import org.netbeans.lib.nbjavac.services.NBJavadocClassFinder;
import org.netbeans.lib.nbjavac.services.NBJavadocEnter;
import org.netbeans.lib.nbjavac.services.NBJavadocMemberEnter;
import org.netbeans.lib.nbjavac.services.NBMemberEnter;
import org.netbeans.lib.nbjavac.services.NBMessager;
import org.netbeans.lib.nbjavac.services.NBParserFactory;
import org.netbeans.lib.nbjavac.services.NBResolve;
import org.netbeans.lib.nbjavac.services.NBTreeMaker;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.PostFlowAnalysis;
import org.netbeans.modules.java.source.base.SourceLevelUtils;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.FQN2Files;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.ClasspathInfoListener;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.FindMethodRegionsVisitor;
import org.netbeans.modules.java.source.parsing.JavacFlowListener;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.java.source.parsing.MimeTask;
import org.netbeans.modules.java.source.parsing.ModuleOraculum;
import org.netbeans.modules.java.source.parsing.NewComilerTask;
import org.netbeans.modules.java.source.parsing.NullWriter;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

public class JavacParser
extends Parser {
    public static final String OPTION_PATCH_MODULE = "--patch-module";
    public static final String NB_X_MODULE = "-Xnb-Xmodule:";
    private static final Logger TIME_LOGGER = Logger.getLogger("TIMER");
    private static final Logger LOGGER = Logger.getLogger(JavacParser.class.getName());
    public static final String MIME_TYPE = "text/x-java";
    private static final PrintWriter DEV_NULL = new PrintWriter((Writer)new NullWriter(), false);
    private static final int MAX_DUMPS = Integer.getInteger("org.netbeans.modules.java.source.parsing.JavacParser.maxDumps", 255);
    private static final boolean DISABLE_PARTIAL_REPARSE = Boolean.getBoolean("org.netbeans.modules.java.source.parsing.JavacParser.no_reparse");
    private static final boolean DISABLE_PARAMETER_NAMES_READING = Boolean.getBoolean("org.netbeans.modules.java.source.parsing.JavacParser.no_parameter_names");
    public static final String LOMBOK_DETECTED = "lombokDetected";
    private static final Map<JavaSource.Phase, String> phase2Message = new EnumMap<JavaSource.Phase, String>(JavaSource.Phase.class);
    private final ChangeSupport listeners = new ChangeSupport((Object)this);
    private final AtomicBoolean parserCanceled = new AtomicBoolean();
    private final AtomicBoolean indexCanceled = new AtomicBoolean();
    private final boolean privateParser;
    private FileObject file;
    private FileObject root;
    private ClasspathInfo cpInfo;
    private final int sourceCount;
    private final boolean supportsReparse;
    private final List<Pair<DocPositionRegion, MethodTree>> positions = Collections.synchronizedList(new LinkedList());
    private final AtomicReference<Pair<DocPositionRegion, MethodTree>> changedMethod = new AtomicReference();
    private final FilterListener filterListener;
    private final ChangeListener cpInfoListener;
    private final SequentialParsing sequentialParsing;
    private CompilationInfoImpl ciImpl;
    private boolean initialized;
    private boolean invalid;
    private Snapshot cachedSnapShot;
    private long parseId;
    private ChangeListener weakCpListener;
    private Reference<JavaSource> currentSource;
    public static boolean DISABLE_SOURCE_LEVEL_DOWNGRADE;

    JavacParser(Collection<Snapshot> snapshots, boolean privateParser) {
        org.netbeans.modules.parsing.api.Source source;
        FileObject fo;
        this.privateParser = privateParser;
        this.sourceCount = snapshots.size();
        boolean singleJavaFile = this.sourceCount == 1 && MIME_TYPE.equals(snapshots.iterator().next().getSource().getMimeType());
        this.supportsReparse = singleJavaFile && !DISABLE_PARTIAL_REPARSE;
        JavaFileFilterImplementation filter = null;
        if (singleJavaFile && (fo = (source = snapshots.iterator().next().getSource()).getFileObject()) != null) {
            filter = JavaFileFilterQuery.getFilter(fo);
        }
        this.filterListener = filter != null ? new FilterListener(filter) : null;
        this.cpInfoListener = new ClasspathInfoListener(this.listeners, new Runnable(){

            @Override
            public void run() {
                if (JavacParser.this.sourceCount == 0) {
                    JavacParser.this.invalidate(true);
                }
            }
        });
        this.sequentialParsing = (SequentialParsing)Lookup.getDefault().lookup(SequentialParsing.class);
    }

    private void init(Snapshot snapshot, Task task, boolean singleSource) {
        boolean explicitCpInfo;
        boolean bl = explicitCpInfo = task instanceof ClasspathInfo.Provider && ((ClasspathInfo.Provider)task).getClasspathInfo() != null;
        if (!this.initialized) {
            org.netbeans.modules.parsing.api.Source source = snapshot.getSource();
            FileObject sourceFile = source.getFileObject();
            assert (sourceFile != null);
            this.file = sourceFile;
            ClasspathInfo oldInfo = this.cpInfo;
            this.cpInfo = explicitCpInfo ? ((ClasspathInfo.Provider)task).getClasspathInfo() : ClasspathInfo.create(sourceFile);
            ClassPath cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            assert (cp != null);
            this.root = cp.findOwnerRoot(sourceFile);
            if (singleSource) {
                if (oldInfo != null && this.weakCpListener != null) {
                    oldInfo.removeChangeListener(this.weakCpListener);
                    this.weakCpListener = null;
                }
                if (!explicitCpInfo) {
                    this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
                    this.cpInfo.addChangeListener(this.weakCpListener);
                }
                this.initialized = true;
            }
        } else if (singleSource && !explicitCpInfo) {
            assert (this.file != null);
            assert (this.cpInfo != null);
            ClassPath scp = ClassPath.getClassPath((FileObject)this.file, (String)"classpath/source");
            if (scp == null) {
                scp = ClassPath.EMPTY;
            }
            if (scp != this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)) {
                Project owner = FileOwnerQuery.getOwner((FileObject)this.file);
                LOGGER.log(Level.WARNING, "ClassPath identity changed for {0}, class path owner: {1} original sourcePath: {2} new sourcePath: {3}", new Object[]{this.file, owner == null ? "null" : FileUtil.getFileDisplayName((FileObject)owner.getProjectDirectory()) + " (" + owner.getClass() + ")", this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), scp});
                if (this.weakCpListener != null) {
                    this.cpInfo.removeChangeListener(this.weakCpListener);
                }
                this.cpInfo = ClasspathInfo.create(this.file);
                ClassPath cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                assert (cp != null);
                this.root = cp.findOwnerRoot(this.file);
                this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
                this.cpInfo.addChangeListener(this.weakCpListener);
                JavaSourceAccessor.getINSTANCE().invalidateCachedClasspathInfo(this.file);
            }
        }
    }

    private void init(Task task) {
        if (!this.initialized) {
            ClasspathInfo _tmpInfo = null;
            if (task instanceof ClasspathInfo.Provider && (_tmpInfo = ((ClasspathInfo.Provider)task).getClasspathInfo()) != null) {
                if (this.cpInfo != null && this.weakCpListener != null) {
                    this.cpInfo.removeChangeListener(this.weakCpListener);
                    this.weakCpListener = null;
                }
            } else {
                throw new IllegalArgumentException("No classpath provided by task: " + task);
            }
            this.cpInfo = _tmpInfo;
            this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
            this.cpInfo.addChangeListener(this.weakCpListener);
            this.root = Optional.ofNullable(this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)).map(cp -> {
                FileObject[] roots = cp.getRoots();
                return roots.length > 0 ? roots[0] : null;
            }).orElse(null);
            this.initialized = true;
        }
    }

    private void invalidate(boolean reinit) {
        this.invalid = true;
        if (reinit) {
            this.initialized = false;
        }
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        try {
            this.checkSourceModification(event);
            this.parseImpl(snapshot, task);
        }
        catch (FileObjects.InvalidFileException invalidFileException) {
        }
        catch (IOException ioe) {
            throw new ParseException("JavacParser failure", (Throwable)ioe);
        }
    }

    private boolean shouldParse(@NonNull Task task) {
        JavaSource oldSource;
        if (!(task instanceof MimeTask)) {
            this.currentSource = null;
            return true;
        }
        JavaSource newSource = ((MimeTask)task).getJavaSource();
        if (this.invalid) {
            this.currentSource = new WeakReference<JavaSource>(newSource);
            return true;
        }
        JavaSource javaSource = oldSource = this.currentSource == null ? null : this.currentSource.get();
        if (oldSource == null) {
            this.currentSource = new WeakReference<JavaSource>(newSource);
            return true;
        }
        if (newSource.equals(oldSource)) {
            return false;
        }
        if (newSource.getClasspathInfo() == oldSource.getClasspathInfo()) {
            this.currentSource = new WeakReference<JavaSource>(newSource);
            return false;
        }
        this.currentSource = new WeakReference<JavaSource>(newSource);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseImpl(Snapshot snapshot, Task task) throws IOException {
        assert (task != null);
        assert (this.privateParser || Utilities.holdsParserLock());
        ++this.parseId;
        this.parserCanceled.set(false);
        this.indexCanceled.set(false);
        this.cachedSnapShot = snapshot;
        LOGGER.log(Level.FINE, "parse: task: {0}\n{1}", new Object[]{task.toString(), snapshot == null ? "null" : snapshot.getText()});
        CompilationInfoImpl oldInfo = this.ciImpl;
        boolean success = false;
        try {
            switch (this.sourceCount) {
                case 0: {
                    if (!this.shouldParse(task)) break;
                    this.init(task);
                    this.ciImpl = new CompilationInfoImpl(this.cpInfo, this.root);
                    break;
                }
                case 1: {
                    Pair _changedMethod;
                    this.init(snapshot, task, true);
                    boolean needsFullReparse = true;
                    if (this.supportsReparse && (_changedMethod = (Pair)this.changedMethod.getAndSet(null)) != null && this.ciImpl != null) {
                        LOGGER.log(Level.FINE, "\t:trying partial reparse:\n{0}", ((DocPositionRegion)((Object)_changedMethod.first())).getText());
                        PartialReparser reparser = (PartialReparser)Lookup.getDefault().lookup(PartialReparser.class);
                        boolean bl = needsFullReparse = !reparser.reparseMethod(this.ciImpl, snapshot, (MethodTree)_changedMethod.second(), ((DocPositionRegion)((Object)_changedMethod.first())).getText());
                        if (!needsFullReparse) {
                            this.ciImpl.setChangedMethod((Pair<DocPositionRegion, MethodTree>)_changedMethod);
                        }
                    }
                    if (!needsFullReparse) break;
                    this.positions.clear();
                    this.ciImpl = JavacParser.createCurrentInfo(this, this.file, this.root, snapshot, null, null);
                    LOGGER.fine("\t:created new javac");
                    break;
                }
                default: {
                    this.init(snapshot, task, false);
                    this.ciImpl = JavacParser.createCurrentInfo(this, this.file, this.root, snapshot, this.sequentialParsing == null || this.ciImpl == null ? null : this.ciImpl.getJavacTask(), this.sequentialParsing == null || this.ciImpl == null ? null : this.ciImpl.getDiagnosticListener());
                }
            }
            boolean bl = this.invalid = !(success = true);
        }
        catch (Throwable throwable) {
            boolean bl = this.invalid = !success;
            if (oldInfo != this.ciImpl && oldInfo != null) {
                oldInfo.dispose();
            }
            throw throwable;
        }
        if (oldInfo != this.ciImpl && oldInfo != null) {
            oldInfo.dispose();
        }
    }

    public JavacParserResult getResult(Task task) throws ParseException {
        NewComilerTask nct;
        assert (this.privateParser || Utilities.holdsParserLock());
        if (this.ciImpl == null && !this.invalid) {
            throw new IllegalStateException("No CompilationInfoImpl in valid parser");
        }
        LOGGER.log(Level.FINE, "getResult: task:{0}", task.toString());
        boolean isJavaParserResultTask = task instanceof JavaParserResultTask;
        boolean isParserResultTask = task instanceof ParserResultTask;
        boolean isUserTask = task instanceof UserTask;
        boolean isClasspathInfoProvider = task instanceof ClasspathInfo.Provider;
        if (this.invalid || isClasspathInfoProvider) {
            ClasspathInfo providedInfo;
            if (this.invalid) {
                LOGGER.fine("Invalid, reparse");
            }
            if (isClasspathInfoProvider && (providedInfo = ((ClasspathInfo.Provider)task).getClasspathInfo()) != null && !providedInfo.equals(this.cpInfo)) {
                if (this.sourceCount != 0) {
                    LOGGER.log(Level.FINE, "Task {0} has changed ClasspathInfo form: {1} to:{2}", new Object[]{task, this.cpInfo, providedInfo});
                }
                this.invalidate(true);
            }
            if (this.invalid) {
                assert (this.cachedSnapShot != null || this.sourceCount == 0);
                try {
                    this.parseImpl(this.cachedSnapShot, task);
                }
                catch (FileObjects.InvalidFileException ife) {
                    LOGGER.warning(ife.getMessage());
                    return null;
                }
                catch (IOException ioe) {
                    throw new ParseException("JavacParser failure", (Throwable)ioe);
                }
            }
        }
        JavacParserResult result = null;
        if (isParserResultTask) {
            JavaSource.Phase reachedPhase;
            JavaSource.Phase requiredPhase;
            if (isJavaParserResultTask) {
                requiredPhase = ((JavaParserResultTask)task).getPhase();
            } else {
                requiredPhase = JavaSource.Phase.RESOLVED;
                LOGGER.log(Level.WARNING, "ParserResultTask: {0} doesn''t provide phase, assuming RESOLVED", task);
            }
            DefaultCancelService cancelService = DefaultCancelService.instance(this.ciImpl.getJavacTask().getContext());
            if (cancelService != null) {
                cancelService.mayCancel.set(true);
            }
            try {
                reachedPhase = this.moveToPhase(requiredPhase, this.ciImpl, true);
            }
            catch (IOException ioe) {
                throw new ParseException("JavacParser failure", (Throwable)ioe);
            }
            finally {
                if (cancelService != null) {
                    cancelService.mayCancel.set(false);
                }
            }
            if (reachedPhase.compareTo(requiredPhase) >= 0) {
                ClassIndexImpl.cancel.set(this.indexCanceled);
                result = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationInfo(this.ciImpl));
            }
        } else if (isUserTask) {
            result = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationController(this.ciImpl));
        } else {
            LOGGER.log(Level.WARNING, "Ignoring unknown task: {0}", task);
        }
        if (task instanceof NewComilerTask && ((nct = (NewComilerTask)task).getCompilationController() == null || nct.getTimeStamp() != this.parseId)) {
            try {
                nct.setCompilationController(JavaSourceAccessor.getINSTANCE().createCompilationController(new CompilationInfoImpl(this, this.file, this.root, null, null, this.cachedSnapShot, true)), this.parseId);
            }
            catch (IOException ioe) {
                throw new ParseException("Javac Failure", (Throwable)ioe);
            }
        }
        return result;
    }

    public void cancel(@NonNull Parser.CancelReason reason, @NonNull SourceModificationEvent event) {
        this.indexCanceled.set(true);
        if (reason == Parser.CancelReason.SOURCE_MODIFICATION_EVENT && event.sourceChanged()) {
            this.parserCanceled.set(true);
        }
    }

    public void resultFinished(boolean isCancelable) {
        if (isCancelable) {
            ClassIndexImpl.cancel.remove();
            this.indexCanceled.set(false);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listeners.removeChangeListener(changeListener);
    }

    ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaSource.Phase moveToPhase(JavaSource.Phase phase, CompilationInfoImpl currentInfo, boolean cancellable) throws IOException {
        JavaSource.Phase parserError = currentInfo.parserCrashed;
        assert (parserError != null);
        JavaSource.Phase currentPhase = currentInfo.getPhase();
        try {
            long start2;
            if (currentPhase.compareTo(JavaSource.Phase.PARSED) < 0 && phase.compareTo(JavaSource.Phase.PARSED) >= 0 && phase.compareTo(parserError) <= 0) {
                if (cancellable && this.parserCanceled.get()) {
                    JavaSource.Phase phase2 = JavaSource.Phase.MODIFIED;
                    return phase2;
                }
                start2 = System.currentTimeMillis();
                Iterable<? extends CompilationUnitTree> trees = this.sequentialParsing != null ? this.sequentialParsing.parse(currentInfo.getJavacTask(), currentInfo.jfo) : currentInfo.getJavacTask().parse();
                if (trees == null) {
                    LOGGER.log(Level.INFO, "Did not parse anything for: {0}", currentInfo.jfo.toUri());
                    JavaSource.Phase phase3 = JavaSource.Phase.MODIFIED;
                    return phase3;
                }
                Iterator<? extends CompilationUnitTree> it = trees.iterator();
                if (!it.hasNext()) {
                    LOGGER.log(Level.INFO, "Did not parse anything for: {0}", currentInfo.jfo.toUri());
                    JavaSource.Phase phase4 = JavaSource.Phase.MODIFIED;
                    return phase4;
                }
                CompilationUnitTree unit = it.next();
                currentInfo.setCompilationUnit(unit);
                assert (!it.hasNext());
                Document doc = currentInfo.getDocument();
                if (doc != null && this.supportsReparse) {
                    FindMethodRegionsVisitor v = new FindMethodRegionsVisitor(doc, Trees.instance(currentInfo.getJavacTask()).getSourcePositions(), this.parserCanceled, unit);
                    doc.render(v);
                    List<Pair<DocPositionRegion, MethodTree>> list = this.positions;
                    synchronized (list) {
                        this.positions.clear();
                        if (!this.parserCanceled.get()) {
                            this.positions.addAll(v.getResult());
                        }
                    }
                }
                currentPhase = JavaSource.Phase.PARSED;
                long end = System.currentTimeMillis();
                FileObject currentFile = currentInfo.getFileObject();
                TIME_LOGGER.log(Level.FINE, "Compilation Unit", new Object[]{currentFile, unit});
                JavacParser.logTime(currentFile, currentPhase, end - start2);
            }
            if (currentPhase == JavaSource.Phase.PARSED && phase.compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0 && phase.compareTo(parserError) <= 0) {
                if (cancellable && this.parserCanceled.get()) {
                    JavaSource.Phase start2 = JavaSource.Phase.MODIFIED;
                    return start2;
                }
                start2 = System.currentTimeMillis();
                currentInfo.getJavacTask().enter();
                currentPhase = JavaSource.Phase.ELEMENTS_RESOLVED;
                long end = System.currentTimeMillis();
                JavacParser.logTime(currentInfo.getFileObject(), currentPhase, end - start2);
            }
            if (currentPhase == JavaSource.Phase.ELEMENTS_RESOLVED && phase.compareTo(JavaSource.Phase.RESOLVED) >= 0 && phase.compareTo(parserError) <= 0) {
                if (cancellable && this.parserCanceled.get()) {
                    JavaSource.Phase start3 = JavaSource.Phase.MODIFIED;
                    return start3;
                }
                start2 = System.currentTimeMillis();
                JavacTaskImpl jti = currentInfo.getJavacTask();
                PostFlowAnalysis.analyze(jti.analyze(), jti.getContext());
                currentPhase = JavaSource.Phase.RESOLVED;
                long end = System.currentTimeMillis();
                JavacParser.logTime(currentInfo.getFileObject(), currentPhase, end - start2);
            }
            if (currentPhase == JavaSource.Phase.RESOLVED && phase.compareTo(JavaSource.Phase.UP_TO_DATE) >= 0) {
                currentPhase = JavaSource.Phase.UP_TO_DATE;
            }
        }
        catch (CancelAbort ca) {
            currentPhase = JavaSource.Phase.MODIFIED;
            this.invalidate(false);
        }
        catch (Abort abort) {
            parserError = currentPhase;
        }
        catch (Error | RuntimeException ex) {
            parserError = currentPhase;
            JavacParser.dumpSource(currentInfo, ex);
            throw ex;
        }
        finally {
            currentInfo.setPhase(currentPhase);
            currentInfo.parserCrashed = parserError;
        }
        return currentPhase;
    }

    private static CompilationInfoImpl createCurrentInfo(JavacParser parser, FileObject file, FileObject root, Snapshot snapshot, JavacTaskImpl javac, DiagnosticListener<JavaFileObject> diagnosticListener) throws IOException {
        CompilationInfoImpl info = new CompilationInfoImpl(parser, file, root, javac, diagnosticListener, snapshot, false);
        if (file != null) {
            Logger.getLogger("TIMER").log(Level.FINE, "CompilationInfo", new Object[]{file, info});
        }
        return info;
    }

    static JavacTaskImpl createJavacTask(FileObject file, JavaFileObject jfo, FileObject root, ClasspathInfo cpInfo, JavacParser parser, DiagnosticListener<? super JavaFileObject> diagnosticListener, boolean detached) {
        if (file != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Created new JavacTask for: {0}", FileUtil.getFileDisplayName((FileObject)file));
        }
        FQN2Files fqn2Files = null;
        if (root != null) {
            try {
                fqn2Files = FQN2Files.forRoot(root.toURL());
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        EnumSet<ConfigFlags> flags = EnumSet.noneOf(ConfigFlags.class);
        Optional<JavacParser> mayBeParser = Optional.ofNullable(parser);
        if (mayBeParser.filter(p -> p.sourceCount > 1).isPresent()) {
            flags.add(ConfigFlags.MULTI_SOURCE);
        }
        if (Optional.ofNullable(mayBeParser.map(p -> p.file).orElse(file)).filter(f -> "module-info".equals(f.getName()) && "class".equals(f.getExt())).isPresent()) {
            flags.add(ConfigFlags.MODULE_INFO);
        }
        try (ModuleOraculum mo = ModuleOraculum.getInstance();){
            SourceLevelQuery.Result sourceLevel;
            CompilerOptionsQuery.Result compilerOptions;
            FileObject artefact;
            ClassPath cp;
            HashSet additionalModules = new HashSet();
            if (!mo.installModuleName(root, file) && file == null && (cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)) != null) {
                cp.entries().stream().map(e -> {
                    try {
                        return JavaIndex.getAttribute(e.getURL(), "moduleName", null);
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }).filter(modName -> modName != null).forEach(additionalModules::add);
            }
            FileObject fileObject = artefact = root != null ? root : file;
            if (artefact != null) {
                compilerOptions = CompilerOptionsQuery.getOptions((FileObject)artefact);
                sourceLevel = SourceLevelQuery.getSourceLevel2((FileObject)artefact);
            } else {
                compilerOptions = null;
                sourceLevel = null;
            }
            JavacTaskImpl javacTask = JavacParser.createJavacTask(cpInfo, diagnosticListener, sourceLevel != null ? sourceLevel.getSourceLevel() : null, sourceLevel != null ? sourceLevel.getProfile() : null, flags, fqn2Files, parser == null ? null : new DefaultCancelService(parser), APTUtils.get(root), compilerOptions, additionalModules, jfo != null ? Arrays.asList(jfo) : Collections.emptyList());
            Lookup.getDefault().lookupAll(TreeLoaderRegistry.class).stream().forEach(r -> r.enhance(javacTask.getContext(), cpInfo, detached));
            JavacTaskImpl javacTaskImpl = javacTask;
            return javacTaskImpl;
        }
    }

    public static JavacTaskImpl createJavacTask(@NonNull ClasspathInfo cpInfo, @NullAllowed DiagnosticListener<? super JavaFileObject> diagnosticListener, @NullAllowed String sourceLevel, @NullAllowed SourceLevelQuery.Profile sourceProfile, @NullAllowed FQN2Files fqn2Files, @NullAllowed CancelService cancelService, @NullAllowed APTUtils aptUtils, @NullAllowed CompilerOptionsQuery.Result compilerOptions, @NonNull Iterable<? extends JavaFileObject> files) {
        return JavacParser.createJavacTask(cpInfo, diagnosticListener, sourceLevel, sourceProfile, EnumSet.of(ConfigFlags.BACKGROUND_COMPILATION, ConfigFlags.MULTI_SOURCE), fqn2Files, cancelService, aptUtils, compilerOptions, Collections.emptySet(), files);
    }

    private static JavacTaskImpl createJavacTask(@NonNull ClasspathInfo cpInfo, @NullAllowed DiagnosticListener<? super JavaFileObject> diagnosticListener, @NullAllowed String sourceLevel, @NullAllowed SourceLevelQuery.Profile sourceProfile, @NonNull Set<? extends ConfigFlags> flags, @NullAllowed FQN2Files fqn2Files, @NullAllowed CancelService cancelService, @NullAllowed APTUtils aptUtils, @NullAllowed CompilerOptionsQuery.Result compilerOptions, @NonNull Collection<? extends String> additionalModules, @NonNull Iterable<? extends JavaFileObject> files) {
        boolean backgroundCompilation = flags.contains((Object)ConfigFlags.BACKGROUND_COMPILATION);
        boolean multiSource = flags.contains((Object)ConfigFlags.MULTI_SOURCE);
        ArrayList<String> options = new ArrayList<String>();
        String lintOptions = CompilerSettings.getCommandLine(cpInfo);
        Source validatedSourceLevel = JavacParser.validateSourceLevel(sourceLevel, cpInfo, flags.contains((Object)ConfigFlags.MODULE_INFO));
        if (lintOptions.length() > 0) {
            options.addAll(Arrays.asList(lintOptions.split(" ")));
        }
        if (!backgroundCompilation) {
            options.add("-Xjcov");
            options.add("-XDallowStringFolding=false");
            options.add("-XDkeepComments=true");
            if (!$assertionsDisabled && !options.add("-XDdev")) {
                // empty if block
            }
        } else {
            options.add("-XDbackgroundCompilation");
            options.add("-XDcompilePolicy=byfile");
            options.add("-XD-Xprefer=source");
            options.add("-target");
            options.add(validatedSourceLevel.requiredTarget().name);
        }
        options.add("-XDide");
        if (!DISABLE_PARAMETER_NAMES_READING) {
            options.add("-XDsave-parameter-names");
            options.add("-parameters");
        }
        options.add("-XDsuppressAbortOnBadClassFile");
        options.add("-XDshould-stop.at=GENERATE");
        options.add("-g:source");
        options.add("-g:lines");
        options.add("-g:vars");
        options.add("-source");
        options.add(validatedSourceLevel.name);
        if (sourceProfile != null && sourceProfile != SourceLevelQuery.Profile.DEFAULT) {
            options.add("-profile");
            options.add(sourceProfile.getName());
        }
        options.add("-XDdiags.formatterOptions=-source");
        options.add("-XDdiags.layout=%L%m|%L%m|%L%m");
        options.add("-XDbreakDocCommentParsingOnError=false");
        boolean aptEnabled = aptUtils != null && aptUtils.aptEnabledOnScan() && (backgroundCompilation || aptUtils.aptEnabledInEditor() && !multiSource) && JavacParser.hasSourceCache(cpInfo, aptUtils);
        Collection<? extends Processor> processors = null;
        if (aptEnabled) {
            processors = aptUtils.resolveProcessors(backgroundCompilation);
            if (processors.isEmpty()) {
                aptEnabled = false;
            } else {
                for (Processor processor : processors) {
                    if (!"lombok.core.AnnotationProcessor".equals(processor.getClass().getName())) continue;
                    options.add("-XDlombokDetected");
                    break;
                }
            }
        }
        if (aptEnabled) {
            for (Map.Entry entry : aptUtils.processorOptions().entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("-A").append((String)entry.getKey());
                if (entry.getValue() != null) {
                    sb.append('=').append((String)entry.getValue());
                }
                options.add(sb.toString());
            }
        } else {
            options.add("-proc:none");
        }
        if (compilerOptions != null) {
            for (String string : JavacParser.validateCompilerOptions(compilerOptions.getArguments(), validatedSourceLevel)) {
                options.add(string);
            }
        }
        if (!additionalModules.isEmpty()) {
            options.add("--add-modules");
            options.add(additionalModules.stream().collect(Collectors.joining(",")));
        }
        Context context = new Context();
        NBMessager.preRegister((Context)context, null, (PrintWriter)DEV_NULL, (PrintWriter)DEV_NULL, (PrintWriter)DEV_NULL);
        JavacTaskImpl javacTaskImpl = (JavacTaskImpl)JavacTool.create().getTask(null, ClasspathInfoAccessor.getINSTANCE().createFileManager(cpInfo, validatedSourceLevel.name), diagnosticListener, options, files.iterator().hasNext() ? null : Arrays.asList("java.lang.Object"), files, context);
        if (aptEnabled) {
            javacTaskImpl.setProcessors(processors);
            ProcessorHolder.instance(context).setProcessors(processors);
        }
        NBClassReader.preRegister((Context)context);
        Lookup.getDefault().lookupAll(ContextEnhancer.class).stream().forEach(r -> r.enhance(context, backgroundCompilation));
        Lookup.getDefault().lookupAll(DuplicateClassRegistry.class).stream().forEach(r -> r.enhance(context, fqn2Files));
        if (cancelService != null) {
            DefaultCancelService.preRegister(context, cancelService);
        }
        NBAttr.preRegister((Context)context);
        NBClassWriter.preRegister((Context)context);
        NBParserFactory.preRegister((Context)context);
        NBTreeMaker.preRegister((Context)context);
        NBJavacTrees.preRegister((Context)context);
        if (!backgroundCompilation) {
            JavacFlowListener.preRegister(context, javacTaskImpl);
            NBJavadocEnter.preRegister((Context)context);
            NBJavadocMemberEnter.preRegister((Context)context);
            JavadocEnv.preRegister(context, cpInfo);
            NBResolve.preRegister((Context)context);
        } else {
            NBEnter.preRegister((Context)context);
            NBMemberEnter.preRegister((Context)context);
        }
        TIME_LOGGER.log(Level.FINE, "JavaC", context);
        return javacTaskImpl;
    }

    @NonNull
    static Source validateSourceLevel(@NullAllowed String sourceLevel, @NonNull ClasspathInfo cpInfo, boolean isModuleInfo) {
        return JavacParser.validateSourceLevel(sourceLevel, cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS), isModuleInfo);
    }

    @NonNull
    public static Source validateSourceLevel(@NullAllowed String sourceLevel, @NullAllowed ClassPath bootClassPath, @NullAllowed ClassPath classPath, @NullAllowed ClassPath srcClassPath, @NullAllowed ClassPath moduleBoot, @NullAllowed ClassPath moduleCompile, @NullAllowed ClassPath moduleAllUnnamed, boolean isModuleInfo) {
        Level warnLevel;
        Source[] sources = Source.values();
        if (sourceLevel == null) {
            sourceLevel = sources[sources.length - 1].name;
            warnLevel = Level.FINE;
        } else {
            if (isModuleInfo) {
                Source[] java9 = SourceLevelUtils.JDK1_9;
                Source required = Source.lookup(sourceLevel);
                if (required == null || required.compareTo(java9) < 0) {
                    sourceLevel = java9.name;
                }
            }
            warnLevel = Level.WARNING;
        }
        for (Source source : sources) {
            if (source != Source.lookup(sourceLevel)) continue;
            if (DISABLE_SOURCE_LEVEL_DOWNGRADE || isModuleInfo) {
                return source;
            }
            if (source.compareTo(Source.JDK1_4) >= 0 && bootClassPath != null && bootClassPath.findResource("java/lang/AssertionError.class") == null) {
                boolean checkCp = bootClassPath.findResource("java/lang/Object.class") == null;
                ClassPath[] classPathArray = new ClassPath[1];
                ClassPath classPath2 = classPathArray[0] = checkCp ? classPath : ClassPath.EMPTY;
                if (!JavacParser.hasResource("java/lang/AssertionError", new ClassPath[]{ClassPath.EMPTY}, classPathArray, new ClassPath[]{srcClassPath})) {
                    LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.lang.AssertionError cannot be found on the bootclasspath: {2}\nChanging source level to 1.3", new Object[]{srcClassPath, sourceLevel, bootClassPath});
                    return Source.JDK1_3;
                }
            }
            if (source.compareTo(SourceLevelUtils.JDK1_5) >= 0 && !JavacParser.hasResource("java/lang/StringBuilder", new ClassPath[]{bootClassPath}, new ClassPath[]{classPath}, new ClassPath[]{srcClassPath})) {
                LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.lang.StringBuilder cannot be found on the bootclasspath: {2}\nChanging source level to 1.4", new Object[]{srcClassPath, sourceLevel, bootClassPath});
                return Source.JDK1_4;
            }
            if (source.compareTo(SourceLevelUtils.JDK1_7) >= 0 && !JavacParser.hasResource("java/lang/AutoCloseable", new ClassPath[]{bootClassPath}, new ClassPath[]{classPath}, new ClassPath[]{srcClassPath})) {
                LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.lang.AutoCloseable cannot be found on the bootclasspath: {2}\nTry with resources is unsupported.", new Object[]{srcClassPath, sourceLevel, bootClassPath});
            }
            if (source.compareTo(SourceLevelUtils.JDK1_8) >= 0 && !JavacParser.hasResource("java/lang/invoke/LambdaMetafactory", new ClassPath[]{bootClassPath}, new ClassPath[]{classPath}, new ClassPath[]{srcClassPath})) {
                LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.lang.invoke.LambdaMetafactory cannot be found on the bootclasspath: {2}\nChanging source level to 1.7", new Object[]{srcClassPath, sourceLevel, bootClassPath});
                return SourceLevelUtils.JDK1_7;
            }
            if (source.compareTo(SourceLevelUtils.JDK1_9) >= 0 && !JavacParser.hasResource("java/util/zip/CRC32C", new ClassPath[]{moduleBoot}, new ClassPath[]{moduleCompile, moduleAllUnnamed}, new ClassPath[]{srcClassPath})) {
                LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.util.zip.CRC32C cannot be found on the system module path: {2}\nChanging source level to 1.8", new Object[]{srcClassPath, sourceLevel, moduleBoot});
                return SourceLevelUtils.JDK1_8;
            }
            return source;
        }
        SpecificationVersion JAVA_12 = new SpecificationVersion("1.2");
        SpecificationVersion specVer = new SpecificationVersion(sourceLevel);
        if (JAVA_12.compareTo((Object)specVer) > 0) {
            return sources[0];
        }
        return sources[sources.length - 1];
    }

    @NonNull
    public static List<? extends String> validateCompilerOptions(@NonNull List<? extends String> options, @NullAllowed Source sourceLevel) {
        ArrayList<String> res = new ArrayList<String>();
        boolean allowModularOptions = sourceLevel == null || Source.lookup("9").compareTo(sourceLevel) <= 0;
        boolean xmoduleSeen = false;
        for (int i = 0; i < options.size(); ++i) {
            String option = options.get(i);
            if (option.startsWith("-Xmodule:") && !xmoduleSeen) {
                LOGGER.log(Level.WARNING, "Removed javac option -Xmodule: {0}", option);
                res.add(NB_X_MODULE + option.substring("-Xmodule:".length()));
                xmoduleSeen = true;
                continue;
            }
            if (option.startsWith("-XD-Xmodule:") && !xmoduleSeen) {
                res.add(NB_X_MODULE + option.substring("-XD-Xmodule:".length()));
                xmoduleSeen = true;
                continue;
            }
            if (option.startsWith(NB_X_MODULE) && !xmoduleSeen) {
                res.add(option);
                xmoduleSeen = true;
                continue;
            }
            if (option.equals("-parameters") || option.startsWith("-Xlint")) {
                res.add(option);
                continue;
            }
            if (!option.startsWith("--add-modules") && !option.startsWith("--limit-modules") && !option.startsWith("--add-exports") && !option.startsWith("--add-reads") && !option.startsWith(OPTION_PATCH_MODULE) || !allowModularOptions) continue;
            int idx = option.indexOf(61);
            if (idx > 0) {
                res.add(option);
                continue;
            }
            if (i + 1 >= options.size()) continue;
            res.add(option);
            option = options.get(++i);
            res.add(option);
        }
        return res;
    }

    private static boolean hasResource(@NonNull String resourceBase, @NonNull ClassPath[] boot, @NonNull ClassPath[] compile, @NonNull ClassPath[] source) {
        String resourceClass = String.format("%s.class", resourceBase);
        String resourceJava = String.format("%s.java", resourceBase);
        return JavacParser.hasResource(resourceClass, boot) || JavacParser.hasResource(resourceJava, source) || JavacParser.hasResource(resourceClass, compile);
    }

    private static boolean hasSourceCache(@NonNull ClasspathInfo cpInfo, @NonNull APTUtils aptUtils) {
        List entries = ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(cpInfo, ClasspathInfo.PathKind.SOURCE).entries();
        if (entries.isEmpty()) {
            return false;
        }
        URL sourceRoot = aptUtils.getRoot().toURL();
        for (ClassPath.Entry entry : entries) {
            if (!sourceRoot.equals(entry.getURL())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasResource(@NonNull String resource, ClassPath ... cps) {
        for (ClassPath cp : cps) {
            if (cp == null || cp.findResource(resource) == null) continue;
            return true;
        }
        return false;
    }

    public static void logTime(FileObject source, JavaSource.Phase phase, long time) {
        assert (source != null && phase != null);
        String message = phase2Message.get((Object)phase);
        assert (message != null);
        TIME_LOGGER.log(Level.FINE, message, new Object[]{source, time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSource(CompilationInfoImpl info, Throwable exc) {
        String userDir = System.getProperty("netbeans.user");
        if (userDir == null) {
            return;
        }
        String dumpDir = userDir + "/var/log/";
        String src = info.getText();
        FileObject file = info.getFileObject();
        String fileName = FileUtil.getFileDisplayName((FileObject)file);
        String origName = file.getName();
        File f = new File(dumpDir + origName + ".dump");
        boolean dumpSucceeded = false;
        for (int i = 1; i < MAX_DUMPS && f.exists(); ++i) {
            f = new File(dumpDir + origName + '_' + i + ".dump");
        }
        if (!f.exists()) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));){
                    writer.println(src);
                    writer.println("----- Classpath: ---------------------------------------------");
                    ClassPath bootPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    writer.println("bootPath: " + (bootPath != null ? bootPath.toString() : "null"));
                    writer.println("classPath: " + (classPath != null ? classPath.toString() : "null"));
                    writer.println("sourcePath: " + (sourcePath != null ? sourcePath.toString() : "null"));
                    writer.println("----- Original exception ---------------------------------------------");
                    exc.printStackTrace(writer);
                }
                finally {
                    dumpSucceeded = true;
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Error when writing parser dump file!", ioe);
            }
        }
        if (dumpSucceeded) {
            try {
                Throwable t = Exceptions.attachMessage((Throwable)exc, (String)("An error occurred during parsing of '" + fileName + "'. Please report a bug against java/source and attach dump file '" + f.getAbsolutePath() + "'."));
                Exceptions.printStackTrace((Throwable)t);
            }
            catch (RuntimeException re) {
                Exceptions.printStackTrace((Throwable)exc);
            }
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + dumpDir + "' and clean all *.dump files in that directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSourceModification(SourceModificationEvent evt) {
        if (evt instanceof SourceModificationEvent.Composite) {
            evt = ((SourceModificationEvent.Composite)evt).getWriteEvent();
        }
        if (evt != null && evt.sourceChanged()) {
            Pair<DocPositionRegion, MethodTree> changedMethod = null;
            if (this.supportsReparse) {
                int start = evt.getAffectedStartOffset();
                int end = evt.getAffectedEndOffset();
                List<Pair<DocPositionRegion, MethodTree>> list = this.positions;
                synchronized (list) {
                    for (Pair<DocPositionRegion, MethodTree> pe : this.positions) {
                        PositionRegion p = (PositionRegion)pe.first();
                        if (start <= p.getStartOffset() || end >= p.getEndOffset()) continue;
                        changedMethod = pe;
                        break;
                    }
                    this.positions.clear();
                    if (changedMethod != null) {
                        this.positions.add(changedMethod);
                    }
                    this.changedMethod.set(changedMethod);
                }
            }
        } else {
            this.positions.clear();
            this.changedMethod.set(null);
        }
    }

    public synchronized void setChangedMethod(Pair<DocPositionRegion, MethodTree> changedMethod) {
        assert (changedMethod != null);
        this.changedMethod.set(changedMethod);
    }

    static {
        phase2Message.put(JavaSource.Phase.PARSED, "Parsed");
        phase2Message.put(JavaSource.Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Message.put(JavaSource.Phase.RESOLVED, "Attributed");
        DISABLE_SOURCE_LEVEL_DOWNGRADE = false;
    }

    public static interface SequentialParsing {
        public Iterable<? extends CompilationUnitTree> parse(JavacTask var1, JavaFileObject var2) throws IOException;
    }

    public static class VanillaJavacContextEnhancer
    implements ContextEnhancer {
        @Override
        public void enhance(Context context, boolean backgroundCompilation) {
            if (!backgroundCompilation) {
                NBJavadocClassFinder.preRegister((Context)context);
            } else {
                NBClassFinder.preRegister((Context)context);
            }
            NBJavaCompiler.preRegister((Context)context);
        }
    }

    public static interface ContextEnhancer {
        public void enhance(Context var1, boolean var2);
    }

    public static interface DuplicateClassRegistry {
        public void enhance(Context var1, FQN2Files var2);
    }

    public static interface TreeLoaderRegistry {
        public void enhance(Context var1, ClasspathInfo var2, boolean var3);
    }

    public static class ProcessorHolder {
        private Collection<? extends Processor> processors;

        public static ProcessorHolder instance(Context ctx) {
            ProcessorHolder instance = ctx.get(ProcessorHolder.class);
            if (instance == null) {
                instance = new ProcessorHolder();
                ctx.put(ProcessorHolder.class, instance);
            }
            return instance;
        }

        public void setProcessors(Collection<? extends Processor> processors) {
            this.processors = processors;
        }

        public Collection<? extends Processor> getProcessors() {
            return this.processors;
        }
    }

    public static class DefaultPartialReparser
    implements PartialReparser {
        @Override
        public boolean reparseMethod(CompilationInfoImpl ci, Snapshot snapshot, MethodTree orig, String newBody) throws IOException {
            return false;
        }
    }

    public static interface PartialReparser {
        public boolean reparseMethod(CompilationInfoImpl var1, Snapshot var2, MethodTree var3, String var4) throws IOException;
    }

    private final class FilterListener
    implements ChangeListener {
        public FilterListener(JavaFileFilterImplementation filter) {
            filter.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)filter));
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            JavacParser.this.listeners.fireChange();
        }
    }

    private static class DefaultCancelService
    extends CancelService {
        final AtomicBoolean mayCancel = new AtomicBoolean();
        private final JavacParser parser;

        private DefaultCancelService(JavacParser parser) {
            this.parser = parser;
        }

        public static void preRegister(Context context, CancelService cancelServiceToRegister) {
            context.put(cancelServiceKey, cancelServiceToRegister);
        }

        public static DefaultCancelService instance(Context ctx) {
            assert (ctx != null);
            CancelService cancelService = CancelService.instance((Context)ctx);
            return cancelService instanceof DefaultCancelService ? (DefaultCancelService)cancelService : null;
        }

        public boolean isCanceled() {
            return this.mayCancel.get() && this.parser.parserCanceled.get();
        }
    }

    private static enum ConfigFlags {
        BACKGROUND_COMPILATION,
        MULTI_SOURCE,
        MODULE_INFO;

    }
}

