/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.BorderLayout;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EditLayoutSpacePanel
extends JPanel {
    private LayoutDesigner.EditableGap[] editableGaps;
    private JLabel actualSizeLabel;
    private JComboBox bottomCombo;
    private JLabel bottomLabel;
    private JPanel componentGapsPanel;
    private JLabel componentsTitle;
    private JLabel defSizeLabel;
    private JComboBox leftCombo;
    private JLabel leftLabel;
    private JCheckBox resBottomCheckBox;
    private JCheckBox resLeftCheckBox;
    private JCheckBox resRightCheckBox;
    private JCheckBox resTopCheckBox;
    private JComboBox rightCombo;
    private JLabel rightLabel;
    private JPanel singleGapPanel;
    private JCheckBox singleResCheckBox;
    private JComboBox singleSizeCombo;
    private JLabel singleTitleLabel;
    private JComboBox topCombo;
    private JLabel topLabel;

    EditLayoutSpacePanel(LayoutDesigner.EditableGap[] editableGaps, String componentName) {
        this.editableGaps = editableGaps;
        this.initComponents();
        if (editableGaps.length == 1) {
            this.add(this.singleGapPanel);
            this.initSingleGapValues();
        } else {
            this.add(this.componentGapsPanel);
            this.initComponentGapsValues(componentName);
        }
    }

    private void initSingleGapValues() {
        LayoutDesigner.EditableGap eg = this.editableGaps[0];
        this.singleTitleLabel.setText(NbBundle.getMessage(EditLayoutSpacePanel.class, (String)(eg.getDimension() == 0 ? "CTL_singleTitleLabel_H" : "CTL_singleTitleLabel_V")));
        EditLayoutSpacePanel.initGapValues(eg, this.singleSizeCombo, this.singleResCheckBox);
        if (eg.definedSize != eg.getActualSize()) {
            this.actualSizeLabel.setText(NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"FMT_actualSizelabel", (Object)Integer.toString(eg.getActualSize())));
        } else {
            this.actualSizeLabel.setVisible(false);
        }
    }

    private void initComponentGapsValues(String compName) {
        this.componentsTitle.setText(NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"FMT_componentsTitle", (Object)compName));
        EditLayoutSpacePanel.initGapValues(this.editableGaps[0], this.leftCombo, this.resLeftCheckBox);
        EditLayoutSpacePanel.initGapValues(this.editableGaps[1], this.rightCombo, this.resRightCheckBox);
        EditLayoutSpacePanel.initGapValues(this.editableGaps[2], this.topCombo, this.resTopCheckBox);
        EditLayoutSpacePanel.initGapValues(this.editableGaps[3], this.bottomCombo, this.resBottomCheckBox);
    }

    private static void initGapValues(LayoutDesigner.EditableGap eg, JComboBox sizeCombo, JCheckBox resCheckBox) {
        if (eg != null) {
            String selected = null;
            String[] defaultNames = eg.getPaddingDisplayNames();
            if (eg.canHaveDefaultValue() && defaultNames != null) {
                sizeCombo.setModel(new DefaultComboBoxModel<String>(defaultNames));
                if (eg.definedSize == -1) {
                    LayoutConstants.PaddingType[] defaultTypes = eg.getPossiblePaddingTypes();
                    if (eg.paddingType == null || defaultTypes == null || defaultTypes.length == 0) {
                        selected = defaultNames[0];
                    } else {
                        for (int i = 0; i < defaultTypes.length; ++i) {
                            if (eg.paddingType != defaultTypes[i]) continue;
                            selected = defaultNames[i];
                            break;
                        }
                    }
                }
            }
            if (selected == null) {
                selected = Integer.toString(eg.definedSize);
            }
            sizeCombo.setSelectedItem(selected);
            resCheckBox.setSelected(eg.resizing);
        } else {
            sizeCombo.setSelectedItem(NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"VALUE_NoEmptySpace"));
            sizeCombo.setEnabled(false);
            resCheckBox.setEnabled(false);
        }
    }

    boolean applyValues() {
        if (this.editableGaps.length == 1) {
            return EditLayoutSpacePanel.applyGapValues(this.editableGaps[0], this.singleSizeCombo, this.singleResCheckBox);
        }
        if (this.editableGaps[0] != null && !EditLayoutSpacePanel.applyGapValues(this.editableGaps[0], this.leftCombo, this.resLeftCheckBox)) {
            return false;
        }
        if (this.editableGaps[1] != null && !EditLayoutSpacePanel.applyGapValues(this.editableGaps[1], this.rightCombo, this.resRightCheckBox)) {
            return false;
        }
        if (this.editableGaps[2] != null && !EditLayoutSpacePanel.applyGapValues(this.editableGaps[2], this.topCombo, this.resTopCheckBox)) {
            return false;
        }
        return this.editableGaps[3] == null || EditLayoutSpacePanel.applyGapValues(this.editableGaps[3], this.bottomCombo, this.resBottomCheckBox);
    }

    private static boolean applyGapValues(LayoutDesigner.EditableGap eg, JComboBox sizeCombo, JCheckBox resCheckBox) {
        int newSize = Integer.MIN_VALUE;
        LayoutConstants.PaddingType newPadding = null;
        Object selSize = sizeCombo.getSelectedItem();
        if (eg.canHaveDefaultValue()) {
            int n = eg.getPaddingDisplayNames().length;
            for (int i = 0; i < n; ++i) {
                String pdn = eg.getPaddingDisplayNames()[i];
                if (!pdn.equals(selSize)) continue;
                newSize = -1;
                if (eg.getPossiblePaddingTypes() == null) break;
                newPadding = eg.getPossiblePaddingTypes()[i];
                break;
            }
        }
        if (newSize == Integer.MIN_VALUE) {
            try {
                newSize = Integer.parseInt((String)selSize);
                if (newSize < 0) {
                    EditLayoutSpacePanel.notify("MSG_NegativeSpaceSize");
                    return false;
                }
                if (newSize > Short.MAX_VALUE) {
                    EditLayoutSpacePanel.notify("MSG_TooLargeSpaceSize");
                    return false;
                }
            }
            catch (NumberFormatException nfex) {
                EditLayoutSpacePanel.notify("MSG_CorruptedSpaceSize");
                return false;
            }
        }
        eg.definedSize = newSize;
        eg.paddingType = newPadding;
        eg.resizing = resCheckBox.isSelected();
        return true;
    }

    private static void notify(String messageKey) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)messageKey));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    private void initComponents() {
        this.componentGapsPanel = new JPanel();
        this.leftLabel = new JLabel();
        this.rightLabel = new JLabel();
        this.topLabel = new JLabel();
        this.bottomLabel = new JLabel();
        this.leftCombo = new JComboBox();
        this.rightCombo = new JComboBox();
        this.topCombo = new JComboBox();
        this.bottomCombo = new JComboBox();
        this.resLeftCheckBox = new JCheckBox();
        this.resRightCheckBox = new JCheckBox();
        this.resTopCheckBox = new JCheckBox();
        this.resBottomCheckBox = new JCheckBox();
        this.componentsTitle = new JLabel();
        this.singleGapPanel = new JPanel();
        this.singleTitleLabel = new JLabel();
        this.defSizeLabel = new JLabel();
        this.singleSizeCombo = new JComboBox();
        this.singleResCheckBox = new JCheckBox();
        this.actualSizeLabel = new JLabel();
        this.leftLabel.setLabelFor(this.leftCombo);
        Mnemonics.setLocalizedText((JLabel)this.leftLabel, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"EditLayoutSpacePanel.leftLabel.text"));
        this.rightLabel.setLabelFor(this.rightCombo);
        Mnemonics.setLocalizedText((JLabel)this.rightLabel, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"EditLayoutSpacePanel.rightLabel.text"));
        this.topLabel.setLabelFor(this.topCombo);
        Mnemonics.setLocalizedText((JLabel)this.topLabel, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"EditLayoutSpacePanel.topLabel.text"));
        this.bottomLabel.setLabelFor(this.bottomCombo);
        Mnemonics.setLocalizedText((JLabel)this.bottomLabel, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"EditLayoutSpacePanel.bottomLabel.text"));
        this.leftCombo.setEditable(true);
        this.rightCombo.setEditable(true);
        this.topCombo.setEditable(true);
        this.bottomCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.resLeftCheckBox, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"NAME_SpaceResizable2"));
        Mnemonics.setLocalizedText((AbstractButton)this.resRightCheckBox, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"NAME_SpaceResizable2"));
        Mnemonics.setLocalizedText((AbstractButton)this.resTopCheckBox, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"NAME_SpaceResizable2"));
        Mnemonics.setLocalizedText((AbstractButton)this.resBottomCheckBox, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"NAME_SpaceResizable2"));
        Mnemonics.setLocalizedText((JLabel)this.componentsTitle, (String)"(Gaps Around Selected Component)");
        GroupLayout componentGapsPanelLayout = new GroupLayout(this.componentGapsPanel);
        this.componentGapsPanel.setLayout(componentGapsPanelLayout);
        componentGapsPanelLayout.setHorizontalGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(componentGapsPanelLayout.createSequentialGroup().addContainerGap().addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(componentGapsPanelLayout.createSequentialGroup().addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.rightLabel).addComponent(this.leftLabel).addComponent(this.topLabel).addComponent(this.bottomLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftCombo, 0, -1, Short.MAX_VALUE).addComponent(this.rightCombo, 0, -1, Short.MAX_VALUE).addComponent(this.topCombo, 0, -1, Short.MAX_VALUE).addComponent(this.bottomCombo, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resLeftCheckBox).addComponent(this.resRightCheckBox).addComponent(this.resTopCheckBox).addComponent(this.resBottomCheckBox))).addGroup(componentGapsPanelLayout.createSequentialGroup().addComponent(this.componentsTitle).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        componentGapsPanelLayout.setVerticalGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(componentGapsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.componentsTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.leftLabel).addComponent(this.leftCombo, -2, -1, -2).addComponent(this.resLeftCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rightLabel).addComponent(this.rightCombo, -2, -1, -2).addComponent(this.resRightCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topLabel).addComponent(this.topCombo, -2, -1, -2).addComponent(this.resTopCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(componentGapsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bottomLabel).addComponent(this.bottomCombo, -2, -1, -2).addComponent(this.resBottomCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.singleTitleLabel, (String)"(Selected Layout Gap: H/ V)");
        this.defSizeLabel.setLabelFor(this.singleSizeCombo);
        Mnemonics.setLocalizedText((JLabel)this.defSizeLabel, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"EditLayoutSpacePanel.defSizeLabel.text"));
        this.singleSizeCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.singleResCheckBox, (String)NbBundle.getMessage(EditLayoutSpacePanel.class, (String)"NAME_SpaceResizable"));
        Mnemonics.setLocalizedText((JLabel)this.actualSizeLabel, (String)"(Actual Size)");
        GroupLayout singleGapPanelLayout = new GroupLayout(this.singleGapPanel);
        this.singleGapPanel.setLayout(singleGapPanelLayout);
        singleGapPanelLayout.setHorizontalGroup(singleGapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(singleGapPanelLayout.createSequentialGroup().addContainerGap().addGroup(singleGapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(singleGapPanelLayout.createSequentialGroup().addComponent(this.defSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleSizeCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.singleResCheckBox)).addGroup(singleGapPanelLayout.createSequentialGroup().addComponent(this.singleTitleLabel).addGap(18, 18, 18).addComponent(this.actualSizeLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        singleGapPanelLayout.setVerticalGroup(singleGapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(singleGapPanelLayout.createSequentialGroup().addContainerGap().addGroup(singleGapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singleTitleLabel).addComponent(this.actualSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(singleGapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defSizeLabel).addComponent(this.singleSizeCombo, -2, -1, -2).addComponent(this.singleResCheckBox)).addGap(0, 0, 0)));
        this.setLayout(new BorderLayout());
    }
}

