/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormServices;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

class CopySupport {
    private static final String flavorMimeType = "application/x-form-metacomponent;class=java.lang.Object";
    private static DataFlavor copyFlavor;
    private static DataFlavor cutFlavor;

    CopySupport() {
    }

    static DataFlavor getComponentCopyFlavor() {
        if (copyFlavor == null) {
            copyFlavor = new DataFlavor(flavorMimeType, "COMPONENT_COPY_FLAVOR");
        }
        return copyFlavor;
    }

    static DataFlavor getComponentCutFlavor() {
        if (cutFlavor == null) {
            cutFlavor = new DataFlavor(flavorMimeType, "COMPONENT_CUT_FLAVOR");
        }
        return cutFlavor;
    }

    public static boolean canPasteCut(RADComponent sourceComponent, FormModel targetForm, RADComponent targetComponent) {
        if (!sourceComponent.isInModel()) {
            return false;
        }
        if (sourceComponent.getFormModel() != targetForm) {
            return true;
        }
        if (targetComponent == null) {
            return targetForm.getModelContainer().getIndexOf(sourceComponent) < 0;
        }
        return sourceComponent != targetComponent && sourceComponent.getParentComponent() != targetComponent && !sourceComponent.isParentComponent(targetComponent);
    }

    static void createPasteTypes(Transferable trans, List<PasteType> s, FormModel targetForm, RADComponent targetComponent) {
        Transferable[] allTrans;
        if (targetForm.isReadOnly()) {
            return;
        }
        if (trans.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject transObj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                allTrans = new Transferable[transObj.getCount()];
                for (int i = 0; i < allTrans.length; ++i) {
                    allTrans[i] = transObj.getTransferableAt(i);
                }
            }
            catch (UnsupportedFlavorException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return;
            }
        } else {
            allTrans = new Transferable[]{trans};
        }
        boolean canPaste = false;
        boolean cut = false;
        LinkedList<RADComponent> sourceComponents = null;
        for (int i = 0; i < allTrans.length; ++i) {
            boolean metaCompTransfer;
            Transferable t = allTrans[i];
            if (t.isDataFlavorSupported(CopySupport.getComponentCopyFlavor())) {
                assert (!cut);
                metaCompTransfer = true;
            } else if (t.isDataFlavorSupported(CopySupport.getComponentCutFlavor())) {
                assert (cut || sourceComponents == null);
                metaCompTransfer = true;
                cut = true;
            } else {
                metaCompTransfer = false;
            }
            if (metaCompTransfer) {
                RADComponent componentToCopy;
                RADComponent transComp = null;
                try {
                    Object data = t.getTransferData(t.getTransferDataFlavors()[0]);
                    if (data instanceof RADComponent) {
                        transComp = (RADComponent)data;
                    }
                }
                catch (UnsupportedFlavorException data) {
                }
                catch (IOException data) {
                    // empty catch block
                }
                if (transComp == null || cut && !CopySupport.canPasteCut(transComp, targetForm, targetComponent) || !MetaComponentCreator.canAddComponent(transComp.getBeanClass(), targetComponent) && (cut || !MetaComponentCreator.canApplyComponent(transComp.getBeanClass(), targetComponent)) || targetComponent instanceof RADMenuComponent && !(transComp instanceof RADMenuItemComponent)) continue;
                if (sourceComponents == null) {
                    sourceComponents = new LinkedList<RADComponent>();
                }
                if (!sourceComponents.contains(componentToCopy = CopySupport.getComponentToCopy(transComp, targetComponent, cut))) {
                    sourceComponents.add(componentToCopy);
                }
                canPaste = true;
                continue;
            }
            ClassSource classSource = CopySupport.getCopiedBeanClassSource(t);
            if (classSource == null) continue;
            s.add(new ClassPaste(t, classSource, targetForm, targetComponent));
            canPaste = true;
        }
        if (sourceComponents != null) {
            s.add(new RADPaste(sourceComponents, targetForm, targetComponent, cut));
        }
        if (!(canPaste || targetComponent == null || targetComponent instanceof ComponentContainer && !MetaComponentCreator.isTransparentLayoutComponent(targetComponent) || targetComponent.getParentComponent() == null)) {
            CopySupport.createPasteTypes(trans, s, targetForm, targetComponent.getParentComponent());
        }
    }

    private static RADComponent getComponentToCopy(RADComponent metacomp, RADComponent targetComp, boolean cut) {
        RADComponent parent = metacomp.getParentComponent();
        if (MetaComponentCreator.isTransparentLayoutComponent(parent) && (!cut || parent.getParentComponent() != targetComp)) {
            return parent;
        }
        return metacomp;
    }

    static ClassSource getCopiedBeanClassSource(Transferable transferable) {
        FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
        return services.getCopiedBeanClassSource(transferable);
    }

    private static class ClassPaste
    extends PasteType
    implements Mutex.ExceptionAction<Transferable> {
        private Transferable transferable;
        private ClassSource classSource;
        private FormModel targetForm;
        private RADComponent targetComponent;

        ClassPaste(Transferable t, ClassSource classSource, FormModel targetForm, RADComponent targetComponent) {
            this.transferable = t;
            this.classSource = classSource;
            this.targetForm = targetForm;
            this.targetComponent = targetComponent;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return this.transferable;
            }
        }

        public Transferable run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            if (this.classSource.getClassName().indexOf(46) == -1 && !FormJavaSource.isInDefaultPackage(this.targetForm)) {
                String message = FormUtils.getBundleString("MSG_DefaultPackageBean");
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            } else {
                this.targetForm.getComponentCreator().createComponent(this.classSource, this.targetComponent, null);
            }
            return this.transferable;
        }
    }

    private static class RADPaste
    extends PasteType
    implements Mutex.ExceptionAction<Transferable> {
        private List<RADComponent> sourceComponents;
        private FormModel targetForm;
        private RADComponent targetComponent;
        private boolean fromCut;

        RADPaste(List<RADComponent> sourceComponents, FormModel targetForm, RADComponent targetComponent, boolean cut) {
            this.sourceComponents = sourceComponents;
            this.targetForm = targetForm;
            this.targetComponent = targetComponent;
            this.fromCut = cut;
        }

        public String getName() {
            return FormUtils.getBundleString(this.fromCut ? "CTL_CutPaste" : "CTL_CopyPaste");
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return ExTransferable.EMPTY;
            }
        }

        public Transferable run() throws Exception {
            return this.doPaste();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private Transferable doPaste() throws IOException {
            RADVisualContainer parent;
            if (this.sourceComponents == null || this.sourceComponents.isEmpty()) {
                return null;
            }
            FormModel sourceForm = this.sourceComponents.get(0).getFormModel();
            boolean move = this.fromCut && sourceForm == this.targetForm;
            boolean autoUndo = true;
            LayoutModel sourceLayout = sourceForm.getLayoutModel();
            LayoutModel targetLayout = this.targetForm.getLayoutModel();
            ArrayList<RADComponent> copiedComponents = null;
            boolean targetNewLayout = this.targetComponent instanceof RADVisualContainer && ((RADVisualContainer)this.targetComponent).getLayoutSupport() == null;
            RADVisualContainer sourceContainer = null;
            HashMap<String, String> sourceToTargetId = null;
            HashMap<String, Rectangle> idToBounds = null;
            if (targetNewLayout) {
                for (RADComponent rADComponent : this.sourceComponents) {
                    if (rADComponent instanceof RADVisualComponent) {
                        RADVisualComponent sourceCompVisual = (RADVisualComponent)rADComponent;
                        if (sourceCompVisual.isMenuComponent()) continue;
                        RADVisualContainer parent2 = sourceCompVisual.getParentContainer();
                        if (sourceContainer == null) {
                            sourceContainer = parent2;
                            continue;
                        }
                        if (parent2 == sourceContainer) continue;
                        sourceContainer = null;
                        break;
                    }
                    sourceContainer = null;
                    break;
                }
                if (sourceContainer != null && sourceContainer.getLayoutSupport() == null) {
                    LayoutInterval commonRoot = null;
                    for (RADComponent sourceComp : this.sourceComponents) {
                        RADVisualComponent sourceCompVisual = (RADVisualComponent)sourceComp;
                        if (sourceCompVisual.isMenuComponent()) continue;
                        LayoutComponent layoutComp = sourceLayout.getLayoutComponent(sourceCompVisual.getId());
                        if (layoutComp == null) {
                            commonRoot = null;
                            break;
                        }
                        LayoutInterval compInterval = layoutComp.getLayoutInterval(0);
                        if (commonRoot == null) {
                            commonRoot = compInterval.getRoot();
                            continue;
                        }
                        if (commonRoot.isParentOf(compInterval)) continue;
                        commonRoot = null;
                        break;
                    }
                    if (commonRoot == null) {
                        sourceContainer = null;
                    }
                } else if (!(sourceContainer == null || sourceContainer.getLayoutSupport() == null || RADPaste.getComponentBounds(this.sourceComponents.get(0)) != null && RADPaste.isConvertibleLayout(sourceContainer))) {
                    sourceContainer = null;
                }
            }
            Object layoutUndoMark = null;
            Object var12_15 = null;
            boolean layoutModelAffected = false;
            if (targetNewLayout) {
                layoutModelAffected = true;
            } else if (move) {
                for (RADComponent sourceComp : this.sourceComponents) {
                    RADVisualComponent sourceCompVisual;
                    if (!(sourceComp instanceof RADVisualComponent) || (sourceCompVisual = (RADVisualComponent)sourceComp).isMenuComponent() || (parent = sourceCompVisual.getParentContainer()) == null || parent.getLayoutSupport() != null) continue;
                    layoutModelAffected = true;
                    break;
                }
            }
            if (layoutModelAffected) {
                layoutUndoMark = targetLayout.getChangeMark();
                UndoableEdit undoableEdit = targetLayout.getUndoableEdit();
            }
            try {
                for (RADComponent sourceComp : this.sourceComponents) {
                    RADComponent copiedComp;
                    if (!move) {
                        copiedComp = this.targetForm.getComponentCreator().copyComponent(sourceComp, this.targetComponent);
                        if (copiedComp == null) {
                            parent = null;
                            return parent;
                        }
                    } else {
                        this.targetForm.getComponentCreator().moveComponent(sourceComp, this.targetComponent);
                        copiedComp = sourceComp;
                    }
                    if (!(copiedComp instanceof RADVisualComponent) || ((RADVisualComponent)copiedComp).isMenuComponent() || !(sourceComp instanceof RADVisualComponent)) continue;
                    if (targetNewLayout) {
                        if (sourceContainer != null) {
                            if (sourceContainer.getLayoutSupport() == null) {
                                if (sourceToTargetId == null) {
                                    sourceToTargetId = new HashMap<String, String>();
                                }
                                sourceToTargetId.put(sourceComp.getId(), copiedComp.getId());
                                if (copiedComp == sourceComp) continue;
                                if (copiedComponents == null) {
                                    copiedComponents = new ArrayList<RADComponent>(this.sourceComponents.size());
                                }
                                copiedComponents.add(copiedComp);
                                continue;
                            }
                            if (idToBounds == null) {
                                idToBounds = new HashMap<String, Rectangle>();
                            }
                            idToBounds.put(copiedComp.getId(), RADPaste.getComponentBounds(sourceComp));
                            continue;
                        }
                        this.getLayoutDesigner().addUnspecifiedComponent(copiedComp.getId(), sourceComp.getId(), RADPaste.getComponentSize(sourceComp), this.targetComponent.getId());
                        continue;
                    }
                    if (!move || sourceLayout == null || sourceForm != this.targetForm) continue;
                    this.getLayoutDesigner().removeComponentsFromParent(sourceComp.getId());
                }
                if (sourceToTargetId != null) {
                    this.getLayoutDesigner().copyLayout(sourceLayout, sourceToTargetId, this.targetComponent.getId());
                } else if (idToBounds != null) {
                    this.getLayoutDesigner().copyLayoutFromOutside(idToBounds, this.targetComponent.getId(), true);
                }
                autoUndo = false;
            }
            finally {
                if (layoutUndoMark != null && !layoutUndoMark.equals(targetLayout.getChangeMark())) {
                    void var12_17;
                    this.targetForm.addUndoableEdit((UndoableEdit)var12_17);
                }
                if (autoUndo) {
                    this.targetForm.forceUndoOfCompoundEdit();
                }
            }
            if (this.fromCut && sourceForm != this.targetForm) {
                for (RADComponent sourceComp : this.sourceComponents) {
                    RADComponentNode sourceNode = sourceComp.getNodeReference();
                    if (sourceNode == null) continue;
                    sourceNode.destroy();
                }
            }
            if (this.fromCut) {
                return ExTransferable.EMPTY;
            }
            if (copiedComponents != null) {
                if (copiedComponents.size() == 1) {
                    return new RADTransferable(CopySupport.getComponentCopyFlavor(), (RADComponent)copiedComponents.get(0));
                }
                Transferable[] trans = new Transferable[copiedComponents.size()];
                int i = 0;
                for (RADComponent comp : copiedComponents) {
                    trans[i++] = new RADTransferable(CopySupport.getComponentCopyFlavor(), comp);
                }
                return new ExTransferable.Multi(trans);
            }
            return null;
        }

        private static Rectangle getComponentBounds(RADComponent sourceComp) {
            Component comp;
            FormDesigner designer = FormEditor.getFormDesigner(sourceComp.getFormModel());
            if (designer != null && (comp = (Component)designer.getComponent(sourceComp)) != null) {
                return comp.getBounds();
            }
            return null;
        }

        private static Dimension getComponentSize(RADComponent sourceComp) {
            Component comp;
            FormDesigner designer = FormEditor.getFormDesigner(sourceComp.getFormModel());
            if (designer != null && (comp = (Component)designer.getComponent(sourceComp)) != null) {
                return comp.getSize();
            }
            return null;
        }

        private static boolean isConvertibleLayout(RADVisualContainer metaCont) {
            LayoutSupportManager ls = metaCont.getLayoutSupport();
            return !ls.isDedicated() && ls.getSupportedClass() != CardLayout.class;
        }

        private LayoutDesigner getLayoutDesigner() {
            return FormEditor.getFormDesigner(this.targetForm).getLayoutDesigner();
        }
    }

    static class RADTransferable
    implements Transferable {
        private RADComponent radComponent;
        private DataFlavor[] flavors;

        RADTransferable(DataFlavor flavor, RADComponent radComponent) {
            this(new DataFlavor[]{flavor}, radComponent);
        }

        RADTransferable(DataFlavor[] flavors, RADComponent radComponent) {
            this.flavors = flavors;
            this.radComponent = radComponent;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (this.flavors[i] != flavor) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if ("x-form-metacomponent".equals(flavor.getSubType())) {
                return this.radComponent;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

