/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.documentation.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.documentation.PhpDocumentations;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.documentation.PhpDocumentationProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleCustomizer;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerDocumentation
extends JPanel
implements ChangeListener {
    private final ProjectCustomizer.Category category;
    private final PhpModule phpModule;
    private final Map<PhpDocumentationProvider, PhpModuleCustomizer> providerPanels;
    private final PhpDocumentationProvider originalProvider;
    private volatile PhpDocumentationProvider selectedProvider;
    private JComboBox<PhpDocumentationProvider> providerComboBox;
    private JLabel providerLabel;
    private JPanel providerPanel;
    private JSeparator separator;

    CustomizerDocumentation(ProjectCustomizer.Category category, PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (category != null);
        assert (phpModule != null);
        this.category = category;
        this.phpModule = phpModule;
        this.originalProvider = this.getOriginalProvider();
        this.providerPanels = this.createProviderPanels();
        this.initComponents();
        this.init();
    }

    private PhpDocumentationProvider getOriginalProvider() {
        for (PhpDocumentationProvider provider : PhpDocumentations.getDocumentations()) {
            if (!provider.isInPhpModule(this.phpModule)) continue;
            return provider;
        }
        return null;
    }

    private Map<PhpDocumentationProvider, PhpModuleCustomizer> createProviderPanels() {
        ConcurrentHashMap<PhpDocumentationProvider, PhpModuleCustomizer> panels = new ConcurrentHashMap<PhpDocumentationProvider, PhpModuleCustomizer>();
        for (PhpDocumentationProvider provider : PhpDocumentations.getDocumentations()) {
            PhpModuleCustomizer customizer = provider.createPhpModuleCustomizer(this.phpModule);
            if (customizer == null) continue;
            panels.put(provider, customizer);
        }
        return panels;
    }

    private void init() {
        for (PhpDocumentationProvider provider : this.getProviders()) {
            this.providerComboBox.addItem(provider);
        }
        if (this.originalProvider != null) {
            this.providerComboBox.setSelectedItem(this.originalProvider);
        }
        this.providerComboBox.setRenderer(new PhpDocumentationProviderRenderer());
        this.providerComboBox.addActionListener(new ProviderActionListener());
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerDocumentation.this.storeData();
            }
        });
        this.category.setCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerDocumentation.this.cleanup();
            }
        });
        this.providerChanged();
    }

    void providerChanged() {
        assert (EventQueue.isDispatchThread());
        this.removeListener();
        this.selectedProvider = this.getSelectedProvider();
        this.providerPanel.removeAll();
        PhpModuleCustomizer selectedPanel = this.getSelectedPanel();
        if (selectedPanel != null) {
            this.providerPanel.add((Component)selectedPanel.getComponent(), "Center");
            selectedPanel.addChangeListener((ChangeListener)this);
        }
        this.providerPanel.revalidate();
        this.providerPanel.repaint();
        this.validateData();
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        PhpModuleCustomizer customizer = this.getSelectedPanel();
        if (customizer != null) {
            String error = customizer.getErrorMessage();
            if (error != null) {
                this.category.setErrorMessage(error);
                this.category.setValid(false);
                return;
            }
            String warning = customizer.getWarningMessage();
            if (warning != null) {
                this.category.setErrorMessage(warning);
                this.category.setValid(true);
                return;
            }
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    void storeData() {
        assert (!EventQueue.isDispatchThread());
        if (this.originalProvider != this.selectedProvider) {
            if (this.originalProvider != null) {
                this.originalProvider.notifyEnabled(this.phpModule, false);
            }
            if (this.selectedProvider != null) {
                this.selectedProvider.notifyEnabled(this.phpModule, true);
            }
        }
        for (PhpModuleCustomizer customizer : this.getCustomizers()) {
            customizer.save();
        }
    }

    void cleanup() {
        this.removeListener();
        for (PhpModuleCustomizer customizer : this.getCustomizers()) {
            customizer.close();
        }
    }

    private void removeListener() {
        for (PhpModuleCustomizer customizer : this.getCustomizers()) {
            customizer.removeChangeListener((ChangeListener)this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateData();
    }

    @CheckForNull
    private PhpDocumentationProvider getSelectedProvider() {
        return (PhpDocumentationProvider)this.providerComboBox.getSelectedItem();
    }

    @CheckForNull
    private PhpModuleCustomizer getSelectedPanel() {
        assert (EventQueue.isDispatchThread());
        assert (this.providerPanels != null);
        PhpDocumentationProvider selecteProvider = this.getSelectedProvider();
        if (selecteProvider == null) {
            return null;
        }
        return this.providerPanels.get(selecteProvider);
    }

    private List<PhpDocumentationProvider> getProviders() {
        Set<PhpDocumentationProvider> providersWithPanels = this.providerPanels.keySet();
        ArrayList<PhpDocumentationProvider> providers = new ArrayList<PhpDocumentationProvider>(providersWithPanels.size());
        for (PhpDocumentationProvider provider : PhpDocumentations.getDocumentations()) {
            if (!providersWithPanels.contains(provider)) continue;
            providers.add(provider);
        }
        return providers;
    }

    private List<PhpModuleCustomizer> getCustomizers() {
        ArrayList<PhpModuleCustomizer> customizers = new ArrayList<PhpModuleCustomizer>(this.providerPanels.size());
        for (PhpDocumentationProvider provider : this.getProviders()) {
            PhpModuleCustomizer customizer = this.providerPanels.get(provider);
            assert (customizer != null) : "no customizer for " + provider.getName();
            customizers.add(this.providerPanels.get(provider));
        }
        return customizers;
    }

    private void initComponents() {
        this.providerLabel = new JLabel();
        this.providerComboBox = new JComboBox();
        this.separator = new JSeparator();
        this.providerPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.providerLabel, (String)NbBundle.getMessage(CustomizerDocumentation.class, (String)"CustomizerDocumentation.providerLabel.text"));
        this.providerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator).addGroup(layout.createSequentialGroup().addComponent(this.providerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerComboBox, -2, -1, -2)).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.providerLabel).addComponent(this.providerComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE)));
    }

    private final class ProviderActionListener
    implements ActionListener {
        private ProviderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerDocumentation.this.providerChanged();
        }
    }

    private static final class PhpDocumentationProviderRenderer
    implements ListCellRenderer<Object> {
        private final ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();

        private PhpDocumentationProviderRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            assert (EventQueue.isDispatchThread());
            if (value == null) {
                label = "";
            } else {
                assert (value instanceof PhpDocumentationProvider) : value.getClass().getName();
                label = ((PhpDocumentationProvider)value).getDisplayName();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, label, index, isSelected, cellHasFocus);
        }
    }
}

