/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class InfoCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
    private List<String> output = new ArrayList<String>();
    private final SVNUrl url;
    private final File[] files;
    private final SVNRevision revision;
    private final SVNRevision pegging;
    private final InfoType type;
    private static final String INFO_PATH = "Path";
    private static final String INFO_URL = "URL";
    private static final String INFO_REVISION = "Revision";
    private static final String INFO_REPOSITORY = "Repository Root";
    private static final String INFO_NODEKIND = "Node Kind";
    private static final String INFO_LAST_CHANGED_AUTHOR = "Last Changed Author";
    private static final String INFO_LAST_CHANGED_REVISION = "Last Changed Rev";
    private static final String INFO_LAST_CHANGED_DATE = "Last Changed Date";
    private static final String INFO_TEXT_LAST_UPDATED = "Text Last Updated";
    private static final String INFO_SCHEDULE = "Schedule";
    private static final String INFO_COPIED_FROM_URL = "Copied From URL";
    private static final String INFO_COPIED_FROM_REV = "Copied From Rev";
    private static final String INFO_PROPS_LAST_UPDATED = "Properties Last Updated";
    private static final String INFO_REPOSITORY_UUID = "Repository UUID";
    private static final String INFO_LOCK_OWNER = "Lock Owner";
    private static final String INFO_LOCK_CREATION_DATE = "Lock Created";
    private static final String INFO_LOCK_COMMENT = "Lock Comment";
    private static final String INFO_CONFLICT_PREVIOUS_BASE = "Conflict Previous Base File";
    private static final String INFO_CONFLICT_PREVIOUS_WORKING = "Conflict Previous Working File";
    private static final String INFO_CONFLICT_CURRENT_BASE = "Conflict Current Base File";

    public InfoCommand(SVNUrl url, SVNRevision revision, SVNRevision pegging) {
        this.url = url;
        this.revision = revision;
        this.pegging = pegging;
        this.files = null;
        this.type = InfoType.url;
    }

    public InfoCommand(File[] files, SVNRevision revision, SVNRevision pegging) {
        this.files = files;
        this.revision = revision;
        this.pegging = pegging;
        this.url = null;
        this.type = InfoType.files;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected int getCommand() {
        return 19;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("info");
        if (this.revision != null) {
            arguments.add(this.revision);
        }
        switch (this.type) {
            case url: {
                arguments.add(this.url, this.pegging);
                break;
            }
            case files: {
                arguments.addFileArguments(this.files);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported infotype: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public void outputText(String lineString) {
        if (lineString == null || lineString.trim().equals("")) {
            return;
        }
        this.output.add(lineString);
        super.outputText(lineString);
    }

    public ISVNInfo[] getInfo() throws SVNClientException {
        ArrayList<Info> infos = new ArrayList<Info>();
        HashMap<String, String> map = null;
        StringBuffer comment = new StringBuffer();
        for (int i = 0; i < this.output.size(); ++i) {
            int idx;
            String info;
            String outputLine = this.output.get(i);
            if (outputLine == null || outputLine.trim().equals("")) continue;
            if (outputLine.startsWith("Path:")) {
                if (map != null) {
                    infos.add(new Info(map));
                }
                map = new HashMap<String, String>();
            }
            if ((info = outputLine.substring(0, idx = outputLine.indexOf(58))).startsWith(INFO_LOCK_COMMENT)) {
                while (++i < this.output.size()) {
                    comment.append(this.output.get(i));
                    comment.append('\n');
                }
                map.put(INFO_LOCK_COMMENT, comment.toString());
            }
            String infoValue = outputLine.substring(idx + 1);
            map.put(info, infoValue.trim());
        }
        if (map != null) {
            infos.add(new Info(map));
        }
        if (infos.size() == 0 && this.url != null) {
            Subversion.LOG.warning("InfoCommand: Map is null for: " + this.output);
        }
        return infos.toArray(new Info[infos.size()]);
    }

    private SVNUrl getSVNUrl(String url) {
        try {
            return new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private SVNRevision.Number getNumber(String revision) {
        if (revision == null) {
            return null;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(revision));
        }
        catch (NumberFormatException e) {
            return new SVNRevision.Number(-1L);
        }
    }

    private Date getDate(String date) {
        if (date == null) {
            return null;
        }
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e1) {
            return null;
        }
    }

    private class Info
    implements ISVNInfo {
        private final Map<String, String> infoMap;

        public Info(Map<String, String> infoMap) {
            this.infoMap = infoMap;
        }

        public SVNRevision.Number getRevision() {
            return InfoCommand.this.getNumber(this.infoMap.get(InfoCommand.INFO_REVISION));
        }

        public Date getLastDateTextUpdate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_TEXT_LAST_UPDATED));
        }

        public String getUuid() {
            return this.infoMap.get(InfoCommand.INFO_REPOSITORY_UUID);
        }

        public SVNUrl getRepository() {
            return InfoCommand.this.getSVNUrl(this.infoMap.get(InfoCommand.INFO_REPOSITORY));
        }

        public SVNScheduleKind getSchedule() {
            return SVNScheduleKind.fromString((String)this.infoMap.get(InfoCommand.INFO_SCHEDULE));
        }

        public Date getLastDatePropsUpdate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_PROPS_LAST_UPDATED));
        }

        public boolean isCopied() {
            return this.getCopyRev() != null || this.getCopyUrl() != null;
        }

        public SVNRevision.Number getCopyRev() {
            return InfoCommand.this.getNumber(this.infoMap.get(InfoCommand.INFO_COPIED_FROM_REV));
        }

        public SVNUrl getCopyUrl() {
            return InfoCommand.this.getSVNUrl(this.infoMap.get(InfoCommand.INFO_COPIED_FROM_URL));
        }

        public Date getLockCreationDate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_LOCK_CREATION_DATE));
        }

        public String getLockOwner() {
            return this.infoMap.get(InfoCommand.INFO_LOCK_OWNER);
        }

        public String getLockComment() {
            return this.infoMap.get(InfoCommand.INFO_LOCK_COMMENT);
        }

        public File getConflictNew() {
            String path = this.infoMap.get(InfoCommand.INFO_CONFLICT_CURRENT_BASE);
            return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
        }

        public File getConflictOld() {
            String path = this.infoMap.get(InfoCommand.INFO_CONFLICT_PREVIOUS_BASE);
            return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
        }

        public File getConflictWorking() {
            String path = this.infoMap.get(InfoCommand.INFO_CONFLICT_PREVIOUS_WORKING);
            return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
        }

        public String getPath() {
            return this.infoMap.get(InfoCommand.INFO_PATH);
        }

        public File getFile() {
            return new File(this.getPath()).getAbsoluteFile();
        }

        public SVNUrl getUrl() {
            return InfoCommand.this.getSVNUrl(this.infoMap.get(InfoCommand.INFO_URL));
        }

        public String getUrlString() {
            return this.infoMap.get(InfoCommand.INFO_URL);
        }

        public Date getLastChangedDate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_LAST_CHANGED_DATE));
        }

        public SVNRevision.Number getLastChangedRevision() {
            return InfoCommand.this.getNumber(this.infoMap.get(InfoCommand.INFO_LAST_CHANGED_REVISION));
        }

        public String getLastCommitAuthor() {
            return this.infoMap.get(InfoCommand.INFO_LAST_CHANGED_AUTHOR);
        }

        public SVNNodeKind getNodeKind() {
            return SVNNodeKind.fromString((String)this.infoMap.get(InfoCommand.INFO_NODEKIND));
        }

        public int getDepth() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static enum InfoType {
        files,
        url;

    }
}

