/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.IconBases;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class BiFeature
implements IconBases,
Node.Cookie,
Comparable<BiFeature> {
    private static final Logger LOG = Logger.getLogger(BiFeature.class.getName());
    private static final String TEXT_EXPERT = "setExpert";
    private static final String TEXT_HIDDEN = "setHidden";
    private static final String TEXT_PREFERRED = "setPreferred";
    private static final String TEXT_DISPLAY_NAME = "setDisplayName";
    private static final String TEXT_SHORT_DESCRIPTION = "setShortDescription";
    private String displayName = null;
    private boolean expert = false;
    private boolean hidden = false;
    private String name = null;
    private boolean preferred = false;
    private String shortDescription = null;
    private boolean included = true;
    private String brackets = "]";
    private final BiAnalyser bia;

    public BiFeature(Pattern pattern, BiAnalyser bia) {
        this(pattern.getName(), bia);
    }

    BiFeature(String name, String displayName, BiAnalyser bia) {
        this.name = name;
        this.displayName = displayName;
        this.bia = bia;
    }

    protected BiFeature(BiAnalyser bia) {
        this("beanDescriptor", bia);
    }

    private BiFeature(String name, BiAnalyser bia) {
        this(name, null, bia);
    }

    abstract String getCreationString();

    protected final void setModified() {
        this.bia.setModified();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.setModified();
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
        this.setModified();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setModified();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
        this.setModified();
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        this.setModified();
    }

    abstract String getBracketedName();

    String getBrackets() {
        return this.brackets;
    }

    void setBrackets(String brackets) {
        this.brackets = brackets;
        this.setModified();
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
        this.setModified();
    }

    public String getToolTip() {
        return this.getName();
    }

    List<String> getCustomizationStrings() {
        ArrayList<String> col = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(100);
        if (this.expert) {
            sb.setLength(0);
            sb.append(TEXT_EXPERT).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.hidden) {
            sb.setLength(0);
            sb.append(TEXT_HIDDEN).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.preferred) {
            sb.setLength(0);
            sb.append(TEXT_PREFERRED).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.displayName != null && this.displayName.trim().length() > 0) {
            sb.setLength(0);
            sb.append(TEXT_DISPLAY_NAME).append(" ( ");
            sb.append(this.displayName).append(" )");
            col.add(sb.toString());
        }
        if (this.shortDescription != null && this.shortDescription.trim().length() > 0) {
            sb.setLength(0);
            sb.append(TEXT_SHORT_DESCRIPTION).append(" ( ");
            sb.append(this.shortDescription).append(" )");
            col.add(sb.toString());
        }
        return col;
    }

    void analyzeCustomization(Collection<String> code) throws GenerateBeanException {
        this.setIncluded(false);
        Iterator<String> it = code.iterator();
        String n = this.getBracketedName();
        String stNew = n + "=new";
        String stExpert = n + "." + TEXT_EXPERT;
        String stHidden = n + "." + TEXT_HIDDEN;
        String stPreferred = n + "." + TEXT_PREFERRED;
        String stDisplayName = n + "." + TEXT_DISPLAY_NAME;
        String stShortDescription = n + "." + TEXT_SHORT_DESCRIPTION;
        while (it.hasNext()) {
            String param;
            String statement = it.next();
            if (statement.indexOf(stNew) != -1) {
                this.setIncluded(true);
                this.analyzeCreationString(statement);
                continue;
            }
            if (statement.indexOf(stExpert) != -1) {
                this.setExpert(true);
                continue;
            }
            if (statement.indexOf(stHidden) != -1) {
                this.setHidden(true);
                continue;
            }
            if (statement.indexOf(stPreferred) != -1) {
                this.setPreferred(true);
                continue;
            }
            if (statement.indexOf(stDisplayName) != -1) {
                param = BiAnalyser.getArgumentParameter(statement);
                if (param == null) continue;
                this.setDisplayName(param);
                continue;
            }
            if (statement.indexOf(stShortDescription) != -1) {
                param = BiAnalyser.getArgumentParameter(statement);
                if (param == null) continue;
                this.setShortDescription(param);
                continue;
            }
            this.analyzeCustomizationString(statement);
        }
    }

    abstract String getIconBase(boolean var1);

    abstract void analyzeCreationString(String var1);

    abstract void analyzeCustomizationString(String var1);

    @Override
    public int compareTo(BiFeature other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public static final class Method
    extends BiFeature {
        private ElementHandle<ExecutableElement> element;
        private String varName;
        private String toolTip;
        private String creationString;

        Method(ExecutableElement me, PatternAnalyser pa, CompilationInfo javac, BiAnalyser bia) throws GenerateBeanException {
            super(me.getSimpleName().toString(), "\"\"", bia);
            this.element = ElementHandle.create((Element)me);
            this.toolTip = Method.initToolTip(me, javac);
            this.creationString = Method.initCreationString(me, javac);
        }

        @Override
        String getBracketedName() {
            return "[METHOD_" + this.getName() + "]";
        }

        private static String getTypeClass(TypeMirror type, CompilationInfo javac) {
            TypeKind kind = type.getKind();
            if (kind.isPrimitive()) {
                return type.toString();
            }
            if (kind == TypeKind.ARRAY) {
                return Method.resolveArrayClass((ArrayType)type, javac);
            }
            if (kind == TypeKind.DECLARED) {
                return ((TypeElement)((DeclaredType)type).asElement()).getQualifiedName().toString();
            }
            if (kind == TypeKind.ERROR) {
                return type.toString();
            }
            if (kind == TypeKind.TYPEVAR) {
                return javac.getTypes().erasure(type).toString();
            }
            throw new IllegalStateException("Unknown type: " + type + ", " + (Object)((Object)type.getKind()));
        }

        private static String resolveArrayClass(ArrayType array, CompilationInfo javac) {
            TypeMirror type = array;
            StringBuilder dim = new StringBuilder();
            int i = 0;
            while (type.getKind() == TypeKind.ARRAY) {
                type = type.getComponentType();
                dim.append("[]");
                ++i;
            }
            return Method.getTypeClass(type, javac) + dim;
        }

        @Override
        public String getToolTip() {
            return this.toolTip;
        }

        private static String initToolTip(ExecutableElement element, CompilationInfo javac) {
            return ElementHeaders.getHeader((Element)element, (CompilationInfo)javac, (String)"%name%%parameters% : %type%") + " :: " + ((TypeElement)element.getEnclosingElement()).getQualifiedName();
        }

        ElementHandle<ExecutableElement> getElement() {
            return this.element;
        }

        @Override
        String getCreationString() {
            return this.creationString;
        }

        private static String initCreationString(ExecutableElement element, CompilationInfo javac) {
            TypeElement enclClass = (TypeElement)element.getEnclosingElement();
            String code = "new MethodDescriptor(%1$s.class.getMethod(\"%2$s\", new Class[] {%3$s}))";
            String paramdelim = ", ";
            StringBuilder sb = new StringBuilder();
            for (VariableElement variableElement : element.getParameters()) {
                sb.append(paramdelim).append(Method.getTypeClass(variableElement.asType(), javac)).append(".class");
            }
            return String.format(code, enclClass.getQualifiedName(), element.getSimpleName(), sb.length() == 0 ? sb : sb.substring(paramdelim.length()));
        }

        @Override
        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifMethod_S";
            }
            return "org/netbeans/modules/beans/resources/bifMethod_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        void analyzeCustomizationString(String statement) {
        }

        @Override
        void analyzeCreationString(String statement) {
        }

        @Override
        void analyzeCustomization(Collection<String> code) throws GenerateBeanException {
            if (this.element != null) {
                String creation = (String)BiAnalyser.normalizeText(this.getCreationString()).toArray()[0];
                for (String statement : code) {
                    int index = statement.indexOf(creation);
                    if (index <= -1) continue;
                    this.varName = statement.substring(statement.indexOf("methods[METHOD_") + 15, index - 2);
                    break;
                }
                this.element = null;
            }
            String realName = this.getName();
            this.setName(this.varName);
            super.analyzeCustomization(code);
            this.setName(realName);
        }
    }

    public static final class EventSet
    extends BiFeature
    implements Comparator {
        EventSetPattern pattern;
        private static final String TEXT_UNICAST = "setUnicast";
        private static final String TEXT_IN_DEFAULT = "setInDefaultEventSet";
        private boolean isInDefaultEventSet = true;
        private String creationString;

        EventSet(EventSetPattern esp, CompilationInfo javac, BiAnalyser bia) throws GenerateBeanException {
            super(esp, bia);
            this.pattern = esp;
            this.creationString = this.initCreationString(javac);
        }

        public boolean isUnicast() {
            return this.pattern.isUnicast();
        }

        public boolean isInDefaultEventSet() {
            return this.isInDefaultEventSet;
        }

        public void setInDefaultEventSet(boolean isInDefaultEventSet) {
            this.isInDefaultEventSet = isInDefaultEventSet;
        }

        @Override
        String getBracketedName() {
            return "[EVENT_" + this.getName() + "]";
        }

        public int compare(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }

        @Override
        String getCreationString() {
            return this.creationString;
        }

        private String initCreationString(CompilationInfo javac) throws GenerateBeanException {
            String code = "new EventSetDescriptor ( %1$s.class, \"%2$s\", %3$s.class, new String[] {%4$s}, \"%5$s\", \"%6$s\" )";
            String paramdelim = ", ";
            StringBuilder methodList = new StringBuilder();
            TypeMirror listenerType = this.pattern.getType().resolve(javac);
            TypeElement listener = (TypeElement)((DeclaredType)listenerType).asElement();
            for (ExecutableElement me : ElementFilter.methodsIn(listener.getEnclosedElements())) {
                methodList.append(paramdelim).append('\"').append(me.getSimpleName()).append('\"');
            }
            return String.format(code, ((TypeElement)this.pattern.getDeclaringClass().resolve(javac)).getQualifiedName(), this.pattern.getName(), listener.getQualifiedName().toString(), methodList.length() == 0 ? methodList : methodList.substring(paramdelim.length()), ((ExecutableElement)this.pattern.getAddListenerMethod().resolve(javac)).getSimpleName(), ((ExecutableElement)this.pattern.getRemoveListenerMethod().resolve(javac)).getSimpleName());
        }

        @Override
        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                if (this.isUnicast()) {
                    return "org/netbeans/modules/beans/resources/bifEventSetUC_S";
                }
                return "org/netbeans/modules/beans/resources/bifEventSetMC_S";
            }
            if (this.isUnicast()) {
                return "org/netbeans/modules/beans/resources/bifEventSetUC_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifEventSetMC_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        List<String> getCustomizationStrings() {
            List<String> col = super.getCustomizationStrings();
            StringBuilder sb = new StringBuilder(100);
            if (this.isUnicast()) {
                sb.setLength(0);
                sb.append(TEXT_UNICAST).append(" ( true )");
                col.add(sb.toString());
            }
            if (!this.isInDefaultEventSet) {
                sb.setLength(0);
                sb.append(TEXT_IN_DEFAULT).append(" ( false )");
                col.add(sb.toString());
            }
            return col;
        }

        @Override
        void analyzeCustomizationString(String statement) {
            String n = this.getBracketedName();
            String stInDefault = n + "." + TEXT_IN_DEFAULT;
            if (statement.indexOf(stInDefault) != -1) {
                this.setInDefaultEventSet(false);
                return;
            }
        }

        @Override
        void analyzeCreationString(String statement) {
        }
    }

    public static final class IdxProperty
    extends Property {
        private boolean niGetter;
        private boolean niSetter;
        IdxPropertyPattern pattern;
        private String indexedGetterName;
        private String indexedSetterName;

        IdxProperty(IdxPropertyPattern pp, CompilationInfo javac, BiAnalyser bia) throws GenerateBeanException {
            super(pp, javac, bia);
            this.pattern = pp;
            this.niGetter = this.hasNiGetter();
            this.niSetter = this.hasNiSetter();
            ElementHandle<ExecutableElement> indexedGetterHandle = this.pattern.getIndexedGetterMethod();
            this.indexedGetterName = indexedGetterHandle == null ? null : ((ExecutableElement)indexedGetterHandle.resolve(javac)).getSimpleName().toString();
            ElementHandle<ExecutableElement> indexedSetterHandle = this.pattern.getIndexedSetterMethod();
            String string = this.indexedSetterName = indexedSetterHandle == null ? null : ((ExecutableElement)indexedSetterHandle.resolve(javac)).getSimpleName().toString();
            if (LOG.isLoggable(Level.FINE)) {
                this.debugTooltip = String.format("<html><body><b>Field:</b> %s<br><b>Getter:</b> %s<br><b>Setter:</b> %s<br><b>Indexed Getter:</b> %s<br><b>Indexed Setter:</b> %s</body></html>", pp.getEstimatedField() == null ? null : ElementHeaders.getHeader((Element)pp.getEstimatedField().resolve(javac), (CompilationInfo)javac, (String)"%name% : %type%") + " :: " + ((TypeElement)((VariableElement)pp.getEstimatedField().resolve(javac)).getEnclosingElement()).getQualifiedName(), IdxProperty.printMethodHandleTip(this.pattern.getGetterMethod(), javac), IdxProperty.printMethodHandleTip(this.pattern.getGetterMethod(), javac), IdxProperty.printMethodHandleTip(indexedGetterHandle, javac), IdxProperty.printMethodHandleTip(indexedSetterHandle, javac));
            }
        }

        boolean isNiGetter() {
            return this.niGetter;
        }

        void setNiGetter(boolean niGetter) {
            this.niGetter = this.hasNiGetter() ? niGetter : false;
            this.setModified();
        }

        boolean isNiSetter() {
            return this.niSetter;
        }

        void setNiSetter(boolean niSetter) {
            this.niSetter = this.hasNiSetter() ? niSetter : false;
            this.setModified();
        }

        boolean hasNiGetter() {
            return this.pattern.getGetterMethod() != null;
        }

        boolean hasNiSetter() {
            return this.pattern.getSetterMethod() != null;
        }

        @Override
        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new IndexedPropertyDescriptor ( ");
            sb.append("\"" + this.getName() + "\", ");
            sb.append(this.getDeclaringClassName() + ".class, ");
            if (this.getGetterName() != null && this.niGetter) {
                sb.append("\"" + this.getGetterName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.getSetterName() != null && this.niSetter) {
                sb.append("\"" + this.getSetterName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.indexedGetterName != null && this.getMode() != 4) {
                sb.append("\"" + this.indexedGetterName + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.indexedSetterName != null && this.getMode() != 2) {
                sb.append("\"" + this.indexedSetterName + "\" )");
            } else {
                sb.append("null )");
            }
            return sb.toString();
        }

        @Override
        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_S";
            }
            if (this.getMode() == 2) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.getMode() == 4) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        void analyzeCreationString(String statement) {
            String[] params = BiAnalyser.getParameters(statement);
            if (params.length == 6 && this.getMode() == 1) {
                if (params[4].equals("null")) {
                    this.setMode(4);
                } else if (params[5].equals("null")) {
                    this.setMode(2);
                }
                if (this.hasNiGetter() && params[2].equals("null")) {
                    this.niGetter = false;
                }
                if (this.hasNiGetter() && params[3].equals("null")) {
                    this.niSetter = false;
                }
            }
        }
    }

    public static class Property
    extends BiFeature {
        private PropertyPattern pattern;
        private static final String TEXT_BOUND = "setBound";
        private static final String TEXT_CONSTRAINED = "setConstrained";
        private static final String TEXT_PROPERTY_EDITOR = "setPropertyEditorClass";
        private boolean bound;
        private boolean constrained;
        private int mode;
        private String propertyEditorClass;
        private String declaringClassName;
        private String getterName;
        private String setterName;
        String debugTooltip;

        Property(PropertyPattern pp, CompilationInfo javac, BiAnalyser bia) throws GenerateBeanException {
            super(pp, bia);
            this.mode = pp.getMode();
            this.pattern = pp;
            TypeElement declaringClass = (TypeElement)this.pattern.getDeclaringClass().resolve(javac);
            this.declaringClassName = declaringClass.getQualifiedName().toString();
            ElementHandle<ExecutableElement> getterHandle = this.pattern.getGetterMethod();
            this.getterName = getterHandle == null ? null : ((ExecutableElement)getterHandle.resolve(javac)).getSimpleName().toString();
            ElementHandle<ExecutableElement> setterHandle = this.pattern.getSetterMethod();
            String string = this.setterName = setterHandle == null ? null : ((ExecutableElement)setterHandle.resolve(javac)).getSimpleName().toString();
            if (LOG.isLoggable(Level.FINE) && this.getClass() == Property.class) {
                this.debugTooltip = String.format("<html><body><b>Field:</b> %s<br><b>Getter:</b> %s<br><b>Setter:</b> %s</body></html>", pp.getEstimatedField() == null ? null : ElementHeaders.getHeader((Element)pp.getEstimatedField().resolve(javac), (CompilationInfo)javac, (String)"%name% : %type%") + " :: " + ((TypeElement)((VariableElement)pp.getEstimatedField().resolve(javac)).getEnclosingElement()).getQualifiedName(), Property.printMethodHandleTip(getterHandle, javac), Property.printMethodHandleTip(setterHandle, javac));
            }
        }

        static String printMethodHandleTip(ElementHandle<ExecutableElement> handle, CompilationInfo javac) {
            if (handle == null) {
                return null;
            }
            ExecutableElement method = (ExecutableElement)handle.resolve(javac);
            return ElementHeaders.getHeader((Element)method, (CompilationInfo)javac, (String)"%name%%parameters% : %type%") + " :: " + ((TypeElement)method.getEnclosingElement()).getQualifiedName();
        }

        @Override
        public String getToolTip() {
            return this.debugTooltip != null ? this.debugTooltip : super.getToolTip();
        }

        protected final String getDeclaringClassName() {
            return this.declaringClassName;
        }

        protected final String getGetterName() {
            return this.getterName;
        }

        protected final String getSetterName() {
            return this.setterName;
        }

        public boolean isBound() {
            return this.bound;
        }

        @Override
        String getBracketedName() {
            return "[PROPERTY_" + this.getName() + "]";
        }

        public void setBound(boolean bound) {
            this.bound = bound;
            this.setModified();
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
            this.setModified();
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
            this.setModified();
        }

        public boolean modeChangeable() {
            return this.pattern.getMode() == 1;
        }

        public String getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        public void setPropertyEditorClass(String propertyEditorClass) {
            this.propertyEditorClass = propertyEditorClass;
            this.setModified();
        }

        @Override
        String getCreationString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("new PropertyDescriptor ( ");
            sb.append("\"" + this.getName() + "\", ");
            sb.append(this.declaringClassName + ".class, ");
            if (this.getterName != null && this.getMode() != 4) {
                sb.append("\"" + this.getterName + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.setterName != null && this.getMode() != 2) {
                sb.append("\"" + this.setterName + "\" )");
            } else {
                sb.append("null )");
            }
            return sb.toString();
        }

        @Override
        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifPropertyRW_S";
            }
            if (this.mode == 2) {
                return "org/netbeans/modules/beans/resources/bifPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.mode == 4) {
                return "org/netbeans/modules/beans/resources/bifPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        List<String> getCustomizationStrings() {
            List<String> col = super.getCustomizationStrings();
            StringBuilder sb = new StringBuilder(100);
            if (this.bound) {
                sb.setLength(0);
                sb.append(TEXT_BOUND).append(" ( true )");
                col.add(sb.toString());
            }
            if (this.constrained) {
                sb.setLength(0);
                sb.append(TEXT_CONSTRAINED).append(" ( true )");
                col.add(sb.toString());
            }
            if (this.propertyEditorClass != null && this.propertyEditorClass.trim().length() > 0) {
                sb.setLength(0);
                sb.append(TEXT_PROPERTY_EDITOR).append(" ( ");
                sb.append(this.propertyEditorClass).append(" )");
                col.add(sb.toString());
            }
            return col;
        }

        @Override
        void analyzeCustomizationString(String statement) {
            String n = this.getBracketedName();
            String stBound = n + "." + TEXT_BOUND;
            String stConstrained = n + "." + TEXT_CONSTRAINED;
            String stPropertyEditor = n + "." + TEXT_PROPERTY_EDITOR;
            if (statement.indexOf(stBound) != -1) {
                this.setBound(true);
                return;
            }
            if (statement.indexOf(stConstrained) != -1) {
                this.setConstrained(true);
                return;
            }
            int peIndex = statement.indexOf(stPropertyEditor);
            if (peIndex != -1) {
                String paramString = statement.substring(peIndex + stPropertyEditor.length());
                String[] params = BiAnalyser.getParameters(paramString);
                if (params.length > 0) {
                    this.setPropertyEditorClass(params[0]);
                }
                return;
            }
        }

        @Override
        void analyzeCreationString(String statement) {
            String[] params = BiAnalyser.getParameters(statement);
            if (params.length == 4 && this.mode == 1) {
                if (params[2].equals("null")) {
                    this.mode = 4;
                } else if (params[3].equals("null")) {
                    this.mode = 2;
                }
            }
        }
    }

    public static final class Descriptor
    extends BiFeature {
        ElementHandle<TypeElement> element;
        String customizer;
        private String beanName;

        Descriptor(TypeElement ce, BiAnalyser bia) throws GenerateBeanException {
            super(bia);
            this.element = ElementHandle.create((Element)ce);
            this.beanName = ce.getQualifiedName().toString();
        }

        @Override
        String getCreationString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("new BeanDescriptor  ( ");
            sb.append(this.getBeanName() + ".class , ");
            sb.append(String.valueOf(this.getCustomizer()) + " )");
            return sb.toString();
        }

        @Override
        String getIconBase(boolean defaultIcon) {
            return "org/netbeans/modules/beans/resources/bifDescriptor";
        }

        @Override
        public String getToolTip() {
            return NbBundle.getMessage(BiFeature.class, (String)"HINT_NODE_Descriptor");
        }

        @Override
        void analyzeCustomizationString(String statement) {
        }

        @Override
        void analyzeCreationString(String statement) {
            int beg = statement.indexOf(44);
            int end = statement.lastIndexOf(41);
            if (beg != -1 && end != -1 && ++beg < end) {
                this.setCustomizer(statement.substring(beg, end));
            } else {
                this.setCustomizer(null);
            }
        }

        @Override
        String getBracketedName() {
            return this.getName();
        }

        @Override
        String getBrackets() {
            return "";
        }

        public String getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(String customizer) {
            this.customizer = customizer;
            this.setModified();
        }

        @Override
        public boolean isIncluded() {
            return true;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

