# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.
swig_version = (3, 0, 12)

"""
The lldb module contains the public APIs for Python binding.

Some of the important classes are described here:

o SBTarget: Represents the target program running under the debugger.
o SBProcess: Represents the process associated with the target program.
o SBThread: Represents a thread of execution. SBProcess contains SBThread(s).
o SBFrame: Represents one of the stack frames associated with a thread. SBThread
      contains SBFrame(s).
o SBSymbolContext: A container that stores various debugger related info.
o SBValue: Represents the value of a variable, a register, or an expression.
o SBModule: Represents an executable image and its associated object and symbol
      files.  SBTarget contains SBModule(s).
o SBBreakpoint: Represents a logical breakpoint and its associated settings.
      SBTarget contains SBBreakpoint(s).
o SBSymbol: Represents the symbol possibly associated with a stack frame.
o SBCompileUnit: Represents a compilation unit, or compiled source file.
o SBFunction: Represents a generic function, which can be inlined or not.
o SBBlock: Represents a lexical block. SBFunction contains SBBlock(s).
o SBLineEntry: Specifies an association with a contiguous range of instructions
      and a source file location. SBCompileUnit contains SBLineEntry(s).
"""


try:
    # Try a relative import first
    from . import _lldb
except ImportError:
    # Maybe absolute import will work (if we're being loaded from lldb, it
    # should).
    import _lldb
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


import uuid
import re
import os

import six

INT32_MAX = _lldb.INT32_MAX
UINT32_MAX = _lldb.UINT32_MAX
UINT64_MAX = _lldb.UINT64_MAX
LLDB_GENERIC_ERROR = _lldb.LLDB_GENERIC_ERROR
LLDB_INVALID_BREAK_ID = _lldb.LLDB_INVALID_BREAK_ID
LLDB_DEFAULT_BREAK_SIZE = _lldb.LLDB_DEFAULT_BREAK_SIZE
LLDB_INVALID_WATCH_ID = _lldb.LLDB_INVALID_WATCH_ID
LLDB_WATCH_TYPE_READ = _lldb.LLDB_WATCH_TYPE_READ
LLDB_WATCH_TYPE_WRITE = _lldb.LLDB_WATCH_TYPE_WRITE
LLDB_REGNUM_GENERIC_PC = _lldb.LLDB_REGNUM_GENERIC_PC
LLDB_REGNUM_GENERIC_SP = _lldb.LLDB_REGNUM_GENERIC_SP
LLDB_REGNUM_GENERIC_FP = _lldb.LLDB_REGNUM_GENERIC_FP
LLDB_REGNUM_GENERIC_RA = _lldb.LLDB_REGNUM_GENERIC_RA
LLDB_REGNUM_GENERIC_FLAGS = _lldb.LLDB_REGNUM_GENERIC_FLAGS
LLDB_REGNUM_GENERIC_ARG1 = _lldb.LLDB_REGNUM_GENERIC_ARG1
LLDB_REGNUM_GENERIC_ARG2 = _lldb.LLDB_REGNUM_GENERIC_ARG2
LLDB_REGNUM_GENERIC_ARG3 = _lldb.LLDB_REGNUM_GENERIC_ARG3
LLDB_REGNUM_GENERIC_ARG4 = _lldb.LLDB_REGNUM_GENERIC_ARG4
LLDB_REGNUM_GENERIC_ARG5 = _lldb.LLDB_REGNUM_GENERIC_ARG5
LLDB_REGNUM_GENERIC_ARG6 = _lldb.LLDB_REGNUM_GENERIC_ARG6
LLDB_REGNUM_GENERIC_ARG7 = _lldb.LLDB_REGNUM_GENERIC_ARG7
LLDB_REGNUM_GENERIC_ARG8 = _lldb.LLDB_REGNUM_GENERIC_ARG8
LLDB_INVALID_ADDRESS = _lldb.LLDB_INVALID_ADDRESS
LLDB_INVALID_INDEX32 = _lldb.LLDB_INVALID_INDEX32
LLDB_INVALID_IVAR_OFFSET = _lldb.LLDB_INVALID_IVAR_OFFSET
LLDB_INVALID_IMAGE_TOKEN = _lldb.LLDB_INVALID_IMAGE_TOKEN
LLDB_INVALID_MODULE_VERSION = _lldb.LLDB_INVALID_MODULE_VERSION
LLDB_INVALID_REGNUM = _lldb.LLDB_INVALID_REGNUM
LLDB_INVALID_UID = _lldb.LLDB_INVALID_UID
LLDB_INVALID_PROCESS_ID = _lldb.LLDB_INVALID_PROCESS_ID
LLDB_INVALID_THREAD_ID = _lldb.LLDB_INVALID_THREAD_ID
LLDB_INVALID_FRAME_ID = _lldb.LLDB_INVALID_FRAME_ID
LLDB_INVALID_SIGNAL_NUMBER = _lldb.LLDB_INVALID_SIGNAL_NUMBER
LLDB_INVALID_OFFSET = _lldb.LLDB_INVALID_OFFSET
LLDB_INVALID_LINE_NUMBER = _lldb.LLDB_INVALID_LINE_NUMBER
LLDB_INVALID_QUEUE_ID = _lldb.LLDB_INVALID_QUEUE_ID
LLDB_ARCH_DEFAULT = _lldb.LLDB_ARCH_DEFAULT
LLDB_ARCH_DEFAULT_32BIT = _lldb.LLDB_ARCH_DEFAULT_32BIT
LLDB_ARCH_DEFAULT_64BIT = _lldb.LLDB_ARCH_DEFAULT_64BIT
LLDB_INVALID_CPUTYPE = _lldb.LLDB_INVALID_CPUTYPE
LLDB_MAX_NUM_OPTION_SETS = _lldb.LLDB_MAX_NUM_OPTION_SETS
LLDB_OPT_SET_ALL = _lldb.LLDB_OPT_SET_ALL
LLDB_OPT_SET_1 = _lldb.LLDB_OPT_SET_1
LLDB_OPT_SET_2 = _lldb.LLDB_OPT_SET_2
LLDB_OPT_SET_3 = _lldb.LLDB_OPT_SET_3
LLDB_OPT_SET_4 = _lldb.LLDB_OPT_SET_4
LLDB_OPT_SET_5 = _lldb.LLDB_OPT_SET_5
LLDB_OPT_SET_6 = _lldb.LLDB_OPT_SET_6
LLDB_OPT_SET_7 = _lldb.LLDB_OPT_SET_7
LLDB_OPT_SET_8 = _lldb.LLDB_OPT_SET_8
LLDB_OPT_SET_9 = _lldb.LLDB_OPT_SET_9
LLDB_OPT_SET_10 = _lldb.LLDB_OPT_SET_10
eStateInvalid = _lldb.eStateInvalid
eStateUnloaded = _lldb.eStateUnloaded
eStateConnected = _lldb.eStateConnected
eStateAttaching = _lldb.eStateAttaching
eStateLaunching = _lldb.eStateLaunching
eStateStopped = _lldb.eStateStopped
eStateRunning = _lldb.eStateRunning
eStateStepping = _lldb.eStateStepping
eStateCrashed = _lldb.eStateCrashed
eStateDetached = _lldb.eStateDetached
eStateExited = _lldb.eStateExited
eStateSuspended = _lldb.eStateSuspended
eLaunchFlagNone = _lldb.eLaunchFlagNone
eLaunchFlagExec = _lldb.eLaunchFlagExec
eLaunchFlagDebug = _lldb.eLaunchFlagDebug
eLaunchFlagStopAtEntry = _lldb.eLaunchFlagStopAtEntry
eLaunchFlagDisableASLR = _lldb.eLaunchFlagDisableASLR
eLaunchFlagDisableSTDIO = _lldb.eLaunchFlagDisableSTDIO
eLaunchFlagLaunchInTTY = _lldb.eLaunchFlagLaunchInTTY
eLaunchFlagLaunchInShell = _lldb.eLaunchFlagLaunchInShell
eLaunchFlagLaunchInSeparateProcessGroup = _lldb.eLaunchFlagLaunchInSeparateProcessGroup
eLaunchFlagDontSetExitStatus = _lldb.eLaunchFlagDontSetExitStatus
eLaunchFlagDetachOnError = _lldb.eLaunchFlagDetachOnError
eLaunchFlagShellExpandArguments = _lldb.eLaunchFlagShellExpandArguments
eLaunchFlagCloseTTYOnExit = _lldb.eLaunchFlagCloseTTYOnExit
eOnlyThisThread = _lldb.eOnlyThisThread
eAllThreads = _lldb.eAllThreads
eOnlyDuringStepping = _lldb.eOnlyDuringStepping
eByteOrderInvalid = _lldb.eByteOrderInvalid
eByteOrderBig = _lldb.eByteOrderBig
eByteOrderPDP = _lldb.eByteOrderPDP
eByteOrderLittle = _lldb.eByteOrderLittle
eEncodingInvalid = _lldb.eEncodingInvalid
eEncodingUint = _lldb.eEncodingUint
eEncodingSint = _lldb.eEncodingSint
eEncodingIEEE754 = _lldb.eEncodingIEEE754
eEncodingVector = _lldb.eEncodingVector
eFormatDefault = _lldb.eFormatDefault
eFormatInvalid = _lldb.eFormatInvalid
eFormatBoolean = _lldb.eFormatBoolean
eFormatBinary = _lldb.eFormatBinary
eFormatBytes = _lldb.eFormatBytes
eFormatBytesWithASCII = _lldb.eFormatBytesWithASCII
eFormatChar = _lldb.eFormatChar
eFormatCharPrintable = _lldb.eFormatCharPrintable
eFormatComplex = _lldb.eFormatComplex
eFormatComplexFloat = _lldb.eFormatComplexFloat
eFormatCString = _lldb.eFormatCString
eFormatDecimal = _lldb.eFormatDecimal
eFormatEnum = _lldb.eFormatEnum
eFormatHex = _lldb.eFormatHex
eFormatHexUppercase = _lldb.eFormatHexUppercase
eFormatFloat = _lldb.eFormatFloat
eFormatOctal = _lldb.eFormatOctal
eFormatOSType = _lldb.eFormatOSType
eFormatUnicode16 = _lldb.eFormatUnicode16
eFormatUnicode32 = _lldb.eFormatUnicode32
eFormatUnsigned = _lldb.eFormatUnsigned
eFormatPointer = _lldb.eFormatPointer
eFormatVectorOfChar = _lldb.eFormatVectorOfChar
eFormatVectorOfSInt8 = _lldb.eFormatVectorOfSInt8
eFormatVectorOfUInt8 = _lldb.eFormatVectorOfUInt8
eFormatVectorOfSInt16 = _lldb.eFormatVectorOfSInt16
eFormatVectorOfUInt16 = _lldb.eFormatVectorOfUInt16
eFormatVectorOfSInt32 = _lldb.eFormatVectorOfSInt32
eFormatVectorOfUInt32 = _lldb.eFormatVectorOfUInt32
eFormatVectorOfSInt64 = _lldb.eFormatVectorOfSInt64
eFormatVectorOfUInt64 = _lldb.eFormatVectorOfUInt64
eFormatVectorOfFloat16 = _lldb.eFormatVectorOfFloat16
eFormatVectorOfFloat32 = _lldb.eFormatVectorOfFloat32
eFormatVectorOfFloat64 = _lldb.eFormatVectorOfFloat64
eFormatVectorOfUInt128 = _lldb.eFormatVectorOfUInt128
eFormatComplexInteger = _lldb.eFormatComplexInteger
eFormatCharArray = _lldb.eFormatCharArray
eFormatAddressInfo = _lldb.eFormatAddressInfo
eFormatHexFloat = _lldb.eFormatHexFloat
eFormatInstruction = _lldb.eFormatInstruction
eFormatVoid = _lldb.eFormatVoid
kNumFormats = _lldb.kNumFormats
eDescriptionLevelBrief = _lldb.eDescriptionLevelBrief
eDescriptionLevelFull = _lldb.eDescriptionLevelFull
eDescriptionLevelVerbose = _lldb.eDescriptionLevelVerbose
eDescriptionLevelInitial = _lldb.eDescriptionLevelInitial
kNumDescriptionLevels = _lldb.kNumDescriptionLevels
eScriptLanguageNone = _lldb.eScriptLanguageNone
eScriptLanguagePython = _lldb.eScriptLanguagePython
eScriptLanguageDefault = _lldb.eScriptLanguageDefault
eScriptLanguageUnknown = _lldb.eScriptLanguageUnknown
eRegisterKindEHFrame = _lldb.eRegisterKindEHFrame
eRegisterKindDWARF = _lldb.eRegisterKindDWARF
eRegisterKindGeneric = _lldb.eRegisterKindGeneric
eRegisterKindProcessPlugin = _lldb.eRegisterKindProcessPlugin
eRegisterKindLLDB = _lldb.eRegisterKindLLDB
kNumRegisterKinds = _lldb.kNumRegisterKinds
eStopReasonInvalid = _lldb.eStopReasonInvalid
eStopReasonNone = _lldb.eStopReasonNone
eStopReasonTrace = _lldb.eStopReasonTrace
eStopReasonBreakpoint = _lldb.eStopReasonBreakpoint
eStopReasonWatchpoint = _lldb.eStopReasonWatchpoint
eStopReasonSignal = _lldb.eStopReasonSignal
eStopReasonException = _lldb.eStopReasonException
eStopReasonExec = _lldb.eStopReasonExec
eStopReasonPlanComplete = _lldb.eStopReasonPlanComplete
eStopReasonThreadExiting = _lldb.eStopReasonThreadExiting
eStopReasonInstrumentation = _lldb.eStopReasonInstrumentation
eReturnStatusInvalid = _lldb.eReturnStatusInvalid
eReturnStatusSuccessFinishNoResult = _lldb.eReturnStatusSuccessFinishNoResult
eReturnStatusSuccessFinishResult = _lldb.eReturnStatusSuccessFinishResult
eReturnStatusSuccessContinuingNoResult = _lldb.eReturnStatusSuccessContinuingNoResult
eReturnStatusSuccessContinuingResult = _lldb.eReturnStatusSuccessContinuingResult
eReturnStatusStarted = _lldb.eReturnStatusStarted
eReturnStatusFailed = _lldb.eReturnStatusFailed
eReturnStatusQuit = _lldb.eReturnStatusQuit
eExpressionCompleted = _lldb.eExpressionCompleted
eExpressionSetupError = _lldb.eExpressionSetupError
eExpressionParseError = _lldb.eExpressionParseError
eExpressionDiscarded = _lldb.eExpressionDiscarded
eExpressionInterrupted = _lldb.eExpressionInterrupted
eExpressionHitBreakpoint = _lldb.eExpressionHitBreakpoint
eExpressionTimedOut = _lldb.eExpressionTimedOut
eExpressionResultUnavailable = _lldb.eExpressionResultUnavailable
eExpressionStoppedForDebug = _lldb.eExpressionStoppedForDebug
eConnectionStatusSuccess = _lldb.eConnectionStatusSuccess
eConnectionStatusEndOfFile = _lldb.eConnectionStatusEndOfFile
eConnectionStatusError = _lldb.eConnectionStatusError
eConnectionStatusTimedOut = _lldb.eConnectionStatusTimedOut
eConnectionStatusNoConnection = _lldb.eConnectionStatusNoConnection
eConnectionStatusLostConnection = _lldb.eConnectionStatusLostConnection
eConnectionStatusInterrupted = _lldb.eConnectionStatusInterrupted
eErrorTypeInvalid = _lldb.eErrorTypeInvalid
eErrorTypeGeneric = _lldb.eErrorTypeGeneric
eErrorTypeMachKernel = _lldb.eErrorTypeMachKernel
eErrorTypePOSIX = _lldb.eErrorTypePOSIX
eErrorTypeExpression = _lldb.eErrorTypeExpression
eErrorTypeWin32 = _lldb.eErrorTypeWin32
eValueTypeInvalid = _lldb.eValueTypeInvalid
eValueTypeVariableGlobal = _lldb.eValueTypeVariableGlobal
eValueTypeVariableStatic = _lldb.eValueTypeVariableStatic
eValueTypeVariableArgument = _lldb.eValueTypeVariableArgument
eValueTypeVariableLocal = _lldb.eValueTypeVariableLocal
eValueTypeRegister = _lldb.eValueTypeRegister
eValueTypeRegisterSet = _lldb.eValueTypeRegisterSet
eValueTypeConstResult = _lldb.eValueTypeConstResult
eValueTypeVariableThreadLocal = _lldb.eValueTypeVariableThreadLocal
eInputReaderGranularityInvalid = _lldb.eInputReaderGranularityInvalid
eInputReaderGranularityByte = _lldb.eInputReaderGranularityByte
eInputReaderGranularityWord = _lldb.eInputReaderGranularityWord
eInputReaderGranularityLine = _lldb.eInputReaderGranularityLine
eInputReaderGranularityAll = _lldb.eInputReaderGranularityAll
eSymbolContextTarget = _lldb.eSymbolContextTarget
eSymbolContextModule = _lldb.eSymbolContextModule
eSymbolContextCompUnit = _lldb.eSymbolContextCompUnit
eSymbolContextFunction = _lldb.eSymbolContextFunction
eSymbolContextBlock = _lldb.eSymbolContextBlock
eSymbolContextLineEntry = _lldb.eSymbolContextLineEntry
eSymbolContextSymbol = _lldb.eSymbolContextSymbol
eSymbolContextEverything = _lldb.eSymbolContextEverything
eSymbolContextVariable = _lldb.eSymbolContextVariable
ePermissionsWritable = _lldb.ePermissionsWritable
ePermissionsReadable = _lldb.ePermissionsReadable
ePermissionsExecutable = _lldb.ePermissionsExecutable
eInputReaderActivate = _lldb.eInputReaderActivate
eInputReaderAsynchronousOutputWritten = _lldb.eInputReaderAsynchronousOutputWritten
eInputReaderReactivate = _lldb.eInputReaderReactivate
eInputReaderDeactivate = _lldb.eInputReaderDeactivate
eInputReaderGotToken = _lldb.eInputReaderGotToken
eInputReaderInterrupt = _lldb.eInputReaderInterrupt
eInputReaderEndOfFile = _lldb.eInputReaderEndOfFile
eInputReaderDone = _lldb.eInputReaderDone
eBreakpointEventTypeInvalidType = _lldb.eBreakpointEventTypeInvalidType
eBreakpointEventTypeAdded = _lldb.eBreakpointEventTypeAdded
eBreakpointEventTypeRemoved = _lldb.eBreakpointEventTypeRemoved
eBreakpointEventTypeLocationsAdded = _lldb.eBreakpointEventTypeLocationsAdded
eBreakpointEventTypeLocationsRemoved = _lldb.eBreakpointEventTypeLocationsRemoved
eBreakpointEventTypeLocationsResolved = _lldb.eBreakpointEventTypeLocationsResolved
eBreakpointEventTypeEnabled = _lldb.eBreakpointEventTypeEnabled
eBreakpointEventTypeDisabled = _lldb.eBreakpointEventTypeDisabled
eBreakpointEventTypeCommandChanged = _lldb.eBreakpointEventTypeCommandChanged
eBreakpointEventTypeConditionChanged = _lldb.eBreakpointEventTypeConditionChanged
eBreakpointEventTypeIgnoreChanged = _lldb.eBreakpointEventTypeIgnoreChanged
eBreakpointEventTypeThreadChanged = _lldb.eBreakpointEventTypeThreadChanged
eBreakpointEventTypeAutoContinueChanged = _lldb.eBreakpointEventTypeAutoContinueChanged
eWatchpointEventTypeInvalidType = _lldb.eWatchpointEventTypeInvalidType
eWatchpointEventTypeAdded = _lldb.eWatchpointEventTypeAdded
eWatchpointEventTypeRemoved = _lldb.eWatchpointEventTypeRemoved
eWatchpointEventTypeEnabled = _lldb.eWatchpointEventTypeEnabled
eWatchpointEventTypeDisabled = _lldb.eWatchpointEventTypeDisabled
eWatchpointEventTypeCommandChanged = _lldb.eWatchpointEventTypeCommandChanged
eWatchpointEventTypeConditionChanged = _lldb.eWatchpointEventTypeConditionChanged
eWatchpointEventTypeIgnoreChanged = _lldb.eWatchpointEventTypeIgnoreChanged
eWatchpointEventTypeThreadChanged = _lldb.eWatchpointEventTypeThreadChanged
eWatchpointEventTypeTypeChanged = _lldb.eWatchpointEventTypeTypeChanged
eLanguageTypeUnknown = _lldb.eLanguageTypeUnknown
eLanguageTypeC89 = _lldb.eLanguageTypeC89
eLanguageTypeC = _lldb.eLanguageTypeC
eLanguageTypeAda83 = _lldb.eLanguageTypeAda83
eLanguageTypeC_plus_plus = _lldb.eLanguageTypeC_plus_plus
eLanguageTypeCobol74 = _lldb.eLanguageTypeCobol74
eLanguageTypeCobol85 = _lldb.eLanguageTypeCobol85
eLanguageTypeFortran77 = _lldb.eLanguageTypeFortran77
eLanguageTypeFortran90 = _lldb.eLanguageTypeFortran90
eLanguageTypePascal83 = _lldb.eLanguageTypePascal83
eLanguageTypeModula2 = _lldb.eLanguageTypeModula2
eLanguageTypeJava = _lldb.eLanguageTypeJava
eLanguageTypeC99 = _lldb.eLanguageTypeC99
eLanguageTypeAda95 = _lldb.eLanguageTypeAda95
eLanguageTypeFortran95 = _lldb.eLanguageTypeFortran95
eLanguageTypePLI = _lldb.eLanguageTypePLI
eLanguageTypeObjC = _lldb.eLanguageTypeObjC
eLanguageTypeObjC_plus_plus = _lldb.eLanguageTypeObjC_plus_plus
eLanguageTypeUPC = _lldb.eLanguageTypeUPC
eLanguageTypeD = _lldb.eLanguageTypeD
eLanguageTypePython = _lldb.eLanguageTypePython
eLanguageTypeOpenCL = _lldb.eLanguageTypeOpenCL
eLanguageTypeGo = _lldb.eLanguageTypeGo
eLanguageTypeModula3 = _lldb.eLanguageTypeModula3
eLanguageTypeHaskell = _lldb.eLanguageTypeHaskell
eLanguageTypeC_plus_plus_03 = _lldb.eLanguageTypeC_plus_plus_03
eLanguageTypeC_plus_plus_11 = _lldb.eLanguageTypeC_plus_plus_11
eLanguageTypeOCaml = _lldb.eLanguageTypeOCaml
eLanguageTypeRust = _lldb.eLanguageTypeRust
eLanguageTypeC11 = _lldb.eLanguageTypeC11
eLanguageTypeSwift = _lldb.eLanguageTypeSwift
eLanguageTypeJulia = _lldb.eLanguageTypeJulia
eLanguageTypeDylan = _lldb.eLanguageTypeDylan
eLanguageTypeC_plus_plus_14 = _lldb.eLanguageTypeC_plus_plus_14
eLanguageTypeFortran03 = _lldb.eLanguageTypeFortran03
eLanguageTypeFortran08 = _lldb.eLanguageTypeFortran08
eLanguageTypeMipsAssembler = _lldb.eLanguageTypeMipsAssembler
eLanguageTypeExtRenderScript = _lldb.eLanguageTypeExtRenderScript
eNumLanguageTypes = _lldb.eNumLanguageTypes
eInstrumentationRuntimeTypeAddressSanitizer = _lldb.eInstrumentationRuntimeTypeAddressSanitizer
eInstrumentationRuntimeTypeThreadSanitizer = _lldb.eInstrumentationRuntimeTypeThreadSanitizer
eInstrumentationRuntimeTypeUndefinedBehaviorSanitizer = _lldb.eInstrumentationRuntimeTypeUndefinedBehaviorSanitizer
eInstrumentationRuntimeTypeMainThreadChecker = _lldb.eInstrumentationRuntimeTypeMainThreadChecker
eInstrumentationRuntimeTypeSwiftRuntimeReporting = _lldb.eInstrumentationRuntimeTypeSwiftRuntimeReporting
eNumInstrumentationRuntimeTypes = _lldb.eNumInstrumentationRuntimeTypes
eNoDynamicValues = _lldb.eNoDynamicValues
eDynamicCanRunTarget = _lldb.eDynamicCanRunTarget
eDynamicDontRunTarget = _lldb.eDynamicDontRunTarget
eStopShowColumnAnsiOrCaret = _lldb.eStopShowColumnAnsiOrCaret
eStopShowColumnAnsi = _lldb.eStopShowColumnAnsi
eStopShowColumnCaret = _lldb.eStopShowColumnCaret
eStopShowColumnNone = _lldb.eStopShowColumnNone
eAccessNone = _lldb.eAccessNone
eAccessPublic = _lldb.eAccessPublic
eAccessPrivate = _lldb.eAccessPrivate
eAccessProtected = _lldb.eAccessProtected
eAccessPackage = _lldb.eAccessPackage
eArgTypeAddress = _lldb.eArgTypeAddress
eArgTypeAddressOrExpression = _lldb.eArgTypeAddressOrExpression
eArgTypeAliasName = _lldb.eArgTypeAliasName
eArgTypeAliasOptions = _lldb.eArgTypeAliasOptions
eArgTypeArchitecture = _lldb.eArgTypeArchitecture
eArgTypeBoolean = _lldb.eArgTypeBoolean
eArgTypeBreakpointID = _lldb.eArgTypeBreakpointID
eArgTypeBreakpointIDRange = _lldb.eArgTypeBreakpointIDRange
eArgTypeBreakpointName = _lldb.eArgTypeBreakpointName
eArgTypeByteSize = _lldb.eArgTypeByteSize
eArgTypeClassName = _lldb.eArgTypeClassName
eArgTypeCommandName = _lldb.eArgTypeCommandName
eArgTypeCount = _lldb.eArgTypeCount
eArgTypeDescriptionVerbosity = _lldb.eArgTypeDescriptionVerbosity
eArgTypeDirectoryName = _lldb.eArgTypeDirectoryName
eArgTypeDisassemblyFlavor = _lldb.eArgTypeDisassemblyFlavor
eArgTypeEndAddress = _lldb.eArgTypeEndAddress
eArgTypeExpression = _lldb.eArgTypeExpression
eArgTypeExpressionPath = _lldb.eArgTypeExpressionPath
eArgTypeExprFormat = _lldb.eArgTypeExprFormat
eArgTypeFilename = _lldb.eArgTypeFilename
eArgTypeFormat = _lldb.eArgTypeFormat
eArgTypeFrameIndex = _lldb.eArgTypeFrameIndex
eArgTypeFullName = _lldb.eArgTypeFullName
eArgTypeFunctionName = _lldb.eArgTypeFunctionName
eArgTypeFunctionOrSymbol = _lldb.eArgTypeFunctionOrSymbol
eArgTypeGDBFormat = _lldb.eArgTypeGDBFormat
eArgTypeHelpText = _lldb.eArgTypeHelpText
eArgTypeIndex = _lldb.eArgTypeIndex
eArgTypeLanguage = _lldb.eArgTypeLanguage
eArgTypeLineNum = _lldb.eArgTypeLineNum
eArgTypeLogCategory = _lldb.eArgTypeLogCategory
eArgTypeLogChannel = _lldb.eArgTypeLogChannel
eArgTypeMethod = _lldb.eArgTypeMethod
eArgTypeName = _lldb.eArgTypeName
eArgTypeNewPathPrefix = _lldb.eArgTypeNewPathPrefix
eArgTypeNumLines = _lldb.eArgTypeNumLines
eArgTypeNumberPerLine = _lldb.eArgTypeNumberPerLine
eArgTypeOffset = _lldb.eArgTypeOffset
eArgTypeOldPathPrefix = _lldb.eArgTypeOldPathPrefix
eArgTypeOneLiner = _lldb.eArgTypeOneLiner
eArgTypePath = _lldb.eArgTypePath
eArgTypePermissionsNumber = _lldb.eArgTypePermissionsNumber
eArgTypePermissionsString = _lldb.eArgTypePermissionsString
eArgTypePid = _lldb.eArgTypePid
eArgTypePlugin = _lldb.eArgTypePlugin
eArgTypeProcessName = _lldb.eArgTypeProcessName
eArgTypePythonClass = _lldb.eArgTypePythonClass
eArgTypePythonFunction = _lldb.eArgTypePythonFunction
eArgTypePythonScript = _lldb.eArgTypePythonScript
eArgTypeQueueName = _lldb.eArgTypeQueueName
eArgTypeRegisterName = _lldb.eArgTypeRegisterName
eArgTypeRegularExpression = _lldb.eArgTypeRegularExpression
eArgTypeRunArgs = _lldb.eArgTypeRunArgs
eArgTypeRunMode = _lldb.eArgTypeRunMode
eArgTypeScriptedCommandSynchronicity = _lldb.eArgTypeScriptedCommandSynchronicity
eArgTypeScriptLang = _lldb.eArgTypeScriptLang
eArgTypeSearchWord = _lldb.eArgTypeSearchWord
eArgTypeSelector = _lldb.eArgTypeSelector
eArgTypeSettingIndex = _lldb.eArgTypeSettingIndex
eArgTypeSettingKey = _lldb.eArgTypeSettingKey
eArgTypeSettingPrefix = _lldb.eArgTypeSettingPrefix
eArgTypeSettingVariableName = _lldb.eArgTypeSettingVariableName
eArgTypeShlibName = _lldb.eArgTypeShlibName
eArgTypeSourceFile = _lldb.eArgTypeSourceFile
eArgTypeSortOrder = _lldb.eArgTypeSortOrder
eArgTypeStartAddress = _lldb.eArgTypeStartAddress
eArgTypeSummaryString = _lldb.eArgTypeSummaryString
eArgTypeSymbol = _lldb.eArgTypeSymbol
eArgTypeThreadID = _lldb.eArgTypeThreadID
eArgTypeThreadIndex = _lldb.eArgTypeThreadIndex
eArgTypeThreadName = _lldb.eArgTypeThreadName
eArgTypeTypeName = _lldb.eArgTypeTypeName
eArgTypeUnsignedInteger = _lldb.eArgTypeUnsignedInteger
eArgTypeUnixSignal = _lldb.eArgTypeUnixSignal
eArgTypeVarName = _lldb.eArgTypeVarName
eArgTypeValue = _lldb.eArgTypeValue
eArgTypeWidth = _lldb.eArgTypeWidth
eArgTypeNone = _lldb.eArgTypeNone
eArgTypePlatform = _lldb.eArgTypePlatform
eArgTypeWatchpointID = _lldb.eArgTypeWatchpointID
eArgTypeWatchpointIDRange = _lldb.eArgTypeWatchpointIDRange
eArgTypeWatchType = _lldb.eArgTypeWatchType
eArgRawInput = _lldb.eArgRawInput
eArgTypeCommand = _lldb.eArgTypeCommand
eArgTypeLastArg = _lldb.eArgTypeLastArg
eSymbolTypeAny = _lldb.eSymbolTypeAny
eSymbolTypeInvalid = _lldb.eSymbolTypeInvalid
eSymbolTypeAbsolute = _lldb.eSymbolTypeAbsolute
eSymbolTypeCode = _lldb.eSymbolTypeCode
eSymbolTypeResolver = _lldb.eSymbolTypeResolver
eSymbolTypeData = _lldb.eSymbolTypeData
eSymbolTypeTrampoline = _lldb.eSymbolTypeTrampoline
eSymbolTypeRuntime = _lldb.eSymbolTypeRuntime
eSymbolTypeException = _lldb.eSymbolTypeException
eSymbolTypeSourceFile = _lldb.eSymbolTypeSourceFile
eSymbolTypeHeaderFile = _lldb.eSymbolTypeHeaderFile
eSymbolTypeObjectFile = _lldb.eSymbolTypeObjectFile
eSymbolTypeCommonBlock = _lldb.eSymbolTypeCommonBlock
eSymbolTypeBlock = _lldb.eSymbolTypeBlock
eSymbolTypeLocal = _lldb.eSymbolTypeLocal
eSymbolTypeParam = _lldb.eSymbolTypeParam
eSymbolTypeVariable = _lldb.eSymbolTypeVariable
eSymbolTypeVariableType = _lldb.eSymbolTypeVariableType
eSymbolTypeLineEntry = _lldb.eSymbolTypeLineEntry
eSymbolTypeLineHeader = _lldb.eSymbolTypeLineHeader
eSymbolTypeScopeBegin = _lldb.eSymbolTypeScopeBegin
eSymbolTypeScopeEnd = _lldb.eSymbolTypeScopeEnd
eSymbolTypeAdditional = _lldb.eSymbolTypeAdditional
eSymbolTypeCompiler = _lldb.eSymbolTypeCompiler
eSymbolTypeInstrumentation = _lldb.eSymbolTypeInstrumentation
eSymbolTypeUndefined = _lldb.eSymbolTypeUndefined
eSymbolTypeObjCClass = _lldb.eSymbolTypeObjCClass
eSymbolTypeObjCMetaClass = _lldb.eSymbolTypeObjCMetaClass
eSymbolTypeObjCIVar = _lldb.eSymbolTypeObjCIVar
eSymbolTypeReExported = _lldb.eSymbolTypeReExported
eSectionTypeInvalid = _lldb.eSectionTypeInvalid
eSectionTypeCode = _lldb.eSectionTypeCode
eSectionTypeContainer = _lldb.eSectionTypeContainer
eSectionTypeData = _lldb.eSectionTypeData
eSectionTypeDataCString = _lldb.eSectionTypeDataCString
eSectionTypeDataCStringPointers = _lldb.eSectionTypeDataCStringPointers
eSectionTypeDataSymbolAddress = _lldb.eSectionTypeDataSymbolAddress
eSectionTypeData4 = _lldb.eSectionTypeData4
eSectionTypeData8 = _lldb.eSectionTypeData8
eSectionTypeData16 = _lldb.eSectionTypeData16
eSectionTypeDataPointers = _lldb.eSectionTypeDataPointers
eSectionTypeDebug = _lldb.eSectionTypeDebug
eSectionTypeZeroFill = _lldb.eSectionTypeZeroFill
eSectionTypeDataObjCMessageRefs = _lldb.eSectionTypeDataObjCMessageRefs
eSectionTypeDataObjCCFStrings = _lldb.eSectionTypeDataObjCCFStrings
eSectionTypeDWARFDebugAbbrev = _lldb.eSectionTypeDWARFDebugAbbrev
eSectionTypeDWARFDebugAddr = _lldb.eSectionTypeDWARFDebugAddr
eSectionTypeDWARFDebugAranges = _lldb.eSectionTypeDWARFDebugAranges
eSectionTypeDWARFDebugCuIndex = _lldb.eSectionTypeDWARFDebugCuIndex
eSectionTypeDWARFDebugFrame = _lldb.eSectionTypeDWARFDebugFrame
eSectionTypeDWARFDebugInfo = _lldb.eSectionTypeDWARFDebugInfo
eSectionTypeDWARFDebugLine = _lldb.eSectionTypeDWARFDebugLine
eSectionTypeDWARFDebugLoc = _lldb.eSectionTypeDWARFDebugLoc
eSectionTypeDWARFDebugMacInfo = _lldb.eSectionTypeDWARFDebugMacInfo
eSectionTypeDWARFDebugMacro = _lldb.eSectionTypeDWARFDebugMacro
eSectionTypeDWARFDebugPubNames = _lldb.eSectionTypeDWARFDebugPubNames
eSectionTypeDWARFDebugPubTypes = _lldb.eSectionTypeDWARFDebugPubTypes
eSectionTypeDWARFDebugRanges = _lldb.eSectionTypeDWARFDebugRanges
eSectionTypeDWARFDebugStr = _lldb.eSectionTypeDWARFDebugStr
eSectionTypeDWARFDebugStrOffsets = _lldb.eSectionTypeDWARFDebugStrOffsets
eSectionTypeDWARFAppleNames = _lldb.eSectionTypeDWARFAppleNames
eSectionTypeDWARFAppleTypes = _lldb.eSectionTypeDWARFAppleTypes
eSectionTypeDWARFAppleNamespaces = _lldb.eSectionTypeDWARFAppleNamespaces
eSectionTypeDWARFAppleObjC = _lldb.eSectionTypeDWARFAppleObjC
eSectionTypeELFSymbolTable = _lldb.eSectionTypeELFSymbolTable
eSectionTypeELFDynamicSymbols = _lldb.eSectionTypeELFDynamicSymbols
eSectionTypeELFRelocationEntries = _lldb.eSectionTypeELFRelocationEntries
eSectionTypeELFDynamicLinkInfo = _lldb.eSectionTypeELFDynamicLinkInfo
eSectionTypeEHFrame = _lldb.eSectionTypeEHFrame
eSectionTypeARMexidx = _lldb.eSectionTypeARMexidx
eSectionTypeARMextab = _lldb.eSectionTypeARMextab
eSectionTypeCompactUnwind = _lldb.eSectionTypeCompactUnwind
eSectionTypeGoSymtab = _lldb.eSectionTypeGoSymtab
eSectionTypeAbsoluteAddress = _lldb.eSectionTypeAbsoluteAddress
eSectionTypeDWARFGNUDebugAltLink = _lldb.eSectionTypeDWARFGNUDebugAltLink
eSectionTypeDWARFDebugTypes = _lldb.eSectionTypeDWARFDebugTypes
eSectionTypeDWARFDebugNames = _lldb.eSectionTypeDWARFDebugNames
eSectionTypeOther = _lldb.eSectionTypeOther
eEmulateInstructionOptionNone = _lldb.eEmulateInstructionOptionNone
eEmulateInstructionOptionAutoAdvancePC = _lldb.eEmulateInstructionOptionAutoAdvancePC
eEmulateInstructionOptionIgnoreConditions = _lldb.eEmulateInstructionOptionIgnoreConditions
eFunctionNameTypeNone = _lldb.eFunctionNameTypeNone
eFunctionNameTypeAuto = _lldb.eFunctionNameTypeAuto
eFunctionNameTypeFull = _lldb.eFunctionNameTypeFull
eFunctionNameTypeBase = _lldb.eFunctionNameTypeBase
eFunctionNameTypeMethod = _lldb.eFunctionNameTypeMethod
eFunctionNameTypeSelector = _lldb.eFunctionNameTypeSelector
eFunctionNameTypeAny = _lldb.eFunctionNameTypeAny
eBasicTypeInvalid = _lldb.eBasicTypeInvalid
eBasicTypeVoid = _lldb.eBasicTypeVoid
eBasicTypeChar = _lldb.eBasicTypeChar
eBasicTypeSignedChar = _lldb.eBasicTypeSignedChar
eBasicTypeUnsignedChar = _lldb.eBasicTypeUnsignedChar
eBasicTypeWChar = _lldb.eBasicTypeWChar
eBasicTypeSignedWChar = _lldb.eBasicTypeSignedWChar
eBasicTypeUnsignedWChar = _lldb.eBasicTypeUnsignedWChar
eBasicTypeChar16 = _lldb.eBasicTypeChar16
eBasicTypeChar32 = _lldb.eBasicTypeChar32
eBasicTypeShort = _lldb.eBasicTypeShort
eBasicTypeUnsignedShort = _lldb.eBasicTypeUnsignedShort
eBasicTypeInt = _lldb.eBasicTypeInt
eBasicTypeUnsignedInt = _lldb.eBasicTypeUnsignedInt
eBasicTypeLong = _lldb.eBasicTypeLong
eBasicTypeUnsignedLong = _lldb.eBasicTypeUnsignedLong
eBasicTypeLongLong = _lldb.eBasicTypeLongLong
eBasicTypeUnsignedLongLong = _lldb.eBasicTypeUnsignedLongLong
eBasicTypeInt128 = _lldb.eBasicTypeInt128
eBasicTypeUnsignedInt128 = _lldb.eBasicTypeUnsignedInt128
eBasicTypeBool = _lldb.eBasicTypeBool
eBasicTypeHalf = _lldb.eBasicTypeHalf
eBasicTypeFloat = _lldb.eBasicTypeFloat
eBasicTypeDouble = _lldb.eBasicTypeDouble
eBasicTypeLongDouble = _lldb.eBasicTypeLongDouble
eBasicTypeFloatComplex = _lldb.eBasicTypeFloatComplex
eBasicTypeDoubleComplex = _lldb.eBasicTypeDoubleComplex
eBasicTypeLongDoubleComplex = _lldb.eBasicTypeLongDoubleComplex
eBasicTypeObjCID = _lldb.eBasicTypeObjCID
eBasicTypeObjCClass = _lldb.eBasicTypeObjCClass
eBasicTypeObjCSel = _lldb.eBasicTypeObjCSel
eBasicTypeNullPtr = _lldb.eBasicTypeNullPtr
eBasicTypeOther = _lldb.eBasicTypeOther
eTraceTypeNone = _lldb.eTraceTypeNone
eTraceTypeProcessorTrace = _lldb.eTraceTypeProcessorTrace
eStructuredDataTypeInvalid = _lldb.eStructuredDataTypeInvalid
eStructuredDataTypeNull = _lldb.eStructuredDataTypeNull
eStructuredDataTypeGeneric = _lldb.eStructuredDataTypeGeneric
eStructuredDataTypeArray = _lldb.eStructuredDataTypeArray
eStructuredDataTypeInteger = _lldb.eStructuredDataTypeInteger
eStructuredDataTypeFloat = _lldb.eStructuredDataTypeFloat
eStructuredDataTypeBoolean = _lldb.eStructuredDataTypeBoolean
eStructuredDataTypeString = _lldb.eStructuredDataTypeString
eStructuredDataTypeDictionary = _lldb.eStructuredDataTypeDictionary
eTypeClassInvalid = _lldb.eTypeClassInvalid
eTypeClassArray = _lldb.eTypeClassArray
eTypeClassBlockPointer = _lldb.eTypeClassBlockPointer
eTypeClassBuiltin = _lldb.eTypeClassBuiltin
eTypeClassClass = _lldb.eTypeClassClass
eTypeClassComplexFloat = _lldb.eTypeClassComplexFloat
eTypeClassComplexInteger = _lldb.eTypeClassComplexInteger
eTypeClassEnumeration = _lldb.eTypeClassEnumeration
eTypeClassFunction = _lldb.eTypeClassFunction
eTypeClassMemberPointer = _lldb.eTypeClassMemberPointer
eTypeClassObjCObject = _lldb.eTypeClassObjCObject
eTypeClassObjCInterface = _lldb.eTypeClassObjCInterface
eTypeClassObjCObjectPointer = _lldb.eTypeClassObjCObjectPointer
eTypeClassPointer = _lldb.eTypeClassPointer
eTypeClassReference = _lldb.eTypeClassReference
eTypeClassStruct = _lldb.eTypeClassStruct
eTypeClassTypedef = _lldb.eTypeClassTypedef
eTypeClassUnion = _lldb.eTypeClassUnion
eTypeClassVector = _lldb.eTypeClassVector
eTypeClassOther = _lldb.eTypeClassOther
eTypeClassAny = _lldb.eTypeClassAny
eTemplateArgumentKindNull = _lldb.eTemplateArgumentKindNull
eTemplateArgumentKindType = _lldb.eTemplateArgumentKindType
eTemplateArgumentKindDeclaration = _lldb.eTemplateArgumentKindDeclaration
eTemplateArgumentKindIntegral = _lldb.eTemplateArgumentKindIntegral
eTemplateArgumentKindTemplate = _lldb.eTemplateArgumentKindTemplate
eTemplateArgumentKindTemplateExpansion = _lldb.eTemplateArgumentKindTemplateExpansion
eTemplateArgumentKindExpression = _lldb.eTemplateArgumentKindExpression
eTemplateArgumentKindPack = _lldb.eTemplateArgumentKindPack
eTemplateArgumentKindNullPtr = _lldb.eTemplateArgumentKindNullPtr
eTypeOptionNone = _lldb.eTypeOptionNone
eTypeOptionCascade = _lldb.eTypeOptionCascade
eTypeOptionSkipPointers = _lldb.eTypeOptionSkipPointers
eTypeOptionSkipReferences = _lldb.eTypeOptionSkipReferences
eTypeOptionHideChildren = _lldb.eTypeOptionHideChildren
eTypeOptionHideValue = _lldb.eTypeOptionHideValue
eTypeOptionShowOneLiner = _lldb.eTypeOptionShowOneLiner
eTypeOptionHideNames = _lldb.eTypeOptionHideNames
eTypeOptionNonCacheable = _lldb.eTypeOptionNonCacheable
eTypeOptionHideEmptyAggregates = _lldb.eTypeOptionHideEmptyAggregates
eTypeOptionFrontEndWantsDereference = _lldb.eTypeOptionFrontEndWantsDereference
eFrameCompareInvalid = _lldb.eFrameCompareInvalid
eFrameCompareUnknown = _lldb.eFrameCompareUnknown
eFrameCompareEqual = _lldb.eFrameCompareEqual
eFrameCompareSameParent = _lldb.eFrameCompareSameParent
eFrameCompareYounger = _lldb.eFrameCompareYounger
eFrameCompareOlder = _lldb.eFrameCompareOlder
eFilePermissionsUserRead = _lldb.eFilePermissionsUserRead
eFilePermissionsUserWrite = _lldb.eFilePermissionsUserWrite
eFilePermissionsUserExecute = _lldb.eFilePermissionsUserExecute
eFilePermissionsGroupRead = _lldb.eFilePermissionsGroupRead
eFilePermissionsGroupWrite = _lldb.eFilePermissionsGroupWrite
eFilePermissionsGroupExecute = _lldb.eFilePermissionsGroupExecute
eFilePermissionsWorldRead = _lldb.eFilePermissionsWorldRead
eFilePermissionsWorldWrite = _lldb.eFilePermissionsWorldWrite
eFilePermissionsWorldExecute = _lldb.eFilePermissionsWorldExecute
eFilePermissionsUserRW = _lldb.eFilePermissionsUserRW
eFileFilePermissionsUserRX = _lldb.eFileFilePermissionsUserRX
eFilePermissionsUserRWX = _lldb.eFilePermissionsUserRWX
eFilePermissionsGroupRW = _lldb.eFilePermissionsGroupRW
eFilePermissionsGroupRX = _lldb.eFilePermissionsGroupRX
eFilePermissionsGroupRWX = _lldb.eFilePermissionsGroupRWX
eFilePermissionsWorldRW = _lldb.eFilePermissionsWorldRW
eFilePermissionsWorldRX = _lldb.eFilePermissionsWorldRX
eFilePermissionsWorldRWX = _lldb.eFilePermissionsWorldRWX
eFilePermissionsEveryoneR = _lldb.eFilePermissionsEveryoneR
eFilePermissionsEveryoneW = _lldb.eFilePermissionsEveryoneW
eFilePermissionsEveryoneX = _lldb.eFilePermissionsEveryoneX
eFilePermissionsEveryoneRW = _lldb.eFilePermissionsEveryoneRW
eFilePermissionsEveryoneRX = _lldb.eFilePermissionsEveryoneRX
eFilePermissionsEveryoneRWX = _lldb.eFilePermissionsEveryoneRWX
eFilePermissionsFileDefault = _lldb.eFilePermissionsFileDefault
eFilePermissionsDirectoryDefault = _lldb.eFilePermissionsDirectoryDefault
eQueueItemKindUnknown = _lldb.eQueueItemKindUnknown
eQueueItemKindFunction = _lldb.eQueueItemKindFunction
eQueueItemKindBlock = _lldb.eQueueItemKindBlock
eQueueKindUnknown = _lldb.eQueueKindUnknown
eQueueKindSerial = _lldb.eQueueKindSerial
eQueueKindConcurrent = _lldb.eQueueKindConcurrent
eExpressionEvaluationParse = _lldb.eExpressionEvaluationParse
eExpressionEvaluationIRGen = _lldb.eExpressionEvaluationIRGen
eExpressionEvaluationExecution = _lldb.eExpressionEvaluationExecution
eExpressionEvaluationComplete = _lldb.eExpressionEvaluationComplete
eWatchpointKindWrite = _lldb.eWatchpointKindWrite
eWatchpointKindRead = _lldb.eWatchpointKindRead
eGdbSignalBadAccess = _lldb.eGdbSignalBadAccess
eGdbSignalBadInstruction = _lldb.eGdbSignalBadInstruction
eGdbSignalArithmetic = _lldb.eGdbSignalArithmetic
eGdbSignalEmulation = _lldb.eGdbSignalEmulation
eGdbSignalSoftware = _lldb.eGdbSignalSoftware
eGdbSignalBreakpoint = _lldb.eGdbSignalBreakpoint
ePathTypeLLDBShlibDir = _lldb.ePathTypeLLDBShlibDir
ePathTypeSupportExecutableDir = _lldb.ePathTypeSupportExecutableDir
ePathTypeHeaderDir = _lldb.ePathTypeHeaderDir
ePathTypePythonDir = _lldb.ePathTypePythonDir
ePathTypeLLDBSystemPlugins = _lldb.ePathTypeLLDBSystemPlugins
ePathTypeLLDBUserPlugins = _lldb.ePathTypeLLDBUserPlugins
ePathTypeLLDBTempSystemDir = _lldb.ePathTypeLLDBTempSystemDir
ePathTypeGlobalLLDBTempSystemDir = _lldb.ePathTypeGlobalLLDBTempSystemDir
ePathTypeClangDir = _lldb.ePathTypeClangDir
eMemberFunctionKindUnknown = _lldb.eMemberFunctionKindUnknown
eMemberFunctionKindConstructor = _lldb.eMemberFunctionKindConstructor
eMemberFunctionKindDestructor = _lldb.eMemberFunctionKindDestructor
eMemberFunctionKindInstanceMethod = _lldb.eMemberFunctionKindInstanceMethod
eMemberFunctionKindStaticMethod = _lldb.eMemberFunctionKindStaticMethod
eMatchTypeNormal = _lldb.eMatchTypeNormal
eMatchTypeRegex = _lldb.eMatchTypeRegex
eMatchTypeStartsWith = _lldb.eMatchTypeStartsWith
eTypeHasChildren = _lldb.eTypeHasChildren
eTypeHasValue = _lldb.eTypeHasValue
eTypeIsArray = _lldb.eTypeIsArray
eTypeIsBlock = _lldb.eTypeIsBlock
eTypeIsBuiltIn = _lldb.eTypeIsBuiltIn
eTypeIsClass = _lldb.eTypeIsClass
eTypeIsCPlusPlus = _lldb.eTypeIsCPlusPlus
eTypeIsEnumeration = _lldb.eTypeIsEnumeration
eTypeIsFuncPrototype = _lldb.eTypeIsFuncPrototype
eTypeIsMember = _lldb.eTypeIsMember
eTypeIsObjC = _lldb.eTypeIsObjC
eTypeIsPointer = _lldb.eTypeIsPointer
eTypeIsReference = _lldb.eTypeIsReference
eTypeIsStructUnion = _lldb.eTypeIsStructUnion
eTypeIsTemplate = _lldb.eTypeIsTemplate
eTypeIsTypedef = _lldb.eTypeIsTypedef
eTypeIsVector = _lldb.eTypeIsVector
eTypeIsScalar = _lldb.eTypeIsScalar
eTypeIsInteger = _lldb.eTypeIsInteger
eTypeIsFloat = _lldb.eTypeIsFloat
eTypeIsComplex = _lldb.eTypeIsComplex
eTypeIsSigned = _lldb.eTypeIsSigned
eTypeInstanceIsPointer = _lldb.eTypeInstanceIsPointer
eCommandRequiresTarget = _lldb.eCommandRequiresTarget
eCommandRequiresProcess = _lldb.eCommandRequiresProcess
eCommandRequiresThread = _lldb.eCommandRequiresThread
eCommandRequiresFrame = _lldb.eCommandRequiresFrame
eCommandRequiresRegContext = _lldb.eCommandRequiresRegContext
eCommandTryTargetAPILock = _lldb.eCommandTryTargetAPILock
eCommandProcessMustBeLaunched = _lldb.eCommandProcessMustBeLaunched
eCommandProcessMustBePaused = _lldb.eCommandProcessMustBePaused
eTypeSummaryCapped = _lldb.eTypeSummaryCapped
eTypeSummaryUncapped = _lldb.eTypeSummaryUncapped

# ==================================
# Helper function for SBModule class
# ==================================
def in_range(symbol, section):
    """Test whether a symbol is within the range of a section."""
    symSA = symbol.GetStartAddress().GetFileAddress()
    symEA = symbol.GetEndAddress().GetFileAddress()
    secSA = section.GetFileAddress()
    secEA = secSA + section.GetByteSize()

    if symEA != LLDB_INVALID_ADDRESS:
        if secSA <= symSA and symEA <= secEA:
            return True
        else:
            return False
    else:
        if secSA <= symSA and symSA < secEA:
            return True
        else:
            return False


# ===================================
# Iterator for lldb container objects
# ===================================
def lldb_iter(obj, getsize, getelem):
    """A generator adaptor to support iteration for lldb container objects."""
    size = getattr(obj, getsize)
    elem = getattr(obj, getelem)
    for i in range(size()):
        yield elem(i)

# ==============================================================================
# The modify-python-lldb.py script is responsible for post-processing this SWIG-
# generated lldb.py module.  It is responsible for adding the above lldb_iter()
# function definition as well as the supports, in the following, for iteration
# protocol: __iter__, rich comparison methods: __eq__ and __ne__, truth value
# testing (and built-in operation bool()): __nonzero__, and built-in function
# len(): __len__.
# ==============================================================================

class SBAddress(_object):
    """
    A section + offset based address class.

    The SBAddress class allows addresses to be relative to a section
    that can move during runtime due to images (executables, shared
    libraries, bundles, frameworks) being loaded at different
    addresses than the addresses found in the object file that
    represents them on disk. There are currently two types of addresses
    for a section:
        o file addresses
        o load addresses

    File addresses represents the virtual addresses that are in the 'on
    disk' object files. These virtual addresses are converted to be
    relative to unique sections scoped to the object file so that
    when/if the addresses slide when the images are loaded/unloaded
    in memory, we can easily track these changes without having to
    update every object (compile unit ranges, line tables, function
    address ranges, lexical block and inlined subroutine address
    ranges, global and static variables) each time an image is loaded or
    unloaded.

    Load addresses represents the virtual addresses where each section
    ends up getting loaded at runtime. Before executing a program, it
    is common for all of the load addresses to be unresolved. When a
    DynamicLoader plug-in receives notification that shared libraries
    have been loaded/unloaded, the load addresses of the main executable
    and any images (shared libraries) will be  resolved/unresolved. When
    this happens, breakpoints that are in one of these sections can be
    set/cleared.

    See docstring of SBFunction for example usage of SBAddress.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBAddress, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBAddress, name)
    __repr__ = _swig_repr

    def __eq__(self, other): return isinstance(other, SBAddress) and self.GetFileAddress() == other.GetFileAddress() and self.GetModule() == other.GetModule()
    def __ne__(self, other): return not self.__eq__(other)
    def __init__(self, *args):
        """
        __init__(lldb::SBAddress self) -> SBAddress
        __init__(lldb::SBAddress self, SBAddress rhs) -> SBAddress
        __init__(lldb::SBAddress self, SBSection section, lldb::addr_t offset) -> SBAddress
        __init__(lldb::SBAddress self, lldb::addr_t load_addr, SBTarget target) -> SBAddress


        Create an address by resolving a load address using the supplied target.
        """
        this = _lldb.new_SBAddress(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBAddress
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBAddress self) -> bool"""
        return _lldb.SBAddress_IsValid(self)


    def Clear(self):
        """Clear(SBAddress self)"""
        return _lldb.SBAddress_Clear(self)


    def GetFileAddress(self):
        """GetFileAddress(SBAddress self) -> lldb::addr_t"""
        return _lldb.SBAddress_GetFileAddress(self)


    def GetLoadAddress(self, target):
        """GetLoadAddress(SBAddress self, SBTarget target) -> lldb::addr_t"""
        return _lldb.SBAddress_GetLoadAddress(self, target)


    def SetLoadAddress(self, load_addr, target):
        """SetLoadAddress(SBAddress self, lldb::addr_t load_addr, SBTarget target)"""
        return _lldb.SBAddress_SetLoadAddress(self, load_addr, target)


    def OffsetAddress(self, offset):
        """OffsetAddress(SBAddress self, lldb::addr_t offset) -> bool"""
        return _lldb.SBAddress_OffsetAddress(self, offset)


    def GetDescription(self, description):
        """GetDescription(SBAddress self, SBStream description) -> bool"""
        return _lldb.SBAddress_GetDescription(self, description)


    def GetSection(self):
        """GetSection(SBAddress self) -> SBSection"""
        return _lldb.SBAddress_GetSection(self)


    def GetOffset(self):
        """GetOffset(SBAddress self) -> lldb::addr_t"""
        return _lldb.SBAddress_GetOffset(self)


    def SetAddress(self, section, offset):
        """SetAddress(SBAddress self, SBSection section, lldb::addr_t offset)"""
        return _lldb.SBAddress_SetAddress(self, section, offset)


    def GetSymbolContext(self, resolve_scope):
        """
        GetSymbolContext(SBAddress self, uint32_t resolve_scope) -> SBSymbolContext


        GetSymbolContext() and the following can lookup symbol information for a given address.
        An address might refer to code or data from an existing module, or it
        might refer to something on the stack or heap. The following functions
        will only return valid values if the address has been resolved to a code
        or data address using 'void SBAddress::SetLoadAddress(...)' or 
        'lldb::SBAddress SBTarget::ResolveLoadAddress (...)'. 
        """
        return _lldb.SBAddress_GetSymbolContext(self, resolve_scope)


    def GetModule(self):
        """
        GetModule(SBAddress self) -> SBModule


        GetModule() and the following grab individual objects for a given address and
        are less efficient if you want more than one symbol related objects. 
        Use one of the following when you want multiple debug symbol related 
        objects for an address:
           lldb::SBSymbolContext SBAddress::GetSymbolContext (uint32_t resolve_scope);
           lldb::SBSymbolContext SBTarget::ResolveSymbolContextForAddress (const SBAddress &addr, uint32_t resolve_scope);
        One or more bits from the SymbolContextItem enumerations can be logically
        OR'ed together to more efficiently retrieve multiple symbol objects.
        """
        return _lldb.SBAddress_GetModule(self)


    def GetCompileUnit(self):
        """GetCompileUnit(SBAddress self) -> SBCompileUnit"""
        return _lldb.SBAddress_GetCompileUnit(self)


    def GetFunction(self):
        """GetFunction(SBAddress self) -> SBFunction"""
        return _lldb.SBAddress_GetFunction(self)


    def GetBlock(self):
        """GetBlock(SBAddress self) -> SBBlock"""
        return _lldb.SBAddress_GetBlock(self)


    def GetSymbol(self):
        """GetSymbol(SBAddress self) -> SBSymbol"""
        return _lldb.SBAddress_GetSymbol(self)


    def GetLineEntry(self):
        """GetLineEntry(SBAddress self) -> SBLineEntry"""
        return _lldb.SBAddress_GetLineEntry(self)


    def __get_load_addr_property__ (self):
        '''Get the load address for a lldb.SBAddress using the current target.'''
        return self.GetLoadAddress (target)

    def __set_load_addr_property__ (self, load_addr):
        '''Set the load address for a lldb.SBAddress using the current target.'''
        return self.SetLoadAddress (load_addr, target)

    def __int__(self):
        '''Convert an address to a load address if there is a process and that process is alive, or to a file address otherwise.'''
        if process.is_alive:
            return self.GetLoadAddress (target)
        else:
            return self.GetFileAddress ()

    def __oct__(self):
        '''Convert the address to an octal string'''
        return '%o' % int(self)

    def __hex__(self):
        '''Convert the address to an hex string'''
        return '0x%x' % int(self)

    __swig_getmethods__["module"] = GetModule
    if _newclass: module = property(GetModule, None, doc='''A read only property that returns an lldb object that represents the module (lldb.SBModule) that this address resides within.''')

    __swig_getmethods__["compile_unit"] = GetCompileUnit
    if _newclass: compile_unit = property(GetCompileUnit, None, doc='''A read only property that returns an lldb object that represents the compile unit (lldb.SBCompileUnit) that this address resides within.''')

    __swig_getmethods__["line_entry"] = GetLineEntry
    if _newclass: line_entry = property(GetLineEntry, None, doc='''A read only property that returns an lldb object that represents the line entry (lldb.SBLineEntry) that this address resides within.''')

    __swig_getmethods__["function"] = GetFunction
    if _newclass: function = property(GetFunction, None, doc='''A read only property that returns an lldb object that represents the function (lldb.SBFunction) that this address resides within.''')

    __swig_getmethods__["block"] = GetBlock
    if _newclass: block = property(GetBlock, None, doc='''A read only property that returns an lldb object that represents the block (lldb.SBBlock) that this address resides within.''')

    __swig_getmethods__["symbol"] = GetSymbol
    if _newclass: symbol = property(GetSymbol, None, doc='''A read only property that returns an lldb object that represents the symbol (lldb.SBSymbol) that this address resides within.''')

    __swig_getmethods__["offset"] = GetOffset
    if _newclass: offset = property(GetOffset, None, doc='''A read only property that returns the section offset in bytes as an integer.''')

    __swig_getmethods__["section"] = GetSection
    if _newclass: section = property(GetSection, None, doc='''A read only property that returns an lldb object that represents the section (lldb.SBSection) that this address resides within.''')

    __swig_getmethods__["file_addr"] = GetFileAddress
    if _newclass: file_addr = property(GetFileAddress, None, doc='''A read only property that returns file address for the section as an integer. This is the address that represents the address as it is found in the object file that defines it.''')

    __swig_getmethods__["load_addr"] = __get_load_addr_property__
    __swig_setmethods__["load_addr"] = __set_load_addr_property__
    if _newclass: load_addr = property(__get_load_addr_property__, __set_load_addr_property__, doc='''A read/write property that gets/sets the SBAddress using load address. The setter resolves SBAddress using the SBTarget from lldb.target so this property can ONLY be used in the interactive script interpreter (i.e. under the lldb script command) and not in Python based commands, or breakpoint commands.''')



    def __str__(self):
        """__str__(SBAddress self) -> PyObject *"""
        return _lldb.SBAddress___str__(self)

SBAddress_swigregister = _lldb.SBAddress_swigregister
SBAddress_swigregister(SBAddress)

class SBAttachInfo(_object):
    """Proxy of C++ lldb::SBAttachInfo class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBAttachInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBAttachInfo, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBAttachInfo self) -> SBAttachInfo
        __init__(lldb::SBAttachInfo self, lldb::pid_t pid) -> SBAttachInfo
        __init__(lldb::SBAttachInfo self, str const * path, bool wait_for) -> SBAttachInfo
        __init__(lldb::SBAttachInfo self, str const * path, bool wait_for, bool async) -> SBAttachInfo
        __init__(lldb::SBAttachInfo self, SBAttachInfo rhs) -> SBAttachInfo
        """
        this = _lldb.new_SBAttachInfo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def GetProcessID(self):
        """GetProcessID(SBAttachInfo self) -> lldb::pid_t"""
        return _lldb.SBAttachInfo_GetProcessID(self)


    def SetProcessID(self, pid):
        """SetProcessID(SBAttachInfo self, lldb::pid_t pid)"""
        return _lldb.SBAttachInfo_SetProcessID(self, pid)


    def SetExecutable(self, *args):
        """
        SetExecutable(SBAttachInfo self, str const * path)
        SetExecutable(SBAttachInfo self, SBFileSpec exe_file)
        """
        return _lldb.SBAttachInfo_SetExecutable(self, *args)


    def GetWaitForLaunch(self):
        """GetWaitForLaunch(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_GetWaitForLaunch(self)


    def SetWaitForLaunch(self, *args):
        """
        SetWaitForLaunch(SBAttachInfo self, bool b)
        SetWaitForLaunch(SBAttachInfo self, bool b, bool async)
        """
        return _lldb.SBAttachInfo_SetWaitForLaunch(self, *args)


    def GetIgnoreExisting(self):
        """GetIgnoreExisting(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_GetIgnoreExisting(self)


    def SetIgnoreExisting(self, b):
        """SetIgnoreExisting(SBAttachInfo self, bool b)"""
        return _lldb.SBAttachInfo_SetIgnoreExisting(self, b)


    def GetResumeCount(self):
        """GetResumeCount(SBAttachInfo self) -> uint32_t"""
        return _lldb.SBAttachInfo_GetResumeCount(self)


    def SetResumeCount(self, c):
        """SetResumeCount(SBAttachInfo self, uint32_t c)"""
        return _lldb.SBAttachInfo_SetResumeCount(self, c)


    def GetProcessPluginName(self):
        """GetProcessPluginName(SBAttachInfo self) -> str const *"""
        return _lldb.SBAttachInfo_GetProcessPluginName(self)


    def SetProcessPluginName(self, plugin_name):
        """SetProcessPluginName(SBAttachInfo self, str const * plugin_name)"""
        return _lldb.SBAttachInfo_SetProcessPluginName(self, plugin_name)


    def GetUserID(self):
        """GetUserID(SBAttachInfo self) -> uint32_t"""
        return _lldb.SBAttachInfo_GetUserID(self)


    def GetGroupID(self):
        """GetGroupID(SBAttachInfo self) -> uint32_t"""
        return _lldb.SBAttachInfo_GetGroupID(self)


    def UserIDIsValid(self):
        """UserIDIsValid(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_UserIDIsValid(self)


    def GroupIDIsValid(self):
        """GroupIDIsValid(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_GroupIDIsValid(self)


    def SetUserID(self, uid):
        """SetUserID(SBAttachInfo self, uint32_t uid)"""
        return _lldb.SBAttachInfo_SetUserID(self, uid)


    def SetGroupID(self, gid):
        """SetGroupID(SBAttachInfo self, uint32_t gid)"""
        return _lldb.SBAttachInfo_SetGroupID(self, gid)


    def GetEffectiveUserID(self):
        """GetEffectiveUserID(SBAttachInfo self) -> uint32_t"""
        return _lldb.SBAttachInfo_GetEffectiveUserID(self)


    def GetEffectiveGroupID(self):
        """GetEffectiveGroupID(SBAttachInfo self) -> uint32_t"""
        return _lldb.SBAttachInfo_GetEffectiveGroupID(self)


    def EffectiveUserIDIsValid(self):
        """EffectiveUserIDIsValid(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_EffectiveUserIDIsValid(self)


    def EffectiveGroupIDIsValid(self):
        """EffectiveGroupIDIsValid(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_EffectiveGroupIDIsValid(self)


    def SetEffectiveUserID(self, uid):
        """SetEffectiveUserID(SBAttachInfo self, uint32_t uid)"""
        return _lldb.SBAttachInfo_SetEffectiveUserID(self, uid)


    def SetEffectiveGroupID(self, gid):
        """SetEffectiveGroupID(SBAttachInfo self, uint32_t gid)"""
        return _lldb.SBAttachInfo_SetEffectiveGroupID(self, gid)


    def GetParentProcessID(self):
        """GetParentProcessID(SBAttachInfo self) -> lldb::pid_t"""
        return _lldb.SBAttachInfo_GetParentProcessID(self)


    def SetParentProcessID(self, pid):
        """SetParentProcessID(SBAttachInfo self, lldb::pid_t pid)"""
        return _lldb.SBAttachInfo_SetParentProcessID(self, pid)


    def ParentProcessIDIsValid(self):
        """ParentProcessIDIsValid(SBAttachInfo self) -> bool"""
        return _lldb.SBAttachInfo_ParentProcessIDIsValid(self)


    def GetListener(self):
        """GetListener(SBAttachInfo self) -> SBListener"""
        return _lldb.SBAttachInfo_GetListener(self)


    def SetListener(self, listener):
        """SetListener(SBAttachInfo self, SBListener listener)"""
        return _lldb.SBAttachInfo_SetListener(self, listener)

    __swig_destroy__ = _lldb.delete_SBAttachInfo
    __del__ = lambda self: None
SBAttachInfo_swigregister = _lldb.SBAttachInfo_swigregister
SBAttachInfo_swigregister(SBAttachInfo)

class SBBlock(_object):
    """Represents a lexical block. SBFunction contains SBBlock(s)."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBBlock, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBBlock, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBBlock self) -> SBBlock
        __init__(lldb::SBBlock self, SBBlock rhs) -> SBBlock
        """
        this = _lldb.new_SBBlock(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBBlock
    __del__ = lambda self: None

    def IsInlined(self):
        """
        IsInlined(SBBlock self) -> bool

        Does this block represent an inlined function?
        """
        return _lldb.SBBlock_IsInlined(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBBlock self) -> bool"""
        return _lldb.SBBlock_IsValid(self)


    def GetInlinedName(self):
        """
        GetInlinedName(SBBlock self) -> str const *


        Get the function name if this block represents an inlined function;
        otherwise, return None.
        """
        return _lldb.SBBlock_GetInlinedName(self)


    def GetInlinedCallSiteFile(self):
        """
        GetInlinedCallSiteFile(SBBlock self) -> SBFileSpec


        Get the call site file if this block represents an inlined function;
        otherwise, return an invalid file spec.
        """
        return _lldb.SBBlock_GetInlinedCallSiteFile(self)


    def GetInlinedCallSiteLine(self):
        """
        GetInlinedCallSiteLine(SBBlock self) -> uint32_t


        Get the call site line if this block represents an inlined function;
        otherwise, return 0.
        """
        return _lldb.SBBlock_GetInlinedCallSiteLine(self)


    def GetInlinedCallSiteColumn(self):
        """
        GetInlinedCallSiteColumn(SBBlock self) -> uint32_t


        Get the call site column if this block represents an inlined function;
        otherwise, return 0.
        """
        return _lldb.SBBlock_GetInlinedCallSiteColumn(self)


    def GetParent(self):
        """
        GetParent(SBBlock self) -> SBBlock

        Get the parent block.
        """
        return _lldb.SBBlock_GetParent(self)


    def GetContainingInlinedBlock(self):
        """
        GetContainingInlinedBlock(SBBlock self) -> SBBlock

        Get the inlined block that is or contains this block.
        """
        return _lldb.SBBlock_GetContainingInlinedBlock(self)


    def GetSibling(self):
        """
        GetSibling(SBBlock self) -> SBBlock

        Get the sibling block for this block.
        """
        return _lldb.SBBlock_GetSibling(self)


    def GetFirstChild(self):
        """
        GetFirstChild(SBBlock self) -> SBBlock

        Get the first child block.
        """
        return _lldb.SBBlock_GetFirstChild(self)


    def GetNumRanges(self):
        """GetNumRanges(SBBlock self) -> uint32_t"""
        return _lldb.SBBlock_GetNumRanges(self)


    def GetRangeStartAddress(self, idx):
        """GetRangeStartAddress(SBBlock self, uint32_t idx) -> SBAddress"""
        return _lldb.SBBlock_GetRangeStartAddress(self, idx)


    def GetRangeEndAddress(self, idx):
        """GetRangeEndAddress(SBBlock self, uint32_t idx) -> SBAddress"""
        return _lldb.SBBlock_GetRangeEndAddress(self, idx)


    def GetRangeIndexForBlockAddress(self, block_addr):
        """GetRangeIndexForBlockAddress(SBBlock self, SBAddress block_addr) -> uint32_t"""
        return _lldb.SBBlock_GetRangeIndexForBlockAddress(self, block_addr)


    def GetDescription(self, description):
        """GetDescription(SBBlock self, SBStream description) -> bool"""
        return _lldb.SBBlock_GetDescription(self, description)


    def GetVariables(self, *args):
        """
        GetVariables(SBBlock self, SBFrame frame, bool arguments, bool locals, bool statics, lldb::DynamicValueType use_dynamic) -> SBValueList
        GetVariables(SBBlock self, SBTarget target, bool arguments, bool locals, bool statics) -> SBValueList
        """
        return _lldb.SBBlock_GetVariables(self, *args)


    def get_range_at_index(self, idx):
        if idx < self.GetNumRanges():
            return [self.GetRangeStartAddress(idx), self.GetRangeEndAddress(idx)]
        return []

    class ranges_access(object):
        '''A helper object that will lazily hand out an array of lldb.SBAddress that represent address ranges for a block.'''
        def __init__(self, sbblock):
            self.sbblock = sbblock

        def __len__(self):
            if self.sbblock:
                return int(self.sbblock.GetNumRanges())
            return 0

        def __getitem__(self, key):
            count = len(self)
            if type(key) is int:
                return self.sbblock.get_range_at_index (key);
            if isinstance(key, SBAddress):
                range_idx = self.sbblock.GetRangeIndexForBlockAddress(key);
                if range_idx < len(self):
                    return [self.sbblock.GetRangeStartAddress(range_idx), self.sbblock.GetRangeEndAddress(range_idx)]
            else:
                print("error: unsupported item type: %s" % type(key))
            return None

    def get_ranges_access_object(self):
        '''An accessor function that returns a ranges_access() object which allows lazy block address ranges access.'''
        return self.ranges_access (self)

    def get_ranges_array(self):
        '''An accessor function that returns an array object that contains all ranges in this block object.'''
        if not hasattr(self, 'ranges_array'):
            self.ranges_array = []
            for idx in range(self.num_ranges):
                self.ranges_array.append ([self.GetRangeStartAddress(idx), self.GetRangeEndAddress(idx)])
        return self.ranges_array

    def get_call_site(self):
        return declaration(self.GetInlinedCallSiteFile(), self.GetInlinedCallSiteLine(), self.GetInlinedCallSiteColumn())

    __swig_getmethods__["parent"] = GetParent
    if _newclass: parent = property(GetParent, None, doc='''A read only property that returns the same result as GetParent().''')

    __swig_getmethods__["first_child"] = GetFirstChild
    if _newclass: first_child = property(GetFirstChild, None, doc='''A read only property that returns the same result as GetFirstChild().''')

    __swig_getmethods__["call_site"] = get_call_site
    if _newclass: call_site = property(get_call_site, None, doc='''A read only property that returns a lldb.declaration object that contains the inlined call site file, line and column.''')

    __swig_getmethods__["sibling"] = GetSibling
    if _newclass: sibling = property(GetSibling, None, doc='''A read only property that returns the same result as GetSibling().''')

    __swig_getmethods__["name"] = GetInlinedName
    if _newclass: name = property(GetInlinedName, None, doc='''A read only property that returns the same result as GetInlinedName().''')

    __swig_getmethods__["inlined_block"] = GetContainingInlinedBlock
    if _newclass: inlined_block = property(GetContainingInlinedBlock, None, doc='''A read only property that returns the same result as GetContainingInlinedBlock().''')

    __swig_getmethods__["range"] = get_ranges_access_object
    if _newclass: range = property(get_ranges_access_object, None, doc='''A read only property that allows item access to the address ranges for a block by integer (range = block.range[0]) and by lldb.SBAdddress (find the range that contains the specified lldb.SBAddress like "pc_range = lldb.frame.block.range[frame.addr]").''')

    __swig_getmethods__["ranges"] = get_ranges_array
    if _newclass: ranges = property(get_ranges_array, None, doc='''A read only property that returns a list() object that contains all of the address ranges for the block.''')

    __swig_getmethods__["num_ranges"] = GetNumRanges
    if _newclass: num_ranges = property(GetNumRanges, None, doc='''A read only property that returns the same result as GetNumRanges().''')


    def __str__(self):
        """__str__(SBBlock self) -> PyObject *"""
        return _lldb.SBBlock___str__(self)

SBBlock_swigregister = _lldb.SBBlock_swigregister
SBBlock_swigregister(SBBlock)

class SBBreakpoint(_object):
    """
    Represents a logical breakpoint and its associated settings.

    For example (from test/functionalities/breakpoint/breakpoint_ignore_count/
    TestBreakpointIgnoreCount.py),

        def breakpoint_ignore_count_python(self):
            '''Use Python APIs to set breakpoint ignore count.'''
            exe = os.path.join(os.getcwd(), 'a.out')

            # Create a target by the debugger.
            target = self.dbg.CreateTarget(exe)
            self.assertTrue(target, VALID_TARGET)

            # Now create a breakpoint on main.c by name 'c'.
            breakpoint = target.BreakpointCreateByName('c', 'a.out')
            self.assertTrue(breakpoint and
                            breakpoint.GetNumLocations() == 1,
                            VALID_BREAKPOINT)

            # Get the breakpoint location from breakpoint after we verified that,
            # indeed, it has one location.
            location = breakpoint.GetLocationAtIndex(0)
            self.assertTrue(location and
                            location.IsEnabled(),
                            VALID_BREAKPOINT_LOCATION)

            # Set the ignore count on the breakpoint location.
            location.SetIgnoreCount(2)
            self.assertTrue(location.GetIgnoreCount() == 2,
                            'SetIgnoreCount() works correctly')

            # Now launch the process, and do not stop at entry point.
            process = target.LaunchSimple(None, None, os.getcwd())
            self.assertTrue(process, PROCESS_IS_VALID)

            # Frame#0 should be on main.c:37, frame#1 should be on main.c:25, and
            # frame#2 should be on main.c:48.
            #lldbutil.print_stacktraces(process)
            from lldbutil import get_stopped_thread
            thread = get_stopped_thread(process, lldb.eStopReasonBreakpoint)
            self.assertTrue(thread != None, 'There should be a thread stopped due to breakpoint')
            frame0 = thread.GetFrameAtIndex(0)
            frame1 = thread.GetFrameAtIndex(1)
            frame2 = thread.GetFrameAtIndex(2)
            self.assertTrue(frame0.GetLineEntry().GetLine() == self.line1 and
                            frame1.GetLineEntry().GetLine() == self.line3 and
                            frame2.GetLineEntry().GetLine() == self.line4,
                            STOPPED_DUE_TO_BREAKPOINT_IGNORE_COUNT)

            # The hit count for the breakpoint should be 3.
            self.assertTrue(breakpoint.GetHitCount() == 3)

            process.Continue()

    SBBreakpoint supports breakpoint location iteration, for example,

        for bl in breakpoint:
            print('breakpoint location load addr: %s' % hex(bl.GetLoadAddress()))
            print('breakpoint location condition: %s' % hex(bl.GetCondition()))

    and rich comparison methods which allow the API program to use,

        if aBreakpoint == bBreakpoint:
            ...

    to compare two breakpoints for equality.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBBreakpoint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBBreakpoint, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetNumLocations', 'GetLocationAtIndex')
    def __len__(self): return self.GetNumLocations()
    def __eq__(self, other): return isinstance(other, SBBreakpoint) and self.GetID() == other.GetID()
    def __ne__(self, other): return not self.__eq__(other)
    def __init__(self, *args):
        """
        __init__(lldb::SBBreakpoint self) -> SBBreakpoint
        __init__(lldb::SBBreakpoint self, SBBreakpoint rhs) -> SBBreakpoint
        """
        this = _lldb.new_SBBreakpoint(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBBreakpoint
    __del__ = lambda self: None

    def GetID(self):
        """GetID(SBBreakpoint self) -> lldb::break_id_t"""
        return _lldb.SBBreakpoint_GetID(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBBreakpoint self) -> bool"""
        return _lldb.SBBreakpoint_IsValid(self)


    def ClearAllBreakpointSites(self):
        """ClearAllBreakpointSites(SBBreakpoint self)"""
        return _lldb.SBBreakpoint_ClearAllBreakpointSites(self)


    def FindLocationByAddress(self, vm_addr):
        """FindLocationByAddress(SBBreakpoint self, lldb::addr_t vm_addr) -> SBBreakpointLocation"""
        return _lldb.SBBreakpoint_FindLocationByAddress(self, vm_addr)


    def FindLocationIDByAddress(self, vm_addr):
        """FindLocationIDByAddress(SBBreakpoint self, lldb::addr_t vm_addr) -> lldb::break_id_t"""
        return _lldb.SBBreakpoint_FindLocationIDByAddress(self, vm_addr)


    def FindLocationByID(self, bp_loc_id):
        """FindLocationByID(SBBreakpoint self, lldb::break_id_t bp_loc_id) -> SBBreakpointLocation"""
        return _lldb.SBBreakpoint_FindLocationByID(self, bp_loc_id)


    def GetLocationAtIndex(self, index):
        """GetLocationAtIndex(SBBreakpoint self, uint32_t index) -> SBBreakpointLocation"""
        return _lldb.SBBreakpoint_GetLocationAtIndex(self, index)


    def SetEnabled(self, enable):
        """SetEnabled(SBBreakpoint self, bool enable)"""
        return _lldb.SBBreakpoint_SetEnabled(self, enable)


    def IsEnabled(self):
        """IsEnabled(SBBreakpoint self) -> bool"""
        return _lldb.SBBreakpoint_IsEnabled(self)


    def SetOneShot(self, one_shot):
        """SetOneShot(SBBreakpoint self, bool one_shot)"""
        return _lldb.SBBreakpoint_SetOneShot(self, one_shot)


    def IsOneShot(self):
        """IsOneShot(SBBreakpoint self) -> bool"""
        return _lldb.SBBreakpoint_IsOneShot(self)


    def IsInternal(self):
        """IsInternal(SBBreakpoint self) -> bool"""
        return _lldb.SBBreakpoint_IsInternal(self)


    def GetHitCount(self):
        """GetHitCount(SBBreakpoint self) -> uint32_t"""
        return _lldb.SBBreakpoint_GetHitCount(self)


    def SetIgnoreCount(self, count):
        """SetIgnoreCount(SBBreakpoint self, uint32_t count)"""
        return _lldb.SBBreakpoint_SetIgnoreCount(self, count)


    def GetIgnoreCount(self):
        """GetIgnoreCount(SBBreakpoint self) -> uint32_t"""
        return _lldb.SBBreakpoint_GetIgnoreCount(self)


    def SetCondition(self, condition):
        """
        SetCondition(SBBreakpoint self, str const * condition)


        The breakpoint stops only if the condition expression evaluates to true.
        """
        return _lldb.SBBreakpoint_SetCondition(self, condition)


    def GetCondition(self):
        """
        GetCondition(SBBreakpoint self) -> str const *


        Get the condition expression for the breakpoint.
        """
        return _lldb.SBBreakpoint_GetCondition(self)


    def SetAutoContinue(self, auto_continue):
        """SetAutoContinue(SBBreakpoint self, bool auto_continue)"""
        return _lldb.SBBreakpoint_SetAutoContinue(self, auto_continue)


    def GetAutoContinue(self):
        """GetAutoContinue(SBBreakpoint self) -> bool"""
        return _lldb.SBBreakpoint_GetAutoContinue(self)


    def SetThreadID(self, sb_thread_id):
        """SetThreadID(SBBreakpoint self, lldb::tid_t sb_thread_id)"""
        return _lldb.SBBreakpoint_SetThreadID(self, sb_thread_id)


    def GetThreadID(self):
        """GetThreadID(SBBreakpoint self) -> lldb::tid_t"""
        return _lldb.SBBreakpoint_GetThreadID(self)


    def SetThreadIndex(self, index):
        """SetThreadIndex(SBBreakpoint self, uint32_t index)"""
        return _lldb.SBBreakpoint_SetThreadIndex(self, index)


    def GetThreadIndex(self):
        """GetThreadIndex(SBBreakpoint self) -> uint32_t"""
        return _lldb.SBBreakpoint_GetThreadIndex(self)


    def SetThreadName(self, thread_name):
        """SetThreadName(SBBreakpoint self, str const * thread_name)"""
        return _lldb.SBBreakpoint_SetThreadName(self, thread_name)


    def GetThreadName(self):
        """GetThreadName(SBBreakpoint self) -> str const *"""
        return _lldb.SBBreakpoint_GetThreadName(self)


    def SetQueueName(self, queue_name):
        """SetQueueName(SBBreakpoint self, str const * queue_name)"""
        return _lldb.SBBreakpoint_SetQueueName(self, queue_name)


    def GetQueueName(self):
        """GetQueueName(SBBreakpoint self) -> str const *"""
        return _lldb.SBBreakpoint_GetQueueName(self)


    def SetScriptCallbackFunction(self, callback_function_name):
        """
        SetScriptCallbackFunction(SBBreakpoint self, str const * callback_function_name)


        Set the name of the script function to be called when the breakpoint is hit.
        """
        return _lldb.SBBreakpoint_SetScriptCallbackFunction(self, callback_function_name)


    def SetScriptCallbackBody(self, script_body_text):
        """
        SetScriptCallbackBody(SBBreakpoint self, str const * script_body_text) -> SBError


        Provide the body for the script function to be called when the breakpoint is hit.
        The body will be wrapped in a function, which be passed two arguments:
        'frame' - which holds the bottom-most SBFrame of the thread that hit the breakpoint
        'bpno'  - which is the SBBreakpointLocation to which the callback was attached.
        
        The error parameter is currently ignored, but will at some point hold the Python
        compilation diagnostics.
        Returns true if the body compiles successfully, false if not.
        """
        return _lldb.SBBreakpoint_SetScriptCallbackBody(self, script_body_text)


    def SetCommandLineCommands(self, commands):
        """SetCommandLineCommands(SBBreakpoint self, SBStringList commands)"""
        return _lldb.SBBreakpoint_SetCommandLineCommands(self, commands)


    def GetCommandLineCommands(self, commands):
        """GetCommandLineCommands(SBBreakpoint self, SBStringList commands) -> bool"""
        return _lldb.SBBreakpoint_GetCommandLineCommands(self, commands)


    def AddName(self, new_name):
        """AddName(SBBreakpoint self, str const * new_name) -> bool"""
        return _lldb.SBBreakpoint_AddName(self, new_name)


    def RemoveName(self, name_to_remove):
        """RemoveName(SBBreakpoint self, str const * name_to_remove)"""
        return _lldb.SBBreakpoint_RemoveName(self, name_to_remove)


    def MatchesName(self, name):
        """MatchesName(SBBreakpoint self, str const * name) -> bool"""
        return _lldb.SBBreakpoint_MatchesName(self, name)


    def GetNames(self, names):
        """GetNames(SBBreakpoint self, SBStringList names)"""
        return _lldb.SBBreakpoint_GetNames(self, names)


    def GetNumResolvedLocations(self):
        """GetNumResolvedLocations(SBBreakpoint self) -> size_t"""
        return _lldb.SBBreakpoint_GetNumResolvedLocations(self)


    def GetNumLocations(self):
        """GetNumLocations(SBBreakpoint self) -> size_t"""
        return _lldb.SBBreakpoint_GetNumLocations(self)


    def GetDescription(self, *args):
        """
        GetDescription(SBBreakpoint self, SBStream description) -> bool
        GetDescription(SBBreakpoint self, SBStream description, bool include_locations) -> bool
        """
        return _lldb.SBBreakpoint_GetDescription(self, *args)


    def __eq__(self, rhs):
        """__eq__(SBBreakpoint self, SBBreakpoint rhs) -> bool"""
        return _lldb.SBBreakpoint___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBBreakpoint self, SBBreakpoint rhs) -> bool"""
        return _lldb.SBBreakpoint___ne__(self, rhs)


    def EventIsBreakpointEvent(event):
        """EventIsBreakpointEvent(SBEvent event) -> bool"""
        return _lldb.SBBreakpoint_EventIsBreakpointEvent(event)

    EventIsBreakpointEvent = staticmethod(EventIsBreakpointEvent)

    def GetBreakpointEventTypeFromEvent(event):
        """GetBreakpointEventTypeFromEvent(SBEvent event) -> lldb::BreakpointEventType"""
        return _lldb.SBBreakpoint_GetBreakpointEventTypeFromEvent(event)

    GetBreakpointEventTypeFromEvent = staticmethod(GetBreakpointEventTypeFromEvent)

    def GetBreakpointFromEvent(event):
        """GetBreakpointFromEvent(SBEvent event) -> SBBreakpoint"""
        return _lldb.SBBreakpoint_GetBreakpointFromEvent(event)

    GetBreakpointFromEvent = staticmethod(GetBreakpointFromEvent)

    def GetBreakpointLocationAtIndexFromEvent(event, loc_idx):
        """GetBreakpointLocationAtIndexFromEvent(SBEvent event, uint32_t loc_idx) -> SBBreakpointLocation"""
        return _lldb.SBBreakpoint_GetBreakpointLocationAtIndexFromEvent(event, loc_idx)

    GetBreakpointLocationAtIndexFromEvent = staticmethod(GetBreakpointLocationAtIndexFromEvent)

    def GetNumBreakpointLocationsFromEvent(event_sp):
        """GetNumBreakpointLocationsFromEvent(SBEvent event_sp) -> uint32_t"""
        return _lldb.SBBreakpoint_GetNumBreakpointLocationsFromEvent(event_sp)

    GetNumBreakpointLocationsFromEvent = staticmethod(GetNumBreakpointLocationsFromEvent)


    class locations_access(object):
        '''A helper object that will lazily hand out locations for a breakpoint when supplied an index.'''
        def __init__(self, sbbreakpoint):
            self.sbbreakpoint = sbbreakpoint

        def __len__(self):
            if self.sbbreakpoint:
                return int(self.sbbreakpoint.GetNumLocations())
            return 0

        def __getitem__(self, key):
            if type(key) is int and key < len(self):
                return self.sbbreakpoint.GetLocationAtIndex(key)
            return None

    def get_locations_access_object(self):
        '''An accessor function that returns a locations_access() object which allows lazy location access from a lldb.SBBreakpoint object.'''
        return self.locations_access (self)

    def get_breakpoint_location_list(self):
        '''An accessor function that returns a list() that contains all locations in a lldb.SBBreakpoint object.'''
        locations = []
        accessor = self.get_locations_access_object()
        for idx in range(len(accessor)):
            locations.append(accessor[idx])
        return locations

    __swig_getmethods__["locations"] = get_breakpoint_location_list
    if _newclass: locations = property(get_breakpoint_location_list, None, doc='''A read only property that returns a list() of lldb.SBBreakpointLocation objects for this breakpoint.''')

    __swig_getmethods__["location"] = get_locations_access_object
    if _newclass: location = property(get_locations_access_object, None, doc='''A read only property that returns an object that can access locations by index (not location ID) (location = bkpt.location[12]).''')

    __swig_getmethods__["id"] = GetID
    if _newclass: id = property(GetID, None, doc='''A read only property that returns the ID of this breakpoint.''')

    __swig_getmethods__["enabled"] = IsEnabled
    __swig_setmethods__["enabled"] = SetEnabled
    if _newclass: enabled = property(IsEnabled, SetEnabled, doc='''A read/write property that configures whether this breakpoint is enabled or not.''')

    __swig_getmethods__["one_shot"] = IsOneShot
    __swig_setmethods__["one_shot"] = SetOneShot
    if _newclass: one_shot = property(IsOneShot, SetOneShot, doc='''A read/write property that configures whether this breakpoint is one-shot (deleted when hit) or not.''')

    __swig_getmethods__["num_locations"] = GetNumLocations
    if _newclass: num_locations = property(GetNumLocations, None, doc='''A read only property that returns the count of locations of this breakpoint.''')



    def __str__(self):
        """__str__(SBBreakpoint self) -> PyObject *"""
        return _lldb.SBBreakpoint___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBBreakpoint_swigregister = _lldb.SBBreakpoint_swigregister
SBBreakpoint_swigregister(SBBreakpoint)

def SBBreakpoint_EventIsBreakpointEvent(event):
    """SBBreakpoint_EventIsBreakpointEvent(SBEvent event) -> bool"""
    return _lldb.SBBreakpoint_EventIsBreakpointEvent(event)

def SBBreakpoint_GetBreakpointEventTypeFromEvent(event):
    """SBBreakpoint_GetBreakpointEventTypeFromEvent(SBEvent event) -> lldb::BreakpointEventType"""
    return _lldb.SBBreakpoint_GetBreakpointEventTypeFromEvent(event)

def SBBreakpoint_GetBreakpointFromEvent(event):
    """SBBreakpoint_GetBreakpointFromEvent(SBEvent event) -> SBBreakpoint"""
    return _lldb.SBBreakpoint_GetBreakpointFromEvent(event)

def SBBreakpoint_GetBreakpointLocationAtIndexFromEvent(event, loc_idx):
    """SBBreakpoint_GetBreakpointLocationAtIndexFromEvent(SBEvent event, uint32_t loc_idx) -> SBBreakpointLocation"""
    return _lldb.SBBreakpoint_GetBreakpointLocationAtIndexFromEvent(event, loc_idx)

def SBBreakpoint_GetNumBreakpointLocationsFromEvent(event_sp):
    """SBBreakpoint_GetNumBreakpointLocationsFromEvent(SBEvent event_sp) -> uint32_t"""
    return _lldb.SBBreakpoint_GetNumBreakpointLocationsFromEvent(event_sp)

class SBBreakpointList(_object):
    """Proxy of C++ lldb::SBBreakpointList class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBBreakpointList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBBreakpointList, name)
    __repr__ = _swig_repr

    def __init__(self, target):
        """__init__(lldb::SBBreakpointList self, SBTarget target) -> SBBreakpointList"""
        this = _lldb.new_SBBreakpointList(target)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBBreakpointList
    __del__ = lambda self: None

    def GetSize(self):
        """GetSize(SBBreakpointList self) -> size_t"""
        return _lldb.SBBreakpointList_GetSize(self)


    def GetBreakpointAtIndex(self, idx):
        """GetBreakpointAtIndex(SBBreakpointList self, size_t idx) -> SBBreakpoint"""
        return _lldb.SBBreakpointList_GetBreakpointAtIndex(self, idx)


    def FindBreakpointByID(self, arg2):
        """FindBreakpointByID(SBBreakpointList self, lldb::break_id_t arg2) -> SBBreakpoint"""
        return _lldb.SBBreakpointList_FindBreakpointByID(self, arg2)


    def Append(self, sb_bkpt):
        """Append(SBBreakpointList self, SBBreakpoint sb_bkpt)"""
        return _lldb.SBBreakpointList_Append(self, sb_bkpt)


    def AppendIfUnique(self, sb_bkpt):
        """AppendIfUnique(SBBreakpointList self, SBBreakpoint sb_bkpt) -> bool"""
        return _lldb.SBBreakpointList_AppendIfUnique(self, sb_bkpt)


    def AppendByID(self, id):
        """AppendByID(SBBreakpointList self, lldb::break_id_t id)"""
        return _lldb.SBBreakpointList_AppendByID(self, id)


    def Clear(self):
        """Clear(SBBreakpointList self)"""
        return _lldb.SBBreakpointList_Clear(self)

SBBreakpointList_swigregister = _lldb.SBBreakpointList_swigregister
SBBreakpointList_swigregister(SBBreakpointList)

class SBBreakpointLocation(_object):
    """
    Represents one unique instance (by address) of a logical breakpoint.

    A breakpoint location is defined by the breakpoint that produces it,
    and the address that resulted in this particular instantiation.
    Each breakpoint location has its settable options.

    SBBreakpoint contains SBBreakpointLocation(s). See docstring of SBBreakpoint
    for retrieval of an SBBreakpointLocation from an SBBreakpoint.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBBreakpointLocation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBBreakpointLocation, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBBreakpointLocation self) -> SBBreakpointLocation
        __init__(lldb::SBBreakpointLocation self, SBBreakpointLocation rhs) -> SBBreakpointLocation
        """
        this = _lldb.new_SBBreakpointLocation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBBreakpointLocation
    __del__ = lambda self: None

    def GetID(self):
        """GetID(SBBreakpointLocation self) -> lldb::break_id_t"""
        return _lldb.SBBreakpointLocation_GetID(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBBreakpointLocation self) -> bool"""
        return _lldb.SBBreakpointLocation_IsValid(self)


    def GetAddress(self):
        """GetAddress(SBBreakpointLocation self) -> SBAddress"""
        return _lldb.SBBreakpointLocation_GetAddress(self)


    def GetLoadAddress(self):
        """GetLoadAddress(SBBreakpointLocation self) -> lldb::addr_t"""
        return _lldb.SBBreakpointLocation_GetLoadAddress(self)


    def SetEnabled(self, enabled):
        """SetEnabled(SBBreakpointLocation self, bool enabled)"""
        return _lldb.SBBreakpointLocation_SetEnabled(self, enabled)


    def IsEnabled(self):
        """IsEnabled(SBBreakpointLocation self) -> bool"""
        return _lldb.SBBreakpointLocation_IsEnabled(self)


    def GetHitCount(self):
        """GetHitCount(SBBreakpointLocation self) -> uint32_t"""
        return _lldb.SBBreakpointLocation_GetHitCount(self)


    def GetIgnoreCount(self):
        """GetIgnoreCount(SBBreakpointLocation self) -> uint32_t"""
        return _lldb.SBBreakpointLocation_GetIgnoreCount(self)


    def SetIgnoreCount(self, n):
        """SetIgnoreCount(SBBreakpointLocation self, uint32_t n)"""
        return _lldb.SBBreakpointLocation_SetIgnoreCount(self, n)


    def SetCondition(self, condition):
        """
        SetCondition(SBBreakpointLocation self, str const * condition)


        The breakpoint location stops only if the condition expression evaluates
        to true.
        """
        return _lldb.SBBreakpointLocation_SetCondition(self, condition)


    def GetCondition(self):
        """
        GetCondition(SBBreakpointLocation self) -> str const *


        Get the condition expression for the breakpoint location.
        """
        return _lldb.SBBreakpointLocation_GetCondition(self)


    def GetAutoContinue(self):
        """GetAutoContinue(SBBreakpointLocation self) -> bool"""
        return _lldb.SBBreakpointLocation_GetAutoContinue(self)


    def SetAutoContinue(self, auto_continue):
        """SetAutoContinue(SBBreakpointLocation self, bool auto_continue)"""
        return _lldb.SBBreakpointLocation_SetAutoContinue(self, auto_continue)


    def SetScriptCallbackFunction(self, callback_function_name):
        """
        SetScriptCallbackFunction(SBBreakpointLocation self, str const * callback_function_name)


        Set the callback to the given Python function name.
        """
        return _lldb.SBBreakpointLocation_SetScriptCallbackFunction(self, callback_function_name)


    def SetScriptCallbackBody(self, script_body_text):
        """
        SetScriptCallbackBody(SBBreakpointLocation self, str const * script_body_text) -> SBError


        Provide the body for the script function to be called when the breakpoint location is hit.
        The body will be wrapped in a function, which be passed two arguments:
        'frame' - which holds the bottom-most SBFrame of the thread that hit the breakpoint
        'bpno'  - which is the SBBreakpointLocation to which the callback was attached.
        
        The error parameter is currently ignored, but will at some point hold the Python
        compilation diagnostics.
        Returns true if the body compiles successfully, false if not.
        """
        return _lldb.SBBreakpointLocation_SetScriptCallbackBody(self, script_body_text)


    def SetCommandLineCommands(self, commands):
        """SetCommandLineCommands(SBBreakpointLocation self, SBStringList commands)"""
        return _lldb.SBBreakpointLocation_SetCommandLineCommands(self, commands)


    def GetCommandLineCommands(self, commands):
        """GetCommandLineCommands(SBBreakpointLocation self, SBStringList commands) -> bool"""
        return _lldb.SBBreakpointLocation_GetCommandLineCommands(self, commands)


    def SetThreadID(self, sb_thread_id):
        """SetThreadID(SBBreakpointLocation self, lldb::tid_t sb_thread_id)"""
        return _lldb.SBBreakpointLocation_SetThreadID(self, sb_thread_id)


    def GetThreadID(self):
        """GetThreadID(SBBreakpointLocation self) -> lldb::tid_t"""
        return _lldb.SBBreakpointLocation_GetThreadID(self)


    def SetThreadIndex(self, index):
        """SetThreadIndex(SBBreakpointLocation self, uint32_t index)"""
        return _lldb.SBBreakpointLocation_SetThreadIndex(self, index)


    def GetThreadIndex(self):
        """GetThreadIndex(SBBreakpointLocation self) -> uint32_t"""
        return _lldb.SBBreakpointLocation_GetThreadIndex(self)


    def SetThreadName(self, thread_name):
        """SetThreadName(SBBreakpointLocation self, str const * thread_name)"""
        return _lldb.SBBreakpointLocation_SetThreadName(self, thread_name)


    def GetThreadName(self):
        """GetThreadName(SBBreakpointLocation self) -> str const *"""
        return _lldb.SBBreakpointLocation_GetThreadName(self)


    def SetQueueName(self, queue_name):
        """SetQueueName(SBBreakpointLocation self, str const * queue_name)"""
        return _lldb.SBBreakpointLocation_SetQueueName(self, queue_name)


    def GetQueueName(self):
        """GetQueueName(SBBreakpointLocation self) -> str const *"""
        return _lldb.SBBreakpointLocation_GetQueueName(self)


    def IsResolved(self):
        """IsResolved(SBBreakpointLocation self) -> bool"""
        return _lldb.SBBreakpointLocation_IsResolved(self)


    def GetDescription(self, description, level):
        """GetDescription(SBBreakpointLocation self, SBStream description, lldb::DescriptionLevel level) -> bool"""
        return _lldb.SBBreakpointLocation_GetDescription(self, description, level)


    def GetBreakpoint(self):
        """GetBreakpoint(SBBreakpointLocation self) -> SBBreakpoint"""
        return _lldb.SBBreakpointLocation_GetBreakpoint(self)


    def __str__(self):
        """__str__(SBBreakpointLocation self) -> PyObject *"""
        return _lldb.SBBreakpointLocation___str__(self)

SBBreakpointLocation_swigregister = _lldb.SBBreakpointLocation_swigregister
SBBreakpointLocation_swigregister(SBBreakpointLocation)

class SBBreakpointName(_object):
    """
    Represents a breakpoint name registered in a given SBTarget.

    Breakpoint names provide a way to act on groups of breakpoints.  When you add a
    name to a group of breakpoints, you can then use the name in all the command
    line lldb commands for that name.  You can also configure the SBBreakpointName
    options and those options will be propagated to any SBBreakpoints currently
    using that name.  Adding a name to a breakpoint will also apply any of the
    set options to that breakpoint.

    You can also set permissions on a breakpoint name to disable listing, deleting 
    and disabling breakpoints.  That will disallow the given operation for breakpoints
    except when the breakpoint is mentioned by ID.  So for instance deleting all the
    breakpoints won't delete breakpoints so marked.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBBreakpointName, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBBreakpointName, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBBreakpointName self) -> SBBreakpointName
        __init__(lldb::SBBreakpointName self, SBTarget target, str const * name) -> SBBreakpointName
        __init__(lldb::SBBreakpointName self, SBBreakpoint bkpt, str const * name) -> SBBreakpointName
        __init__(lldb::SBBreakpointName self, SBBreakpointName rhs) -> SBBreakpointName
        """
        this = _lldb.new_SBBreakpointName(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBBreakpointName
    __del__ = lambda self: None

    def __eq__(self, rhs):
        """__eq__(SBBreakpointName self, SBBreakpointName rhs) -> bool"""
        return _lldb.SBBreakpointName___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBBreakpointName self, SBBreakpointName rhs) -> bool"""
        return _lldb.SBBreakpointName___ne__(self, rhs)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_IsValid(self)


    def GetName(self):
        """GetName(SBBreakpointName self) -> str const *"""
        return _lldb.SBBreakpointName_GetName(self)


    def SetEnabled(self, enable):
        """SetEnabled(SBBreakpointName self, bool enable)"""
        return _lldb.SBBreakpointName_SetEnabled(self, enable)


    def IsEnabled(self):
        """IsEnabled(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_IsEnabled(self)


    def SetOneShot(self, one_shot):
        """SetOneShot(SBBreakpointName self, bool one_shot)"""
        return _lldb.SBBreakpointName_SetOneShot(self, one_shot)


    def IsOneShot(self):
        """IsOneShot(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_IsOneShot(self)


    def SetIgnoreCount(self, count):
        """SetIgnoreCount(SBBreakpointName self, uint32_t count)"""
        return _lldb.SBBreakpointName_SetIgnoreCount(self, count)


    def GetIgnoreCount(self):
        """GetIgnoreCount(SBBreakpointName self) -> uint32_t"""
        return _lldb.SBBreakpointName_GetIgnoreCount(self)


    def SetCondition(self, condition):
        """SetCondition(SBBreakpointName self, str const * condition)"""
        return _lldb.SBBreakpointName_SetCondition(self, condition)


    def GetCondition(self):
        """GetCondition(SBBreakpointName self) -> str const *"""
        return _lldb.SBBreakpointName_GetCondition(self)


    def SetAutoContinue(self, auto_continue):
        """SetAutoContinue(SBBreakpointName self, bool auto_continue)"""
        return _lldb.SBBreakpointName_SetAutoContinue(self, auto_continue)


    def GetAutoContinue(self):
        """GetAutoContinue(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_GetAutoContinue(self)


    def SetThreadID(self, sb_thread_id):
        """SetThreadID(SBBreakpointName self, lldb::tid_t sb_thread_id)"""
        return _lldb.SBBreakpointName_SetThreadID(self, sb_thread_id)


    def GetThreadID(self):
        """GetThreadID(SBBreakpointName self) -> lldb::tid_t"""
        return _lldb.SBBreakpointName_GetThreadID(self)


    def SetThreadIndex(self, index):
        """SetThreadIndex(SBBreakpointName self, uint32_t index)"""
        return _lldb.SBBreakpointName_SetThreadIndex(self, index)


    def GetThreadIndex(self):
        """GetThreadIndex(SBBreakpointName self) -> uint32_t"""
        return _lldb.SBBreakpointName_GetThreadIndex(self)


    def SetThreadName(self, thread_name):
        """SetThreadName(SBBreakpointName self, str const * thread_name)"""
        return _lldb.SBBreakpointName_SetThreadName(self, thread_name)


    def GetThreadName(self):
        """GetThreadName(SBBreakpointName self) -> str const *"""
        return _lldb.SBBreakpointName_GetThreadName(self)


    def SetQueueName(self, queue_name):
        """SetQueueName(SBBreakpointName self, str const * queue_name)"""
        return _lldb.SBBreakpointName_SetQueueName(self, queue_name)


    def GetQueueName(self):
        """GetQueueName(SBBreakpointName self) -> str const *"""
        return _lldb.SBBreakpointName_GetQueueName(self)


    def SetScriptCallbackFunction(self, callback_function_name):
        """SetScriptCallbackFunction(SBBreakpointName self, str const * callback_function_name)"""
        return _lldb.SBBreakpointName_SetScriptCallbackFunction(self, callback_function_name)


    def SetCommandLineCommands(self, commands):
        """SetCommandLineCommands(SBBreakpointName self, SBStringList commands)"""
        return _lldb.SBBreakpointName_SetCommandLineCommands(self, commands)


    def GetCommandLineCommands(self, commands):
        """GetCommandLineCommands(SBBreakpointName self, SBStringList commands) -> bool"""
        return _lldb.SBBreakpointName_GetCommandLineCommands(self, commands)


    def SetScriptCallbackBody(self, script_body_text):
        """SetScriptCallbackBody(SBBreakpointName self, str const * script_body_text) -> SBError"""
        return _lldb.SBBreakpointName_SetScriptCallbackBody(self, script_body_text)


    def GetHelpString(self):
        """GetHelpString(SBBreakpointName self) -> str const *"""
        return _lldb.SBBreakpointName_GetHelpString(self)


    def SetHelpString(self, help_string):
        """SetHelpString(SBBreakpointName self, str const * help_string)"""
        return _lldb.SBBreakpointName_SetHelpString(self, help_string)


    def GetAllowList(self):
        """GetAllowList(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_GetAllowList(self)


    def SetAllowList(self, value):
        """SetAllowList(SBBreakpointName self, bool value)"""
        return _lldb.SBBreakpointName_SetAllowList(self, value)


    def GetAllowDelete(self):
        """GetAllowDelete(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_GetAllowDelete(self)


    def SetAllowDelete(self, value):
        """SetAllowDelete(SBBreakpointName self, bool value)"""
        return _lldb.SBBreakpointName_SetAllowDelete(self, value)


    def GetAllowDisable(self):
        """GetAllowDisable(SBBreakpointName self) -> bool"""
        return _lldb.SBBreakpointName_GetAllowDisable(self)


    def SetAllowDisable(self, value):
        """SetAllowDisable(SBBreakpointName self, bool value)"""
        return _lldb.SBBreakpointName_SetAllowDisable(self, value)


    def GetDescription(self, description):
        """GetDescription(SBBreakpointName self, SBStream description) -> bool"""
        return _lldb.SBBreakpointName_GetDescription(self, description)


    def __str__(self):
        """__str__(SBBreakpointName self) -> PyObject *"""
        return _lldb.SBBreakpointName___str__(self)

SBBreakpointName_swigregister = _lldb.SBBreakpointName_swigregister
SBBreakpointName_swigregister(SBBreakpointName)

class SBBroadcaster(_object):
    """
    Represents an entity which can broadcast events. A default broadcaster is
    associated with an SBCommandInterpreter, SBProcess, and SBTarget.  For
    example, use

        broadcaster = process.GetBroadcaster()

    to retrieve the process's broadcaster.

    See also SBEvent for example usage of interacting with a broadcaster.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBBroadcaster, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBBroadcaster, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBBroadcaster self) -> SBBroadcaster
        __init__(lldb::SBBroadcaster self, str const * name) -> SBBroadcaster
        __init__(lldb::SBBroadcaster self, SBBroadcaster rhs) -> SBBroadcaster
        """
        this = _lldb.new_SBBroadcaster(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBBroadcaster
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBBroadcaster self) -> bool"""
        return _lldb.SBBroadcaster_IsValid(self)


    def Clear(self):
        """Clear(SBBroadcaster self)"""
        return _lldb.SBBroadcaster_Clear(self)


    def BroadcastEventByType(self, event_type, unique=False):
        """
        BroadcastEventByType(SBBroadcaster self, uint32_t event_type, bool unique=False)
        BroadcastEventByType(SBBroadcaster self, uint32_t event_type)
        """
        return _lldb.SBBroadcaster_BroadcastEventByType(self, event_type, unique)


    def BroadcastEvent(self, event, unique=False):
        """
        BroadcastEvent(SBBroadcaster self, SBEvent event, bool unique=False)
        BroadcastEvent(SBBroadcaster self, SBEvent event)
        """
        return _lldb.SBBroadcaster_BroadcastEvent(self, event, unique)


    def AddInitialEventsToListener(self, listener, requested_events):
        """AddInitialEventsToListener(SBBroadcaster self, SBListener listener, uint32_t requested_events)"""
        return _lldb.SBBroadcaster_AddInitialEventsToListener(self, listener, requested_events)


    def AddListener(self, listener, event_mask):
        """AddListener(SBBroadcaster self, SBListener listener, uint32_t event_mask) -> uint32_t"""
        return _lldb.SBBroadcaster_AddListener(self, listener, event_mask)


    def GetName(self):
        """GetName(SBBroadcaster self) -> str const *"""
        return _lldb.SBBroadcaster_GetName(self)


    def EventTypeHasListeners(self, event_type):
        """EventTypeHasListeners(SBBroadcaster self, uint32_t event_type) -> bool"""
        return _lldb.SBBroadcaster_EventTypeHasListeners(self, event_type)


    def RemoveListener(self, *args):
        """
        RemoveListener(SBBroadcaster self, SBListener listener, uint32_t event_mask) -> bool
        RemoveListener(SBBroadcaster self, SBListener listener) -> bool
        """
        return _lldb.SBBroadcaster_RemoveListener(self, *args)


    def __eq__(self, rhs):
        """__eq__(SBBroadcaster self, SBBroadcaster rhs) -> bool"""
        return _lldb.SBBroadcaster___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBBroadcaster self, SBBroadcaster rhs) -> bool"""
        return _lldb.SBBroadcaster___ne__(self, rhs)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBBroadcaster_swigregister = _lldb.SBBroadcaster_swigregister
SBBroadcaster_swigregister(SBBroadcaster)

class SBCommandInterpreterRunOptions(_object):
    """
    SBCommandInterpreterRunOptions controls how the RunCommandInterpreter runs the code it is fed.
    A default SBCommandInterpreterRunOptions object has:
        StopOnContinue: false
        StopOnError:    false
        StopOnCrash:    false
        EchoCommands:   true
        PrintResults:   true
        AddToHistory:   true



    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBCommandInterpreterRunOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBCommandInterpreterRunOptions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(lldb::SBCommandInterpreterRunOptions self) -> SBCommandInterpreterRunOptions"""
        this = _lldb.new_SBCommandInterpreterRunOptions()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBCommandInterpreterRunOptions
    __del__ = lambda self: None

    def GetStopOnContinue(self):
        """GetStopOnContinue(SBCommandInterpreterRunOptions self) -> bool"""
        return _lldb.SBCommandInterpreterRunOptions_GetStopOnContinue(self)


    def SetStopOnContinue(self, arg2):
        """SetStopOnContinue(SBCommandInterpreterRunOptions self, bool arg2)"""
        return _lldb.SBCommandInterpreterRunOptions_SetStopOnContinue(self, arg2)


    def GetStopOnError(self):
        """GetStopOnError(SBCommandInterpreterRunOptions self) -> bool"""
        return _lldb.SBCommandInterpreterRunOptions_GetStopOnError(self)


    def SetStopOnError(self, arg2):
        """SetStopOnError(SBCommandInterpreterRunOptions self, bool arg2)"""
        return _lldb.SBCommandInterpreterRunOptions_SetStopOnError(self, arg2)


    def GetStopOnCrash(self):
        """GetStopOnCrash(SBCommandInterpreterRunOptions self) -> bool"""
        return _lldb.SBCommandInterpreterRunOptions_GetStopOnCrash(self)


    def SetStopOnCrash(self, arg2):
        """SetStopOnCrash(SBCommandInterpreterRunOptions self, bool arg2)"""
        return _lldb.SBCommandInterpreterRunOptions_SetStopOnCrash(self, arg2)


    def GetEchoCommands(self):
        """GetEchoCommands(SBCommandInterpreterRunOptions self) -> bool"""
        return _lldb.SBCommandInterpreterRunOptions_GetEchoCommands(self)


    def SetEchoCommands(self, arg2):
        """SetEchoCommands(SBCommandInterpreterRunOptions self, bool arg2)"""
        return _lldb.SBCommandInterpreterRunOptions_SetEchoCommands(self, arg2)


    def GetPrintResults(self):
        """GetPrintResults(SBCommandInterpreterRunOptions self) -> bool"""
        return _lldb.SBCommandInterpreterRunOptions_GetPrintResults(self)


    def SetPrintResults(self, arg2):
        """SetPrintResults(SBCommandInterpreterRunOptions self, bool arg2)"""
        return _lldb.SBCommandInterpreterRunOptions_SetPrintResults(self, arg2)


    def GetAddToHistory(self):
        """GetAddToHistory(SBCommandInterpreterRunOptions self) -> bool"""
        return _lldb.SBCommandInterpreterRunOptions_GetAddToHistory(self)


    def SetAddToHistory(self, arg2):
        """SetAddToHistory(SBCommandInterpreterRunOptions self, bool arg2)"""
        return _lldb.SBCommandInterpreterRunOptions_SetAddToHistory(self, arg2)

SBCommandInterpreterRunOptions_swigregister = _lldb.SBCommandInterpreterRunOptions_swigregister
SBCommandInterpreterRunOptions_swigregister(SBCommandInterpreterRunOptions)

class SBCommandInterpreter(_object):
    """
    SBCommandInterpreter handles/interprets commands for lldb.  You get the
    command interpreter from the SBDebugger instance. For example (from test/
    python_api/interpreter/TestCommandInterpreterAPI.py),

        def command_interpreter_api(self):
            '''Test the SBCommandInterpreter APIs.'''
            exe = os.path.join(os.getcwd(), 'a.out')

            # Create a target by the debugger.
            target = self.dbg.CreateTarget(exe)
            self.assertTrue(target, VALID_TARGET)

            # Retrieve the associated command interpreter from our debugger.
            ci = self.dbg.GetCommandInterpreter()
            self.assertTrue(ci, VALID_COMMAND_INTERPRETER)

            # Exercise some APIs....

            self.assertTrue(ci.HasCommands())
            self.assertTrue(ci.HasAliases())
            self.assertTrue(ci.HasAliasOptions())
            self.assertTrue(ci.CommandExists('breakpoint'))
            self.assertTrue(ci.CommandExists('target'))
            self.assertTrue(ci.CommandExists('platform'))
            self.assertTrue(ci.AliasExists('file'))
            self.assertTrue(ci.AliasExists('run'))
            self.assertTrue(ci.AliasExists('bt'))

            res = lldb.SBCommandReturnObject()
            ci.HandleCommand('breakpoint set -f main.c -l %d' % self.line, res)
            self.assertTrue(res.Succeeded())
            ci.HandleCommand('process launch', res)
            self.assertTrue(res.Succeeded())

            process = ci.GetProcess()
            self.assertTrue(process)

            ...

    The HandleCommand() instance method takes two args: the command string and
    an SBCommandReturnObject instance which encapsulates the result of command
    execution.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBCommandInterpreter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBCommandInterpreter, name)
    __repr__ = _swig_repr
    eBroadcastBitThreadShouldExit = _lldb.SBCommandInterpreter_eBroadcastBitThreadShouldExit
    eBroadcastBitResetPrompt = _lldb.SBCommandInterpreter_eBroadcastBitResetPrompt
    eBroadcastBitQuitCommandReceived = _lldb.SBCommandInterpreter_eBroadcastBitQuitCommandReceived
    eBroadcastBitAsynchronousOutputData = _lldb.SBCommandInterpreter_eBroadcastBitAsynchronousOutputData
    eBroadcastBitAsynchronousErrorData = _lldb.SBCommandInterpreter_eBroadcastBitAsynchronousErrorData

    def __init__(self, rhs):
        """__init__(lldb::SBCommandInterpreter self, SBCommandInterpreter rhs) -> SBCommandInterpreter"""
        this = _lldb.new_SBCommandInterpreter(rhs)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBCommandInterpreter
    __del__ = lambda self: None

    def GetArgumentTypeAsCString(arg_type):
        """GetArgumentTypeAsCString(lldb::CommandArgumentType const arg_type) -> str const *"""
        return _lldb.SBCommandInterpreter_GetArgumentTypeAsCString(arg_type)

    GetArgumentTypeAsCString = staticmethod(GetArgumentTypeAsCString)

    def GetArgumentDescriptionAsCString(arg_type):
        """GetArgumentDescriptionAsCString(lldb::CommandArgumentType const arg_type) -> str const *"""
        return _lldb.SBCommandInterpreter_GetArgumentDescriptionAsCString(arg_type)

    GetArgumentDescriptionAsCString = staticmethod(GetArgumentDescriptionAsCString)

    def EventIsCommandInterpreterEvent(event):
        """EventIsCommandInterpreterEvent(SBEvent event) -> bool"""
        return _lldb.SBCommandInterpreter_EventIsCommandInterpreterEvent(event)

    EventIsCommandInterpreterEvent = staticmethod(EventIsCommandInterpreterEvent)

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_IsValid(self)


    def GetIOHandlerControlSequence(self, ch):
        """GetIOHandlerControlSequence(SBCommandInterpreter self, str ch) -> str const *"""
        return _lldb.SBCommandInterpreter_GetIOHandlerControlSequence(self, ch)


    def GetPromptOnQuit(self):
        """GetPromptOnQuit(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_GetPromptOnQuit(self)


    def SetPromptOnQuit(self, b):
        """SetPromptOnQuit(SBCommandInterpreter self, bool b)"""
        return _lldb.SBCommandInterpreter_SetPromptOnQuit(self, b)


    def AllowExitCodeOnQuit(self, b):
        """AllowExitCodeOnQuit(SBCommandInterpreter self, bool b)"""
        return _lldb.SBCommandInterpreter_AllowExitCodeOnQuit(self, b)


    def HasCustomQuitExitCode(self):
        """HasCustomQuitExitCode(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_HasCustomQuitExitCode(self)


    def GetQuitStatus(self):
        """GetQuitStatus(SBCommandInterpreter self) -> int"""
        return _lldb.SBCommandInterpreter_GetQuitStatus(self)


    def ResolveCommand(self, command_line, result):
        """ResolveCommand(SBCommandInterpreter self, str const * command_line, SBCommandReturnObject result)"""
        return _lldb.SBCommandInterpreter_ResolveCommand(self, command_line, result)


    def CommandExists(self, cmd):
        """CommandExists(SBCommandInterpreter self, str const * cmd) -> bool"""
        return _lldb.SBCommandInterpreter_CommandExists(self, cmd)


    def AliasExists(self, cmd):
        """AliasExists(SBCommandInterpreter self, str const * cmd) -> bool"""
        return _lldb.SBCommandInterpreter_AliasExists(self, cmd)


    def GetBroadcaster(self):
        """GetBroadcaster(SBCommandInterpreter self) -> SBBroadcaster"""
        return _lldb.SBCommandInterpreter_GetBroadcaster(self)


    def GetBroadcasterClass():
        """GetBroadcasterClass() -> str const *"""
        return _lldb.SBCommandInterpreter_GetBroadcasterClass()

    GetBroadcasterClass = staticmethod(GetBroadcasterClass)

    def HasCommands(self):
        """HasCommands(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_HasCommands(self)


    def HasAliases(self):
        """HasAliases(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_HasAliases(self)


    def HasAliasOptions(self):
        """HasAliasOptions(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_HasAliasOptions(self)


    def GetProcess(self):
        """GetProcess(SBCommandInterpreter self) -> SBProcess"""
        return _lldb.SBCommandInterpreter_GetProcess(self)


    def GetDebugger(self):
        """GetDebugger(SBCommandInterpreter self) -> SBDebugger"""
        return _lldb.SBCommandInterpreter_GetDebugger(self)


    def SourceInitFileInHomeDirectory(self, result):
        """SourceInitFileInHomeDirectory(SBCommandInterpreter self, SBCommandReturnObject result)"""
        return _lldb.SBCommandInterpreter_SourceInitFileInHomeDirectory(self, result)


    def SourceInitFileInCurrentWorkingDirectory(self, result):
        """SourceInitFileInCurrentWorkingDirectory(SBCommandInterpreter self, SBCommandReturnObject result)"""
        return _lldb.SBCommandInterpreter_SourceInitFileInCurrentWorkingDirectory(self, result)


    def HandleCommand(self, *args):
        """
        HandleCommand(SBCommandInterpreter self, str const * command_line, SBCommandReturnObject result, bool add_to_history=False) -> lldb::ReturnStatus
        HandleCommand(SBCommandInterpreter self, str const * command_line, SBCommandReturnObject result) -> lldb::ReturnStatus
        HandleCommand(SBCommandInterpreter self, str const * command_line, SBExecutionContext exe_ctx, SBCommandReturnObject result, bool add_to_history=False) -> lldb::ReturnStatus
        HandleCommand(SBCommandInterpreter self, str const * command_line, SBExecutionContext exe_ctx, SBCommandReturnObject result) -> lldb::ReturnStatus
        """
        return _lldb.SBCommandInterpreter_HandleCommand(self, *args)


    def HandleCommandsFromFile(self, file, override_context, options, result):
        """HandleCommandsFromFile(SBCommandInterpreter self, SBFileSpec file, SBExecutionContext override_context, SBCommandInterpreterRunOptions options, SBCommandReturnObject result)"""
        return _lldb.SBCommandInterpreter_HandleCommandsFromFile(self, file, override_context, options, result)


    def HandleCompletion(self, current_line, cursor_pos, match_start_point, max_return_elements, matches):
        """HandleCompletion(SBCommandInterpreter self, str const * current_line, uint32_t cursor_pos, int match_start_point, int max_return_elements, SBStringList matches) -> int"""
        return _lldb.SBCommandInterpreter_HandleCompletion(self, current_line, cursor_pos, match_start_point, max_return_elements, matches)


    def IsActive(self):
        """IsActive(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_IsActive(self)


    def WasInterrupted(self):
        """WasInterrupted(SBCommandInterpreter self) -> bool"""
        return _lldb.SBCommandInterpreter_WasInterrupted(self)

SBCommandInterpreter_swigregister = _lldb.SBCommandInterpreter_swigregister
SBCommandInterpreter_swigregister(SBCommandInterpreter)

def SBCommandInterpreter_GetArgumentTypeAsCString(arg_type):
    """SBCommandInterpreter_GetArgumentTypeAsCString(lldb::CommandArgumentType const arg_type) -> char const *"""
    return _lldb.SBCommandInterpreter_GetArgumentTypeAsCString(arg_type)

def SBCommandInterpreter_GetArgumentDescriptionAsCString(arg_type):
    """SBCommandInterpreter_GetArgumentDescriptionAsCString(lldb::CommandArgumentType const arg_type) -> char const *"""
    return _lldb.SBCommandInterpreter_GetArgumentDescriptionAsCString(arg_type)

def SBCommandInterpreter_EventIsCommandInterpreterEvent(event):
    """SBCommandInterpreter_EventIsCommandInterpreterEvent(SBEvent event) -> bool"""
    return _lldb.SBCommandInterpreter_EventIsCommandInterpreterEvent(event)

def SBCommandInterpreter_GetBroadcasterClass():
    """SBCommandInterpreter_GetBroadcasterClass() -> char const *"""
    return _lldb.SBCommandInterpreter_GetBroadcasterClass()

class SBCommandReturnObject(_object):
    """
    Represents a container which holds the result from command execution.
    It works with SBCommandInterpreter.HandleCommand() to encapsulate the result
    of command execution.

    See SBCommandInterpreter for example usage of SBCommandReturnObject.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBCommandReturnObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBCommandReturnObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBCommandReturnObject self) -> SBCommandReturnObject
        __init__(lldb::SBCommandReturnObject self, SBCommandReturnObject rhs) -> SBCommandReturnObject
        """
        this = _lldb.new_SBCommandReturnObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBCommandReturnObject
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBCommandReturnObject self) -> bool"""
        return _lldb.SBCommandReturnObject_IsValid(self)


    def GetOutputSize(self):
        """GetOutputSize(SBCommandReturnObject self) -> size_t"""
        return _lldb.SBCommandReturnObject_GetOutputSize(self)


    def GetErrorSize(self):
        """GetErrorSize(SBCommandReturnObject self) -> size_t"""
        return _lldb.SBCommandReturnObject_GetErrorSize(self)


    def GetOutput(self, *args):
        """
        GetOutput(SBCommandReturnObject self) -> str const
        GetOutput(SBCommandReturnObject self, bool only_if_no_immediate) -> str const *
        """
        return _lldb.SBCommandReturnObject_GetOutput(self, *args)


    def GetError(self, *args):
        """
        GetError(SBCommandReturnObject self) -> str const
        GetError(SBCommandReturnObject self, bool if_no_immediate) -> str const *
        """
        return _lldb.SBCommandReturnObject_GetError(self, *args)


    def PutOutput(self, fh):
        """PutOutput(SBCommandReturnObject self, FILE * fh) -> size_t"""
        return _lldb.SBCommandReturnObject_PutOutput(self, fh)


    def PutError(self, fh):
        """PutError(SBCommandReturnObject self, FILE * fh) -> size_t"""
        return _lldb.SBCommandReturnObject_PutError(self, fh)


    def Clear(self):
        """Clear(SBCommandReturnObject self)"""
        return _lldb.SBCommandReturnObject_Clear(self)


    def SetStatus(self, status):
        """SetStatus(SBCommandReturnObject self, lldb::ReturnStatus status)"""
        return _lldb.SBCommandReturnObject_SetStatus(self, status)


    def SetError(self, *args):
        """
        SetError(SBCommandReturnObject self, SBError error, str const * fallback_error_cstr=None)
        SetError(SBCommandReturnObject self, SBError error)
        SetError(SBCommandReturnObject self, str const * error_cstr)
        """
        return _lldb.SBCommandReturnObject_SetError(self, *args)


    def GetStatus(self):
        """GetStatus(SBCommandReturnObject self) -> lldb::ReturnStatus"""
        return _lldb.SBCommandReturnObject_GetStatus(self)


    def Succeeded(self):
        """Succeeded(SBCommandReturnObject self) -> bool"""
        return _lldb.SBCommandReturnObject_Succeeded(self)


    def HasResult(self):
        """HasResult(SBCommandReturnObject self) -> bool"""
        return _lldb.SBCommandReturnObject_HasResult(self)


    def AppendMessage(self, message):
        """AppendMessage(SBCommandReturnObject self, str const * message)"""
        return _lldb.SBCommandReturnObject_AppendMessage(self, message)


    def AppendWarning(self, message):
        """AppendWarning(SBCommandReturnObject self, str const * message)"""
        return _lldb.SBCommandReturnObject_AppendWarning(self, message)


    def GetDescription(self, description):
        """GetDescription(SBCommandReturnObject self, SBStream description) -> bool"""
        return _lldb.SBCommandReturnObject_GetDescription(self, description)


    def SetImmediateOutputFile(self, fh):
        """SetImmediateOutputFile(SBCommandReturnObject self, FILE * fh)"""
        return _lldb.SBCommandReturnObject_SetImmediateOutputFile(self, fh)


    def SetImmediateErrorFile(self, fh):
        """SetImmediateErrorFile(SBCommandReturnObject self, FILE * fh)"""
        return _lldb.SBCommandReturnObject_SetImmediateErrorFile(self, fh)


    def PutCString(self, string):
        """PutCString(SBCommandReturnObject self, str const * string)"""
        return _lldb.SBCommandReturnObject_PutCString(self, string)


    def Print(self, str):
        """Print(SBCommandReturnObject self, str const * str)"""
        return _lldb.SBCommandReturnObject_Print(self, str)


    def __str__(self):
        """__str__(SBCommandReturnObject self) -> PyObject *"""
        return _lldb.SBCommandReturnObject___str__(self)


    def write(self, str):
        """write(SBCommandReturnObject self, str const * str)"""
        return _lldb.SBCommandReturnObject_write(self, str)


    def flush(self):
        """flush(SBCommandReturnObject self)"""
        return _lldb.SBCommandReturnObject_flush(self)

SBCommandReturnObject_swigregister = _lldb.SBCommandReturnObject_swigregister
SBCommandReturnObject_swigregister(SBCommandReturnObject)

class SBCommunication(_object):
    """Proxy of C++ lldb::SBCommunication class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBCommunication, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBCommunication, name)
    __repr__ = _swig_repr
    eBroadcastBitDisconnected = _lldb.SBCommunication_eBroadcastBitDisconnected
    eBroadcastBitReadThreadGotBytes = _lldb.SBCommunication_eBroadcastBitReadThreadGotBytes
    eBroadcastBitReadThreadDidExit = _lldb.SBCommunication_eBroadcastBitReadThreadDidExit
    eBroadcastBitReadThreadShouldExit = _lldb.SBCommunication_eBroadcastBitReadThreadShouldExit
    eBroadcastBitPacketAvailable = _lldb.SBCommunication_eBroadcastBitPacketAvailable
    eAllEventBits = _lldb.SBCommunication_eAllEventBits

    def __init__(self, *args):
        """
        __init__(lldb::SBCommunication self) -> SBCommunication
        __init__(lldb::SBCommunication self, str const * broadcaster_name) -> SBCommunication
        """
        this = _lldb.new_SBCommunication(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBCommunication
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBCommunication self) -> bool"""
        return _lldb.SBCommunication_IsValid(self)


    def GetBroadcaster(self):
        """GetBroadcaster(SBCommunication self) -> SBBroadcaster"""
        return _lldb.SBCommunication_GetBroadcaster(self)


    def GetBroadcasterClass():
        """GetBroadcasterClass() -> str const *"""
        return _lldb.SBCommunication_GetBroadcasterClass()

    GetBroadcasterClass = staticmethod(GetBroadcasterClass)

    def AdoptFileDesriptor(self, fd, owns_fd):
        """AdoptFileDesriptor(SBCommunication self, int fd, bool owns_fd) -> lldb::ConnectionStatus"""
        return _lldb.SBCommunication_AdoptFileDesriptor(self, fd, owns_fd)


    def Connect(self, url):
        """Connect(SBCommunication self, str const * url) -> lldb::ConnectionStatus"""
        return _lldb.SBCommunication_Connect(self, url)


    def Disconnect(self):
        """Disconnect(SBCommunication self) -> lldb::ConnectionStatus"""
        return _lldb.SBCommunication_Disconnect(self)


    def IsConnected(self):
        """IsConnected(SBCommunication self) -> bool"""
        return _lldb.SBCommunication_IsConnected(self)


    def GetCloseOnEOF(self):
        """GetCloseOnEOF(SBCommunication self) -> bool"""
        return _lldb.SBCommunication_GetCloseOnEOF(self)


    def SetCloseOnEOF(self, b):
        """SetCloseOnEOF(SBCommunication self, bool b)"""
        return _lldb.SBCommunication_SetCloseOnEOF(self, b)


    def Read(self, dst, dst_len, timeout_usec, status):
        """Read(SBCommunication self, void * dst, size_t dst_len, uint32_t timeout_usec, lldb::ConnectionStatus & status) -> size_t"""
        return _lldb.SBCommunication_Read(self, dst, dst_len, timeout_usec, status)


    def Write(self, src, src_len, status):
        """Write(SBCommunication self, void const * src, size_t src_len, lldb::ConnectionStatus & status) -> size_t"""
        return _lldb.SBCommunication_Write(self, src, src_len, status)


    def ReadThreadStart(self):
        """ReadThreadStart(SBCommunication self) -> bool"""
        return _lldb.SBCommunication_ReadThreadStart(self)


    def ReadThreadStop(self):
        """ReadThreadStop(SBCommunication self) -> bool"""
        return _lldb.SBCommunication_ReadThreadStop(self)


    def ReadThreadIsRunning(self):
        """ReadThreadIsRunning(SBCommunication self) -> bool"""
        return _lldb.SBCommunication_ReadThreadIsRunning(self)


    def SetReadThreadBytesReceivedCallback(self, callback, callback_baton):
        """SetReadThreadBytesReceivedCallback(SBCommunication self, lldb::SBCommunication::ReadThreadBytesReceived callback, void * callback_baton) -> bool"""
        return _lldb.SBCommunication_SetReadThreadBytesReceivedCallback(self, callback, callback_baton)

SBCommunication_swigregister = _lldb.SBCommunication_swigregister
SBCommunication_swigregister(SBCommunication)

def SBCommunication_GetBroadcasterClass():
    """SBCommunication_GetBroadcasterClass() -> char const *"""
    return _lldb.SBCommunication_GetBroadcasterClass()

class SBCompileUnit(_object):
    """
    Represents a compilation unit, or compiled source file.

    SBCompileUnit supports line entry iteration. For example,

        # Now get the SBSymbolContext from this frame.  We want everything. :-)
        context = frame0.GetSymbolContext(lldb.eSymbolContextEverything)
        ...

        compileUnit = context.GetCompileUnit()

        for lineEntry in compileUnit:
            print('line entry: %s:%d' % (str(lineEntry.GetFileSpec()),
                                        lineEntry.GetLine()))
            print('start addr: %s' % str(lineEntry.GetStartAddress()))
            print('end   addr: %s' % str(lineEntry.GetEndAddress()))

    produces:

    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:20
    start addr: a.out[0x100000d98]
    end   addr: a.out[0x100000da3]
    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:21
    start addr: a.out[0x100000da3]
    end   addr: a.out[0x100000da9]
    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:22
    start addr: a.out[0x100000da9]
    end   addr: a.out[0x100000db6]
    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:23
    start addr: a.out[0x100000db6]
    end   addr: a.out[0x100000dbc]
    ...

    See also SBSymbolContext and SBLineEntry
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBCompileUnit, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBCompileUnit, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetNumLineEntries', 'GetLineEntryAtIndex')
    def __len__(self): return self.GetNumLineEntries()
    def __init__(self, *args):
        """
        __init__(lldb::SBCompileUnit self) -> SBCompileUnit
        __init__(lldb::SBCompileUnit self, SBCompileUnit rhs) -> SBCompileUnit
        """
        this = _lldb.new_SBCompileUnit(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBCompileUnit
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBCompileUnit self) -> bool"""
        return _lldb.SBCompileUnit_IsValid(self)


    def GetFileSpec(self):
        """GetFileSpec(SBCompileUnit self) -> SBFileSpec"""
        return _lldb.SBCompileUnit_GetFileSpec(self)


    def GetNumLineEntries(self):
        """GetNumLineEntries(SBCompileUnit self) -> uint32_t"""
        return _lldb.SBCompileUnit_GetNumLineEntries(self)


    def GetLineEntryAtIndex(self, idx):
        """GetLineEntryAtIndex(SBCompileUnit self, uint32_t idx) -> SBLineEntry"""
        return _lldb.SBCompileUnit_GetLineEntryAtIndex(self, idx)


    def FindLineEntryIndex(self, *args):
        """
        FindLineEntryIndex(SBCompileUnit self, uint32_t start_idx, uint32_t line, SBFileSpec inline_file_spec) -> uint32_t
        FindLineEntryIndex(SBCompileUnit self, uint32_t start_idx, uint32_t line, SBFileSpec inline_file_spec, bool exact) -> uint32_t
        """
        return _lldb.SBCompileUnit_FindLineEntryIndex(self, *args)


    def GetSupportFileAtIndex(self, idx):
        """GetSupportFileAtIndex(SBCompileUnit self, uint32_t idx) -> SBFileSpec"""
        return _lldb.SBCompileUnit_GetSupportFileAtIndex(self, idx)


    def GetNumSupportFiles(self):
        """GetNumSupportFiles(SBCompileUnit self) -> uint32_t"""
        return _lldb.SBCompileUnit_GetNumSupportFiles(self)


    def FindSupportFileIndex(self, start_idx, sb_file, full):
        """FindSupportFileIndex(SBCompileUnit self, uint32_t start_idx, SBFileSpec sb_file, bool full) -> uint32_t"""
        return _lldb.SBCompileUnit_FindSupportFileIndex(self, start_idx, sb_file, full)


    def GetTypes(self, *args):
        """
        GetTypes(SBCompileUnit self, uint32_t type_mask) -> SBTypeList
        GetTypes(SBCompileUnit self) -> SBTypeList


        Get all types matching type_mask from debug info in this
        compile unit.
        
        @param[in] type_mask
           A bitfield that consists of one or more bits logically OR'ed
           together from the lldb::TypeClass enumeration. This allows
           you to request only structure types, or only class, struct
           and union types. Passing in lldb::eTypeClassAny will return
           all types found in the debug information for this compile
           unit.
        
        @return
           A list of types in this compile unit that match type_mask
        """
        return _lldb.SBCompileUnit_GetTypes(self, *args)


    def GetLanguage(self):
        """GetLanguage(SBCompileUnit self) -> lldb::LanguageType"""
        return _lldb.SBCompileUnit_GetLanguage(self)


    def GetDescription(self, description):
        """GetDescription(SBCompileUnit self, SBStream description) -> bool"""
        return _lldb.SBCompileUnit_GetDescription(self, description)


    def __eq__(self, rhs):
        """__eq__(SBCompileUnit self, SBCompileUnit rhs) -> bool"""
        return _lldb.SBCompileUnit___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBCompileUnit self, SBCompileUnit rhs) -> bool"""
        return _lldb.SBCompileUnit___ne__(self, rhs)


    __swig_getmethods__["file"] = GetFileSpec
    if _newclass: file = property(GetFileSpec, None, doc='''A read only property that returns the same result an lldb object that represents the source file (lldb.SBFileSpec) for the compile unit.''')

    __swig_getmethods__["num_line_entries"] = GetNumLineEntries
    if _newclass: num_line_entries = property(GetNumLineEntries, None, doc='''A read only property that returns the number of line entries in a compile unit as an integer.''')


    def __str__(self):
        """__str__(SBCompileUnit self) -> PyObject *"""
        return _lldb.SBCompileUnit___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBCompileUnit_swigregister = _lldb.SBCompileUnit_swigregister
SBCompileUnit_swigregister(SBCompileUnit)

class SBData(_object):
    """Proxy of C++ lldb::SBData class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBData, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBData self) -> SBData
        __init__(lldb::SBData self, SBData rhs) -> SBData
        """
        this = _lldb.new_SBData(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBData
    __del__ = lambda self: None

    def GetAddressByteSize(self):
        """GetAddressByteSize(SBData self) -> uint8_t"""
        return _lldb.SBData_GetAddressByteSize(self)


    def SetAddressByteSize(self, addr_byte_size):
        """SetAddressByteSize(SBData self, uint8_t addr_byte_size)"""
        return _lldb.SBData_SetAddressByteSize(self, addr_byte_size)


    def Clear(self):
        """Clear(SBData self)"""
        return _lldb.SBData_Clear(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBData self) -> bool"""
        return _lldb.SBData_IsValid(self)


    def GetByteSize(self):
        """GetByteSize(SBData self) -> size_t"""
        return _lldb.SBData_GetByteSize(self)


    def GetByteOrder(self):
        """GetByteOrder(SBData self) -> lldb::ByteOrder"""
        return _lldb.SBData_GetByteOrder(self)


    def SetByteOrder(self, endian):
        """SetByteOrder(SBData self, lldb::ByteOrder endian)"""
        return _lldb.SBData_SetByteOrder(self, endian)


    def GetFloat(self, error, offset):
        """GetFloat(SBData self, SBError error, lldb::offset_t offset) -> float"""
        return _lldb.SBData_GetFloat(self, error, offset)


    def GetDouble(self, error, offset):
        """GetDouble(SBData self, SBError error, lldb::offset_t offset) -> double"""
        return _lldb.SBData_GetDouble(self, error, offset)


    def GetLongDouble(self, error, offset):
        """GetLongDouble(SBData self, SBError error, lldb::offset_t offset) -> long double"""
        return _lldb.SBData_GetLongDouble(self, error, offset)


    def GetAddress(self, error, offset):
        """GetAddress(SBData self, SBError error, lldb::offset_t offset) -> lldb::addr_t"""
        return _lldb.SBData_GetAddress(self, error, offset)


    def GetUnsignedInt8(self, error, offset):
        """GetUnsignedInt8(SBData self, SBError error, lldb::offset_t offset) -> uint8_t"""
        return _lldb.SBData_GetUnsignedInt8(self, error, offset)


    def GetUnsignedInt16(self, error, offset):
        """GetUnsignedInt16(SBData self, SBError error, lldb::offset_t offset) -> uint16_t"""
        return _lldb.SBData_GetUnsignedInt16(self, error, offset)


    def GetUnsignedInt32(self, error, offset):
        """GetUnsignedInt32(SBData self, SBError error, lldb::offset_t offset) -> uint32_t"""
        return _lldb.SBData_GetUnsignedInt32(self, error, offset)


    def GetUnsignedInt64(self, error, offset):
        """GetUnsignedInt64(SBData self, SBError error, lldb::offset_t offset) -> uint64_t"""
        return _lldb.SBData_GetUnsignedInt64(self, error, offset)


    def GetSignedInt8(self, error, offset):
        """GetSignedInt8(SBData self, SBError error, lldb::offset_t offset) -> int8_t"""
        return _lldb.SBData_GetSignedInt8(self, error, offset)


    def GetSignedInt16(self, error, offset):
        """GetSignedInt16(SBData self, SBError error, lldb::offset_t offset) -> int16_t"""
        return _lldb.SBData_GetSignedInt16(self, error, offset)


    def GetSignedInt32(self, error, offset):
        """GetSignedInt32(SBData self, SBError error, lldb::offset_t offset) -> int32_t"""
        return _lldb.SBData_GetSignedInt32(self, error, offset)


    def GetSignedInt64(self, error, offset):
        """GetSignedInt64(SBData self, SBError error, lldb::offset_t offset) -> int64_t"""
        return _lldb.SBData_GetSignedInt64(self, error, offset)


    def GetString(self, error, offset):
        """GetString(SBData self, SBError error, lldb::offset_t offset) -> str const *"""
        return _lldb.SBData_GetString(self, error, offset)


    def GetDescription(self, description, base_addr):
        """GetDescription(SBData self, SBStream description, lldb::addr_t base_addr) -> bool"""
        return _lldb.SBData_GetDescription(self, description, base_addr)


    def ReadRawData(self, error, offset, buf):
        """ReadRawData(SBData self, SBError error, lldb::offset_t offset, void * buf) -> size_t"""
        return _lldb.SBData_ReadRawData(self, error, offset, buf)


    def SetData(self, error, buf, endian, addr_size):
        """SetData(SBData self, SBError error, void const * buf, lldb::ByteOrder endian, uint8_t addr_size)"""
        return _lldb.SBData_SetData(self, error, buf, endian, addr_size)


    def Append(self, rhs):
        """Append(SBData self, SBData rhs) -> bool"""
        return _lldb.SBData_Append(self, rhs)


    def CreateDataFromCString(endian, addr_byte_size, data):
        """CreateDataFromCString(lldb::ByteOrder endian, uint32_t addr_byte_size, str const * data) -> SBData"""
        return _lldb.SBData_CreateDataFromCString(endian, addr_byte_size, data)

    CreateDataFromCString = staticmethod(CreateDataFromCString)

    def CreateDataFromUInt64Array(endian, addr_byte_size, array):
        """CreateDataFromUInt64Array(lldb::ByteOrder endian, uint32_t addr_byte_size, uint64_t * array) -> SBData"""
        return _lldb.SBData_CreateDataFromUInt64Array(endian, addr_byte_size, array)

    CreateDataFromUInt64Array = staticmethod(CreateDataFromUInt64Array)

    def CreateDataFromUInt32Array(endian, addr_byte_size, array):
        """CreateDataFromUInt32Array(lldb::ByteOrder endian, uint32_t addr_byte_size, uint32_t * array) -> SBData"""
        return _lldb.SBData_CreateDataFromUInt32Array(endian, addr_byte_size, array)

    CreateDataFromUInt32Array = staticmethod(CreateDataFromUInt32Array)

    def CreateDataFromSInt64Array(endian, addr_byte_size, array):
        """CreateDataFromSInt64Array(lldb::ByteOrder endian, uint32_t addr_byte_size, int64_t * array) -> SBData"""
        return _lldb.SBData_CreateDataFromSInt64Array(endian, addr_byte_size, array)

    CreateDataFromSInt64Array = staticmethod(CreateDataFromSInt64Array)

    def CreateDataFromSInt32Array(endian, addr_byte_size, array):
        """CreateDataFromSInt32Array(lldb::ByteOrder endian, uint32_t addr_byte_size, int32_t * array) -> SBData"""
        return _lldb.SBData_CreateDataFromSInt32Array(endian, addr_byte_size, array)

    CreateDataFromSInt32Array = staticmethod(CreateDataFromSInt32Array)

    def CreateDataFromDoubleArray(endian, addr_byte_size, array):
        """CreateDataFromDoubleArray(lldb::ByteOrder endian, uint32_t addr_byte_size, double * array) -> SBData"""
        return _lldb.SBData_CreateDataFromDoubleArray(endian, addr_byte_size, array)

    CreateDataFromDoubleArray = staticmethod(CreateDataFromDoubleArray)

    def SetDataFromCString(self, data):
        """SetDataFromCString(SBData self, str const * data) -> bool"""
        return _lldb.SBData_SetDataFromCString(self, data)


    def SetDataFromUInt64Array(self, array):
        """SetDataFromUInt64Array(SBData self, uint64_t * array) -> bool"""
        return _lldb.SBData_SetDataFromUInt64Array(self, array)


    def SetDataFromUInt32Array(self, array):
        """SetDataFromUInt32Array(SBData self, uint32_t * array) -> bool"""
        return _lldb.SBData_SetDataFromUInt32Array(self, array)


    def SetDataFromSInt64Array(self, array):
        """SetDataFromSInt64Array(SBData self, int64_t * array) -> bool"""
        return _lldb.SBData_SetDataFromSInt64Array(self, array)


    def SetDataFromSInt32Array(self, array):
        """SetDataFromSInt32Array(SBData self, int32_t * array) -> bool"""
        return _lldb.SBData_SetDataFromSInt32Array(self, array)


    def SetDataFromDoubleArray(self, array):
        """SetDataFromDoubleArray(SBData self, double * array) -> bool"""
        return _lldb.SBData_SetDataFromDoubleArray(self, array)



    class read_data_helper:
        def __init__(self, sbdata, readerfunc, item_size):
            self.sbdata = sbdata
            self.readerfunc = readerfunc
            self.item_size = item_size
        def __getitem__(self,key):
            if isinstance(key,slice):
                list = []
                for x in range(*key.indices(self.__len__())):
                    list.append(self.__getitem__(x))
                return list
            if not (isinstance(key,six.integer_types)):
                raise TypeError('must be int')
            key = key * self.item_size # SBData uses byte-based indexes, but we want to use itemsize-based indexes here
            error = SBError()
            my_data = self.readerfunc(self.sbdata,error,key)
            if error.Fail():
                raise IndexError(error.GetCString())
            else:
                return my_data
        def __len__(self):
            return int(self.sbdata.GetByteSize()/self.item_size)
        def all(self):
            return self[0:len(self)]

    @classmethod
    def CreateDataFromInt (cls, value, size = None, target = None, ptr_size = None, endian = None):
        import sys
        lldbmodule = sys.modules[cls.__module__]
        lldbdict = lldbmodule.__dict__
        if 'target' in lldbdict:
            lldbtarget = lldbdict['target']
        else:
            lldbtarget = None
        if target == None and lldbtarget != None and lldbtarget.IsValid():
            target = lldbtarget
        if ptr_size == None:
            if target and target.IsValid():
                ptr_size = target.addr_size
            else:
                ptr_size = 8
        if endian == None:
            if target and target.IsValid():
                endian = target.byte_order
            else:
                endian = lldbdict['eByteOrderLittle']
        if size == None:
            if value > 2147483647:
                size = 8
            elif value < -2147483648:
                size = 8
            elif value > 4294967295:
                size = 8
            else:
                size = 4
        if size == 4:
            if value < 0:
                return SBData().CreateDataFromSInt32Array(endian, ptr_size, [value])
            return SBData().CreateDataFromUInt32Array(endian, ptr_size, [value])
        if size == 8:
            if value < 0:
                return SBData().CreateDataFromSInt64Array(endian, ptr_size, [value])
            return SBData().CreateDataFromUInt64Array(endian, ptr_size, [value])
        return None

    def _make_helper(self, sbdata, getfunc, itemsize):
        return self.read_data_helper(sbdata, getfunc, itemsize)

    def _make_helper_uint8(self):
        return self._make_helper(self, SBData.GetUnsignedInt8, 1)

    def _make_helper_uint16(self):
        return self._make_helper(self, SBData.GetUnsignedInt16, 2)

    def _make_helper_uint32(self):
        return self._make_helper(self, SBData.GetUnsignedInt32, 4)

    def _make_helper_uint64(self):
        return self._make_helper(self, SBData.GetUnsignedInt64, 8)

    def _make_helper_sint8(self):
        return self._make_helper(self, SBData.GetSignedInt8, 1)

    def _make_helper_sint16(self):
        return self._make_helper(self, SBData.GetSignedInt16, 2)

    def _make_helper_sint32(self):
        return self._make_helper(self, SBData.GetSignedInt32, 4)

    def _make_helper_sint64(self):
        return self._make_helper(self, SBData.GetSignedInt64, 8)

    def _make_helper_float(self):
        return self._make_helper(self, SBData.GetFloat, 4)

    def _make_helper_double(self):
        return self._make_helper(self, SBData.GetDouble, 8)

    def _read_all_uint8(self):
        return self._make_helper_uint8().all()

    def _read_all_uint16(self):
        return self._make_helper_uint16().all()

    def _read_all_uint32(self):
        return self._make_helper_uint32().all()

    def _read_all_uint64(self):
        return self._make_helper_uint64().all()

    def _read_all_sint8(self):
        return self._make_helper_sint8().all()

    def _read_all_sint16(self):
        return self._make_helper_sint16().all()

    def _read_all_sint32(self):
        return self._make_helper_sint32().all()

    def _read_all_sint64(self):
        return self._make_helper_sint64().all()

    def _read_all_float(self):
        return self._make_helper_float().all()

    def _read_all_double(self):
        return self._make_helper_double().all()

    __swig_getmethods__["uint8"] = _make_helper_uint8
    if _newclass: uint8 = property(_make_helper_uint8, None, doc='''A read only property that returns an array-like object out of which you can read uint8 values.''')

    __swig_getmethods__["uint16"] = _make_helper_uint16
    if _newclass: uint16 = property(_make_helper_uint16, None, doc='''A read only property that returns an array-like object out of which you can read uint16 values.''')

    __swig_getmethods__["uint32"] = _make_helper_uint32
    if _newclass: uint32 = property(_make_helper_uint32, None, doc='''A read only property that returns an array-like object out of which you can read uint32 values.''')

    __swig_getmethods__["uint64"] = _make_helper_uint64
    if _newclass: uint64 = property(_make_helper_uint64, None, doc='''A read only property that returns an array-like object out of which you can read uint64 values.''')

    __swig_getmethods__["sint8"] = _make_helper_sint8
    if _newclass: sint8 = property(_make_helper_sint8, None, doc='''A read only property that returns an array-like object out of which you can read sint8 values.''')

    __swig_getmethods__["sint16"] = _make_helper_sint16
    if _newclass: sint16 = property(_make_helper_sint16, None, doc='''A read only property that returns an array-like object out of which you can read sint16 values.''')

    __swig_getmethods__["sint32"] = _make_helper_sint32
    if _newclass: sint32 = property(_make_helper_sint32, None, doc='''A read only property that returns an array-like object out of which you can read sint32 values.''')

    __swig_getmethods__["sint64"] = _make_helper_sint64
    if _newclass: sint64 = property(_make_helper_sint64, None, doc='''A read only property that returns an array-like object out of which you can read sint64 values.''')

    __swig_getmethods__["float"] = _make_helper_float
    if _newclass: float = property(_make_helper_float, None, doc='''A read only property that returns an array-like object out of which you can read float values.''')

    __swig_getmethods__["double"] = _make_helper_double
    if _newclass: double = property(_make_helper_double, None, doc='''A read only property that returns an array-like object out of which you can read double values.''')

    __swig_getmethods__["uint8s"] = _read_all_uint8
    if _newclass: uint8s = property(_read_all_uint8, None, doc='''A read only property that returns an array with all the contents of this SBData represented as uint8 values.''')

    __swig_getmethods__["uint16s"] = _read_all_uint16
    if _newclass: uint16s = property(_read_all_uint16, None, doc='''A read only property that returns an array with all the contents of this SBData represented as uint16 values.''')

    __swig_getmethods__["uint32s"] = _read_all_uint32
    if _newclass: uint32s = property(_read_all_uint32, None, doc='''A read only property that returns an array with all the contents of this SBData represented as uint32 values.''')

    __swig_getmethods__["uint64s"] = _read_all_uint64
    if _newclass: uint64s = property(_read_all_uint64, None, doc='''A read only property that returns an array with all the contents of this SBData represented as uint64 values.''')

    __swig_getmethods__["sint8s"] = _read_all_sint8
    if _newclass: sint8s = property(_read_all_sint8, None, doc='''A read only property that returns an array with all the contents of this SBData represented as sint8 values.''')

    __swig_getmethods__["sint16s"] = _read_all_sint16
    if _newclass: sint16s = property(_read_all_sint16, None, doc='''A read only property that returns an array with all the contents of this SBData represented as sint16 values.''')

    __swig_getmethods__["sint32s"] = _read_all_sint32
    if _newclass: sint32s = property(_read_all_sint32, None, doc='''A read only property that returns an array with all the contents of this SBData represented as sint32 values.''')

    __swig_getmethods__["sint64s"] = _read_all_sint64
    if _newclass: sint64s = property(_read_all_sint64, None, doc='''A read only property that returns an array with all the contents of this SBData represented as sint64 values.''')

    __swig_getmethods__["floats"] = _read_all_float
    if _newclass: floats = property(_read_all_float, None, doc='''A read only property that returns an array with all the contents of this SBData represented as float values.''')

    __swig_getmethods__["doubles"] = _read_all_double
    if _newclass: doubles = property(_read_all_double, None, doc='''A read only property that returns an array with all the contents of this SBData represented as double values.''')



    __swig_getmethods__["byte_order"] = GetByteOrder
    __swig_setmethods__["byte_order"] = SetByteOrder
    if _newclass: byte_order = property(GetByteOrder, SetByteOrder, doc='''A read/write property getting and setting the endianness of this SBData (data.byte_order = lldb.eByteOrderLittle).''')

    __swig_getmethods__["size"] = GetByteSize
    if _newclass: size = property(GetByteSize, None, doc='''A read only property that returns the size the same result as GetByteSize().''')



    def __str__(self):
        """__str__(SBData self) -> PyObject *"""
        return _lldb.SBData___str__(self)

SBData_swigregister = _lldb.SBData_swigregister
SBData_swigregister(SBData)

def SBData_CreateDataFromCString(endian, addr_byte_size, data):
    """SBData_CreateDataFromCString(lldb::ByteOrder endian, uint32_t addr_byte_size, char const * data) -> SBData"""
    return _lldb.SBData_CreateDataFromCString(endian, addr_byte_size, data)

def SBData_CreateDataFromUInt64Array(endian, addr_byte_size, array):
    """SBData_CreateDataFromUInt64Array(lldb::ByteOrder endian, uint32_t addr_byte_size, uint64_t * array) -> SBData"""
    return _lldb.SBData_CreateDataFromUInt64Array(endian, addr_byte_size, array)

def SBData_CreateDataFromUInt32Array(endian, addr_byte_size, array):
    """SBData_CreateDataFromUInt32Array(lldb::ByteOrder endian, uint32_t addr_byte_size, uint32_t * array) -> SBData"""
    return _lldb.SBData_CreateDataFromUInt32Array(endian, addr_byte_size, array)

def SBData_CreateDataFromSInt64Array(endian, addr_byte_size, array):
    """SBData_CreateDataFromSInt64Array(lldb::ByteOrder endian, uint32_t addr_byte_size, int64_t * array) -> SBData"""
    return _lldb.SBData_CreateDataFromSInt64Array(endian, addr_byte_size, array)

def SBData_CreateDataFromSInt32Array(endian, addr_byte_size, array):
    """SBData_CreateDataFromSInt32Array(lldb::ByteOrder endian, uint32_t addr_byte_size, int32_t * array) -> SBData"""
    return _lldb.SBData_CreateDataFromSInt32Array(endian, addr_byte_size, array)

def SBData_CreateDataFromDoubleArray(endian, addr_byte_size, array):
    """SBData_CreateDataFromDoubleArray(lldb::ByteOrder endian, uint32_t addr_byte_size, double * array) -> SBData"""
    return _lldb.SBData_CreateDataFromDoubleArray(endian, addr_byte_size, array)

class SBDebugger(_object):
    """
    SBDebugger is the primordial object that creates SBTargets and provides
    access to them.  It also manages the overall debugging experiences.

    For example (from example/disasm.py),

    import lldb
    import os
    import sys

    def disassemble_instructions (insts):
        for i in insts:
            print i

    ...

    # Create a new debugger instance
    debugger = lldb.SBDebugger.Create()

    # When we step or continue, don't return from the function until the process 
    # stops. We do this by setting the async mode to false.
    debugger.SetAsync (False)

    # Create a target from a file and arch
    print('Creating a target for '%s'' % exe)

    target = debugger.CreateTargetWithFileAndArch (exe, lldb.LLDB_ARCH_DEFAULT)

    if target:
        # If the target is valid set a breakpoint at main
        main_bp = target.BreakpointCreateByName (fname, target.GetExecutable().GetFilename());

        print main_bp

        # Launch the process. Since we specified synchronous mode, we won't return
        # from this function until we hit the breakpoint at main
        process = target.LaunchSimple (None, None, os.getcwd())

        # Make sure the launch went ok
        if process:
            # Print some simple process info
            state = process.GetState ()
            print process
            if state == lldb.eStateStopped:
                # Get the first thread
                thread = process.GetThreadAtIndex (0)
                if thread:
                    # Print some simple thread info
                    print thread
                    # Get the first frame
                    frame = thread.GetFrameAtIndex (0)
                    if frame:
                        # Print some simple frame info
                        print frame
                        function = frame.GetFunction()
                        # See if we have debug info (a function)
                        if function:
                            # We do have a function, print some info for the function
                            print function
                            # Now get all instructions for this function and print them
                            insts = function.GetInstructions(target)
                            disassemble_instructions (insts)
                        else:
                            # See if we have a symbol in the symbol table for where we stopped
                            symbol = frame.GetSymbol();
                            if symbol:
                                # We do have a symbol, print some info for the symbol
                                print symbol
                                # Now get all instructions for this symbol and print them
                                insts = symbol.GetInstructions(target)
                                disassemble_instructions (insts)

                        registerList = frame.GetRegisters()
                        print('Frame registers (size of register set = %d):' % registerList.GetSize())
                        for value in registerList:
                            #print value
                            print('%s (number of children = %d):' % (value.GetName(), value.GetNumChildren()))
                            for child in value:
                                print('Name: ', child.GetName(), ' Value: ', child.GetValue())

                print('Hit the breakpoint at main, enter to continue and wait for program to exit or 'Ctrl-D'/'quit' to terminate the program')
                next = sys.stdin.readline()
                if not next or next.rstrip('
    ') == 'quit':
                    print('Terminating the inferior process...')
                    process.Kill()
                else:
                    # Now continue to the program exit
                    process.Continue()
                    # When we return from the above function we will hopefully be at the
                    # program exit. Print out some process info
                    print process
            elif state == lldb.eStateExited:
                print('Didn't hit the breakpoint at main, program has exited...')
            else:
                print('Unexpected process state: %s, killing process...' % debugger.StateAsCString (state))
                process.Kill()

    Sometimes you need to create an empty target that will get filled in later.  The most common use for this
    is to attach to a process by name or pid where you don't know the executable up front.  The most convenient way
    to do this is:

    target = debugger.CreateTarget('')
    error = lldb.SBError()
    process = target.AttachToProcessWithName(debugger.GetListener(), 'PROCESS_NAME', False, error)

    or the equivalent arguments for AttachToProcessWithID.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBDebugger, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBDebugger, name)
    __repr__ = _swig_repr

    def Initialize():
        """Initialize()"""
        return _lldb.SBDebugger_Initialize()

    Initialize = staticmethod(Initialize)

    def Terminate():
        """Terminate()"""
        return _lldb.SBDebugger_Terminate()

    Terminate = staticmethod(Terminate)

    def Create(*args):
        """
        Create() -> SBDebugger
        Create(bool source_init_files) -> SBDebugger
        Create(bool source_init_files, lldb::LogOutputCallback log_callback) -> SBDebugger
        """
        return _lldb.SBDebugger_Create(*args)

    Create = staticmethod(Create)

    def Destroy(debugger):
        """Destroy(SBDebugger debugger)"""
        return _lldb.SBDebugger_Destroy(debugger)

    Destroy = staticmethod(Destroy)

    def MemoryPressureDetected():
        """MemoryPressureDetected()"""
        return _lldb.SBDebugger_MemoryPressureDetected()

    MemoryPressureDetected = staticmethod(MemoryPressureDetected)

    def __iter__(self): return lldb_iter(self, 'GetNumTargets', 'GetTargetAtIndex')
    def __len__(self): return self.GetNumTargets()
    def __init__(self, *args):
        """
        __init__(lldb::SBDebugger self) -> SBDebugger
        __init__(lldb::SBDebugger self, SBDebugger rhs) -> SBDebugger
        """
        this = _lldb.new_SBDebugger(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBDebugger
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBDebugger self) -> bool"""
        return _lldb.SBDebugger_IsValid(self)


    def Clear(self):
        """Clear(SBDebugger self)"""
        return _lldb.SBDebugger_Clear(self)


    def SetAsync(self, b):
        """SetAsync(SBDebugger self, bool b)"""
        return _lldb.SBDebugger_SetAsync(self, b)


    def GetAsync(self):
        """GetAsync(SBDebugger self) -> bool"""
        return _lldb.SBDebugger_GetAsync(self)


    def SkipLLDBInitFiles(self, b):
        """SkipLLDBInitFiles(SBDebugger self, bool b)"""
        return _lldb.SBDebugger_SkipLLDBInitFiles(self, b)


    def SetInputFileHandle(self, f, transfer_ownership):
        """SetInputFileHandle(SBDebugger self, FILE * f, bool transfer_ownership)"""
        return _lldb.SBDebugger_SetInputFileHandle(self, f, transfer_ownership)


    def SetOutputFileHandle(self, f, transfer_ownership):
        """SetOutputFileHandle(SBDebugger self, FILE * f, bool transfer_ownership)"""
        return _lldb.SBDebugger_SetOutputFileHandle(self, f, transfer_ownership)


    def SetErrorFileHandle(self, f, transfer_ownership):
        """SetErrorFileHandle(SBDebugger self, FILE * f, bool transfer_ownership)"""
        return _lldb.SBDebugger_SetErrorFileHandle(self, f, transfer_ownership)


    def GetInputFileHandle(self):
        """GetInputFileHandle(SBDebugger self) -> FILE *"""
        return _lldb.SBDebugger_GetInputFileHandle(self)


    def GetOutputFileHandle(self):
        """GetOutputFileHandle(SBDebugger self) -> FILE *"""
        return _lldb.SBDebugger_GetOutputFileHandle(self)


    def GetErrorFileHandle(self):
        """GetErrorFileHandle(SBDebugger self) -> FILE *"""
        return _lldb.SBDebugger_GetErrorFileHandle(self)


    def GetCommandInterpreter(self):
        """GetCommandInterpreter(SBDebugger self) -> SBCommandInterpreter"""
        return _lldb.SBDebugger_GetCommandInterpreter(self)


    def HandleCommand(self, command):
        """HandleCommand(SBDebugger self, str const * command)"""
        return _lldb.SBDebugger_HandleCommand(self, command)


    def GetListener(self):
        """GetListener(SBDebugger self) -> SBListener"""
        return _lldb.SBDebugger_GetListener(self)


    def HandleProcessEvent(self, process, event, out, err):
        """HandleProcessEvent(SBDebugger self, SBProcess process, SBEvent event, FILE * out, FILE * err)"""
        return _lldb.SBDebugger_HandleProcessEvent(self, process, event, out, err)


    def CreateTargetWithFileAndTargetTriple(self, filename, target_triple):
        """CreateTargetWithFileAndTargetTriple(SBDebugger self, str const * filename, str const * target_triple) -> SBTarget"""
        return _lldb.SBDebugger_CreateTargetWithFileAndTargetTriple(self, filename, target_triple)


    def CreateTargetWithFileAndArch(self, filename, archname):
        """CreateTargetWithFileAndArch(SBDebugger self, str const * filename, str const * archname) -> SBTarget"""
        return _lldb.SBDebugger_CreateTargetWithFileAndArch(self, filename, archname)


    def CreateTarget(self, *args):
        """
        CreateTarget(SBDebugger self, str const * filename, str const * target_triple, str const * platform_name, bool add_dependent_modules, SBError sb_error) -> SBTarget
        CreateTarget(SBDebugger self, str const * filename) -> SBTarget
        """
        return _lldb.SBDebugger_CreateTarget(self, *args)


    def GetDummyTarget(self):
        """
        GetDummyTarget(SBDebugger self) -> SBTarget

        The dummy target holds breakpoints and breakpoint names that will prime newly created targets.
        """
        return _lldb.SBDebugger_GetDummyTarget(self)


    def DeleteTarget(self, target):
        """
        DeleteTarget(SBDebugger self, SBTarget target) -> bool

        Return true if target is deleted from the target list of the debugger.
        """
        return _lldb.SBDebugger_DeleteTarget(self, target)


    def GetTargetAtIndex(self, idx):
        """GetTargetAtIndex(SBDebugger self, uint32_t idx) -> SBTarget"""
        return _lldb.SBDebugger_GetTargetAtIndex(self, idx)


    def GetIndexOfTarget(self, target):
        """GetIndexOfTarget(SBDebugger self, SBTarget target) -> uint32_t"""
        return _lldb.SBDebugger_GetIndexOfTarget(self, target)


    def FindTargetWithProcessID(self, pid):
        """FindTargetWithProcessID(SBDebugger self, lldb::pid_t pid) -> SBTarget"""
        return _lldb.SBDebugger_FindTargetWithProcessID(self, pid)


    def FindTargetWithFileAndArch(self, filename, arch):
        """FindTargetWithFileAndArch(SBDebugger self, str const * filename, str const * arch) -> SBTarget"""
        return _lldb.SBDebugger_FindTargetWithFileAndArch(self, filename, arch)


    def GetNumTargets(self):
        """GetNumTargets(SBDebugger self) -> uint32_t"""
        return _lldb.SBDebugger_GetNumTargets(self)


    def GetSelectedTarget(self):
        """GetSelectedTarget(SBDebugger self) -> SBTarget"""
        return _lldb.SBDebugger_GetSelectedTarget(self)


    def SetSelectedTarget(self, target):
        """SetSelectedTarget(SBDebugger self, SBTarget target)"""
        return _lldb.SBDebugger_SetSelectedTarget(self, target)


    def GetSelectedPlatform(self):
        """GetSelectedPlatform(SBDebugger self) -> SBPlatform"""
        return _lldb.SBDebugger_GetSelectedPlatform(self)


    def SetSelectedPlatform(self, platform):
        """SetSelectedPlatform(SBDebugger self, SBPlatform platform)"""
        return _lldb.SBDebugger_SetSelectedPlatform(self, platform)


    def GetNumPlatforms(self):
        """
        GetNumPlatforms(SBDebugger self) -> uint32_t

        Get the number of currently active platforms.
        """
        return _lldb.SBDebugger_GetNumPlatforms(self)


    def GetPlatformAtIndex(self, idx):
        """
        GetPlatformAtIndex(SBDebugger self, uint32_t idx) -> SBPlatform

        Get one of the currently active platforms.
        """
        return _lldb.SBDebugger_GetPlatformAtIndex(self, idx)


    def GetNumAvailablePlatforms(self):
        """
        GetNumAvailablePlatforms(SBDebugger self) -> uint32_t

        Get the number of available platforms.
        """
        return _lldb.SBDebugger_GetNumAvailablePlatforms(self)


    def GetAvailablePlatformInfoAtIndex(self, idx):
        """
        GetAvailablePlatformInfoAtIndex(SBDebugger self, uint32_t idx) -> SBStructuredData


        Get the name and description of one of the available platforms.

        @param idx Zero-based index of the platform for which info should be
                   retrieved, must be less than the value returned by
                   GetNumAvailablePlatforms().
        """
        return _lldb.SBDebugger_GetAvailablePlatformInfoAtIndex(self, idx)


    def GetSourceManager(self):
        """GetSourceManager(SBDebugger self) -> SBSourceManager"""
        return _lldb.SBDebugger_GetSourceManager(self)


    def SetCurrentPlatform(self, platform_name):
        """SetCurrentPlatform(SBDebugger self, str const * platform_name) -> SBError"""
        return _lldb.SBDebugger_SetCurrentPlatform(self, platform_name)


    def SetCurrentPlatformSDKRoot(self, sysroot):
        """SetCurrentPlatformSDKRoot(SBDebugger self, str const * sysroot) -> bool"""
        return _lldb.SBDebugger_SetCurrentPlatformSDKRoot(self, sysroot)


    def SetUseExternalEditor(self, input):
        """SetUseExternalEditor(SBDebugger self, bool input) -> bool"""
        return _lldb.SBDebugger_SetUseExternalEditor(self, input)


    def GetUseExternalEditor(self):
        """GetUseExternalEditor(SBDebugger self) -> bool"""
        return _lldb.SBDebugger_GetUseExternalEditor(self)


    def SetUseColor(self, use_color):
        """SetUseColor(SBDebugger self, bool use_color) -> bool"""
        return _lldb.SBDebugger_SetUseColor(self, use_color)


    def GetUseColor(self):
        """GetUseColor(SBDebugger self) -> bool"""
        return _lldb.SBDebugger_GetUseColor(self)


    def GetDefaultArchitecture(arch_name, arch_name_len):
        """GetDefaultArchitecture(str * arch_name, size_t arch_name_len) -> bool"""
        return _lldb.SBDebugger_GetDefaultArchitecture(arch_name, arch_name_len)

    GetDefaultArchitecture = staticmethod(GetDefaultArchitecture)

    def SetDefaultArchitecture(arch_name):
        """SetDefaultArchitecture(str const * arch_name) -> bool"""
        return _lldb.SBDebugger_SetDefaultArchitecture(arch_name)

    SetDefaultArchitecture = staticmethod(SetDefaultArchitecture)

    def GetScriptingLanguage(self, script_language_name):
        """GetScriptingLanguage(SBDebugger self, str const * script_language_name) -> lldb::ScriptLanguage"""
        return _lldb.SBDebugger_GetScriptingLanguage(self, script_language_name)


    def GetVersionString():
        """GetVersionString() -> str const *"""
        return _lldb.SBDebugger_GetVersionString()

    GetVersionString = staticmethod(GetVersionString)

    def StateAsCString(state):
        """StateAsCString(lldb::StateType state) -> str const *"""
        return _lldb.SBDebugger_StateAsCString(state)

    StateAsCString = staticmethod(StateAsCString)

    def GetBuildConfiguration():
        """GetBuildConfiguration() -> SBStructuredData"""
        return _lldb.SBDebugger_GetBuildConfiguration()

    GetBuildConfiguration = staticmethod(GetBuildConfiguration)

    def StateIsRunningState(state):
        """StateIsRunningState(lldb::StateType state) -> bool"""
        return _lldb.SBDebugger_StateIsRunningState(state)

    StateIsRunningState = staticmethod(StateIsRunningState)

    def StateIsStoppedState(state):
        """StateIsStoppedState(lldb::StateType state) -> bool"""
        return _lldb.SBDebugger_StateIsStoppedState(state)

    StateIsStoppedState = staticmethod(StateIsStoppedState)

    def EnableLog(self, channel, types):
        """EnableLog(SBDebugger self, str const * channel, str const ** types) -> bool"""
        return _lldb.SBDebugger_EnableLog(self, channel, types)


    def SetLoggingCallback(self, log_callback):
        """SetLoggingCallback(SBDebugger self, lldb::LogOutputCallback log_callback)"""
        return _lldb.SBDebugger_SetLoggingCallback(self, log_callback)


    def DispatchInput(self, data):
        """DispatchInput(SBDebugger self, void const * data)"""
        return _lldb.SBDebugger_DispatchInput(self, data)


    def DispatchInputInterrupt(self):
        """DispatchInputInterrupt(SBDebugger self)"""
        return _lldb.SBDebugger_DispatchInputInterrupt(self)


    def DispatchInputEndOfFile(self):
        """DispatchInputEndOfFile(SBDebugger self)"""
        return _lldb.SBDebugger_DispatchInputEndOfFile(self)


    def GetInstanceName(self):
        """GetInstanceName(SBDebugger self) -> str const *"""
        return _lldb.SBDebugger_GetInstanceName(self)


    def FindDebuggerWithID(id):
        """FindDebuggerWithID(int id) -> SBDebugger"""
        return _lldb.SBDebugger_FindDebuggerWithID(id)

    FindDebuggerWithID = staticmethod(FindDebuggerWithID)

    def SetInternalVariable(var_name, value, debugger_instance_name):
        """SetInternalVariable(str const * var_name, str const * value, str const * debugger_instance_name) -> SBError"""
        return _lldb.SBDebugger_SetInternalVariable(var_name, value, debugger_instance_name)

    SetInternalVariable = staticmethod(SetInternalVariable)

    def GetInternalVariableValue(var_name, debugger_instance_name):
        """GetInternalVariableValue(str const * var_name, str const * debugger_instance_name) -> SBStringList"""
        return _lldb.SBDebugger_GetInternalVariableValue(var_name, debugger_instance_name)

    GetInternalVariableValue = staticmethod(GetInternalVariableValue)

    def GetDescription(self, description):
        """GetDescription(SBDebugger self, SBStream description) -> bool"""
        return _lldb.SBDebugger_GetDescription(self, description)


    def GetTerminalWidth(self):
        """GetTerminalWidth(SBDebugger self) -> uint32_t"""
        return _lldb.SBDebugger_GetTerminalWidth(self)


    def SetTerminalWidth(self, term_width):
        """SetTerminalWidth(SBDebugger self, uint32_t term_width)"""
        return _lldb.SBDebugger_SetTerminalWidth(self, term_width)


    def GetID(self):
        """GetID(SBDebugger self) -> lldb::user_id_t"""
        return _lldb.SBDebugger_GetID(self)


    def GetPrompt(self):
        """GetPrompt(SBDebugger self) -> str const *"""
        return _lldb.SBDebugger_GetPrompt(self)


    def SetPrompt(self, prompt):
        """SetPrompt(SBDebugger self, str const * prompt)"""
        return _lldb.SBDebugger_SetPrompt(self, prompt)


    def GetScriptLanguage(self):
        """GetScriptLanguage(SBDebugger self) -> lldb::ScriptLanguage"""
        return _lldb.SBDebugger_GetScriptLanguage(self)


    def SetScriptLanguage(self, script_lang):
        """SetScriptLanguage(SBDebugger self, lldb::ScriptLanguage script_lang)"""
        return _lldb.SBDebugger_SetScriptLanguage(self, script_lang)


    def GetCloseInputOnEOF(self):
        """GetCloseInputOnEOF(SBDebugger self) -> bool"""
        return _lldb.SBDebugger_GetCloseInputOnEOF(self)


    def SetCloseInputOnEOF(self, b):
        """SetCloseInputOnEOF(SBDebugger self, bool b)"""
        return _lldb.SBDebugger_SetCloseInputOnEOF(self, b)


    def GetCategory(self, *args):
        """
        GetCategory(SBDebugger self, str const * category_name) -> SBTypeCategory
        GetCategory(SBDebugger self, lldb::LanguageType lang_type) -> SBTypeCategory
        """
        return _lldb.SBDebugger_GetCategory(self, *args)


    def CreateCategory(self, category_name):
        """CreateCategory(SBDebugger self, str const * category_name) -> SBTypeCategory"""
        return _lldb.SBDebugger_CreateCategory(self, category_name)


    def DeleteCategory(self, category_name):
        """DeleteCategory(SBDebugger self, str const * category_name) -> bool"""
        return _lldb.SBDebugger_DeleteCategory(self, category_name)


    def GetNumCategories(self):
        """GetNumCategories(SBDebugger self) -> uint32_t"""
        return _lldb.SBDebugger_GetNumCategories(self)


    def GetCategoryAtIndex(self, arg2):
        """GetCategoryAtIndex(SBDebugger self, uint32_t arg2) -> SBTypeCategory"""
        return _lldb.SBDebugger_GetCategoryAtIndex(self, arg2)


    def GetDefaultCategory(self):
        """GetDefaultCategory(SBDebugger self) -> SBTypeCategory"""
        return _lldb.SBDebugger_GetDefaultCategory(self)


    def GetFormatForType(self, arg2):
        """GetFormatForType(SBDebugger self, SBTypeNameSpecifier arg2) -> SBTypeFormat"""
        return _lldb.SBDebugger_GetFormatForType(self, arg2)


    def GetSummaryForType(self, arg2):
        """GetSummaryForType(SBDebugger self, SBTypeNameSpecifier arg2) -> SBTypeSummary"""
        return _lldb.SBDebugger_GetSummaryForType(self, arg2)


    def GetFilterForType(self, arg2):
        """GetFilterForType(SBDebugger self, SBTypeNameSpecifier arg2) -> SBTypeFilter"""
        return _lldb.SBDebugger_GetFilterForType(self, arg2)


    def GetSyntheticForType(self, arg2):
        """GetSyntheticForType(SBDebugger self, SBTypeNameSpecifier arg2) -> SBTypeSynthetic"""
        return _lldb.SBDebugger_GetSyntheticForType(self, arg2)


    def RunCommandInterpreter(self, auto_handle_events, spawn_thread, options, num_errors, quit_requested, stopped_for_crash):
        """RunCommandInterpreter(SBDebugger self, bool auto_handle_events, bool spawn_thread, SBCommandInterpreterRunOptions options, int & num_errors, bool & quit_requested, bool & stopped_for_crash)"""
        return _lldb.SBDebugger_RunCommandInterpreter(self, auto_handle_events, spawn_thread, options, num_errors, quit_requested, stopped_for_crash)


    def RunREPL(self, language, repl_options):
        """RunREPL(SBDebugger self, lldb::LanguageType language, str const * repl_options) -> SBError"""
        return _lldb.SBDebugger_RunREPL(self, language, repl_options)


    def __str__(self):
        """__str__(SBDebugger self) -> PyObject *"""
        return _lldb.SBDebugger___str__(self)

SBDebugger_swigregister = _lldb.SBDebugger_swigregister
SBDebugger_swigregister(SBDebugger)

def SBDebugger_Initialize():
    """SBDebugger_Initialize()"""
    return _lldb.SBDebugger_Initialize()

def SBDebugger_Terminate():
    """SBDebugger_Terminate()"""
    return _lldb.SBDebugger_Terminate()

def SBDebugger_Create(*args):
    """
    Create() -> SBDebugger
    Create(bool source_init_files) -> SBDebugger
    SBDebugger_Create(bool source_init_files, lldb::LogOutputCallback log_callback) -> SBDebugger
    """
    return _lldb.SBDebugger_Create(*args)

def SBDebugger_Destroy(debugger):
    """SBDebugger_Destroy(SBDebugger debugger)"""
    return _lldb.SBDebugger_Destroy(debugger)

def SBDebugger_MemoryPressureDetected():
    """SBDebugger_MemoryPressureDetected()"""
    return _lldb.SBDebugger_MemoryPressureDetected()

def SBDebugger_GetDefaultArchitecture(arch_name, arch_name_len):
    """SBDebugger_GetDefaultArchitecture(char * arch_name, size_t arch_name_len) -> bool"""
    return _lldb.SBDebugger_GetDefaultArchitecture(arch_name, arch_name_len)

def SBDebugger_SetDefaultArchitecture(arch_name):
    """SBDebugger_SetDefaultArchitecture(char const * arch_name) -> bool"""
    return _lldb.SBDebugger_SetDefaultArchitecture(arch_name)

def SBDebugger_GetVersionString():
    """SBDebugger_GetVersionString() -> char const *"""
    return _lldb.SBDebugger_GetVersionString()

def SBDebugger_StateAsCString(state):
    """SBDebugger_StateAsCString(lldb::StateType state) -> char const *"""
    return _lldb.SBDebugger_StateAsCString(state)

def SBDebugger_GetBuildConfiguration():
    """SBDebugger_GetBuildConfiguration() -> SBStructuredData"""
    return _lldb.SBDebugger_GetBuildConfiguration()

def SBDebugger_StateIsRunningState(state):
    """SBDebugger_StateIsRunningState(lldb::StateType state) -> bool"""
    return _lldb.SBDebugger_StateIsRunningState(state)

def SBDebugger_StateIsStoppedState(state):
    """SBDebugger_StateIsStoppedState(lldb::StateType state) -> bool"""
    return _lldb.SBDebugger_StateIsStoppedState(state)

def SBDebugger_FindDebuggerWithID(id):
    """SBDebugger_FindDebuggerWithID(int id) -> SBDebugger"""
    return _lldb.SBDebugger_FindDebuggerWithID(id)

def SBDebugger_SetInternalVariable(var_name, value, debugger_instance_name):
    """SBDebugger_SetInternalVariable(char const * var_name, char const * value, char const * debugger_instance_name) -> SBError"""
    return _lldb.SBDebugger_SetInternalVariable(var_name, value, debugger_instance_name)

def SBDebugger_GetInternalVariableValue(var_name, debugger_instance_name):
    """SBDebugger_GetInternalVariableValue(char const * var_name, char const * debugger_instance_name) -> SBStringList"""
    return _lldb.SBDebugger_GetInternalVariableValue(var_name, debugger_instance_name)

class SBDeclaration(_object):
    """Specifies an association with a line and column for a variable."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBDeclaration, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBDeclaration, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBDeclaration self) -> SBDeclaration
        __init__(lldb::SBDeclaration self, SBDeclaration rhs) -> SBDeclaration
        """
        this = _lldb.new_SBDeclaration(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBDeclaration
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBDeclaration self) -> bool"""
        return _lldb.SBDeclaration_IsValid(self)


    def GetFileSpec(self):
        """GetFileSpec(SBDeclaration self) -> SBFileSpec"""
        return _lldb.SBDeclaration_GetFileSpec(self)


    def GetLine(self):
        """GetLine(SBDeclaration self) -> uint32_t"""
        return _lldb.SBDeclaration_GetLine(self)


    def GetColumn(self):
        """GetColumn(SBDeclaration self) -> uint32_t"""
        return _lldb.SBDeclaration_GetColumn(self)


    def GetDescription(self, description):
        """GetDescription(SBDeclaration self, SBStream description) -> bool"""
        return _lldb.SBDeclaration_GetDescription(self, description)


    def SetFileSpec(self, filespec):
        """SetFileSpec(SBDeclaration self, SBFileSpec filespec)"""
        return _lldb.SBDeclaration_SetFileSpec(self, filespec)


    def SetLine(self, line):
        """SetLine(SBDeclaration self, uint32_t line)"""
        return _lldb.SBDeclaration_SetLine(self, line)


    def SetColumn(self, column):
        """SetColumn(SBDeclaration self, uint32_t column)"""
        return _lldb.SBDeclaration_SetColumn(self, column)


    def __eq__(self, rhs):
        """__eq__(SBDeclaration self, SBDeclaration rhs) -> bool"""
        return _lldb.SBDeclaration___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBDeclaration self, SBDeclaration rhs) -> bool"""
        return _lldb.SBDeclaration___ne__(self, rhs)


    __swig_getmethods__["file"] = GetFileSpec
    if _newclass: file = property(GetFileSpec, None, doc='''A read only property that returns an lldb object that represents the file (lldb.SBFileSpec) for this line entry.''')

    __swig_getmethods__["line"] = GetLine
    if _newclass: line = property(GetLine, None, doc='''A read only property that returns the 1 based line number for this line entry, a return value of zero indicates that no line information is available.''')

    __swig_getmethods__["column"] = GetColumn
    if _newclass: column = property(GetColumn, None, doc='''A read only property that returns the 1 based column number for this line entry, a return value of zero indicates that no column information is available.''')


    def __str__(self):
        """__str__(SBDeclaration self) -> PyObject *"""
        return _lldb.SBDeclaration___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBDeclaration_swigregister = _lldb.SBDeclaration_swigregister
SBDeclaration_swigregister(SBDeclaration)

class SBError(_object):
    """
    Represents a container for holding any error code.

    For example (from test/python_api/hello_world/TestHelloWorld.py),

        def hello_world_attach_with_id_api(self):
            '''Create target, spawn a process, and attach to it by id.'''

            target = self.dbg.CreateTarget(self.exe)

            # Spawn a new process and don't display the stdout if not in TraceOn() mode.
            import subprocess
            popen = subprocess.Popen([self.exe, 'abc', 'xyz'],
                                     stdout = open(os.devnull, 'w') if not self.TraceOn() else None)

            listener = lldb.SBListener('my.attach.listener')
            error = lldb.SBError()
            process = target.AttachToProcessWithID(listener, popen.pid, error)

            self.assertTrue(error.Success() and process, PROCESS_IS_VALID)

            # Let's check the stack traces of the attached process.
            import lldbutil
            stacktraces = lldbutil.print_stacktraces(process, string_buffer=True)
            self.expect(stacktraces, exe=False,
                substrs = ['main.c:%d' % self.line2,
                           '(int)argc=3'])

            listener = lldb.SBListener('my.attach.listener')
            error = lldb.SBError()
            process = target.AttachToProcessWithID(listener, popen.pid, error)

            self.assertTrue(error.Success() and process, PROCESS_IS_VALID)

    checks that after the attach, there is no error condition by asserting
    that error.Success() is True and we get back a valid process object.

    And (from test/python_api/event/TestEvent.py),

            # Now launch the process, and do not stop at entry point.
            error = lldb.SBError()
            process = target.Launch(listener, None, None, None, None, None, None, 0, False, error)
            self.assertTrue(error.Success() and process, PROCESS_IS_VALID)

    checks that after calling the target.Launch() method there's no error
    condition and we get back a void process object.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBError, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBError self) -> SBError
        __init__(lldb::SBError self, SBError rhs) -> SBError
        """
        this = _lldb.new_SBError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBError
    __del__ = lambda self: None

    def GetCString(self):
        """GetCString(SBError self) -> str const *"""
        return _lldb.SBError_GetCString(self)


    def Clear(self):
        """Clear(SBError self)"""
        return _lldb.SBError_Clear(self)


    def Fail(self):
        """Fail(SBError self) -> bool"""
        return _lldb.SBError_Fail(self)


    def Success(self):
        """Success(SBError self) -> bool"""
        return _lldb.SBError_Success(self)


    def GetError(self):
        """GetError(SBError self) -> uint32_t"""
        return _lldb.SBError_GetError(self)


    def GetType(self):
        """GetType(SBError self) -> lldb::ErrorType"""
        return _lldb.SBError_GetType(self)


    def SetError(self, err, type):
        """SetError(SBError self, uint32_t err, lldb::ErrorType type)"""
        return _lldb.SBError_SetError(self, err, type)


    def SetErrorToErrno(self):
        """SetErrorToErrno(SBError self)"""
        return _lldb.SBError_SetErrorToErrno(self)


    def SetErrorToGenericError(self):
        """SetErrorToGenericError(SBError self)"""
        return _lldb.SBError_SetErrorToGenericError(self)


    def SetErrorString(self, err_str):
        """SetErrorString(SBError self, str const * err_str)"""
        return _lldb.SBError_SetErrorString(self, err_str)


    def SetErrorStringWithFormat(self, format, str1=None, str2=None, str3=None):
        """
        SetErrorStringWithFormat(SBError self, str const * format, str * str1=None, str * str2=None, str * str3=None) -> int
        SetErrorStringWithFormat(SBError self, str const * format, str * str1=None, str * str2=None) -> int
        SetErrorStringWithFormat(SBError self, str const * format, str * str1=None) -> int
        SetErrorStringWithFormat(SBError self, str const * format) -> int
        """
        return _lldb.SBError_SetErrorStringWithFormat(self, format, str1, str2, str3)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBError self) -> bool"""
        return _lldb.SBError_IsValid(self)


    def GetDescription(self, description):
        """GetDescription(SBError self, SBStream description) -> bool"""
        return _lldb.SBError_GetDescription(self, description)


    __swig_getmethods__["value"] = GetError
    if _newclass: value = property(GetError, None, doc='''A read only property that returns the same result as GetError().''')

    __swig_getmethods__["fail"] = Fail
    if _newclass: fail = property(Fail, None, doc='''A read only property that returns the same result as Fail().''')

    __swig_getmethods__["success"] = Success
    if _newclass: success = property(Success, None, doc='''A read only property that returns the same result as Success().''')

    __swig_getmethods__["description"] = GetCString
    if _newclass: description = property(GetCString, None, doc='''A read only property that returns the same result as GetCString().''')

    __swig_getmethods__["type"] = GetType
    if _newclass: type = property(GetType, None, doc='''A read only property that returns the same result as GetType().''')



    def __str__(self):
        """__str__(SBError self) -> PyObject *"""
        return _lldb.SBError___str__(self)

SBError_swigregister = _lldb.SBError_swigregister
SBError_swigregister(SBError)

class SBEvent(_object):
    """
    API clients can register to receive events.

    For example, check out the following output:

    Try wait for event...
    Event description: 0x103d0bb70 Event: broadcaster = 0x1009c8410, type = 0x00000001, data = { process = 0x1009c8400 (pid = 21528), state = running}
    Event data flavor: Process::ProcessEventData
    Process state: running

    Try wait for event...
    Event description: 0x103a700a0 Event: broadcaster = 0x1009c8410, type = 0x00000001, data = { process = 0x1009c8400 (pid = 21528), state = stopped}
    Event data flavor: Process::ProcessEventData
    Process state: stopped

    Try wait for event...
    Event description: 0x103d0d4a0 Event: broadcaster = 0x1009c8410, type = 0x00000001, data = { process = 0x1009c8400 (pid = 21528), state = exited}
    Event data flavor: Process::ProcessEventData
    Process state: exited

    Try wait for event...
    timeout occurred waiting for event...

    from test/python_api/event/TestEventspy:

        def do_listen_for_and_print_event(self):
            '''Create a listener and use SBEvent API to print the events received.'''
            exe = os.path.join(os.getcwd(), 'a.out')

            # Create a target by the debugger.
            target = self.dbg.CreateTarget(exe)
            self.assertTrue(target, VALID_TARGET)

            # Now create a breakpoint on main.c by name 'c'.
            breakpoint = target.BreakpointCreateByName('c', 'a.out')

            # Now launch the process, and do not stop at the entry point.
            process = target.LaunchSimple(None, None, os.getcwd())
            self.assertTrue(process.GetState() == lldb.eStateStopped,
                            PROCESS_STOPPED)

            # Get a handle on the process's broadcaster.
            broadcaster = process.GetBroadcaster()

            # Create an empty event object.
            event = lldb.SBEvent()

            # Create a listener object and register with the broadcaster.
            listener = lldb.SBListener('my listener')
            rc = broadcaster.AddListener(listener, lldb.SBProcess.eBroadcastBitStateChanged)
            self.assertTrue(rc, 'AddListener successfully retruns')

            traceOn = self.TraceOn()
            if traceOn:
                lldbutil.print_stacktraces(process)

            # Create MyListeningThread class to wait for any kind of event.
            import threading
            class MyListeningThread(threading.Thread):
                def run(self):
                    count = 0
                    # Let's only try at most 4 times to retrieve any kind of event.
                    # After that, the thread exits.
                    while not count > 3:
                        if traceOn:
                            print('Try wait for event...')
                        if listener.WaitForEventForBroadcasterWithType(5,
                                                                       broadcaster,
                                                                       lldb.SBProcess.eBroadcastBitStateChanged,
                                                                       event):
                            if traceOn:
                                desc = lldbutil.get_description(event))
                                print('Event description:', desc)
                                print('Event data flavor:', event.GetDataFlavor())
                                print('Process state:', lldbutil.state_type_to_str(process.GetState()))
                                print()
                        else:
                            if traceOn:
                                print 'timeout occurred waiting for event...'
                        count = count + 1
                    return

            # Let's start the listening thread to retrieve the events.
            my_thread = MyListeningThread()
            my_thread.start()

            # Use Python API to continue the process.  The listening thread should be
            # able to receive the state changed events.
            process.Continue()

            # Use Python API to kill the process.  The listening thread should be
            # able to receive the state changed event, too.
            process.Kill()

            # Wait until the 'MyListeningThread' terminates.
            my_thread.join()

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBEvent, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBEvent, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBEvent self) -> SBEvent
        __init__(lldb::SBEvent self, SBEvent rhs) -> SBEvent
        __init__(self, int type, str data) -> SBEvent (make an event that contains a C string)
        """
        this = _lldb.new_SBEvent(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBEvent
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBEvent self) -> bool"""
        return _lldb.SBEvent_IsValid(self)


    def GetDataFlavor(self):
        """GetDataFlavor(SBEvent self) -> str const *"""
        return _lldb.SBEvent_GetDataFlavor(self)


    def GetType(self):
        """GetType(SBEvent self) -> uint32_t"""
        return _lldb.SBEvent_GetType(self)


    def GetBroadcaster(self):
        """GetBroadcaster(SBEvent self) -> SBBroadcaster"""
        return _lldb.SBEvent_GetBroadcaster(self)


    def GetBroadcasterClass(self):
        """GetBroadcasterClass(SBEvent self) -> str const *"""
        return _lldb.SBEvent_GetBroadcasterClass(self)


    def BroadcasterMatchesRef(self, broadcaster):
        """BroadcasterMatchesRef(SBEvent self, SBBroadcaster broadcaster) -> bool"""
        return _lldb.SBEvent_BroadcasterMatchesRef(self, broadcaster)


    def Clear(self):
        """Clear(SBEvent self)"""
        return _lldb.SBEvent_Clear(self)


    def GetCStringFromEvent(event):
        """GetCStringFromEvent(SBEvent event) -> str const *"""
        return _lldb.SBEvent_GetCStringFromEvent(event)

    GetCStringFromEvent = staticmethod(GetCStringFromEvent)

    def GetDescription(self, description):
        """GetDescription(SBEvent self, SBStream description) -> bool"""
        return _lldb.SBEvent_GetDescription(self, description)

SBEvent_swigregister = _lldb.SBEvent_swigregister
SBEvent_swigregister(SBEvent)

def SBEvent_GetCStringFromEvent(event):
    """SBEvent_GetCStringFromEvent(SBEvent event) -> char const *"""
    return _lldb.SBEvent_GetCStringFromEvent(event)

class SBExecutionContext(_object):
    """Proxy of C++ lldb::SBExecutionContext class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBExecutionContext, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBExecutionContext, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBExecutionContext self) -> SBExecutionContext
        __init__(lldb::SBExecutionContext self, SBExecutionContext rhs) -> SBExecutionContext
        __init__(lldb::SBExecutionContext self, SBTarget target) -> SBExecutionContext
        __init__(lldb::SBExecutionContext self, SBProcess process) -> SBExecutionContext
        __init__(lldb::SBExecutionContext self, SBThread thread) -> SBExecutionContext
        __init__(lldb::SBExecutionContext self, SBFrame frame) -> SBExecutionContext
        """
        this = _lldb.new_SBExecutionContext(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBExecutionContext
    __del__ = lambda self: None

    def GetTarget(self):
        """GetTarget(SBExecutionContext self) -> SBTarget"""
        return _lldb.SBExecutionContext_GetTarget(self)


    def GetProcess(self):
        """GetProcess(SBExecutionContext self) -> SBProcess"""
        return _lldb.SBExecutionContext_GetProcess(self)


    def GetThread(self):
        """GetThread(SBExecutionContext self) -> SBThread"""
        return _lldb.SBExecutionContext_GetThread(self)


    def GetFrame(self):
        """GetFrame(SBExecutionContext self) -> SBFrame"""
        return _lldb.SBExecutionContext_GetFrame(self)


    __swig_getmethods__["target"] = GetTarget
    if _newclass: target = property(GetTarget, None, doc='''A read only property that returns the same result as GetTarget().''')

    __swig_getmethods__["process"] = GetProcess
    if _newclass: process = property(GetProcess, None, doc='''A read only property that returns the same result as GetProcess().''')

    __swig_getmethods__["thread"] = GetThread
    if _newclass: thread = property(GetThread, None, doc='''A read only property that returns the same result as GetThread().''')

    __swig_getmethods__["frame"] = GetFrame
    if _newclass: frame = property(GetFrame, None, doc='''A read only property that returns the same result as GetFrame().''')

SBExecutionContext_swigregister = _lldb.SBExecutionContext_swigregister
SBExecutionContext_swigregister(SBExecutionContext)

class SBExpressionOptions(_object):
    """A container for options to use when evaluating expressions."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBExpressionOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBExpressionOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBExpressionOptions self) -> SBExpressionOptions
        __init__(lldb::SBExpressionOptions self, SBExpressionOptions rhs) -> SBExpressionOptions
        """
        this = _lldb.new_SBExpressionOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBExpressionOptions
    __del__ = lambda self: None

    def GetCoerceResultToId(self):
        """GetCoerceResultToId(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetCoerceResultToId(self)


    def SetCoerceResultToId(self, coerce=True):
        """
        SetCoerceResultToId(SBExpressionOptions self, bool coerce=True)
        SetCoerceResultToId(SBExpressionOptions self)

        Sets whether to coerce the expression result to ObjC id type after evaluation.
        """
        return _lldb.SBExpressionOptions_SetCoerceResultToId(self, coerce)


    def GetUnwindOnError(self):
        """GetUnwindOnError(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetUnwindOnError(self)


    def SetUnwindOnError(self, unwind=True):
        """
        SetUnwindOnError(SBExpressionOptions self, bool unwind=True)
        SetUnwindOnError(SBExpressionOptions self)

        Sets whether to unwind the expression stack on error.
        """
        return _lldb.SBExpressionOptions_SetUnwindOnError(self, unwind)


    def GetIgnoreBreakpoints(self):
        """GetIgnoreBreakpoints(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetIgnoreBreakpoints(self)


    def SetIgnoreBreakpoints(self, ignore=True):
        """
        SetIgnoreBreakpoints(SBExpressionOptions self, bool ignore=True)
        SetIgnoreBreakpoints(SBExpressionOptions self)
        """
        return _lldb.SBExpressionOptions_SetIgnoreBreakpoints(self, ignore)


    def GetFetchDynamicValue(self):
        """GetFetchDynamicValue(SBExpressionOptions self) -> lldb::DynamicValueType"""
        return _lldb.SBExpressionOptions_GetFetchDynamicValue(self)


    def SetFetchDynamicValue(self, *args):
        """
        SetFetchDynamicValue(SBExpressionOptions self, lldb::DynamicValueType dynamic)
        SetFetchDynamicValue(SBExpressionOptions self)

        Sets whether to cast the expression result to its dynamic type.
        """
        return _lldb.SBExpressionOptions_SetFetchDynamicValue(self, *args)


    def GetTimeoutInMicroSeconds(self):
        """GetTimeoutInMicroSeconds(SBExpressionOptions self) -> uint32_t"""
        return _lldb.SBExpressionOptions_GetTimeoutInMicroSeconds(self)


    def SetTimeoutInMicroSeconds(self, *args):
        """
        SetTimeoutInMicroSeconds(SBExpressionOptions self, uint32_t timeout)
        SetTimeoutInMicroSeconds(SBExpressionOptions self)

        Sets the timeout in microseconds to run the expression for. If try all threads is set to true and the expression doesn't complete within the specified timeout, all threads will be resumed for the same timeout to see if the expresson will finish.
        """
        return _lldb.SBExpressionOptions_SetTimeoutInMicroSeconds(self, *args)


    def GetOneThreadTimeoutInMicroSeconds(self):
        """GetOneThreadTimeoutInMicroSeconds(SBExpressionOptions self) -> uint32_t"""
        return _lldb.SBExpressionOptions_GetOneThreadTimeoutInMicroSeconds(self)


    def SetOneThreadTimeoutInMicroSeconds(self, *args):
        """
        SetOneThreadTimeoutInMicroSeconds(SBExpressionOptions self, uint32_t timeout)
        SetOneThreadTimeoutInMicroSeconds(SBExpressionOptions self)
        """
        return _lldb.SBExpressionOptions_SetOneThreadTimeoutInMicroSeconds(self, *args)


    def GetTryAllThreads(self):
        """GetTryAllThreads(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetTryAllThreads(self)


    def SetTryAllThreads(self, run_others=True):
        """
        SetTryAllThreads(SBExpressionOptions self, bool run_others=True)
        SetTryAllThreads(SBExpressionOptions self)

        Sets whether to run all threads if the expression does not complete on one thread.
        """
        return _lldb.SBExpressionOptions_SetTryAllThreads(self, run_others)


    def GetStopOthers(self):
        """GetStopOthers(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetStopOthers(self)


    def SetStopOthers(self, stop_others=True):
        """
        SetStopOthers(SBExpressionOptions self, bool stop_others=True)
        SetStopOthers(SBExpressionOptions self)
        """
        return _lldb.SBExpressionOptions_SetStopOthers(self, stop_others)


    def GetTrapExceptions(self):
        """GetTrapExceptions(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetTrapExceptions(self)


    def SetTrapExceptions(self, trap_exceptions=True):
        """
        SetTrapExceptions(SBExpressionOptions self, bool trap_exceptions=True)
        SetTrapExceptions(SBExpressionOptions self)
        """
        return _lldb.SBExpressionOptions_SetTrapExceptions(self, trap_exceptions)


    def SetLanguage(self, language):
        """
        SetLanguage(SBExpressionOptions self, lldb::LanguageType language)

        Sets the language that LLDB should assume the expression is written in
        """
        return _lldb.SBExpressionOptions_SetLanguage(self, language)


    def GetGenerateDebugInfo(self):
        """GetGenerateDebugInfo(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetGenerateDebugInfo(self)


    def SetGenerateDebugInfo(self, b=True):
        """
        SetGenerateDebugInfo(SBExpressionOptions self, bool b=True)
        SetGenerateDebugInfo(SBExpressionOptions self)

        Sets whether to generate debug information for the expression and also controls if a SBModule is generated.
        """
        return _lldb.SBExpressionOptions_SetGenerateDebugInfo(self, b)


    def GetSuppressPersistentResult(self):
        """GetSuppressPersistentResult(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetSuppressPersistentResult(self)


    def SetSuppressPersistentResult(self, b=False):
        """
        SetSuppressPersistentResult(SBExpressionOptions self, bool b=False)
        SetSuppressPersistentResult(SBExpressionOptions self)

        Sets whether to produce a persistent result that can be used in future expressions.
        """
        return _lldb.SBExpressionOptions_SetSuppressPersistentResult(self, b)


    def GetPrefix(self):
        """
        GetPrefix(SBExpressionOptions self) -> str const *

        Gets the prefix to use for this expression.
        """
        return _lldb.SBExpressionOptions_GetPrefix(self)


    def SetPrefix(self, prefix):
        """
        SetPrefix(SBExpressionOptions self, str const * prefix)

        Sets the prefix to use for this expression. This prefix gets inserted after the 'target.expr-prefix' prefix contents, but before the wrapped expression function body.
        """
        return _lldb.SBExpressionOptions_SetPrefix(self, prefix)


    def SetAutoApplyFixIts(self, b=True):
        """
        SetAutoApplyFixIts(SBExpressionOptions self, bool b=True)
        SetAutoApplyFixIts(SBExpressionOptions self)

        Sets whether to auto-apply fix-it hints to the expression being evaluated.
        """
        return _lldb.SBExpressionOptions_SetAutoApplyFixIts(self, b)


    def GetAutoApplyFixIts(self):
        """
        GetAutoApplyFixIts(SBExpressionOptions self) -> bool

        Gets whether to auto-apply fix-it hints to an expression.
        """
        return _lldb.SBExpressionOptions_GetAutoApplyFixIts(self)


    def GetTopLevel(self):
        """GetTopLevel(SBExpressionOptions self) -> bool"""
        return _lldb.SBExpressionOptions_GetTopLevel(self)


    def SetTopLevel(self, b=True):
        """
        SetTopLevel(SBExpressionOptions self, bool b=True)
        SetTopLevel(SBExpressionOptions self)
        """
        return _lldb.SBExpressionOptions_SetTopLevel(self, b)

SBExpressionOptions_swigregister = _lldb.SBExpressionOptions_swigregister
SBExpressionOptions_swigregister(SBExpressionOptions)

class SBFileSpec(_object):
    """
    Represents a file specification that divides the path into a directory and
    basename.  The string values of the paths are put into uniqued string pools
    for fast comparisons and efficient memory usage.

    For example, the following code

            lineEntry = context.GetLineEntry()
            self.expect(lineEntry.GetFileSpec().GetDirectory(), 'The line entry should have the correct directory',
                        exe=False,
                substrs = [self.mydir])
            self.expect(lineEntry.GetFileSpec().GetFilename(), 'The line entry should have the correct filename',
                        exe=False,
                substrs = ['main.c'])
            self.assertTrue(lineEntry.GetLine() == self.line,
                            'The line entry's line number should match ')

    gets the line entry from the symbol context when a thread is stopped.
    It gets the file spec corresponding to the line entry and checks that
    the filename and the directory matches what we expect.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBFileSpec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBFileSpec, name)
    __repr__ = _swig_repr

    def __eq__(self, other): return isinstance(other, SBFileSpec) and self.GetFilename() == other.GetFilename() and self.GetDirectory() == other.GetDirectory()
    def __ne__(self, other): return not self.__eq__(other)
    def __init__(self, *args):
        """
        __init__(lldb::SBFileSpec self) -> SBFileSpec
        __init__(lldb::SBFileSpec self, SBFileSpec rhs) -> SBFileSpec
        __init__(lldb::SBFileSpec self, str const * path) -> SBFileSpec
        __init__(lldb::SBFileSpec self, str const * path, bool resolve) -> SBFileSpec
        """
        this = _lldb.new_SBFileSpec(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBFileSpec
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBFileSpec self) -> bool"""
        return _lldb.SBFileSpec_IsValid(self)


    def Exists(self):
        """Exists(SBFileSpec self) -> bool"""
        return _lldb.SBFileSpec_Exists(self)


    def ResolveExecutableLocation(self):
        """ResolveExecutableLocation(SBFileSpec self) -> bool"""
        return _lldb.SBFileSpec_ResolveExecutableLocation(self)


    def GetFilename(self):
        """GetFilename(SBFileSpec self) -> str const *"""
        return _lldb.SBFileSpec_GetFilename(self)


    def GetDirectory(self):
        """GetDirectory(SBFileSpec self) -> str const *"""
        return _lldb.SBFileSpec_GetDirectory(self)


    def SetFilename(self, filename):
        """SetFilename(SBFileSpec self, str const * filename)"""
        return _lldb.SBFileSpec_SetFilename(self, filename)


    def SetDirectory(self, directory):
        """SetDirectory(SBFileSpec self, str const * directory)"""
        return _lldb.SBFileSpec_SetDirectory(self, directory)


    def GetPath(self, dst_path, dst_len):
        """GetPath(SBFileSpec self, str * dst_path, size_t dst_len) -> uint32_t"""
        return _lldb.SBFileSpec_GetPath(self, dst_path, dst_len)


    def ResolvePath(src_path, dst_path, dst_len):
        """ResolvePath(str const * src_path, str * dst_path, size_t dst_len) -> int"""
        return _lldb.SBFileSpec_ResolvePath(src_path, dst_path, dst_len)

    ResolvePath = staticmethod(ResolvePath)

    def GetDescription(self, description):
        """GetDescription(SBFileSpec self, SBStream description) -> bool"""
        return _lldb.SBFileSpec_GetDescription(self, description)


    def AppendPathComponent(self, file_or_directory):
        """AppendPathComponent(SBFileSpec self, str const * file_or_directory)"""
        return _lldb.SBFileSpec_AppendPathComponent(self, file_or_directory)


    def __get_fullpath__(self):
        spec_dir = self.GetDirectory()
        spec_file = self.GetFilename()
        if spec_dir and spec_file:
            return '%s/%s' % (spec_dir, spec_file)
        elif spec_dir:
            return spec_dir
        elif spec_file:
            return spec_file
        return None

    __swig_getmethods__["fullpath"] = __get_fullpath__
    if _newclass: fullpath = property(__get_fullpath__, None, doc='''A read only property that returns the fullpath as a python string.''')

    __swig_getmethods__["basename"] = GetFilename
    if _newclass: basename = property(GetFilename, None, doc='''A read only property that returns the path basename as a python string.''')

    __swig_getmethods__["dirname"] = GetDirectory
    if _newclass: dirname = property(GetDirectory, None, doc='''A read only property that returns the path directory name as a python string.''')

    __swig_getmethods__["exists"] = Exists
    if _newclass: exists = property(Exists, None, doc='''A read only property that returns a boolean value that indicates if the file exists.''')


    def __str__(self):
        """__str__(SBFileSpec self) -> PyObject *"""
        return _lldb.SBFileSpec___str__(self)

SBFileSpec_swigregister = _lldb.SBFileSpec_swigregister
SBFileSpec_swigregister(SBFileSpec)

def SBFileSpec_ResolvePath(src_path, dst_path, dst_len):
    """SBFileSpec_ResolvePath(char const * src_path, char * dst_path, size_t dst_len) -> int"""
    return _lldb.SBFileSpec_ResolvePath(src_path, dst_path, dst_len)

class SBFileSpecList(_object):
    """Proxy of C++ lldb::SBFileSpecList class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBFileSpecList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBFileSpecList, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBFileSpecList self) -> SBFileSpecList
        __init__(lldb::SBFileSpecList self, SBFileSpecList rhs) -> SBFileSpecList
        """
        this = _lldb.new_SBFileSpecList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBFileSpecList
    __del__ = lambda self: None

    def GetSize(self):
        """GetSize(SBFileSpecList self) -> uint32_t"""
        return _lldb.SBFileSpecList_GetSize(self)


    def GetDescription(self, description):
        """GetDescription(SBFileSpecList self, SBStream description) -> bool"""
        return _lldb.SBFileSpecList_GetDescription(self, description)


    def Append(self, sb_file):
        """Append(SBFileSpecList self, SBFileSpec sb_file)"""
        return _lldb.SBFileSpecList_Append(self, sb_file)


    def AppendIfUnique(self, sb_file):
        """AppendIfUnique(SBFileSpecList self, SBFileSpec sb_file) -> bool"""
        return _lldb.SBFileSpecList_AppendIfUnique(self, sb_file)


    def Clear(self):
        """Clear(SBFileSpecList self)"""
        return _lldb.SBFileSpecList_Clear(self)


    def FindFileIndex(self, idx, sb_file, full):
        """FindFileIndex(SBFileSpecList self, uint32_t idx, SBFileSpec sb_file, bool full) -> uint32_t"""
        return _lldb.SBFileSpecList_FindFileIndex(self, idx, sb_file, full)


    def GetFileSpecAtIndex(self, idx):
        """GetFileSpecAtIndex(SBFileSpecList self, uint32_t idx) -> SBFileSpec"""
        return _lldb.SBFileSpecList_GetFileSpecAtIndex(self, idx)

SBFileSpecList_swigregister = _lldb.SBFileSpecList_swigregister
SBFileSpecList_swigregister(SBFileSpecList)

class SBFrame(_object):
    """
    Represents one of the stack frames associated with a thread.
    SBThread contains SBFrame(s). For example (from test/lldbutil.py),

    def print_stacktrace(thread, string_buffer = False):
        '''Prints a simple stack trace of this thread.'''

        ...

        for i in range(depth):
            frame = thread.GetFrameAtIndex(i)
            function = frame.GetFunction()

            load_addr = addrs[i].GetLoadAddress(target)
            if not function:
                file_addr = addrs[i].GetFileAddress()
                start_addr = frame.GetSymbol().GetStartAddress().GetFileAddress()
                symbol_offset = file_addr - start_addr
                print >> output, '  frame #{num}: {addr:#016x} {mod}`{symbol} + {offset}'.format(
                    num=i, addr=load_addr, mod=mods[i], symbol=symbols[i], offset=symbol_offset)
            else:
                print >> output, '  frame #{num}: {addr:#016x} {mod}`{func} at {file}:{line} {args}'.format(
                    num=i, addr=load_addr, mod=mods[i],
                    func='%s [inlined]' % funcs[i] if frame.IsInlined() else funcs[i],
                    file=files[i], line=lines[i],
                    args=get_args_as_string(frame, showFuncName=False) if not frame.IsInlined() else '()')

        ...

    And,

        for frame in thread:
            print frame

    See also SBThread.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBFrame, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBFrame, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBFrame self) -> SBFrame
        __init__(lldb::SBFrame self, SBFrame rhs) -> SBFrame
        """
        this = _lldb.new_SBFrame(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBFrame
    __del__ = lambda self: None

    def IsEqual(self, rhs):
        """IsEqual(SBFrame self, SBFrame rhs) -> bool"""
        return _lldb.SBFrame_IsEqual(self, rhs)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBFrame self) -> bool"""
        return _lldb.SBFrame_IsValid(self)


    def GetFrameID(self):
        """GetFrameID(SBFrame self) -> uint32_t"""
        return _lldb.SBFrame_GetFrameID(self)


    def GetCFA(self):
        """
        GetCFA(SBFrame self) -> lldb::addr_t


        Get the Canonical Frame Address for this stack frame.
        This is the DWARF standard's definition of a CFA, a stack address
        that remains constant throughout the lifetime of the function.
        Returns an lldb::addr_t stack address, or LLDB_INVALID_ADDRESS if
        the CFA cannot be determined.
        """
        return _lldb.SBFrame_GetCFA(self)


    def GetPC(self):
        """GetPC(SBFrame self) -> lldb::addr_t"""
        return _lldb.SBFrame_GetPC(self)


    def SetPC(self, new_pc):
        """SetPC(SBFrame self, lldb::addr_t new_pc) -> bool"""
        return _lldb.SBFrame_SetPC(self, new_pc)


    def GetSP(self):
        """GetSP(SBFrame self) -> lldb::addr_t"""
        return _lldb.SBFrame_GetSP(self)


    def GetFP(self):
        """GetFP(SBFrame self) -> lldb::addr_t"""
        return _lldb.SBFrame_GetFP(self)


    def GetPCAddress(self):
        """GetPCAddress(SBFrame self) -> SBAddress"""
        return _lldb.SBFrame_GetPCAddress(self)


    def GetSymbolContext(self, resolve_scope):
        """GetSymbolContext(SBFrame self, uint32_t resolve_scope) -> SBSymbolContext"""
        return _lldb.SBFrame_GetSymbolContext(self, resolve_scope)


    def GetModule(self):
        """GetModule(SBFrame self) -> SBModule"""
        return _lldb.SBFrame_GetModule(self)


    def GetCompileUnit(self):
        """GetCompileUnit(SBFrame self) -> SBCompileUnit"""
        return _lldb.SBFrame_GetCompileUnit(self)


    def GetFunction(self):
        """GetFunction(SBFrame self) -> SBFunction"""
        return _lldb.SBFrame_GetFunction(self)


    def GetSymbol(self):
        """GetSymbol(SBFrame self) -> SBSymbol"""
        return _lldb.SBFrame_GetSymbol(self)


    def GetBlock(self):
        """
        GetBlock(SBFrame self) -> SBBlock


        Gets the deepest block that contains the frame PC.
        
        See also GetFrameBlock().
        """
        return _lldb.SBFrame_GetBlock(self)


    def GetDisplayFunctionName(self):
        """GetDisplayFunctionName(SBFrame self) -> str const *"""
        return _lldb.SBFrame_GetDisplayFunctionName(self)


    def GetFunctionName(self, *args):
        """
        GetFunctionName(SBFrame self) -> str const
        GetFunctionName(SBFrame self) -> str const *


        Get the appropriate function name for this frame. Inlined functions in
        LLDB are represented by Blocks that have inlined function information, so
        just looking at the SBFunction or SBSymbol for a frame isn't enough.
        This function will return the appropriate function, symbol or inlined
        function name for the frame.
        
        This function returns:
        - the name of the inlined function (if there is one)
        - the name of the concrete function (if there is one)
        - the name of the symbol (if there is one)
        - NULL
        
        See also IsInlined().
        """
        return _lldb.SBFrame_GetFunctionName(self, *args)


    def GuessLanguage(self):
        """
        GuessLanguage(SBFrame self) -> lldb::LanguageType


        Returns the language of the frame's SBFunction, or if there.
        is no SBFunction, guess the language from the mangled name.
        .
        """
        return _lldb.SBFrame_GuessLanguage(self)


    def IsInlined(self, *args):
        """
        IsInlined(SBFrame self) -> bool
        IsInlined(SBFrame self) -> bool


        Return true if this frame represents an inlined function.
        
        See also GetFunctionName().
        """
        return _lldb.SBFrame_IsInlined(self, *args)


    def EvaluateExpression(self, *args):
        """
        EvaluateExpression(SBFrame self, str const * expr) -> SBValue
        EvaluateExpression(SBFrame self, str const * expr, lldb::DynamicValueType use_dynamic) -> SBValue
        EvaluateExpression(SBFrame self, str const * expr, lldb::DynamicValueType use_dynamic, bool unwind_on_error) -> SBValue
        EvaluateExpression(SBFrame self, str const * expr, SBExpressionOptions options) -> SBValue


        The version that doesn't supply a 'use_dynamic' value will use the
        target's default.
        """
        return _lldb.SBFrame_EvaluateExpression(self, *args)


    def GetFrameBlock(self):
        """
        GetFrameBlock(SBFrame self) -> SBBlock


        Gets the lexical block that defines the stack frame. Another way to think
        of this is it will return the block that contains all of the variables
        for a stack frame. Inlined functions are represented as SBBlock objects
        that have inlined function information: the name of the inlined function,
        where it was called from. The block that is returned will be the first 
        block at or above the block for the PC (SBFrame::GetBlock()) that defines
        the scope of the frame. When a function contains no inlined functions,
        this will be the top most lexical block that defines the function. 
        When a function has inlined functions and the PC is currently
        in one of those inlined functions, this method will return the inlined
        block that defines this frame. If the PC isn't currently in an inlined
        function, the lexical block that defines the function is returned.
        """
        return _lldb.SBFrame_GetFrameBlock(self)


    def GetLineEntry(self):
        """GetLineEntry(SBFrame self) -> SBLineEntry"""
        return _lldb.SBFrame_GetLineEntry(self)


    def GetThread(self):
        """GetThread(SBFrame self) -> SBThread"""
        return _lldb.SBFrame_GetThread(self)


    def Disassemble(self):
        """Disassemble(SBFrame self) -> str const *"""
        return _lldb.SBFrame_Disassemble(self)


    def Clear(self):
        """Clear(SBFrame self)"""
        return _lldb.SBFrame_Clear(self)


    def GetVariables(self, *args):
        """
        GetVariables(SBFrame self, bool arguments, bool locals, bool statics, bool in_scope_only) -> SBValueList
        GetVariables(SBFrame self, bool arguments, bool locals, bool statics, bool in_scope_only, lldb::DynamicValueType use_dynamic) -> SBValueList
        GetVariables(SBFrame self, SBVariablesOptions options) -> SBValueList


        The version that doesn't supply a 'use_dynamic' value will use the
        target's default.
        """
        return _lldb.SBFrame_GetVariables(self, *args)


    def GetRegisters(self):
        """GetRegisters(SBFrame self) -> SBValueList"""
        return _lldb.SBFrame_GetRegisters(self)


    def FindVariable(self, *args):
        """
        FindVariable(SBFrame self, str const * var_name) -> SBValue
        FindVariable(SBFrame self, str const * var_name, lldb::DynamicValueType use_dynamic) -> SBValue


        The version that doesn't supply a 'use_dynamic' value will use the
        target's default.
        """
        return _lldb.SBFrame_FindVariable(self, *args)


    def FindRegister(self, name):
        """FindRegister(SBFrame self, str const * name) -> SBValue"""
        return _lldb.SBFrame_FindRegister(self, name)


    def GetValueForVariablePath(self, *args):
        """
        GetValueForVariablePath(SBFrame self, str const * var_path) -> SBValue
        GetValueForVariablePath(SBFrame self, str const * var_path, lldb::DynamicValueType use_dynamic) -> SBValue


        Get a lldb.SBValue for a variable path. 
        
        Variable paths can include access to pointer or instance members:
            rect_ptr->origin.y
            pt.x
        Pointer dereferences:
            *this->foo_ptr
            **argv
        Address of:
            &pt
            &my_array[3].x
        Array accesses and treating pointers as arrays:
            int_array[1]
            pt_ptr[22].x
        
        Unlike EvaluateExpression() which returns lldb.SBValue objects
        with constant copies of the values at the time of evaluation,
        the result of this function is a value that will continue to
        track the current value of the value as execution progresses
        in the current frame.
        """
        return _lldb.SBFrame_GetValueForVariablePath(self, *args)


    def FindValue(self, *args):
        """
        FindValue(SBFrame self, str const * name, lldb::ValueType value_type) -> SBValue
        FindValue(SBFrame self, str const * name, lldb::ValueType value_type, lldb::DynamicValueType use_dynamic) -> SBValue


        Find variables, register sets, registers, or persistent variables using
        the frame as the scope.
        
        The version that doesn't supply a 'use_dynamic' value will use the
        target's default.
        """
        return _lldb.SBFrame_FindValue(self, *args)


    def GetDescription(self, description):
        """GetDescription(SBFrame self, SBStream description) -> bool"""
        return _lldb.SBFrame_GetDescription(self, description)


    def get_all_variables(self):
        return self.GetVariables(True,True,True,True)

    def get_parent_frame(self):
        parent_idx = self.idx + 1
        if parent_idx >= 0 and parent_idx < len(self.thread.frame):
            return self.thread.frame[parent_idx]
        else:
            return SBFrame()

    def get_arguments(self):
        return self.GetVariables(True,False,False,False)

    def get_locals(self):
        return self.GetVariables(False,True,False,False)

    def get_statics(self):
        return self.GetVariables(False,False,True,False)

    def var(self, var_expr_path):
        '''Calls through to lldb.SBFrame.GetValueForVariablePath() and returns 
        a value that represents the variable expression path'''
        return self.GetValueForVariablePath(var_expr_path)

    def get_registers_access(self):
        class registers_access(object):
            '''A helper object that exposes a flattened view of registers, masking away the notion of register sets for easy scripting.'''
            def __init__(self, regs):
                self.regs = regs

            def __getitem__(self, key):
                if type(key) is str:
                    for i in range(0,len(self.regs)):
                        rs = self.regs[i]
                        for j in range (0,rs.num_children):
                            reg = rs.GetChildAtIndex(j)
                            if reg.name == key: return reg
                else:
                    return lldb.SBValue()

        return registers_access(self.registers)

    __swig_getmethods__["pc"] = GetPC
    __swig_setmethods__["pc"] = SetPC
    if _newclass: pc = property(GetPC, SetPC)

    __swig_getmethods__["addr"] = GetPCAddress
    if _newclass: addr = property(GetPCAddress, None, doc='''A read only property that returns the program counter (PC) as a section offset address (lldb.SBAddress).''')

    __swig_getmethods__["fp"] = GetFP
    if _newclass: fp = property(GetFP, None, doc='''A read only property that returns the frame pointer (FP) as an unsigned integer.''')

    __swig_getmethods__["sp"] = GetSP
    if _newclass: sp = property(GetSP, None, doc='''A read only property that returns the stack pointer (SP) as an unsigned integer.''')

    __swig_getmethods__["module"] = GetModule
    if _newclass: module = property(GetModule, None, doc='''A read only property that returns an lldb object that represents the module (lldb.SBModule) for this stack frame.''')

    __swig_getmethods__["compile_unit"] = GetCompileUnit
    if _newclass: compile_unit = property(GetCompileUnit, None, doc='''A read only property that returns an lldb object that represents the compile unit (lldb.SBCompileUnit) for this stack frame.''')

    __swig_getmethods__["function"] = GetFunction
    if _newclass: function = property(GetFunction, None, doc='''A read only property that returns an lldb object that represents the function (lldb.SBFunction) for this stack frame.''')

    __swig_getmethods__["symbol"] = GetSymbol
    if _newclass: symbol = property(GetSymbol, None, doc='''A read only property that returns an lldb object that represents the symbol (lldb.SBSymbol) for this stack frame.''')

    __swig_getmethods__["block"] = GetBlock
    if _newclass: block = property(GetBlock, None, doc='''A read only property that returns an lldb object that represents the block (lldb.SBBlock) for this stack frame.''')

    __swig_getmethods__["is_inlined"] = IsInlined
    if _newclass: is_inlined = property(IsInlined, None, doc='''A read only property that returns an boolean that indicates if the block frame is an inlined function.''')

    __swig_getmethods__["name"] = GetFunctionName
    if _newclass: name = property(GetFunctionName, None, doc='''A read only property that retuns the name for the function that this frame represents. Inlined stack frame might have a concrete function that differs from the name of the inlined function (a named lldb.SBBlock).''')

    __swig_getmethods__["line_entry"] = GetLineEntry
    if _newclass: line_entry = property(GetLineEntry, None, doc='''A read only property that returns an lldb object that represents the line table entry (lldb.SBLineEntry) for this stack frame.''')

    __swig_getmethods__["thread"] = GetThread
    if _newclass: thread = property(GetThread, None, doc='''A read only property that returns an lldb object that represents the thread (lldb.SBThread) for this stack frame.''')

    __swig_getmethods__["disassembly"] = Disassemble
    if _newclass: disassembly = property(Disassemble, None, doc='''A read only property that returns the disassembly for this stack frame as a python string.''')

    __swig_getmethods__["idx"] = GetFrameID
    if _newclass: idx = property(GetFrameID, None, doc='''A read only property that returns the zero based stack frame index.''')

    __swig_getmethods__["variables"] = get_all_variables
    if _newclass: variables = property(get_all_variables, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the variables in this stack frame.''')

    __swig_getmethods__["vars"] = get_all_variables
    if _newclass: vars = property(get_all_variables, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the variables in this stack frame.''')

    __swig_getmethods__["locals"] = get_locals
    if _newclass: locals = property(get_locals, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the local variables in this stack frame.''')

    __swig_getmethods__["args"] = get_arguments
    if _newclass: args = property(get_arguments, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the argument variables in this stack frame.''')

    __swig_getmethods__["arguments"] = get_arguments
    if _newclass: arguments = property(get_arguments, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the argument variables in this stack frame.''')

    __swig_getmethods__["statics"] = get_statics
    if _newclass: statics = property(get_statics, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the static variables in this stack frame.''')

    __swig_getmethods__["registers"] = GetRegisters
    if _newclass: registers = property(GetRegisters, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the CPU registers for this stack frame.''')

    __swig_getmethods__["regs"] = GetRegisters
    if _newclass: regs = property(GetRegisters, None, doc='''A read only property that returns a list() that contains a collection of lldb.SBValue objects that represent the CPU registers for this stack frame.''')

    __swig_getmethods__["register"] = get_registers_access
    if _newclass: register = property(get_registers_access, None, doc='''A read only property that returns an helper object providing a flattened indexable view of the CPU registers for this stack frame.''')

    __swig_getmethods__["reg"] = get_registers_access
    if _newclass: reg = property(get_registers_access, None, doc='''A read only property that returns an helper object providing a flattened indexable view of the CPU registers for this stack frame''')

    __swig_getmethods__["parent"] = get_parent_frame
    if _newclass: parent = property(get_parent_frame, None, doc='''A read only property that returns the parent (caller) frame of the current frame.''')



    def __str__(self):
        """__str__(SBFrame self) -> PyObject *"""
        return _lldb.SBFrame___str__(self)

SBFrame_swigregister = _lldb.SBFrame_swigregister
SBFrame_swigregister(SBFrame)

class SBFunction(_object):
    """
    Represents a generic function, which can be inlined or not.

    For example (from test/lldbutil.py, but slightly modified for doc purpose),

            ...

            frame = thread.GetFrameAtIndex(i)
            addr = frame.GetPCAddress()
            load_addr = addr.GetLoadAddress(target)
            function = frame.GetFunction()
            mod_name = frame.GetModule().GetFileSpec().GetFilename()

            if not function:
                # No debug info for 'function'.
                symbol = frame.GetSymbol()
                file_addr = addr.GetFileAddress()
                start_addr = symbol.GetStartAddress().GetFileAddress()
                symbol_name = symbol.GetName()
                symbol_offset = file_addr - start_addr
                print >> output, '  frame #{num}: {addr:#016x} {mod}`{symbol} + {offset}'.format(
                    num=i, addr=load_addr, mod=mod_name, symbol=symbol_name, offset=symbol_offset)
            else:
                # Debug info is available for 'function'.
                func_name = frame.GetFunctionName()
                file_name = frame.GetLineEntry().GetFileSpec().GetFilename()
                line_num = frame.GetLineEntry().GetLine()
                print >> output, '  frame #{num}: {addr:#016x} {mod}`{func} at {file}:{line} {args}'.format(
                    num=i, addr=load_addr, mod=mod_name,
                    func='%s [inlined]' % func_name] if frame.IsInlined() else func_name,
                    file=file_name, line=line_num, args=get_args_as_string(frame, showFuncName=False))

            ...

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBFunction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBFunction, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBFunction self) -> SBFunction
        __init__(lldb::SBFunction self, SBFunction rhs) -> SBFunction
        """
        this = _lldb.new_SBFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBFunction
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBFunction self) -> bool"""
        return _lldb.SBFunction_IsValid(self)


    def GetName(self):
        """GetName(SBFunction self) -> str const *"""
        return _lldb.SBFunction_GetName(self)


    def GetDisplayName(self):
        """GetDisplayName(SBFunction self) -> str const *"""
        return _lldb.SBFunction_GetDisplayName(self)


    def GetMangledName(self):
        """GetMangledName(SBFunction self) -> str const *"""
        return _lldb.SBFunction_GetMangledName(self)


    def GetInstructions(self, *args):
        """
        GetInstructions(SBFunction self, SBTarget target) -> SBInstructionList
        GetInstructions(SBFunction self, SBTarget target, str const * flavor) -> SBInstructionList
        """
        return _lldb.SBFunction_GetInstructions(self, *args)


    def GetStartAddress(self):
        """GetStartAddress(SBFunction self) -> SBAddress"""
        return _lldb.SBFunction_GetStartAddress(self)


    def GetEndAddress(self):
        """GetEndAddress(SBFunction self) -> SBAddress"""
        return _lldb.SBFunction_GetEndAddress(self)


    def GetArgumentName(self, arg_idx):
        """GetArgumentName(SBFunction self, uint32_t arg_idx) -> str const *"""
        return _lldb.SBFunction_GetArgumentName(self, arg_idx)


    def GetPrologueByteSize(self):
        """GetPrologueByteSize(SBFunction self) -> uint32_t"""
        return _lldb.SBFunction_GetPrologueByteSize(self)


    def GetType(self):
        """GetType(SBFunction self) -> SBType"""
        return _lldb.SBFunction_GetType(self)


    def GetBlock(self):
        """GetBlock(SBFunction self) -> SBBlock"""
        return _lldb.SBFunction_GetBlock(self)


    def GetLanguage(self):
        """GetLanguage(SBFunction self) -> lldb::LanguageType"""
        return _lldb.SBFunction_GetLanguage(self)


    def GetIsOptimized(self):
        """
        GetIsOptimized(SBFunction self) -> bool


        Returns true if the function was compiled with optimization.
        Optimization, in this case, is meant to indicate that the debugger
        experience may be confusing for the user -- variables optimized away,
        stepping jumping between source lines -- and the driver may want to 
        provide some guidance to the user about this.
        Returns false if unoptimized, or unknown.
        """
        return _lldb.SBFunction_GetIsOptimized(self)


    def GetDescription(self, description):
        """GetDescription(SBFunction self, SBStream description) -> bool"""
        return _lldb.SBFunction_GetDescription(self, description)


    def __eq__(self, rhs):
        """__eq__(SBFunction self, SBFunction rhs) -> bool"""
        return _lldb.SBFunction___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBFunction self, SBFunction rhs) -> bool"""
        return _lldb.SBFunction___ne__(self, rhs)


    def get_instructions_from_current_target (self):
        return self.GetInstructions (target)

    __swig_getmethods__["addr"] = GetStartAddress
    if _newclass: addr = property(GetStartAddress, None, doc='''A read only property that returns an lldb object that represents the start address (lldb.SBAddress) for this function.''')

    __swig_getmethods__["end_addr"] = GetEndAddress
    if _newclass: end_addr = property(GetEndAddress, None, doc='''A read only property that returns an lldb object that represents the end address (lldb.SBAddress) for this function.''')

    __swig_getmethods__["block"] = GetBlock
    if _newclass: block = property(GetBlock, None, doc='''A read only property that returns an lldb object that represents the top level lexical block (lldb.SBBlock) for this function.''')

    __swig_getmethods__["instructions"] = get_instructions_from_current_target
    if _newclass: instructions = property(get_instructions_from_current_target, None, doc='''A read only property that returns an lldb object that represents the instructions (lldb.SBInstructionList) for this function.''')

    __swig_getmethods__["mangled"] = GetMangledName
    if _newclass: mangled = property(GetMangledName, None, doc='''A read only property that returns the mangled (linkage) name for this function as a string.''')

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name for this function as a string.''')

    __swig_getmethods__["prologue_size"] = GetPrologueByteSize
    if _newclass: prologue_size = property(GetPrologueByteSize, None, doc='''A read only property that returns the size in bytes of the prologue instructions as an unsigned integer.''')

    __swig_getmethods__["type"] = GetType
    if _newclass: type = property(GetType, None, doc='''A read only property that returns an lldb object that represents the return type (lldb.SBType) for this function.''')


    def __str__(self):
        """__str__(SBFunction self) -> PyObject *"""
        return _lldb.SBFunction___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBFunction_swigregister = _lldb.SBFunction_swigregister
SBFunction_swigregister(SBFunction)

class SBHostOS(_object):
    """Proxy of C++ lldb::SBHostOS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBHostOS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBHostOS, name)
    __repr__ = _swig_repr

    def GetProgramFileSpec():
        """GetProgramFileSpec() -> SBFileSpec"""
        return _lldb.SBHostOS_GetProgramFileSpec()

    GetProgramFileSpec = staticmethod(GetProgramFileSpec)

    def GetLLDBPythonPath():
        """GetLLDBPythonPath() -> SBFileSpec"""
        return _lldb.SBHostOS_GetLLDBPythonPath()

    GetLLDBPythonPath = staticmethod(GetLLDBPythonPath)

    def GetLLDBPath(path_type):
        """GetLLDBPath(lldb::PathType path_type) -> SBFileSpec"""
        return _lldb.SBHostOS_GetLLDBPath(path_type)

    GetLLDBPath = staticmethod(GetLLDBPath)

    def GetUserHomeDirectory():
        """GetUserHomeDirectory() -> SBFileSpec"""
        return _lldb.SBHostOS_GetUserHomeDirectory()

    GetUserHomeDirectory = staticmethod(GetUserHomeDirectory)

    def ThreadCreated(name):
        """ThreadCreated(str const * name)"""
        return _lldb.SBHostOS_ThreadCreated(name)

    ThreadCreated = staticmethod(ThreadCreated)

    def ThreadCreate(name, arg2, thread_arg, err):
        """ThreadCreate(str const * name, lldb::thread_func_t arg2, void * thread_arg, SBError err) -> lldb::thread_t"""
        return _lldb.SBHostOS_ThreadCreate(name, arg2, thread_arg, err)

    ThreadCreate = staticmethod(ThreadCreate)

    def ThreadCancel(thread, err):
        """ThreadCancel(lldb::thread_t thread, SBError err) -> bool"""
        return _lldb.SBHostOS_ThreadCancel(thread, err)

    ThreadCancel = staticmethod(ThreadCancel)

    def ThreadDetach(thread, err):
        """ThreadDetach(lldb::thread_t thread, SBError err) -> bool"""
        return _lldb.SBHostOS_ThreadDetach(thread, err)

    ThreadDetach = staticmethod(ThreadDetach)

    def ThreadJoin(thread, result, err):
        """ThreadJoin(lldb::thread_t thread, lldb::thread_result_t * result, SBError err) -> bool"""
        return _lldb.SBHostOS_ThreadJoin(thread, result, err)

    ThreadJoin = staticmethod(ThreadJoin)

    def __init__(self):
        """__init__(lldb::SBHostOS self) -> SBHostOS"""
        this = _lldb.new_SBHostOS()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBHostOS
    __del__ = lambda self: None
SBHostOS_swigregister = _lldb.SBHostOS_swigregister
SBHostOS_swigregister(SBHostOS)

def SBHostOS_GetProgramFileSpec():
    """SBHostOS_GetProgramFileSpec() -> SBFileSpec"""
    return _lldb.SBHostOS_GetProgramFileSpec()

def SBHostOS_GetLLDBPythonPath():
    """SBHostOS_GetLLDBPythonPath() -> SBFileSpec"""
    return _lldb.SBHostOS_GetLLDBPythonPath()

def SBHostOS_GetLLDBPath(path_type):
    """SBHostOS_GetLLDBPath(lldb::PathType path_type) -> SBFileSpec"""
    return _lldb.SBHostOS_GetLLDBPath(path_type)

def SBHostOS_GetUserHomeDirectory():
    """SBHostOS_GetUserHomeDirectory() -> SBFileSpec"""
    return _lldb.SBHostOS_GetUserHomeDirectory()

def SBHostOS_ThreadCreated(name):
    """SBHostOS_ThreadCreated(char const * name)"""
    return _lldb.SBHostOS_ThreadCreated(name)

def SBHostOS_ThreadCreate(name, arg3, thread_arg, err):
    """SBHostOS_ThreadCreate(char const * name, lldb::thread_func_t arg3, void * thread_arg, SBError err) -> lldb::thread_t"""
    return _lldb.SBHostOS_ThreadCreate(name, arg3, thread_arg, err)

def SBHostOS_ThreadCancel(thread, err):
    """SBHostOS_ThreadCancel(lldb::thread_t thread, SBError err) -> bool"""
    return _lldb.SBHostOS_ThreadCancel(thread, err)

def SBHostOS_ThreadDetach(thread, err):
    """SBHostOS_ThreadDetach(lldb::thread_t thread, SBError err) -> bool"""
    return _lldb.SBHostOS_ThreadDetach(thread, err)

def SBHostOS_ThreadJoin(thread, result, err):
    """SBHostOS_ThreadJoin(lldb::thread_t thread, lldb::thread_result_t * result, SBError err) -> bool"""
    return _lldb.SBHostOS_ThreadJoin(thread, result, err)

class SBInstruction(_object):
    """Proxy of C++ lldb::SBInstruction class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBInstruction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBInstruction, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBInstruction self) -> SBInstruction
        __init__(lldb::SBInstruction self, SBInstruction rhs) -> SBInstruction
        """
        this = _lldb.new_SBInstruction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBInstruction
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBInstruction self) -> bool"""
        return _lldb.SBInstruction_IsValid(self)


    def GetAddress(self):
        """GetAddress(SBInstruction self) -> SBAddress"""
        return _lldb.SBInstruction_GetAddress(self)


    def GetMnemonic(self, target):
        """GetMnemonic(SBInstruction self, SBTarget target) -> str const *"""
        return _lldb.SBInstruction_GetMnemonic(self, target)


    def GetOperands(self, target):
        """GetOperands(SBInstruction self, SBTarget target) -> str const *"""
        return _lldb.SBInstruction_GetOperands(self, target)


    def GetComment(self, target):
        """GetComment(SBInstruction self, SBTarget target) -> str const *"""
        return _lldb.SBInstruction_GetComment(self, target)


    def GetData(self, target):
        """GetData(SBInstruction self, SBTarget target) -> SBData"""
        return _lldb.SBInstruction_GetData(self, target)


    def GetByteSize(self):
        """GetByteSize(SBInstruction self) -> size_t"""
        return _lldb.SBInstruction_GetByteSize(self)


    def DoesBranch(self):
        """DoesBranch(SBInstruction self) -> bool"""
        return _lldb.SBInstruction_DoesBranch(self)


    def HasDelaySlot(self):
        """HasDelaySlot(SBInstruction self) -> bool"""
        return _lldb.SBInstruction_HasDelaySlot(self)


    def CanSetBreakpoint(self):
        """CanSetBreakpoint(SBInstruction self) -> bool"""
        return _lldb.SBInstruction_CanSetBreakpoint(self)


    def Print(self, out):
        """Print(SBInstruction self, FILE * out)"""
        return _lldb.SBInstruction_Print(self, out)


    def GetDescription(self, description):
        """GetDescription(SBInstruction self, SBStream description) -> bool"""
        return _lldb.SBInstruction_GetDescription(self, description)


    def EmulateWithFrame(self, frame, evaluate_options):
        """EmulateWithFrame(SBInstruction self, SBFrame frame, uint32_t evaluate_options) -> bool"""
        return _lldb.SBInstruction_EmulateWithFrame(self, frame, evaluate_options)


    def DumpEmulation(self, triple):
        """DumpEmulation(SBInstruction self, str const * triple) -> bool"""
        return _lldb.SBInstruction_DumpEmulation(self, triple)


    def TestEmulation(self, output_stream, test_file):
        """TestEmulation(SBInstruction self, SBStream output_stream, str const * test_file) -> bool"""
        return _lldb.SBInstruction_TestEmulation(self, output_stream, test_file)


    def __mnemonic_property__ (self):
        return self.GetMnemonic (target)
    def __operands_property__ (self):
        return self.GetOperands (target)
    def __comment_property__ (self):
        return self.GetComment (target)
    def __file_addr_property__ (self):
        return self.GetAddress ().GetFileAddress()
    def __load_adrr_property__ (self):
        return self.GetComment (target)

    __swig_getmethods__["mnemonic"] = __mnemonic_property__
    if _newclass: mnemonic = property(__mnemonic_property__, None, doc='''A read only property that returns the mnemonic for this instruction as a string.''')

    __swig_getmethods__["operands"] = __operands_property__
    if _newclass: operands = property(__operands_property__, None, doc='''A read only property that returns the operands for this instruction as a string.''')

    __swig_getmethods__["comment"] = __comment_property__
    if _newclass: comment = property(__comment_property__, None, doc='''A read only property that returns the comment for this instruction as a string.''')

    __swig_getmethods__["addr"] = GetAddress
    if _newclass: addr = property(GetAddress, None, doc='''A read only property that returns an lldb object that represents the address (lldb.SBAddress) for this instruction.''')

    __swig_getmethods__["size"] = GetByteSize
    if _newclass: size = property(GetByteSize, None, doc='''A read only property that returns the size in bytes for this instruction as an integer.''')

    __swig_getmethods__["is_branch"] = DoesBranch
    if _newclass: is_branch = property(DoesBranch, None, doc='''A read only property that returns a boolean value that indicates if this instruction is a branch instruction.''')


    def __str__(self):
        """__str__(SBInstruction self) -> PyObject *"""
        return _lldb.SBInstruction___str__(self)

SBInstruction_swigregister = _lldb.SBInstruction_swigregister
SBInstruction_swigregister(SBInstruction)

class SBInstructionList(_object):
    """
    Represents a list of machine instructions.  SBFunction and SBSymbol have
    GetInstructions() methods which return SBInstructionList instances.

    SBInstructionList supports instruction (SBInstruction instance) iteration.
    For example (see also SBDebugger for a more complete example),

    def disassemble_instructions (insts):
        for i in insts:
            print i

    defines a function which takes an SBInstructionList instance and prints out
    the machine instructions in assembly format.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBInstructionList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBInstructionList, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetSize', 'GetInstructionAtIndex')
    def __len__(self): return self.GetSize()
    def __init__(self, *args):
        """
        __init__(lldb::SBInstructionList self) -> SBInstructionList
        __init__(lldb::SBInstructionList self, SBInstructionList rhs) -> SBInstructionList
        """
        this = _lldb.new_SBInstructionList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBInstructionList
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBInstructionList self) -> bool"""
        return _lldb.SBInstructionList_IsValid(self)


    def GetSize(self):
        """GetSize(SBInstructionList self) -> size_t"""
        return _lldb.SBInstructionList_GetSize(self)


    def GetInstructionAtIndex(self, idx):
        """GetInstructionAtIndex(SBInstructionList self, uint32_t idx) -> SBInstruction"""
        return _lldb.SBInstructionList_GetInstructionAtIndex(self, idx)


    def GetInstructionsCount(self, start, end, canSetBreakpoint):
        """GetInstructionsCount(SBInstructionList self, SBAddress start, SBAddress end, bool canSetBreakpoint) -> size_t"""
        return _lldb.SBInstructionList_GetInstructionsCount(self, start, end, canSetBreakpoint)


    def Clear(self):
        """Clear(SBInstructionList self)"""
        return _lldb.SBInstructionList_Clear(self)


    def AppendInstruction(self, inst):
        """AppendInstruction(SBInstructionList self, SBInstruction inst)"""
        return _lldb.SBInstructionList_AppendInstruction(self, inst)


    def Print(self, out):
        """Print(SBInstructionList self, FILE * out)"""
        return _lldb.SBInstructionList_Print(self, out)


    def GetDescription(self, description):
        """GetDescription(SBInstructionList self, SBStream description) -> bool"""
        return _lldb.SBInstructionList_GetDescription(self, description)


    def DumpEmulationForAllInstructions(self, triple):
        """DumpEmulationForAllInstructions(SBInstructionList self, str const * triple) -> bool"""
        return _lldb.SBInstructionList_DumpEmulationForAllInstructions(self, triple)


    def __len__(self):
        '''Access len of the instruction list.'''
        return int(self.GetSize())

    def __getitem__(self, key):
        '''Access instructions by integer index for array access or by lldb.SBAddress to find an instruction that matches a section offset address object.'''
        if type(key) is int:
    # Find an instruction by index
            if key < len(self):
                return self.GetInstructionAtIndex(key)
        elif type(key) is SBAddress:
    # Find an instruction using a lldb.SBAddress object
            lookup_file_addr = key.file_addr
            closest_inst = None
            for idx in range(self.GetSize()):
                inst = self.GetInstructionAtIndex(idx)
                inst_file_addr = inst.addr.file_addr
                if inst_file_addr == lookup_file_addr:
                    return inst
                elif inst_file_addr > lookup_file_addr:
                    return closest_inst
                else:
                    closest_inst = inst
        return None        


    def __str__(self):
        """__str__(SBInstructionList self) -> PyObject *"""
        return _lldb.SBInstructionList___str__(self)

SBInstructionList_swigregister = _lldb.SBInstructionList_swigregister
SBInstructionList_swigregister(SBInstructionList)

class SBLanguageRuntime(_object):
    """Proxy of C++ lldb::SBLanguageRuntime class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBLanguageRuntime, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBLanguageRuntime, name)
    __repr__ = _swig_repr

    def GetLanguageTypeFromString(string):
        """GetLanguageTypeFromString(str const * string) -> lldb::LanguageType"""
        return _lldb.SBLanguageRuntime_GetLanguageTypeFromString(string)

    GetLanguageTypeFromString = staticmethod(GetLanguageTypeFromString)

    def GetNameForLanguageType(language):
        """GetNameForLanguageType(lldb::LanguageType language) -> str const *"""
        return _lldb.SBLanguageRuntime_GetNameForLanguageType(language)

    GetNameForLanguageType = staticmethod(GetNameForLanguageType)

    def __init__(self):
        """__init__(lldb::SBLanguageRuntime self) -> SBLanguageRuntime"""
        this = _lldb.new_SBLanguageRuntime()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBLanguageRuntime
    __del__ = lambda self: None
SBLanguageRuntime_swigregister = _lldb.SBLanguageRuntime_swigregister
SBLanguageRuntime_swigregister(SBLanguageRuntime)

def SBLanguageRuntime_GetLanguageTypeFromString(string):
    """SBLanguageRuntime_GetLanguageTypeFromString(char const * string) -> lldb::LanguageType"""
    return _lldb.SBLanguageRuntime_GetLanguageTypeFromString(string)

def SBLanguageRuntime_GetNameForLanguageType(language):
    """SBLanguageRuntime_GetNameForLanguageType(lldb::LanguageType language) -> char const *"""
    return _lldb.SBLanguageRuntime_GetNameForLanguageType(language)

class SBLaunchInfo(_object):
    """Proxy of C++ lldb::SBLaunchInfo class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBLaunchInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBLaunchInfo, name)
    __repr__ = _swig_repr

    def __init__(self, argv):
        """__init__(lldb::SBLaunchInfo self, str const ** argv) -> SBLaunchInfo"""
        this = _lldb.new_SBLaunchInfo(argv)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def GetProcessID(self):
        """GetProcessID(SBLaunchInfo self) -> lldb::pid_t"""
        return _lldb.SBLaunchInfo_GetProcessID(self)


    def GetUserID(self):
        """GetUserID(SBLaunchInfo self) -> uint32_t"""
        return _lldb.SBLaunchInfo_GetUserID(self)


    def GetGroupID(self):
        """GetGroupID(SBLaunchInfo self) -> uint32_t"""
        return _lldb.SBLaunchInfo_GetGroupID(self)


    def UserIDIsValid(self):
        """UserIDIsValid(SBLaunchInfo self) -> bool"""
        return _lldb.SBLaunchInfo_UserIDIsValid(self)


    def GroupIDIsValid(self):
        """GroupIDIsValid(SBLaunchInfo self) -> bool"""
        return _lldb.SBLaunchInfo_GroupIDIsValid(self)


    def SetUserID(self, uid):
        """SetUserID(SBLaunchInfo self, uint32_t uid)"""
        return _lldb.SBLaunchInfo_SetUserID(self, uid)


    def SetGroupID(self, gid):
        """SetGroupID(SBLaunchInfo self, uint32_t gid)"""
        return _lldb.SBLaunchInfo_SetGroupID(self, gid)


    def GetExecutableFile(self):
        """GetExecutableFile(SBLaunchInfo self) -> SBFileSpec"""
        return _lldb.SBLaunchInfo_GetExecutableFile(self)


    def SetExecutableFile(self, exe_file, add_as_first_arg):
        """SetExecutableFile(SBLaunchInfo self, SBFileSpec exe_file, bool add_as_first_arg)"""
        return _lldb.SBLaunchInfo_SetExecutableFile(self, exe_file, add_as_first_arg)


    def GetListener(self):
        """GetListener(SBLaunchInfo self) -> SBListener"""
        return _lldb.SBLaunchInfo_GetListener(self)


    def SetListener(self, listener):
        """SetListener(SBLaunchInfo self, SBListener listener)"""
        return _lldb.SBLaunchInfo_SetListener(self, listener)


    def GetNumArguments(self):
        """GetNumArguments(SBLaunchInfo self) -> uint32_t"""
        return _lldb.SBLaunchInfo_GetNumArguments(self)


    def GetArgumentAtIndex(self, idx):
        """GetArgumentAtIndex(SBLaunchInfo self, uint32_t idx) -> str const *"""
        return _lldb.SBLaunchInfo_GetArgumentAtIndex(self, idx)


    def SetArguments(self, argv, append):
        """SetArguments(SBLaunchInfo self, str const ** argv, bool append)"""
        return _lldb.SBLaunchInfo_SetArguments(self, argv, append)


    def GetNumEnvironmentEntries(self):
        """GetNumEnvironmentEntries(SBLaunchInfo self) -> uint32_t"""
        return _lldb.SBLaunchInfo_GetNumEnvironmentEntries(self)


    def GetEnvironmentEntryAtIndex(self, idx):
        """GetEnvironmentEntryAtIndex(SBLaunchInfo self, uint32_t idx) -> str const *"""
        return _lldb.SBLaunchInfo_GetEnvironmentEntryAtIndex(self, idx)


    def SetEnvironmentEntries(self, envp, append):
        """SetEnvironmentEntries(SBLaunchInfo self, str const ** envp, bool append)"""
        return _lldb.SBLaunchInfo_SetEnvironmentEntries(self, envp, append)


    def Clear(self):
        """Clear(SBLaunchInfo self)"""
        return _lldb.SBLaunchInfo_Clear(self)


    def GetWorkingDirectory(self):
        """GetWorkingDirectory(SBLaunchInfo self) -> str const *"""
        return _lldb.SBLaunchInfo_GetWorkingDirectory(self)


    def SetWorkingDirectory(self, working_dir):
        """SetWorkingDirectory(SBLaunchInfo self, str const * working_dir)"""
        return _lldb.SBLaunchInfo_SetWorkingDirectory(self, working_dir)


    def GetLaunchFlags(self):
        """GetLaunchFlags(SBLaunchInfo self) -> uint32_t"""
        return _lldb.SBLaunchInfo_GetLaunchFlags(self)


    def SetLaunchFlags(self, flags):
        """SetLaunchFlags(SBLaunchInfo self, uint32_t flags)"""
        return _lldb.SBLaunchInfo_SetLaunchFlags(self, flags)


    def GetProcessPluginName(self):
        """GetProcessPluginName(SBLaunchInfo self) -> str const *"""
        return _lldb.SBLaunchInfo_GetProcessPluginName(self)


    def SetProcessPluginName(self, plugin_name):
        """SetProcessPluginName(SBLaunchInfo self, str const * plugin_name)"""
        return _lldb.SBLaunchInfo_SetProcessPluginName(self, plugin_name)


    def GetShell(self):
        """GetShell(SBLaunchInfo self) -> str const *"""
        return _lldb.SBLaunchInfo_GetShell(self)


    def SetShell(self, path):
        """SetShell(SBLaunchInfo self, str const * path)"""
        return _lldb.SBLaunchInfo_SetShell(self, path)


    def GetShellExpandArguments(self):
        """GetShellExpandArguments(SBLaunchInfo self) -> bool"""
        return _lldb.SBLaunchInfo_GetShellExpandArguments(self)


    def SetShellExpandArguments(self, expand):
        """SetShellExpandArguments(SBLaunchInfo self, bool expand)"""
        return _lldb.SBLaunchInfo_SetShellExpandArguments(self, expand)


    def GetResumeCount(self):
        """GetResumeCount(SBLaunchInfo self) -> uint32_t"""
        return _lldb.SBLaunchInfo_GetResumeCount(self)


    def SetResumeCount(self, c):
        """SetResumeCount(SBLaunchInfo self, uint32_t c)"""
        return _lldb.SBLaunchInfo_SetResumeCount(self, c)


    def AddCloseFileAction(self, fd):
        """AddCloseFileAction(SBLaunchInfo self, int fd) -> bool"""
        return _lldb.SBLaunchInfo_AddCloseFileAction(self, fd)


    def AddDuplicateFileAction(self, fd, dup_fd):
        """AddDuplicateFileAction(SBLaunchInfo self, int fd, int dup_fd) -> bool"""
        return _lldb.SBLaunchInfo_AddDuplicateFileAction(self, fd, dup_fd)


    def AddOpenFileAction(self, fd, path, read, write):
        """AddOpenFileAction(SBLaunchInfo self, int fd, str const * path, bool read, bool write) -> bool"""
        return _lldb.SBLaunchInfo_AddOpenFileAction(self, fd, path, read, write)


    def AddSuppressFileAction(self, fd, read, write):
        """AddSuppressFileAction(SBLaunchInfo self, int fd, bool read, bool write) -> bool"""
        return _lldb.SBLaunchInfo_AddSuppressFileAction(self, fd, read, write)


    def SetLaunchEventData(self, data):
        """SetLaunchEventData(SBLaunchInfo self, str const * data)"""
        return _lldb.SBLaunchInfo_SetLaunchEventData(self, data)


    def GetLaunchEventData(self):
        """GetLaunchEventData(SBLaunchInfo self) -> str const *"""
        return _lldb.SBLaunchInfo_GetLaunchEventData(self)


    def GetDetachOnError(self):
        """GetDetachOnError(SBLaunchInfo self) -> bool"""
        return _lldb.SBLaunchInfo_GetDetachOnError(self)


    def SetDetachOnError(self, enable):
        """SetDetachOnError(SBLaunchInfo self, bool enable)"""
        return _lldb.SBLaunchInfo_SetDetachOnError(self, enable)

    __swig_destroy__ = _lldb.delete_SBLaunchInfo
    __del__ = lambda self: None
SBLaunchInfo_swigregister = _lldb.SBLaunchInfo_swigregister
SBLaunchInfo_swigregister(SBLaunchInfo)

class SBLineEntry(_object):
    """
    Specifies an association with a contiguous range of instructions and
    a source file location. SBCompileUnit contains SBLineEntry(s). For example,

        for lineEntry in compileUnit:
            print('line entry: %s:%d' % (str(lineEntry.GetFileSpec()),
                                        lineEntry.GetLine()))
            print('start addr: %s' % str(lineEntry.GetStartAddress()))
            print('end   addr: %s' % str(lineEntry.GetEndAddress()))

    produces:

    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:20
    start addr: a.out[0x100000d98]
    end   addr: a.out[0x100000da3]
    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:21
    start addr: a.out[0x100000da3]
    end   addr: a.out[0x100000da9]
    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:22
    start addr: a.out[0x100000da9]
    end   addr: a.out[0x100000db6]
    line entry: /Volumes/data/lldb/svn/trunk/test/python_api/symbol-context/main.c:23
    start addr: a.out[0x100000db6]
    end   addr: a.out[0x100000dbc]
    ...

    See also SBCompileUnit.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBLineEntry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBLineEntry, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBLineEntry self) -> SBLineEntry
        __init__(lldb::SBLineEntry self, SBLineEntry rhs) -> SBLineEntry
        """
        this = _lldb.new_SBLineEntry(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBLineEntry
    __del__ = lambda self: None

    def GetStartAddress(self):
        """GetStartAddress(SBLineEntry self) -> SBAddress"""
        return _lldb.SBLineEntry_GetStartAddress(self)


    def GetEndAddress(self):
        """GetEndAddress(SBLineEntry self) -> SBAddress"""
        return _lldb.SBLineEntry_GetEndAddress(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBLineEntry self) -> bool"""
        return _lldb.SBLineEntry_IsValid(self)


    def GetFileSpec(self):
        """GetFileSpec(SBLineEntry self) -> SBFileSpec"""
        return _lldb.SBLineEntry_GetFileSpec(self)


    def GetLine(self):
        """GetLine(SBLineEntry self) -> uint32_t"""
        return _lldb.SBLineEntry_GetLine(self)


    def GetColumn(self):
        """GetColumn(SBLineEntry self) -> uint32_t"""
        return _lldb.SBLineEntry_GetColumn(self)


    def GetDescription(self, description):
        """GetDescription(SBLineEntry self, SBStream description) -> bool"""
        return _lldb.SBLineEntry_GetDescription(self, description)


    def SetFileSpec(self, filespec):
        """SetFileSpec(SBLineEntry self, SBFileSpec filespec)"""
        return _lldb.SBLineEntry_SetFileSpec(self, filespec)


    def SetLine(self, line):
        """SetLine(SBLineEntry self, uint32_t line)"""
        return _lldb.SBLineEntry_SetLine(self, line)


    def SetColumn(self, column):
        """SetColumn(SBLineEntry self, uint32_t column)"""
        return _lldb.SBLineEntry_SetColumn(self, column)


    def __eq__(self, rhs):
        """__eq__(SBLineEntry self, SBLineEntry rhs) -> bool"""
        return _lldb.SBLineEntry___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBLineEntry self, SBLineEntry rhs) -> bool"""
        return _lldb.SBLineEntry___ne__(self, rhs)


    __swig_getmethods__["file"] = GetFileSpec
    if _newclass: file = property(GetFileSpec, None, doc='''A read only property that returns an lldb object that represents the file (lldb.SBFileSpec) for this line entry.''')

    __swig_getmethods__["line"] = GetLine
    if _newclass: line = property(GetLine, None, doc='''A read only property that returns the 1 based line number for this line entry, a return value of zero indicates that no line information is available.''')

    __swig_getmethods__["column"] = GetColumn
    if _newclass: column = property(GetColumn, None, doc='''A read only property that returns the 1 based column number for this line entry, a return value of zero indicates that no column information is available.''')

    __swig_getmethods__["addr"] = GetStartAddress
    if _newclass: addr = property(GetStartAddress, None, doc='''A read only property that returns an lldb object that represents the start address (lldb.SBAddress) for this line entry.''')

    __swig_getmethods__["end_addr"] = GetEndAddress
    if _newclass: end_addr = property(GetEndAddress, None, doc='''A read only property that returns an lldb object that represents the end address (lldb.SBAddress) for this line entry.''')



    def __str__(self):
        """__str__(SBLineEntry self) -> PyObject *"""
        return _lldb.SBLineEntry___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBLineEntry_swigregister = _lldb.SBLineEntry_swigregister
SBLineEntry_swigregister(SBLineEntry)

class SBListener(_object):
    """
    API clients can register its own listener to debugger events.

    See aslo SBEvent for example usage of creating and adding a listener.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBListener, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBListener self) -> SBListener
        __init__(lldb::SBListener self, str const * name) -> SBListener
        __init__(lldb::SBListener self, SBListener rhs) -> SBListener
        """
        this = _lldb.new_SBListener(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBListener
    __del__ = lambda self: None

    def AddEvent(self, event):
        """AddEvent(SBListener self, SBEvent event)"""
        return _lldb.SBListener_AddEvent(self, event)


    def Clear(self):
        """Clear(SBListener self)"""
        return _lldb.SBListener_Clear(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBListener self) -> bool"""
        return _lldb.SBListener_IsValid(self)


    def StartListeningForEventClass(self, debugger, broadcaster_class, event_mask):
        """StartListeningForEventClass(SBListener self, SBDebugger debugger, str const * broadcaster_class, uint32_t event_mask) -> uint32_t"""
        return _lldb.SBListener_StartListeningForEventClass(self, debugger, broadcaster_class, event_mask)


    def StopListeningForEventClass(self, debugger, broadcaster_class, event_mask):
        """StopListeningForEventClass(SBListener self, SBDebugger debugger, str const * broadcaster_class, uint32_t event_mask) -> uint32_t"""
        return _lldb.SBListener_StopListeningForEventClass(self, debugger, broadcaster_class, event_mask)


    def StartListeningForEvents(self, broadcaster, event_mask):
        """StartListeningForEvents(SBListener self, SBBroadcaster broadcaster, uint32_t event_mask) -> uint32_t"""
        return _lldb.SBListener_StartListeningForEvents(self, broadcaster, event_mask)


    def StopListeningForEvents(self, broadcaster, event_mask):
        """StopListeningForEvents(SBListener self, SBBroadcaster broadcaster, uint32_t event_mask) -> bool"""
        return _lldb.SBListener_StopListeningForEvents(self, broadcaster, event_mask)


    def WaitForEvent(self, num_seconds, event):
        """WaitForEvent(SBListener self, uint32_t num_seconds, SBEvent event) -> bool"""
        return _lldb.SBListener_WaitForEvent(self, num_seconds, event)


    def WaitForEventForBroadcaster(self, num_seconds, broadcaster, sb_event):
        """WaitForEventForBroadcaster(SBListener self, uint32_t num_seconds, SBBroadcaster broadcaster, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_WaitForEventForBroadcaster(self, num_seconds, broadcaster, sb_event)


    def WaitForEventForBroadcasterWithType(self, num_seconds, broadcaster, event_type_mask, sb_event):
        """WaitForEventForBroadcasterWithType(SBListener self, uint32_t num_seconds, SBBroadcaster broadcaster, uint32_t event_type_mask, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_WaitForEventForBroadcasterWithType(self, num_seconds, broadcaster, event_type_mask, sb_event)


    def PeekAtNextEvent(self, sb_event):
        """PeekAtNextEvent(SBListener self, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_PeekAtNextEvent(self, sb_event)


    def PeekAtNextEventForBroadcaster(self, broadcaster, sb_event):
        """PeekAtNextEventForBroadcaster(SBListener self, SBBroadcaster broadcaster, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_PeekAtNextEventForBroadcaster(self, broadcaster, sb_event)


    def PeekAtNextEventForBroadcasterWithType(self, broadcaster, event_type_mask, sb_event):
        """PeekAtNextEventForBroadcasterWithType(SBListener self, SBBroadcaster broadcaster, uint32_t event_type_mask, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_PeekAtNextEventForBroadcasterWithType(self, broadcaster, event_type_mask, sb_event)


    def GetNextEvent(self, sb_event):
        """GetNextEvent(SBListener self, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_GetNextEvent(self, sb_event)


    def GetNextEventForBroadcaster(self, broadcaster, sb_event):
        """GetNextEventForBroadcaster(SBListener self, SBBroadcaster broadcaster, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_GetNextEventForBroadcaster(self, broadcaster, sb_event)


    def GetNextEventForBroadcasterWithType(self, broadcaster, event_type_mask, sb_event):
        """GetNextEventForBroadcasterWithType(SBListener self, SBBroadcaster broadcaster, uint32_t event_type_mask, SBEvent sb_event) -> bool"""
        return _lldb.SBListener_GetNextEventForBroadcasterWithType(self, broadcaster, event_type_mask, sb_event)


    def HandleBroadcastEvent(self, event):
        """HandleBroadcastEvent(SBListener self, SBEvent event) -> bool"""
        return _lldb.SBListener_HandleBroadcastEvent(self, event)

SBListener_swigregister = _lldb.SBListener_swigregister
SBListener_swigregister(SBListener)

class SBMemoryRegionInfo(_object):
    """API clients can get information about memory regions in processes."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBMemoryRegionInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBMemoryRegionInfo, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBMemoryRegionInfo self) -> SBMemoryRegionInfo
        __init__(lldb::SBMemoryRegionInfo self, SBMemoryRegionInfo rhs) -> SBMemoryRegionInfo
        """
        this = _lldb.new_SBMemoryRegionInfo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBMemoryRegionInfo
    __del__ = lambda self: None

    def Clear(self):
        """Clear(SBMemoryRegionInfo self)"""
        return _lldb.SBMemoryRegionInfo_Clear(self)


    def GetRegionBase(self):
        """GetRegionBase(SBMemoryRegionInfo self) -> lldb::addr_t"""
        return _lldb.SBMemoryRegionInfo_GetRegionBase(self)


    def GetRegionEnd(self):
        """GetRegionEnd(SBMemoryRegionInfo self) -> lldb::addr_t"""
        return _lldb.SBMemoryRegionInfo_GetRegionEnd(self)


    def IsReadable(self):
        """IsReadable(SBMemoryRegionInfo self) -> bool"""
        return _lldb.SBMemoryRegionInfo_IsReadable(self)


    def IsWritable(self):
        """IsWritable(SBMemoryRegionInfo self) -> bool"""
        return _lldb.SBMemoryRegionInfo_IsWritable(self)


    def IsExecutable(self):
        """IsExecutable(SBMemoryRegionInfo self) -> bool"""
        return _lldb.SBMemoryRegionInfo_IsExecutable(self)


    def IsMapped(self):
        """IsMapped(SBMemoryRegionInfo self) -> bool"""
        return _lldb.SBMemoryRegionInfo_IsMapped(self)


    def __eq__(self, rhs):
        """__eq__(SBMemoryRegionInfo self, SBMemoryRegionInfo rhs) -> bool"""
        return _lldb.SBMemoryRegionInfo___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBMemoryRegionInfo self, SBMemoryRegionInfo rhs) -> bool"""
        return _lldb.SBMemoryRegionInfo___ne__(self, rhs)


    def GetDescription(self, description):
        """GetDescription(SBMemoryRegionInfo self, SBStream description) -> bool"""
        return _lldb.SBMemoryRegionInfo_GetDescription(self, description)


    def __str__(self):
        """__str__(SBMemoryRegionInfo self) -> PyObject *"""
        return _lldb.SBMemoryRegionInfo___str__(self)

SBMemoryRegionInfo_swigregister = _lldb.SBMemoryRegionInfo_swigregister
SBMemoryRegionInfo_swigregister(SBMemoryRegionInfo)

class SBMemoryRegionInfoList(_object):
    """Proxy of C++ lldb::SBMemoryRegionInfoList class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBMemoryRegionInfoList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBMemoryRegionInfoList, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBMemoryRegionInfoList self) -> SBMemoryRegionInfoList
        __init__(lldb::SBMemoryRegionInfoList self, SBMemoryRegionInfoList rhs) -> SBMemoryRegionInfoList
        """
        this = _lldb.new_SBMemoryRegionInfoList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBMemoryRegionInfoList
    __del__ = lambda self: None

    def GetSize(self):
        """GetSize(SBMemoryRegionInfoList self) -> uint32_t"""
        return _lldb.SBMemoryRegionInfoList_GetSize(self)


    def GetMemoryRegionAtIndex(self, idx, region_info):
        """GetMemoryRegionAtIndex(SBMemoryRegionInfoList self, uint32_t idx, SBMemoryRegionInfo region_info) -> bool"""
        return _lldb.SBMemoryRegionInfoList_GetMemoryRegionAtIndex(self, idx, region_info)


    def Append(self, *args):
        """
        Append(SBMemoryRegionInfoList self, SBMemoryRegionInfo region)
        Append(SBMemoryRegionInfoList self, SBMemoryRegionInfoList region_list)
        """
        return _lldb.SBMemoryRegionInfoList_Append(self, *args)


    def Clear(self):
        """Clear(SBMemoryRegionInfoList self)"""
        return _lldb.SBMemoryRegionInfoList_Clear(self)

SBMemoryRegionInfoList_swigregister = _lldb.SBMemoryRegionInfoList_swigregister
SBMemoryRegionInfoList_swigregister(SBMemoryRegionInfoList)

class SBModule(_object):
    """
    Represents an executable image and its associated object and symbol files.

    The module is designed to be able to select a single slice of an
    executable image as it would appear on disk and during program
    execution.

    You can retrieve SBModule from SBSymbolContext, which in turn is available
    from SBFrame.

    SBModule supports symbol iteration, for example,

        for symbol in module:
            name = symbol.GetName()
            saddr = symbol.GetStartAddress()
            eaddr = symbol.GetEndAddress()

    and rich comparison methods which allow the API program to use,

        if thisModule == thatModule:
            print('This module is the same as that module')

    to test module equality.  A module also contains object file sections, namely
    SBSection.  SBModule supports section iteration through section_iter(), for
    example,

        print('Number of sections: %d' % module.GetNumSections())
        for sec in module.section_iter():
            print(sec)

    And to iterate the symbols within a SBSection, use symbol_in_section_iter(),

        # Iterates the text section and prints each symbols within each sub-section.
        for subsec in text_sec:
            print(INDENT + repr(subsec))
            for sym in exe_module.symbol_in_section_iter(subsec):
                print(INDENT2 + repr(sym))
                print(INDENT2 + 'symbol type: %s' % symbol_type_to_str(sym.GetType()))

    produces this following output:

        [0x0000000100001780-0x0000000100001d5c) a.out.__TEXT.__text
            id = {0x00000004}, name = 'mask_access(MaskAction, unsigned int)', range = [0x00000001000017c0-0x0000000100001870)
            symbol type: code
            id = {0x00000008}, name = 'thread_func(void*)', range = [0x0000000100001870-0x00000001000019b0)
            symbol type: code
            id = {0x0000000c}, name = 'main', range = [0x00000001000019b0-0x0000000100001d5c)
            symbol type: code
            id = {0x00000023}, name = 'start', address = 0x0000000100001780
            symbol type: code
        [0x0000000100001d5c-0x0000000100001da4) a.out.__TEXT.__stubs
            id = {0x00000024}, name = '__stack_chk_fail', range = [0x0000000100001d5c-0x0000000100001d62)
            symbol type: trampoline
            id = {0x00000028}, name = 'exit', range = [0x0000000100001d62-0x0000000100001d68)
            symbol type: trampoline
            id = {0x00000029}, name = 'fflush', range = [0x0000000100001d68-0x0000000100001d6e)
            symbol type: trampoline
            id = {0x0000002a}, name = 'fgets', range = [0x0000000100001d6e-0x0000000100001d74)
            symbol type: trampoline
            id = {0x0000002b}, name = 'printf', range = [0x0000000100001d74-0x0000000100001d7a)
            symbol type: trampoline
            id = {0x0000002c}, name = 'pthread_create', range = [0x0000000100001d7a-0x0000000100001d80)
            symbol type: trampoline
            id = {0x0000002d}, name = 'pthread_join', range = [0x0000000100001d80-0x0000000100001d86)
            symbol type: trampoline
            id = {0x0000002e}, name = 'pthread_mutex_lock', range = [0x0000000100001d86-0x0000000100001d8c)
            symbol type: trampoline
            id = {0x0000002f}, name = 'pthread_mutex_unlock', range = [0x0000000100001d8c-0x0000000100001d92)
            symbol type: trampoline
            id = {0x00000030}, name = 'rand', range = [0x0000000100001d92-0x0000000100001d98)
            symbol type: trampoline
            id = {0x00000031}, name = 'strtoul', range = [0x0000000100001d98-0x0000000100001d9e)
            symbol type: trampoline
            id = {0x00000032}, name = 'usleep', range = [0x0000000100001d9e-0x0000000100001da4)
            symbol type: trampoline
        [0x0000000100001da4-0x0000000100001e2c) a.out.__TEXT.__stub_helper
        [0x0000000100001e2c-0x0000000100001f10) a.out.__TEXT.__cstring
        [0x0000000100001f10-0x0000000100001f68) a.out.__TEXT.__unwind_info
        [0x0000000100001f68-0x0000000100001ff8) a.out.__TEXT.__eh_frame

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBModule, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBModule, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetNumSymbols', 'GetSymbolAtIndex')
    def __len__(self): return self.GetNumSymbols()
    def __eq__(self, other): return isinstance(other, SBModule) and self.GetFileSpec() == other.GetFileSpec() and self.GetUUIDString() == other.GetUUIDString()
    def __ne__(self, other): return not self.__eq__(other)
    def section_iter(self): return lldb_iter(self, 'GetNumSections', 'GetSectionAtIndex')
    def compile_unit_iter(self): return lldb_iter(self, 'GetNumCompileUnits', 'GetCompileUnitAtIndex')

    def symbol_in_section_iter(self, section):
        """Given a module and its contained section, returns an iterator on the
        symbols within the section."""
        for sym in self:
            if in_range(sym, section):
                yield sym

    def __init__(self, *args):
        """
        __init__(lldb::SBModule self) -> SBModule
        __init__(lldb::SBModule self, SBModule rhs) -> SBModule
        __init__(lldb::SBModule self, SBModuleSpec module_spec) -> SBModule
        __init__(lldb::SBModule self, SBProcess process, lldb::addr_t header_addr) -> SBModule
        """
        this = _lldb.new_SBModule(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBModule
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBModule self) -> bool"""
        return _lldb.SBModule_IsValid(self)


    def Clear(self):
        """Clear(SBModule self)"""
        return _lldb.SBModule_Clear(self)


    def GetFileSpec(self):
        """
        GetFileSpec(SBModule self) -> SBFileSpec


        Get const accessor for the module file specification.
        
        This function returns the file for the module on the host system
        that is running LLDB. This can differ from the path on the 
        platform since we might be doing remote debugging.
        
        @return
            A const reference to the file specification object.
        """
        return _lldb.SBModule_GetFileSpec(self)


    def GetPlatformFileSpec(self):
        """
        GetPlatformFileSpec(SBModule self) -> SBFileSpec


        Get accessor for the module platform file specification.
        
        Platform file refers to the path of the module as it is known on
        the remote system on which it is being debugged. For local 
        debugging this is always the same as Module::GetFileSpec(). But
        remote debugging might mention a file '/usr/lib/liba.dylib'
        which might be locally downloaded and cached. In this case the
        platform file could be something like:
        '/tmp/lldb/platform-cache/remote.host.computer/usr/lib/liba.dylib'
        The file could also be cached in a local developer kit directory.
        
        @return
            A const reference to the file specification object.
        """
        return _lldb.SBModule_GetPlatformFileSpec(self)


    def SetPlatformFileSpec(self, platform_file):
        """SetPlatformFileSpec(SBModule self, SBFileSpec platform_file) -> bool"""
        return _lldb.SBModule_SetPlatformFileSpec(self, platform_file)


    def GetRemoteInstallFileSpec(self):
        """GetRemoteInstallFileSpec(SBModule self) -> SBFileSpec"""
        return _lldb.SBModule_GetRemoteInstallFileSpec(self)


    def SetRemoteInstallFileSpec(self, file):
        """SetRemoteInstallFileSpec(SBModule self, SBFileSpec file) -> bool"""
        return _lldb.SBModule_SetRemoteInstallFileSpec(self, file)


    def GetUUIDString(self):
        """
        GetUUIDString(SBModule self) -> str const *

        Returns the UUID of the module as a Python string.
        """
        return _lldb.SBModule_GetUUIDString(self)


    def FindSection(self, sect_name):
        """FindSection(SBModule self, str const * sect_name) -> SBSection"""
        return _lldb.SBModule_FindSection(self, sect_name)


    def ResolveFileAddress(self, vm_addr):
        """ResolveFileAddress(SBModule self, lldb::addr_t vm_addr) -> SBAddress"""
        return _lldb.SBModule_ResolveFileAddress(self, vm_addr)


    def ResolveSymbolContextForAddress(self, addr, resolve_scope):
        """ResolveSymbolContextForAddress(SBModule self, SBAddress addr, uint32_t resolve_scope) -> SBSymbolContext"""
        return _lldb.SBModule_ResolveSymbolContextForAddress(self, addr, resolve_scope)


    def GetDescription(self, description):
        """GetDescription(SBModule self, SBStream description) -> bool"""
        return _lldb.SBModule_GetDescription(self, description)


    def GetNumCompileUnits(self):
        """GetNumCompileUnits(SBModule self) -> uint32_t"""
        return _lldb.SBModule_GetNumCompileUnits(self)


    def GetCompileUnitAtIndex(self, arg2):
        """GetCompileUnitAtIndex(SBModule self, uint32_t arg2) -> SBCompileUnit"""
        return _lldb.SBModule_GetCompileUnitAtIndex(self, arg2)


    def FindCompileUnits(self, sb_file_spec):
        """
        FindCompileUnits(SBModule self, SBFileSpec sb_file_spec) -> SBSymbolContextList


        Find compile units related to *this module and passed source
        file.
        
        @param[in] sb_file_spec
            A lldb::SBFileSpec object that contains source file
            specification.
        
        @return
            A lldb::SBSymbolContextList that gets filled in with all of
            the symbol contexts for all the matches.
        """
        return _lldb.SBModule_FindCompileUnits(self, sb_file_spec)


    def GetNumSymbols(self):
        """GetNumSymbols(SBModule self) -> size_t"""
        return _lldb.SBModule_GetNumSymbols(self)


    def GetSymbolAtIndex(self, idx):
        """GetSymbolAtIndex(SBModule self, size_t idx) -> SBSymbol"""
        return _lldb.SBModule_GetSymbolAtIndex(self, idx)


    def FindSymbol(self, *args):
        """
        FindSymbol(SBModule self, str const * name, lldb::SymbolType type) -> SBSymbol
        FindSymbol(SBModule self, str const * name) -> SBSymbol
        """
        return _lldb.SBModule_FindSymbol(self, *args)


    def FindSymbols(self, *args):
        """
        FindSymbols(SBModule self, str const * name, lldb::SymbolType type) -> SBSymbolContextList
        FindSymbols(SBModule self, str const * name) -> SBSymbolContextList
        """
        return _lldb.SBModule_FindSymbols(self, *args)


    def GetNumSections(self):
        """GetNumSections(SBModule self) -> size_t"""
        return _lldb.SBModule_GetNumSections(self)


    def GetSectionAtIndex(self, idx):
        """GetSectionAtIndex(SBModule self, size_t idx) -> SBSection"""
        return _lldb.SBModule_GetSectionAtIndex(self, idx)


    def FindFunctions(self, *args):
        """
        FindFunctions(SBModule self, str const * name, uint32_t name_type_mask) -> SBSymbolContextList
        FindFunctions(SBModule self, str const * name) -> SBSymbolContextList


        Find functions by name.
        
        @param[in] name
            The name of the function we are looking for.
        
        @param[in] name_type_mask
            A logical OR of one or more FunctionNameType enum bits that
            indicate what kind of names should be used when doing the
            lookup. Bits include fully qualified names, base names,
            C++ methods, or ObjC selectors. 
            See FunctionNameType for more details.
        
        @return
            A symbol context list that gets filled in with all of the
            matches.
        """
        return _lldb.SBModule_FindFunctions(self, *args)


    def FindFirstType(self, name):
        """FindFirstType(SBModule self, str const * name) -> SBType"""
        return _lldb.SBModule_FindFirstType(self, name)


    def FindTypes(self, type):
        """FindTypes(SBModule self, str const * type) -> SBTypeList"""
        return _lldb.SBModule_FindTypes(self, type)


    def GetTypeByID(self, uid):
        """GetTypeByID(SBModule self, lldb::user_id_t uid) -> SBType"""
        return _lldb.SBModule_GetTypeByID(self, uid)


    def GetBasicType(self, type):
        """GetBasicType(SBModule self, lldb::BasicType type) -> SBType"""
        return _lldb.SBModule_GetBasicType(self, type)


    def GetTypes(self, *args):
        """
        GetTypes(SBModule self, uint32_t type_mask) -> SBTypeList
        GetTypes(SBModule self) -> SBTypeList


        Get all types matching type_mask from debug info in this
        module.
        
        @param[in] type_mask
            A bitfield that consists of one or more bits logically OR'ed
            together from the lldb::TypeClass enumeration. This allows
            you to request only structure types, or only class, struct
            and union types. Passing in lldb::eTypeClassAny will return
            all types found in the debug information for this module.
        
        @return
            A list of types in this module that match type_mask
        """
        return _lldb.SBModule_GetTypes(self, *args)


    def FindGlobalVariables(self, target, name, max_matches):
        """
        FindGlobalVariables(SBModule self, SBTarget target, str const * name, uint32_t max_matches) -> SBValueList


        Find global and static variables by name.
        
        @param[in] target
            A valid SBTarget instance representing the debuggee.
        
        @param[in] name
            The name of the global or static variable we are looking
            for.
        
        @param[in] max_matches
            Allow the number of matches to be limited to max_matches.
        
        @return
            A list of matched variables in an SBValueList.
        """
        return _lldb.SBModule_FindGlobalVariables(self, target, name, max_matches)


    def FindFirstGlobalVariable(self, target, name):
        """
        FindFirstGlobalVariable(SBModule self, SBTarget target, str const * name) -> SBValue


        Find the first global (or static) variable by name.
        
        @param[in] target
            A valid SBTarget instance representing the debuggee.
        
        @param[in] name
            The name of the global or static variable we are looking
            for.
        
        @return
            An SBValue that gets filled in with the found variable (if any).
        """
        return _lldb.SBModule_FindFirstGlobalVariable(self, target, name)


    def GetByteOrder(self):
        """GetByteOrder(SBModule self) -> lldb::ByteOrder"""
        return _lldb.SBModule_GetByteOrder(self)


    def GetAddressByteSize(self):
        """GetAddressByteSize(SBModule self) -> uint32_t"""
        return _lldb.SBModule_GetAddressByteSize(self)


    def GetTriple(self):
        """GetTriple(SBModule self) -> str const *"""
        return _lldb.SBModule_GetTriple(self)


    def GetVersion(self):
        """GetVersion(SBModule self) -> uint32_t"""
        return _lldb.SBModule_GetVersion(self)


    def GetSymbolFileSpec(self):
        """GetSymbolFileSpec(SBModule self) -> SBFileSpec"""
        return _lldb.SBModule_GetSymbolFileSpec(self)


    def GetObjectFileHeaderAddress(self):
        """GetObjectFileHeaderAddress(SBModule self) -> SBAddress"""
        return _lldb.SBModule_GetObjectFileHeaderAddress(self)


    def __eq__(self, rhs):
        """__eq__(SBModule self, SBModule rhs) -> bool"""
        return _lldb.SBModule___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBModule self, SBModule rhs) -> bool"""
        return _lldb.SBModule___ne__(self, rhs)


    class symbols_access(object):
        re_compile_type = type(re.compile('.'))
        '''A helper object that will lazily hand out lldb.SBSymbol objects for a module when supplied an index, name, or regular expression.'''
        def __init__(self, sbmodule):
            self.sbmodule = sbmodule

        def __len__(self):
            if self.sbmodule:
                return int(self.sbmodule.GetNumSymbols())
            return 0

        def __getitem__(self, key):
            count = len(self)
            if type(key) is int:
                if key < count:
                    return self.sbmodule.GetSymbolAtIndex(key)
            elif type(key) is str:
                matches = []
                sc_list = self.sbmodule.FindSymbols(key)
                for sc in sc_list:
                    symbol = sc.symbol
                    if symbol:
                        matches.append(symbol)
                return matches
            elif isinstance(key, self.re_compile_type):
                matches = []
                for idx in range(count):
                    symbol = self.sbmodule.GetSymbolAtIndex(idx)
                    added = False
                    name = symbol.name
                    if name:
                        re_match = key.search(name)
                        if re_match:
                            matches.append(symbol)
                            added = True
                    if not added:
                        mangled = symbol.mangled
                        if mangled:
                            re_match = key.search(mangled)
                            if re_match:
                                matches.append(symbol)
                return matches
            else:
                print("error: unsupported item type: %s" % type(key))
            return None

    def get_symbols_access_object(self):
        '''An accessor function that returns a symbols_access() object which allows lazy symbol access from a lldb.SBModule object.'''
        return self.symbols_access (self)

    def get_compile_units_access_object (self):
        '''An accessor function that returns a compile_units_access() object which allows lazy compile unit access from a lldb.SBModule object.'''
        return self.compile_units_access (self)

    def get_symbols_array(self):
        '''An accessor function that returns a list() that contains all symbols in a lldb.SBModule object.'''
        symbols = []
        for idx in range(self.num_symbols):
            symbols.append(self.GetSymbolAtIndex(idx))
        return symbols

    class sections_access(object):
        re_compile_type = type(re.compile('.'))
        '''A helper object that will lazily hand out lldb.SBSection objects for a module when supplied an index, name, or regular expression.'''
        def __init__(self, sbmodule):
            self.sbmodule = sbmodule

        def __len__(self):
            if self.sbmodule:
                return int(self.sbmodule.GetNumSections())
            return 0

        def __getitem__(self, key):
            count = len(self)
            if type(key) is int:
                if key < count:
                    return self.sbmodule.GetSectionAtIndex(key)
            elif type(key) is str:
                for idx in range(count):
                    section = self.sbmodule.GetSectionAtIndex(idx)
                    if section.name == key:
                        return section
            elif isinstance(key, self.re_compile_type):
                matches = []
                for idx in range(count):
                    section = self.sbmodule.GetSectionAtIndex(idx)
                    name = section.name
                    if name:
                        re_match = key.search(name)
                        if re_match:
                            matches.append(section)
                return matches
            else:
                print("error: unsupported item type: %s" % type(key))
            return None

    class compile_units_access(object):
        re_compile_type = type(re.compile('.'))
        '''A helper object that will lazily hand out lldb.SBCompileUnit objects for a module when supplied an index, full or partial path, or regular expression.'''
        def __init__(self, sbmodule):
            self.sbmodule = sbmodule

        def __len__(self):
            if self.sbmodule:
                return int(self.sbmodule.GetNumCompileUnits())
            return 0

        def __getitem__(self, key):
            count = len(self)
            if type(key) is int:
                if key < count:
                    return self.sbmodule.GetCompileUnitAtIndex(key)
            elif type(key) is str:
                is_full_path = key[0] == '/'
                for idx in range(count):
                    comp_unit = self.sbmodule.GetCompileUnitAtIndex(idx)
                    if is_full_path:
                        if comp_unit.file.fullpath == key:
                            return comp_unit
                    else:
                        if comp_unit.file.basename == key:
                            return comp_unit
            elif isinstance(key, self.re_compile_type):
                matches = []
                for idx in range(count):
                    comp_unit = self.sbmodule.GetCompileUnitAtIndex(idx)
                    fullpath = comp_unit.file.fullpath
                    if fullpath:
                        re_match = key.search(fullpath)
                        if re_match:
                            matches.append(comp_unit)
                return matches
            else:
                print("error: unsupported item type: %s" % type(key))
            return None

    def get_sections_access_object(self):
        '''An accessor function that returns a sections_access() object which allows lazy section array access.'''
        return self.sections_access (self)

    def get_sections_array(self):
        '''An accessor function that returns an array object that contains all sections in this module object.'''
        if not hasattr(self, 'sections_array'):
            self.sections_array = []
            for idx in range(self.num_sections):
                self.sections_array.append(self.GetSectionAtIndex(idx))
        return self.sections_array

    def get_compile_units_array(self):
        '''An accessor function that returns an array object that contains all compile_units in this module object.'''
        if not hasattr(self, 'compile_units_array'):
            self.compile_units_array = []
            for idx in range(self.GetNumCompileUnits()):
                self.compile_units_array.append(self.GetCompileUnitAtIndex(idx))
        return self.compile_units_array

    __swig_getmethods__["symbols"] = get_symbols_array
    if _newclass: symbols = property(get_symbols_array, None, doc='''A read only property that returns a list() of lldb.SBSymbol objects contained in this module.''')

    __swig_getmethods__["symbol"] = get_symbols_access_object
    if _newclass: symbol = property(get_symbols_access_object, None, doc='''A read only property that can be used to access symbols by index ("symbol = module.symbol[0]"), name ("symbols = module.symbol['main']"), or using a regular expression ("symbols = module.symbol[re.compile(...)]"). The return value is a single lldb.SBSymbol object for array access, and a list() of lldb.SBSymbol objects for name and regular expression access''')

    __swig_getmethods__["sections"] = get_sections_array
    if _newclass: sections = property(get_sections_array, None, doc='''A read only property that returns a list() of lldb.SBSection objects contained in this module.''')

    __swig_getmethods__["compile_units"] = get_compile_units_array
    if _newclass: compile_units = property(get_compile_units_array, None, doc='''A read only property that returns a list() of lldb.SBCompileUnit objects contained in this module.''')

    __swig_getmethods__["section"] = get_sections_access_object
    if _newclass: section = property(get_sections_access_object, None, doc='''A read only property that can be used to access symbols by index ("section = module.section[0]"), name ("sections = module.section[\'main\']"), or using a regular expression ("sections = module.section[re.compile(...)]"). The return value is a single lldb.SBSection object for array access, and a list() of lldb.SBSection objects for name and regular expression access''')

    __swig_getmethods__["compile_unit"] = get_compile_units_access_object
    if _newclass: section = property(get_sections_access_object, None, doc='''A read only property that can be used to access compile units by index ("compile_unit = module.compile_unit[0]"), name ("compile_unit = module.compile_unit[\'main.cpp\']"), or using a regular expression ("compile_unit = module.compile_unit[re.compile(...)]"). The return value is a single lldb.SBCompileUnit object for array access or by full or partial path, and a list() of lldb.SBCompileUnit objects regular expressions.''')

    def get_uuid(self):
        return uuid.UUID (self.GetUUIDString())

    __swig_getmethods__["uuid"] = get_uuid
    if _newclass: uuid = property(get_uuid, None, doc='''A read only property that returns a standard python uuid.UUID object that represents the UUID of this module.''')

    __swig_getmethods__["file"] = GetFileSpec
    if _newclass: file = property(GetFileSpec, None, doc='''A read only property that returns an lldb object that represents the file (lldb.SBFileSpec) for this object file for this module as it is represented where it is being debugged.''')

    __swig_getmethods__["platform_file"] = GetPlatformFileSpec
    if _newclass: platform_file = property(GetPlatformFileSpec, None, doc='''A read only property that returns an lldb object that represents the file (lldb.SBFileSpec) for this object file for this module as it is represented on the current host system.''')

    __swig_getmethods__["byte_order"] = GetByteOrder
    if _newclass: byte_order = property(GetByteOrder, None, doc='''A read only property that returns an lldb enumeration value (lldb.eByteOrderLittle, lldb.eByteOrderBig, lldb.eByteOrderInvalid) that represents the byte order for this module.''')

    __swig_getmethods__["addr_size"] = GetAddressByteSize
    if _newclass: addr_size = property(GetAddressByteSize, None, doc='''A read only property that returns the size in bytes of an address for this module.''')

    __swig_getmethods__["triple"] = GetTriple
    if _newclass: triple = property(GetTriple, None, doc='''A read only property that returns the target triple (arch-vendor-os) for this module.''')

    __swig_getmethods__["num_symbols"] = GetNumSymbols
    if _newclass: num_symbols = property(GetNumSymbols, None, doc='''A read only property that returns number of symbols in the module symbol table as an integer.''')

    __swig_getmethods__["num_sections"] = GetNumSections
    if _newclass: num_sections = property(GetNumSections, None, doc='''A read only property that returns number of sections in the module as an integer.''')



    def __str__(self):
        """__str__(SBModule self) -> PyObject *"""
        return _lldb.SBModule___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBModule_swigregister = _lldb.SBModule_swigregister
SBModule_swigregister(SBModule)

class SBModuleSpec(_object):
    """Proxy of C++ lldb::SBModuleSpec class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBModuleSpec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBModuleSpec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBModuleSpec self) -> SBModuleSpec
        __init__(lldb::SBModuleSpec self, SBModuleSpec rhs) -> SBModuleSpec
        """
        this = _lldb.new_SBModuleSpec(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBModuleSpec
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBModuleSpec self) -> bool"""
        return _lldb.SBModuleSpec_IsValid(self)


    def Clear(self):
        """Clear(SBModuleSpec self)"""
        return _lldb.SBModuleSpec_Clear(self)


    def GetFileSpec(self):
        """GetFileSpec(SBModuleSpec self) -> SBFileSpec"""
        return _lldb.SBModuleSpec_GetFileSpec(self)


    def SetFileSpec(self, fspec):
        """SetFileSpec(SBModuleSpec self, SBFileSpec fspec)"""
        return _lldb.SBModuleSpec_SetFileSpec(self, fspec)


    def GetPlatformFileSpec(self):
        """GetPlatformFileSpec(SBModuleSpec self) -> SBFileSpec"""
        return _lldb.SBModuleSpec_GetPlatformFileSpec(self)


    def SetPlatformFileSpec(self, fspec):
        """SetPlatformFileSpec(SBModuleSpec self, SBFileSpec fspec)"""
        return _lldb.SBModuleSpec_SetPlatformFileSpec(self, fspec)


    def GetSymbolFileSpec(self):
        """GetSymbolFileSpec(SBModuleSpec self) -> SBFileSpec"""
        return _lldb.SBModuleSpec_GetSymbolFileSpec(self)


    def SetSymbolFileSpec(self, fspec):
        """SetSymbolFileSpec(SBModuleSpec self, SBFileSpec fspec)"""
        return _lldb.SBModuleSpec_SetSymbolFileSpec(self, fspec)


    def GetObjectName(self):
        """GetObjectName(SBModuleSpec self) -> str const *"""
        return _lldb.SBModuleSpec_GetObjectName(self)


    def SetObjectName(self, name):
        """SetObjectName(SBModuleSpec self, str const * name)"""
        return _lldb.SBModuleSpec_SetObjectName(self, name)


    def GetTriple(self):
        """GetTriple(SBModuleSpec self) -> str const *"""
        return _lldb.SBModuleSpec_GetTriple(self)


    def SetTriple(self, triple):
        """SetTriple(SBModuleSpec self, str const * triple)"""
        return _lldb.SBModuleSpec_SetTriple(self, triple)


    def GetUUIDBytes(self):
        """GetUUIDBytes(SBModuleSpec self) -> uint8_t const *"""
        return _lldb.SBModuleSpec_GetUUIDBytes(self)


    def GetUUIDLength(self):
        """GetUUIDLength(SBModuleSpec self) -> size_t"""
        return _lldb.SBModuleSpec_GetUUIDLength(self)


    def SetUUIDBytes(self, uuid, uuid_len):
        """SetUUIDBytes(SBModuleSpec self, uint8_t const * uuid, size_t uuid_len) -> bool"""
        return _lldb.SBModuleSpec_SetUUIDBytes(self, uuid, uuid_len)


    def GetDescription(self, description):
        """GetDescription(SBModuleSpec self, SBStream description) -> bool"""
        return _lldb.SBModuleSpec_GetDescription(self, description)


    def __str__(self):
        """__str__(SBModuleSpec self) -> PyObject *"""
        return _lldb.SBModuleSpec___str__(self)

SBModuleSpec_swigregister = _lldb.SBModuleSpec_swigregister
SBModuleSpec_swigregister(SBModuleSpec)

class SBModuleSpecList(_object):
    """Proxy of C++ lldb::SBModuleSpecList class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBModuleSpecList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBModuleSpecList, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBModuleSpecList self) -> SBModuleSpecList
        __init__(lldb::SBModuleSpecList self, SBModuleSpecList rhs) -> SBModuleSpecList
        """
        this = _lldb.new_SBModuleSpecList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBModuleSpecList
    __del__ = lambda self: None

    def GetModuleSpecifications(path):
        """GetModuleSpecifications(str const * path) -> SBModuleSpecList"""
        return _lldb.SBModuleSpecList_GetModuleSpecifications(path)

    GetModuleSpecifications = staticmethod(GetModuleSpecifications)

    def Append(self, *args):
        """
        Append(SBModuleSpecList self, SBModuleSpec spec)
        Append(SBModuleSpecList self, SBModuleSpecList spec_list)
        """
        return _lldb.SBModuleSpecList_Append(self, *args)


    def FindFirstMatchingSpec(self, match_spec):
        """FindFirstMatchingSpec(SBModuleSpecList self, SBModuleSpec match_spec) -> SBModuleSpec"""
        return _lldb.SBModuleSpecList_FindFirstMatchingSpec(self, match_spec)


    def FindMatchingSpecs(self, match_spec):
        """FindMatchingSpecs(SBModuleSpecList self, SBModuleSpec match_spec) -> SBModuleSpecList"""
        return _lldb.SBModuleSpecList_FindMatchingSpecs(self, match_spec)


    def GetSize(self):
        """GetSize(SBModuleSpecList self) -> size_t"""
        return _lldb.SBModuleSpecList_GetSize(self)


    def GetSpecAtIndex(self, i):
        """GetSpecAtIndex(SBModuleSpecList self, size_t i) -> SBModuleSpec"""
        return _lldb.SBModuleSpecList_GetSpecAtIndex(self, i)


    def GetDescription(self, description):
        """GetDescription(SBModuleSpecList self, SBStream description) -> bool"""
        return _lldb.SBModuleSpecList_GetDescription(self, description)


    def __str__(self):
        """__str__(SBModuleSpecList self) -> PyObject *"""
        return _lldb.SBModuleSpecList___str__(self)

SBModuleSpecList_swigregister = _lldb.SBModuleSpecList_swigregister
SBModuleSpecList_swigregister(SBModuleSpecList)

def SBModuleSpecList_GetModuleSpecifications(path):
    """SBModuleSpecList_GetModuleSpecifications(char const * path) -> SBModuleSpecList"""
    return _lldb.SBModuleSpecList_GetModuleSpecifications(path)

class SBPlatformConnectOptions(_object):
    """Proxy of C++ lldb::SBPlatformConnectOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBPlatformConnectOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBPlatformConnectOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBPlatformConnectOptions self, str const * url) -> SBPlatformConnectOptions
        __init__(lldb::SBPlatformConnectOptions self, SBPlatformConnectOptions rhs) -> SBPlatformConnectOptions
        """
        this = _lldb.new_SBPlatformConnectOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBPlatformConnectOptions
    __del__ = lambda self: None

    def GetURL(self):
        """GetURL(SBPlatformConnectOptions self) -> str const *"""
        return _lldb.SBPlatformConnectOptions_GetURL(self)


    def SetURL(self, url):
        """SetURL(SBPlatformConnectOptions self, str const * url)"""
        return _lldb.SBPlatformConnectOptions_SetURL(self, url)


    def GetRsyncEnabled(self):
        """GetRsyncEnabled(SBPlatformConnectOptions self) -> bool"""
        return _lldb.SBPlatformConnectOptions_GetRsyncEnabled(self)


    def EnableRsync(self, options, remote_path_prefix, omit_remote_hostname):
        """EnableRsync(SBPlatformConnectOptions self, str const * options, str const * remote_path_prefix, bool omit_remote_hostname)"""
        return _lldb.SBPlatformConnectOptions_EnableRsync(self, options, remote_path_prefix, omit_remote_hostname)


    def DisableRsync(self):
        """DisableRsync(SBPlatformConnectOptions self)"""
        return _lldb.SBPlatformConnectOptions_DisableRsync(self)


    def GetLocalCacheDirectory(self):
        """GetLocalCacheDirectory(SBPlatformConnectOptions self) -> str const *"""
        return _lldb.SBPlatformConnectOptions_GetLocalCacheDirectory(self)


    def SetLocalCacheDirectory(self, path):
        """SetLocalCacheDirectory(SBPlatformConnectOptions self, str const * path)"""
        return _lldb.SBPlatformConnectOptions_SetLocalCacheDirectory(self, path)

SBPlatformConnectOptions_swigregister = _lldb.SBPlatformConnectOptions_swigregister
SBPlatformConnectOptions_swigregister(SBPlatformConnectOptions)

class SBPlatformShellCommand(_object):
    """Proxy of C++ lldb::SBPlatformShellCommand class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBPlatformShellCommand, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBPlatformShellCommand, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBPlatformShellCommand self, str const * shell_command) -> SBPlatformShellCommand
        __init__(lldb::SBPlatformShellCommand self, SBPlatformShellCommand rhs) -> SBPlatformShellCommand
        """
        this = _lldb.new_SBPlatformShellCommand(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBPlatformShellCommand
    __del__ = lambda self: None

    def Clear(self):
        """Clear(SBPlatformShellCommand self)"""
        return _lldb.SBPlatformShellCommand_Clear(self)


    def GetCommand(self):
        """GetCommand(SBPlatformShellCommand self) -> str const *"""
        return _lldb.SBPlatformShellCommand_GetCommand(self)


    def SetCommand(self, shell_command):
        """SetCommand(SBPlatformShellCommand self, str const * shell_command)"""
        return _lldb.SBPlatformShellCommand_SetCommand(self, shell_command)


    def GetWorkingDirectory(self):
        """GetWorkingDirectory(SBPlatformShellCommand self) -> str const *"""
        return _lldb.SBPlatformShellCommand_GetWorkingDirectory(self)


    def SetWorkingDirectory(self, path):
        """SetWorkingDirectory(SBPlatformShellCommand self, str const * path)"""
        return _lldb.SBPlatformShellCommand_SetWorkingDirectory(self, path)


    def GetTimeoutSeconds(self):
        """GetTimeoutSeconds(SBPlatformShellCommand self) -> uint32_t"""
        return _lldb.SBPlatformShellCommand_GetTimeoutSeconds(self)


    def SetTimeoutSeconds(self, sec):
        """SetTimeoutSeconds(SBPlatformShellCommand self, uint32_t sec)"""
        return _lldb.SBPlatformShellCommand_SetTimeoutSeconds(self, sec)


    def GetSignal(self):
        """GetSignal(SBPlatformShellCommand self) -> int"""
        return _lldb.SBPlatformShellCommand_GetSignal(self)


    def GetStatus(self):
        """GetStatus(SBPlatformShellCommand self) -> int"""
        return _lldb.SBPlatformShellCommand_GetStatus(self)


    def GetOutput(self):
        """GetOutput(SBPlatformShellCommand self) -> str const *"""
        return _lldb.SBPlatformShellCommand_GetOutput(self)

SBPlatformShellCommand_swigregister = _lldb.SBPlatformShellCommand_swigregister
SBPlatformShellCommand_swigregister(SBPlatformShellCommand)

class SBPlatform(_object):
    """
    A class that represents a platform that can represent the current host or a remote host debug platform.

    The SBPlatform class represents the current host, or a remote host.
    It can be connected to a remote platform in order to provide ways
    to remotely launch and attach to processes, upload/download files,
    create directories, run remote shell commands, find locally cached
    versions of files from the remote system, and much more.

    SBPlatform objects can be created and then used to connect to a remote
    platform which allows the SBPlatform to be used to get a list of the
    current processes on the remote host, attach to one of those processes,
    install programs on the remote system, attach and launch processes,
    and much more.

    Every SBTarget has a corresponding SBPlatform. The platform can be
    specified upon target creation, or the currently selected platform
    will attempt to be used when creating the target automatically as long
    as the currently selected platform matches the target architecture
    and executable type. If the architecture or executable type do not match,
    a suitable platform will be found automatically.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBPlatform, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBPlatform, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBPlatform self) -> SBPlatform
        __init__(lldb::SBPlatform self, str const * arg2) -> SBPlatform
        """
        this = _lldb.new_SBPlatform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBPlatform
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBPlatform self) -> bool"""
        return _lldb.SBPlatform_IsValid(self)


    def Clear(self):
        """Clear(SBPlatform self)"""
        return _lldb.SBPlatform_Clear(self)


    def GetWorkingDirectory(self):
        """GetWorkingDirectory(SBPlatform self) -> str const *"""
        return _lldb.SBPlatform_GetWorkingDirectory(self)


    def SetWorkingDirectory(self, arg2):
        """SetWorkingDirectory(SBPlatform self, str const * arg2) -> bool"""
        return _lldb.SBPlatform_SetWorkingDirectory(self, arg2)


    def GetName(self):
        """GetName(SBPlatform self) -> str const *"""
        return _lldb.SBPlatform_GetName(self)


    def ConnectRemote(self, connect_options):
        """ConnectRemote(SBPlatform self, SBPlatformConnectOptions connect_options) -> SBError"""
        return _lldb.SBPlatform_ConnectRemote(self, connect_options)


    def DisconnectRemote(self):
        """DisconnectRemote(SBPlatform self)"""
        return _lldb.SBPlatform_DisconnectRemote(self)


    def IsConnected(self):
        """IsConnected(SBPlatform self) -> bool"""
        return _lldb.SBPlatform_IsConnected(self)


    def GetTriple(self):
        """GetTriple(SBPlatform self) -> str const *"""
        return _lldb.SBPlatform_GetTriple(self)


    def GetHostname(self):
        """GetHostname(SBPlatform self) -> str const *"""
        return _lldb.SBPlatform_GetHostname(self)


    def GetOSBuild(self):
        """GetOSBuild(SBPlatform self) -> str const *"""
        return _lldb.SBPlatform_GetOSBuild(self)


    def GetOSDescription(self):
        """GetOSDescription(SBPlatform self) -> str const *"""
        return _lldb.SBPlatform_GetOSDescription(self)


    def GetOSMajorVersion(self):
        """GetOSMajorVersion(SBPlatform self) -> uint32_t"""
        return _lldb.SBPlatform_GetOSMajorVersion(self)


    def GetOSMinorVersion(self):
        """GetOSMinorVersion(SBPlatform self) -> uint32_t"""
        return _lldb.SBPlatform_GetOSMinorVersion(self)


    def GetOSUpdateVersion(self):
        """GetOSUpdateVersion(SBPlatform self) -> uint32_t"""
        return _lldb.SBPlatform_GetOSUpdateVersion(self)


    def Get(self, src, dst):
        """Get(SBPlatform self, SBFileSpec src, SBFileSpec dst) -> SBError"""
        return _lldb.SBPlatform_Get(self, src, dst)


    def Put(self, src, dst):
        """Put(SBPlatform self, SBFileSpec src, SBFileSpec dst) -> SBError"""
        return _lldb.SBPlatform_Put(self, src, dst)


    def Install(self, src, dst):
        """Install(SBPlatform self, SBFileSpec src, SBFileSpec dst) -> SBError"""
        return _lldb.SBPlatform_Install(self, src, dst)


    def Run(self, shell_command):
        """Run(SBPlatform self, SBPlatformShellCommand shell_command) -> SBError"""
        return _lldb.SBPlatform_Run(self, shell_command)


    def Launch(self, launch_info):
        """Launch(SBPlatform self, SBLaunchInfo launch_info) -> SBError"""
        return _lldb.SBPlatform_Launch(self, launch_info)


    def Kill(self, pid):
        """Kill(SBPlatform self, lldb::pid_t const pid) -> SBError"""
        return _lldb.SBPlatform_Kill(self, pid)


    def MakeDirectory(self, *args):
        """
        MakeDirectory(SBPlatform self, str const * path, uint32_t file_permissions) -> SBError
        MakeDirectory(SBPlatform self, str const * path) -> SBError
        """
        return _lldb.SBPlatform_MakeDirectory(self, *args)


    def GetFilePermissions(self, path):
        """GetFilePermissions(SBPlatform self, str const * path) -> uint32_t"""
        return _lldb.SBPlatform_GetFilePermissions(self, path)


    def SetFilePermissions(self, path, file_permissions):
        """SetFilePermissions(SBPlatform self, str const * path, uint32_t file_permissions) -> SBError"""
        return _lldb.SBPlatform_SetFilePermissions(self, path, file_permissions)


    def GetUnixSignals(self):
        """GetUnixSignals(SBPlatform self) -> SBUnixSignals"""
        return _lldb.SBPlatform_GetUnixSignals(self)

SBPlatform_swigregister = _lldb.SBPlatform_swigregister
SBPlatform_swigregister(SBPlatform)

class SBProcess(_object):
    """
    Represents the process associated with the target program.

    SBProcess supports thread iteration. For example (from test/lldbutil.py),

    # ==================================================
    # Utility functions related to Threads and Processes
    # ==================================================

    def get_stopped_threads(process, reason):
        '''Returns the thread(s) with the specified stop reason in a list.

        The list can be empty if no such thread exists.
        '''
        threads = []
        for t in process:
            if t.GetStopReason() == reason:
                threads.append(t)
        return threads

    ...

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBProcess, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBProcess, name)
    __repr__ = _swig_repr
    eBroadcastBitStateChanged = _lldb.SBProcess_eBroadcastBitStateChanged
    eBroadcastBitInterrupt = _lldb.SBProcess_eBroadcastBitInterrupt
    eBroadcastBitSTDOUT = _lldb.SBProcess_eBroadcastBitSTDOUT
    eBroadcastBitSTDERR = _lldb.SBProcess_eBroadcastBitSTDERR
    eBroadcastBitProfileData = _lldb.SBProcess_eBroadcastBitProfileData
    eBroadcastBitStructuredData = _lldb.SBProcess_eBroadcastBitStructuredData

    def __iter__(self): return lldb_iter(self, 'GetNumThreads', 'GetThreadAtIndex')
    def __len__(self): return self.GetNumThreads()
    def __init__(self, *args):
        """
        __init__(lldb::SBProcess self) -> SBProcess
        __init__(lldb::SBProcess self, SBProcess rhs) -> SBProcess
        """
        this = _lldb.new_SBProcess(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBProcess
    __del__ = lambda self: None

    def GetBroadcasterClassName():
        """GetBroadcasterClassName() -> str const *"""
        return _lldb.SBProcess_GetBroadcasterClassName()

    GetBroadcasterClassName = staticmethod(GetBroadcasterClassName)

    def GetPluginName(self):
        """GetPluginName(SBProcess self) -> str const *"""
        return _lldb.SBProcess_GetPluginName(self)


    def GetShortPluginName(self):
        """GetShortPluginName(SBProcess self) -> str const *"""
        return _lldb.SBProcess_GetShortPluginName(self)


    def Clear(self):
        """Clear(SBProcess self)"""
        return _lldb.SBProcess_Clear(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBProcess self) -> bool"""
        return _lldb.SBProcess_IsValid(self)


    def GetTarget(self):
        """GetTarget(SBProcess self) -> SBTarget"""
        return _lldb.SBProcess_GetTarget(self)


    def GetByteOrder(self):
        """GetByteOrder(SBProcess self) -> lldb::ByteOrder"""
        return _lldb.SBProcess_GetByteOrder(self)


    def PutSTDIN(self, src):
        """

        Writes data into the current process's stdin. API client specifies a Python
        string as the only argument.
        """
        return _lldb.SBProcess_PutSTDIN(self, src)


    def GetSTDOUT(self, dst):
        """

        Reads data from the current process's stdout stream. API client specifies
        the size of the buffer to read data into. It returns the byte buffer in a
        Python string.
        """
        return _lldb.SBProcess_GetSTDOUT(self, dst)


    def GetSTDERR(self, dst):
        """

        Reads data from the current process's stderr stream. API client specifies
        the size of the buffer to read data into. It returns the byte buffer in a
        Python string.
        """
        return _lldb.SBProcess_GetSTDERR(self, dst)


    def GetAsyncProfileData(self, dst):
        """GetAsyncProfileData(SBProcess self, str * dst) -> size_t"""
        return _lldb.SBProcess_GetAsyncProfileData(self, dst)


    def ReportEventState(self, event, out):
        """ReportEventState(SBProcess self, SBEvent event, FILE * out)"""
        return _lldb.SBProcess_ReportEventState(self, event, out)


    def AppendEventStateReport(self, event, result):
        """AppendEventStateReport(SBProcess self, SBEvent event, SBCommandReturnObject result)"""
        return _lldb.SBProcess_AppendEventStateReport(self, event, result)


    def RemoteAttachToProcessWithID(self, pid, error):
        """
        RemoteAttachToProcessWithID(SBProcess self, lldb::pid_t pid, SBError error) -> bool


        Remote connection related functions. These will fail if the
        process is not in eStateConnected. They are intended for use
        when connecting to an externally managed debugserver instance.
        """
        return _lldb.SBProcess_RemoteAttachToProcessWithID(self, pid, error)


    def RemoteLaunch(self, argv, envp, stdin_path, stdout_path, stderr_path, working_directory, launch_flags, stop_at_entry, error):
        """
        RemoteLaunch(SBProcess self, str const ** argv, str const ** envp, str const * stdin_path, str const * stdout_path, str const * stderr_path, str const * working_directory, uint32_t launch_flags, bool stop_at_entry, SBError error) -> bool

        See SBTarget.Launch for argument description and usage.
        """
        return _lldb.SBProcess_RemoteLaunch(self, argv, envp, stdin_path, stdout_path, stderr_path, working_directory, launch_flags, stop_at_entry, error)


    def GetNumThreads(self):
        """GetNumThreads(SBProcess self) -> uint32_t"""
        return _lldb.SBProcess_GetNumThreads(self)


    def GetThreadAtIndex(self, index):
        """

        Returns the INDEX'th thread from the list of current threads.  The index
        of a thread is only valid for the current stop.  For a persistent thread
        identifier use either the thread ID or the IndexID.  See help on SBThread
        for more details.
        """
        return _lldb.SBProcess_GetThreadAtIndex(self, index)


    def GetThreadByID(self, sb_thread_id):
        """

        Returns the thread with the given thread ID.
        """
        return _lldb.SBProcess_GetThreadByID(self, sb_thread_id)


    def GetThreadByIndexID(self, index_id):
        """

        Returns the thread with the given thread IndexID.
        """
        return _lldb.SBProcess_GetThreadByIndexID(self, index_id)


    def GetSelectedThread(self):
        """

        Returns the currently selected thread.
        """
        return _lldb.SBProcess_GetSelectedThread(self)


    def CreateOSPluginThread(self, tid, context):
        """

        Lazily create a thread on demand through the current OperatingSystem plug-in, if the current OperatingSystem plug-in supports it.
        """
        return _lldb.SBProcess_CreateOSPluginThread(self, tid, context)


    def SetSelectedThread(self, thread):
        """SetSelectedThread(SBProcess self, SBThread thread) -> bool"""
        return _lldb.SBProcess_SetSelectedThread(self, thread)


    def SetSelectedThreadByID(self, tid):
        """SetSelectedThreadByID(SBProcess self, lldb::tid_t tid) -> bool"""
        return _lldb.SBProcess_SetSelectedThreadByID(self, tid)


    def SetSelectedThreadByIndexID(self, index_id):
        """SetSelectedThreadByIndexID(SBProcess self, uint32_t index_id) -> bool"""
        return _lldb.SBProcess_SetSelectedThreadByIndexID(self, index_id)


    def GetNumQueues(self):
        """GetNumQueues(SBProcess self) -> uint32_t"""
        return _lldb.SBProcess_GetNumQueues(self)


    def GetQueueAtIndex(self, index):
        """GetQueueAtIndex(SBProcess self, uint32_t index) -> SBQueue"""
        return _lldb.SBProcess_GetQueueAtIndex(self, index)


    def GetState(self):
        """GetState(SBProcess self) -> lldb::StateType"""
        return _lldb.SBProcess_GetState(self)


    def GetExitStatus(self):
        """GetExitStatus(SBProcess self) -> int"""
        return _lldb.SBProcess_GetExitStatus(self)


    def GetExitDescription(self):
        """GetExitDescription(SBProcess self) -> str const *"""
        return _lldb.SBProcess_GetExitDescription(self)


    def GetProcessID(self):
        """

        Returns the process ID of the process.
        """
        return _lldb.SBProcess_GetProcessID(self)


    def GetUniqueID(self):
        """

        Returns an integer ID that is guaranteed to be unique across all process instances. This is not the process ID, just a unique integer for comparison and caching purposes.
        """
        return _lldb.SBProcess_GetUniqueID(self)


    def GetAddressByteSize(self):
        """GetAddressByteSize(SBProcess self) -> uint32_t"""
        return _lldb.SBProcess_GetAddressByteSize(self)


    def Destroy(self):
        """
        Destroy(SBProcess self) -> SBError


        Kills the process and shuts down all threads that were spawned to
        track and monitor process.
        """
        return _lldb.SBProcess_Destroy(self)


    def Continue(self):
        """Continue(SBProcess self) -> SBError"""
        return _lldb.SBProcess_Continue(self)


    def Stop(self):
        """Stop(SBProcess self) -> SBError"""
        return _lldb.SBProcess_Stop(self)


    def Kill(self):
        """Kill(SBProcess self) -> SBError"""
        return _lldb.SBProcess_Kill(self)


    def Detach(self):
        """Detach(SBProcess self) -> SBError"""
        return _lldb.SBProcess_Detach(self)


    def Signal(self, signal):
        """
        Signal(SBProcess self, int signal) -> SBError

        Sends the process a unix signal.
        """
        return _lldb.SBProcess_Signal(self, signal)


    def GetUnixSignals(self):
        """GetUnixSignals(SBProcess self) -> SBUnixSignals"""
        return _lldb.SBProcess_GetUnixSignals(self)


    def GetStopID(self, include_expression_stops=False):
        """
        GetStopID(SBProcess self, bool include_expression_stops=False) -> uint32_t
        GetStopID(SBProcess self) -> uint32_t


        Returns a stop id that will increase every time the process executes.  If
        include_expression_stops is true, then stops caused by expression evaluation
        will cause the returned value to increase, otherwise the counter returned will
        only increase when execution is continued explicitly by the user.  Note, the value
        will always increase, but may increase by more than one per stop.
        """
        return _lldb.SBProcess_GetStopID(self, include_expression_stops)


    def SendAsyncInterrupt(self):
        """SendAsyncInterrupt(SBProcess self)"""
        return _lldb.SBProcess_SendAsyncInterrupt(self)


    def ReadMemory(self, addr, buf, error):
        """

        Reads memory from the current process's address space and removes any
        traps that may have been inserted into the memory. It returns the byte
        buffer in a Python string. Example:

        # Read 4 bytes from address 'addr' and assume error.Success() is True.
        content = process.ReadMemory(addr, 4, error)
        new_bytes = bytearray(content)
        """
        return _lldb.SBProcess_ReadMemory(self, addr, buf, error)


    def WriteMemory(self, addr, buf, error):
        """

        Writes memory to the current process's address space and maintains any
        traps that might be present due to software breakpoints. Example:

        # Create a Python string from the byte array.
        new_value = str(bytes)
        result = process.WriteMemory(addr, new_value, error)
        if not error.Success() or result != len(bytes):
            print('SBProcess.WriteMemory() failed!')
        """
        return _lldb.SBProcess_WriteMemory(self, addr, buf, error)


    def ReadCStringFromMemory(self, addr, char_buf, error):
        """

        Reads a NULL terminated C string from the current process's address space.
        It returns a python string of the exact length, or truncates the string if
        the maximum stracter limit is reached. Example:

        # Read a C string of at most 256 bytes from address '0x1000' 
        error = lldb.SBError()
        cstring = process.ReadCStringFromMemory(0x1000, 256, error)
        if error.Success():
            print('cstring: ', cstring)
        else
            print('error: ', error)
        """
        return _lldb.SBProcess_ReadCStringFromMemory(self, addr, char_buf, error)


    def ReadUnsignedFromMemory(self, addr, byte_size, error):
        """

        Reads an unsigned integer from memory given a byte size and an address. 
        Returns the unsigned integer that was read. Example:

        # Read a 4 byte unsigned integer from address 0x1000
        error = lldb.SBError()
        uint = ReadUnsignedFromMemory(0x1000, 4, error)
        if error.Success():
            print('integer: %u' % uint)
        else
            print('error: ', error)

        """
        return _lldb.SBProcess_ReadUnsignedFromMemory(self, addr, byte_size, error)


    def ReadPointerFromMemory(self, addr, error):
        """

        Reads a pointer from memory from an address and returns the value. Example:

        # Read a pointer from address 0x1000
        error = lldb.SBError()
        ptr = ReadPointerFromMemory(0x1000, error)
        if error.Success():
            print('pointer: 0x%x' % ptr)
        else
            print('error: ', error)

        """
        return _lldb.SBProcess_ReadPointerFromMemory(self, addr, error)


    def GetStateFromEvent(event):
        """GetStateFromEvent(SBEvent event) -> lldb::StateType"""
        return _lldb.SBProcess_GetStateFromEvent(event)

    GetStateFromEvent = staticmethod(GetStateFromEvent)

    def GetRestartedFromEvent(event):
        """GetRestartedFromEvent(SBEvent event) -> bool"""
        return _lldb.SBProcess_GetRestartedFromEvent(event)

    GetRestartedFromEvent = staticmethod(GetRestartedFromEvent)

    def GetNumRestartedReasonsFromEvent(event):
        """GetNumRestartedReasonsFromEvent(SBEvent event) -> size_t"""
        return _lldb.SBProcess_GetNumRestartedReasonsFromEvent(event)

    GetNumRestartedReasonsFromEvent = staticmethod(GetNumRestartedReasonsFromEvent)

    def GetRestartedReasonAtIndexFromEvent(event, idx):
        """GetRestartedReasonAtIndexFromEvent(SBEvent event, size_t idx) -> str const *"""
        return _lldb.SBProcess_GetRestartedReasonAtIndexFromEvent(event, idx)

    GetRestartedReasonAtIndexFromEvent = staticmethod(GetRestartedReasonAtIndexFromEvent)

    def GetProcessFromEvent(event):
        """GetProcessFromEvent(SBEvent event) -> SBProcess"""
        return _lldb.SBProcess_GetProcessFromEvent(event)

    GetProcessFromEvent = staticmethod(GetProcessFromEvent)

    def GetInterruptedFromEvent(event):
        """GetInterruptedFromEvent(SBEvent event) -> bool"""
        return _lldb.SBProcess_GetInterruptedFromEvent(event)

    GetInterruptedFromEvent = staticmethod(GetInterruptedFromEvent)

    def GetStructuredDataFromEvent(event):
        """GetStructuredDataFromEvent(SBEvent event) -> SBStructuredData"""
        return _lldb.SBProcess_GetStructuredDataFromEvent(event)

    GetStructuredDataFromEvent = staticmethod(GetStructuredDataFromEvent)

    def EventIsProcessEvent(event):
        """EventIsProcessEvent(SBEvent event) -> bool"""
        return _lldb.SBProcess_EventIsProcessEvent(event)

    EventIsProcessEvent = staticmethod(EventIsProcessEvent)

    def EventIsStructuredDataEvent(event):
        """EventIsStructuredDataEvent(SBEvent event) -> bool"""
        return _lldb.SBProcess_EventIsStructuredDataEvent(event)

    EventIsStructuredDataEvent = staticmethod(EventIsStructuredDataEvent)

    def GetBroadcaster(self):
        """GetBroadcaster(SBProcess self) -> SBBroadcaster"""
        return _lldb.SBProcess_GetBroadcaster(self)


    def GetDescription(self, description):
        """GetDescription(SBProcess self, SBStream description) -> bool"""
        return _lldb.SBProcess_GetDescription(self, description)


    def GetNumSupportedHardwareWatchpoints(self, error):
        """GetNumSupportedHardwareWatchpoints(SBProcess self, SBError error) -> uint32_t"""
        return _lldb.SBProcess_GetNumSupportedHardwareWatchpoints(self, error)


    def LoadImage(self, image_spec, error):
        """LoadImage(SBProcess self, SBFileSpec image_spec, SBError error) -> uint32_t"""
        return _lldb.SBProcess_LoadImage(self, image_spec, error)


    def LoadImageUsingPaths(self, image_spec, paths, loaded_path, error):
        """

        Load the library whose filename is given by image_spec looking in all the
        paths supplied in the paths argument.  If successful, return a token that
        can be passed to UnloadImage and fill loaded_path with the path that was
        successfully loaded.  On failure, return 
        lldb.LLDB_INVALID_IMAGE_TOKEN.
        """
        return _lldb.SBProcess_LoadImageUsingPaths(self, image_spec, paths, loaded_path, error)


    def UnloadImage(self, image_token):
        """UnloadImage(SBProcess self, uint32_t image_token) -> SBError"""
        return _lldb.SBProcess_UnloadImage(self, image_token)


    def SendEventData(self, event_data):
        """SendEventData(SBProcess self, str const * event_data) -> SBError"""
        return _lldb.SBProcess_SendEventData(self, event_data)


    def GetNumExtendedBacktraceTypes(self):
        """

        Return the number of different thread-origin extended backtraces
        this process can support as a uint32_t.
        When the process is stopped and you have an SBThread, lldb may be
        able to show a backtrace of when that thread was originally created,
        or the work item was enqueued to it (in the case of a libdispatch 
        queue).
        """
        return _lldb.SBProcess_GetNumExtendedBacktraceTypes(self)


    def GetExtendedBacktraceTypeAtIndex(self, idx):
        """

        Takes an index argument, returns the name of one of the thread-origin 
        extended backtrace methods as a str.
        """
        return _lldb.SBProcess_GetExtendedBacktraceTypeAtIndex(self, idx)


    def GetHistoryThreads(self, addr):
        """GetHistoryThreads(SBProcess self, lldb::addr_t addr) -> SBThreadCollection"""
        return _lldb.SBProcess_GetHistoryThreads(self, addr)


    def IsInstrumentationRuntimePresent(self, type):
        """IsInstrumentationRuntimePresent(SBProcess self, lldb::InstrumentationRuntimeType type) -> bool"""
        return _lldb.SBProcess_IsInstrumentationRuntimePresent(self, type)


    def SaveCore(self, file_name):
        """SaveCore(SBProcess self, str const * file_name) -> SBError"""
        return _lldb.SBProcess_SaveCore(self, file_name)


    def StartTrace(self, options, error):
        """StartTrace(SBProcess self, SBTraceOptions options, SBError error) -> SBTrace"""
        return _lldb.SBProcess_StartTrace(self, options, error)


    def GetMemoryRegionInfo(self, load_addr, region_info):
        """GetMemoryRegionInfo(SBProcess self, lldb::addr_t load_addr, SBMemoryRegionInfo region_info) -> SBError"""
        return _lldb.SBProcess_GetMemoryRegionInfo(self, load_addr, region_info)


    def GetMemoryRegions(self):
        """GetMemoryRegions(SBProcess self) -> SBMemoryRegionInfoList"""
        return _lldb.SBProcess_GetMemoryRegions(self)


    def GetProcessInfo(self):
        """

        Get information about the process.
        Valid process info will only be returned when the process is alive,
        use IsValid() to check if the info returned is valid.

        process_info = process.GetProcessInfo()
        if process_info.IsValid():
            process_info.GetProcessID()
        """
        return _lldb.SBProcess_GetProcessInfo(self)


    def __get_is_alive__(self):
        '''Returns "True" if the process is currently alive, "False" otherwise'''
        s = self.GetState()
        if (s == eStateAttaching or 
            s == eStateLaunching or 
            s == eStateStopped or 
            s == eStateRunning or 
            s == eStateStepping or 
            s == eStateCrashed or 
            s == eStateSuspended):
            return True
        return False

    def __get_is_running__(self):
        '''Returns "True" if the process is currently running, "False" otherwise'''
        state = self.GetState()
        if state == eStateRunning or state == eStateStepping:
            return True
        return False

    def __get_is_stopped__(self):
        '''Returns "True" if the process is currently stopped, "False" otherwise'''
        state = self.GetState()
        if state == eStateStopped or state == eStateCrashed or state == eStateSuspended:
            return True
        return False

    class threads_access(object):
        '''A helper object that will lazily hand out thread for a process when supplied an index.'''
        def __init__(self, sbprocess):
            self.sbprocess = sbprocess

        def __len__(self):
            if self.sbprocess:
                return int(self.sbprocess.GetNumThreads())
            return 0

        def __getitem__(self, key):
            if type(key) is int and key < len(self):
                return self.sbprocess.GetThreadAtIndex(key)
            return None

    def get_threads_access_object(self):
        '''An accessor function that returns a modules_access() object which allows lazy thread access from a lldb.SBProcess object.'''
        return self.threads_access (self)

    def get_process_thread_list(self):
        '''An accessor function that returns a list() that contains all threads in a lldb.SBProcess object.'''
        threads = []
        accessor = self.get_threads_access_object()
        for idx in range(len(accessor)):
            threads.append(accessor[idx])
        return threads

    __swig_getmethods__["threads"] = get_process_thread_list
    if _newclass: threads = property(get_process_thread_list, None, doc='''A read only property that returns a list() of lldb.SBThread objects for this process.''')

    __swig_getmethods__["thread"] = get_threads_access_object
    if _newclass: thread = property(get_threads_access_object, None, doc='''A read only property that returns an object that can access threads by thread index (thread = lldb.process.thread[12]).''')

    __swig_getmethods__["is_alive"] = __get_is_alive__
    if _newclass: is_alive = property(__get_is_alive__, None, doc='''A read only property that returns a boolean value that indicates if this process is currently alive.''')

    __swig_getmethods__["is_running"] = __get_is_running__
    if _newclass: is_running = property(__get_is_running__, None, doc='''A read only property that returns a boolean value that indicates if this process is currently running.''')

    __swig_getmethods__["is_stopped"] = __get_is_stopped__
    if _newclass: is_stopped = property(__get_is_stopped__, None, doc='''A read only property that returns a boolean value that indicates if this process is currently stopped.''')

    __swig_getmethods__["id"] = GetProcessID
    if _newclass: id = property(GetProcessID, None, doc='''A read only property that returns the process ID as an integer.''')

    __swig_getmethods__["target"] = GetTarget
    if _newclass: target = property(GetTarget, None, doc='''A read only property that an lldb object that represents the target (lldb.SBTarget) that owns this process.''')

    __swig_getmethods__["num_threads"] = GetNumThreads
    if _newclass: num_threads = property(GetNumThreads, None, doc='''A read only property that returns the number of threads in this process as an integer.''')

    __swig_getmethods__["selected_thread"] = GetSelectedThread
    __swig_setmethods__["selected_thread"] = SetSelectedThread
    if _newclass: selected_thread = property(GetSelectedThread, SetSelectedThread, doc='''A read/write property that gets/sets the currently selected thread in this process. The getter returns a lldb.SBThread object and the setter takes an lldb.SBThread object.''')

    __swig_getmethods__["state"] = GetState
    if _newclass: state = property(GetState, None, doc='''A read only property that returns an lldb enumeration value (see enumerations that start with "lldb.eState") that represents the current state of this process (running, stopped, exited, etc.).''')

    __swig_getmethods__["exit_state"] = GetExitStatus
    if _newclass: exit_state = property(GetExitStatus, None, doc='''A read only property that returns an exit status as an integer of this process when the process state is lldb.eStateExited.''')

    __swig_getmethods__["exit_description"] = GetExitDescription
    if _newclass: exit_description = property(GetExitDescription, None, doc='''A read only property that returns an exit description as a string of this process when the process state is lldb.eStateExited.''')

    __swig_getmethods__["broadcaster"] = GetBroadcaster
    if _newclass: broadcaster = property(GetBroadcaster, None, doc='''A read only property that an lldb object that represents the broadcaster (lldb.SBBroadcaster) for this process.''')


    def __str__(self):
        """__str__(SBProcess self) -> PyObject *"""
        return _lldb.SBProcess___str__(self)

SBProcess_swigregister = _lldb.SBProcess_swigregister
SBProcess_swigregister(SBProcess)

def SBProcess_GetBroadcasterClassName():
    """SBProcess_GetBroadcasterClassName() -> char const *"""
    return _lldb.SBProcess_GetBroadcasterClassName()

def SBProcess_GetStateFromEvent(event):
    """SBProcess_GetStateFromEvent(SBEvent event) -> lldb::StateType"""
    return _lldb.SBProcess_GetStateFromEvent(event)

def SBProcess_GetRestartedFromEvent(event):
    """SBProcess_GetRestartedFromEvent(SBEvent event) -> bool"""
    return _lldb.SBProcess_GetRestartedFromEvent(event)

def SBProcess_GetNumRestartedReasonsFromEvent(event):
    """SBProcess_GetNumRestartedReasonsFromEvent(SBEvent event) -> size_t"""
    return _lldb.SBProcess_GetNumRestartedReasonsFromEvent(event)

def SBProcess_GetRestartedReasonAtIndexFromEvent(event, idx):
    """SBProcess_GetRestartedReasonAtIndexFromEvent(SBEvent event, size_t idx) -> char const *"""
    return _lldb.SBProcess_GetRestartedReasonAtIndexFromEvent(event, idx)

def SBProcess_GetProcessFromEvent(event):
    """SBProcess_GetProcessFromEvent(SBEvent event) -> SBProcess"""
    return _lldb.SBProcess_GetProcessFromEvent(event)

def SBProcess_GetInterruptedFromEvent(event):
    """SBProcess_GetInterruptedFromEvent(SBEvent event) -> bool"""
    return _lldb.SBProcess_GetInterruptedFromEvent(event)

def SBProcess_GetStructuredDataFromEvent(event):
    """SBProcess_GetStructuredDataFromEvent(SBEvent event) -> SBStructuredData"""
    return _lldb.SBProcess_GetStructuredDataFromEvent(event)

def SBProcess_EventIsProcessEvent(event):
    """SBProcess_EventIsProcessEvent(SBEvent event) -> bool"""
    return _lldb.SBProcess_EventIsProcessEvent(event)

def SBProcess_EventIsStructuredDataEvent(event):
    """SBProcess_EventIsStructuredDataEvent(SBEvent event) -> bool"""
    return _lldb.SBProcess_EventIsStructuredDataEvent(event)

class SBProcessInfo(_object):
    """
    Describes an existing process and any discoverable information that pertains to
    that process.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBProcessInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBProcessInfo, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBProcessInfo self) -> SBProcessInfo
        __init__(lldb::SBProcessInfo self, SBProcessInfo rhs) -> SBProcessInfo
        """
        this = _lldb.new_SBProcessInfo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBProcessInfo
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBProcessInfo self) -> bool"""
        return _lldb.SBProcessInfo_IsValid(self)


    def GetName(self):
        """GetName(SBProcessInfo self) -> str const *"""
        return _lldb.SBProcessInfo_GetName(self)


    def GetExecutableFile(self):
        """GetExecutableFile(SBProcessInfo self) -> SBFileSpec"""
        return _lldb.SBProcessInfo_GetExecutableFile(self)


    def GetProcessID(self):
        """GetProcessID(SBProcessInfo self) -> lldb::pid_t"""
        return _lldb.SBProcessInfo_GetProcessID(self)


    def GetUserID(self):
        """GetUserID(SBProcessInfo self) -> uint32_t"""
        return _lldb.SBProcessInfo_GetUserID(self)


    def GetGroupID(self):
        """GetGroupID(SBProcessInfo self) -> uint32_t"""
        return _lldb.SBProcessInfo_GetGroupID(self)


    def UserIDIsValid(self):
        """UserIDIsValid(SBProcessInfo self) -> bool"""
        return _lldb.SBProcessInfo_UserIDIsValid(self)


    def GroupIDIsValid(self):
        """GroupIDIsValid(SBProcessInfo self) -> bool"""
        return _lldb.SBProcessInfo_GroupIDIsValid(self)


    def GetEffectiveUserID(self):
        """GetEffectiveUserID(SBProcessInfo self) -> uint32_t"""
        return _lldb.SBProcessInfo_GetEffectiveUserID(self)


    def GetEffectiveGroupID(self):
        """GetEffectiveGroupID(SBProcessInfo self) -> uint32_t"""
        return _lldb.SBProcessInfo_GetEffectiveGroupID(self)


    def EffectiveUserIDIsValid(self):
        """EffectiveUserIDIsValid(SBProcessInfo self) -> bool"""
        return _lldb.SBProcessInfo_EffectiveUserIDIsValid(self)


    def EffectiveGroupIDIsValid(self):
        """EffectiveGroupIDIsValid(SBProcessInfo self) -> bool"""
        return _lldb.SBProcessInfo_EffectiveGroupIDIsValid(self)


    def GetParentProcessID(self):
        """GetParentProcessID(SBProcessInfo self) -> lldb::pid_t"""
        return _lldb.SBProcessInfo_GetParentProcessID(self)

SBProcessInfo_swigregister = _lldb.SBProcessInfo_swigregister
SBProcessInfo_swigregister(SBProcessInfo)

class SBQueue(_object):
    """Proxy of C++ lldb::SBQueue class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBQueue, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBQueue, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBQueue self) -> SBQueue
        __init__(lldb::SBQueue self, lldb::QueueSP const & queue_sp) -> SBQueue
        """
        this = _lldb.new_SBQueue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBQueue
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBQueue self) -> bool"""
        return _lldb.SBQueue_IsValid(self)


    def Clear(self):
        """Clear(SBQueue self)"""
        return _lldb.SBQueue_Clear(self)


    def GetProcess(self):
        """GetProcess(SBQueue self) -> SBProcess"""
        return _lldb.SBQueue_GetProcess(self)


    def GetQueueID(self):
        """

        Returns an lldb::queue_id_t type unique identifier number for this
        queue that will not be used by any other queue during this process'
        execution.  These ID numbers often start at 1 with the first
        system-created queues and increment from there.
        """
        return _lldb.SBQueue_GetQueueID(self)


    def GetName(self):
        """GetName(SBQueue self) -> str const *"""
        return _lldb.SBQueue_GetName(self)


    def GetKind(self):
        """

        Returns an lldb::QueueKind enumerated value (e.g. eQueueKindUnknown, 
        eQueueKindSerial, eQueueKindConcurrent) describing the type of this
        queue.
        """
        return _lldb.SBQueue_GetKind(self)


    def GetIndexID(self):
        """GetIndexID(SBQueue self) -> uint32_t"""
        return _lldb.SBQueue_GetIndexID(self)


    def GetNumThreads(self):
        """GetNumThreads(SBQueue self) -> uint32_t"""
        return _lldb.SBQueue_GetNumThreads(self)


    def GetThreadAtIndex(self, arg2):
        """GetThreadAtIndex(SBQueue self, uint32_t arg2) -> SBThread"""
        return _lldb.SBQueue_GetThreadAtIndex(self, arg2)


    def GetNumPendingItems(self):
        """GetNumPendingItems(SBQueue self) -> uint32_t"""
        return _lldb.SBQueue_GetNumPendingItems(self)


    def GetPendingItemAtIndex(self, arg2):
        """GetPendingItemAtIndex(SBQueue self, uint32_t arg2) -> SBQueueItem"""
        return _lldb.SBQueue_GetPendingItemAtIndex(self, arg2)


    def GetNumRunningItems(self):
        """GetNumRunningItems(SBQueue self) -> uint32_t"""
        return _lldb.SBQueue_GetNumRunningItems(self)

SBQueue_swigregister = _lldb.SBQueue_swigregister
SBQueue_swigregister(SBQueue)

class SBQueueItem(_object):
    """Proxy of C++ lldb::SBQueueItem class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBQueueItem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBQueueItem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBQueueItem self) -> SBQueueItem
        __init__(lldb::SBQueueItem self, lldb::QueueItemSP const & queue_item_sp) -> SBQueueItem
        """
        this = _lldb.new_SBQueueItem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBQueueItem
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBQueueItem self) -> bool"""
        return _lldb.SBQueueItem_IsValid(self)


    def Clear(self):
        """Clear(SBQueueItem self)"""
        return _lldb.SBQueueItem_Clear(self)


    def GetKind(self):
        """GetKind(SBQueueItem self) -> lldb::QueueItemKind"""
        return _lldb.SBQueueItem_GetKind(self)


    def SetKind(self, kind):
        """SetKind(SBQueueItem self, lldb::QueueItemKind kind)"""
        return _lldb.SBQueueItem_SetKind(self, kind)


    def GetAddress(self):
        """GetAddress(SBQueueItem self) -> SBAddress"""
        return _lldb.SBQueueItem_GetAddress(self)


    def SetAddress(self, addr):
        """SetAddress(SBQueueItem self, SBAddress addr)"""
        return _lldb.SBQueueItem_SetAddress(self, addr)


    def SetQueueItem(self, queue_item_sp):
        """SetQueueItem(SBQueueItem self, lldb::QueueItemSP const & queue_item_sp)"""
        return _lldb.SBQueueItem_SetQueueItem(self, queue_item_sp)


    def GetExtendedBacktraceThread(self, type):
        """GetExtendedBacktraceThread(SBQueueItem self, str const * type) -> SBThread"""
        return _lldb.SBQueueItem_GetExtendedBacktraceThread(self, type)

SBQueueItem_swigregister = _lldb.SBQueueItem_swigregister
SBQueueItem_swigregister(SBQueueItem)

class SBSection(_object):
    """
    Represents an executable image section.

    SBSection supports iteration through its subsection, represented as SBSection
    as well.  For example,

        for sec in exe_module:
            if sec.GetName() == '__TEXT':
                print sec
                break
        print INDENT + 'Number of subsections: %d' % sec.GetNumSubSections()
        for subsec in sec:
            print INDENT + repr(subsec)

    produces:

    [0x0000000100000000-0x0000000100002000) a.out.__TEXT
        Number of subsections: 6
        [0x0000000100001780-0x0000000100001d5c) a.out.__TEXT.__text
        [0x0000000100001d5c-0x0000000100001da4) a.out.__TEXT.__stubs
        [0x0000000100001da4-0x0000000100001e2c) a.out.__TEXT.__stub_helper
        [0x0000000100001e2c-0x0000000100001f10) a.out.__TEXT.__cstring
        [0x0000000100001f10-0x0000000100001f68) a.out.__TEXT.__unwind_info
        [0x0000000100001f68-0x0000000100001ff8) a.out.__TEXT.__eh_frame

    See also SBModule.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBSection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBSection, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetNumSubSections', 'GetSubSectionAtIndex')
    def __len__(self): return self.GetNumSubSections()
    def __init__(self, *args):
        """
        __init__(lldb::SBSection self) -> SBSection
        __init__(lldb::SBSection self, SBSection rhs) -> SBSection
        """
        this = _lldb.new_SBSection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBSection
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBSection self) -> bool"""
        return _lldb.SBSection_IsValid(self)


    def GetName(self):
        """GetName(SBSection self) -> str const *"""
        return _lldb.SBSection_GetName(self)


    def GetParent(self):
        """GetParent(SBSection self) -> SBSection"""
        return _lldb.SBSection_GetParent(self)


    def FindSubSection(self, sect_name):
        """FindSubSection(SBSection self, str const * sect_name) -> SBSection"""
        return _lldb.SBSection_FindSubSection(self, sect_name)


    def GetNumSubSections(self):
        """GetNumSubSections(SBSection self) -> size_t"""
        return _lldb.SBSection_GetNumSubSections(self)


    def GetSubSectionAtIndex(self, idx):
        """GetSubSectionAtIndex(SBSection self, size_t idx) -> SBSection"""
        return _lldb.SBSection_GetSubSectionAtIndex(self, idx)


    def GetFileAddress(self):
        """GetFileAddress(SBSection self) -> lldb::addr_t"""
        return _lldb.SBSection_GetFileAddress(self)


    def GetLoadAddress(self, target):
        """GetLoadAddress(SBSection self, SBTarget target) -> lldb::addr_t"""
        return _lldb.SBSection_GetLoadAddress(self, target)


    def GetByteSize(self):
        """GetByteSize(SBSection self) -> lldb::addr_t"""
        return _lldb.SBSection_GetByteSize(self)


    def GetFileOffset(self):
        """GetFileOffset(SBSection self) -> uint64_t"""
        return _lldb.SBSection_GetFileOffset(self)


    def GetFileByteSize(self):
        """GetFileByteSize(SBSection self) -> uint64_t"""
        return _lldb.SBSection_GetFileByteSize(self)


    def GetSectionData(self, *args):
        """
        GetSectionData(SBSection self) -> SBData
        GetSectionData(SBSection self, uint64_t offset, uint64_t size) -> SBData
        """
        return _lldb.SBSection_GetSectionData(self, *args)


    def GetSectionType(self):
        """GetSectionType(SBSection self) -> lldb::SectionType"""
        return _lldb.SBSection_GetSectionType(self)


    def GetPermissions(self):
        """GetPermissions(SBSection self) -> uint32_t"""
        return _lldb.SBSection_GetPermissions(self)


    def GetTargetByteSize(self):
        """
        GetTargetByteSize(SBSection self) -> uint32_t


        Return the size of a target's byte represented by this section
        in numbers of host bytes. Note that certain architectures have
        varying minimum addressable unit (i.e. byte) size for their 
        CODE or DATA buses.
        
        @return
            The number of host (8-bit) bytes needed to hold a target byte
        """
        return _lldb.SBSection_GetTargetByteSize(self)


    def GetDescription(self, description):
        """GetDescription(SBSection self, SBStream description) -> bool"""
        return _lldb.SBSection_GetDescription(self, description)


    def __eq__(self, rhs):
        """__eq__(SBSection self, SBSection rhs) -> bool"""
        return _lldb.SBSection___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBSection self, SBSection rhs) -> bool"""
        return _lldb.SBSection___ne__(self, rhs)


    def get_addr(self):
        return SBAddress(self, 0)

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name of this section as a string.''')

    __swig_getmethods__["addr"] = get_addr
    if _newclass: addr = property(get_addr, None, doc='''A read only property that returns an lldb object that represents the start address (lldb.SBAddress) for this section.''')

    __swig_getmethods__["file_addr"] = GetFileAddress
    if _newclass: file_addr = property(GetFileAddress, None, doc='''A read only property that returns an integer that represents the starting "file" address for this section, or the address of the section in the object file in which it is defined.''')

    __swig_getmethods__["size"] = GetByteSize
    if _newclass: size = property(GetByteSize, None, doc='''A read only property that returns the size in bytes of this section as an integer.''')

    __swig_getmethods__["file_offset"] = GetFileOffset
    if _newclass: file_offset = property(GetFileOffset, None, doc='''A read only property that returns the file offset in bytes of this section as an integer.''')

    __swig_getmethods__["file_size"] = GetFileByteSize
    if _newclass: file_size = property(GetFileByteSize, None, doc='''A read only property that returns the file size in bytes of this section as an integer.''')

    __swig_getmethods__["data"] = GetSectionData
    if _newclass: data = property(GetSectionData, None, doc='''A read only property that returns an lldb object that represents the bytes for this section (lldb.SBData) for this section.''')

    __swig_getmethods__["type"] = GetSectionType
    if _newclass: type = property(GetSectionType, None, doc='''A read only property that returns an lldb enumeration value (see enumerations that start with "lldb.eSectionType") that represents the type of this section (code, data, etc.).''')

    __swig_getmethods__["target_byte_size"] = GetTargetByteSize
    if _newclass: target_byte_size = property(GetTargetByteSize, None, doc='''A read only property that returns the size of a target byte represented by this section as a number of host bytes.''')



    def __str__(self):
        """__str__(SBSection self) -> PyObject *"""
        return _lldb.SBSection___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBSection_swigregister = _lldb.SBSection_swigregister
SBSection_swigregister(SBSection)

class SBSourceManager(_object):
    """
    Represents a central authority for displaying source code.

    For example (from test/source-manager/TestSourceManager.py),

            # Create the filespec for 'main.c'.
            filespec = lldb.SBFileSpec('main.c', False)
            source_mgr = self.dbg.GetSourceManager()
            # Use a string stream as the destination.
            stream = lldb.SBStream()
            source_mgr.DisplaySourceLinesWithLineNumbers(filespec,
                                                         self.line,
                                                         2, # context before
                                                         2, # context after
                                                         '=>', # prefix for current line
                                                         stream)

            #    2    
            #    3    int main(int argc, char const *argv[]) {
            # => 4        printf('Hello world.\n'); // Set break point at this line.
            #    5        return 0;
            #    6    }
            self.expect(stream.GetData(), 'Source code displayed correctly',
                        exe=False,
                patterns = ['=> %d.*Hello world' % self.line])

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBSourceManager, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBSourceManager, name)
    __repr__ = _swig_repr

    def __init__(self, rhs):
        """__init__(lldb::SBSourceManager self, SBSourceManager rhs) -> SBSourceManager"""
        this = _lldb.new_SBSourceManager(rhs)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBSourceManager
    __del__ = lambda self: None

    def DisplaySourceLinesWithLineNumbers(self, file, line, context_before, context_after, current_line_cstr, s):
        """DisplaySourceLinesWithLineNumbers(SBSourceManager self, SBFileSpec file, uint32_t line, uint32_t context_before, uint32_t context_after, str const * current_line_cstr, SBStream s) -> size_t"""
        return _lldb.SBSourceManager_DisplaySourceLinesWithLineNumbers(self, file, line, context_before, context_after, current_line_cstr, s)


    def DisplaySourceLinesWithLineNumbersAndColumn(self, file, line, column, context_before, context_after, current_line_cstr, s):
        """DisplaySourceLinesWithLineNumbersAndColumn(SBSourceManager self, SBFileSpec file, uint32_t line, uint32_t column, uint32_t context_before, uint32_t context_after, str const * current_line_cstr, SBStream s) -> size_t"""
        return _lldb.SBSourceManager_DisplaySourceLinesWithLineNumbersAndColumn(self, file, line, column, context_before, context_after, current_line_cstr, s)

SBSourceManager_swigregister = _lldb.SBSourceManager_swigregister
SBSourceManager_swigregister(SBSourceManager)

class SBStream(_object):
    """
    Represents a destination for streaming data output to. By default, a string
    stream is created.

    For example (from test/source-manager/TestSourceManager.py),

            # Create the filespec for 'main.c'.
            filespec = lldb.SBFileSpec('main.c', False)
            source_mgr = self.dbg.GetSourceManager()
            # Use a string stream as the destination.
            stream = lldb.SBStream()
            source_mgr.DisplaySourceLinesWithLineNumbers(filespec,
                                                         self.line,
                                                         2, # context before
                                                         2, # context after
                                                         '=>', # prefix for current line
                                                         stream)

            #    2    
            #    3    int main(int argc, char const *argv[]) {
            # => 4        printf('Hello world.\n'); // Set break point at this line.
            #    5        return 0;
            #    6    }
            self.expect(stream.GetData(), 'Source code displayed correctly',
                        exe=False,
                patterns = ['=> %d.*Hello world' % self.line])

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBStream, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBStream, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(lldb::SBStream self) -> SBStream"""
        this = _lldb.new_SBStream()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBStream
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBStream self) -> bool"""
        return _lldb.SBStream_IsValid(self)


    def GetData(self):
        """
        GetData(SBStream self) -> str const *


        If this stream is not redirected to a file, it will maintain a local
        cache for the stream data which can be accessed using this accessor.
        """
        return _lldb.SBStream_GetData(self)


    def GetSize(self):
        """
        GetSize(SBStream self) -> size_t


        If this stream is not redirected to a file, it will maintain a local
        cache for the stream output whose length can be accessed using this 
        accessor.
        """
        return _lldb.SBStream_GetSize(self)


    def Print(self, str):
        """Print(SBStream self, str const * str)"""
        return _lldb.SBStream_Print(self, str)


    def RedirectToFile(self, path, append):
        """RedirectToFile(SBStream self, str const * path, bool append)"""
        return _lldb.SBStream_RedirectToFile(self, path, append)


    def RedirectToFileHandle(self, fh, transfer_fh_ownership):
        """RedirectToFileHandle(SBStream self, FILE * fh, bool transfer_fh_ownership)"""
        return _lldb.SBStream_RedirectToFileHandle(self, fh, transfer_fh_ownership)


    def RedirectToFileDescriptor(self, fd, transfer_fh_ownership):
        """RedirectToFileDescriptor(SBStream self, int fd, bool transfer_fh_ownership)"""
        return _lldb.SBStream_RedirectToFileDescriptor(self, fd, transfer_fh_ownership)


    def Clear(self):
        """
        Clear(SBStream self)


        If the stream is redirected to a file, forget about the file and if
        ownership of the file was transferred to this object, close the file.
        If the stream is backed by a local cache, clear this cache.
        """
        return _lldb.SBStream_Clear(self)


    def write(self, str):
        """write(SBStream self, str const * str)"""
        return _lldb.SBStream_write(self, str)


    def flush(self):
        """flush(SBStream self)"""
        return _lldb.SBStream_flush(self)

SBStream_swigregister = _lldb.SBStream_swigregister
SBStream_swigregister(SBStream)

class SBStringList(_object):
    """Proxy of C++ lldb::SBStringList class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBStringList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBStringList, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetSize', 'GetStringAtIndex')
    def __len__(self): return self.GetSize()
    def __init__(self, *args):
        """
        __init__(lldb::SBStringList self) -> SBStringList
        __init__(lldb::SBStringList self, SBStringList rhs) -> SBStringList
        """
        this = _lldb.new_SBStringList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBStringList
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBStringList self) -> bool"""
        return _lldb.SBStringList_IsValid(self)


    def AppendString(self, str):
        """AppendString(SBStringList self, str const * str)"""
        return _lldb.SBStringList_AppendString(self, str)


    def AppendList(self, *args):
        """
        AppendList(SBStringList self, str const ** strv, int strc)
        AppendList(SBStringList self, SBStringList strings)
        """
        return _lldb.SBStringList_AppendList(self, *args)


    def GetSize(self):
        """GetSize(SBStringList self) -> uint32_t"""
        return _lldb.SBStringList_GetSize(self)


    def GetStringAtIndex(self, idx):
        """GetStringAtIndex(SBStringList self, size_t idx) -> str const *"""
        return _lldb.SBStringList_GetStringAtIndex(self, idx)


    def Clear(self):
        """Clear(SBStringList self)"""
        return _lldb.SBStringList_Clear(self)

SBStringList_swigregister = _lldb.SBStringList_swigregister
SBStringList_swigregister(SBStringList)

class SBStructuredData(_object):
    """
    A class representing a StructuredData event.

                  This class wraps the event type generated by StructuredData
                  features.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBStructuredData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBStructuredData, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBStructuredData self) -> SBStructuredData
        __init__(lldb::SBStructuredData self, SBStructuredData rhs) -> SBStructuredData
        __init__(lldb::SBStructuredData self, lldb::EventSP const & event_sp) -> SBStructuredData
        """
        this = _lldb.new_SBStructuredData(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBStructuredData
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBStructuredData self) -> bool"""
        return _lldb.SBStructuredData_IsValid(self)


    def Clear(self):
        """Clear(SBStructuredData self)"""
        return _lldb.SBStructuredData_Clear(self)


    def GetType(self):
        """GetType(SBStructuredData self) -> lldb::StructuredDataType"""
        return _lldb.SBStructuredData_GetType(self)


    def GetSize(self):
        """GetSize(SBStructuredData self) -> size_t"""
        return _lldb.SBStructuredData_GetSize(self)


    def GetValueForKey(self, key):
        """GetValueForKey(SBStructuredData self, str const * key) -> SBStructuredData"""
        return _lldb.SBStructuredData_GetValueForKey(self, key)


    def GetItemAtIndex(self, idx):
        """GetItemAtIndex(SBStructuredData self, size_t idx) -> SBStructuredData"""
        return _lldb.SBStructuredData_GetItemAtIndex(self, idx)


    def GetIntegerValue(self, *args):
        """
        GetIntegerValue(SBStructuredData self, uint64_t fail_value) -> uint64_t
        GetIntegerValue(SBStructuredData self) -> uint64_t
        """
        return _lldb.SBStructuredData_GetIntegerValue(self, *args)


    def GetFloatValue(self, *args):
        """
        GetFloatValue(SBStructuredData self, double fail_value) -> double
        GetFloatValue(SBStructuredData self) -> double
        """
        return _lldb.SBStructuredData_GetFloatValue(self, *args)


    def GetBooleanValue(self, fail_value=False):
        """
        GetBooleanValue(SBStructuredData self, bool fail_value=False) -> bool
        GetBooleanValue(SBStructuredData self) -> bool
        """
        return _lldb.SBStructuredData_GetBooleanValue(self, fail_value)


    def GetStringValue(self, dst):
        """GetStringValue(SBStructuredData self, str * dst) -> size_t"""
        return _lldb.SBStructuredData_GetStringValue(self, dst)


    def GetAsJSON(self, stream):
        """GetAsJSON(SBStructuredData self, SBStream stream) -> SBError"""
        return _lldb.SBStructuredData_GetAsJSON(self, stream)


    def GetDescription(self, stream):
        """GetDescription(SBStructuredData self, SBStream stream) -> SBError"""
        return _lldb.SBStructuredData_GetDescription(self, stream)


    def SetFromJSON(self, stream):
        """SetFromJSON(SBStructuredData self, SBStream stream) -> SBError"""
        return _lldb.SBStructuredData_SetFromJSON(self, stream)

SBStructuredData_swigregister = _lldb.SBStructuredData_swigregister
SBStructuredData_swigregister(SBStructuredData)

class SBSymbol(_object):
    """
    Represents the symbol possibly associated with a stack frame.
    SBModule contains SBSymbol(s). SBSymbol can also be retrieved from SBFrame.

    See also SBModule and SBFrame.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBSymbol, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBSymbol, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _lldb.delete_SBSymbol
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(lldb::SBSymbol self) -> SBSymbol
        __init__(lldb::SBSymbol self, SBSymbol rhs) -> SBSymbol
        """
        this = _lldb.new_SBSymbol(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBSymbol self) -> bool"""
        return _lldb.SBSymbol_IsValid(self)


    def GetName(self):
        """GetName(SBSymbol self) -> str const *"""
        return _lldb.SBSymbol_GetName(self)


    def GetDisplayName(self):
        """GetDisplayName(SBSymbol self) -> str const *"""
        return _lldb.SBSymbol_GetDisplayName(self)


    def GetMangledName(self):
        """GetMangledName(SBSymbol self) -> str const *"""
        return _lldb.SBSymbol_GetMangledName(self)


    def GetInstructions(self, *args):
        """
        GetInstructions(SBSymbol self, SBTarget target) -> SBInstructionList
        GetInstructions(SBSymbol self, SBTarget target, str const * flavor_string) -> SBInstructionList
        """
        return _lldb.SBSymbol_GetInstructions(self, *args)


    def GetStartAddress(self):
        """GetStartAddress(SBSymbol self) -> SBAddress"""
        return _lldb.SBSymbol_GetStartAddress(self)


    def GetEndAddress(self):
        """GetEndAddress(SBSymbol self) -> SBAddress"""
        return _lldb.SBSymbol_GetEndAddress(self)


    def GetPrologueByteSize(self):
        """GetPrologueByteSize(SBSymbol self) -> uint32_t"""
        return _lldb.SBSymbol_GetPrologueByteSize(self)


    def GetType(self):
        """GetType(SBSymbol self) -> lldb::SymbolType"""
        return _lldb.SBSymbol_GetType(self)


    def GetDescription(self, description):
        """GetDescription(SBSymbol self, SBStream description) -> bool"""
        return _lldb.SBSymbol_GetDescription(self, description)


    def IsExternal(self):
        """IsExternal(SBSymbol self) -> bool"""
        return _lldb.SBSymbol_IsExternal(self)


    def IsSynthetic(self):
        """IsSynthetic(SBSymbol self) -> bool"""
        return _lldb.SBSymbol_IsSynthetic(self)


    def __eq__(self, rhs):
        """__eq__(SBSymbol self, SBSymbol rhs) -> bool"""
        return _lldb.SBSymbol___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBSymbol self, SBSymbol rhs) -> bool"""
        return _lldb.SBSymbol___ne__(self, rhs)


    def get_instructions_from_current_target (self):
        return self.GetInstructions (target)

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name for this symbol as a string.''')

    __swig_getmethods__["mangled"] = GetMangledName
    if _newclass: mangled = property(GetMangledName, None, doc='''A read only property that returns the mangled (linkage) name for this symbol as a string.''')

    __swig_getmethods__["type"] = GetType
    if _newclass: type = property(GetType, None, doc='''A read only property that returns an lldb enumeration value (see enumerations that start with "lldb.eSymbolType") that represents the type of this symbol.''')

    __swig_getmethods__["addr"] = GetStartAddress
    if _newclass: addr = property(GetStartAddress, None, doc='''A read only property that returns an lldb object that represents the start address (lldb.SBAddress) for this symbol.''')

    __swig_getmethods__["end_addr"] = GetEndAddress
    if _newclass: end_addr = property(GetEndAddress, None, doc='''A read only property that returns an lldb object that represents the end address (lldb.SBAddress) for this symbol.''')

    __swig_getmethods__["prologue_size"] = GetPrologueByteSize
    if _newclass: prologue_size = property(GetPrologueByteSize, None, doc='''A read only property that returns the size in bytes of the prologue instructions as an unsigned integer.''')

    __swig_getmethods__["instructions"] = get_instructions_from_current_target
    if _newclass: instructions = property(get_instructions_from_current_target, None, doc='''A read only property that returns an lldb object that represents the instructions (lldb.SBInstructionList) for this symbol.''')

    __swig_getmethods__["external"] = IsExternal
    if _newclass: external = property(IsExternal, None, doc='''A read only property that returns a boolean value that indicates if this symbol is externally visiable (exported) from the module that contains it.''')

    __swig_getmethods__["synthetic"] = IsSynthetic
    if _newclass: synthetic = property(IsSynthetic, None, doc='''A read only property that returns a boolean value that indicates if this symbol was synthetically created from information in module that contains it.''')




    def __str__(self):
        """__str__(SBSymbol self) -> PyObject *"""
        return _lldb.SBSymbol___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBSymbol_swigregister = _lldb.SBSymbol_swigregister
SBSymbol_swigregister(SBSymbol)

class SBSymbolContext(_object):
    """
    A context object that provides access to core debugger entities.

    Many debugger functions require a context when doing lookups. This class
    provides a common structure that can be used as the result of a query that
    can contain a single result.

    For example,

            exe = os.path.join(os.getcwd(), 'a.out')

            # Create a target for the debugger.
            target = self.dbg.CreateTarget(exe)

            # Now create a breakpoint on main.c by name 'c'.
            breakpoint = target.BreakpointCreateByName('c', 'a.out')

            # Now launch the process, and do not stop at entry point.
            process = target.LaunchSimple(None, None, os.getcwd())

            # The inferior should stop on 'c'.
            from lldbutil import get_stopped_thread
            thread = get_stopped_thread(process, lldb.eStopReasonBreakpoint)
            frame0 = thread.GetFrameAtIndex(0)

            # Now get the SBSymbolContext from this frame.  We want everything. :-)
            context = frame0.GetSymbolContext(lldb.eSymbolContextEverything)

            # Get the module.
            module = context.GetModule()
            ...

            # And the compile unit associated with the frame.
            compileUnit = context.GetCompileUnit()
            ...

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBSymbolContext, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBSymbolContext, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBSymbolContext self) -> SBSymbolContext
        __init__(lldb::SBSymbolContext self, SBSymbolContext rhs) -> SBSymbolContext
        """
        this = _lldb.new_SBSymbolContext(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBSymbolContext
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBSymbolContext self) -> bool"""
        return _lldb.SBSymbolContext_IsValid(self)


    def GetModule(self):
        """GetModule(SBSymbolContext self) -> SBModule"""
        return _lldb.SBSymbolContext_GetModule(self)


    def GetCompileUnit(self):
        """GetCompileUnit(SBSymbolContext self) -> SBCompileUnit"""
        return _lldb.SBSymbolContext_GetCompileUnit(self)


    def GetFunction(self):
        """GetFunction(SBSymbolContext self) -> SBFunction"""
        return _lldb.SBSymbolContext_GetFunction(self)


    def GetBlock(self):
        """GetBlock(SBSymbolContext self) -> SBBlock"""
        return _lldb.SBSymbolContext_GetBlock(self)


    def GetLineEntry(self):
        """GetLineEntry(SBSymbolContext self) -> SBLineEntry"""
        return _lldb.SBSymbolContext_GetLineEntry(self)


    def GetSymbol(self):
        """GetSymbol(SBSymbolContext self) -> SBSymbol"""
        return _lldb.SBSymbolContext_GetSymbol(self)


    def SetModule(self, module):
        """SetModule(SBSymbolContext self, SBModule module)"""
        return _lldb.SBSymbolContext_SetModule(self, module)


    def SetCompileUnit(self, compile_unit):
        """SetCompileUnit(SBSymbolContext self, SBCompileUnit compile_unit)"""
        return _lldb.SBSymbolContext_SetCompileUnit(self, compile_unit)


    def SetFunction(self, function):
        """SetFunction(SBSymbolContext self, SBFunction function)"""
        return _lldb.SBSymbolContext_SetFunction(self, function)


    def SetBlock(self, block):
        """SetBlock(SBSymbolContext self, SBBlock block)"""
        return _lldb.SBSymbolContext_SetBlock(self, block)


    def SetLineEntry(self, line_entry):
        """SetLineEntry(SBSymbolContext self, SBLineEntry line_entry)"""
        return _lldb.SBSymbolContext_SetLineEntry(self, line_entry)


    def SetSymbol(self, symbol):
        """SetSymbol(SBSymbolContext self, SBSymbol symbol)"""
        return _lldb.SBSymbolContext_SetSymbol(self, symbol)


    def GetParentOfInlinedScope(self, curr_frame_pc, parent_frame_addr):
        """GetParentOfInlinedScope(SBSymbolContext self, SBAddress curr_frame_pc, SBAddress parent_frame_addr) -> SBSymbolContext"""
        return _lldb.SBSymbolContext_GetParentOfInlinedScope(self, curr_frame_pc, parent_frame_addr)


    def GetDescription(self, description):
        """GetDescription(SBSymbolContext self, SBStream description) -> bool"""
        return _lldb.SBSymbolContext_GetDescription(self, description)


    __swig_getmethods__["module"] = GetModule
    __swig_setmethods__["module"] = SetModule
    if _newclass: module = property(GetModule, SetModule, doc='''A read/write property that allows the getting/setting of the module (lldb.SBModule) in this symbol context.''')

    __swig_getmethods__["compile_unit"] = GetCompileUnit
    __swig_setmethods__["compile_unit"] = SetCompileUnit
    if _newclass: compile_unit = property(GetCompileUnit, SetCompileUnit, doc='''A read/write property that allows the getting/setting of the compile unit (lldb.SBCompileUnit) in this symbol context.''')

    __swig_getmethods__["function"] = GetFunction
    __swig_setmethods__["function"] = SetFunction
    if _newclass: function = property(GetFunction, SetFunction, doc='''A read/write property that allows the getting/setting of the function (lldb.SBFunction) in this symbol context.''')

    __swig_getmethods__["block"] = GetBlock
    __swig_setmethods__["block"] = SetBlock
    if _newclass: block = property(GetBlock, SetBlock, doc='''A read/write property that allows the getting/setting of the block (lldb.SBBlock) in this symbol context.''')

    __swig_getmethods__["symbol"] = GetSymbol
    __swig_setmethods__["symbol"] = SetSymbol
    if _newclass: symbol = property(GetSymbol, SetSymbol, doc='''A read/write property that allows the getting/setting of the symbol (lldb.SBSymbol) in this symbol context.''')

    __swig_getmethods__["line_entry"] = GetLineEntry
    __swig_setmethods__["line_entry"] = SetLineEntry
    if _newclass: line_entry = property(GetLineEntry, SetLineEntry, doc='''A read/write property that allows the getting/setting of the line entry (lldb.SBLineEntry) in this symbol context.''')


    def __str__(self):
        """__str__(SBSymbolContext self) -> PyObject *"""
        return _lldb.SBSymbolContext___str__(self)

SBSymbolContext_swigregister = _lldb.SBSymbolContext_swigregister
SBSymbolContext_swigregister(SBSymbolContext)

class SBSymbolContextList(_object):
    """
    Represents a list of symbol context object. See also SBSymbolContext.

    For example (from test/python_api/target/TestTargetAPI.py),

        def find_functions(self, exe_name):
            '''Exercise SBTaget.FindFunctions() API.'''
            exe = os.path.join(os.getcwd(), exe_name)

            # Create a target by the debugger.
            target = self.dbg.CreateTarget(exe)
            self.assertTrue(target, VALID_TARGET)

            list = lldb.SBSymbolContextList()
            num = target.FindFunctions('c', lldb.eFunctionNameTypeAuto, False, list)
            self.assertTrue(num == 1 and list.GetSize() == 1)

            for sc in list:
                self.assertTrue(sc.GetModule().GetFileSpec().GetFilename() == exe_name)
                self.assertTrue(sc.GetSymbol().GetName() == 'c')                

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBSymbolContextList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBSymbolContextList, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetSize', 'GetContextAtIndex')
    def __len__(self): return self.GetSize()
    def __init__(self, *args):
        """
        __init__(lldb::SBSymbolContextList self) -> SBSymbolContextList
        __init__(lldb::SBSymbolContextList self, SBSymbolContextList rhs) -> SBSymbolContextList
        """
        this = _lldb.new_SBSymbolContextList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBSymbolContextList
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBSymbolContextList self) -> bool"""
        return _lldb.SBSymbolContextList_IsValid(self)


    def GetSize(self):
        """GetSize(SBSymbolContextList self) -> uint32_t"""
        return _lldb.SBSymbolContextList_GetSize(self)


    def GetContextAtIndex(self, idx):
        """GetContextAtIndex(SBSymbolContextList self, uint32_t idx) -> SBSymbolContext"""
        return _lldb.SBSymbolContextList_GetContextAtIndex(self, idx)


    def Append(self, *args):
        """
        Append(SBSymbolContextList self, SBSymbolContext sc)
        Append(SBSymbolContextList self, SBSymbolContextList sc_list)
        """
        return _lldb.SBSymbolContextList_Append(self, *args)


    def GetDescription(self, description):
        """GetDescription(SBSymbolContextList self, SBStream description) -> bool"""
        return _lldb.SBSymbolContextList_GetDescription(self, description)


    def Clear(self):
        """Clear(SBSymbolContextList self)"""
        return _lldb.SBSymbolContextList_Clear(self)


    def __len__(self):
        return int(self.GetSize())

    def __getitem__(self, key):
        count = len(self)
        if type(key) is int:
            if key < count:
                return self.GetContextAtIndex(key)
            else:
                raise IndexError
        raise TypeError

    def get_module_array(self):
        a = []
        for i in range(len(self)):
            obj = self.GetContextAtIndex(i).module
            if obj:
                a.append(obj)
        return a

    def get_compile_unit_array(self):
        a = []
        for i in range(len(self)):
            obj = self.GetContextAtIndex(i).compile_unit
            if obj:
                a.append(obj)
        return a
    def get_function_array(self):
        a = []
        for i in range(len(self)):
            obj = self.GetContextAtIndex(i).function
            if obj:
                a.append(obj)
        return a
    def get_block_array(self):
        a = []
        for i in range(len(self)):
            obj = self.GetContextAtIndex(i).block
            if obj:
                a.append(obj)
        return a
    def get_symbol_array(self):
        a = []
        for i in range(len(self)):
            obj = self.GetContextAtIndex(i).symbol
            if obj:
                a.append(obj)
        return a
    def get_line_entry_array(self):
        a = []
        for i in range(len(self)):
            obj = self.GetContextAtIndex(i).line_entry
            if obj:
                a.append(obj)
        return a
    __swig_getmethods__["modules"] = get_module_array
    if _newclass: modules = property(get_module_array, None, doc='''Returns a list() of lldb.SBModule objects, one for each module in each SBSymbolContext object in this list.''')

    __swig_getmethods__["compile_units"] = get_compile_unit_array
    if _newclass: compile_units = property(get_compile_unit_array, None, doc='''Returns a list() of lldb.SBCompileUnit objects, one for each compile unit in each SBSymbolContext object in this list.''')

    __swig_getmethods__["functions"] = get_function_array
    if _newclass: functions = property(get_function_array, None, doc='''Returns a list() of lldb.SBFunction objects, one for each function in each SBSymbolContext object in this list.''')

    __swig_getmethods__["blocks"] = get_block_array
    if _newclass: blocks = property(get_block_array, None, doc='''Returns a list() of lldb.SBBlock objects, one for each block in each SBSymbolContext object in this list.''')

    __swig_getmethods__["line_entries"] = get_line_entry_array
    if _newclass: line_entries = property(get_line_entry_array, None, doc='''Returns a list() of lldb.SBLineEntry objects, one for each line entry in each SBSymbolContext object in this list.''')

    __swig_getmethods__["symbols"] = get_symbol_array
    if _newclass: symbols = property(get_symbol_array, None, doc='''Returns a list() of lldb.SBSymbol objects, one for each symbol in each SBSymbolContext object in this list.''')


    def __str__(self):
        """__str__(SBSymbolContextList self) -> PyObject *"""
        return _lldb.SBSymbolContextList___str__(self)

SBSymbolContextList_swigregister = _lldb.SBSymbolContextList_swigregister
SBSymbolContextList_swigregister(SBSymbolContextList)

class SBTarget(_object):
    """
    Represents the target program running under the debugger.

    SBTarget supports module, breakpoint, and watchpoint iterations. For example,

        for m in target.module_iter():
            print m

    produces:

    (x86_64) /Volumes/data/lldb/svn/trunk/test/python_api/lldbutil/iter/a.out
    (x86_64) /usr/lib/dyld
    (x86_64) /usr/lib/libstdc++.6.dylib
    (x86_64) /usr/lib/libSystem.B.dylib
    (x86_64) /usr/lib/system/libmathCommon.A.dylib
    (x86_64) /usr/lib/libSystem.B.dylib(__commpage)

    and,

        for b in target.breakpoint_iter():
            print b

    produces:

    SBBreakpoint: id = 1, file ='main.cpp', line = 66, locations = 1
    SBBreakpoint: id = 2, file ='main.cpp', line = 85, locations = 1

    and,

        for wp_loc in target.watchpoint_iter():
            print wp_loc

    produces:

    Watchpoint 1: addr = 0x1034ca048 size = 4 state = enabled type = rw
        declare @ '/Volumes/data/lldb/svn/trunk/test/python_api/watchpoint/main.c:12'
        hw_index = 0  hit_count = 2     ignore_count = 0
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTarget, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTarget, name)
    __repr__ = _swig_repr
    eBroadcastBitBreakpointChanged = _lldb.SBTarget_eBroadcastBitBreakpointChanged
    eBroadcastBitModulesLoaded = _lldb.SBTarget_eBroadcastBitModulesLoaded
    eBroadcastBitModulesUnloaded = _lldb.SBTarget_eBroadcastBitModulesUnloaded
    eBroadcastBitWatchpointChanged = _lldb.SBTarget_eBroadcastBitWatchpointChanged
    eBroadcastBitSymbolsLoaded = _lldb.SBTarget_eBroadcastBitSymbolsLoaded

    def module_iter(self): return lldb_iter(self, 'GetNumModules', 'GetModuleAtIndex')
    def breakpoint_iter(self): return lldb_iter(self, 'GetNumBreakpoints', 'GetBreakpointAtIndex')
    def watchpoint_iter(self): return lldb_iter(self, 'GetNumWatchpoints', 'GetWatchpointAtIndex')
    def __init__(self, *args):
        """
        __init__(lldb::SBTarget self) -> SBTarget
        __init__(lldb::SBTarget self, SBTarget rhs) -> SBTarget
        """
        this = _lldb.new_SBTarget(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTarget
    __del__ = lambda self: None

    def GetBroadcasterClassName():
        """GetBroadcasterClassName() -> str const *"""
        return _lldb.SBTarget_GetBroadcasterClassName()

    GetBroadcasterClassName = staticmethod(GetBroadcasterClassName)

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTarget self) -> bool"""
        return _lldb.SBTarget_IsValid(self)


    def EventIsTargetEvent(event):
        """EventIsTargetEvent(SBEvent event) -> bool"""
        return _lldb.SBTarget_EventIsTargetEvent(event)

    EventIsTargetEvent = staticmethod(EventIsTargetEvent)

    def GetTargetFromEvent(event):
        """GetTargetFromEvent(SBEvent event) -> SBTarget"""
        return _lldb.SBTarget_GetTargetFromEvent(event)

    GetTargetFromEvent = staticmethod(GetTargetFromEvent)

    def GetNumModulesFromEvent(event):
        """GetNumModulesFromEvent(SBEvent event) -> uint32_t"""
        return _lldb.SBTarget_GetNumModulesFromEvent(event)

    GetNumModulesFromEvent = staticmethod(GetNumModulesFromEvent)

    def GetModuleAtIndexFromEvent(idx, event):
        """GetModuleAtIndexFromEvent(uint32_t const idx, SBEvent event) -> SBModule"""
        return _lldb.SBTarget_GetModuleAtIndexFromEvent(idx, event)

    GetModuleAtIndexFromEvent = staticmethod(GetModuleAtIndexFromEvent)

    def GetProcess(self):
        """GetProcess(SBTarget self) -> SBProcess"""
        return _lldb.SBTarget_GetProcess(self)


    def GetPlatform(self):
        """
        GetPlatform(SBTarget self) -> SBPlatform


        Return the platform object associated with the target.
        
        After return, the platform object should be checked for
        validity.
        
        @return
            A platform object.
        """
        return _lldb.SBTarget_GetPlatform(self)


    def Install(self):
        """
        Install(SBTarget self) -> SBError


        Install any binaries that need to be installed.
        
        This function does nothing when debugging on the host system.
        When connected to remote platforms, the target's main executable
        and any modules that have their install path set will be
        installed on the remote platform. If the main executable doesn't
        have an install location set, it will be installed in the remote
        platform's working directory.
        
        @return
            An error describing anything that went wrong during
            installation.
        """
        return _lldb.SBTarget_Install(self)


    def LaunchSimple(self, argv, envp, working_directory):
        """
        LaunchSimple(SBTarget self, str const ** argv, str const ** envp, str const * working_directory) -> SBProcess


        Launch a new process with sensible defaults.
        
        @param[in] argv
            The argument array.
        
        @param[in] envp
            The environment array.
        
        @param[in] working_directory
            The working directory to have the child process run in
        
        Default: listener
            Set to the target's debugger (SBTarget::GetDebugger())
        
        Default: launch_flags
            Empty launch flags
        
        Default: stdin_path
        Default: stdout_path
        Default: stderr_path
            A pseudo terminal will be used.
        
        @return
             A process object for the newly created process.

        For example,

            process = target.LaunchSimple(['X', 'Y', 'Z'], None, os.getcwd())

        launches a new process by passing 'X', 'Y', 'Z' as the args to the
        executable.
        """
        return _lldb.SBTarget_LaunchSimple(self, argv, envp, working_directory)


    def Launch(self, *args):
        """
        Launch(SBTarget self, SBListener listener, str const ** argv, str const ** envp, str const * stdin_path, str const * stdout_path, str const * stderr_path, str const * working_directory, uint32_t launch_flags, bool stop_at_entry, SBError error) -> SBProcess
        Launch(SBTarget self, SBLaunchInfo launch_info, SBError error) -> SBProcess


        Launch a new process.
        
        Launch a new process by spawning a new process using the
        target object's executable module's file as the file to launch.
        Arguments are given in argv, and the environment variables
        are in envp. Standard input and output files can be
        optionally re-directed to stdin_path, stdout_path, and
        stderr_path.
        
        @param[in] listener
            An optional listener that will receive all process events.
            If listener is valid then listener will listen to all
            process events. If not valid, then this target's debugger
            (SBTarget::GetDebugger()) will listen to all process events.
        
        @param[in] argv
            The argument array.
        
        @param[in] envp
            The environment array.
        
        @param[in] launch_flags
            Flags to modify the launch (@see lldb::LaunchFlags)
        
        @param[in] stdin_path
            The path to use when re-directing the STDIN of the new
            process. If all stdXX_path arguments are NULL, a pseudo
            terminal will be used.
        
        @param[in] stdout_path
            The path to use when re-directing the STDOUT of the new
            process. If all stdXX_path arguments are NULL, a pseudo
            terminal will be used.
        
        @param[in] stderr_path
            The path to use when re-directing the STDERR of the new
            process. If all stdXX_path arguments are NULL, a pseudo
            terminal will be used.
        
        @param[in] working_directory
            The working directory to have the child process run in
        
        @param[in] launch_flags
            Some launch options specified by logical OR'ing
            lldb::LaunchFlags enumeration values together.
        
        @param[in] stop_at_entry
            If false do not stop the inferior at the entry point.
        
        @param[out]
            An error object. Contains the reason if there is some failure.
        
        @return
             A process object for the newly created process.

        For example,

            process = target.Launch(self.dbg.GetListener(), None, None,
                                    None, '/tmp/stdout.txt', None,
                                    None, 0, False, error)

        launches a new process by passing nothing for both the args and the envs
        and redirect the standard output of the inferior to the /tmp/stdout.txt
        file. It does not specify a working directory so that the debug server
        will use its idea of what the current working directory is for the
        inferior. Also, we ask the debugger not to stop the inferior at the
        entry point. If no breakpoint is specified for the inferior, it should
        run to completion if no user interaction is required.
        """
        return _lldb.SBTarget_Launch(self, *args)


    def LoadCore(self, *args):
        """
        LoadCore(SBTarget self, str const * core_file) -> SBProcess
        LoadCore(SBTarget self, str const * core_file, SBError error) -> SBProcess


        Load a core file
        
        @param[in] core_file
            File path of the core dump.
        
        @param[out] error
            An error explaining what went wrong if the operation fails.
            (Optional)
        
        @return
             A process object for the newly created core file.

        For example,

            process = target.LoadCore('./a.out.core')

        loads a new core file and returns the process object.
        """
        return _lldb.SBTarget_LoadCore(self, *args)


    def Attach(self, attach_info, error):
        """Attach(SBTarget self, SBAttachInfo attach_info, SBError error) -> SBProcess"""
        return _lldb.SBTarget_Attach(self, attach_info, error)


    def AttachToProcessWithID(self, listener, pid, error):
        """
        AttachToProcessWithID(SBTarget self, SBListener listener, lldb::pid_t pid, SBError error) -> SBProcess


        Attach to process with pid.
        
        @param[in] listener
            An optional listener that will receive all process events.
            If listener is valid then listener will listen to all
            process events. If not valid, then this target's debugger
            (SBTarget::GetDebugger()) will listen to all process events.
        
        @param[in] pid
            The process ID to attach to.
        
        @param[out]
            An error explaining what went wrong if attach fails.
        
        @return
             A process object for the attached process.
        """
        return _lldb.SBTarget_AttachToProcessWithID(self, listener, pid, error)


    def AttachToProcessWithName(self, listener, name, wait_for, error):
        """
        AttachToProcessWithName(SBTarget self, SBListener listener, str const * name, bool wait_for, SBError error) -> SBProcess


        Attach to process with name.
        
        @param[in] listener
            An optional listener that will receive all process events.
            If listener is valid then listener will listen to all
            process events. If not valid, then this target's debugger
            (SBTarget::GetDebugger()) will listen to all process events.
        
        @param[in] name
            Basename of process to attach to.
        
        @param[in] wait_for
            If true wait for a new instance of 'name' to be launched.
        
        @param[out]
            An error explaining what went wrong if attach fails.
        
        @return
             A process object for the attached process.
        """
        return _lldb.SBTarget_AttachToProcessWithName(self, listener, name, wait_for, error)


    def ConnectRemote(self, listener, url, plugin_name, error):
        """
        ConnectRemote(SBTarget self, SBListener listener, str const * url, str const * plugin_name, SBError error) -> SBProcess


        Connect to a remote debug server with url.
        
        @param[in] listener
            An optional listener that will receive all process events.
            If listener is valid then listener will listen to all
            process events. If not valid, then this target's debugger
            (SBTarget::GetDebugger()) will listen to all process events.
        
        @param[in] url
            The url to connect to, e.g., 'connect://localhost:12345'.
        
        @param[in] plugin_name
            The plugin name to be used; can be NULL.
        
        @param[out]
            An error explaining what went wrong if the connect fails.
        
        @return
             A process object for the connected process.
        """
        return _lldb.SBTarget_ConnectRemote(self, listener, url, plugin_name, error)


    def GetExecutable(self):
        """GetExecutable(SBTarget self) -> SBFileSpec"""
        return _lldb.SBTarget_GetExecutable(self)


    def AddModule(self, *args):
        """
        AddModule(SBTarget self, SBModule module) -> bool
        AddModule(SBTarget self, str const * path, str const * triple, str const * uuid) -> SBModule
        AddModule(SBTarget self, str const * path, str const * triple, str const * uuid_cstr, str const * symfile) -> SBModule
        AddModule(SBTarget self, SBModuleSpec module_spec) -> SBModule
        """
        return _lldb.SBTarget_AddModule(self, *args)


    def GetNumModules(self):
        """GetNumModules(SBTarget self) -> uint32_t"""
        return _lldb.SBTarget_GetNumModules(self)


    def GetModuleAtIndex(self, idx):
        """GetModuleAtIndex(SBTarget self, uint32_t idx) -> SBModule"""
        return _lldb.SBTarget_GetModuleAtIndex(self, idx)


    def RemoveModule(self, module):
        """RemoveModule(SBTarget self, SBModule module) -> bool"""
        return _lldb.SBTarget_RemoveModule(self, module)


    def GetDebugger(self):
        """GetDebugger(SBTarget self) -> SBDebugger"""
        return _lldb.SBTarget_GetDebugger(self)


    def FindModule(self, file_spec):
        """FindModule(SBTarget self, SBFileSpec file_spec) -> SBModule"""
        return _lldb.SBTarget_FindModule(self, file_spec)


    def FindCompileUnits(self, sb_file_spec):
        """
        FindCompileUnits(SBTarget self, SBFileSpec sb_file_spec) -> SBSymbolContextList


        Find compile units related to *this target and passed source
        file.
        
        @param[in] sb_file_spec
            A lldb::SBFileSpec object that contains source file
            specification.
        
        @return
            A lldb::SBSymbolContextList that gets filled in with all of
            the symbol contexts for all the matches.
        """
        return _lldb.SBTarget_FindCompileUnits(self, sb_file_spec)


    def GetByteOrder(self):
        """GetByteOrder(SBTarget self) -> lldb::ByteOrder"""
        return _lldb.SBTarget_GetByteOrder(self)


    def GetAddressByteSize(self):
        """GetAddressByteSize(SBTarget self) -> uint32_t"""
        return _lldb.SBTarget_GetAddressByteSize(self)


    def GetTriple(self):
        """GetTriple(SBTarget self) -> str const *"""
        return _lldb.SBTarget_GetTriple(self)


    def GetDataByteSize(self):
        """
        GetDataByteSize(SBTarget self) -> uint32_t


        Architecture data byte width accessor
        
        @return
        The size in 8-bit (host) bytes of a minimum addressable
        unit from the Architecture's data bus
        """
        return _lldb.SBTarget_GetDataByteSize(self)


    def GetCodeByteSize(self):
        """
        GetCodeByteSize(SBTarget self) -> uint32_t


        Architecture code byte width accessor
        
        @return
        The size in 8-bit (host) bytes of a minimum addressable
        unit from the Architecture's code bus
        """
        return _lldb.SBTarget_GetCodeByteSize(self)


    def SetSectionLoadAddress(self, section, section_base_addr):
        """SetSectionLoadAddress(SBTarget self, SBSection section, lldb::addr_t section_base_addr) -> SBError"""
        return _lldb.SBTarget_SetSectionLoadAddress(self, section, section_base_addr)


    def ClearSectionLoadAddress(self, section):
        """ClearSectionLoadAddress(SBTarget self, SBSection section) -> SBError"""
        return _lldb.SBTarget_ClearSectionLoadAddress(self, section)


    def SetModuleLoadAddress(self, module, sections_offset):
        """SetModuleLoadAddress(SBTarget self, SBModule module, int64_t sections_offset) -> SBError"""
        return _lldb.SBTarget_SetModuleLoadAddress(self, module, sections_offset)


    def ClearModuleLoadAddress(self, module):
        """ClearModuleLoadAddress(SBTarget self, SBModule module) -> SBError"""
        return _lldb.SBTarget_ClearModuleLoadAddress(self, module)


    def FindFunctions(self, *args):
        """
        FindFunctions(SBTarget self, str const * name, uint32_t name_type_mask) -> SBSymbolContextList
        FindFunctions(SBTarget self, str const * name) -> SBSymbolContextList


        Find functions by name.
        
        @param[in] name
            The name of the function we are looking for.
        
        @param[in] name_type_mask
            A logical OR of one or more FunctionNameType enum bits that
            indicate what kind of names should be used when doing the
            lookup. Bits include fully qualified names, base names,
            C++ methods, or ObjC selectors.
            See FunctionNameType for more details.
        
        @return
            A lldb::SBSymbolContextList that gets filled in with all of
            the symbol contexts for all the matches.
        """
        return _lldb.SBTarget_FindFunctions(self, *args)


    def FindFirstType(self, type):
        """FindFirstType(SBTarget self, str const * type) -> SBType"""
        return _lldb.SBTarget_FindFirstType(self, type)


    def FindTypes(self, type):
        """FindTypes(SBTarget self, str const * type) -> SBTypeList"""
        return _lldb.SBTarget_FindTypes(self, type)


    def GetBasicType(self, type):
        """GetBasicType(SBTarget self, lldb::BasicType type) -> SBType"""
        return _lldb.SBTarget_GetBasicType(self, type)


    def GetSourceManager(self):
        """GetSourceManager(SBTarget self) -> SBSourceManager"""
        return _lldb.SBTarget_GetSourceManager(self)


    def FindFirstGlobalVariable(self, name):
        """
        FindFirstGlobalVariable(SBTarget self, str const * name) -> SBValue


        Find the first global (or static) variable by name.
        
        @param[in] name
            The name of the global or static variable we are looking
            for.
        
        @return
            An SBValue that gets filled in with the found variable (if any).
        """
        return _lldb.SBTarget_FindFirstGlobalVariable(self, name)


    def FindGlobalVariables(self, *args):
        """
        FindGlobalVariables(SBTarget self, str const * name, uint32_t max_matches) -> SBValueList
        FindGlobalVariables(SBTarget self, str const * name, uint32_t max_matches, lldb::MatchType matchtype) -> SBValueList


        Find global and static variables by name.
        
        @param[in] name
            The name of the global or static variable we are looking
            for.
        
        @param[in] max_matches
            Allow the number of matches to be limited to max_matches.
        
        @return
            A list of matched variables in an SBValueList.
        """
        return _lldb.SBTarget_FindGlobalVariables(self, *args)


    def FindGlobalFunctions(self, name, max_matches, matchtype):
        """FindGlobalFunctions(SBTarget self, str const * name, uint32_t max_matches, lldb::MatchType matchtype) -> SBSymbolContextList"""
        return _lldb.SBTarget_FindGlobalFunctions(self, name, max_matches, matchtype)


    def Clear(self):
        """Clear(SBTarget self)"""
        return _lldb.SBTarget_Clear(self)


    def ResolveFileAddress(self, file_addr):
        """
        ResolveFileAddress(SBTarget self, lldb::addr_t file_addr) -> SBAddress


        Resolve a current file address into a section offset address.
        
        @param[in] file_addr
        
        @return
            An SBAddress which will be valid if...
        """
        return _lldb.SBTarget_ResolveFileAddress(self, file_addr)


    def ResolveLoadAddress(self, vm_addr):
        """ResolveLoadAddress(SBTarget self, lldb::addr_t vm_addr) -> SBAddress"""
        return _lldb.SBTarget_ResolveLoadAddress(self, vm_addr)


    def ResolvePastLoadAddress(self, stop_id, vm_addr):
        """ResolvePastLoadAddress(SBTarget self, uint32_t stop_id, lldb::addr_t vm_addr) -> SBAddress"""
        return _lldb.SBTarget_ResolvePastLoadAddress(self, stop_id, vm_addr)


    def ResolveSymbolContextForAddress(self, addr, resolve_scope):
        """ResolveSymbolContextForAddress(SBTarget self, SBAddress addr, uint32_t resolve_scope) -> SBSymbolContext"""
        return _lldb.SBTarget_ResolveSymbolContextForAddress(self, addr, resolve_scope)


    def ReadMemory(self, addr, buf, error):
        """
        ReadMemory(SBTarget self, SBAddress addr, void * buf, SBError error) -> size_t


        Read target memory. If a target process is running then memory
        is read from here. Otherwise the memory is read from the object
        files. For a target whose bytes are sized as a multiple of host
        bytes, the data read back will preserve the target's byte order.
        
        @param[in] addr
            A target address to read from.
        
        @param[out] buf
            The buffer to read memory into.
        
        @param[in] size
            The maximum number of host bytes to read in the buffer passed
            into this call
        
        @param[out] error
            Error information is written here if the memory read fails.
        
        @return
            The amount of data read in host bytes.
        """
        return _lldb.SBTarget_ReadMemory(self, addr, buf, error)


    def BreakpointCreateByLocation(self, *args):
        """
        BreakpointCreateByLocation(SBTarget self, str const * file, uint32_t line) -> SBBreakpoint
        BreakpointCreateByLocation(SBTarget self, SBFileSpec file_spec, uint32_t line) -> SBBreakpoint
        BreakpointCreateByLocation(SBTarget self, SBFileSpec file_spec, uint32_t line, lldb::addr_t offset) -> SBBreakpoint
        BreakpointCreateByLocation(SBTarget self, SBFileSpec file_spec, uint32_t line, lldb::addr_t offset, SBFileSpecList module_list) -> SBBreakpoint
        """
        return _lldb.SBTarget_BreakpointCreateByLocation(self, *args)


    def BreakpointCreateByName(self, *args):
        """
        BreakpointCreateByName(SBTarget self, str const * symbol_name, str const * module_name=None) -> SBBreakpoint
        BreakpointCreateByName(SBTarget self, str const * symbol_name) -> SBBreakpoint
        BreakpointCreateByName(SBTarget self, str const * symbol_name, uint32_t func_name_type, SBFileSpecList module_list, SBFileSpecList comp_unit_list) -> SBBreakpoint
        BreakpointCreateByName(SBTarget self, str const * symbol_name, uint32_t func_name_type, lldb::LanguageType symbol_language, SBFileSpecList module_list, SBFileSpecList comp_unit_list) -> SBBreakpoint
        """
        return _lldb.SBTarget_BreakpointCreateByName(self, *args)


    def BreakpointCreateByNames(self, *args):
        """
        BreakpointCreateByNames(SBTarget self, str const ** symbol_name, uint32_t name_type_mask, SBFileSpecList module_list, SBFileSpecList comp_unit_list) -> SBBreakpoint
        BreakpointCreateByNames(SBTarget self, str const ** symbol_name, uint32_t name_type_mask, lldb::LanguageType symbol_language, SBFileSpecList module_list, SBFileSpecList comp_unit_list) -> SBBreakpoint
        BreakpointCreateByNames(SBTarget self, str const ** symbol_name, uint32_t name_type_mask, lldb::LanguageType symbol_language, lldb::addr_t offset, SBFileSpecList module_list, SBFileSpecList comp_unit_list) -> SBBreakpoint
        """
        return _lldb.SBTarget_BreakpointCreateByNames(self, *args)


    def BreakpointCreateByRegex(self, *args):
        """
        BreakpointCreateByRegex(SBTarget self, str const * symbol_name_regex, str const * module_name=None) -> SBBreakpoint
        BreakpointCreateByRegex(SBTarget self, str const * symbol_name_regex) -> SBBreakpoint
        BreakpointCreateByRegex(SBTarget self, str const * symbol_name_regex, lldb::LanguageType symbol_language, SBFileSpecList module_list, SBFileSpecList comp_unit_list) -> SBBreakpoint
        """
        return _lldb.SBTarget_BreakpointCreateByRegex(self, *args)


    def BreakpointCreateBySourceRegex(self, *args):
        """
        BreakpointCreateBySourceRegex(SBTarget self, str const * source_regex, SBFileSpec source_file, str const * module_name=None) -> SBBreakpoint
        BreakpointCreateBySourceRegex(SBTarget self, str const * source_regex, SBFileSpec source_file) -> SBBreakpoint
        BreakpointCreateBySourceRegex(SBTarget self, str const * source_regex, SBFileSpecList module_list, SBFileSpecList file_list) -> SBBreakpoint
        BreakpointCreateBySourceRegex(SBTarget self, str const * source_regex, SBFileSpecList module_list, SBFileSpecList source_file, SBStringList func_names) -> SBBreakpoint
        """
        return _lldb.SBTarget_BreakpointCreateBySourceRegex(self, *args)


    def BreakpointCreateForException(self, language, catch_bp, throw_bp):
        """BreakpointCreateForException(SBTarget self, lldb::LanguageType language, bool catch_bp, bool throw_bp) -> SBBreakpoint"""
        return _lldb.SBTarget_BreakpointCreateForException(self, language, catch_bp, throw_bp)


    def BreakpointCreateByAddress(self, address):
        """BreakpointCreateByAddress(SBTarget self, lldb::addr_t address) -> SBBreakpoint"""
        return _lldb.SBTarget_BreakpointCreateByAddress(self, address)


    def BreakpointCreateBySBAddress(self, sb_address):
        """BreakpointCreateBySBAddress(SBTarget self, SBAddress sb_address) -> SBBreakpoint"""
        return _lldb.SBTarget_BreakpointCreateBySBAddress(self, sb_address)


    def GetNumBreakpoints(self):
        """GetNumBreakpoints(SBTarget self) -> uint32_t"""
        return _lldb.SBTarget_GetNumBreakpoints(self)


    def GetBreakpointAtIndex(self, idx):
        """GetBreakpointAtIndex(SBTarget self, uint32_t idx) -> SBBreakpoint"""
        return _lldb.SBTarget_GetBreakpointAtIndex(self, idx)


    def BreakpointDelete(self, break_id):
        """BreakpointDelete(SBTarget self, lldb::break_id_t break_id) -> bool"""
        return _lldb.SBTarget_BreakpointDelete(self, break_id)


    def FindBreakpointByID(self, break_id):
        """FindBreakpointByID(SBTarget self, lldb::break_id_t break_id) -> SBBreakpoint"""
        return _lldb.SBTarget_FindBreakpointByID(self, break_id)


    def FindBreakpointsByName(self, name, bkpt_list):
        """FindBreakpointsByName(SBTarget self, str const * name, SBBreakpointList bkpt_list) -> bool"""
        return _lldb.SBTarget_FindBreakpointsByName(self, name, bkpt_list)


    def DeleteBreakpointName(self, name):
        """DeleteBreakpointName(SBTarget self, str const * name)"""
        return _lldb.SBTarget_DeleteBreakpointName(self, name)


    def GetBreakpointNames(self, names):
        """GetBreakpointNames(SBTarget self, SBStringList names)"""
        return _lldb.SBTarget_GetBreakpointNames(self, names)


    def EnableAllBreakpoints(self):
        """EnableAllBreakpoints(SBTarget self) -> bool"""
        return _lldb.SBTarget_EnableAllBreakpoints(self)


    def DisableAllBreakpoints(self):
        """DisableAllBreakpoints(SBTarget self) -> bool"""
        return _lldb.SBTarget_DisableAllBreakpoints(self)


    def DeleteAllBreakpoints(self):
        """DeleteAllBreakpoints(SBTarget self) -> bool"""
        return _lldb.SBTarget_DeleteAllBreakpoints(self)


    def BreakpointsCreateFromFile(self, *args):
        """
        BreakpointsCreateFromFile(SBTarget self, SBFileSpec source_file, SBBreakpointList bkpt_list) -> SBError
        BreakpointsCreateFromFile(SBTarget self, SBFileSpec source_file, SBStringList matching_names, SBBreakpointList new_bps) -> SBError


        Read breakpoints from source_file and return the newly created
        breakpoints in bkpt_list.
        
        @param[in] source_file
           The file from which to read the breakpoints
        
        @param[in] matching_names
           Only read in breakpoints whose names match one of the names in this
           list.
        
        @param[out] bkpt_list
           A list of the newly created breakpoints.
        
        @return
            An SBError detailing any errors in reading in the breakpoints.
        """
        return _lldb.SBTarget_BreakpointsCreateFromFile(self, *args)


    def BreakpointsWriteToFile(self, *args):
        """
        BreakpointsWriteToFile(SBTarget self, SBFileSpec dest_file) -> SBError
        BreakpointsWriteToFile(SBTarget self, SBFileSpec dest_file, SBBreakpointList bkpt_list, bool append=False) -> SBError
        BreakpointsWriteToFile(SBTarget self, SBFileSpec dest_file, SBBreakpointList bkpt_list) -> SBError
        """
        return _lldb.SBTarget_BreakpointsWriteToFile(self, *args)


    def GetNumWatchpoints(self):
        """GetNumWatchpoints(SBTarget self) -> uint32_t"""
        return _lldb.SBTarget_GetNumWatchpoints(self)


    def GetWatchpointAtIndex(self, idx):
        """GetWatchpointAtIndex(SBTarget self, uint32_t idx) -> SBWatchpoint"""
        return _lldb.SBTarget_GetWatchpointAtIndex(self, idx)


    def DeleteWatchpoint(self, watch_id):
        """DeleteWatchpoint(SBTarget self, lldb::watch_id_t watch_id) -> bool"""
        return _lldb.SBTarget_DeleteWatchpoint(self, watch_id)


    def FindWatchpointByID(self, watch_id):
        """FindWatchpointByID(SBTarget self, lldb::watch_id_t watch_id) -> SBWatchpoint"""
        return _lldb.SBTarget_FindWatchpointByID(self, watch_id)


    def EnableAllWatchpoints(self):
        """EnableAllWatchpoints(SBTarget self) -> bool"""
        return _lldb.SBTarget_EnableAllWatchpoints(self)


    def DisableAllWatchpoints(self):
        """DisableAllWatchpoints(SBTarget self) -> bool"""
        return _lldb.SBTarget_DisableAllWatchpoints(self)


    def DeleteAllWatchpoints(self):
        """DeleteAllWatchpoints(SBTarget self) -> bool"""
        return _lldb.SBTarget_DeleteAllWatchpoints(self)


    def WatchAddress(self, addr, size, read, write, error):
        """WatchAddress(SBTarget self, lldb::addr_t addr, size_t size, bool read, bool write, SBError error) -> SBWatchpoint"""
        return _lldb.SBTarget_WatchAddress(self, addr, size, read, write, error)


    def GetBroadcaster(self):
        """GetBroadcaster(SBTarget self) -> SBBroadcaster"""
        return _lldb.SBTarget_GetBroadcaster(self)


    def CreateValueFromAddress(self, name, addr, type):
        """
        CreateValueFromAddress(SBTarget self, str const * name, SBAddress addr, SBType type) -> SBValue


        Create an SBValue with the given name by treating the memory starting at addr as an entity of type.
        
        @param[in] name
            The name of the resultant SBValue
        
        @param[in] addr
            The address of the start of the memory region to be used.
        
        @param[in] type
            The type to use to interpret the memory starting at addr.
        
        @return
            An SBValue of the given type, may be invalid if there was an error reading
            the underlying memory.
        """
        return _lldb.SBTarget_CreateValueFromAddress(self, name, addr, type)


    def CreateValueFromData(self, name, data, type):
        """CreateValueFromData(SBTarget self, str const * name, SBData data, SBType type) -> SBValue"""
        return _lldb.SBTarget_CreateValueFromData(self, name, data, type)


    def CreateValueFromExpression(self, name, expr):
        """CreateValueFromExpression(SBTarget self, str const * name, str const * expr) -> SBValue"""
        return _lldb.SBTarget_CreateValueFromExpression(self, name, expr)


    def ReadInstructions(self, *args):
        """
        ReadInstructions(SBTarget self, SBAddress base_addr, uint32_t count) -> SBInstructionList
        ReadInstructions(SBTarget self, SBAddress base_addr, uint32_t count, str const * flavor_string) -> SBInstructionList


        Disassemble a specified number of instructions starting at an address.
        Parameters:
           base_addr       -- the address to start disassembly from
           count           -- the number of instructions to disassemble
           flavor_string   -- may be 'intel' or 'att' on x86 targets to specify that style of disassembly
        Returns an SBInstructionList.
        """
        return _lldb.SBTarget_ReadInstructions(self, *args)


    def GetInstructions(self, base_addr, buf):
        """
        GetInstructions(SBTarget self, SBAddress base_addr, void const * buf) -> SBInstructionList


        Disassemble the bytes in a buffer and return them in an SBInstructionList.
        Parameters:
           base_addr -- used for symbolicating the offsets in the byte stream when disassembling
           buf       -- bytes to be disassembled
           size      -- (C++) size of the buffer
        Returns an SBInstructionList.
        """
        return _lldb.SBTarget_GetInstructions(self, base_addr, buf)


    def GetInstructionsWithFlavor(self, base_addr, flavor_string, buf):
        """
        GetInstructionsWithFlavor(SBTarget self, SBAddress base_addr, str const * flavor_string, void const * buf) -> SBInstructionList


        Disassemble the bytes in a buffer and return them in an SBInstructionList, with a supplied flavor.
        Parameters:
           base_addr -- used for symbolicating the offsets in the byte stream when disassembling
           flavor    -- may be 'intel' or 'att' on x86 targets to specify that style of disassembly
           buf       -- bytes to be disassembled
           size      -- (C++) size of the buffer
        Returns an SBInstructionList.
        """
        return _lldb.SBTarget_GetInstructionsWithFlavor(self, base_addr, flavor_string, buf)


    def FindSymbols(self, *args):
        """
        FindSymbols(SBTarget self, str const * name, lldb::SymbolType type) -> SBSymbolContextList
        FindSymbols(SBTarget self, str const * name) -> SBSymbolContextList
        """
        return _lldb.SBTarget_FindSymbols(self, *args)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTarget self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTarget_GetDescription(self, description, description_level)


    def GetStackRedZoneSize(self):
        """GetStackRedZoneSize(SBTarget self) -> lldb::addr_t"""
        return _lldb.SBTarget_GetStackRedZoneSize(self)


    def GetLaunchInfo(self):
        """GetLaunchInfo(SBTarget self) -> SBLaunchInfo"""
        return _lldb.SBTarget_GetLaunchInfo(self)


    def SetLaunchInfo(self, launch_info):
        """SetLaunchInfo(SBTarget self, SBLaunchInfo launch_info)"""
        return _lldb.SBTarget_SetLaunchInfo(self, launch_info)


    def GetStatistics(self):
        """GetStatistics(SBTarget self) -> SBStructuredData"""
        return _lldb.SBTarget_GetStatistics(self)


    def __eq__(self, rhs):
        """__eq__(SBTarget self, SBTarget rhs) -> bool"""
        return _lldb.SBTarget___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBTarget self, SBTarget rhs) -> bool"""
        return _lldb.SBTarget___ne__(self, rhs)


    def EvaluateExpression(self, *args):
        """
        EvaluateExpression(SBTarget self, str const * expr) -> SBValue
        EvaluateExpression(SBTarget self, str const * expr, SBExpressionOptions options) -> SBValue
        """
        return _lldb.SBTarget_EvaluateExpression(self, *args)


    class modules_access(object):
        '''A helper object that will lazily hand out lldb.SBModule objects for a target when supplied an index, or by full or partial path.'''
        def __init__(self, sbtarget):
            self.sbtarget = sbtarget

        def __len__(self):
            if self.sbtarget:
                return int(self.sbtarget.GetNumModules())
            return 0

        def __getitem__(self, key):
            num_modules = self.sbtarget.GetNumModules()
            if type(key) is int:
                if key < num_modules:
                    return self.sbtarget.GetModuleAtIndex(key)
            elif type(key) is str:
                if key.find('/') == -1:
                    for idx in range(num_modules):
                        module = self.sbtarget.GetModuleAtIndex(idx)
                        if module.file.basename == key:
                            return module
                else:
                    for idx in range(num_modules):
                        module = self.sbtarget.GetModuleAtIndex(idx)
                        if module.file.fullpath == key:
                            return module
    # See if the string is a UUID
                try:
                    the_uuid = uuid.UUID(key)
                    if the_uuid:
                        for idx in range(num_modules):
                            module = self.sbtarget.GetModuleAtIndex(idx)
                            if module.uuid == the_uuid:
                                return module
                except:
                    return None
            elif type(key) is uuid.UUID:
                for idx in range(num_modules):
                    module = self.sbtarget.GetModuleAtIndex(idx)
                    if module.uuid == key:
                        return module
            elif type(key) is re.SRE_Pattern:
                matching_modules = []
                for idx in range(num_modules):
                    module = self.sbtarget.GetModuleAtIndex(idx)
                    re_match = key.search(module.path.fullpath)
                    if re_match:
                        matching_modules.append(module)
                return matching_modules
            else:
                print("error: unsupported item type: %s" % type(key))
            return None

    def get_modules_access_object(self):
        '''An accessor function that returns a modules_access() object which allows lazy module access from a lldb.SBTarget object.'''
        return self.modules_access (self)

    def get_modules_array(self):
        '''An accessor function that returns a list() that contains all modules in a lldb.SBTarget object.'''
        modules = []
        for idx in range(self.GetNumModules()):
            modules.append(self.GetModuleAtIndex(idx))
        return modules

    __swig_getmethods__["modules"] = get_modules_array
    if _newclass: modules = property(get_modules_array, None, doc='''A read only property that returns a list() of lldb.SBModule objects contained in this target. This list is a list all modules that the target currently is tracking (the main executable and all dependent shared libraries).''')

    __swig_getmethods__["module"] = get_modules_access_object
    if _newclass: module = property(get_modules_access_object, None, doc=r'''A read only property that returns an object that implements python operator overloading with the square brackets().\n    target.module[<int>] allows array access to any modules.\n    target.module[<str>] allows access to modules by basename, full path, or uuid string value.\n    target.module[uuid.UUID()] allows module access by UUID.\n    target.module[re] allows module access using a regular expression that matches the module full path.''')

    __swig_getmethods__["process"] = GetProcess
    if _newclass: process = property(GetProcess, None, doc='''A read only property that returns an lldb object that represents the process (lldb.SBProcess) that this target owns.''')

    __swig_getmethods__["executable"] = GetExecutable
    if _newclass: executable = property(GetExecutable, None, doc='''A read only property that returns an lldb object that represents the main executable module (lldb.SBModule) for this target.''')

    __swig_getmethods__["debugger"] = GetDebugger
    if _newclass: debugger = property(GetDebugger, None, doc='''A read only property that returns an lldb object that represents the debugger (lldb.SBDebugger) that owns this target.''')

    __swig_getmethods__["num_breakpoints"] = GetNumBreakpoints
    if _newclass: num_breakpoints = property(GetNumBreakpoints, None, doc='''A read only property that returns the number of breakpoints that this target has as an integer.''')

    __swig_getmethods__["num_watchpoints"] = GetNumWatchpoints
    if _newclass: num_watchpoints = property(GetNumWatchpoints, None, doc='''A read only property that returns the number of watchpoints that this target has as an integer.''')

    __swig_getmethods__["broadcaster"] = GetBroadcaster
    if _newclass: broadcaster = property(GetBroadcaster, None, doc='''A read only property that an lldb object that represents the broadcaster (lldb.SBBroadcaster) for this target.''')

    __swig_getmethods__["byte_order"] = GetByteOrder
    if _newclass: byte_order = property(GetByteOrder, None, doc='''A read only property that returns an lldb enumeration value (lldb.eByteOrderLittle, lldb.eByteOrderBig, lldb.eByteOrderInvalid) that represents the byte order for this target.''')

    __swig_getmethods__["addr_size"] = GetAddressByteSize
    if _newclass: addr_size = property(GetAddressByteSize, None, doc='''A read only property that returns the size in bytes of an address for this target.''')

    __swig_getmethods__["triple"] = GetTriple
    if _newclass: triple = property(GetTriple, None, doc='''A read only property that returns the target triple (arch-vendor-os) for this target as a string.''')

    __swig_getmethods__["data_byte_size"] = GetDataByteSize
    if _newclass: data_byte_size = property(GetDataByteSize, None, doc='''A read only property that returns the size in host bytes of a byte in the data address space for this target.''')

    __swig_getmethods__["code_byte_size"] = GetCodeByteSize
    if _newclass: code_byte_size = property(GetCodeByteSize, None, doc='''A read only property that returns the size in host bytes of a byte in the code address space for this target.''')

    __swig_getmethods__["platform"] = GetPlatform
    if _newclass: platform = property(GetPlatform, None, doc='''A read only property that returns the platform associated with with this target.''')


    def __str__(self):
        """__str__(SBTarget self) -> PyObject *"""
        return _lldb.SBTarget___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBTarget_swigregister = _lldb.SBTarget_swigregister
SBTarget_swigregister(SBTarget)

def SBTarget_GetBroadcasterClassName():
    """SBTarget_GetBroadcasterClassName() -> char const *"""
    return _lldb.SBTarget_GetBroadcasterClassName()

def SBTarget_EventIsTargetEvent(event):
    """SBTarget_EventIsTargetEvent(SBEvent event) -> bool"""
    return _lldb.SBTarget_EventIsTargetEvent(event)

def SBTarget_GetTargetFromEvent(event):
    """SBTarget_GetTargetFromEvent(SBEvent event) -> SBTarget"""
    return _lldb.SBTarget_GetTargetFromEvent(event)

def SBTarget_GetNumModulesFromEvent(event):
    """SBTarget_GetNumModulesFromEvent(SBEvent event) -> uint32_t"""
    return _lldb.SBTarget_GetNumModulesFromEvent(event)

def SBTarget_GetModuleAtIndexFromEvent(idx, event):
    """SBTarget_GetModuleAtIndexFromEvent(uint32_t const idx, SBEvent event) -> SBModule"""
    return _lldb.SBTarget_GetModuleAtIndexFromEvent(idx, event)

class SBThread(_object):
    """
    Represents a thread of execution. SBProcess contains SBThread(s).

    SBThreads can be referred to by their ID, which maps to the system specific thread
    identifier, or by IndexID.  The ID may or may not be unique depending on whether the
    system reuses its thread identifiers.  The IndexID is a monotonically increasing identifier
    that will always uniquely reference a particular thread, and when that thread goes
    away it will not be reused.

    SBThread supports frame iteration. For example (from test/python_api/
    lldbutil/iter/TestLLDBIterator.py),

            from lldbutil import print_stacktrace
            stopped_due_to_breakpoint = False
            for thread in process:
                if self.TraceOn():
                    print_stacktrace(thread)
                ID = thread.GetThreadID()
                if thread.GetStopReason() == lldb.eStopReasonBreakpoint:
                    stopped_due_to_breakpoint = True
                for frame in thread:
                    self.assertTrue(frame.GetThread().GetThreadID() == ID)
                    if self.TraceOn():
                        print frame

            self.assertTrue(stopped_due_to_breakpoint)

    See also SBProcess and SBFrame.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBThread, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBThread, name)
    __repr__ = _swig_repr
    eBroadcastBitStackChanged = _lldb.SBThread_eBroadcastBitStackChanged
    eBroadcastBitThreadSuspended = _lldb.SBThread_eBroadcastBitThreadSuspended
    eBroadcastBitThreadResumed = _lldb.SBThread_eBroadcastBitThreadResumed
    eBroadcastBitSelectedFrameChanged = _lldb.SBThread_eBroadcastBitSelectedFrameChanged
    eBroadcastBitThreadSelected = _lldb.SBThread_eBroadcastBitThreadSelected

    def __iter__(self): return lldb_iter(self, 'GetNumFrames', 'GetFrameAtIndex')
    def __len__(self): return self.GetNumFrames()
    def __init__(self, *args):
        """
        __init__(lldb::SBThread self) -> SBThread
        __init__(lldb::SBThread self, SBThread thread) -> SBThread
        """
        this = _lldb.new_SBThread(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBThread
    __del__ = lambda self: None

    def GetBroadcasterClassName():
        """GetBroadcasterClassName() -> str const *"""
        return _lldb.SBThread_GetBroadcasterClassName()

    GetBroadcasterClassName = staticmethod(GetBroadcasterClassName)

    def EventIsThreadEvent(event):
        """EventIsThreadEvent(SBEvent event) -> bool"""
        return _lldb.SBThread_EventIsThreadEvent(event)

    EventIsThreadEvent = staticmethod(EventIsThreadEvent)

    def GetStackFrameFromEvent(event):
        """GetStackFrameFromEvent(SBEvent event) -> SBFrame"""
        return _lldb.SBThread_GetStackFrameFromEvent(event)

    GetStackFrameFromEvent = staticmethod(GetStackFrameFromEvent)

    def GetThreadFromEvent(event):
        """GetThreadFromEvent(SBEvent event) -> SBThread"""
        return _lldb.SBThread_GetThreadFromEvent(event)

    GetThreadFromEvent = staticmethod(GetThreadFromEvent)

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBThread self) -> bool"""
        return _lldb.SBThread_IsValid(self)


    def Clear(self):
        """Clear(SBThread self)"""
        return _lldb.SBThread_Clear(self)


    def GetStopReason(self):
        """GetStopReason(SBThread self) -> lldb::StopReason"""
        return _lldb.SBThread_GetStopReason(self)


    def GetStopReasonDataCount(self):
        """
        GetStopReasonDataCount(SBThread self) -> size_t


        Get the number of words associated with the stop reason.
        See also GetStopReasonDataAtIndex().
        """
        return _lldb.SBThread_GetStopReasonDataCount(self)


    def GetStopReasonDataAtIndex(self, idx):
        """
        GetStopReasonDataAtIndex(SBThread self, uint32_t idx) -> uint64_t


        Get information associated with a stop reason.
        
        Breakpoint stop reasons will have data that consists of pairs of 
        breakpoint IDs followed by the breakpoint location IDs (they always come
        in pairs).
        
        Stop Reason              Count Data Type
        ======================== ===== =========================================
        eStopReasonNone          0
        eStopReasonTrace         0
        eStopReasonBreakpoint    N     duple: {breakpoint id, location id}
        eStopReasonWatchpoint    1     watchpoint id
        eStopReasonSignal        1     unix signal number
        eStopReasonException     N     exception data
        eStopReasonExec          0
        eStopReasonPlanComplete  0
        """
        return _lldb.SBThread_GetStopReasonDataAtIndex(self, idx)


    def GetStopReasonExtendedInfoAsJSON(self, stream):
        """

        Collects a thread's stop reason extended information dictionary and prints it
        into the SBStream in a JSON format. The format of this JSON dictionary depends
        on the stop reason and is currently used only for instrumentation plugins.
        """
        return _lldb.SBThread_GetStopReasonExtendedInfoAsJSON(self, stream)


    def GetStopReasonExtendedBacktraces(self, type):
        """

        Returns a collection of historical stack traces that are significant to the
        current stop reason. Used by ThreadSanitizer, where we provide various stack
        traces that were involved in a data race or other type of detected issue.
        """
        return _lldb.SBThread_GetStopReasonExtendedBacktraces(self, type)


    def GetStopDescription(self, dst):
        """

        Pass only an (int)length and expect to get a Python string describing the
        stop reason.
        """
        return _lldb.SBThread_GetStopDescription(self, dst)


    def GetStopReturnValue(self):
        """GetStopReturnValue(SBThread self) -> SBValue"""
        return _lldb.SBThread_GetStopReturnValue(self)


    def GetThreadID(self):
        """

        Returns a unique thread identifier (type lldb::tid_t, typically a 64-bit type)
        for the current SBThread that will remain constant throughout the thread's
        lifetime in this process and will not be reused by another thread during this
        process lifetime.  On Mac OS X systems, this is a system-wide unique thread
        identifier; this identifier is also used by other tools like sample which helps
        to associate data from those tools with lldb.  See related GetIndexID.
        """
        return _lldb.SBThread_GetThreadID(self)


    def GetIndexID(self):
        """

        Return the index number for this SBThread.  The index number is the same thing
        that a user gives as an argument to 'thread select' in the command line lldb.
        These numbers start at 1 (for the first thread lldb sees in a debug session)
        and increments up throughout the process lifetime.  An index number will not be
        reused for a different thread later in a process - thread 1 will always be
        associated with the same thread.  See related GetThreadID.
        This method returns a uint32_t index number, takes no arguments.
        """
        return _lldb.SBThread_GetIndexID(self)


    def GetName(self):
        """GetName(SBThread self) -> str const *"""
        return _lldb.SBThread_GetName(self)


    def GetQueueName(self):
        """

        Return the queue name associated with this thread, if any, as a str.
        For example, with a libdispatch (aka Grand Central Dispatch) queue.
        """
        return _lldb.SBThread_GetQueueName(self)


    def GetQueueID(self):
        """

        Return the dispatch_queue_id for this thread, if any, as a lldb::queue_id_t.
        For example, with a libdispatch (aka Grand Central Dispatch) queue.
        """
        return _lldb.SBThread_GetQueueID(self)


    def GetInfoItemByPathAsString(self, path, strm):
        """
        GetInfoItemByPathAsString(SBThread self, str const * path, SBStream strm) -> bool


        Takes a path string and a SBStream reference as parameters, returns a bool.  
        Collects the thread's 'info' dictionary from the remote system, uses the path
        argument to descend into the dictionary to an item of interest, and prints
        it into the SBStream in a natural format.  Return bool is to indicate if
        anything was printed into the stream (true) or not (false).
        """
        return _lldb.SBThread_GetInfoItemByPathAsString(self, path, strm)


    def GetQueue(self):
        """

        Return the SBQueue for this thread.  If this thread is not currently associated
        with a libdispatch queue, the SBQueue object's IsValid() method will return false.
        If this SBThread is actually a HistoryThread, we may be able to provide QueueID
        and QueueName, but not provide an SBQueue.  Those individual attributes may have
        been saved for the HistoryThread without enough information to reconstitute the
        entire SBQueue at that time.
        This method takes no arguments, returns an SBQueue.
        """
        return _lldb.SBThread_GetQueue(self)


    def StepOver(self, *args):
        """
        StepOver(SBThread self, lldb::RunMode stop_other_threads)
        StepOver(SBThread self)
        Do a source level single step over in the currently selected thread.
        """
        return _lldb.SBThread_StepOver(self, *args)


    def StepInto(self, *args):
        """
        StepInto(SBThread self, lldb::RunMode stop_other_threads)
        StepInto(SBThread self)
        StepInto(SBThread self, str const * target_name, lldb::RunMode stop_other_threads)
        StepInto(SBThread self, str const * target_name)

            Step the current thread from the current source line to the line given by end_line, stopping if
            the thread steps into the function given by target_name.  If target_name is None, then stepping will stop
            in any of the places we would normally stop.


            Step the current thread from the current source line to the line given by end_line, stopping if
            the thread steps into the function given by target_name.  If target_name is None, then stepping will stop
            in any of the places we would normally stop.
        """
        return _lldb.SBThread_StepInto(self, *args)


    def StepOut(self, *args):
        """
        StepOut(SBThread self)
        Step out of the currently selected thread.
        """
        return _lldb.SBThread_StepOut(self, *args)


    def StepOutOfFrame(self, *args):
        """
        StepOutOfFrame(SBThread self, SBFrame frame)
        Step out of the specified frame.
        """
        return _lldb.SBThread_StepOutOfFrame(self, *args)


    def StepInstruction(self, *args):
        """
        StepInstruction(SBThread self, bool step_over)
        Do an instruction level single step in the currently selected thread.
        """
        return _lldb.SBThread_StepInstruction(self, *args)


    def StepOverUntil(self, frame, file_spec, line):
        """StepOverUntil(SBThread self, SBFrame frame, SBFileSpec file_spec, uint32_t line) -> SBError"""
        return _lldb.SBThread_StepOverUntil(self, frame, file_spec, line)


    def StepUsingScriptedThreadPlan(self, *args):
        """
        StepUsingScriptedThreadPlan(SBThread self, str const * script_class_name) -> SBError
        StepUsingScriptedThreadPlan(SBThread self, str const * script_class_name, bool resume_immediately) -> SBError
        """
        return _lldb.SBThread_StepUsingScriptedThreadPlan(self, *args)


    def JumpToLine(self, file_spec, line):
        """JumpToLine(SBThread self, SBFileSpec file_spec, uint32_t line) -> SBError"""
        return _lldb.SBThread_JumpToLine(self, file_spec, line)


    def RunToAddress(self, *args):
        """
        RunToAddress(SBThread self, lldb::addr_t addr)
        RunToAddress(SBThread self, lldb::addr_t addr, SBError error)
        """
        return _lldb.SBThread_RunToAddress(self, *args)


    def ReturnFromFrame(self, frame, return_value):
        """

        Force a return from the frame passed in (and any frames younger than it)
        without executing any more code in those frames.  If return_value contains
        a valid SBValue, that will be set as the return value from frame.  Note, at
        present only scalar return values are supported.
        """
        return _lldb.SBThread_ReturnFromFrame(self, frame, return_value)


    def UnwindInnermostExpression(self):
        """

        Unwind the stack frames from the innermost expression evaluation.
        This API is equivalent to 'thread return -x'.
        """
        return _lldb.SBThread_UnwindInnermostExpression(self)


    def Suspend(self, *args):
        """
        Suspend(SBThread self) -> bool
        Suspend(SBThread self, SBError error) -> bool


        LLDB currently supports process centric debugging which means when any
        thread in a process stops, all other threads are stopped. The Suspend()
        call here tells our process to suspend a thread and not let it run when
        the other threads in a process are allowed to run. So when 
        SBProcess::Continue() is called, any threads that aren't suspended will
        be allowed to run. If any of the SBThread functions for stepping are 
        called (StepOver, StepInto, StepOut, StepInstruction, RunToAddres), the
        thread will now be allowed to run and these functions will simply return.
        
        Eventually we plan to add support for thread centric debugging where
        each thread is controlled individually and each thread would broadcast
        its state, but we haven't implemented this yet.
        
        Likewise the SBThread::Resume() call will again allow the thread to run
        when the process is continued.
        
        Suspend() and Resume() functions are not currently reference counted, if
        anyone has the need for them to be reference counted, please let us
        know.
        """
        return _lldb.SBThread_Suspend(self, *args)


    def Resume(self, *args):
        """
        Resume(SBThread self) -> bool
        Resume(SBThread self, SBError error) -> bool
        """
        return _lldb.SBThread_Resume(self, *args)


    def IsSuspended(self):
        """IsSuspended(SBThread self) -> bool"""
        return _lldb.SBThread_IsSuspended(self)


    def IsStopped(self):
        """IsStopped(SBThread self) -> bool"""
        return _lldb.SBThread_IsStopped(self)


    def GetNumFrames(self):
        """GetNumFrames(SBThread self) -> uint32_t"""
        return _lldb.SBThread_GetNumFrames(self)


    def GetFrameAtIndex(self, idx):
        """GetFrameAtIndex(SBThread self, uint32_t idx) -> SBFrame"""
        return _lldb.SBThread_GetFrameAtIndex(self, idx)


    def GetSelectedFrame(self):
        """GetSelectedFrame(SBThread self) -> SBFrame"""
        return _lldb.SBThread_GetSelectedFrame(self)


    def SetSelectedFrame(self, frame_idx):
        """SetSelectedFrame(SBThread self, uint32_t frame_idx) -> SBFrame"""
        return _lldb.SBThread_SetSelectedFrame(self, frame_idx)


    def GetProcess(self):
        """GetProcess(SBThread self) -> SBProcess"""
        return _lldb.SBThread_GetProcess(self)


    def GetDescription(self, *args):
        """
        GetDescription(SBThread self, SBStream description) -> bool
        GetDescription(SBThread self, SBStream description, bool stop_format) -> bool


        Get the description strings for this thread that match what the 
        lldb driver will present, using the thread-format (stop_format==false)
        or thread-stop-format (stop_format = true).
        """
        return _lldb.SBThread_GetDescription(self, *args)


    def GetStatus(self, status):
        """GetStatus(SBThread self, SBStream status) -> bool"""
        return _lldb.SBThread_GetStatus(self, status)


    def __eq__(self, rhs):
        """__eq__(SBThread self, SBThread rhs) -> bool"""
        return _lldb.SBThread___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBThread self, SBThread rhs) -> bool"""
        return _lldb.SBThread___ne__(self, rhs)


    def GetExtendedBacktraceThread(self, type):
        """

        Given an argument of str to specify the type of thread-origin extended
        backtrace to retrieve, query whether the origin of this thread is 
        available.  An SBThread is retured; SBThread.IsValid will return true
        if an extended backtrace was available.  The returned SBThread is not
        a part of the SBProcess' thread list and it cannot be manipulated like
        normal threads -- you cannot step or resume it, for instance -- it is
        intended to used primarily for generating a backtrace.  You may request
        the returned thread's own thread origin in turn.
        """
        return _lldb.SBThread_GetExtendedBacktraceThread(self, type)


    def GetExtendedBacktraceOriginatingIndexID(self):
        """

        Takes no arguments, returns a uint32_t.
        If this SBThread is an ExtendedBacktrace thread, get the IndexID of the
        original thread that this ExtendedBacktrace thread represents, if 
        available.  The thread that was running this backtrace in the past may
        not have been registered with lldb's thread index (if it was created,
        did its work, and was destroyed without lldb ever stopping execution).
        In that case, this ExtendedBacktrace thread's IndexID will be returned.
        """
        return _lldb.SBThread_GetExtendedBacktraceOriginatingIndexID(self)


    def SafeToCallFunctions(self):
        """

        Takes no arguments, returns a bool.
        lldb may be able to detect that function calls should not be executed
        on a given thread at a particular point in time.  It is recommended that
        this is checked before performing an inferior function call on a given
        thread.
        """
        return _lldb.SBThread_SafeToCallFunctions(self)


    class frames_access(object):
        '''A helper object that will lazily hand out frames for a thread when supplied an index.'''
        def __init__(self, sbthread):
            self.sbthread = sbthread

        def __len__(self):
            if self.sbthread:
                return int(self.sbthread.GetNumFrames())
            return 0

        def __getitem__(self, key):
            if type(key) is int and key < self.sbthread.GetNumFrames():
                return self.sbthread.GetFrameAtIndex(key)
            return None

    def get_frames_access_object(self):
        '''An accessor function that returns a frames_access() object which allows lazy frame access from a lldb.SBThread object.'''
        return self.frames_access (self)

    def get_thread_frames(self):
        '''An accessor function that returns a list() that contains all frames in a lldb.SBThread object.'''
        frames = []
        for frame in self:
            frames.append(frame)
        return frames

    __swig_getmethods__["id"] = GetThreadID
    if _newclass: id = property(GetThreadID, None, doc='''A read only property that returns the thread ID as an integer.''')

    __swig_getmethods__["idx"] = GetIndexID
    if _newclass: idx = property(GetIndexID, None, doc='''A read only property that returns the thread index ID as an integer. Thread index ID values start at 1 and increment as threads come and go and can be used to uniquely identify threads.''')

    __swig_getmethods__["return_value"] = GetStopReturnValue
    if _newclass: return_value = property(GetStopReturnValue, None, doc='''A read only property that returns an lldb object that represents the return value from the last stop (lldb.SBValue) if we just stopped due to stepping out of a function.''')

    __swig_getmethods__["process"] = GetProcess
    if _newclass: process = property(GetProcess, None, doc='''A read only property that returns an lldb object that represents the process (lldb.SBProcess) that owns this thread.''')

    __swig_getmethods__["num_frames"] = GetNumFrames
    if _newclass: num_frames = property(GetNumFrames, None, doc='''A read only property that returns the number of stack frames in this thread as an integer.''')

    __swig_getmethods__["frames"] = get_thread_frames
    if _newclass: frames = property(get_thread_frames, None, doc='''A read only property that returns a list() of lldb.SBFrame objects for all frames in this thread.''')

    __swig_getmethods__["frame"] = get_frames_access_object
    if _newclass: frame = property(get_frames_access_object, None, doc='''A read only property that returns an object that can be used to access frames as an array ("frame_12 = lldb.thread.frame[12]").''')

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name of this thread as a string.''')

    __swig_getmethods__["queue"] = GetQueueName
    if _newclass: queue = property(GetQueueName, None, doc='''A read only property that returns the dispatch queue name of this thread as a string.''')

    __swig_getmethods__["queue_id"] = GetQueueID
    if _newclass: queue_id = property(GetQueueID, None, doc='''A read only property that returns the dispatch queue id of this thread as an integer.''')

    __swig_getmethods__["stop_reason"] = GetStopReason
    if _newclass: stop_reason = property(GetStopReason, None, doc='''A read only property that returns an lldb enumeration value (see enumerations that start with "lldb.eStopReason") that represents the reason this thread stopped.''')

    __swig_getmethods__["is_suspended"] = IsSuspended
    if _newclass: is_suspended = property(IsSuspended, None, doc='''A read only property that returns a boolean value that indicates if this thread is suspended.''')

    __swig_getmethods__["is_stopped"] = IsStopped
    if _newclass: is_stopped = property(IsStopped, None, doc='''A read only property that returns a boolean value that indicates if this thread is stopped but not exited.''')


    def __str__(self):
        """__str__(SBThread self) -> PyObject *"""
        return _lldb.SBThread___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBThread_swigregister = _lldb.SBThread_swigregister
SBThread_swigregister(SBThread)

def SBThread_GetBroadcasterClassName():
    """SBThread_GetBroadcasterClassName() -> char const *"""
    return _lldb.SBThread_GetBroadcasterClassName()

def SBThread_EventIsThreadEvent(event):
    """SBThread_EventIsThreadEvent(SBEvent event) -> bool"""
    return _lldb.SBThread_EventIsThreadEvent(event)

def SBThread_GetStackFrameFromEvent(event):
    """SBThread_GetStackFrameFromEvent(SBEvent event) -> SBFrame"""
    return _lldb.SBThread_GetStackFrameFromEvent(event)

def SBThread_GetThreadFromEvent(event):
    """SBThread_GetThreadFromEvent(SBEvent event) -> SBThread"""
    return _lldb.SBThread_GetThreadFromEvent(event)

class SBThreadCollection(_object):
    """Represents a collection of SBThread objects."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBThreadCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBThreadCollection, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBThreadCollection self) -> SBThreadCollection
        __init__(lldb::SBThreadCollection self, SBThreadCollection rhs) -> SBThreadCollection
        """
        this = _lldb.new_SBThreadCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBThreadCollection
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBThreadCollection self) -> bool"""
        return _lldb.SBThreadCollection_IsValid(self)


    def GetSize(self):
        """GetSize(SBThreadCollection self) -> size_t"""
        return _lldb.SBThreadCollection_GetSize(self)


    def GetThreadAtIndex(self, idx):
        """GetThreadAtIndex(SBThreadCollection self, size_t idx) -> SBThread"""
        return _lldb.SBThreadCollection_GetThreadAtIndex(self, idx)

SBThreadCollection_swigregister = _lldb.SBThreadCollection_swigregister
SBThreadCollection_swigregister(SBThreadCollection)

class SBThreadPlan(_object):
    """Proxy of C++ lldb::SBThreadPlan class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBThreadPlan, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBThreadPlan, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBThreadPlan self) -> SBThreadPlan
        __init__(lldb::SBThreadPlan self, SBThreadPlan threadPlan) -> SBThreadPlan
        __init__(lldb::SBThreadPlan self, lldb::ThreadPlanSP const & lldb_object_sp) -> SBThreadPlan
        __init__(lldb::SBThreadPlan self, SBThread thread, str const * class_name) -> SBThreadPlan
        """
        this = _lldb.new_SBThreadPlan(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBThreadPlan
    __del__ = lambda self: None

    def Clear(self):
        """Clear(SBThreadPlan self)"""
        return _lldb.SBThreadPlan_Clear(self)


    def GetStopReason(self):
        """GetStopReason(SBThreadPlan self) -> lldb::StopReason"""
        return _lldb.SBThreadPlan_GetStopReason(self)


    def GetStopReasonDataCount(self):
        """GetStopReasonDataCount(SBThreadPlan self) -> size_t"""
        return _lldb.SBThreadPlan_GetStopReasonDataCount(self)


    def GetStopReasonDataAtIndex(self, idx):
        """GetStopReasonDataAtIndex(SBThreadPlan self, uint32_t idx) -> uint64_t"""
        return _lldb.SBThreadPlan_GetStopReasonDataAtIndex(self, idx)


    def GetThread(self):
        """GetThread(SBThreadPlan self) -> SBThread"""
        return _lldb.SBThreadPlan_GetThread(self)


    def GetDescription(self, description):
        """GetDescription(SBThreadPlan self, SBStream description) -> bool"""
        return _lldb.SBThreadPlan_GetDescription(self, description)


    def SetPlanComplete(self, success):
        """SetPlanComplete(SBThreadPlan self, bool success)"""
        return _lldb.SBThreadPlan_SetPlanComplete(self, success)


    def IsPlanComplete(self):
        """IsPlanComplete(SBThreadPlan self) -> bool"""
        return _lldb.SBThreadPlan_IsPlanComplete(self)


    def IsPlanStale(self):
        """IsPlanStale(SBThreadPlan self) -> bool"""
        return _lldb.SBThreadPlan_IsPlanStale(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self, *args):
        """
        IsValid(SBThreadPlan self) -> bool
        IsValid(SBThreadPlan self) -> bool
        """
        return _lldb.SBThreadPlan_IsValid(self, *args)


    def QueueThreadPlanForStepOverRange(self, start_address, range_size):
        """QueueThreadPlanForStepOverRange(SBThreadPlan self, SBAddress start_address, lldb::addr_t range_size) -> SBThreadPlan"""
        return _lldb.SBThreadPlan_QueueThreadPlanForStepOverRange(self, start_address, range_size)


    def QueueThreadPlanForStepInRange(self, start_address, range_size):
        """QueueThreadPlanForStepInRange(SBThreadPlan self, SBAddress start_address, lldb::addr_t range_size) -> SBThreadPlan"""
        return _lldb.SBThreadPlan_QueueThreadPlanForStepInRange(self, start_address, range_size)


    def QueueThreadPlanForStepOut(self, frame_idx_to_step_to, first_insn=False):
        """
        QueueThreadPlanForStepOut(SBThreadPlan self, uint32_t frame_idx_to_step_to, bool first_insn=False) -> SBThreadPlan
        QueueThreadPlanForStepOut(SBThreadPlan self, uint32_t frame_idx_to_step_to) -> SBThreadPlan
        """
        return _lldb.SBThreadPlan_QueueThreadPlanForStepOut(self, frame_idx_to_step_to, first_insn)


    def QueueThreadPlanForRunToAddress(self, address):
        """QueueThreadPlanForRunToAddress(SBThreadPlan self, SBAddress address) -> SBThreadPlan"""
        return _lldb.SBThreadPlan_QueueThreadPlanForRunToAddress(self, address)

SBThreadPlan_swigregister = _lldb.SBThreadPlan_swigregister
SBThreadPlan_swigregister(SBThreadPlan)

class SBTrace(_object):
    """Proxy of C++ lldb::SBTrace class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTrace, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTrace, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(lldb::SBTrace self) -> SBTrace"""
        this = _lldb.new_SBTrace()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def GetTraceData(self, error, buf, offset, thread_id):
        """GetTraceData(SBTrace self, SBError error, void * buf, size_t offset, lldb::tid_t thread_id) -> size_t"""
        return _lldb.SBTrace_GetTraceData(self, error, buf, offset, thread_id)


    def GetMetaData(self, error, buf, offset, thread_id):
        """GetMetaData(SBTrace self, SBError error, void * buf, size_t offset, lldb::tid_t thread_id) -> size_t"""
        return _lldb.SBTrace_GetMetaData(self, error, buf, offset, thread_id)


    def StopTrace(self, error, thread_id):
        """StopTrace(SBTrace self, SBError error, lldb::tid_t thread_id)"""
        return _lldb.SBTrace_StopTrace(self, error, thread_id)


    def GetTraceConfig(self, options, error):
        """GetTraceConfig(SBTrace self, SBTraceOptions options, SBError error)"""
        return _lldb.SBTrace_GetTraceConfig(self, options, error)


    def GetTraceUID(self):
        """GetTraceUID(SBTrace self) -> lldb::user_id_t"""
        return _lldb.SBTrace_GetTraceUID(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTrace self) -> bool"""
        return _lldb.SBTrace_IsValid(self)

    __swig_destroy__ = _lldb.delete_SBTrace
    __del__ = lambda self: None
SBTrace_swigregister = _lldb.SBTrace_swigregister
SBTrace_swigregister(SBTrace)

class SBTraceOptions(_object):
    """Proxy of C++ lldb::SBTraceOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTraceOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTraceOptions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(lldb::SBTraceOptions self) -> SBTraceOptions"""
        this = _lldb.new_SBTraceOptions()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getType(self):
        """getType(SBTraceOptions self) -> lldb::TraceType"""
        return _lldb.SBTraceOptions_getType(self)


    def getTraceBufferSize(self):
        """getTraceBufferSize(SBTraceOptions self) -> uint64_t"""
        return _lldb.SBTraceOptions_getTraceBufferSize(self)


    def getTraceParams(self, error):
        """getTraceParams(SBTraceOptions self, SBError error) -> SBStructuredData"""
        return _lldb.SBTraceOptions_getTraceParams(self, error)


    def getMetaDataBufferSize(self):
        """getMetaDataBufferSize(SBTraceOptions self) -> uint64_t"""
        return _lldb.SBTraceOptions_getMetaDataBufferSize(self)


    def setTraceParams(self, params):
        """setTraceParams(SBTraceOptions self, SBStructuredData params)"""
        return _lldb.SBTraceOptions_setTraceParams(self, params)


    def setType(self, type):
        """setType(SBTraceOptions self, lldb::TraceType type)"""
        return _lldb.SBTraceOptions_setType(self, type)


    def setTraceBufferSize(self, size):
        """setTraceBufferSize(SBTraceOptions self, uint64_t size)"""
        return _lldb.SBTraceOptions_setTraceBufferSize(self, size)


    def setMetaDataBufferSize(self, size):
        """setMetaDataBufferSize(SBTraceOptions self, uint64_t size)"""
        return _lldb.SBTraceOptions_setMetaDataBufferSize(self, size)


    def setThreadID(self, thread_id):
        """setThreadID(SBTraceOptions self, lldb::tid_t thread_id)"""
        return _lldb.SBTraceOptions_setThreadID(self, thread_id)


    def getThreadID(self):
        """getThreadID(SBTraceOptions self) -> lldb::tid_t"""
        return _lldb.SBTraceOptions_getThreadID(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTraceOptions self) -> bool"""
        return _lldb.SBTraceOptions_IsValid(self)

    __swig_destroy__ = _lldb.delete_SBTraceOptions
    __del__ = lambda self: None
SBTraceOptions_swigregister = _lldb.SBTraceOptions_swigregister
SBTraceOptions_swigregister(SBTraceOptions)

class SBTypeMember(_object):
    """
    Represents a member of a type in lldb.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeMember, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeMember, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeMember self) -> SBTypeMember
        __init__(lldb::SBTypeMember self, SBTypeMember rhs) -> SBTypeMember
        """
        this = _lldb.new_SBTypeMember(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeMember
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeMember self) -> bool"""
        return _lldb.SBTypeMember_IsValid(self)


    def GetName(self):
        """GetName(SBTypeMember self) -> str const *"""
        return _lldb.SBTypeMember_GetName(self)


    def GetType(self):
        """GetType(SBTypeMember self) -> SBType"""
        return _lldb.SBTypeMember_GetType(self)


    def GetOffsetInBytes(self):
        """GetOffsetInBytes(SBTypeMember self) -> uint64_t"""
        return _lldb.SBTypeMember_GetOffsetInBytes(self)


    def GetOffsetInBits(self):
        """GetOffsetInBits(SBTypeMember self) -> uint64_t"""
        return _lldb.SBTypeMember_GetOffsetInBits(self)


    def IsBitfield(self):
        """IsBitfield(SBTypeMember self) -> bool"""
        return _lldb.SBTypeMember_IsBitfield(self)


    def GetBitfieldSizeInBits(self):
        """GetBitfieldSizeInBits(SBTypeMember self) -> uint32_t"""
        return _lldb.SBTypeMember_GetBitfieldSizeInBits(self)


    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name for this member as a string.''')

    __swig_getmethods__["type"] = GetType
    if _newclass: type = property(GetType, None, doc='''A read only property that returns an lldb object that represents the type (lldb.SBType) for this member.''')

    __swig_getmethods__["byte_offset"] = GetOffsetInBytes
    if _newclass: byte_offset = property(GetOffsetInBytes, None, doc='''A read only property that returns offset in bytes for this member as an integer.''')

    __swig_getmethods__["bit_offset"] = GetOffsetInBits
    if _newclass: bit_offset = property(GetOffsetInBits, None, doc='''A read only property that returns offset in bits for this member as an integer.''')

    __swig_getmethods__["is_bitfield"] = IsBitfield
    if _newclass: is_bitfield = property(IsBitfield, None, doc='''A read only property that returns true if this member is a bitfield.''')

    __swig_getmethods__["bitfield_bit_size"] = GetBitfieldSizeInBits
    if _newclass: bitfield_bit_size = property(GetBitfieldSizeInBits, None, doc='''A read only property that returns the bitfield size in bits for this member as an integer, or zero if this member is not a bitfield.''')



    def __str__(self):
        """__str__(SBTypeMember self) -> PyObject *"""
        return _lldb.SBTypeMember___str__(self)

SBTypeMember_swigregister = _lldb.SBTypeMember_swigregister
SBTypeMember_swigregister(SBTypeMember)

class SBTypeMemberFunction(_object):
    """Proxy of C++ lldb::SBTypeMemberFunction class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeMemberFunction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeMemberFunction, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeMemberFunction self) -> SBTypeMemberFunction
        __init__(lldb::SBTypeMemberFunction self, SBTypeMemberFunction rhs) -> SBTypeMemberFunction
        """
        this = _lldb.new_SBTypeMemberFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeMemberFunction
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeMemberFunction self) -> bool"""
        return _lldb.SBTypeMemberFunction_IsValid(self)


    def GetName(self):
        """GetName(SBTypeMemberFunction self) -> str const *"""
        return _lldb.SBTypeMemberFunction_GetName(self)


    def GetDemangledName(self):
        """GetDemangledName(SBTypeMemberFunction self) -> str const *"""
        return _lldb.SBTypeMemberFunction_GetDemangledName(self)


    def GetMangledName(self):
        """GetMangledName(SBTypeMemberFunction self) -> str const *"""
        return _lldb.SBTypeMemberFunction_GetMangledName(self)


    def GetType(self):
        """GetType(SBTypeMemberFunction self) -> SBType"""
        return _lldb.SBTypeMemberFunction_GetType(self)


    def GetReturnType(self):
        """GetReturnType(SBTypeMemberFunction self) -> SBType"""
        return _lldb.SBTypeMemberFunction_GetReturnType(self)


    def GetNumberOfArguments(self):
        """GetNumberOfArguments(SBTypeMemberFunction self) -> uint32_t"""
        return _lldb.SBTypeMemberFunction_GetNumberOfArguments(self)


    def GetArgumentTypeAtIndex(self, arg2):
        """GetArgumentTypeAtIndex(SBTypeMemberFunction self, uint32_t arg2) -> SBType"""
        return _lldb.SBTypeMemberFunction_GetArgumentTypeAtIndex(self, arg2)


    def GetKind(self):
        """GetKind(SBTypeMemberFunction self) -> lldb::MemberFunctionKind"""
        return _lldb.SBTypeMemberFunction_GetKind(self)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeMemberFunction self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeMemberFunction_GetDescription(self, description, description_level)


    def __str__(self):
        """__str__(SBTypeMemberFunction self) -> PyObject *"""
        return _lldb.SBTypeMemberFunction___str__(self)

SBTypeMemberFunction_swigregister = _lldb.SBTypeMemberFunction_swigregister
SBTypeMemberFunction_swigregister(SBTypeMemberFunction)

class SBType(_object):
    """
    Represents a data type in lldb.  The FindFirstType() method of SBTarget/SBModule
    returns a SBType.

    SBType supports the eq/ne operator. For example,

    main.cpp:

    class Task {
    public:
        int id;
        Task *next;
        Task(int i, Task *n):
            id(i),
            next(n)
        {}
    };

    int main (int argc, char const *argv[])
    {
        Task *task_head = new Task(-1, NULL);
        Task *task1 = new Task(1, NULL);
        Task *task2 = new Task(2, NULL);
        Task *task3 = new Task(3, NULL); // Orphaned.
        Task *task4 = new Task(4, NULL);
        Task *task5 = new Task(5, NULL);

        task_head->next = task1;
        task1->next = task2;
        task2->next = task4;
        task4->next = task5;

        int total = 0;
        Task *t = task_head;
        while (t != NULL) {
            if (t->id >= 0)
                ++total;
            t = t->next;
        }
        printf('We have a total number of %d tasks\n', total);

        // This corresponds to an empty task list.
        Task *empty_task_head = new Task(-1, NULL);

        return 0; // Break at this line
    }

    find_type.py:

            # Get the type 'Task'.
            task_type = target.FindFirstType('Task')
            self.assertTrue(task_type)

            # Get the variable 'task_head'.
            frame0.FindVariable('task_head')
            task_head_type = task_head.GetType()
            self.assertTrue(task_head_type.IsPointerType())

            # task_head_type is 'Task *'.
            task_pointer_type = task_type.GetPointerType()
            self.assertTrue(task_head_type == task_pointer_type)

            # Get the child mmember 'id' from 'task_head'.
            id = task_head.GetChildMemberWithName('id')
            id_type = id.GetType()

            # SBType.GetBasicType() takes an enum 'BasicType' (lldb-enumerations.h).
            int_type = id_type.GetBasicType(lldb.eBasicTypeInt)
            # id_type and int_type should be the same type!
            self.assertTrue(id_type == int_type)

    ...

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBType, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBType, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetNumberChildren', 'GetChildAtIndex')
    def __len__(self): return self.GetNumberChildren()
    def __eq__(self, other): return isinstance(other, SBType) and self.GetByteSize() == other.GetByteSize() and self.GetName() == other.GetName()
    def __ne__(self, other): return not self.__eq__(other)
    def __init__(self, *args):
        """
        __init__(lldb::SBType self) -> SBType
        __init__(lldb::SBType self, SBType rhs) -> SBType
        """
        this = _lldb.new_SBType(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBType
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBType self) -> bool"""
        return _lldb.SBType_IsValid(self)


    def GetByteSize(self):
        """GetByteSize(SBType self) -> uint64_t"""
        return _lldb.SBType_GetByteSize(self)


    def IsPointerType(self):
        """IsPointerType(SBType self) -> bool"""
        return _lldb.SBType_IsPointerType(self)


    def IsReferenceType(self):
        """IsReferenceType(SBType self) -> bool"""
        return _lldb.SBType_IsReferenceType(self)


    def IsFunctionType(self):
        """IsFunctionType(SBType self) -> bool"""
        return _lldb.SBType_IsFunctionType(self)


    def IsPolymorphicClass(self):
        """IsPolymorphicClass(SBType self) -> bool"""
        return _lldb.SBType_IsPolymorphicClass(self)


    def IsArrayType(self):
        """IsArrayType(SBType self) -> bool"""
        return _lldb.SBType_IsArrayType(self)


    def IsVectorType(self):
        """IsVectorType(SBType self) -> bool"""
        return _lldb.SBType_IsVectorType(self)


    def IsTypedefType(self):
        """IsTypedefType(SBType self) -> bool"""
        return _lldb.SBType_IsTypedefType(self)


    def IsAnonymousType(self):
        """IsAnonymousType(SBType self) -> bool"""
        return _lldb.SBType_IsAnonymousType(self)


    def GetPointerType(self):
        """GetPointerType(SBType self) -> SBType"""
        return _lldb.SBType_GetPointerType(self)


    def GetPointeeType(self):
        """GetPointeeType(SBType self) -> SBType"""
        return _lldb.SBType_GetPointeeType(self)


    def GetReferenceType(self):
        """GetReferenceType(SBType self) -> SBType"""
        return _lldb.SBType_GetReferenceType(self)


    def GetTypedefedType(self):
        """GetTypedefedType(SBType self) -> SBType"""
        return _lldb.SBType_GetTypedefedType(self)


    def GetDereferencedType(self):
        """GetDereferencedType(SBType self) -> SBType"""
        return _lldb.SBType_GetDereferencedType(self)


    def GetUnqualifiedType(self):
        """GetUnqualifiedType(SBType self) -> SBType"""
        return _lldb.SBType_GetUnqualifiedType(self)


    def GetCanonicalType(self):
        """GetCanonicalType(SBType self) -> SBType"""
        return _lldb.SBType_GetCanonicalType(self)


    def GetArrayElementType(self):
        """GetArrayElementType(SBType self) -> SBType"""
        return _lldb.SBType_GetArrayElementType(self)


    def GetArrayType(self, size):
        """GetArrayType(SBType self, uint64_t size) -> SBType"""
        return _lldb.SBType_GetArrayType(self, size)


    def GetVectorElementType(self):
        """GetVectorElementType(SBType self) -> SBType"""
        return _lldb.SBType_GetVectorElementType(self)


    def GetBasicType(self, *args):
        """
        GetBasicType(SBType self) -> lldb::BasicType
        GetBasicType(SBType self, lldb::BasicType type) -> SBType
        """
        return _lldb.SBType_GetBasicType(self, *args)


    def GetNumberOfFields(self):
        """GetNumberOfFields(SBType self) -> uint32_t"""
        return _lldb.SBType_GetNumberOfFields(self)


    def GetNumberOfDirectBaseClasses(self):
        """GetNumberOfDirectBaseClasses(SBType self) -> uint32_t"""
        return _lldb.SBType_GetNumberOfDirectBaseClasses(self)


    def GetNumberOfVirtualBaseClasses(self):
        """GetNumberOfVirtualBaseClasses(SBType self) -> uint32_t"""
        return _lldb.SBType_GetNumberOfVirtualBaseClasses(self)


    def GetFieldAtIndex(self, idx):
        """GetFieldAtIndex(SBType self, uint32_t idx) -> SBTypeMember"""
        return _lldb.SBType_GetFieldAtIndex(self, idx)


    def GetDirectBaseClassAtIndex(self, idx):
        """GetDirectBaseClassAtIndex(SBType self, uint32_t idx) -> SBTypeMember"""
        return _lldb.SBType_GetDirectBaseClassAtIndex(self, idx)


    def GetVirtualBaseClassAtIndex(self, idx):
        """GetVirtualBaseClassAtIndex(SBType self, uint32_t idx) -> SBTypeMember"""
        return _lldb.SBType_GetVirtualBaseClassAtIndex(self, idx)


    def GetEnumMembers(self):
        """GetEnumMembers(SBType self) -> SBTypeEnumMemberList"""
        return _lldb.SBType_GetEnumMembers(self)


    def GetName(self):
        """GetName(SBType self) -> str const *"""
        return _lldb.SBType_GetName(self)


    def GetDisplayTypeName(self):
        """GetDisplayTypeName(SBType self) -> str const *"""
        return _lldb.SBType_GetDisplayTypeName(self)


    def GetTypeClass(self):
        """GetTypeClass(SBType self) -> lldb::TypeClass"""
        return _lldb.SBType_GetTypeClass(self)


    def GetNumberOfTemplateArguments(self):
        """GetNumberOfTemplateArguments(SBType self) -> uint32_t"""
        return _lldb.SBType_GetNumberOfTemplateArguments(self)


    def GetTemplateArgumentType(self, idx):
        """GetTemplateArgumentType(SBType self, uint32_t idx) -> SBType"""
        return _lldb.SBType_GetTemplateArgumentType(self, idx)


    def GetTemplateArgumentKind(self, idx):
        """GetTemplateArgumentKind(SBType self, uint32_t idx) -> lldb::TemplateArgumentKind"""
        return _lldb.SBType_GetTemplateArgumentKind(self, idx)


    def GetFunctionReturnType(self):
        """GetFunctionReturnType(SBType self) -> SBType"""
        return _lldb.SBType_GetFunctionReturnType(self)


    def GetFunctionArgumentTypes(self):
        """GetFunctionArgumentTypes(SBType self) -> SBTypeList"""
        return _lldb.SBType_GetFunctionArgumentTypes(self)


    def GetNumberOfMemberFunctions(self):
        """GetNumberOfMemberFunctions(SBType self) -> uint32_t"""
        return _lldb.SBType_GetNumberOfMemberFunctions(self)


    def GetMemberFunctionAtIndex(self, idx):
        """GetMemberFunctionAtIndex(SBType self, uint32_t idx) -> SBTypeMemberFunction"""
        return _lldb.SBType_GetMemberFunctionAtIndex(self, idx)


    def IsTypeComplete(self):
        """IsTypeComplete(SBType self) -> bool"""
        return _lldb.SBType_IsTypeComplete(self)


    def GetTypeFlags(self):
        """GetTypeFlags(SBType self) -> uint32_t"""
        return _lldb.SBType_GetTypeFlags(self)


    def template_arg_array(self):
        num_args = self.num_template_args
        if num_args:
            template_args = []
            for i in range(num_args):
                template_args.append(self.GetTemplateArgumentType(i))
            return template_args
        return None

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name for this type as a string.''')

    __swig_getmethods__["size"] = GetByteSize
    if _newclass: size = property(GetByteSize, None, doc='''A read only property that returns size in bytes for this type as an integer.''')

    __swig_getmethods__["is_pointer"] = IsPointerType
    if _newclass: is_pointer = property(IsPointerType, None, doc='''A read only property that returns a boolean value that indicates if this type is a pointer type.''')

    __swig_getmethods__["is_reference"] = IsReferenceType
    if _newclass: is_reference = property(IsReferenceType, None, doc='''A read only property that returns a boolean value that indicates if this type is a reference type.''')

    __swig_getmethods__["is_function"] = IsFunctionType
    if _newclass: is_reference = property(IsReferenceType, None, doc='''A read only property that returns a boolean value that indicates if this type is a function type.''')

    __swig_getmethods__["num_fields"] = GetNumberOfFields
    if _newclass: num_fields = property(GetNumberOfFields, None, doc='''A read only property that returns number of fields in this type as an integer.''')

    __swig_getmethods__["num_bases"] = GetNumberOfDirectBaseClasses
    if _newclass: num_bases = property(GetNumberOfDirectBaseClasses, None, doc='''A read only property that returns number of direct base classes in this type as an integer.''')

    __swig_getmethods__["num_vbases"] = GetNumberOfVirtualBaseClasses
    if _newclass: num_vbases = property(GetNumberOfVirtualBaseClasses, None, doc='''A read only property that returns number of virtual base classes in this type as an integer.''')

    __swig_getmethods__["num_template_args"] = GetNumberOfTemplateArguments
    if _newclass: num_template_args = property(GetNumberOfTemplateArguments, None, doc='''A read only property that returns number of template arguments in this type as an integer.''')

    __swig_getmethods__["template_args"] = template_arg_array
    if _newclass: template_args = property(template_arg_array, None, doc='''A read only property that returns a list() of lldb.SBType objects that represent all template arguments in this type.''')

    __swig_getmethods__["type"] = GetTypeClass
    if _newclass: type = property(GetTypeClass, None, doc='''A read only property that returns an lldb enumeration value (see enumerations that start with "lldb.eTypeClass") that represents a classification for this type.''')

    __swig_getmethods__["is_complete"] = IsTypeComplete
    if _newclass: is_complete = property(IsTypeComplete, None, doc='''A read only property that returns a boolean value that indicates if this type is a complete type (True) or a forward declaration (False).''')

    def get_bases_array(self):
        '''An accessor function that returns a list() that contains all direct base classes in a lldb.SBType object.'''
        bases = []
        for idx in range(self.GetNumberOfDirectBaseClasses()):
            bases.append(self.GetDirectBaseClassAtIndex(idx))
        return bases

    def get_vbases_array(self):
        '''An accessor function that returns a list() that contains all fields in a lldb.SBType object.'''
        vbases = []
        for idx in range(self.GetNumberOfVirtualBaseClasses()):
            vbases.append(self.GetVirtualBaseClassAtIndex(idx))
        return vbases

    def get_fields_array(self):
        '''An accessor function that returns a list() that contains all fields in a lldb.SBType object.'''
        fields = []
        for idx in range(self.GetNumberOfFields()):
            fields.append(self.GetFieldAtIndex(idx))
        return fields

    def get_members_array(self):
        '''An accessor function that returns a list() that contains all members (base classes and fields) in a lldb.SBType object in ascending bit offset order.'''
        members = []
        bases = self.get_bases_array()
        fields = self.get_fields_array()
        vbases = self.get_vbases_array()
        for base in bases:
            bit_offset = base.bit_offset
            added = False
            for idx, member in enumerate(members):
                if member.bit_offset > bit_offset:
                    members.insert(idx, base)
                    added = True
                    break
            if not added:
                members.append(base)
        for vbase in vbases:
            bit_offset = vbase.bit_offset
            added = False
            for idx, member in enumerate(members):
                if member.bit_offset > bit_offset:
                    members.insert(idx, vbase)
                    added = True
                    break
            if not added:
                members.append(vbase)
        for field in fields:
            bit_offset = field.bit_offset
            added = False
            for idx, member in enumerate(members):
                if member.bit_offset > bit_offset:
                    members.insert(idx, field)
                    added = True
                    break
            if not added:
                members.append(field)
        return members

    def get_enum_members_array(self):
        '''An accessor function that returns a list() that contains all enum members in an lldb.SBType object.'''
        enum_members_list = []
        sb_enum_members = self.GetEnumMembers()
        for idx in range(sb_enum_members.GetSize()):
            enum_members_list.append(sb_enum_members.GetTypeEnumMemberAtIndex(idx))
        return enum_members_list

    __swig_getmethods__["bases"] = get_bases_array
    if _newclass: bases = property(get_bases_array, None, doc='''A read only property that returns a list() of lldb.SBTypeMember objects that represent all of the direct base classes for this type.''')

    __swig_getmethods__["vbases"] = get_vbases_array
    if _newclass: vbases = property(get_vbases_array, None, doc='''A read only property that returns a list() of lldb.SBTypeMember objects that represent all of the virtual base classes for this type.''')

    __swig_getmethods__["fields"] = get_fields_array
    if _newclass: fields = property(get_fields_array, None, doc='''A read only property that returns a list() of lldb.SBTypeMember objects that represent all of the fields for this type.''')

    __swig_getmethods__["members"] = get_members_array
    if _newclass: members = property(get_members_array, None, doc='''A read only property that returns a list() of all lldb.SBTypeMember objects that represent all of the base classes, virtual base classes and fields for this type in ascending bit offset order.''')

    __swig_getmethods__["enum_members"] = get_enum_members_array
    if _newclass: enum_members = property(get_enum_members_array, None, doc='''A read only property that returns a list() of all lldb.SBTypeEnumMember objects that represent the enum members for this type.''')



    def __str__(self):
        """__str__(SBType self) -> PyObject *"""
        return _lldb.SBType___str__(self)

SBType_swigregister = _lldb.SBType_swigregister
SBType_swigregister(SBType)

class SBTypeList(_object):
    """
    Represents a list of SBTypes.  The FindTypes() method of SBTarget/SBModule
    returns a SBTypeList.

    SBTypeList supports SBType iteration. For example,

    main.cpp:

    class Task {
    public:
        int id;
        Task *next;
        Task(int i, Task *n):
            id(i),
            next(n)
        {}
    };

    ...

    find_type.py:

            # Get the type 'Task'.
            type_list = target.FindTypes('Task')
            self.assertTrue(len(type_list) == 1)
            # To illustrate the SBType iteration.
            for type in type_list:
                # do something with type

    ...

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeList, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetSize', 'GetTypeAtIndex')
    def __len__(self): return self.GetSize()
    def __init__(self):
        """__init__(lldb::SBTypeList self) -> SBTypeList"""
        this = _lldb.new_SBTypeList()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeList self) -> bool"""
        return _lldb.SBTypeList_IsValid(self)


    def Append(self, type):
        """Append(SBTypeList self, SBType type)"""
        return _lldb.SBTypeList_Append(self, type)


    def GetTypeAtIndex(self, index):
        """GetTypeAtIndex(SBTypeList self, uint32_t index) -> SBType"""
        return _lldb.SBTypeList_GetTypeAtIndex(self, index)


    def GetSize(self):
        """GetSize(SBTypeList self) -> uint32_t"""
        return _lldb.SBTypeList_GetSize(self)

    __swig_destroy__ = _lldb.delete_SBTypeList
    __del__ = lambda self: None
SBTypeList_swigregister = _lldb.SBTypeList_swigregister
SBTypeList_swigregister(SBTypeList)

class SBTypeCategory(_object):
    """
    Represents a category that can contain formatters for types.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeCategory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeCategory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeCategory self) -> SBTypeCategory
        __init__(lldb::SBTypeCategory self, SBTypeCategory rhs) -> SBTypeCategory
        """
        this = _lldb.new_SBTypeCategory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeCategory
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeCategory self) -> bool"""
        return _lldb.SBTypeCategory_IsValid(self)


    def GetEnabled(self):
        """GetEnabled(SBTypeCategory self) -> bool"""
        return _lldb.SBTypeCategory_GetEnabled(self)


    def SetEnabled(self, arg2):
        """SetEnabled(SBTypeCategory self, bool arg2)"""
        return _lldb.SBTypeCategory_SetEnabled(self, arg2)


    def GetName(self):
        """GetName(SBTypeCategory self) -> str const *"""
        return _lldb.SBTypeCategory_GetName(self)


    def GetLanguageAtIndex(self, idx):
        """GetLanguageAtIndex(SBTypeCategory self, uint32_t idx) -> lldb::LanguageType"""
        return _lldb.SBTypeCategory_GetLanguageAtIndex(self, idx)


    def GetNumLanguages(self):
        """GetNumLanguages(SBTypeCategory self) -> uint32_t"""
        return _lldb.SBTypeCategory_GetNumLanguages(self)


    def AddLanguage(self, language):
        """AddLanguage(SBTypeCategory self, lldb::LanguageType language)"""
        return _lldb.SBTypeCategory_AddLanguage(self, language)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeCategory self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeCategory_GetDescription(self, description, description_level)


    def GetNumFormats(self):
        """GetNumFormats(SBTypeCategory self) -> uint32_t"""
        return _lldb.SBTypeCategory_GetNumFormats(self)


    def GetNumSummaries(self):
        """GetNumSummaries(SBTypeCategory self) -> uint32_t"""
        return _lldb.SBTypeCategory_GetNumSummaries(self)


    def GetNumFilters(self):
        """GetNumFilters(SBTypeCategory self) -> uint32_t"""
        return _lldb.SBTypeCategory_GetNumFilters(self)


    def GetNumSynthetics(self):
        """GetNumSynthetics(SBTypeCategory self) -> uint32_t"""
        return _lldb.SBTypeCategory_GetNumSynthetics(self)


    def GetTypeNameSpecifierForFilterAtIndex(self, arg2):
        """GetTypeNameSpecifierForFilterAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeNameSpecifier"""
        return _lldb.SBTypeCategory_GetTypeNameSpecifierForFilterAtIndex(self, arg2)


    def GetTypeNameSpecifierForFormatAtIndex(self, arg2):
        """GetTypeNameSpecifierForFormatAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeNameSpecifier"""
        return _lldb.SBTypeCategory_GetTypeNameSpecifierForFormatAtIndex(self, arg2)


    def GetTypeNameSpecifierForSummaryAtIndex(self, arg2):
        """GetTypeNameSpecifierForSummaryAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeNameSpecifier"""
        return _lldb.SBTypeCategory_GetTypeNameSpecifierForSummaryAtIndex(self, arg2)


    def GetTypeNameSpecifierForSyntheticAtIndex(self, arg2):
        """GetTypeNameSpecifierForSyntheticAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeNameSpecifier"""
        return _lldb.SBTypeCategory_GetTypeNameSpecifierForSyntheticAtIndex(self, arg2)


    def GetFilterForType(self, arg2):
        """GetFilterForType(SBTypeCategory self, SBTypeNameSpecifier arg2) -> SBTypeFilter"""
        return _lldb.SBTypeCategory_GetFilterForType(self, arg2)


    def GetFormatForType(self, arg2):
        """GetFormatForType(SBTypeCategory self, SBTypeNameSpecifier arg2) -> SBTypeFormat"""
        return _lldb.SBTypeCategory_GetFormatForType(self, arg2)


    def GetSummaryForType(self, arg2):
        """GetSummaryForType(SBTypeCategory self, SBTypeNameSpecifier arg2) -> SBTypeSummary"""
        return _lldb.SBTypeCategory_GetSummaryForType(self, arg2)


    def GetSyntheticForType(self, arg2):
        """GetSyntheticForType(SBTypeCategory self, SBTypeNameSpecifier arg2) -> SBTypeSynthetic"""
        return _lldb.SBTypeCategory_GetSyntheticForType(self, arg2)


    def GetFilterAtIndex(self, arg2):
        """GetFilterAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeFilter"""
        return _lldb.SBTypeCategory_GetFilterAtIndex(self, arg2)


    def GetFormatAtIndex(self, arg2):
        """GetFormatAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeFormat"""
        return _lldb.SBTypeCategory_GetFormatAtIndex(self, arg2)


    def GetSummaryAtIndex(self, arg2):
        """GetSummaryAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeSummary"""
        return _lldb.SBTypeCategory_GetSummaryAtIndex(self, arg2)


    def GetSyntheticAtIndex(self, arg2):
        """GetSyntheticAtIndex(SBTypeCategory self, uint32_t arg2) -> SBTypeSynthetic"""
        return _lldb.SBTypeCategory_GetSyntheticAtIndex(self, arg2)


    def AddTypeFormat(self, arg2, arg3):
        """AddTypeFormat(SBTypeCategory self, SBTypeNameSpecifier arg2, SBTypeFormat arg3) -> bool"""
        return _lldb.SBTypeCategory_AddTypeFormat(self, arg2, arg3)


    def DeleteTypeFormat(self, arg2):
        """DeleteTypeFormat(SBTypeCategory self, SBTypeNameSpecifier arg2) -> bool"""
        return _lldb.SBTypeCategory_DeleteTypeFormat(self, arg2)


    def AddTypeSummary(self, arg2, arg3):
        """AddTypeSummary(SBTypeCategory self, SBTypeNameSpecifier arg2, SBTypeSummary arg3) -> bool"""
        return _lldb.SBTypeCategory_AddTypeSummary(self, arg2, arg3)


    def DeleteTypeSummary(self, arg2):
        """DeleteTypeSummary(SBTypeCategory self, SBTypeNameSpecifier arg2) -> bool"""
        return _lldb.SBTypeCategory_DeleteTypeSummary(self, arg2)


    def AddTypeFilter(self, arg2, arg3):
        """AddTypeFilter(SBTypeCategory self, SBTypeNameSpecifier arg2, SBTypeFilter arg3) -> bool"""
        return _lldb.SBTypeCategory_AddTypeFilter(self, arg2, arg3)


    def DeleteTypeFilter(self, arg2):
        """DeleteTypeFilter(SBTypeCategory self, SBTypeNameSpecifier arg2) -> bool"""
        return _lldb.SBTypeCategory_DeleteTypeFilter(self, arg2)


    def AddTypeSynthetic(self, arg2, arg3):
        """AddTypeSynthetic(SBTypeCategory self, SBTypeNameSpecifier arg2, SBTypeSynthetic arg3) -> bool"""
        return _lldb.SBTypeCategory_AddTypeSynthetic(self, arg2, arg3)


    def DeleteTypeSynthetic(self, arg2):
        """DeleteTypeSynthetic(SBTypeCategory self, SBTypeNameSpecifier arg2) -> bool"""
        return _lldb.SBTypeCategory_DeleteTypeSynthetic(self, arg2)



    class formatters_access_class(object):
        '''A helper object that will lazily hand out formatters for a specific category.'''
        def __init__(self, sbcategory, get_count_function, get_at_index_function, get_by_name_function):
            self.sbcategory = sbcategory
            self.get_count_function = get_count_function
            self.get_at_index_function = get_at_index_function
            self.get_by_name_function = get_by_name_function
            self.regex_type = type(re.compile('.'))


        def __len__(self):
            if self.sbcategory and self.get_count_function:
                return int(self.get_count_function(self.sbcategory))
            return 0

        def __getitem__(self, key):
            num_items = len(self)
            if type(key) is int:
                if key < num_items:
                    return self.get_at_index_function(self.sbcategory,key)
            elif type(key) is str:
                return self.get_by_name_function(self.sbcategory,SBTypeNameSpecifier(key))
            elif isinstance(key,self.regex_type):
                return self.get_by_name_function(self.sbcategory,SBTypeNameSpecifier(key.pattern,True))
            else:
                print("error: unsupported item type: %s" % type(key))
            return None

    def get_formats_access_object(self):
        '''An accessor function that returns an accessor object which allows lazy format access from a lldb.SBTypeCategory object.'''
        return self.formatters_access_class (self,self.__class__.GetNumFormats,self.__class__.GetFormatAtIndex,self.__class__.GetFormatForType)

    def get_formats_array(self):
        '''An accessor function that returns a list() that contains all formats in a lldb.SBCategory object.'''
        formats = []
        for idx in range(self.GetNumFormats()):
            formats.append(self.GetFormatAtIndex(idx))
        return formats

    def get_summaries_access_object(self):
        '''An accessor function that returns an accessor object which allows lazy summary access from a lldb.SBTypeCategory object.'''
        return self.formatters_access_class (self,self.__class__.GetNumSummaries,self.__class__.GetSummaryAtIndex,self.__class__.GetSummaryForType)

    def get_summaries_array(self):
        '''An accessor function that returns a list() that contains all summaries in a lldb.SBCategory object.'''
        summaries = []
        for idx in range(self.GetNumSummaries()):
            summaries.append(self.GetSummaryAtIndex(idx))
        return summaries

    def get_synthetics_access_object(self):
        '''An accessor function that returns an accessor object which allows lazy synthetic children provider access from a lldb.SBTypeCategory object.'''
        return self.formatters_access_class (self,self.__class__.GetNumSynthetics,self.__class__.GetSyntheticAtIndex,self.__class__.GetSyntheticForType)

    def get_synthetics_array(self):
        '''An accessor function that returns a list() that contains all synthetic children providers in a lldb.SBCategory object.'''
        synthetics = []
        for idx in range(self.GetNumSynthetics()):
            synthetics.append(self.GetSyntheticAtIndex(idx))
        return synthetics

    def get_filters_access_object(self):
        '''An accessor function that returns an accessor object which allows lazy filter access from a lldb.SBTypeCategory object.'''
        return self.formatters_access_class (self,self.__class__.GetNumFilters,self.__class__.GetFilterAtIndex,self.__class__.GetFilterForType)

    def get_filters_array(self):
        '''An accessor function that returns a list() that contains all filters in a lldb.SBCategory object.'''
        filters = []
        for idx in range(self.GetNumFilters()):
            filters.append(self.GetFilterAtIndex(idx))
        return filters

    __swig_getmethods__["formats"] = get_formats_array
    if _newclass: formats = property(get_formats_array, None, doc='''A read only property that returns a list() of lldb.SBTypeFormat objects contained in this category''')

    __swig_getmethods__["format"] = get_formats_access_object
    if _newclass: format = property(get_formats_access_object, None, doc=r'''A read only property that returns an object that you can use to look for formats by index or type name.''')

    __swig_getmethods__["summaries"] = get_summaries_array
    if _newclass: summaries = property(get_summaries_array, None, doc='''A read only property that returns a list() of lldb.SBTypeSummary objects contained in this category''')

    __swig_getmethods__["summary"] = get_summaries_access_object
    if _newclass: summary = property(get_summaries_access_object, None, doc=r'''A read only property that returns an object that you can use to look for summaries by index or type name or regular expression.''')

    __swig_getmethods__["filters"] = get_filters_array
    if _newclass: filters = property(get_filters_array, None, doc='''A read only property that returns a list() of lldb.SBTypeFilter objects contained in this category''')

    __swig_getmethods__["filter"] = get_filters_access_object
    if _newclass: filter = property(get_filters_access_object, None, doc=r'''A read only property that returns an object that you can use to look for filters by index or type name or regular expression.''')

    __swig_getmethods__["synthetics"] = get_synthetics_array
    if _newclass: synthetics = property(get_synthetics_array, None, doc='''A read only property that returns a list() of lldb.SBTypeSynthetic objects contained in this category''')

    __swig_getmethods__["synthetic"] = get_synthetics_access_object
    if _newclass: synthetic = property(get_synthetics_access_object, None, doc=r'''A read only property that returns an object that you can use to look for synthetic children provider by index or type name or regular expression.''')

    __swig_getmethods__["num_formats"] = GetNumFormats
    if _newclass: num_formats = property(GetNumFormats, None)
    __swig_getmethods__["num_summaries"] = GetNumSummaries
    if _newclass: num_summaries = property(GetNumSummaries, None)
    __swig_getmethods__["num_filters"] = GetNumFilters
    if _newclass: num_filters = property(GetNumFilters, None)
    __swig_getmethods__["num_synthetics"] = GetNumSynthetics
    if _newclass: num_synthetics = property(GetNumSynthetics, None)

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None)

    __swig_getmethods__["enabled"] = GetEnabled
    __swig_setmethods__["enabled"] = SetEnabled
    if _newclass: enabled = property(GetEnabled, SetEnabled)


    def __str__(self):
        """__str__(SBTypeCategory self) -> PyObject *"""
        return _lldb.SBTypeCategory___str__(self)

SBTypeCategory_swigregister = _lldb.SBTypeCategory_swigregister
SBTypeCategory_swigregister(SBTypeCategory)

class SBTypeEnumMember(_object):
    """Represents a member of an enum in lldb."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeEnumMember, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeEnumMember, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeEnumMember self) -> SBTypeEnumMember
        __init__(lldb::SBTypeEnumMember self, SBTypeEnumMember rhs) -> SBTypeEnumMember
        """
        this = _lldb.new_SBTypeEnumMember(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeEnumMember
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeEnumMember self) -> bool"""
        return _lldb.SBTypeEnumMember_IsValid(self)


    def GetValueAsSigned(self):
        """GetValueAsSigned(SBTypeEnumMember self) -> int64_t"""
        return _lldb.SBTypeEnumMember_GetValueAsSigned(self)


    def GetValueAsUnsigned(self):
        """GetValueAsUnsigned(SBTypeEnumMember self) -> uint64_t"""
        return _lldb.SBTypeEnumMember_GetValueAsUnsigned(self)


    def GetName(self):
        """GetName(SBTypeEnumMember self) -> str const *"""
        return _lldb.SBTypeEnumMember_GetName(self)


    def GetType(self):
        """GetType(SBTypeEnumMember self) -> SBType"""
        return _lldb.SBTypeEnumMember_GetType(self)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeEnumMember self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeEnumMember_GetDescription(self, description, description_level)


    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name for this enum member as a string.''')

    __swig_getmethods__["type"] = GetType
    if _newclass: type = property(GetType, None, doc='''A read only property that returns an lldb object that represents the type (lldb.SBType) for this enum member.''')

    __swig_getmethods__["signed"] = GetValueAsSigned
    if _newclass: signed = property(GetValueAsSigned, None, doc='''A read only property that returns the value of this enum member as a signed integer.''')

    __swig_getmethods__["unsigned"] = GetValueAsUnsigned
    if _newclass: unsigned = property(GetValueAsUnsigned, None, doc='''A read only property that returns the value of this enum member as a unsigned integer.''')


    def __str__(self):
        """__str__(SBTypeEnumMember self) -> PyObject *"""
        return _lldb.SBTypeEnumMember___str__(self)

SBTypeEnumMember_swigregister = _lldb.SBTypeEnumMember_swigregister
SBTypeEnumMember_swigregister(SBTypeEnumMember)

class SBTypeEnumMemberList(_object):
    """Represents a list of SBTypeEnumMembers."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeEnumMemberList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeEnumMemberList, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeEnumMemberList self) -> SBTypeEnumMemberList
        __init__(lldb::SBTypeEnumMemberList self, SBTypeEnumMemberList rhs) -> SBTypeEnumMemberList
        """
        this = _lldb.new_SBTypeEnumMemberList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeEnumMemberList
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeEnumMemberList self) -> bool"""
        return _lldb.SBTypeEnumMemberList_IsValid(self)


    def Append(self, entry):
        """Append(SBTypeEnumMemberList self, SBTypeEnumMember entry)"""
        return _lldb.SBTypeEnumMemberList_Append(self, entry)


    def GetTypeEnumMemberAtIndex(self, index):
        """GetTypeEnumMemberAtIndex(SBTypeEnumMemberList self, uint32_t index) -> SBTypeEnumMember"""
        return _lldb.SBTypeEnumMemberList_GetTypeEnumMemberAtIndex(self, index)


    def GetSize(self):
        """GetSize(SBTypeEnumMemberList self) -> uint32_t"""
        return _lldb.SBTypeEnumMemberList_GetSize(self)

SBTypeEnumMemberList_swigregister = _lldb.SBTypeEnumMemberList_swigregister
SBTypeEnumMemberList_swigregister(SBTypeEnumMemberList)

class SBTypeFilter(_object):
    """
    Represents a filter that can be associated to one or more types.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeFilter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeFilter self) -> SBTypeFilter
        __init__(lldb::SBTypeFilter self, uint32_t options) -> SBTypeFilter
        __init__(lldb::SBTypeFilter self, SBTypeFilter rhs) -> SBTypeFilter
        """
        this = _lldb.new_SBTypeFilter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeFilter
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeFilter self) -> bool"""
        return _lldb.SBTypeFilter_IsValid(self)


    def IsEqualTo(self, rhs):
        """IsEqualTo(SBTypeFilter self, SBTypeFilter rhs) -> bool"""
        return _lldb.SBTypeFilter_IsEqualTo(self, rhs)


    def GetNumberOfExpressionPaths(self):
        """GetNumberOfExpressionPaths(SBTypeFilter self) -> uint32_t"""
        return _lldb.SBTypeFilter_GetNumberOfExpressionPaths(self)


    def GetExpressionPathAtIndex(self, i):
        """GetExpressionPathAtIndex(SBTypeFilter self, uint32_t i) -> str const *"""
        return _lldb.SBTypeFilter_GetExpressionPathAtIndex(self, i)


    def ReplaceExpressionPathAtIndex(self, i, item):
        """ReplaceExpressionPathAtIndex(SBTypeFilter self, uint32_t i, str const * item) -> bool"""
        return _lldb.SBTypeFilter_ReplaceExpressionPathAtIndex(self, i, item)


    def AppendExpressionPath(self, item):
        """AppendExpressionPath(SBTypeFilter self, str const * item)"""
        return _lldb.SBTypeFilter_AppendExpressionPath(self, item)


    def Clear(self):
        """Clear(SBTypeFilter self)"""
        return _lldb.SBTypeFilter_Clear(self)


    def GetOptions(self):
        """GetOptions(SBTypeFilter self) -> uint32_t"""
        return _lldb.SBTypeFilter_GetOptions(self)


    def SetOptions(self, arg2):
        """SetOptions(SBTypeFilter self, uint32_t arg2)"""
        return _lldb.SBTypeFilter_SetOptions(self, arg2)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeFilter self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeFilter_GetDescription(self, description, description_level)


    def __eq__(self, rhs):
        """__eq__(SBTypeFilter self, SBTypeFilter rhs) -> bool"""
        return _lldb.SBTypeFilter___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBTypeFilter self, SBTypeFilter rhs) -> bool"""
        return _lldb.SBTypeFilter___ne__(self, rhs)


    __swig_getmethods__["options"] = GetOptions
    __swig_setmethods__["options"] = SetOptions
    if _newclass: options = property(GetOptions, SetOptions)

    __swig_getmethods__["count"] = GetNumberOfExpressionPaths
    if _newclass: count = property(GetNumberOfExpressionPaths, None)


    def __str__(self):
        """__str__(SBTypeFilter self) -> PyObject *"""
        return _lldb.SBTypeFilter___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBTypeFilter_swigregister = _lldb.SBTypeFilter_swigregister
SBTypeFilter_swigregister(SBTypeFilter)

class SBTypeFormat(_object):
    """
    Represents a format that can be associated to one or more types.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeFormat, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeFormat, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeFormat self) -> SBTypeFormat
        __init__(lldb::SBTypeFormat self, lldb::Format format, uint32_t options) -> SBTypeFormat
        __init__(lldb::SBTypeFormat self, lldb::Format format) -> SBTypeFormat
        __init__(lldb::SBTypeFormat self, str const * type, uint32_t options) -> SBTypeFormat
        __init__(lldb::SBTypeFormat self, str const * type) -> SBTypeFormat
        __init__(lldb::SBTypeFormat self, SBTypeFormat rhs) -> SBTypeFormat
        """
        this = _lldb.new_SBTypeFormat(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeFormat
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeFormat self) -> bool"""
        return _lldb.SBTypeFormat_IsValid(self)


    def IsEqualTo(self, rhs):
        """IsEqualTo(SBTypeFormat self, SBTypeFormat rhs) -> bool"""
        return _lldb.SBTypeFormat_IsEqualTo(self, rhs)


    def GetFormat(self):
        """GetFormat(SBTypeFormat self) -> lldb::Format"""
        return _lldb.SBTypeFormat_GetFormat(self)


    def GetTypeName(self):
        """GetTypeName(SBTypeFormat self) -> str const *"""
        return _lldb.SBTypeFormat_GetTypeName(self)


    def GetOptions(self):
        """GetOptions(SBTypeFormat self) -> uint32_t"""
        return _lldb.SBTypeFormat_GetOptions(self)


    def SetFormat(self, arg2):
        """SetFormat(SBTypeFormat self, lldb::Format arg2)"""
        return _lldb.SBTypeFormat_SetFormat(self, arg2)


    def SetTypeName(self, arg2):
        """SetTypeName(SBTypeFormat self, str const * arg2)"""
        return _lldb.SBTypeFormat_SetTypeName(self, arg2)


    def SetOptions(self, arg2):
        """SetOptions(SBTypeFormat self, uint32_t arg2)"""
        return _lldb.SBTypeFormat_SetOptions(self, arg2)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeFormat self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeFormat_GetDescription(self, description, description_level)


    def __eq__(self, rhs):
        """__eq__(SBTypeFormat self, SBTypeFormat rhs) -> bool"""
        return _lldb.SBTypeFormat___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBTypeFormat self, SBTypeFormat rhs) -> bool"""
        return _lldb.SBTypeFormat___ne__(self, rhs)


    __swig_getmethods__["format"] = GetFormat
    __swig_setmethods__["format"] = SetFormat
    if _newclass: format = property(GetFormat, SetFormat)

    __swig_getmethods__["options"] = GetOptions
    __swig_setmethods__["options"] = SetOptions
    if _newclass: options = property(GetOptions, SetOptions)            


    def __str__(self):
        """__str__(SBTypeFormat self) -> PyObject *"""
        return _lldb.SBTypeFormat___str__(self)

SBTypeFormat_swigregister = _lldb.SBTypeFormat_swigregister
SBTypeFormat_swigregister(SBTypeFormat)

class SBTypeNameSpecifier(_object):
    """
    Represents a general way to provide a type name to LLDB APIs.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeNameSpecifier, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeNameSpecifier, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeNameSpecifier self) -> SBTypeNameSpecifier
        __init__(lldb::SBTypeNameSpecifier self, str const * name, bool is_regex=False) -> SBTypeNameSpecifier
        __init__(lldb::SBTypeNameSpecifier self, str const * name) -> SBTypeNameSpecifier
        __init__(lldb::SBTypeNameSpecifier self, SBType type) -> SBTypeNameSpecifier
        __init__(lldb::SBTypeNameSpecifier self, SBTypeNameSpecifier rhs) -> SBTypeNameSpecifier
        """
        this = _lldb.new_SBTypeNameSpecifier(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeNameSpecifier
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeNameSpecifier self) -> bool"""
        return _lldb.SBTypeNameSpecifier_IsValid(self)


    def IsEqualTo(self, rhs):
        """IsEqualTo(SBTypeNameSpecifier self, SBTypeNameSpecifier rhs) -> bool"""
        return _lldb.SBTypeNameSpecifier_IsEqualTo(self, rhs)


    def GetName(self):
        """GetName(SBTypeNameSpecifier self) -> str const *"""
        return _lldb.SBTypeNameSpecifier_GetName(self)


    def GetType(self):
        """GetType(SBTypeNameSpecifier self) -> SBType"""
        return _lldb.SBTypeNameSpecifier_GetType(self)


    def IsRegex(self):
        """IsRegex(SBTypeNameSpecifier self) -> bool"""
        return _lldb.SBTypeNameSpecifier_IsRegex(self)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeNameSpecifier self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeNameSpecifier_GetDescription(self, description, description_level)


    def __eq__(self, rhs):
        """__eq__(SBTypeNameSpecifier self, SBTypeNameSpecifier rhs) -> bool"""
        return _lldb.SBTypeNameSpecifier___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBTypeNameSpecifier self, SBTypeNameSpecifier rhs) -> bool"""
        return _lldb.SBTypeNameSpecifier___ne__(self, rhs)


    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None)

    __swig_getmethods__["is_regex"] = IsRegex
    if _newclass: is_regex = property(IsRegex, None)


    def __str__(self):
        """__str__(SBTypeNameSpecifier self) -> PyObject *"""
        return _lldb.SBTypeNameSpecifier___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBTypeNameSpecifier_swigregister = _lldb.SBTypeNameSpecifier_swigregister
SBTypeNameSpecifier_swigregister(SBTypeNameSpecifier)

class SBTypeSummaryOptions(_object):
    """Proxy of C++ lldb::SBTypeSummaryOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeSummaryOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeSummaryOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeSummaryOptions self) -> SBTypeSummaryOptions
        __init__(lldb::SBTypeSummaryOptions self, SBTypeSummaryOptions rhs) -> SBTypeSummaryOptions
        """
        this = _lldb.new_SBTypeSummaryOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeSummaryOptions
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeSummaryOptions self) -> bool"""
        return _lldb.SBTypeSummaryOptions_IsValid(self)


    def GetLanguage(self):
        """GetLanguage(SBTypeSummaryOptions self) -> lldb::LanguageType"""
        return _lldb.SBTypeSummaryOptions_GetLanguage(self)


    def GetCapping(self):
        """GetCapping(SBTypeSummaryOptions self) -> lldb::TypeSummaryCapping"""
        return _lldb.SBTypeSummaryOptions_GetCapping(self)


    def SetLanguage(self, arg2):
        """SetLanguage(SBTypeSummaryOptions self, lldb::LanguageType arg2)"""
        return _lldb.SBTypeSummaryOptions_SetLanguage(self, arg2)


    def SetCapping(self, arg2):
        """SetCapping(SBTypeSummaryOptions self, lldb::TypeSummaryCapping arg2)"""
        return _lldb.SBTypeSummaryOptions_SetCapping(self, arg2)

SBTypeSummaryOptions_swigregister = _lldb.SBTypeSummaryOptions_swigregister
SBTypeSummaryOptions_swigregister(SBTypeSummaryOptions)

class SBTypeSummary(_object):
    """
    Represents a summary that can be associated to one or more types.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeSummary, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeSummary, name)
    __repr__ = _swig_repr

    def CreateWithSummaryString(*args):
        """
        CreateWithSummaryString(str const * data, uint32_t options) -> SBTypeSummary
        CreateWithSummaryString(str const * data) -> SBTypeSummary
        """
        return _lldb.SBTypeSummary_CreateWithSummaryString(*args)

    CreateWithSummaryString = staticmethod(CreateWithSummaryString)

    def CreateWithFunctionName(*args):
        """
        CreateWithFunctionName(str const * data, uint32_t options) -> SBTypeSummary
        CreateWithFunctionName(str const * data) -> SBTypeSummary
        """
        return _lldb.SBTypeSummary_CreateWithFunctionName(*args)

    CreateWithFunctionName = staticmethod(CreateWithFunctionName)

    def CreateWithScriptCode(*args):
        """
        CreateWithScriptCode(str const * data, uint32_t options) -> SBTypeSummary
        CreateWithScriptCode(str const * data) -> SBTypeSummary
        """
        return _lldb.SBTypeSummary_CreateWithScriptCode(*args)

    CreateWithScriptCode = staticmethod(CreateWithScriptCode)

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeSummary self) -> SBTypeSummary
        __init__(lldb::SBTypeSummary self, SBTypeSummary rhs) -> SBTypeSummary
        """
        this = _lldb.new_SBTypeSummary(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeSummary
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeSummary self) -> bool"""
        return _lldb.SBTypeSummary_IsValid(self)


    def IsEqualTo(self, rhs):
        """IsEqualTo(SBTypeSummary self, SBTypeSummary rhs) -> bool"""
        return _lldb.SBTypeSummary_IsEqualTo(self, rhs)


    def IsFunctionCode(self):
        """IsFunctionCode(SBTypeSummary self) -> bool"""
        return _lldb.SBTypeSummary_IsFunctionCode(self)


    def IsFunctionName(self):
        """IsFunctionName(SBTypeSummary self) -> bool"""
        return _lldb.SBTypeSummary_IsFunctionName(self)


    def IsSummaryString(self):
        """IsSummaryString(SBTypeSummary self) -> bool"""
        return _lldb.SBTypeSummary_IsSummaryString(self)


    def GetData(self):
        """GetData(SBTypeSummary self) -> str const *"""
        return _lldb.SBTypeSummary_GetData(self)


    def SetSummaryString(self, data):
        """SetSummaryString(SBTypeSummary self, str const * data)"""
        return _lldb.SBTypeSummary_SetSummaryString(self, data)


    def SetFunctionName(self, data):
        """SetFunctionName(SBTypeSummary self, str const * data)"""
        return _lldb.SBTypeSummary_SetFunctionName(self, data)


    def SetFunctionCode(self, data):
        """SetFunctionCode(SBTypeSummary self, str const * data)"""
        return _lldb.SBTypeSummary_SetFunctionCode(self, data)


    def GetOptions(self):
        """GetOptions(SBTypeSummary self) -> uint32_t"""
        return _lldb.SBTypeSummary_GetOptions(self)


    def SetOptions(self, arg2):
        """SetOptions(SBTypeSummary self, uint32_t arg2)"""
        return _lldb.SBTypeSummary_SetOptions(self, arg2)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeSummary self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeSummary_GetDescription(self, description, description_level)


    def __eq__(self, rhs):
        """__eq__(SBTypeSummary self, SBTypeSummary rhs) -> bool"""
        return _lldb.SBTypeSummary___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBTypeSummary self, SBTypeSummary rhs) -> bool"""
        return _lldb.SBTypeSummary___ne__(self, rhs)


    __swig_getmethods__["options"] = GetOptions
    __swig_setmethods__["options"] = SetOptions
    if _newclass: options = property(GetOptions, SetOptions)

    __swig_getmethods__["is_summary_string"] = IsSummaryString
    if _newclass: is_summary_string = property(IsSummaryString, None)

    __swig_getmethods__["is_function_name"] = IsFunctionName
    if _newclass: is_function_name = property(IsFunctionName, None)

    __swig_getmethods__["is_function_name"] = IsFunctionCode
    if _newclass: is_function_name = property(IsFunctionCode, None)

    __swig_getmethods__["summary_data"] = GetData
    if _newclass: summary_data = property(GetData, None)


    def __str__(self):
        """__str__(SBTypeSummary self) -> PyObject *"""
        return _lldb.SBTypeSummary___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBTypeSummary_swigregister = _lldb.SBTypeSummary_swigregister
SBTypeSummary_swigregister(SBTypeSummary)

def SBTypeSummary_CreateWithSummaryString(*args):
    """
    CreateWithSummaryString(char const * data, uint32_t options) -> SBTypeSummary
    SBTypeSummary_CreateWithSummaryString(char const * data) -> SBTypeSummary
    """
    return _lldb.SBTypeSummary_CreateWithSummaryString(*args)

def SBTypeSummary_CreateWithFunctionName(*args):
    """
    CreateWithFunctionName(char const * data, uint32_t options) -> SBTypeSummary
    SBTypeSummary_CreateWithFunctionName(char const * data) -> SBTypeSummary
    """
    return _lldb.SBTypeSummary_CreateWithFunctionName(*args)

def SBTypeSummary_CreateWithScriptCode(*args):
    """
    CreateWithScriptCode(char const * data, uint32_t options) -> SBTypeSummary
    SBTypeSummary_CreateWithScriptCode(char const * data) -> SBTypeSummary
    """
    return _lldb.SBTypeSummary_CreateWithScriptCode(*args)

class SBTypeSynthetic(_object):
    """
    Represents a summary that can be associated to one or more types.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBTypeSynthetic, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBTypeSynthetic, name)
    __repr__ = _swig_repr

    def CreateWithClassName(*args):
        """
        CreateWithClassName(str const * data, uint32_t options) -> SBTypeSynthetic
        CreateWithClassName(str const * data) -> SBTypeSynthetic
        """
        return _lldb.SBTypeSynthetic_CreateWithClassName(*args)

    CreateWithClassName = staticmethod(CreateWithClassName)

    def CreateWithScriptCode(*args):
        """
        CreateWithScriptCode(str const * data, uint32_t options) -> SBTypeSynthetic
        CreateWithScriptCode(str const * data) -> SBTypeSynthetic
        """
        return _lldb.SBTypeSynthetic_CreateWithScriptCode(*args)

    CreateWithScriptCode = staticmethod(CreateWithScriptCode)

    def __init__(self, *args):
        """
        __init__(lldb::SBTypeSynthetic self) -> SBTypeSynthetic
        __init__(lldb::SBTypeSynthetic self, SBTypeSynthetic rhs) -> SBTypeSynthetic
        """
        this = _lldb.new_SBTypeSynthetic(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBTypeSynthetic
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBTypeSynthetic self) -> bool"""
        return _lldb.SBTypeSynthetic_IsValid(self)


    def IsEqualTo(self, rhs):
        """IsEqualTo(SBTypeSynthetic self, SBTypeSynthetic rhs) -> bool"""
        return _lldb.SBTypeSynthetic_IsEqualTo(self, rhs)


    def IsClassCode(self):
        """IsClassCode(SBTypeSynthetic self) -> bool"""
        return _lldb.SBTypeSynthetic_IsClassCode(self)


    def GetData(self):
        """GetData(SBTypeSynthetic self) -> str const *"""
        return _lldb.SBTypeSynthetic_GetData(self)


    def SetClassName(self, data):
        """SetClassName(SBTypeSynthetic self, str const * data)"""
        return _lldb.SBTypeSynthetic_SetClassName(self, data)


    def SetClassCode(self, data):
        """SetClassCode(SBTypeSynthetic self, str const * data)"""
        return _lldb.SBTypeSynthetic_SetClassCode(self, data)


    def GetOptions(self):
        """GetOptions(SBTypeSynthetic self) -> uint32_t"""
        return _lldb.SBTypeSynthetic_GetOptions(self)


    def SetOptions(self, arg2):
        """SetOptions(SBTypeSynthetic self, uint32_t arg2)"""
        return _lldb.SBTypeSynthetic_SetOptions(self, arg2)


    def GetDescription(self, description, description_level):
        """GetDescription(SBTypeSynthetic self, SBStream description, lldb::DescriptionLevel description_level) -> bool"""
        return _lldb.SBTypeSynthetic_GetDescription(self, description, description_level)


    def __eq__(self, rhs):
        """__eq__(SBTypeSynthetic self, SBTypeSynthetic rhs) -> bool"""
        return _lldb.SBTypeSynthetic___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SBTypeSynthetic self, SBTypeSynthetic rhs) -> bool"""
        return _lldb.SBTypeSynthetic___ne__(self, rhs)


    __swig_getmethods__["options"] = GetOptions
    __swig_setmethods__["options"] = SetOptions
    if _newclass: options = property(GetOptions, SetOptions)

    __swig_getmethods__["contains_code"] = IsClassCode
    if _newclass: contains_code = property(IsClassCode, None)

    __swig_getmethods__["synthetic_data"] = GetData
    if _newclass: synthetic_data = property(GetData, None)


    def __str__(self):
        """__str__(SBTypeSynthetic self) -> PyObject *"""
        return _lldb.SBTypeSynthetic___str__(self)


    def __eq__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return False 

        return getattr(_lldb,self.__class__.__name__+"___eq__")(self, rhs)

    def __ne__(self, rhs):
        if not isinstance(rhs, type(self)): 
            return True 

        return getattr(_lldb,self.__class__.__name__+"___ne__")(self, rhs)

SBTypeSynthetic_swigregister = _lldb.SBTypeSynthetic_swigregister
SBTypeSynthetic_swigregister(SBTypeSynthetic)

def SBTypeSynthetic_CreateWithClassName(*args):
    """
    CreateWithClassName(char const * data, uint32_t options) -> SBTypeSynthetic
    SBTypeSynthetic_CreateWithClassName(char const * data) -> SBTypeSynthetic
    """
    return _lldb.SBTypeSynthetic_CreateWithClassName(*args)

def SBTypeSynthetic_CreateWithScriptCode(*args):
    """
    CreateWithScriptCode(char const * data, uint32_t options) -> SBTypeSynthetic
    SBTypeSynthetic_CreateWithScriptCode(char const * data) -> SBTypeSynthetic
    """
    return _lldb.SBTypeSynthetic_CreateWithScriptCode(*args)

class SBValue(_object):
    """
    Represents the value of a variable, a register, or an expression.

    SBValue supports iteration through its child, which in turn is represented
    as an SBValue.  For example, we can get the general purpose registers of a
    frame as an SBValue, and iterate through all the registers,

        registerSet = frame.registers # Returns an SBValueList.
        for regs in registerSet:
            if 'general purpose registers' in regs.name.lower():
                GPRs = regs
                break

        print('%s (number of children = %d):' % (GPRs.name, GPRs.num_children))
        for reg in GPRs:
            print('Name: ', reg.name, ' Value: ', reg.value)

    produces the output:

    General Purpose Registers (number of children = 21):
    Name:  rax  Value:  0x0000000100000c5c
    Name:  rbx  Value:  0x0000000000000000
    Name:  rcx  Value:  0x00007fff5fbffec0
    Name:  rdx  Value:  0x00007fff5fbffeb8
    Name:  rdi  Value:  0x0000000000000001
    Name:  rsi  Value:  0x00007fff5fbffea8
    Name:  rbp  Value:  0x00007fff5fbffe80
    Name:  rsp  Value:  0x00007fff5fbffe60
    Name:  r8  Value:  0x0000000008668682
    Name:  r9  Value:  0x0000000000000000
    Name:  r10  Value:  0x0000000000001200
    Name:  r11  Value:  0x0000000000000206
    Name:  r12  Value:  0x0000000000000000
    Name:  r13  Value:  0x0000000000000000
    Name:  r14  Value:  0x0000000000000000
    Name:  r15  Value:  0x0000000000000000
    Name:  rip  Value:  0x0000000100000dae
    Name:  rflags  Value:  0x0000000000000206
    Name:  cs  Value:  0x0000000000000027
    Name:  fs  Value:  0x0000000000000010
    Name:  gs  Value:  0x0000000000000048

    See also linked_list_iter() for another perspective on how to iterate through an
    SBValue instance which interprets the value object as representing the head of a
    linked list.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBValue, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBValue, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetNumChildren', 'GetChildAtIndex')
    def __len__(self): return self.GetNumChildren()

    def __eol_test__(val):
        """Default function for end of list test takes an SBValue object.

        Return True if val is invalid or it corresponds to a null pointer.
        Otherwise, return False.
        """
        if not val or val.GetValueAsUnsigned() == 0:
            return True
        else:
            return False

    # ==================================================
    # Iterator for lldb.SBValue treated as a linked list
    # ==================================================
    def linked_list_iter(self, next_item_name, end_of_list_test=__eol_test__):
        """Generator adaptor to support iteration for SBValue as a linked list.

        linked_list_iter() is a special purpose iterator to treat the SBValue as
        the head of a list data structure, where you specify the child member
        name which points to the next item on the list and you specify the
        end-of-list test function which takes an SBValue for an item and returns
        True if EOL is reached and False if not.

        linked_list_iter() also detects infinite loop and bails out early.

        The end_of_list_test arg, if omitted, defaults to the __eol_test__
        function above.

        For example,

        # Get Frame #0.
        ...

        # Get variable 'task_head'.
        task_head = frame0.FindVariable('task_head')
        ...

        for t in task_head.linked_list_iter('next'):
            print t
        """
        if end_of_list_test(self):
            return
        item = self
        visited = set()
        try:
            while not end_of_list_test(item) and not item.GetValueAsUnsigned() in visited:
                visited.add(item.GetValueAsUnsigned())
                yield item
                # Prepare for the next iteration.
                item = item.GetChildMemberWithName(next_item_name)
        except:
            # Exception occurred.  Stop the generator.
            pass

        return

    def __init__(self, *args):
        """
        __init__(lldb::SBValue self) -> SBValue
        __init__(lldb::SBValue self, SBValue rhs) -> SBValue
        """
        this = _lldb.new_SBValue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBValue
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBValue self) -> bool"""
        return _lldb.SBValue_IsValid(self)


    def Clear(self):
        """Clear(SBValue self)"""
        return _lldb.SBValue_Clear(self)


    def GetError(self):
        """GetError(SBValue self) -> SBError"""
        return _lldb.SBValue_GetError(self)


    def GetID(self):
        """GetID(SBValue self) -> lldb::user_id_t"""
        return _lldb.SBValue_GetID(self)


    def GetName(self):
        """GetName(SBValue self) -> str const *"""
        return _lldb.SBValue_GetName(self)


    def GetTypeName(self):
        """GetTypeName(SBValue self) -> str const *"""
        return _lldb.SBValue_GetTypeName(self)


    def GetDisplayTypeName(self):
        """GetDisplayTypeName(SBValue self) -> str const *"""
        return _lldb.SBValue_GetDisplayTypeName(self)


    def GetByteSize(self):
        """GetByteSize(SBValue self) -> size_t"""
        return _lldb.SBValue_GetByteSize(self)


    def IsInScope(self):
        """IsInScope(SBValue self) -> bool"""
        return _lldb.SBValue_IsInScope(self)


    def GetFormat(self):
        """GetFormat(SBValue self) -> lldb::Format"""
        return _lldb.SBValue_GetFormat(self)


    def SetFormat(self, format):
        """SetFormat(SBValue self, lldb::Format format)"""
        return _lldb.SBValue_SetFormat(self, format)


    def GetValue(self):
        """GetValue(SBValue self) -> str const *"""
        return _lldb.SBValue_GetValue(self)


    def GetValueAsSigned(self, *args):
        """
        GetValueAsSigned(SBValue self, SBError error, int64_t fail_value) -> int64_t
        GetValueAsSigned(SBValue self, SBError error) -> int64_t
        GetValueAsSigned(SBValue self, int64_t fail_value) -> int64_t
        GetValueAsSigned(SBValue self) -> int64_t
        """
        return _lldb.SBValue_GetValueAsSigned(self, *args)


    def GetValueAsUnsigned(self, *args):
        """
        GetValueAsUnsigned(SBValue self, SBError error, uint64_t fail_value) -> uint64_t
        GetValueAsUnsigned(SBValue self, SBError error) -> uint64_t
        GetValueAsUnsigned(SBValue self, uint64_t fail_value) -> uint64_t
        GetValueAsUnsigned(SBValue self) -> uint64_t
        """
        return _lldb.SBValue_GetValueAsUnsigned(self, *args)


    def GetValueType(self):
        """GetValueType(SBValue self) -> lldb::ValueType"""
        return _lldb.SBValue_GetValueType(self)


    def GetValueDidChange(self):
        """GetValueDidChange(SBValue self) -> bool"""
        return _lldb.SBValue_GetValueDidChange(self)


    def GetSummary(self, *args):
        """
        GetSummary(SBValue self) -> str const
        GetSummary(SBValue self, SBStream stream, SBTypeSummaryOptions options) -> str const *
        """
        return _lldb.SBValue_GetSummary(self, *args)


    def GetObjectDescription(self):
        """GetObjectDescription(SBValue self) -> str const *"""
        return _lldb.SBValue_GetObjectDescription(self)


    def GetTypeValidatorResult(self):
        """GetTypeValidatorResult(SBValue self) -> str const *"""
        return _lldb.SBValue_GetTypeValidatorResult(self)


    def GetDynamicValue(self, use_dynamic):
        """GetDynamicValue(SBValue self, lldb::DynamicValueType use_dynamic) -> SBValue"""
        return _lldb.SBValue_GetDynamicValue(self, use_dynamic)


    def GetStaticValue(self):
        """GetStaticValue(SBValue self) -> SBValue"""
        return _lldb.SBValue_GetStaticValue(self)


    def GetNonSyntheticValue(self):
        """GetNonSyntheticValue(SBValue self) -> SBValue"""
        return _lldb.SBValue_GetNonSyntheticValue(self)


    def GetPreferDynamicValue(self):
        """GetPreferDynamicValue(SBValue self) -> lldb::DynamicValueType"""
        return _lldb.SBValue_GetPreferDynamicValue(self)


    def SetPreferDynamicValue(self, use_dynamic):
        """SetPreferDynamicValue(SBValue self, lldb::DynamicValueType use_dynamic)"""
        return _lldb.SBValue_SetPreferDynamicValue(self, use_dynamic)


    def GetPreferSyntheticValue(self):
        """GetPreferSyntheticValue(SBValue self) -> bool"""
        return _lldb.SBValue_GetPreferSyntheticValue(self)


    def SetPreferSyntheticValue(self, use_synthetic):
        """SetPreferSyntheticValue(SBValue self, bool use_synthetic)"""
        return _lldb.SBValue_SetPreferSyntheticValue(self, use_synthetic)


    def IsDynamic(self):
        """IsDynamic(SBValue self) -> bool"""
        return _lldb.SBValue_IsDynamic(self)


    def IsSynthetic(self):
        """IsSynthetic(SBValue self) -> bool"""
        return _lldb.SBValue_IsSynthetic(self)


    def IsSyntheticChildrenGenerated(self):
        """IsSyntheticChildrenGenerated(SBValue self) -> bool"""
        return _lldb.SBValue_IsSyntheticChildrenGenerated(self)


    def SetSyntheticChildrenGenerated(self, arg2):
        """SetSyntheticChildrenGenerated(SBValue self, bool arg2)"""
        return _lldb.SBValue_SetSyntheticChildrenGenerated(self, arg2)


    def GetLocation(self):
        """GetLocation(SBValue self) -> str const *"""
        return _lldb.SBValue_GetLocation(self)


    def SetValueFromCString(self, *args):
        """
        SetValueFromCString(SBValue self, str const * value_str) -> bool
        SetValueFromCString(SBValue self, str const * value_str, SBError error) -> bool
        """
        return _lldb.SBValue_SetValueFromCString(self, *args)


    def GetTypeFormat(self):
        """GetTypeFormat(SBValue self) -> SBTypeFormat"""
        return _lldb.SBValue_GetTypeFormat(self)


    def GetTypeSummary(self):
        """GetTypeSummary(SBValue self) -> SBTypeSummary"""
        return _lldb.SBValue_GetTypeSummary(self)


    def GetTypeFilter(self):
        """GetTypeFilter(SBValue self) -> SBTypeFilter"""
        return _lldb.SBValue_GetTypeFilter(self)


    def GetTypeSynthetic(self):
        """GetTypeSynthetic(SBValue self) -> SBTypeSynthetic"""
        return _lldb.SBValue_GetTypeSynthetic(self)


    def GetChildAtIndex(self, *args):
        """
        GetChildAtIndex(SBValue self, uint32_t idx) -> SBValue
        GetChildAtIndex(SBValue self, uint32_t idx, lldb::DynamicValueType use_dynamic, bool can_create_synthetic) -> SBValue


        Get a child value by index from a value.
        
        Structs, unions, classes, arrays and pointers have child
        values that can be access by index. 
        
        Structs and unions access child members using a zero based index
        for each child member. For
        
        Classes reserve the first indexes for base classes that have 
        members (empty base classes are omitted), and all members of the
        current class will then follow the base classes. 
        
        Pointers differ depending on what they point to. If the pointer
        points to a simple type, the child at index zero
        is the only child value available, unless synthetic_allowed 
        is true, in which case the pointer will be used as an array
        and can create 'synthetic' child values using positive or 
        negative indexes. If the pointer points to an aggregate type 
        (an array, class, union, struct), then the pointee is 
        transparently skipped and any children are going to be the indexes
        of the child values within the aggregate type. For example if
        we have a 'Point' type and we have a SBValue that contains a
        pointer to a 'Point' type, then the child at index zero will be
        the 'x' member, and the child at index 1 will be the 'y' member
        (the child at index zero won't be a 'Point' instance).
        
        If you actually need an SBValue that represents the type pointed
        to by a SBValue for which GetType().IsPointeeType() returns true,
        regardless of the pointee type, you can do that with the SBValue.Dereference
        method (or the equivalent deref property).
        
        Arrays have a preset number of children that can be accessed by
        index and will returns invalid child values for indexes that are
        out of bounds unless the synthetic_allowed is true. In this
        case the array can create 'synthetic' child values for indexes 
        that aren't in the array bounds using positive or negative 
        indexes.
        
        @param[in] idx
            The index of the child value to get
        
        @param[in] use_dynamic
            An enumeration that specifies whether to get dynamic values,
            and also if the target can be run to figure out the dynamic
            type of the child value.
        
        @param[in] synthetic_allowed
            If true, then allow child values to be created by index
            for pointers and arrays for indexes that normally wouldn't
            be allowed.
        
        @return
            A new SBValue object that represents the child member value.
        """
        return _lldb.SBValue_GetChildAtIndex(self, *args)


    def CreateChildAtOffset(self, name, offset, type):
        """CreateChildAtOffset(SBValue self, str const * name, uint32_t offset, SBType type) -> SBValue"""
        return _lldb.SBValue_CreateChildAtOffset(self, name, offset, type)


    def Cast(self, type):
        """Cast(SBValue self, SBType type) -> SBValue"""
        return _lldb.SBValue_Cast(self, type)


    def CreateValueFromExpression(self, *args):
        """
        CreateValueFromExpression(SBValue self, str const * name, str const * expression) -> SBValue
        CreateValueFromExpression(SBValue self, str const * name, str const * expression, SBExpressionOptions options) -> SBValue
        """
        return _lldb.SBValue_CreateValueFromExpression(self, *args)


    def CreateValueFromAddress(self, name, address, type):
        """CreateValueFromAddress(SBValue self, str const * name, lldb::addr_t address, SBType type) -> SBValue"""
        return _lldb.SBValue_CreateValueFromAddress(self, name, address, type)


    def CreateValueFromData(self, name, data, type):
        """CreateValueFromData(SBValue self, str const * name, SBData data, SBType type) -> SBValue"""
        return _lldb.SBValue_CreateValueFromData(self, name, data, type)


    def GetType(self):
        """GetType(SBValue self) -> SBType"""
        return _lldb.SBValue_GetType(self)


    def GetIndexOfChildWithName(self, name):
        """
        GetIndexOfChildWithName(SBValue self, str const * name) -> uint32_t


        Returns the child member index.
        
        Matches children of this object only and will match base classes and
        member names if this is a clang typed object.
        
        @param[in] name
            The name of the child value to get
        
        @return
            An index to the child member value.
        """
        return _lldb.SBValue_GetIndexOfChildWithName(self, name)


    def GetChildMemberWithName(self, *args):
        """
        GetChildMemberWithName(SBValue self, str const * name) -> SBValue
        GetChildMemberWithName(SBValue self, str const * name, lldb::DynamicValueType use_dynamic) -> SBValue


        Returns the child member value.
        
        Matches child members of this object and child members of any base
        classes.
        
        @param[in] name
            The name of the child value to get
        
        @param[in] use_dynamic
            An enumeration that specifies whether to get dynamic values,
            and also if the target can be run to figure out the dynamic
            type of the child value.
        
        @return
            A new SBValue object that represents the child member value.
        """
        return _lldb.SBValue_GetChildMemberWithName(self, *args)


    def GetValueForExpressionPath(self, expr_path):
        """
        GetValueForExpressionPath(SBValue self, str const * expr_path) -> SBValue

        Expands nested expressions like .a->b[0].c[1]->d.
        """
        return _lldb.SBValue_GetValueForExpressionPath(self, expr_path)


    def GetDeclaration(self):
        """GetDeclaration(SBValue self) -> SBDeclaration"""
        return _lldb.SBValue_GetDeclaration(self)


    def MightHaveChildren(self):
        """MightHaveChildren(SBValue self) -> bool"""
        return _lldb.SBValue_MightHaveChildren(self)


    def IsRuntimeSupportValue(self):
        """IsRuntimeSupportValue(SBValue self) -> bool"""
        return _lldb.SBValue_IsRuntimeSupportValue(self)


    def GetNumChildren(self, *args):
        """
        GetNumChildren(SBValue self) -> uint32_t
        GetNumChildren(SBValue self, uint32_t max) -> uint32_t
        """
        return _lldb.SBValue_GetNumChildren(self, *args)


    def GetOpaqueType(self):
        """GetOpaqueType(SBValue self) -> void *"""
        return _lldb.SBValue_GetOpaqueType(self)


    def Dereference(self):
        """Dereference(SBValue self) -> SBValue"""
        return _lldb.SBValue_Dereference(self)


    def AddressOf(self):
        """AddressOf(SBValue self) -> SBValue"""
        return _lldb.SBValue_AddressOf(self)


    def TypeIsPointerType(self):
        """TypeIsPointerType(SBValue self) -> bool"""
        return _lldb.SBValue_TypeIsPointerType(self)


    def GetTarget(self):
        """GetTarget(SBValue self) -> SBTarget"""
        return _lldb.SBValue_GetTarget(self)


    def GetProcess(self):
        """GetProcess(SBValue self) -> SBProcess"""
        return _lldb.SBValue_GetProcess(self)


    def GetThread(self):
        """GetThread(SBValue self) -> SBThread"""
        return _lldb.SBValue_GetThread(self)


    def GetFrame(self):
        """GetFrame(SBValue self) -> SBFrame"""
        return _lldb.SBValue_GetFrame(self)


    def Watch(self, resolve_location, read, write, error):
        """
        Watch(SBValue self, bool resolve_location, bool read, bool write, SBError error) -> SBWatchpoint


        Find and watch a variable.
        It returns an SBWatchpoint, which may be invalid.
        """
        return _lldb.SBValue_Watch(self, resolve_location, read, write, error)


    def WatchPointee(self, resolve_location, read, write, error):
        """
        WatchPointee(SBValue self, bool resolve_location, bool read, bool write, SBError error) -> SBWatchpoint


        Find and watch the location pointed to by a variable.
        It returns an SBWatchpoint, which may be invalid.
        """
        return _lldb.SBValue_WatchPointee(self, resolve_location, read, write, error)


    def GetDescription(self, description):
        """GetDescription(SBValue self, SBStream description) -> bool"""
        return _lldb.SBValue_GetDescription(self, description)


    def GetPointeeData(self, *args):
        """
        GetPointeeData(SBValue self, uint32_t item_idx, uint32_t item_count) -> SBData
        GetPointeeData(SBValue self, uint32_t item_idx) -> SBData
        GetPointeeData(SBValue self) -> SBData


          Get an SBData wrapping what this SBValue points to.
          
          This method will dereference the current SBValue, if its
          data type is a T* or T[], and extract item_count elements
          of type T from it, copying their contents in an SBData. 
          
          @param[in] item_idx
              The index of the first item to retrieve. For an array
              this is equivalent to array[item_idx], for a pointer
              to *(pointer + item_idx). In either case, the measurement
              unit for item_idx is the sizeof(T) rather than the byte
          
          @param[in] item_count
              How many items should be copied into the output. By default
              only one item is copied, but more can be asked for.
          
          @return
              An SBData with the contents of the copied items, on success.
              An empty SBData otherwise.
        """
        return _lldb.SBValue_GetPointeeData(self, *args)


    def GetData(self):
        """
        GetData(SBValue self) -> SBData


          Get an SBData wrapping the contents of this SBValue.
          
          This method will read the contents of this object in memory
          and copy them into an SBData for future use. 
          
          @return
              An SBData with the contents of this SBValue, on success.
              An empty SBData otherwise.
        """
        return _lldb.SBValue_GetData(self)


    def SetData(self, data, error):
        """SetData(SBValue self, SBData data, SBError error) -> bool"""
        return _lldb.SBValue_SetData(self, data, error)


    def GetLoadAddress(self):
        """GetLoadAddress(SBValue self) -> lldb::addr_t"""
        return _lldb.SBValue_GetLoadAddress(self)


    def GetAddress(self):
        """GetAddress(SBValue self) -> SBAddress"""
        return _lldb.SBValue_GetAddress(self)


    def Persist(self):
        """Persist(SBValue self) -> SBValue"""
        return _lldb.SBValue_Persist(self)


    def GetExpressionPath(self, *args):
        """
        GetExpressionPath(SBValue self, SBStream description) -> bool
        GetExpressionPath(SBValue self, SBStream description, bool qualify_cxx_base_classes) -> bool

        Returns an expression path for this value.
        """
        return _lldb.SBValue_GetExpressionPath(self, *args)


    def __get_dynamic__ (self):
        '''Helper function for the "SBValue.dynamic" property.'''
        return self.GetDynamicValue (eDynamicCanRunTarget)

    class children_access(object):
        '''A helper object that will lazily hand out thread for a process when supplied an index.'''

        def __init__(self, sbvalue):
            self.sbvalue = sbvalue

        def __len__(self):
            if self.sbvalue:
                return int(self.sbvalue.GetNumChildren())
            return 0

        def __getitem__(self, key):
            if type(key) is int and key < len(self):
                return self.sbvalue.GetChildAtIndex(key)
            return None

    def get_child_access_object(self):
        '''An accessor function that returns a children_access() object which allows lazy member variable access from a lldb.SBValue object.'''
        return self.children_access (self)

    def get_value_child_list(self):
        '''An accessor function that returns a list() that contains all children in a lldb.SBValue object.'''
        children = []
        accessor = self.get_child_access_object()
        for idx in range(len(accessor)):
            children.append(accessor[idx])
        return children

    __swig_getmethods__["children"] = get_value_child_list
    if _newclass: children = property(get_value_child_list, None, doc='''A read only property that returns a list() of lldb.SBValue objects for the children of the value.''')

    __swig_getmethods__["child"] = get_child_access_object
    if _newclass: child = property(get_child_access_object, None, doc='''A read only property that returns an object that can access children of a variable by index (child_value = value.children[12]).''')

    __swig_getmethods__["name"] = GetName
    if _newclass: name = property(GetName, None, doc='''A read only property that returns the name of this value as a string.''')

    __swig_getmethods__["type"] = GetType
    if _newclass: type = property(GetType, None, doc='''A read only property that returns a lldb.SBType object that represents the type for this value.''')

    __swig_getmethods__["size"] = GetByteSize
    if _newclass: size = property(GetByteSize, None, doc='''A read only property that returns the size in bytes of this value.''')

    __swig_getmethods__["is_in_scope"] = IsInScope
    if _newclass: is_in_scope = property(IsInScope, None, doc='''A read only property that returns a boolean value that indicates whether this value is currently lexically in scope.''')

    __swig_getmethods__["format"] = GetFormat
    __swig_setmethods__["format"] = SetFormat
    if _newclass: format = property(GetName, SetFormat, doc='''A read/write property that gets/sets the format used for lldb.SBValue().GetValue() for this value. See enumerations that start with "lldb.eFormat".''')

    __swig_getmethods__["value"] = GetValue
    __swig_setmethods__["value"] = SetValueFromCString
    if _newclass: value = property(GetValue, SetValueFromCString, doc='''A read/write property that gets/sets value from a string.''')

    __swig_getmethods__["value_type"] = GetValueType
    if _newclass: value_type = property(GetValueType, None, doc='''A read only property that returns an lldb enumeration value (see enumerations that start with "lldb.eValueType") that represents the type of this value (local, argument, global, register, etc.).''')

    __swig_getmethods__["changed"] = GetValueDidChange
    if _newclass: changed = property(GetValueDidChange, None, doc='''A read only property that returns a boolean value that indicates if this value has changed since it was last updated.''')

    __swig_getmethods__["data"] = GetData
    if _newclass: data = property(GetData, None, doc='''A read only property that returns an lldb object (lldb.SBData) that represents the bytes that make up the value for this object.''')

    __swig_getmethods__["load_addr"] = GetLoadAddress
    if _newclass: load_addr = property(GetLoadAddress, None, doc='''A read only property that returns the load address of this value as an integer.''')

    __swig_getmethods__["addr"] = GetAddress
    if _newclass: addr = property(GetAddress, None, doc='''A read only property that returns an lldb.SBAddress that represents the address of this value if it is in memory.''')

    __swig_getmethods__["deref"] = Dereference
    if _newclass: deref = property(Dereference, None, doc='''A read only property that returns an lldb.SBValue that is created by dereferencing this value.''')

    __swig_getmethods__["address_of"] = AddressOf
    if _newclass: address_of = property(AddressOf, None, doc='''A read only property that returns an lldb.SBValue that represents the address-of this value.''')

    __swig_getmethods__["error"] = GetError
    if _newclass: error = property(GetError, None, doc='''A read only property that returns the lldb.SBError that represents the error from the last time the variable value was calculated.''')

    __swig_getmethods__["summary"] = GetSummary
    if _newclass: summary = property(GetSummary, None, doc='''A read only property that returns the summary for this value as a string''')

    __swig_getmethods__["description"] = GetObjectDescription
    if _newclass: description = property(GetObjectDescription, None, doc='''A read only property that returns the language-specific description of this value as a string''')

    __swig_getmethods__["dynamic"] = __get_dynamic__
    if _newclass: dynamic = property(__get_dynamic__, None, doc='''A read only property that returns an lldb.SBValue that is created by finding the dynamic type of this value.''')

    __swig_getmethods__["location"] = GetLocation
    if _newclass: location = property(GetLocation, None, doc='''A read only property that returns the location of this value as a string.''')

    __swig_getmethods__["target"] = GetTarget
    if _newclass: target = property(GetTarget, None, doc='''A read only property that returns the lldb.SBTarget that this value is associated with.''')

    __swig_getmethods__["process"] = GetProcess
    if _newclass: process = property(GetProcess, None, doc='''A read only property that returns the lldb.SBProcess that this value is associated with, the returned value might be invalid and should be tested.''')

    __swig_getmethods__["thread"] = GetThread
    if _newclass: thread = property(GetThread, None, doc='''A read only property that returns the lldb.SBThread that this value is associated with, the returned value might be invalid and should be tested.''')

    __swig_getmethods__["frame"] = GetFrame
    if _newclass: frame = property(GetFrame, None, doc='''A read only property that returns the lldb.SBFrame that this value is associated with, the returned value might be invalid and should be tested.''')

    __swig_getmethods__["num_children"] = GetNumChildren
    if _newclass: num_children = property(GetNumChildren, None, doc='''A read only property that returns the number of child lldb.SBValues that this value has.''')

    __swig_getmethods__["unsigned"] = GetValueAsUnsigned
    if _newclass: unsigned = property(GetValueAsUnsigned, None, doc='''A read only property that returns the value of this SBValue as an usigned integer.''')

    __swig_getmethods__["signed"] = GetValueAsSigned
    if _newclass: signed = property(GetValueAsSigned, None, doc='''A read only property that returns the value of this SBValue as a signed integer.''')

    def get_expr_path(self):
        s = SBStream()
        self.GetExpressionPath (s)
        return s.GetData()

    __swig_getmethods__["path"] = get_expr_path
    if _newclass: path = property(get_expr_path, None, doc='''A read only property that returns the expression path that one can use to reach this value in an expression.''')

    def synthetic_child_from_expression(self, name, expr, options=None):
        if options is None: options = lldb.SBExpressionOptions()
        child = self.CreateValueFromExpression(name, expr, options)
        child.SetSyntheticChildrenGenerated(True)
        return child

    def synthetic_child_from_data(self, name, data, type):
        child = self.CreateValueFromData(name, data, type)
        child.SetSyntheticChildrenGenerated(True)
        return child

    def synthetic_child_from_address(self, name, addr, type):
        child = self.CreateValueFromAddress(name, addr, type)
        child.SetSyntheticChildrenGenerated(True)
        return child



    def __str__(self):
        """__str__(SBValue self) -> PyObject *"""
        return _lldb.SBValue___str__(self)

SBValue_swigregister = _lldb.SBValue_swigregister
SBValue_swigregister(SBValue)

class SBValueList(_object):
    """
    Represents a collection of SBValues.  Both SBFrame's GetVariables() and
    GetRegisters() return a SBValueList.

    SBValueList supports SBValue iteration. For example (from test/lldbutil.py),

    def get_registers(frame, kind):
        '''Returns the registers given the frame and the kind of registers desired.

        Returns None if there's no such kind.
        '''
        registerSet = frame.GetRegisters() # Return type of SBValueList.
        for value in registerSet:
            if kind.lower() in value.GetName().lower():
                return value

        return None

    def get_GPRs(frame):
        '''Returns the general purpose registers of the frame as an SBValue.

        The returned SBValue object is iterable.  An example:
            ...
            from lldbutil import get_GPRs
            regs = get_GPRs(frame)
            for reg in regs:
                print('%s => %s' % (reg.GetName(), reg.GetValue()))
            ...
        '''
        return get_registers(frame, 'general purpose')

    def get_FPRs(frame):
        '''Returns the floating point registers of the frame as an SBValue.

        The returned SBValue object is iterable.  An example:
            ...
            from lldbutil import get_FPRs
            regs = get_FPRs(frame)
            for reg in regs:
                print('%s => %s' % (reg.GetName(), reg.GetValue()))
            ...
        '''
        return get_registers(frame, 'floating point')

    def get_ESRs(frame):
        '''Returns the exception state registers of the frame as an SBValue.

        The returned SBValue object is iterable.  An example:
            ...
            from lldbutil import get_ESRs
            regs = get_ESRs(frame)
            for reg in regs:
                print('%s => %s' % (reg.GetName(), reg.GetValue()))
            ...
        '''
        return get_registers(frame, 'exception state')
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBValueList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBValueList, name)
    __repr__ = _swig_repr

    def __iter__(self): return lldb_iter(self, 'GetSize', 'GetValueAtIndex')
    def __len__(self): return self.GetSize()
    def __init__(self, *args):
        """
        __init__(lldb::SBValueList self) -> SBValueList
        __init__(lldb::SBValueList self, SBValueList rhs) -> SBValueList
        """
        this = _lldb.new_SBValueList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBValueList
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBValueList self) -> bool"""
        return _lldb.SBValueList_IsValid(self)


    def Clear(self):
        """Clear(SBValueList self)"""
        return _lldb.SBValueList_Clear(self)


    def Append(self, *args):
        """
        Append(SBValueList self, SBValue val_obj)
        Append(SBValueList self, SBValueList value_list)
        """
        return _lldb.SBValueList_Append(self, *args)


    def GetSize(self):
        """GetSize(SBValueList self) -> uint32_t"""
        return _lldb.SBValueList_GetSize(self)


    def GetValueAtIndex(self, idx):
        """GetValueAtIndex(SBValueList self, uint32_t idx) -> SBValue"""
        return _lldb.SBValueList_GetValueAtIndex(self, idx)


    def FindValueObjectByUID(self, uid):
        """FindValueObjectByUID(SBValueList self, lldb::user_id_t uid) -> SBValue"""
        return _lldb.SBValueList_FindValueObjectByUID(self, uid)


    def GetFirstValueByName(self, name):
        """GetFirstValueByName(SBValueList self, str const * name) -> SBValue"""
        return _lldb.SBValueList_GetFirstValueByName(self, name)


    def __len__(self):
        return int(self.GetSize())

    def __getitem__(self, key):
        count = len(self)
    #------------------------------------------------------------
    # Access with "int" to get Nth item in the list
    #------------------------------------------------------------
        if type(key) is int:
            if key < count:
                return self.GetValueAtIndex(key)
    #------------------------------------------------------------
    # Access with "str" to get values by name
    #------------------------------------------------------------
        elif type(key) is str:
            matches = []
            for idx in range(count):
                value = self.GetValueAtIndex(idx)
                if value.name == key:
                    matches.append(value)
            return matches
    #------------------------------------------------------------
    # Match with regex
    #------------------------------------------------------------
        elif isinstance(key, type(re.compile('.'))):
            matches = []
            for idx in range(count):
                value = self.GetValueAtIndex(idx)
                re_match = key.search(value.name)
                if re_match:
                    matches.append(value)
            return matches



    def __str__(self):
        """__str__(SBValueList self) -> PyObject *"""
        return _lldb.SBValueList___str__(self)

SBValueList_swigregister = _lldb.SBValueList_swigregister
SBValueList_swigregister(SBValueList)

class SBVariablesOptions(_object):
    """Proxy of C++ lldb::SBVariablesOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBVariablesOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBVariablesOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBVariablesOptions self) -> SBVariablesOptions
        __init__(lldb::SBVariablesOptions self, SBVariablesOptions options) -> SBVariablesOptions
        """
        this = _lldb.new_SBVariablesOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBVariablesOptions
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBVariablesOptions self) -> bool"""
        return _lldb.SBVariablesOptions_IsValid(self)


    def GetIncludeArguments(self):
        """GetIncludeArguments(SBVariablesOptions self) -> bool"""
        return _lldb.SBVariablesOptions_GetIncludeArguments(self)


    def SetIncludeArguments(self, arg2):
        """SetIncludeArguments(SBVariablesOptions self, bool arg2)"""
        return _lldb.SBVariablesOptions_SetIncludeArguments(self, arg2)


    def GetIncludeLocals(self):
        """GetIncludeLocals(SBVariablesOptions self) -> bool"""
        return _lldb.SBVariablesOptions_GetIncludeLocals(self)


    def SetIncludeLocals(self, arg2):
        """SetIncludeLocals(SBVariablesOptions self, bool arg2)"""
        return _lldb.SBVariablesOptions_SetIncludeLocals(self, arg2)


    def GetIncludeStatics(self):
        """GetIncludeStatics(SBVariablesOptions self) -> bool"""
        return _lldb.SBVariablesOptions_GetIncludeStatics(self)


    def SetIncludeStatics(self, arg2):
        """SetIncludeStatics(SBVariablesOptions self, bool arg2)"""
        return _lldb.SBVariablesOptions_SetIncludeStatics(self, arg2)


    def GetInScopeOnly(self):
        """GetInScopeOnly(SBVariablesOptions self) -> bool"""
        return _lldb.SBVariablesOptions_GetInScopeOnly(self)


    def SetInScopeOnly(self, arg2):
        """SetInScopeOnly(SBVariablesOptions self, bool arg2)"""
        return _lldb.SBVariablesOptions_SetInScopeOnly(self, arg2)


    def GetIncludeRuntimeSupportValues(self):
        """GetIncludeRuntimeSupportValues(SBVariablesOptions self) -> bool"""
        return _lldb.SBVariablesOptions_GetIncludeRuntimeSupportValues(self)


    def SetIncludeRuntimeSupportValues(self, arg2):
        """SetIncludeRuntimeSupportValues(SBVariablesOptions self, bool arg2)"""
        return _lldb.SBVariablesOptions_SetIncludeRuntimeSupportValues(self, arg2)


    def GetUseDynamic(self):
        """GetUseDynamic(SBVariablesOptions self) -> lldb::DynamicValueType"""
        return _lldb.SBVariablesOptions_GetUseDynamic(self)


    def SetUseDynamic(self, arg2):
        """SetUseDynamic(SBVariablesOptions self, lldb::DynamicValueType arg2)"""
        return _lldb.SBVariablesOptions_SetUseDynamic(self, arg2)

SBVariablesOptions_swigregister = _lldb.SBVariablesOptions_swigregister
SBVariablesOptions_swigregister(SBVariablesOptions)

class SBWatchpoint(_object):
    """
    Represents an instance of watchpoint for a specific target program.

    A watchpoint is determined by the address and the byte size that resulted in
    this particular instantiation.  Each watchpoint has its settable options.

    See also SBTarget.watchpoint_iter() for example usage of iterating through the
    watchpoints of the target.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBWatchpoint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBWatchpoint, name)
    __repr__ = _swig_repr

    def __eq__(self, other): return isinstance(other, SBWatchpoint) and self.GetID() == other.GetID()
    def __ne__(self, other): return not self.__eq__(other)
    def __init__(self, *args):
        """
        __init__(lldb::SBWatchpoint self) -> SBWatchpoint
        __init__(lldb::SBWatchpoint self, SBWatchpoint rhs) -> SBWatchpoint
        """
        this = _lldb.new_SBWatchpoint(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBWatchpoint
    __del__ = lambda self: None

    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBWatchpoint self) -> bool"""
        return _lldb.SBWatchpoint_IsValid(self)


    def GetError(self):
        """GetError(SBWatchpoint self) -> SBError"""
        return _lldb.SBWatchpoint_GetError(self)


    def GetID(self):
        """GetID(SBWatchpoint self) -> lldb::watch_id_t"""
        return _lldb.SBWatchpoint_GetID(self)


    def GetHardwareIndex(self):
        """
        GetHardwareIndex(SBWatchpoint self) -> int32_t


        With -1 representing an invalid hardware index.
        """
        return _lldb.SBWatchpoint_GetHardwareIndex(self)


    def GetWatchAddress(self):
        """GetWatchAddress(SBWatchpoint self) -> lldb::addr_t"""
        return _lldb.SBWatchpoint_GetWatchAddress(self)


    def GetWatchSize(self):
        """GetWatchSize(SBWatchpoint self) -> size_t"""
        return _lldb.SBWatchpoint_GetWatchSize(self)


    def SetEnabled(self, enabled):
        """SetEnabled(SBWatchpoint self, bool enabled)"""
        return _lldb.SBWatchpoint_SetEnabled(self, enabled)


    def IsEnabled(self):
        """IsEnabled(SBWatchpoint self) -> bool"""
        return _lldb.SBWatchpoint_IsEnabled(self)


    def GetHitCount(self):
        """GetHitCount(SBWatchpoint self) -> uint32_t"""
        return _lldb.SBWatchpoint_GetHitCount(self)


    def GetIgnoreCount(self):
        """GetIgnoreCount(SBWatchpoint self) -> uint32_t"""
        return _lldb.SBWatchpoint_GetIgnoreCount(self)


    def SetIgnoreCount(self, n):
        """SetIgnoreCount(SBWatchpoint self, uint32_t n)"""
        return _lldb.SBWatchpoint_SetIgnoreCount(self, n)


    def GetCondition(self):
        """
        GetCondition(SBWatchpoint self) -> str const *


        Get the condition expression for the watchpoint.
        """
        return _lldb.SBWatchpoint_GetCondition(self)


    def SetCondition(self, condition):
        """
        SetCondition(SBWatchpoint self, str const * condition)


        The watchpoint stops only if the condition expression evaluates to true.
        """
        return _lldb.SBWatchpoint_SetCondition(self, condition)


    def GetDescription(self, description, level):
        """GetDescription(SBWatchpoint self, SBStream description, lldb::DescriptionLevel level) -> bool"""
        return _lldb.SBWatchpoint_GetDescription(self, description, level)


    def EventIsWatchpointEvent(event):
        """EventIsWatchpointEvent(SBEvent event) -> bool"""
        return _lldb.SBWatchpoint_EventIsWatchpointEvent(event)

    EventIsWatchpointEvent = staticmethod(EventIsWatchpointEvent)

    def GetWatchpointEventTypeFromEvent(event):
        """GetWatchpointEventTypeFromEvent(SBEvent event) -> lldb::WatchpointEventType"""
        return _lldb.SBWatchpoint_GetWatchpointEventTypeFromEvent(event)

    GetWatchpointEventTypeFromEvent = staticmethod(GetWatchpointEventTypeFromEvent)

    def GetWatchpointFromEvent(event):
        """GetWatchpointFromEvent(SBEvent event) -> SBWatchpoint"""
        return _lldb.SBWatchpoint_GetWatchpointFromEvent(event)

    GetWatchpointFromEvent = staticmethod(GetWatchpointFromEvent)

    def __str__(self):
        """__str__(SBWatchpoint self) -> PyObject *"""
        return _lldb.SBWatchpoint___str__(self)

SBWatchpoint_swigregister = _lldb.SBWatchpoint_swigregister
SBWatchpoint_swigregister(SBWatchpoint)

def SBWatchpoint_EventIsWatchpointEvent(event):
    """SBWatchpoint_EventIsWatchpointEvent(SBEvent event) -> bool"""
    return _lldb.SBWatchpoint_EventIsWatchpointEvent(event)

def SBWatchpoint_GetWatchpointEventTypeFromEvent(event):
    """SBWatchpoint_GetWatchpointEventTypeFromEvent(SBEvent event) -> lldb::WatchpointEventType"""
    return _lldb.SBWatchpoint_GetWatchpointEventTypeFromEvent(event)

def SBWatchpoint_GetWatchpointFromEvent(event):
    """SBWatchpoint_GetWatchpointFromEvent(SBEvent event) -> SBWatchpoint"""
    return _lldb.SBWatchpoint_GetWatchpointFromEvent(event)

class SBUnixSignals(_object):
    """Allows you to manipulate LLDB's signal disposition"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SBUnixSignals, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SBUnixSignals, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(lldb::SBUnixSignals self) -> SBUnixSignals
        __init__(lldb::SBUnixSignals self, SBUnixSignals rhs) -> SBUnixSignals
        """
        this = _lldb.new_SBUnixSignals(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _lldb.delete_SBUnixSignals
    __del__ = lambda self: None

    def Clear(self):
        """Clear(SBUnixSignals self)"""
        return _lldb.SBUnixSignals_Clear(self)


    def __nonzero__(self): return self.IsValid()
    def IsValid(self):
        """IsValid(SBUnixSignals self) -> bool"""
        return _lldb.SBUnixSignals_IsValid(self)


    def GetSignalAsCString(self, signo):
        """GetSignalAsCString(SBUnixSignals self, int32_t signo) -> str const *"""
        return _lldb.SBUnixSignals_GetSignalAsCString(self, signo)


    def GetSignalNumberFromName(self, name):
        """GetSignalNumberFromName(SBUnixSignals self, str const * name) -> int32_t"""
        return _lldb.SBUnixSignals_GetSignalNumberFromName(self, name)


    def GetShouldSuppress(self, signo):
        """GetShouldSuppress(SBUnixSignals self, int32_t signo) -> bool"""
        return _lldb.SBUnixSignals_GetShouldSuppress(self, signo)


    def SetShouldSuppress(self, signo, value):
        """SetShouldSuppress(SBUnixSignals self, int32_t signo, bool value) -> bool"""
        return _lldb.SBUnixSignals_SetShouldSuppress(self, signo, value)


    def GetShouldStop(self, signo):
        """GetShouldStop(SBUnixSignals self, int32_t signo) -> bool"""
        return _lldb.SBUnixSignals_GetShouldStop(self, signo)


    def SetShouldStop(self, signo, value):
        """SetShouldStop(SBUnixSignals self, int32_t signo, bool value) -> bool"""
        return _lldb.SBUnixSignals_SetShouldStop(self, signo, value)


    def GetShouldNotify(self, signo):
        """GetShouldNotify(SBUnixSignals self, int32_t signo) -> bool"""
        return _lldb.SBUnixSignals_GetShouldNotify(self, signo)


    def SetShouldNotify(self, signo, value):
        """SetShouldNotify(SBUnixSignals self, int32_t signo, bool value) -> bool"""
        return _lldb.SBUnixSignals_SetShouldNotify(self, signo, value)


    def GetNumSignals(self):
        """GetNumSignals(SBUnixSignals self) -> int32_t"""
        return _lldb.SBUnixSignals_GetNumSignals(self)


    def GetSignalAtIndex(self, index):
        """GetSignalAtIndex(SBUnixSignals self, int32_t index) -> int32_t"""
        return _lldb.SBUnixSignals_GetSignalAtIndex(self, index)


    def get_unix_signals_list(self):
        signals = []
        for idx in range(0, self.GetNumSignals()):
            signals.append(self.GetSignalAtIndex(sig))
        return signals

    __swig_getmethods__["signals"] = get_unix_signals_list
    if _newclass: threads = property(get_unix_signals_list, None, doc='''A read only property that returns a list() of valid signal numbers for this platform.''')

SBUnixSignals_swigregister = _lldb.SBUnixSignals_swigregister
SBUnixSignals_swigregister(SBUnixSignals)



def command(command_name=None, doc=None):
    import lldb
    """A decorator function that registers an LLDB command line
        command that is bound to the function it is attached to."""
    def callable(function):
        """Registers an lldb command for the decorated function."""
        command = "command script add -f %s.%s %s" % (function.__module__, function.__name__, command_name or function.__name__)
        lldb.debugger.HandleCommand(command)
        if doc:
            function.__doc__ = doc
        return function

    return callable

class declaration(object):
    '''A class that represents a source declaration location with file, line and column.'''
    def __init__(self, file, line, col):
        self.file = file
        self.line = line
        self.col = col

class value_iter(object):
    def __iter__(self):
        return self

    def next(self):
        if self.index >= self.length:
            raise StopIteration()
        child_sbvalue = self.sbvalue.GetChildAtIndex(self.index)
        self.index += 1
        return value(child_sbvalue)

    def __init__(self,value):
        self.index = 0
        self.sbvalue = value
        if type(self.sbvalue) is value:
            self.sbvalue = self.sbvalue.sbvalue
        self.length = self.sbvalue.GetNumChildren()

class value(object):
    '''A class designed to wrap lldb.SBValue() objects so the resulting object
    can be used as a variable would be in code. So if you have a Point structure
    variable in your code in the current frame named "pt", you can initialize an instance
    of this class with it:

    pt = lldb.value(lldb.frame.FindVariable("pt"))
    print pt
    print pt.x
    print pt.y

    pt = lldb.value(lldb.frame.FindVariable("rectangle_array"))
    print rectangle_array[12]
    print rectangle_array[5].origin.x'''
    def __init__(self, sbvalue):
        self.sbvalue = sbvalue

    def __nonzero__(self):
        return self.sbvalue.__nonzero__()

    def __str__(self):
        return self.sbvalue.__str__()

    def __getitem__(self, key):
# Allow array access if this value has children...
        if type(key) is value:
            key = int(key)
        if type(key) is int:
            child_sbvalue = (self.sbvalue.GetValueForExpressionPath("[%i]" % key))
            if child_sbvalue and child_sbvalue.IsValid():
                return value(child_sbvalue)
            raise IndexError("Index '%d' is out of range" % key)
        raise TypeError("No array item of type %s" % str(type(key)))

    def __iter__(self):
        return value_iter(self.sbvalue)

    def __getattr__(self, name):
        child_sbvalue = self.sbvalue.GetChildMemberWithName (name)
        if child_sbvalue and child_sbvalue.IsValid():
            return value(child_sbvalue)
        raise AttributeError("Attribute '%s' is not defined" % name)

    def __add__(self, other):
        return int(self) + int(other)

    def __sub__(self, other):
        return int(self) - int(other)

    def __mul__(self, other):
        return int(self) * int(other)

    def __floordiv__(self, other):
        return int(self) // int(other)

    def __mod__(self, other):
        return int(self) % int(other)

    def __divmod__(self, other):
        return int(self) % int(other)

    def __pow__(self, other):
        return int(self) ** int(other)

    def __lshift__(self, other):
        return int(self) << int(other)

    def __rshift__(self, other):
        return int(self) >> int(other)

    def __and__(self, other):
        return int(self) & int(other)

    def __xor__(self, other):
        return int(self) ^ int(other)

    def __or__(self, other):
        return int(self) | int(other)

    def __div__(self, other):
        return int(self) / int(other)

    def __truediv__(self, other):
        return int(self) / int(other)

    def __iadd__(self, other):
        result = self.__add__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __isub__(self, other):
        result = self.__sub__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __imul__(self, other):
        result = self.__mul__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __idiv__(self, other):
        result = self.__div__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __itruediv__(self, other):
        result = self.__truediv__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __ifloordiv__(self, other):
        result =  self.__floordiv__(self, other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __imod__(self, other):
        result =  self.__and__(self, other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __ipow__(self, other):
        result = self.__pow__(self, other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __ipow__(self, other, modulo):
        result = self.__pow__(self, other, modulo)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __ilshift__(self, other):
        result = self.__lshift__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __irshift__(self, other):
        result =  self.__rshift__(other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __iand__(self, other):
        result =  self.__and__(self, other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __ixor__(self, other):
        result =  self.__xor__(self, other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __ior__(self, other):
        result =  self.__ior__(self, other)
        self.sbvalue.SetValueFromCString (str(result))
        return result

    def __neg__(self):
        return -int(self)

    def __pos__(self):
        return +int(self)

    def __abs__(self):
        return abs(int(self))

    def __invert__(self):
        return ~int(self)

    def __complex__(self):
        return complex (int(self))

    def __int__(self):
        is_num,is_sign = is_numeric_type(self.sbvalue.GetType().GetCanonicalType().GetBasicType())
        if is_num and not is_sign: return self.sbvalue.GetValueAsUnsigned()
        return self.sbvalue.GetValueAsSigned()

    def __long__(self):
        return self.__int__()

    def __float__(self):
        return float (self.sbvalue.GetValueAsSigned())

    def __oct__(self):
        return '0%o' % self.sbvalue.GetValueAsUnsigned()

    def __hex__(self):
        return '0x%x' % self.sbvalue.GetValueAsUnsigned()

    def __len__(self):
        return self.sbvalue.GetNumChildren()

    def __eq__(self, other):
        if type(other) is int:
                return int(self) == other
        elif type(other) is str:
                return str(self) == other
        elif type(other) is value:
                self_err = SBError()
                other_err = SBError()
                self_val = self.sbvalue.GetValueAsUnsigned(self_err)
                if self_err.fail:
                        raise ValueError("unable to extract value of self")
                other_val = other.sbvalue.GetValueAsUnsigned(other_err)
                if other_err.fail:
                        raise ValueError("unable to extract value of other")
                return self_val == other_val
        raise TypeError("Unknown type %s, No equality operation defined." % str(type(other)))

    def __ne__(self, other):
        return not self.__eq__(other)



class SBSyntheticValueProvider(object):
    def __init__(self,valobj):
        pass

    def num_children(self):
        return 0

    def get_child_index(self,name):
        return None

    def get_child_at_index(self,idx):
        return None

    def update(self):
        pass

    def has_children(self):
        return False





# given an lldb.SBBasicType it returns a tuple
# (is_numeric, is_signed)
# the value of is_signed is undefined if is_numeric == false
def is_numeric_type(basic_type):
    if basic_type == eBasicTypeInvalid: return (False,False)
    if basic_type == eBasicTypeVoid: return (False,False)
    if basic_type == eBasicTypeChar: return (True,False)
    if basic_type == eBasicTypeSignedChar: return (True,True)
    if basic_type == eBasicTypeUnsignedChar: return (True,False)
    if basic_type == eBasicTypeWChar: return (True,False)
    if basic_type == eBasicTypeSignedWChar: return (True,True)
    if basic_type == eBasicTypeUnsignedWChar: return (True,False)
    if basic_type == eBasicTypeChar16: return (True,False)
    if basic_type == eBasicTypeChar32: return (True,False)
    if basic_type == eBasicTypeShort: return (True,True)
    if basic_type == eBasicTypeUnsignedShort: return (True,False)
    if basic_type == eBasicTypeInt: return (True,True)
    if basic_type == eBasicTypeUnsignedInt: return (True,False)
    if basic_type == eBasicTypeLong: return (True,True)
    if basic_type == eBasicTypeUnsignedLong: return (True,False)
    if basic_type == eBasicTypeLongLong: return (True,True)
    if basic_type == eBasicTypeUnsignedLongLong: return (True,False)
    if basic_type == eBasicTypeInt128: return (True,True)
    if basic_type == eBasicTypeUnsignedInt128: return (True,False)
    if basic_type == eBasicTypeBool: return (False,False)
    if basic_type == eBasicTypeHalf: return (True,True)
    if basic_type == eBasicTypeFloat: return (True,True)
    if basic_type == eBasicTypeDouble: return (True,True)
    if basic_type == eBasicTypeLongDouble: return (True,True)
    if basic_type == eBasicTypeFloatComplex: return (True,True)
    if basic_type == eBasicTypeDoubleComplex: return (True,True)
    if basic_type == eBasicTypeLongDoubleComplex: return (True,True)
    if basic_type == eBasicTypeObjCID: return (False,False)
    if basic_type == eBasicTypeObjCClass: return (False,False)
    if basic_type == eBasicTypeObjCSel: return (False,False)
    if basic_type == eBasicTypeNullPtr: return (False,False)
#if basic_type == eBasicTypeOther:
    return (False,False)


# This file is compatible with both classic and new-style classes.


debugger_unique_id = 0
SBDebugger.Initialize()
debugger = None
target = SBTarget()
process = SBProcess()
thread = SBThread()
frame = SBFrame()