(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/bn#BN->bytes
    (lambda (_bn155972_)
      (let* ((_bytes155974_
              (make-u8vector (std/crypto/libcrypto#BN_num_bytes _bn155972_)))
             (_count155976_
              (std/crypto/libcrypto#BN_bn2bin _bn155972_ _bytes155974_)))
        (if (##fx< _count155976_ (u8vector-length _bytes155974_))
            (u8vector-shrink! _bytes155974_ _count155976_)
            _bytes155974_))))
  (define std/crypto/bn#bytes->BN__%
    (lambda (_bytes155942_ _start155943_ _end155944_)
      (if (u8vector? _bytes155942_)
          (let* ((_end155949_
                  (let ((_$e155946_ _end155944_))
                    (if _$e155946_
                        _$e155946_
                        (u8vector-length _bytes155942_))))
                 (_$e155951_
                  (std/crypto/libcrypto#BN_bin2bn
                   _bytes155942_
                   _start155943_
                   _end155949_)))
            (if _$e155951_
                _$e155951_
                (error '"error decoding BN; NULL pointer" _bytes155942_)))
          (error '"bad argument; expected bytes" _bytes155942_))))
  (define std/crypto/bn#bytes->BN__0
    (lambda (_bytes155957_)
      (let* ((_start155959_ '0) (_end155961_ '#f))
        (std/crypto/bn#bytes->BN__% _bytes155957_ _start155959_ _end155961_))))
  (define std/crypto/bn#bytes->BN__1
    (lambda (_bytes155963_ _start155964_)
      (let ((_end155966_ '#f))
        (std/crypto/bn#bytes->BN__% _bytes155963_ _start155964_ _end155966_))))
  (define std/crypto/bn#bytes->BN
    (lambda _g155979_
      (let ((_g155978_ (length _g155979_)))
        (cond ((##fx= _g155978_ 1)
               (apply std/crypto/bn#bytes->BN__0 _g155979_))
              ((##fx= _g155978_ 2)
               (apply std/crypto/bn#bytes->BN__1 _g155979_))
              ((##fx= _g155978_ 3)
               (apply std/crypto/bn#bytes->BN__% _g155979_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/bn#bytes->BN
                _g155979_)))))))
