/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.peer.MenuComponentPeer;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;

public abstract class MenuComponent
implements Serializable {
    private static final long serialVersionUID = -4536902356223894379L;
    private Font font;
    private String name;
    transient MenuContainer parent;
    transient MenuComponentPeer peer;
    private transient Object tree_lock = this;
    private static transient Toolkit toolkit = Toolkit.getDefaultToolkit();
    AccessibleContext accessibleContext;
    private boolean nameExplicitlySet;
    private boolean newEventsOnly;
    transient FocusListener focusListener;

    public MenuComponent() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.parent != null) {
            return this.parent.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    String generateName() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
        this.nameExplicitlySet = true;
    }

    public MenuContainer getParent() {
        return this.parent;
    }

    final void setParent(MenuContainer parent) {
        this.parent = parent;
    }

    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    final void setPeer(MenuComponentPeer peer) {
        this.peer = peer;
    }

    public void removeNotify() {
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.peer = null;
    }

    final Toolkit getToolkit() {
        return toolkit;
    }

    protected final Object getTreeLock() {
        return this.tree_lock;
    }

    final void setTreeLock(Object treeLock) {
        this.tree_lock = treeLock;
    }

    public boolean postEvent(Event event) {
        boolean retVal = false;
        MenuContainer parent = this.getParent();
        if (parent != null) {
            retVal = parent.postEvent(event);
        }
        return retVal;
    }

    public final void dispatchEvent(AWTEvent event) {
        Event oldStyleEvent = Component.translateEvent(event);
        if (oldStyleEvent != null) {
            this.postEvent(oldStyleEvent);
        }
        this.dispatchEventImpl(event);
    }

    void dispatchEventImpl(AWTEvent event) {
        this.processEvent(event);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof FocusEvent && this.focusListener != null) {
            switch (event.id) {
                case 1004: {
                    this.focusListener.focusGained((FocusEvent)event);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost((FocusEvent)event);
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "name=" + this.getName();
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    protected abstract class AccessibleAWTMenuComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent,
    AccessibleSelection {
        private static final long serialVersionUID = -4269533416223798698L;

        protected AccessibleAWTMenuComponent() {
        }

        public void addAccessibleSelection(int index) {
        }

        public void addFocusListener(FocusListener listener) {
            MenuComponent.this.focusListener = AWTEventMulticaster.add(MenuComponent.this.focusListener, listener);
        }

        public void clearAccessibleSelection() {
        }

        public boolean contains(Point point) {
            return this.getBounds().contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public Accessible getAccessibleChild(int index) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public String getAccessibleDescription() {
            return MenuComponent.this.getName();
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public String getAccessibleName() {
            return MenuComponent.this.getName();
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int index) {
            return null;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        public Color getBackground() {
            return SystemColor.menu;
        }

        public Rectangle getBounds() {
            return null;
        }

        public Cursor getCursor() {
            return Cursor.getDefaultCursor();
        }

        public Font getFont() {
            return MenuComponent.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return MenuComponent.this.getToolkit().getFontMetrics(font);
        }

        public Color getForeground() {
            return SystemColor.menuText;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public Point getLocation() {
            return this.getBounds().getLocation();
        }

        public Point getLocationOnScreen() {
            return null;
        }

        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        public boolean isAccessibleChildSelected(int index) {
            return false;
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isShowing() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void removeAccessibleSelection(int index) {
        }

        public void removeFocusListener(FocusListener listener) {
            MenuComponent.this.focusListener = AWTEventMulticaster.remove(MenuComponent.this.focusListener, listener);
        }

        public void requestFocus() {
        }

        public void selectAllAccessibleSelection() {
            int a = 0;
            while (a < this.getAccessibleChildrenCount()) {
                this.addAccessibleSelection(a);
                ++a;
            }
        }

        public void setBackground(Color color) {
        }

        public void setBounds(Rectangle rectangle) {
        }

        public void setCursor(Cursor cursor) {
        }

        public void setEnabled(boolean enabled) {
        }

        public void setFont(Font font) {
            MenuComponent.this.setFont(font);
        }

        public void setForeground(Color color) {
        }

        public void setLocation(Point point) {
            this.getBounds().setLocation(point);
        }

        public void setSize(Dimension size) {
            this.getBounds().setSize(size);
        }

        public void setVisible(boolean visibility) {
        }
    }
}

