/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.ESSolrSynonymParser;
import org.elasticsearch.index.analysis.ESWordnetSynonymParser;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;

public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(SynonymTokenFilterFactory.class));
    @Deprecated
    protected final boolean ignoreCase;
    protected final String format;
    protected final boolean expand;
    protected final boolean lenient;
    protected final Settings settings;
    protected final Environment environment;
    @Deprecated
    protected final TokenizerFactory tokenizerFactory;

    public SynonymTokenFilterFactory(IndexSettings indexSettings, Environment env, AnalysisRegistry analysisRegistry, String name, Settings settings) throws IOException {
        super(indexSettings, name, settings);
        this.settings = settings;
        this.ignoreCase = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "ignore_case", false, deprecationLogger);
        if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1) && settings.get("ignore_case") != null) {
            deprecationLogger.deprecated("The ignore_case option on the synonym_graph filter is deprecated. Instead, insert a lowercase filter in the filter chain before the synonym_graph filter.", new Object[0]);
        }
        this.expand = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "expand", true, deprecationLogger);
        if (indexSettings.getIndexVersionCreated().before(Version.V_6_0_0_beta1)) {
            TokenizerFactory tokenizerFactory;
            String tokenizerName = settings.get("tokenizer", "whitespace");
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizerName, indexSettings);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find tokenizer [" + tokenizerName + "] for synonym token filter");
            }
            this.tokenizerFactory = tokenizerFactory = tokenizerFactoryFactory.get(indexSettings, env, tokenizerName, AnalysisRegistry.getSettingsFromIndexSettings(indexSettings, "index.analysis.tokenizer." + tokenizerName));
        } else {
            this.tokenizerFactory = null;
        }
        this.lenient = settings.getAsBoolean("lenient", false);
        this.format = settings.get("format", "");
        this.environment = env;
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymFactory to specialize this factory for an analysis chain first");
    }

    @Override
    public TokenFilterFactory getChainAwareTokenFilterFactory(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        Analyzer analyzer = this.buildSynonymAnalyzer(tokenizer, charFilters, previousTokenFilters);
        final SynonymMap synonyms = this.buildSynonyms(analyzer, this.getRulesFromSettings(this.environment));
        final String name = this.name();
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return synonyms.fst == null ? tokenStream : new SynonymFilter(tokenStream, synonyms, false);
            }

            @Override
            public TokenFilterFactory getSynonymFilter() {
                return IDENTITY_FILTER;
            }
        };
    }

    public Analyzer buildSynonymAnalyzer(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> tokenFilters) {
        if (this.tokenizerFactory != null) {
            return new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    Tokenizer tokenizer = SynonymTokenFilterFactory.this.tokenizerFactory.create();
                    Tokenizer stream = SynonymTokenFilterFactory.this.ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                    return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)stream);
                }
            };
        }
        return new CustomAnalyzer("synonyms", tokenizer, charFilters.toArray(new CharFilterFactory[0]), (TokenFilterFactory[])tokenFilters.stream().map(TokenFilterFactory::getSynonymFilter).toArray(TokenFilterFactory[]::new));
    }

    protected SynonymMap buildSynonyms(Analyzer analyzer, Reader rules) {
        try {
            Object parser;
            if ("wordnet".equalsIgnoreCase(this.format)) {
                parser = new ESWordnetSynonymParser(true, this.expand, this.lenient, analyzer);
                parser.parse(rules);
            } else {
                parser = new ESSolrSynonymParser(true, this.expand, this.lenient, analyzer);
                ((ESSolrSynonymParser)((Object)parser)).parse(rules);
            }
            return parser.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to build synonyms", e);
        }
    }

    protected Reader getRulesFromSettings(Environment env) {
        Reader rulesReader;
        if (this.settings.getAsList("synonyms", null) != null) {
            List<String> rulesList = Analysis.getWordList(env, this.settings, "synonyms");
            StringBuilder sb = new StringBuilder();
            for (String line : rulesList) {
                sb.append(line).append(System.lineSeparator());
            }
            rulesReader = new StringReader(sb.toString());
        } else if (this.settings.get("synonyms_path") != null) {
            rulesReader = Analysis.getReaderFromFile(env, this.settings, "synonyms_path");
        } else {
            throw new IllegalArgumentException("synonym requires either `synonyms` or `synonyms_path` to be configured");
        }
        return rulesReader;
    }
}

