/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnection;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NPNClientConnection
extends NegotiatingClientConnection
implements NextProtoNego.ClientProvider {
    private static final Logger LOG = Log.getLogger(NPNClientConnection.class);
    private final String protocol;

    public NPNClientConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context, String protocol) {
        super(endPoint, executor, sslEngine, connectionFactory, context);
        this.protocol = protocol;
        NextProtoNego.put((SSLEngine)sslEngine, (NextProtoNego.Provider)this);
    }

    public boolean supports() {
        return true;
    }

    public void unsupported() {
        NextProtoNego.remove((SSLEngine)this.getSSLEngine());
        this.completed();
    }

    public String selectProtocol(List<String> protocols) {
        if (protocols.contains(this.protocol)) {
            NextProtoNego.remove((SSLEngine)this.getSSLEngine());
            this.completed();
            return this.protocol;
        }
        LOG.info("Could not negotiate protocol: server {} - client {}", protocols, this.protocol);
        this.close();
        return null;
    }

    @Override
    public void close() {
        NextProtoNego.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

