/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class QueryCommand
extends AbstractJmxCommand {
    private static final Properties PREDEFINED_OBJNAME_QUERY = new Properties();
    protected String[] helpFile = new String[]{"Task Usage: Main query [query-options]", "Description: Display selected broker component's attributes and statistics.", "", "Query Options:", "    -Q<type>=<name>               Add to the search list the specific object type matched", "                                  by the defined object identifier.", "    -xQ<type>=<name>              Remove from the search list the specific object type", "                                  matched by the object identifier.", "    --objname <query>             Add to the search list objects matched by the query similar", "                                  to the JMX object name format.", "    --xobjname <query>            Remove from the search list objects matched by the query", "                                  similar to the JMX object name format.", "    --view <attr1>,<attr2>,...    Select the specific attribute of the object to view.", "                                  By default all attributes will be displayed.", "    --invoke <operation>          Specify the operation to invoke on matching objects", "    --jmxurl <url>                Set the JMX URL to connect to.", "    --pid <pid>                   Set the pid to connect to (only on Sun JVM).", "    --jmxuser <user>              Set the JMX user used for authenticating.", "    --jmxpassword <password>      Set the JMX password used for authenticating.", "    --jmxlocal                    Use the local JMX server instead of a remote one.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the query broker help information.", "", "Examples:", "    query", "        - Print all the attributes of all registered objects queues, topics, connections, etc).", "", "    query -QQueue=TEST.FOO", "        - Print all the attributes of the queue with destination name TEST.FOO.", "", "    query -QTopic=*", "        - Print all the attributes of all registered topics.", "", "    query --view EnqueueCount,DequeueCount", "        - Print the attributes EnqueueCount and DequeueCount of all registered objects.", "", "    query -QTopic=* --view EnqueueCount,DequeueCount", "        - Print the attributes EnqueueCount and DequeueCount of all registered topics.", "", "    query -QTopic=* -QQueue=* --view EnqueueCount,DequeueCount", "        - Print the attributes EnqueueCount and DequeueCount of all registered topics and", "          queues.", "", "    query -QTopic=* -xQTopic=ActiveMQ.Advisory.*", "        - Print all attributes of all topics except those that has a name that begins", "          with \"ActiveMQ.Advisory\".", "", "    query --objname type=Broker,brokerName=*,connector=clientConnectors,connectorName=* -xQNetworkConnector=*", "        - Print all attributes of all connectors, connections excluding network connectors", "          that belongs to the broker that begins with local.", "", "    query -QQueue=* -xQQueue=????", "        - Print all attributes of all queues except those that are 4 letters long.", "", "    query -QQueue=* --invoke pause", "        - Pause all queues.", ""};
    private final List<String> queryAddObjects = new ArrayList<String>(10);
    private final List<String> querySubObjects = new ArrayList<String>(10);
    private final Set queryViews = new LinkedHashSet();
    private final List<String> opAndParams = new ArrayList<String>(10);

    @Override
    public String getName() {
        return "query";
    }

    @Override
    public String getOneLineDescription() {
        return "Display selected broker component's attributes and statistics.";
    }

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        Map<Object, List> addMBeans = JmxMBeansUtil.queryMBeansAsMap(this.createJmxConnection(), this.queryAddObjects, this.queryViews);
        if (this.querySubObjects.size() > 0) {
            Map<Object, List> subMBeans = JmxMBeansUtil.queryMBeansAsMap(this.createJmxConnection(), this.querySubObjects, this.queryViews);
            addMBeans.keySet().removeAll(subMBeans.keySet());
        }
        if (this.opAndParams.isEmpty()) {
            this.context.printMBean(JmxMBeansUtil.filterMBeansView(new ArrayList<List>(addMBeans.values()), this.queryViews));
        } else {
            this.context.print(this.doInvoke(addMBeans.keySet(), this.opAndParams));
        }
    }

    private Collection doInvoke(Set<Object> mBeans, List<String> opAndParams) throws Exception {
        LinkedList<String> results = new LinkedList<String>();
        for (Object objectName : mBeans) {
            Object result = this.createJmxConnection().invoke((ObjectName)objectName, opAndParams.get(0), this.params(opAndParams), this.stringSignature(opAndParams));
            results.add("[" + objectName + "]." + opAndParams.get(0) + " = " + result);
        }
        return results;
    }

    private Object[] params(List<String> opAndParams) {
        if (opAndParams.size() > 1) {
            return opAndParams.subList(1, opAndParams.size()).toArray();
        }
        return null;
    }

    private String[] stringSignature(List<String> opAndParams) {
        if (opAndParams.size() > 1) {
            Object[] sig = new String[opAndParams.size() - 1];
            Arrays.fill(sig, String.class.getName());
            return sig;
        }
        return null;
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.startsWith("-Q")) {
            String predefQuery;
            String key = token.substring(2);
            String value = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                value = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            if ((predefQuery = PREDEFINED_OBJNAME_QUERY.getProperty(key)) == null) {
                this.context.printException(new IllegalArgumentException("Unknown query object type: " + key));
                return;
            }
            String queryStr = JmxMBeansUtil.createQueryString(predefQuery, value);
            StringTokenizer queryTokens = new StringTokenizer(queryStr, ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
            this.normaliseObjectName(this.queryAddObjects);
        } else if (token.startsWith("-xQ")) {
            String predefQuery;
            String key = token.substring(3);
            String value = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                value = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            if ((predefQuery = PREDEFINED_OBJNAME_QUERY.getProperty(key)) == null) {
                this.context.printException(new IllegalArgumentException("Unknown query object type: " + key));
                return;
            }
            String queryStr = JmxMBeansUtil.createQueryString(predefQuery, value);
            StringTokenizer queryTokens = new StringTokenizer(queryStr, ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
            this.normaliseObjectName(this.querySubObjects);
        } else if (token.startsWith("--objname")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Object name query not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer(tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--xobjname")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Object name query not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer(tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--view")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Attributes to view not specified"));
                return;
            }
            StringTokenizer viewTokens = new StringTokenizer(tokens.remove(0), ",");
            while (viewTokens.hasMoreElements()) {
                this.queryViews.add(viewTokens.nextElement());
            }
        } else if (token.startsWith("--invoke")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("operation to invoke is not specified"));
                return;
            }
            StringTokenizer viewTokens = new StringTokenizer(tokens.remove(0), ",");
            while (viewTokens.hasMoreElements()) {
                this.opAndParams.add((String)viewTokens.nextElement());
            }
        } else {
            super.handleOption(token, tokens);
        }
    }

    private void normaliseObjectName(List<String> queryAddObjects) {
        this.ensurePresent(queryAddObjects, "type", "Broker");
        this.ensurePresent(queryAddObjects, "brokerName", "*");
        this.ensureUnique(queryAddObjects, "destinationType", "?????");
        this.ensureUnique(queryAddObjects, "destinationName", "*");
    }

    private void ensurePresent(List<String> queryAddObjects, String id, String wildcard) {
        List<String> matches = this.findMatchingKeys(queryAddObjects, id);
        if (matches.size() == 0) {
            queryAddObjects.add(id + "=" + wildcard);
        }
    }

    private void ensureUnique(List<String> queryAddObjects, String id, String wildcard) {
        List<String> matches = this.findMatchingKeys(queryAddObjects, id);
        if (matches.size() > 1) {
            queryAddObjects.removeAll(matches);
            queryAddObjects.add(id + "=" + wildcard);
        }
    }

    private List<String> findMatchingKeys(List<String> queryAddObjects, String id) {
        LinkedList<String> matches = new LinkedList<String>();
        for (String prop : queryAddObjects) {
            String[] keyValue = prop.split("=");
            if (keyValue.length != 2 || !keyValue[0].equals(id)) continue;
            matches.add(prop);
        }
        return matches;
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }

    static {
        PREDEFINED_OBJNAME_QUERY.setProperty("Broker", "brokerName=%1");
        PREDEFINED_OBJNAME_QUERY.setProperty("Connection", "connector=clientConnectors,connectionViewType=*,connectionName=%1,*");
        PREDEFINED_OBJNAME_QUERY.setProperty("Connector", "connector=clientConnectors,connectorName=%1");
        PREDEFINED_OBJNAME_QUERY.setProperty("NetworkConnector", "connector=networkConnectors,networkConnectorName=%1");
        PREDEFINED_OBJNAME_QUERY.setProperty("Queue", "destinationType=Queue,destinationName=%1");
        PREDEFINED_OBJNAME_QUERY.setProperty("Topic", "destinationType=Topic,destinationName=%1");
    }
}

