/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;

public class ScrollEvent
extends GestureEvent {
    public static final EventType<ScrollEvent> ANY = new EventType<GestureEvent>(GestureEvent.ANY, "ANY_SCROLL");
    public static final EventType<ScrollEvent> SCROLL = new EventType<ScrollEvent>(ANY, "SCROLL");
    public static final EventType<ScrollEvent> SCROLL_STARTED = new EventType<ScrollEvent>(ANY, "SCROLL_STARTED");
    public static final EventType<ScrollEvent> SCROLL_FINISHED = new EventType<ScrollEvent>(ANY, "SCROLL_FINISHED");
    private double deltaX;
    private double deltaY;
    private double totalDeltaX;
    private double totalDeltaY;
    private HorizontalTextScrollUnits textDeltaXUnits;
    private VerticalTextScrollUnits textDeltaYUnits;
    private double textDeltaX;
    private double textDeltaY;
    private int touchCount;

    private ScrollEvent(EventType<? extends ScrollEvent> eventType) {
        super((EventType<? extends GestureEvent>)eventType);
    }

    private ScrollEvent(Object object, EventTarget eventTarget, EventType<? extends ScrollEvent> eventType) {
        super(object, eventTarget, (EventType<? extends GestureEvent>)eventType);
    }

    private ScrollEvent(EventType<? extends ScrollEvent> eventType, double d, double d2, double d3, double d4, HorizontalTextScrollUnits horizontalTextScrollUnits, double d5, VerticalTextScrollUnits verticalTextScrollUnits, double d6, int n, double d7, double d8, double d9, double d10, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(eventType, d7, d8, d9, d10, bl, bl2, bl3, bl4, bl5, bl6);
        this.deltaX = d;
        this.deltaY = d2;
        this.totalDeltaX = d3;
        this.totalDeltaY = d4;
        this.textDeltaXUnits = horizontalTextScrollUnits;
        this.textDeltaX = d5;
        this.textDeltaYUnits = verticalTextScrollUnits;
        this.textDeltaY = d6;
        this.touchCount = n;
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public double getTotalDeltaX() {
        return this.totalDeltaX;
    }

    public double getTotalDeltaY() {
        return this.totalDeltaY;
    }

    public HorizontalTextScrollUnits getTextDeltaXUnits() {
        return this.textDeltaXUnits;
    }

    public VerticalTextScrollUnits getTextDeltaYUnits() {
        return this.textDeltaYUnits;
    }

    public double getTextDeltaX() {
        return this.textDeltaX;
    }

    public double getTextDeltaY() {
        return this.textDeltaY;
    }

    public int getTouchCount() {
        return this.touchCount;
    }

    @Deprecated
    public static ScrollEvent impl_scrollEvent(EventType<ScrollEvent> eventType, double d, double d2, double d3, double d4, HorizontalTextScrollUnits horizontalTextScrollUnits, double d5, VerticalTextScrollUnits verticalTextScrollUnits, double d6, int n, double d7, double d8, double d9, double d10, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return new ScrollEvent(eventType, d, d2, d3, d4, horizontalTextScrollUnits, d5, verticalTextScrollUnits, d6, n, d7, d8, d9, d10, bl, bl2, bl3, bl4, bl5, bl6);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ScrollEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", deltaX = ").append(this.getDeltaX()).append(", deltaY = ").append(this.getDeltaY());
        stringBuilder.append(", totalDeltaX = ").append(this.getTotalDeltaX()).append(", totalDeltaY = ").append(this.getTotalDeltaY());
        stringBuilder.append(", textDeltaXUnits = ").append((Object)this.getTextDeltaXUnits()).append(", textDeltaX = ").append(this.getTextDeltaX());
        stringBuilder.append(", textDeltaYUnits = ").append((Object)this.getTextDeltaYUnits()).append(", textDeltaY = ").append(this.getTextDeltaY());
        stringBuilder.append(", touchCount = ").append(this.getTouchCount());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        stringBuilder.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }

    public static enum HorizontalTextScrollUnits {
        NONE,
        CHARACTERS;

    }

    public static enum VerticalTextScrollUnits {
        NONE,
        LINES,
        PAGES;

    }
}

