/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.saxtree;

import java.util.List;
import nu.validator.saxtree.NodeType;
import nu.validator.saxtree.ParentNode;
import nu.validator.saxtree.PrefixMapping;
import nu.validator.saxtree.TreeParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class Node
implements Locator {
    private final String systemId;
    private final String publicId;
    private final int column;
    private final int line;
    private Node nextSibling = null;
    private ParentNode parentNode = null;

    Node(Locator locator) {
        if (locator == null) {
            this.systemId = null;
            this.publicId = null;
            this.column = -1;
            this.line = -1;
        } else {
            this.systemId = locator.getSystemId();
            this.publicId = locator.getPublicId();
            this.column = locator.getColumnNumber();
            this.line = locator.getLineNumber();
        }
    }

    @Override
    public int getColumnNumber() {
        return this.column;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    abstract void visit(TreeParser var1) throws SAXException;

    void revisit(TreeParser treeParser) throws SAXException {
    }

    public Node getFirstChild() {
        return null;
    }

    public final Node getNextSibling() {
        return this.nextSibling;
    }

    public final Node getPreviousSibling() {
        Node prev = null;
        Node next = this.parentNode.getFirstChild();
        while (this != next) {
            prev = next;
            next = next.nextSibling;
        }
        return prev;
    }

    void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }

    public final ParentNode getParentNode() {
        return this.parentNode;
    }

    void setParentNode(ParentNode parentNode) {
        this.parentNode = parentNode;
    }

    public abstract NodeType getNodeType();

    public void detach() {
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
            this.parentNode = null;
        }
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public String getPublicIdentifier() {
        throw new UnsupportedOperationException();
    }

    public String getSystemIdentifier() {
        throw new UnsupportedOperationException();
    }

    public Attributes getAttributes() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public List<PrefixMapping> getPrefixMappings() {
        throw new UnsupportedOperationException();
    }

    public String getQName() {
        throw new UnsupportedOperationException();
    }

    public String getUri() {
        throw new UnsupportedOperationException();
    }

    public String getData() {
        throw new UnsupportedOperationException();
    }

    public String getTarget() {
        throw new UnsupportedOperationException();
    }
}

