/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class GatorProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_HEARTBEAT = 33;
    public static final int MSG_POSITION_DATA = 128;
    public static final int MSG_ROLLCALL_RESPONSE = 129;
    public static final int MSG_ALARM_DATA = 130;
    public static final int MSG_TERMINAL_STATUS = 131;
    public static final int MSG_MESSAGE = 132;
    public static final int MSG_TERMINAL_ANSWER = 133;
    public static final int MSG_BLIND_AREA = 142;
    public static final int MSG_PICTURE_FRAME = 84;
    public static final int MSG_CAMERA_RESPONSE = 86;
    public static final int MSG_PICTURE_DATA = 87;

    public GatorProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static String decodeId(int b1, int b2, int b3, int b4) {
        int d1 = 30 + (b1 >> 7 << 3) + (b2 >> 7 << 2) + (b3 >> 7 << 1) + (b4 >> 7);
        int d2 = b1 & 0x7F;
        int d3 = b2 & 0x7F;
        int d4 = b3 & 0x7F;
        int d5 = b4 & 0x7F;
        return String.format("%02d%02d%02d%02d%02d", d1, d2, d3, d4, d5);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, byte calibration) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(36);
            response.writeByte(36);
            response.writeByte(33);
            response.writeShort(5);
            response.writeByte((int)calibration);
            response.writeByte(0);
            response.writeByte(0);
            response.writeByte(1);
            response.writeByte(13);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        String id = GatorProtocolDecoder.decodeId(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        this.sendResponse(channel, remoteAddress, buf.getByte(buf.writerIndex() - 2));
        if (type == 128 || type == 129 || type == 130 || type == 142) {
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, "1" + id, id);
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
            position.setTime(dateBuilder.getDate());
            position.setLatitude(BcdUtil.readCoordinate(buf));
            position.setLongitude(BcdUtil.readCoordinate(buf));
            position.setSpeed(UnitsConverter.knotsFromKph(BcdUtil.readInteger(buf, 4)));
            position.setCourse(BcdUtil.readInteger(buf, 4));
            short flags = buf.readUnsignedByte();
            position.setValid((flags & 0x80) != 0);
            position.set("sat", flags & 0xF);
            position.set("status", buf.readUnsignedByte());
            position.set("key", buf.readUnsignedByte());
            position.set("oil", (double)buf.readUnsignedShort() / 10.0);
            position.set("power", (double)buf.readUnsignedByte() + (double)buf.readUnsignedByte() * 0.01);
            position.set("odometer", buf.readUnsignedInt());
            return position;
        }
        return null;
    }
}

