/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.BaseEventHandler;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.DeviceState;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class OverspeedEventHandler
extends BaseEventHandler {
    public static final String ATTRIBUTE_SPEED_LIMIT = "speedLimit";
    private boolean notRepeat;
    private boolean preferLowest;
    private long minimalDuration;

    public OverspeedEventHandler(long minimalDuration, boolean notRepeat, boolean preferLowest) {
        this.notRepeat = notRepeat;
        this.minimalDuration = minimalDuration;
        this.preferLowest = preferLowest;
    }

    private Map<Event, Position> newEvent(DeviceState deviceState, double speedLimit) {
        Position position = deviceState.getOverspeedPosition();
        Event event = new Event("deviceOverspeed", position.getDeviceId(), position.getId());
        event.set("speed", deviceState.getOverspeedPosition().getSpeed());
        event.set(ATTRIBUTE_SPEED_LIMIT, speedLimit);
        event.setGeofenceId(deviceState.getOverspeedGeofenceId());
        deviceState.setOverspeedState(this.notRepeat);
        deviceState.setOverspeedPosition(null);
        deviceState.setOverspeedGeofenceId(0L);
        return Collections.singletonMap(event, position);
    }

    public Map<Event, Position> updateOverspeedState(DeviceState deviceState, double speedLimit) {
        Map<Event, Position> result = null;
        if (deviceState.getOverspeedState() != null && !deviceState.getOverspeedState().booleanValue() && deviceState.getOverspeedPosition() != null && speedLimit != 0.0) {
            long currentTime = System.currentTimeMillis();
            Position overspeedPosition = deviceState.getOverspeedPosition();
            long overspeedTime = overspeedPosition.getFixTime().getTime();
            if (overspeedTime + this.minimalDuration <= currentTime) {
                result = this.newEvent(deviceState, speedLimit);
            }
        }
        return result;
    }

    public Map<Event, Position> updateOverspeedState(DeviceState deviceState, Position position, double speedLimit, long geofenceId) {
        Position overspeedPosition;
        boolean newOverspeed;
        Map<Event, Position> result = null;
        Boolean oldOverspeed = deviceState.getOverspeedState();
        long currentTime = position.getFixTime().getTime();
        boolean bl = newOverspeed = position.getSpeed() > speedLimit;
        if (newOverspeed && !oldOverspeed.booleanValue()) {
            if (deviceState.getOverspeedPosition() == null) {
                deviceState.setOverspeedPosition(position);
                deviceState.setOverspeedGeofenceId(geofenceId);
            }
        } else if (oldOverspeed.booleanValue() && !newOverspeed) {
            deviceState.setOverspeedState(false);
            deviceState.setOverspeedPosition(null);
            deviceState.setOverspeedGeofenceId(0L);
        } else {
            deviceState.setOverspeedPosition(null);
            deviceState.setOverspeedGeofenceId(0L);
        }
        if ((overspeedPosition = deviceState.getOverspeedPosition()) != null) {
            long overspeedTime = overspeedPosition.getFixTime().getTime();
            if (newOverspeed && overspeedTime + this.minimalDuration <= currentTime) {
                result = this.newEvent(deviceState, speedLimit);
            }
        }
        return result;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        long deviceId = position.getDeviceId();
        Device device = Context.getIdentityManager().getById(deviceId);
        if (device == null) {
            return null;
        }
        if (!Context.getIdentityManager().isLatestPosition(position) || !position.getValid()) {
            return null;
        }
        double speedLimit = Context.getDeviceManager().lookupAttributeDouble(deviceId, ATTRIBUTE_SPEED_LIMIT, 0.0, false);
        double geofenceSpeedLimit = 0.0;
        long overspeedGeofenceId = 0L;
        if (Context.getGeofenceManager() != null && device.getGeofenceIds() != null) {
            for (long geofenceId : device.getGeofenceIds()) {
                double currentSpeedLimit;
                Geofence geofence = (Geofence)Context.getGeofenceManager().getById(geofenceId);
                if (geofence == null || !((currentSpeedLimit = geofence.getDouble(ATTRIBUTE_SPEED_LIMIT)) > 0.0 && geofenceSpeedLimit == 0.0 || this.preferLowest && currentSpeedLimit < geofenceSpeedLimit) && (this.preferLowest || !(currentSpeedLimit > geofenceSpeedLimit))) continue;
                geofenceSpeedLimit = currentSpeedLimit;
                overspeedGeofenceId = geofenceId;
            }
        }
        if (geofenceSpeedLimit > 0.0) {
            speedLimit = geofenceSpeedLimit;
        }
        if (speedLimit == 0.0) {
            return null;
        }
        Map<Event, Position> result = null;
        DeviceState deviceState = Context.getDeviceManager().getDeviceState(deviceId);
        if (deviceState.getOverspeedState() == null) {
            deviceState.setOverspeedState(position.getSpeed() > speedLimit);
            deviceState.setOverspeedGeofenceId(position.getSpeed() > speedLimit ? overspeedGeofenceId : 0L);
        } else {
            result = this.updateOverspeedState(deviceState, position, speedLimit, overspeedGeofenceId);
        }
        Context.getDeviceManager().setDeviceState(deviceId, deviceState);
        return result;
    }
}

