/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.api.UserPrincipal;
import org.traccar.api.UserSecurityContext;
import org.traccar.helper.DataConverter;
import org.traccar.model.User;

public class SecurityRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityRequestFilter.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String BASIC_REALM = "Basic realm=\"api\"";
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    @javax.ws.rs.core.Context
    private HttpServletRequest request;
    @javax.ws.rs.core.Context
    private ResourceInfo resourceInfo;

    public static String[] decodeBasicAuth(String auth) {
        byte[] decodedBytes = DataConverter.parseBase64(auth = auth.replaceFirst("[B|b]asic ", ""));
        if (decodedBytes != null && decodedBytes.length > 0) {
            return new String(decodedBytes, StandardCharsets.US_ASCII).split(":", 2);
        }
        return null;
    }

    public void filter(ContainerRequestContext requestContext) {
        UserSecurityContext securityContext;
        block12: {
            if (requestContext.getMethod().equals("OPTIONS")) {
                return;
            }
            securityContext = null;
            try {
                Long userId;
                String authHeader = requestContext.getHeaderString(AUTHORIZATION_HEADER);
                if (authHeader != null) {
                    try {
                        String[] auth = SecurityRequestFilter.decodeBasicAuth(authHeader);
                        User user = Context.getPermissionsManager().login(auth[0], auth[1]);
                        if (user != null) {
                            Context.getStatisticsManager().registerRequest(user.getId());
                            securityContext = new UserSecurityContext(new UserPrincipal(user.getId()));
                        }
                        break block12;
                    }
                    catch (SQLException e) {
                        throw new WebApplicationException((Throwable)e);
                    }
                }
                if (this.request.getSession() != null && (userId = (Long)this.request.getSession().getAttribute("userId")) != null) {
                    Context.getPermissionsManager().checkUserEnabled(userId);
                    Context.getStatisticsManager().registerRequest(userId);
                    securityContext = new UserSecurityContext(new UserPrincipal(userId));
                }
            }
            catch (SecurityException e) {
                LOGGER.warn("Authentication error", (Throwable)e);
            }
        }
        if (securityContext != null) {
            requestContext.setSecurityContext(securityContext);
        } else {
            Method method = this.resourceInfo.getResourceMethod();
            if (!method.isAnnotationPresent(PermitAll.class)) {
                Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                if (!XML_HTTP_REQUEST.equals(this.request.getHeader(X_REQUESTED_WITH))) {
                    responseBuilder.header(WWW_AUTHENTICATE, (Object)BASIC_REALM);
                }
                throw new WebApplicationException(responseBuilder.build());
            }
        }
    }
}

