/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.ChannelHandler;
import org.traccar.BaseDataHandler;
import org.traccar.Context;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class HemisphereHandler
extends BaseDataHandler {
    private int latitudeFactor;
    private int longitudeFactor;

    public HemisphereHandler() {
        String longitudeHemisphere;
        String latitudeHemisphere = Context.getConfig().getString("location.latitudeHemisphere");
        if (latitudeHemisphere != null) {
            if (latitudeHemisphere.equalsIgnoreCase("N")) {
                this.latitudeFactor = 1;
            } else if (latitudeHemisphere.equalsIgnoreCase("S")) {
                this.latitudeFactor = -1;
            }
        }
        if ((longitudeHemisphere = Context.getConfig().getString("location.longitudeHemisphere")) != null) {
            if (longitudeHemisphere.equalsIgnoreCase("E")) {
                this.longitudeFactor = 1;
            } else if (longitudeHemisphere.equalsIgnoreCase("W")) {
                this.longitudeFactor = -1;
            }
        }
    }

    @Override
    protected Position handlePosition(Position position) {
        if (this.latitudeFactor != 0) {
            position.setLatitude(Math.abs(position.getLatitude()) * (double)this.latitudeFactor);
        }
        if (this.longitudeFactor != 0) {
            position.setLongitude(Math.abs(position.getLongitude()) * (double)this.longitudeFactor);
        }
        return position;
    }
}

