/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Context;
import org.traccar.DefaultDataHandler;
import org.traccar.DistanceHandler;
import org.traccar.EngineHoursHandler;
import org.traccar.FilterHandler;
import org.traccar.GeocoderHandler;
import org.traccar.GeolocationHandler;
import org.traccar.HemisphereHandler;
import org.traccar.Main;
import org.traccar.MainEventHandler;
import org.traccar.MotionHandler;
import org.traccar.NetworkMessage;
import org.traccar.PipelineBuilder;
import org.traccar.RemoteAddressHandler;
import org.traccar.TrackerServer;
import org.traccar.WebDataHandler;
import org.traccar.WrapperInboundHandler;
import org.traccar.WrapperOutboundHandler;
import org.traccar.events.AlertEventHandler;
import org.traccar.events.CommandResultEventHandler;
import org.traccar.events.DriverEventHandler;
import org.traccar.events.FuelDropEventHandler;
import org.traccar.events.GeofenceEventHandler;
import org.traccar.events.IgnitionEventHandler;
import org.traccar.events.MaintenanceEventHandler;
import org.traccar.events.MotionEventHandler;
import org.traccar.events.OverspeedEventHandler;
import org.traccar.processing.ComputedAttributesHandler;
import org.traccar.processing.CopyAttributesHandler;

public abstract class BasePipelineFactory
extends ChannelInitializer<Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePipelineFactory.class);
    private final TrackerServer server;
    private int timeout;
    private FilterHandler filterHandler;
    private DistanceHandler distanceHandler;
    private EngineHoursHandler engineHoursHandler;
    private RemoteAddressHandler remoteAddressHandler;
    private MotionHandler motionHandler;
    private GeocoderHandler geocoderHandler;
    private GeolocationHandler geolocationHandler;
    private HemisphereHandler hemisphereHandler;
    private CopyAttributesHandler copyAttributesHandler;
    private ComputedAttributesHandler computedAttributesHandler;
    private CommandResultEventHandler commandResultEventHandler;
    private OverspeedEventHandler overspeedEventHandler;
    private FuelDropEventHandler fuelDropEventHandler;
    private MotionEventHandler motionEventHandler;
    private GeofenceEventHandler geofenceEventHandler;
    private AlertEventHandler alertEventHandler;
    private IgnitionEventHandler ignitionEventHandler;
    private MaintenanceEventHandler maintenanceEventHandler;
    private DriverEventHandler driverEventHandler;

    public BasePipelineFactory(TrackerServer server, String protocol) {
        this.server = server;
        this.timeout = Context.getConfig().getInteger(protocol + ".timeout");
        if (this.timeout == 0) {
            this.timeout = Context.getConfig().getInteger(protocol + ".resetDelay");
            if (this.timeout == 0) {
                this.timeout = Context.getConfig().getInteger("server.timeout");
            }
        }
        this.distanceHandler = new DistanceHandler(Context.getConfig().getBoolean("coordinates.filter"), Context.getConfig().getInteger("coordinates.minError"), Context.getConfig().getInteger("coordinates.maxError"));
        if (Context.getConfig().getBoolean("processing.remoteAddress.enable")) {
            this.remoteAddressHandler = new RemoteAddressHandler();
        }
        if (Context.getConfig().getBoolean("filter.enable")) {
            this.filterHandler = new FilterHandler();
        }
        if (Context.getGeocoder() != null && !Context.getConfig().getBoolean("geocoder.ignorePositions")) {
            this.geocoderHandler = new GeocoderHandler(Context.getGeocoder(), Context.getConfig().getBoolean("geocoder.processInvalidPositions"));
        }
        if (Context.getGeolocationProvider() != null) {
            this.geolocationHandler = new GeolocationHandler(Context.getGeolocationProvider(), Context.getConfig().getBoolean("geolocation.processInvalidPositions"));
        }
        this.motionHandler = new MotionHandler(Context.getTripsConfig().getSpeedThreshold());
        if (Context.getConfig().getBoolean("processing.engineHours.enable")) {
            this.engineHoursHandler = new EngineHoursHandler();
        }
        if (Context.getConfig().hasKey("location.latitudeHemisphere") || Context.getConfig().hasKey("location.longitudeHemisphere")) {
            this.hemisphereHandler = new HemisphereHandler();
        }
        if (Context.getConfig().getBoolean("processing.copyAttributes.enable")) {
            this.copyAttributesHandler = new CopyAttributesHandler();
        }
        if (Context.getConfig().getBoolean("processing.computedAttributes.enable")) {
            this.computedAttributesHandler = new ComputedAttributesHandler();
        }
        if (Context.getConfig().getBoolean("event.enable")) {
            this.commandResultEventHandler = new CommandResultEventHandler();
            this.overspeedEventHandler = Context.getOverspeedEventHandler();
            this.fuelDropEventHandler = new FuelDropEventHandler();
            this.motionEventHandler = Context.getMotionEventHandler();
            this.geofenceEventHandler = new GeofenceEventHandler();
            this.alertEventHandler = new AlertEventHandler();
            this.ignitionEventHandler = new IgnitionEventHandler();
            this.maintenanceEventHandler = new MaintenanceEventHandler();
            this.driverEventHandler = new DriverEventHandler();
        }
    }

    protected abstract void addProtocolHandlers(PipelineBuilder var1);

    private void addHandlers(ChannelPipeline pipeline, ChannelHandler ... handlers) {
        for (ChannelHandler handler : handlers) {
            if (handler == null) continue;
            pipeline.addLast(new ChannelHandler[]{handler});
        }
    }

    public static <T extends ChannelHandler> T getHandler(ChannelPipeline pipeline, Class<T> clazz) {
        for (Map.Entry handlerEntry : pipeline) {
            ChannelHandler handler = (ChannelHandler)handlerEntry.getValue();
            if (handler instanceof WrapperInboundHandler) {
                handler = ((WrapperInboundHandler)handler).getWrappedHandler();
            } else if (handler instanceof WrapperOutboundHandler) {
                handler = ((WrapperOutboundHandler)handler).getWrappedHandler();
            }
            if (!clazz.isAssignableFrom(handler.getClass())) continue;
            return (T)handler;
        }
        return null;
    }

    protected void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.timeout > 0 && !this.server.isDatagram()) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.timeout, 0, 0)});
        }
        pipeline.addLast(new ChannelHandler[]{new OpenChannelHandler(this.server)});
        pipeline.addLast(new ChannelHandler[]{new NetworkMessageHandler()});
        pipeline.addLast(new ChannelHandler[]{new StandardLoggingHandler()});
        this.addProtocolHandlers(handler -> {
            if (!(handler instanceof BaseProtocolDecoder) && !(handler instanceof BaseProtocolEncoder)) {
                handler = handler instanceof ChannelInboundHandler ? new WrapperInboundHandler((ChannelInboundHandler)handler) : new WrapperOutboundHandler((ChannelOutboundHandler)handler);
            }
            pipeline.addLast(new ChannelHandler[]{handler});
        });
        this.addHandlers(pipeline, new ChannelHandler[]{this.geolocationHandler, this.hemisphereHandler, this.distanceHandler, this.remoteAddressHandler});
        this.addDynamicHandlers(pipeline);
        this.addHandlers(pipeline, new ChannelHandler[]{this.filterHandler, this.geocoderHandler, this.motionHandler, this.engineHoursHandler, this.copyAttributesHandler, this.computedAttributesHandler});
        if (Context.getDataManager() != null) {
            pipeline.addLast(new ChannelHandler[]{new DefaultDataHandler()});
        }
        if (Context.getConfig().getBoolean("forward.enable")) {
            pipeline.addLast(new ChannelHandler[]{((WebDataHandler.Factory)Main.getInjector().getInstance(WebDataHandler.Factory.class)).create(Context.getConfig().getString("forward.url"), Context.getConfig().getBoolean("forward.json"))});
        }
        this.addHandlers(pipeline, new ChannelHandler[]{this.commandResultEventHandler, this.overspeedEventHandler, this.fuelDropEventHandler, this.motionEventHandler, this.geofenceEventHandler, this.alertEventHandler, this.ignitionEventHandler, this.maintenanceEventHandler, this.driverEventHandler});
        pipeline.addLast(new ChannelHandler[]{new MainEventHandler()});
    }

    private void addDynamicHandlers(ChannelPipeline pipeline) {
        if (Context.getConfig().hasKey("extra.handlers")) {
            String[] handlers;
            for (String handler : handlers = Context.getConfig().getString("extra.handlers").split(",")) {
                try {
                    pipeline.addLast(new ChannelHandler[]{(ChannelHandler)Class.forName(handler).newInstance()});
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException error) {
                    LOGGER.warn("Dynamic handler error", (Throwable)error);
                }
            }
        }
    }

    private static class StandardLoggingHandler
    extends ChannelDuplexHandler {
        private StandardLoggingHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.log(ctx, false, msg);
            super.channelRead(ctx, msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.log(ctx, true, msg);
            super.write(ctx, msg, promise);
        }

        public void log(ChannelHandlerContext ctx, boolean downstream, Object o) {
            if (o instanceof NetworkMessage) {
                NetworkMessage networkMessage = (NetworkMessage)o;
                if (networkMessage.getMessage() instanceof ByteBuf) {
                    this.log(ctx, downstream, networkMessage.getRemoteAddress(), (ByteBuf)networkMessage.getMessage());
                }
            } else if (o instanceof ByteBuf) {
                this.log(ctx, downstream, ctx.channel().remoteAddress(), (ByteBuf)o);
            }
        }

        public void log(ChannelHandlerContext ctx, boolean downstream, SocketAddress remoteAddress, ByteBuf buf) {
            StringBuilder message = new StringBuilder();
            message.append("[").append(ctx.channel().id().asShortText()).append(": ");
            message.append(((InetSocketAddress)ctx.channel().localAddress()).getPort());
            if (downstream) {
                message.append(" > ");
            } else {
                message.append(" < ");
            }
            if (remoteAddress instanceof InetSocketAddress) {
                message.append(((InetSocketAddress)remoteAddress).getHostString());
            } else {
                message.append("unknown");
            }
            message.append("]");
            message.append(" HEX: ");
            message.append(ByteBufUtil.hexDump((ByteBuf)buf));
            LOGGER.info(message.toString());
        }
    }

    private static class NetworkMessageHandler
    extends ChannelDuplexHandler {
        private NetworkMessageHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (ctx.channel() instanceof DatagramChannel) {
                DatagramPacket packet = (DatagramPacket)msg;
                ctx.fireChannelRead((Object)new NetworkMessage(packet.content(), packet.sender()));
            } else if (msg instanceof ByteBuf) {
                ByteBuf buffer = (ByteBuf)msg;
                ctx.fireChannelRead((Object)new NetworkMessage(buffer, ctx.channel().remoteAddress()));
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg instanceof NetworkMessage) {
                NetworkMessage message = (NetworkMessage)msg;
                if (ctx.channel() instanceof DatagramChannel) {
                    InetSocketAddress recipient = (InetSocketAddress)message.getRemoteAddress();
                    InetSocketAddress sender = (InetSocketAddress)ctx.channel().localAddress();
                    ctx.write((Object)new DatagramPacket((ByteBuf)message.getMessage(), recipient, sender), promise);
                } else {
                    ctx.write(message.getMessage(), promise);
                }
            } else {
                ctx.write(msg, promise);
            }
        }
    }

    private static final class OpenChannelHandler
    extends ChannelDuplexHandler {
        private final TrackerServer server;

        private OpenChannelHandler(TrackerServer server) {
            this.server = server;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.server.getChannelGroup().add((Object)ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            this.server.getChannelGroup().remove((Object)ctx.channel());
        }
    }
}

