/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.ByteBuffer;

public class ByteArrayUtil {
    protected static void checkBytesNotNull(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array was null");
        }
    }

    protected static void checkBytes(byte[] bytes, int offset, int length, int expectedLength) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        ByteBuffer.checkOffsetLength(bytes.length, offset, length);
        if (length != expectedLength) {
            throw new IllegalArgumentException("Unexpected length of byte array [expected=" + expectedLength + ", actual=" + length + "]");
        }
    }

    public static byte[] toByteArray(byte value) {
        return new byte[]{value};
    }

    public static byte[] toByteArray(short value) {
        byte[] buf = new byte[2];
        buf[1] = (byte)(value & 0xFF);
        buf[0] = (byte)(value >>> 8 & 0xFF);
        return buf;
    }

    public static byte[] toByteArray(int value) {
        byte[] buf = new byte[4];
        buf[3] = (byte)(value & 0xFF);
        buf[2] = (byte)(value >>> 8 & 0xFF);
        buf[1] = (byte)(value >>> 16 & 0xFF);
        buf[0] = (byte)(value >>> 24 & 0xFF);
        return buf;
    }

    public static byte[] toByteArray(long value) {
        byte[] buf = new byte[8];
        buf[7] = (byte)(value & 0xFFL);
        buf[6] = (byte)(value >>> 8 & 0xFFL);
        buf[5] = (byte)(value >>> 16 & 0xFFL);
        buf[4] = (byte)(value >>> 24 & 0xFFL);
        buf[3] = (byte)(value >>> 32 & 0xFFL);
        buf[2] = (byte)(value >>> 40 & 0xFFL);
        buf[1] = (byte)(value >>> 48 & 0xFFL);
        buf[0] = (byte)(value >>> 56 & 0xFFL);
        return buf;
    }

    public static byte toByte(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toByte(bytes, 0, bytes.length);
    }

    public static byte toByte(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 1);
        return bytes[offset];
    }

    public static short toUnsignedByte(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toUnsignedByte(bytes, 0, bytes.length);
    }

    public static short toUnsignedByte(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 1);
        short v = 0;
        v = (short)(v | bytes[offset] & 0xFF);
        return v;
    }

    public static short toShort(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toShort(bytes, 0, bytes.length);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 2);
        short v = 0;
        v = (short)(v | bytes[offset] & 0xFF);
        v = (short)(v << 8);
        v = (short)(v | bytes[offset + 1] & 0xFF);
        return v;
    }

    public static int toUnsignedShort(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toUnsignedShort(bytes, 0, bytes.length);
    }

    public static int toUnsignedShort(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 2);
        int v = 0;
        v |= bytes[offset] & 0xFF;
        v <<= 8;
        return v |= bytes[offset + 1] & 0xFF;
    }

    public static int toInt(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toInt(bytes, 0, bytes.length);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 4);
        int v = 0;
        v |= bytes[offset] & 0xFF;
        v <<= 8;
        v |= bytes[offset + 1] & 0xFF;
        v <<= 8;
        v |= bytes[offset + 2] & 0xFF;
        v <<= 8;
        return v |= bytes[offset + 3] & 0xFF;
    }

    public static long toUnsignedInt(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toUnsignedInt(bytes, 0, bytes.length);
    }

    public static long toUnsignedInt(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 4);
        long v = 0L;
        v |= (long)(bytes[offset] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 1] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 2] & 0xFF);
        v <<= 8;
        return v |= (long)(bytes[offset + 3] & 0xFF);
    }

    public static long toLong(byte[] bytes) {
        ByteArrayUtil.checkBytesNotNull(bytes);
        return ByteArrayUtil.toLong(bytes, 0, bytes.length);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        ByteArrayUtil.checkBytes(bytes, offset, length, 8);
        long v = 0L;
        v |= (long)(bytes[offset] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 1] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 2] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 3] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 4] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 5] & 0xFF);
        v <<= 8;
        v |= (long)(bytes[offset + 6] & 0xFF);
        v <<= 8;
        return v |= (long)(bytes[offset + 7] & 0xFF);
    }
}

