/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.pdu;

import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.ByteBufUtil;
import com.cloudhopper.smpp.util.PduUtil;
import io.netty.buffer.ByteBuf;

public class AlertNotification
extends Pdu {
    protected Address sourceAddress;
    protected Address esmeAddress;

    public AlertNotification() {
        super(258, "alert_notification", true);
    }

    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Address value) {
        this.sourceAddress = value;
    }

    public Address getEsmeAddress() {
        return this.esmeAddress;
    }

    public void setEsmeAddress(Address value) {
        this.esmeAddress = value;
    }

    @Override
    protected int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.sourceAddress);
        return bodyLength += PduUtil.calculateByteSizeOfAddress(this.esmeAddress);
    }

    @Override
    public void readBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.sourceAddress = ByteBufUtil.readAddress(buffer);
        this.esmeAddress = ByteBufUtil.readAddress(buffer);
    }

    @Override
    public void writeBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        ByteBufUtil.writeAddress(buffer, this.sourceAddress);
        ByteBufUtil.writeAddress(buffer, this.esmeAddress);
    }

    @Override
    protected void appendBodyToString(StringBuilder buffer) {
        buffer.append("( sourceAddr [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.sourceAddress));
        buffer.append("] esmeAddr [");
        buffer.append(StringUtil.toStringWithNullAsEmpty((Object)this.esmeAddress));
        buffer.append("])");
    }
}

