/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHull2D;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetBoundarySizeEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public GetBoundarySizeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof ConvexHull2D)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a ConvexHull2D", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        ConvexHull2D convexHull2D = (ConvexHull2D)value;
        return convexHull2D.createRegion().getBoundarySize();
    }
}

