/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanPartOfSpeechStopFilter;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class KoreanPartOfSpeechStopFilterFactory
extends TokenFilterFactory {
    private Set<POS.Tag> stopTags;

    public KoreanPartOfSpeechStopFilterFactory(Map<String, String> args) {
        super(args);
        Set stopTagStr = this.getSet(args, "tags");
        this.stopTags = stopTagStr == null ? KoreanPartOfSpeechStopFilter.DEFAULT_STOP_TAGS : stopTagStr.stream().map(POS::resolveTag).collect(Collectors.toSet());
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public TokenStream create(TokenStream stream) {
        return new KoreanPartOfSpeechStopFilter(stream, this.stopTags);
    }
}

