/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogRootFilterImpl;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFiltererImpl
implements VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(VcsLogFiltererImpl.class);
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final DataGetter<? extends VcsFullCommitDetails> myCommitDetailsGetter;
    @NotNull
    protected final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    protected final VcsLogIndex myIndex;

    public VcsLogFiltererImpl(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage storage2, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull DataGetter<? extends VcsFullCommitDetails> detailsGetter, @NotNull VcsLogIndex index) {
        if (providers == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(1);
        }
        if (topCommitsDetailsCache == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(2);
        }
        if (detailsGetter == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(3);
        }
        if (index == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(4);
        }
        this.myStorage = storage2;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
        this.myIndex = index;
    }

    @Override
    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        Pair<VisiblePack, CommitCountStage> hashFilterResult;
        if (dataPack == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(5);
        }
        if (sortType == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(6);
        }
        if (filters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(7);
        }
        if (commitCount == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(8);
        }
        long start2 = System.currentTimeMillis();
        VcsLogHashFilter hashFilter = (VcsLogHashFilter)filters.get(VcsLogFilterCollection.HASH_FILTER);
        if (hashFilter != null && !hashFilter.getHashes().isEmpty() && (hashFilterResult = this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType, commitCount)) != null) {
            LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for filtering by " + ((VisiblePack)hashFilterResult.getFirst()).getFilters());
            Pair<VisiblePack, CommitCountStage> pair = hashFilterResult;
            if (pair == null) {
                VcsLogFiltererImpl.$$$reportNull$$$0(9);
            }
            return pair;
        }
        filters = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(filters).without(VcsLogFilterCollection.HASH_FILTER).build();
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(dataPack.getLogProviders().keySet(), filters);
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), visibleRoots, filters);
        FilterByDetailsResult filterResult = this.filterByDetails(dataPack, filters, commitCount, visibleRoots, matchingHeads);
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, filterResult.matchingCommits);
        VisiblePack visiblePack = new VisiblePack(dataPack, visibleGraph, filterResult.canRequestMore, filters);
        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for filtering by " + filters);
        Pair pair = Pair.create((Object)visiblePack, (Object)((Object)filterResult.commitCount));
        if (pair == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    public VisibleGraph<Integer> createVisibleGraph(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @Nullable Set<Integer> matchingHeads, @Nullable Set<Integer> matchingCommits) {
        if (dataPack == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(11);
        }
        if (sortType == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(12);
        }
        if (VcsLogFiltererImpl.matchesNothing(matchingHeads) || VcsLogFiltererImpl.matchesNothing(matchingCommits)) {
            VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
            if (visibleGraph == null) {
                VcsLogFiltererImpl.$$$reportNull$$$0(13);
            }
            return visibleGraph;
        }
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, matchingCommits);
        if (visibleGraph == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(14);
        }
        return visibleGraph;
    }

    @NotNull
    private FilterByDetailsResult filterByDetails(@NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount, @NotNull Collection<VirtualFile> visibleRoots, @Nullable Set<Integer> matchingHeads) {
        List notIndexedRoots;
        List detailsFilters;
        if (dataPack == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(15);
        }
        if (filters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(16);
        }
        if (commitCount == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(17);
        }
        if (visibleRoots == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(18);
        }
        if ((detailsFilters = filters.getDetailsFilters()).isEmpty()) {
            FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(null, false, commitCount);
            if (filterByDetailsResult == null) {
                VcsLogFiltererImpl.$$$reportNull$$$0(19);
            }
            return filterByDetailsResult;
        }
        Set<Integer> filteredWidthIndex = null;
        IndexDataGetter dataGetter = this.myIndex.getDataGetter();
        if (dataGetter != null && dataGetter.canFilter(detailsFilters) && (notIndexedRoots = ContainerUtil.filter(visibleRoots, root -> !this.myIndex.isIndexed((VirtualFile)root))).size() < visibleRoots.size()) {
            filteredWidthIndex = dataGetter.filter(detailsFilters);
            if (notIndexedRoots.isEmpty()) {
                FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(filteredWidthIndex, false, commitCount);
                if (filterByDetailsResult == null) {
                    VcsLogFiltererImpl.$$$reportNull$$$0(20);
                }
                return filterByDetailsResult;
            }
            filters = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(filters).with((VcsLogFilter)new VcsLogRootFilterImpl(notIndexedRoots)).build();
            matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), notIndexedRoots, filters);
        }
        FilterByDetailsResult filteredWithVcs = this.filterWithVcs(dataPack.getPermanentGraph(), filters, detailsFilters, matchingHeads, commitCount);
        Set<Integer> filteredCommits = filteredWidthIndex == null ? filteredWithVcs.matchingCommits : (filteredWithVcs.matchingCommits == null ? filteredWidthIndex : ContainerUtil.union(filteredWidthIndex, filteredWithVcs.matchingCommits));
        FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(filteredCommits, filteredWithVcs.canRequestMore, filteredWithVcs.commitCount);
        if (filterByDetailsResult == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(21);
        }
        return filterByDetailsResult;
    }

    @NotNull
    private FilterByDetailsResult filterWithVcs(@NotNull PermanentGraph graph2, @NotNull VcsLogFilterCollection filters, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads, @NotNull CommitCountStage commitCount) {
        if (graph2 == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(22);
        }
        if (filters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(23);
        }
        if (detailsFilters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(24);
        }
        if (commitCount == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(25);
        }
        Set<Object> matchingCommits = null;
        if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.getMatchedCommitIndex(this.filterInMemory((PermanentGraph<Integer>)graph2, detailsFilters, matchingHeads))).size() < commitCount.getCount()) {
            commitCount = commitCount.next();
            matchingCommits = null;
        }
        if (matchingCommits == null) {
            try {
                matchingCommits = this.getMatchedCommitIndex(VcsLogFiltererImpl.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount()));
            }
            catch (VcsException e) {
                matchingCommits = Collections.emptySet();
                LOG.error((Throwable)e);
            }
        }
        FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(matchingCommits, matchingCommits.size() >= commitCount.getCount(), commitCount);
        if (filterByDetailsResult == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(26);
        }
        return filterByDetailsResult;
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(27);
        }
        return false;
    }

    public static <T> boolean matchesNothing(@Nullable Collection<T> matchingSet) {
        return matchingSet != null && matchingSet.isEmpty();
    }

    @Nullable
    private Pair<VisiblePack, CommitCountStage> applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType, @NotNull CommitCountStage commitCount) {
        if (dataPack == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(28);
        }
        if (hashes == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(29);
        }
        if (sortType == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(30);
        }
        if (commitCount == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(31);
        }
        HashSet hashFilterResult = ContainerUtil.newHashSet();
        for (String partOfHash : hashes) {
            if (partOfHash.length() == 40) {
                Hash hash = HashImpl.build(partOfHash);
                for (VirtualFile root : dataPack.getLogProviders().keySet()) {
                    if (!this.myStorage.containsCommit(new CommitId(hash, root))) continue;
                    hashFilterResult.add(this.myStorage.getCommitIndex(hash, root));
                }
                continue;
            }
            CommitId commitId = this.myStorage.findCommitId(new CommitIdByStringCondition(partOfHash));
            if (commitId == null) continue;
            hashFilterResult.add(this.myStorage.getCommitIndex(commitId.getHash(), commitId.getRoot()));
        }
        VcsLogTextFilter textFilter = VcsLogTextFilterImpl.createTextFilter(ContainerUtil.newArrayList(hashes), false);
        FilterByDetailsResult textFilterResult = this.filterByDetails(dataPack, new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(new VcsLogFilter[]{textFilter}).build(), commitCount, dataPack.getLogProviders().keySet(), null);
        if (hashFilterResult.isEmpty() && VcsLogFiltererImpl.matchesNothing(textFilterResult.matchingCommits)) {
            return null;
        }
        HashSet filterResult = textFilterResult.matchingCommits == null ? hashFilterResult : ContainerUtil.union((Set)hashFilterResult, textFilterResult.matchingCommits);
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, (Set)filterResult);
        VisiblePack visiblePack = new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, textFilterResult.canRequestMore, new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(new VcsLogFilter[]{new VcsLogHashFilterImpl(hashes), textFilter}).build());
        return Pair.create((Object)visiblePack, (Object)((Object)textFilterResult.commitCount));
    }

    @Nullable
    public Set<Integer> getMatchingHeads(@NotNull RefsModel refs, @NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (refs == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(32);
        }
        if (roots == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(33);
        }
        if (filters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(34);
        }
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER);
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        if (branchFilter == null && revisionFilter == null && filters.get(VcsLogFilterCollection.ROOT_FILTER) == null && filters.get(VcsLogFilterCollection.STRUCTURE_FILTER) == null) {
            return null;
        }
        if (revisionFilter != null) {
            if (branchFilter == null) {
                return this.getMatchingHeads(roots, revisionFilter);
            }
            Set<Integer> filteredByFile = this.getMatchingHeads(refs, roots);
            Set<Integer> filteredByBranch = this.getMatchingHeads((VcsLogRefs)refs, branchFilter);
            return new HashSet<Integer>(ContainerUtil.union((Collection)ContainerUtil.intersection(filteredByBranch, filteredByFile), this.getMatchingHeads(roots, revisionFilter)));
        }
        Set<Integer> filteredByFile = this.getMatchingHeads(refs, roots);
        if (branchFilter == null) {
            return filteredByFile;
        }
        Set<Integer> filteredByBranch = this.getMatchingHeads((VcsLogRefs)refs, branchFilter);
        return new HashSet<Integer>(ContainerUtil.intersection(filteredByBranch, filteredByFile));
    }

    @NotNull
    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull VcsLogBranchFilter filter) {
        if (refs == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(35);
        }
        if (filter == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(36);
        }
        Set set = ContainerUtil.map2SetNotNull((Collection)refs.getBranches(), ref -> {
            boolean acceptRef;
            if (filter == null) {
                VcsLogFiltererImpl.$$$reportNull$$$0(59);
            }
            return (acceptRef = filter.matches(ref.getName())) ? Integer.valueOf(this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot())) : null;
        });
        if (set == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    private Set<Integer> getMatchingHeads(@NotNull Collection<VirtualFile> roots, @NotNull VcsLogRevisionFilter filter) {
        if (roots == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(38);
        }
        if (filter == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(39);
        }
        Set set = ContainerUtil.map2SetNotNull((Collection)filter.getHeads(), commit -> {
            if (roots == null) {
                VcsLogFiltererImpl.$$$reportNull$$$0(58);
            }
            if (roots.contains(commit.getRoot())) {
                return this.myStorage.getCommitIndex(commit.getHash(), commit.getRoot());
            }
            return null;
        });
        if (set == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(40);
        }
        return set;
    }

    @NotNull
    private Set<Integer> getMatchingHeads(@NotNull RefsModel refs, @NotNull Collection<VirtualFile> roots) {
        if (refs == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(41);
        }
        if (roots == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(42);
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        for (Map.Entry<VirtualFile, CompressedRefs> refsForRoot : refs.getAllRefsByRoot().entrySet()) {
            if (!roots.contains(refsForRoot.getKey())) continue;
            result2.addAll(refsForRoot.getValue().getCommits());
        }
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    @NotNull
    private Collection<CommitId> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        GraphCommit commit;
        VcsCommitMetadata data;
        if (permanentGraph == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(44);
        }
        if (detailsFilters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(45);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)iterator.next()).getId())) != null) {
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result2.add(new CommitId((Hash)data.getId(), data.getRoot()));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    private boolean matchesAllFilters(@NotNull VcsCommitMetadata commit, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        boolean matchesAllDetails;
        if (commit == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(47);
        }
        if (permanentGraph == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(48);
        }
        if (detailsFilters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(49);
        }
        return (matchesAllDetails = ContainerUtil.and(detailsFilters, filter -> {
            if (commit == null) {
                VcsLogFiltererImpl.$$$reportNull$$$0(57);
            }
            return filter.matches(commit);
        })) && this.matchesAnyHead(permanentGraph, commit, matchingHeads);
    }

    private boolean matchesAnyHead(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull VcsCommitMetadata commit, @Nullable Set<Integer> matchingHeads) {
        if (permanentGraph == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(50);
        }
        if (commit == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(51);
        }
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.myStorage.getCommitIndex((Hash)commit.getId(), commit.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), matchingHeads);
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(commitIndex);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded(() -> this.myCommitDetailsGetter.getCommitDataIfAvailable(commitIndex));
    }

    @NotNull
    private static Collection<CommitId> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (providers == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(52);
        }
        if (filterCollection == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(53);
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(providers.keySet(), filterCollection);
        ArrayList commits = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
            if (!visibleRoots.contains(root) || userFilter != null && userFilter.getUsers(root).isEmpty()) continue;
            Set<FilePath> filesForRoot = VcsLogUtil.getFilteredFilesForRoot(root, filterCollection);
            VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder rootSpecificCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(filterCollection);
            rootSpecificCollection = filesForRoot.isEmpty() ? rootSpecificCollection.without(VcsLogFilterCollection.STRUCTURE_FILTER) : rootSpecificCollection.with((VcsLogFilter)new VcsLogStructureFilterImpl((Collection<FilePath>)filesForRoot));
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, rootSpecificCollection.build(), maxCount);
            commits.addAll(ContainerUtil.map((Collection)matchingCommits, commit -> new CommitId((Hash)commit.getId(), root)));
        }
        ArrayList arrayList = commits;
        if (arrayList == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    @Nullable
    private Set<Integer> getMatchedCommitIndex(@Nullable Collection<CommitId> commits) {
        if (commits == null) {
            return null;
        }
        return ContainerUtil.map2Set(commits, commitId -> this.myStorage.getCommitIndex(commitId.getHash(), commitId.getRoot()));
    }

    public static boolean areFiltersAffectedByIndexing(@NotNull VcsLogFilterCollection filters, @NotNull List<VirtualFile> roots) {
        boolean needsIndex;
        List detailsFilters;
        if (filters == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(55);
        }
        if (roots == null) {
            VcsLogFiltererImpl.$$$reportNull$$$0(56);
        }
        if ((detailsFilters = filters.getDetailsFilters()).isEmpty()) {
            return false;
        }
        Set<VirtualFile> affectedRoots = VcsLogUtil.getAllVisibleRoots(roots, filters);
        boolean bl = needsIndex = !affectedRoots.isEmpty();
        if (needsIndex) {
            LOG.debug(filters + " are affected by indexing of " + affectedRoots);
        }
        return needsIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsGetter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 6: 
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 7: 
            case 16: 
            case 23: 
            case 27: 
            case 34: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 8: 
            case 17: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitCount";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/VcsLogFiltererImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRoots";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 24: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 32: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 33: 
            case 38: 
            case 42: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 36: 
            case 39: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 44: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 47: 
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/VcsLogFiltererImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleGraph";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDetails";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "filterWithVcs";
                break;
            }
            case 37: 
            case 40: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingHeads";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInMemory";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDetailsFromTheVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 54: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleGraph";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterByDetails";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterWithVcs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canFilterEmptyPack";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "applyHashFilter";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingHeads";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "filterInMemory";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "matchesAllFilters";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "matchesAnyHead";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDetailsFromTheVcs";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "areFiltersAffectedByIndexing";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$matchesAllFilters$3";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMatchingHeads$2";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMatchingHeads$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class FilterByDetailsResult {
        @Nullable
        public final Set<Integer> matchingCommits;
        public final boolean canRequestMore;
        @NotNull
        private final CommitCountStage commitCount;

        protected FilterByDetailsResult(@Nullable Set<Integer> commits, boolean more, @NotNull CommitCountStage count) {
            if (count == null) {
                FilterByDetailsResult.$$$reportNull$$$0(0);
            }
            this.matchingCommits = commits;
            this.canRequestMore = more;
            this.commitCount = count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "count", "com/intellij/vcs/log/visible/VcsLogFiltererImpl$FilterByDetailsResult", "<init>"));
        }
    }
}

