/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.jetbrains.python.sdk.PythonSdkType;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;

public class IpnbConvertToPythonAction
extends AnAction {
    private IpnbFileEditor myFileEditor;

    public IpnbConvertToPythonAction() {
        super(PythonIcons.Python.Python);
        this.myFileEditor = null;
    }

    public IpnbConvertToPythonAction(@NotNull IpnbFileEditor fileEditor) {
        if (fileEditor == null) {
            IpnbConvertToPythonAction.$$$reportNull$$$0(0);
        }
        super("Convert to Python Script", "Convert to Python Script", PythonIcons.Python.Python);
        this.myFileEditor = null;
        this.myFileEditor = fileEditor;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            IpnbConvertToPythonAction.$$$reportNull$$$0(1);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        if (this.myFileEditor != null) {
            VirtualFile virtualFile = this.myFileEditor.getVirtualFile();
            IpnbConvertToPythonAction.convertToPythonScript(project, virtualFile);
        } else {
            DataContext context = event.getDataContext();
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            if (virtualFile == null) {
                return;
            }
            IpnbConvertToPythonAction.convertToPythonScript(project, virtualFile);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            IpnbConvertToPythonAction.$$$reportNull$$$0(2);
        }
        if (this.myFileEditor != null) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        DataContext context = e.getDataContext();
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (virtualFile != null && "ipynb".equals(virtualFile.getExtension())) {
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    private static void convertToPythonScript(@NotNull Project project, final @NotNull VirtualFile virtualFile) {
        Module module;
        if (project == null) {
            IpnbConvertToPythonAction.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            IpnbConvertToPythonAction.$$$reportNull$$$0(4);
        }
        if ((module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(virtualFile)) == null) {
            return;
        }
        Sdk sdk = PythonSdkType.findPythonSdk((Module)module);
        if (sdk == null || PythonSdkType.isInvalid((Sdk)sdk)) {
            return;
        }
        String homePath = sdk.getHomePath();
        if (homePath == null) {
            return;
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{homePath});
        IpnbConvertToPythonAction.addJupyterRunner(homePath, parameters);
        parameters.add("--to");
        parameters.add("script");
        parameters.add(virtualFile.getPath());
        String baseDir = virtualFile.getParent().getPath();
        GeneralCommandLine commandLine = new GeneralCommandLine((List)parameters).withWorkDirectory(baseDir);
        try {
            KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile.getParent()});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ipnb/editor/actions/IpnbConvertToPythonAction$1", "processTerminated"));
                }
            });
            processHandler.setShouldDestroyProcessRecursively(true);
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (project == null) {
                    IpnbConvertToPythonAction.$$$reportNull$$$0(6);
                }
                RunContentExecutor executor = new RunContentExecutor(project, (ProcessHandler)processHandler);
                executor.withActivateToolWindow(false);
                executor.run();
            }, (ModalityState)ModalityState.defaultModalityState());
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private static void addJupyterRunner(@NotNull String homePath, ArrayList<String> parameters) {
        String nbconvert;
        if (homePath == null) {
            IpnbConvertToPythonAction.$$$reportNull$$$0(5);
        }
        if ((nbconvert = PythonSdkType.getExecutablePath((String)homePath, (String)"jupyter-nbconvert")) != null) {
            parameters.add(nbconvert);
        } else {
            nbconvert = PythonSdkType.getExecutablePath((String)homePath, (String)"jupyter");
            parameters.add(nbconvert);
            parameters.add("nbconvert");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/actions/IpnbConvertToPythonAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToPythonScript";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addJupyterRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$convertToPythonScript$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

